package software.amazon.awscdk.services.codedeploy;

/**
 * A custom Deployment Configuration for an ECS Deployment Group.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * FargateService service;
 * ITargetGroup blueTargetGroup;
 * ITargetGroup greenTargetGroup;
 * IApplicationListener listener;
 * IApplicationListener testListener;
 * EcsDeploymentGroup.Builder.create(this, "BlueGreenDG")
 *         .autoRollback(AutoRollbackConfig.builder()
 *                 // CodeDeploy will automatically roll back if the 8-hour approval period times out and the deployment stops
 *                 .stoppedDeployment(true)
 *                 .build())
 *         .service(service)
 *         .blueGreenDeploymentConfig(EcsBlueGreenDeploymentConfig.builder()
 *                 // The deployment will wait for approval for up to 8 hours before stopping the deployment
 *                 .deploymentApprovalWaitTime(Duration.hours(8))
 *                 .blueTargetGroup(blueTargetGroup)
 *                 .greenTargetGroup(greenTargetGroup)
 *                 .listener(listener)
 *                 .testListener(testListener)
 *                 .build())
 *         .deploymentConfig(EcsDeploymentConfig.CANARY_10PERCENT_5MINUTES)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-22T22:42:48.987Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codedeploy.EcsDeploymentConfig")
public class EcsDeploymentConfig extends software.amazon.awscdk.services.codedeploy.BaseDeploymentConfig implements software.amazon.awscdk.services.codedeploy.IEcsDeploymentConfig {

    protected EcsDeploymentConfig(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EcsDeploymentConfig(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        ALL_AT_ONCE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codedeploy.EcsDeploymentConfig.class, "ALL_AT_ONCE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codedeploy.IEcsDeploymentConfig.class));
        CANARY_10_PERCENT_15_MINUTES = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codedeploy.EcsDeploymentConfig.class, "CANARY_10PERCENT_15MINUTES", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codedeploy.IEcsDeploymentConfig.class));
        CANARY_10_PERCENT_5_MINUTES = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codedeploy.EcsDeploymentConfig.class, "CANARY_10PERCENT_5MINUTES", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codedeploy.IEcsDeploymentConfig.class));
        LINEAR_10_PERCENT_EVERY_1_MINUTES = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codedeploy.EcsDeploymentConfig.class, "LINEAR_10PERCENT_EVERY_1MINUTES", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codedeploy.IEcsDeploymentConfig.class));
        LINEAR_10_PERCENT_EVERY_3_MINUTES = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codedeploy.EcsDeploymentConfig.class, "LINEAR_10PERCENT_EVERY_3MINUTES", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codedeploy.IEcsDeploymentConfig.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public EcsDeploymentConfig(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codedeploy.EcsDeploymentConfigProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public EcsDeploymentConfig(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Import a custom Deployment Configuration for an ECS Deployment Group defined outside the CDK.
     * <p>
     * @return a Construct representing a reference to an existing custom Deployment Configuration
     * @param scope the parent Construct for this new Construct. This parameter is required.
     * @param id the logical ID of this new Construct. This parameter is required.
     * @param ecsDeploymentConfigName the name of the referenced custom Deployment Configuration. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codedeploy.IEcsDeploymentConfig fromEcsDeploymentConfigName(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String ecsDeploymentConfigName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codedeploy.EcsDeploymentConfig.class, "fromEcsDeploymentConfigName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codedeploy.IEcsDeploymentConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(ecsDeploymentConfigName, "ecsDeploymentConfigName is required") });
    }

    /**
     * CodeDeploy predefined deployment configuration that shifts all traffic to the updated ECS task set at once.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codedeploy.IEcsDeploymentConfig ALL_AT_ONCE;

    /**
     * CodeDeploy predefined deployment configuration that shifts 10 percent of traffic in the first increment.
     * <p>
     * The remaining 90 percent is deployed 15 minutes later.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codedeploy.IEcsDeploymentConfig CANARY_10_PERCENT_15_MINUTES;

    /**
     * CodeDeploy predefined deployment configuration that shifts 10 percent of traffic in the first increment.
     * <p>
     * The remaining 90 percent is deployed five minutes later.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codedeploy.IEcsDeploymentConfig CANARY_10_PERCENT_5_MINUTES;

    /**
     * CodeDeploy predefined deployment configuration that shifts 10 percent of traffic every minute until all traffic is shifted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codedeploy.IEcsDeploymentConfig LINEAR_10_PERCENT_EVERY_1_MINUTES;

    /**
     * CodeDeploy predefined deployment configuration that shifts 10 percent of traffic every three minutes until all traffic is shifted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codedeploy.IEcsDeploymentConfig LINEAR_10_PERCENT_EVERY_3_MINUTES;

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.codedeploy.EcsDeploymentConfig}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.codedeploy.EcsDeploymentConfig> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.codedeploy.EcsDeploymentConfigProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The physical, human-readable name of the Deployment Configuration.
         * <p>
         * Default: - automatically generated name
         * <p>
         * @return {@code this}
         * @param deploymentConfigName The physical, human-readable name of the Deployment Configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentConfigName(final java.lang.String deploymentConfigName) {
            this.props().deploymentConfigName(deploymentConfigName);
            return this;
        }

        /**
         * The configuration that specifies how traffic is shifted from the 'blue' target group to the 'green' target group during a deployment.
         * <p>
         * Default: AllAtOnce
         * <p>
         * @return {@code this}
         * @param trafficRouting The configuration that specifies how traffic is shifted from the 'blue' target group to the 'green' target group during a deployment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trafficRouting(final software.amazon.awscdk.services.codedeploy.TrafficRouting trafficRouting) {
            this.props().trafficRouting(trafficRouting);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.codedeploy.EcsDeploymentConfig}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.codedeploy.EcsDeploymentConfig build() {
            return new software.amazon.awscdk.services.codedeploy.EcsDeploymentConfig(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.codedeploy.EcsDeploymentConfigProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.codedeploy.EcsDeploymentConfigProps.Builder();
            }
            return this.props;
        }
    }
}
