package software.amazon.awscdk.services.codepipeline;

/**
 * An interface representing resources generated in order to support the cross-region capabilities of CodePipeline.
 * <p>
 * You get instances of this interface from the <code>Pipeline#crossRegionSupport</code> property.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.codepipeline.*;
 * import software.amazon.awscdk.services.s3.*;
 * Bucket bucket;
 * Stack stack;
 * CrossRegionSupport crossRegionSupport = CrossRegionSupport.builder()
 *         .replicationBucket(bucket)
 *         .stack(stack)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-22T22:42:49.076Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.CrossRegionSupport")
@software.amazon.jsii.Jsii.Proxy(CrossRegionSupport.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CrossRegionSupport extends software.amazon.jsii.JsiiSerializable {

    /**
     * The replication Bucket used by CodePipeline to operate in this region.
     * <p>
     * Belongs to <code>stack</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket getReplicationBucket();

    /**
     * The Stack that has been created to house the replication Bucket required for this  region.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stack getStack();

    /**
     * @return a {@link Builder} of {@link CrossRegionSupport}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CrossRegionSupport}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CrossRegionSupport> {
        software.amazon.awscdk.services.s3.IBucket replicationBucket;
        software.amazon.awscdk.Stack stack;

        /**
         * Sets the value of {@link CrossRegionSupport#getReplicationBucket}
         * @param replicationBucket The replication Bucket used by CodePipeline to operate in this region. This parameter is required.
         *                          Belongs to <code>stack</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicationBucket(software.amazon.awscdk.services.s3.IBucket replicationBucket) {
            this.replicationBucket = replicationBucket;
            return this;
        }

        /**
         * Sets the value of {@link CrossRegionSupport#getStack}
         * @param stack The Stack that has been created to house the replication Bucket required for this  region. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stack(software.amazon.awscdk.Stack stack) {
            this.stack = stack;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CrossRegionSupport}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CrossRegionSupport build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CrossRegionSupport}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CrossRegionSupport {
        private final software.amazon.awscdk.services.s3.IBucket replicationBucket;
        private final software.amazon.awscdk.Stack stack;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.replicationBucket = software.amazon.jsii.Kernel.get(this, "replicationBucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class));
            this.stack = software.amazon.jsii.Kernel.get(this, "stack", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Stack.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.replicationBucket = java.util.Objects.requireNonNull(builder.replicationBucket, "replicationBucket is required");
            this.stack = java.util.Objects.requireNonNull(builder.stack, "stack is required");
        }

        @Override
        public final software.amazon.awscdk.services.s3.IBucket getReplicationBucket() {
            return this.replicationBucket;
        }

        @Override
        public final software.amazon.awscdk.Stack getStack() {
            return this.stack;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("replicationBucket", om.valueToTree(this.getReplicationBucket()));
            data.set("stack", om.valueToTree(this.getStack()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline.CrossRegionSupport"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CrossRegionSupport.Jsii$Proxy that = (CrossRegionSupport.Jsii$Proxy) o;

            if (!replicationBucket.equals(that.replicationBucket)) return false;
            return this.stack.equals(that.stack);
        }

        @Override
        public final int hashCode() {
            int result = this.replicationBucket.hashCode();
            result = 31 * result + (this.stack.hashCode());
            return result;
        }
    }
}
