package software.amazon.awscdk.services.codepipeline.actions;

/**
 * The type of the Jenkins Action that determines its CodePipeline Category - Build, or Test.
 * <p>
 * Note that a Jenkins provider, even if it has the same name,
 * must be separately registered for each type.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * JenkinsProvider jenkinsProvider;
 * JenkinsAction buildAction = JenkinsAction.Builder.create()
 *         .actionName("JenkinsBuild")
 *         .jenkinsProvider(jenkinsProvider)
 *         .projectName("MyProject")
 *         .type(JenkinsActionType.BUILD)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-22T22:42:49.185Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline_actions.JenkinsActionType")
public enum JenkinsActionType {
    /**
     * The Action will have the Build Category.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BUILD,
    /**
     * The Action will have the Test Category.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TEST,
}
