package software.amazon.awscdk.services.codepipeline.actions;

/**
 * StepFunctionInvokeAction that is provided by an AWS CodePipeline.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.stepfunctions.*;
 * Pipeline pipeline = new Pipeline(this, "MyPipeline");
 * Pass startState = new Pass(this, "StartState");
 * StateMachine simpleStateMachine = StateMachine.Builder.create(this, "SimpleStateMachine")
 *         .definition(startState)
 *         .build();
 * StepFunctionInvokeAction stepFunctionAction = StepFunctionInvokeAction.Builder.create()
 *         .actionName("Invoke")
 *         .stateMachine(simpleStateMachine)
 *         .stateMachineInput(StateMachineInput.literal(Map.of("IsHelloWorldExample", true)))
 *         .build();
 * pipeline.addStage(StageOptions.builder()
 *         .stageName("StepFunctions")
 *         .actions(List.of(stepFunctionAction))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-22T22:42:49.214Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline_actions.StepFunctionInvokeAction")
public class StepFunctionInvokeAction extends software.amazon.awscdk.services.codepipeline.actions.Action {

    protected StepFunctionInvokeAction(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected StepFunctionInvokeAction(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public StepFunctionInvokeAction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.actions.StepFunctionsInvokeActionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * This is a renamed version of the <code>IAction.bind</code> method.
     * <p>
     * @param _scope This parameter is required.
     * @param _stage This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.ActionConfig bound(final @org.jetbrains.annotations.NotNull software.constructs.Construct _scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.IStage _stage, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.ActionBindOptions options) {
        return software.amazon.jsii.Kernel.call(this, "bound", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.ActionConfig.class), new Object[] { java.util.Objects.requireNonNull(_scope, "_scope is required"), java.util.Objects.requireNonNull(_stage, "_stage is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.codepipeline.actions.StepFunctionInvokeAction}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.codepipeline.actions.StepFunctionInvokeAction> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.codepipeline.actions.StepFunctionsInvokeActionProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.codepipeline.actions.StepFunctionsInvokeActionProps.Builder();
        }

        /**
         * The physical, human-readable name of the Action.
         * <p>
         * Note that Action names must be unique within a single Stage.
         * <p>
         * @return {@code this}
         * @param actionName The physical, human-readable name of the Action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionName(final java.lang.String actionName) {
            this.props.actionName(actionName);
            return this;
        }

        /**
         * The runOrder property for this Action.
         * <p>
         * RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html">https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html</a>
         * @param runOrder The runOrder property for this Action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runOrder(final java.lang.Number runOrder) {
            this.props.runOrder(runOrder);
            return this;
        }

        /**
         * The name of the namespace to use for variables emitted by this action.
         * <p>
         * Default: - a name will be generated, based on the stage and action names,
         * if any of the action's variables were referenced - otherwise,
         * no namespace will be set
         * <p>
         * @return {@code this}
         * @param variablesNamespace The name of the namespace to use for variables emitted by this action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder variablesNamespace(final java.lang.String variablesNamespace) {
            this.props.variablesNamespace(variablesNamespace);
            return this;
        }

        /**
         * The Role in which context's this Action will be executing in.
         * <p>
         * The Pipeline's Role will assume this Role
         * (the required permissions for that will be granted automatically)
         * right before executing this Action.
         * This Action will be passed into your <code>IAction.bind</code>
         * method in the <code>ActionBindOptions.role</code> property.
         * <p>
         * Default: a new Role will be generated
         * <p>
         * @return {@code this}
         * @param role The Role in which context's this Action will be executing in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * The state machine to invoke.
         * <p>
         * @return {@code this}
         * @param stateMachine The state machine to invoke. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stateMachine(final software.amazon.awscdk.services.stepfunctions.IStateMachine stateMachine) {
            this.props.stateMachine(stateMachine);
            return this;
        }

        /**
         * Prefix (optional).
         * <p>
         * By default, the action execution ID is used as the state machine execution name.
         * If a prefix is provided, it is prepended to the action execution ID with a hyphen and
         * together used as the state machine execution name.
         * <p>
         * Default: - action execution ID
         * <p>
         * @return {@code this}
         * @param executionNamePrefix Prefix (optional). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionNamePrefix(final java.lang.String executionNamePrefix) {
            this.props.executionNamePrefix(executionNamePrefix);
            return this;
        }

        /**
         * The optional output Artifact of the Action.
         * <p>
         * Default: the Action will not have any outputs
         * <p>
         * @return {@code this}
         * @param output The optional output Artifact of the Action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder output(final software.amazon.awscdk.services.codepipeline.Artifact output) {
            this.props.output(output);
            return this;
        }

        /**
         * Represents the input to the StateMachine.
         * <p>
         * This includes input artifact, input type and the statemachine input.
         * <p>
         * Default: - none
         * <p>
         * @return {@code this}
         * @param stateMachineInput Represents the input to the StateMachine. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stateMachineInput(final software.amazon.awscdk.services.codepipeline.actions.StateMachineInput stateMachineInput) {
            this.props.stateMachineInput(stateMachineInput);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.codepipeline.actions.StepFunctionInvokeAction}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.codepipeline.actions.StepFunctionInvokeAction build() {
            return new software.amazon.awscdk.services.codepipeline.actions.StepFunctionInvokeAction(
                this.props.build()
            );
        }
    }
}
