package software.amazon.awscdk.services.cognito;

/**
 * The <code>AWS::Cognito::UserPoolRiskConfigurationAttachment</code> resource sets the risk configuration that is used for Amazon Cognito advanced security features.
 * <p>
 * You can specify risk configuration for a single client (with a specific <code>clientId</code> ) or for all clients (by setting the <code>clientId</code> to <code>ALL</code> ). If you specify <code>ALL</code> , the default configuration is used for every client that has had no risk configuration set previously. If you specify risk configuration for a particular client, it no longer falls back to the <code>ALL</code> configuration.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cognito.*;
 * CfnUserPoolRiskConfigurationAttachment cfnUserPoolRiskConfigurationAttachment = CfnUserPoolRiskConfigurationAttachment.Builder.create(this, "MyCfnUserPoolRiskConfigurationAttachment")
 *         .clientId("clientId")
 *         .userPoolId("userPoolId")
 *         // the properties below are optional
 *         .accountTakeoverRiskConfiguration(AccountTakeoverRiskConfigurationTypeProperty.builder()
 *                 .actions(AccountTakeoverActionsTypeProperty.builder()
 *                         .highAction(AccountTakeoverActionTypeProperty.builder()
 *                                 .eventAction("eventAction")
 *                                 .notify(false)
 *                                 .build())
 *                         .lowAction(AccountTakeoverActionTypeProperty.builder()
 *                                 .eventAction("eventAction")
 *                                 .notify(false)
 *                                 .build())
 *                         .mediumAction(AccountTakeoverActionTypeProperty.builder()
 *                                 .eventAction("eventAction")
 *                                 .notify(false)
 *                                 .build())
 *                         .build())
 *                 // the properties below are optional
 *                 .notifyConfiguration(NotifyConfigurationTypeProperty.builder()
 *                         .sourceArn("sourceArn")
 *                         // the properties below are optional
 *                         .blockEmail(NotifyEmailTypeProperty.builder()
 *                                 .subject("subject")
 *                                 // the properties below are optional
 *                                 .htmlBody("htmlBody")
 *                                 .textBody("textBody")
 *                                 .build())
 *                         .from("from")
 *                         .mfaEmail(NotifyEmailTypeProperty.builder()
 *                                 .subject("subject")
 *                                 // the properties below are optional
 *                                 .htmlBody("htmlBody")
 *                                 .textBody("textBody")
 *                                 .build())
 *                         .noActionEmail(NotifyEmailTypeProperty.builder()
 *                                 .subject("subject")
 *                                 // the properties below are optional
 *                                 .htmlBody("htmlBody")
 *                                 .textBody("textBody")
 *                                 .build())
 *                         .replyTo("replyTo")
 *                         .build())
 *                 .build())
 *         .compromisedCredentialsRiskConfiguration(CompromisedCredentialsRiskConfigurationTypeProperty.builder()
 *                 .actions(CompromisedCredentialsActionsTypeProperty.builder()
 *                         .eventAction("eventAction")
 *                         .build())
 *                 // the properties below are optional
 *                 .eventFilter(List.of("eventFilter"))
 *                 .build())
 *         .riskExceptionConfiguration(RiskExceptionConfigurationTypeProperty.builder()
 *                 .blockedIpRangeList(List.of("blockedIpRangeList"))
 *                 .skippedIpRangeList(List.of("skippedIpRangeList"))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-22T22:42:49.327Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.CfnUserPoolRiskConfigurationAttachment")
public class CfnUserPoolRiskConfigurationAttachment extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnUserPoolRiskConfigurationAttachment(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnUserPoolRiskConfigurationAttachment(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.CfnUserPoolRiskConfigurationAttachment.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnUserPoolRiskConfigurationAttachment(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.CfnUserPoolRiskConfigurationAttachmentProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The app client ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getClientId() {
        return software.amazon.jsii.Kernel.get(this, "clientId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The app client ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setClientId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "clientId", java.util.Objects.requireNonNull(value, "clientId is required"));
    }

    /**
     * The user pool ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getUserPoolId() {
        return software.amazon.jsii.Kernel.get(this, "userPoolId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The user pool ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUserPoolId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "userPoolId", java.util.Objects.requireNonNull(value, "userPoolId is required"));
    }

    /**
     * The account takeover risk configuration object, including the <code>NotifyConfiguration</code> object and <code>Actions</code> to take if there is an account takeover.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAccountTakeoverRiskConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "accountTakeoverRiskConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The account takeover risk configuration object, including the <code>NotifyConfiguration</code> object and <code>Actions</code> to take if there is an account takeover.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAccountTakeoverRiskConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "accountTakeoverRiskConfiguration", value);
    }

    /**
     * The account takeover risk configuration object, including the <code>NotifyConfiguration</code> object and <code>Actions</code> to take if there is an account takeover.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAccountTakeoverRiskConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.CfnUserPoolRiskConfigurationAttachment.AccountTakeoverRiskConfigurationTypeProperty value) {
        software.amazon.jsii.Kernel.set(this, "accountTakeoverRiskConfiguration", value);
    }

    /**
     * The compromised credentials risk configuration object, including the <code>EventFilter</code> and the <code>EventAction</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCompromisedCredentialsRiskConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "compromisedCredentialsRiskConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The compromised credentials risk configuration object, including the <code>EventFilter</code> and the <code>EventAction</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCompromisedCredentialsRiskConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "compromisedCredentialsRiskConfiguration", value);
    }

    /**
     * The compromised credentials risk configuration object, including the <code>EventFilter</code> and the <code>EventAction</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCompromisedCredentialsRiskConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.CfnUserPoolRiskConfigurationAttachment.CompromisedCredentialsRiskConfigurationTypeProperty value) {
        software.amazon.jsii.Kernel.set(this, "compromisedCredentialsRiskConfiguration", value);
    }

    /**
     * The configuration to override the risk decision.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRiskExceptionConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "riskExceptionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration to override the risk decision.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRiskExceptionConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "riskExceptionConfiguration", value);
    }

    /**
     * The configuration to override the risk decision.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRiskExceptionConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.CfnUserPoolRiskConfigurationAttachment.RiskExceptionConfigurationTypeProperty value) {
        software.amazon.jsii.Kernel.set(this, "riskExceptionConfiguration", value);
    }
    /**
     * Account takeover action type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cognito.*;
     * AccountTakeoverActionTypeProperty accountTakeoverActionTypeProperty = AccountTakeoverActionTypeProperty.builder()
     *         .eventAction("eventAction")
     *         .notify(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-accounttakeoveractiontype.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-accounttakeoveractiontype.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.CfnUserPoolRiskConfigurationAttachment.AccountTakeoverActionTypeProperty")
    @software.amazon.jsii.Jsii.Proxy(AccountTakeoverActionTypeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AccountTakeoverActionTypeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The action to take in response to the account takeover action. Valid values are as follows:.
         * <p>
         * <ul>
         * <li><code>BLOCK</code> Choosing this action will block the request.</li>
         * <li><code>MFA_IF_CONFIGURED</code> Present an MFA challenge if user has configured it, else allow the request.</li>
         * <li><code>MFA_REQUIRED</code> Present an MFA challenge if user has configured it, else block the request.</li>
         * <li><code>NO_ACTION</code> Allow the user to sign in.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-accounttakeoveractiontype.html#cfn-cognito-userpoolriskconfigurationattachment-accounttakeoveractiontype-eventaction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-accounttakeoveractiontype.html#cfn-cognito-userpoolriskconfigurationattachment-accounttakeoveractiontype-eventaction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEventAction();

        /**
         * Flag specifying whether to send a notification.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-accounttakeoveractiontype.html#cfn-cognito-userpoolriskconfigurationattachment-accounttakeoveractiontype-notify">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-accounttakeoveractiontype.html#cfn-cognito-userpoolriskconfigurationattachment-accounttakeoveractiontype-notify</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getNotify();

        /**
         * @return a {@link Builder} of {@link AccountTakeoverActionTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AccountTakeoverActionTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AccountTakeoverActionTypeProperty> {
            java.lang.String eventAction;
            java.lang.Object notify;

            /**
             * Sets the value of {@link AccountTakeoverActionTypeProperty#getEventAction}
             * @param eventAction The action to take in response to the account takeover action. Valid values are as follows:. This parameter is required.
             *                    <ul>
             *                    <li><code>BLOCK</code> Choosing this action will block the request.</li>
             *                    <li><code>MFA_IF_CONFIGURED</code> Present an MFA challenge if user has configured it, else allow the request.</li>
             *                    <li><code>MFA_REQUIRED</code> Present an MFA challenge if user has configured it, else block the request.</li>
             *                    <li><code>NO_ACTION</code> Allow the user to sign in.</li>
             *                    </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventAction(java.lang.String eventAction) {
                this.eventAction = eventAction;
                return this;
            }

            /**
             * Sets the value of {@link AccountTakeoverActionTypeProperty#getNotify}
             * @param notify Flag specifying whether to send a notification. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder notify(java.lang.Boolean notify) {
                this.notify = notify;
                return this;
            }

            /**
             * Sets the value of {@link AccountTakeoverActionTypeProperty#getNotify}
             * @param notify Flag specifying whether to send a notification. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder notify(software.amazon.awscdk.IResolvable notify) {
                this.notify = notify;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AccountTakeoverActionTypeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AccountTakeoverActionTypeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AccountTakeoverActionTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AccountTakeoverActionTypeProperty {
            private final java.lang.String eventAction;
            private final java.lang.Object notify;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.eventAction = software.amazon.jsii.Kernel.get(this, "eventAction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.notify = software.amazon.jsii.Kernel.get(this, "notify", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.eventAction = java.util.Objects.requireNonNull(builder.eventAction, "eventAction is required");
                this.notify = java.util.Objects.requireNonNull(builder.notify, "notify is required");
            }

            @Override
            public final java.lang.String getEventAction() {
                return this.eventAction;
            }

            @Override
            public final java.lang.Object getNotify() {
                return this.notify;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("eventAction", om.valueToTree(this.getEventAction()));
                data.set("notify", om.valueToTree(this.getNotify()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito.CfnUserPoolRiskConfigurationAttachment.AccountTakeoverActionTypeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AccountTakeoverActionTypeProperty.Jsii$Proxy that = (AccountTakeoverActionTypeProperty.Jsii$Proxy) o;

                if (!eventAction.equals(that.eventAction)) return false;
                return this.notify.equals(that.notify);
            }

            @Override
            public final int hashCode() {
                int result = this.eventAction.hashCode();
                result = 31 * result + (this.notify.hashCode());
                return result;
            }
        }
    }
    /**
     * Account takeover actions type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cognito.*;
     * AccountTakeoverActionsTypeProperty accountTakeoverActionsTypeProperty = AccountTakeoverActionsTypeProperty.builder()
     *         .highAction(AccountTakeoverActionTypeProperty.builder()
     *                 .eventAction("eventAction")
     *                 .notify(false)
     *                 .build())
     *         .lowAction(AccountTakeoverActionTypeProperty.builder()
     *                 .eventAction("eventAction")
     *                 .notify(false)
     *                 .build())
     *         .mediumAction(AccountTakeoverActionTypeProperty.builder()
     *                 .eventAction("eventAction")
     *                 .notify(false)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-accounttakeoveractionstype.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-accounttakeoveractionstype.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.CfnUserPoolRiskConfigurationAttachment.AccountTakeoverActionsTypeProperty")
    @software.amazon.jsii.Jsii.Proxy(AccountTakeoverActionsTypeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AccountTakeoverActionsTypeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Action to take for a high risk.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-accounttakeoveractionstype.html#cfn-cognito-userpoolriskconfigurationattachment-accounttakeoveractionstype-highaction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-accounttakeoveractionstype.html#cfn-cognito-userpoolriskconfigurationattachment-accounttakeoveractionstype-highaction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHighAction() {
            return null;
        }

        /**
         * Action to take for a low risk.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-accounttakeoveractionstype.html#cfn-cognito-userpoolriskconfigurationattachment-accounttakeoveractionstype-lowaction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-accounttakeoveractionstype.html#cfn-cognito-userpoolriskconfigurationattachment-accounttakeoveractionstype-lowaction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLowAction() {
            return null;
        }

        /**
         * Action to take for a medium risk.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-accounttakeoveractionstype.html#cfn-cognito-userpoolriskconfigurationattachment-accounttakeoveractionstype-mediumaction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-accounttakeoveractionstype.html#cfn-cognito-userpoolriskconfigurationattachment-accounttakeoveractionstype-mediumaction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMediumAction() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AccountTakeoverActionsTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AccountTakeoverActionsTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AccountTakeoverActionsTypeProperty> {
            java.lang.Object highAction;
            java.lang.Object lowAction;
            java.lang.Object mediumAction;

            /**
             * Sets the value of {@link AccountTakeoverActionsTypeProperty#getHighAction}
             * @param highAction Action to take for a high risk.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder highAction(software.amazon.awscdk.IResolvable highAction) {
                this.highAction = highAction;
                return this;
            }

            /**
             * Sets the value of {@link AccountTakeoverActionsTypeProperty#getHighAction}
             * @param highAction Action to take for a high risk.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder highAction(software.amazon.awscdk.services.cognito.CfnUserPoolRiskConfigurationAttachment.AccountTakeoverActionTypeProperty highAction) {
                this.highAction = highAction;
                return this;
            }

            /**
             * Sets the value of {@link AccountTakeoverActionsTypeProperty#getLowAction}
             * @param lowAction Action to take for a low risk.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lowAction(software.amazon.awscdk.IResolvable lowAction) {
                this.lowAction = lowAction;
                return this;
            }

            /**
             * Sets the value of {@link AccountTakeoverActionsTypeProperty#getLowAction}
             * @param lowAction Action to take for a low risk.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lowAction(software.amazon.awscdk.services.cognito.CfnUserPoolRiskConfigurationAttachment.AccountTakeoverActionTypeProperty lowAction) {
                this.lowAction = lowAction;
                return this;
            }

            /**
             * Sets the value of {@link AccountTakeoverActionsTypeProperty#getMediumAction}
             * @param mediumAction Action to take for a medium risk.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mediumAction(software.amazon.awscdk.IResolvable mediumAction) {
                this.mediumAction = mediumAction;
                return this;
            }

            /**
             * Sets the value of {@link AccountTakeoverActionsTypeProperty#getMediumAction}
             * @param mediumAction Action to take for a medium risk.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mediumAction(software.amazon.awscdk.services.cognito.CfnUserPoolRiskConfigurationAttachment.AccountTakeoverActionTypeProperty mediumAction) {
                this.mediumAction = mediumAction;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AccountTakeoverActionsTypeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AccountTakeoverActionsTypeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AccountTakeoverActionsTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AccountTakeoverActionsTypeProperty {
            private final java.lang.Object highAction;
            private final java.lang.Object lowAction;
            private final java.lang.Object mediumAction;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.highAction = software.amazon.jsii.Kernel.get(this, "highAction", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.lowAction = software.amazon.jsii.Kernel.get(this, "lowAction", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.mediumAction = software.amazon.jsii.Kernel.get(this, "mediumAction", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.highAction = builder.highAction;
                this.lowAction = builder.lowAction;
                this.mediumAction = builder.mediumAction;
            }

            @Override
            public final java.lang.Object getHighAction() {
                return this.highAction;
            }

            @Override
            public final java.lang.Object getLowAction() {
                return this.lowAction;
            }

            @Override
            public final java.lang.Object getMediumAction() {
                return this.mediumAction;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getHighAction() != null) {
                    data.set("highAction", om.valueToTree(this.getHighAction()));
                }
                if (this.getLowAction() != null) {
                    data.set("lowAction", om.valueToTree(this.getLowAction()));
                }
                if (this.getMediumAction() != null) {
                    data.set("mediumAction", om.valueToTree(this.getMediumAction()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito.CfnUserPoolRiskConfigurationAttachment.AccountTakeoverActionsTypeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AccountTakeoverActionsTypeProperty.Jsii$Proxy that = (AccountTakeoverActionsTypeProperty.Jsii$Proxy) o;

                if (this.highAction != null ? !this.highAction.equals(that.highAction) : that.highAction != null) return false;
                if (this.lowAction != null ? !this.lowAction.equals(that.lowAction) : that.lowAction != null) return false;
                return this.mediumAction != null ? this.mediumAction.equals(that.mediumAction) : that.mediumAction == null;
            }

            @Override
            public final int hashCode() {
                int result = this.highAction != null ? this.highAction.hashCode() : 0;
                result = 31 * result + (this.lowAction != null ? this.lowAction.hashCode() : 0);
                result = 31 * result + (this.mediumAction != null ? this.mediumAction.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration for mitigation actions and notification for different levels of risk detected for a potential account takeover.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cognito.*;
     * AccountTakeoverRiskConfigurationTypeProperty accountTakeoverRiskConfigurationTypeProperty = AccountTakeoverRiskConfigurationTypeProperty.builder()
     *         .actions(AccountTakeoverActionsTypeProperty.builder()
     *                 .highAction(AccountTakeoverActionTypeProperty.builder()
     *                         .eventAction("eventAction")
     *                         .notify(false)
     *                         .build())
     *                 .lowAction(AccountTakeoverActionTypeProperty.builder()
     *                         .eventAction("eventAction")
     *                         .notify(false)
     *                         .build())
     *                 .mediumAction(AccountTakeoverActionTypeProperty.builder()
     *                         .eventAction("eventAction")
     *                         .notify(false)
     *                         .build())
     *                 .build())
     *         // the properties below are optional
     *         .notifyConfiguration(NotifyConfigurationTypeProperty.builder()
     *                 .sourceArn("sourceArn")
     *                 // the properties below are optional
     *                 .blockEmail(NotifyEmailTypeProperty.builder()
     *                         .subject("subject")
     *                         // the properties below are optional
     *                         .htmlBody("htmlBody")
     *                         .textBody("textBody")
     *                         .build())
     *                 .from("from")
     *                 .mfaEmail(NotifyEmailTypeProperty.builder()
     *                         .subject("subject")
     *                         // the properties below are optional
     *                         .htmlBody("htmlBody")
     *                         .textBody("textBody")
     *                         .build())
     *                 .noActionEmail(NotifyEmailTypeProperty.builder()
     *                         .subject("subject")
     *                         // the properties below are optional
     *                         .htmlBody("htmlBody")
     *                         .textBody("textBody")
     *                         .build())
     *                 .replyTo("replyTo")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-accounttakeoverriskconfigurationtype.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-accounttakeoverriskconfigurationtype.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.CfnUserPoolRiskConfigurationAttachment.AccountTakeoverRiskConfigurationTypeProperty")
    @software.amazon.jsii.Jsii.Proxy(AccountTakeoverRiskConfigurationTypeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AccountTakeoverRiskConfigurationTypeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Account takeover risk configuration actions.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-accounttakeoverriskconfigurationtype.html#cfn-cognito-userpoolriskconfigurationattachment-accounttakeoverriskconfigurationtype-actions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-accounttakeoverriskconfigurationtype.html#cfn-cognito-userpoolriskconfigurationattachment-accounttakeoverriskconfigurationtype-actions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getActions();

        /**
         * The notify configuration used to construct email notifications.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-accounttakeoverriskconfigurationtype.html#cfn-cognito-userpoolriskconfigurationattachment-accounttakeoverriskconfigurationtype-notifyconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-accounttakeoverriskconfigurationtype.html#cfn-cognito-userpoolriskconfigurationattachment-accounttakeoverriskconfigurationtype-notifyconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNotifyConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AccountTakeoverRiskConfigurationTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AccountTakeoverRiskConfigurationTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AccountTakeoverRiskConfigurationTypeProperty> {
            java.lang.Object actions;
            java.lang.Object notifyConfiguration;

            /**
             * Sets the value of {@link AccountTakeoverRiskConfigurationTypeProperty#getActions}
             * @param actions Account takeover risk configuration actions. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actions(software.amazon.awscdk.IResolvable actions) {
                this.actions = actions;
                return this;
            }

            /**
             * Sets the value of {@link AccountTakeoverRiskConfigurationTypeProperty#getActions}
             * @param actions Account takeover risk configuration actions. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actions(software.amazon.awscdk.services.cognito.CfnUserPoolRiskConfigurationAttachment.AccountTakeoverActionsTypeProperty actions) {
                this.actions = actions;
                return this;
            }

            /**
             * Sets the value of {@link AccountTakeoverRiskConfigurationTypeProperty#getNotifyConfiguration}
             * @param notifyConfiguration The notify configuration used to construct email notifications.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder notifyConfiguration(software.amazon.awscdk.IResolvable notifyConfiguration) {
                this.notifyConfiguration = notifyConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link AccountTakeoverRiskConfigurationTypeProperty#getNotifyConfiguration}
             * @param notifyConfiguration The notify configuration used to construct email notifications.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder notifyConfiguration(software.amazon.awscdk.services.cognito.CfnUserPoolRiskConfigurationAttachment.NotifyConfigurationTypeProperty notifyConfiguration) {
                this.notifyConfiguration = notifyConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AccountTakeoverRiskConfigurationTypeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AccountTakeoverRiskConfigurationTypeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AccountTakeoverRiskConfigurationTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AccountTakeoverRiskConfigurationTypeProperty {
            private final java.lang.Object actions;
            private final java.lang.Object notifyConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.actions = software.amazon.jsii.Kernel.get(this, "actions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.notifyConfiguration = software.amazon.jsii.Kernel.get(this, "notifyConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.actions = java.util.Objects.requireNonNull(builder.actions, "actions is required");
                this.notifyConfiguration = builder.notifyConfiguration;
            }

            @Override
            public final java.lang.Object getActions() {
                return this.actions;
            }

            @Override
            public final java.lang.Object getNotifyConfiguration() {
                return this.notifyConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("actions", om.valueToTree(this.getActions()));
                if (this.getNotifyConfiguration() != null) {
                    data.set("notifyConfiguration", om.valueToTree(this.getNotifyConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito.CfnUserPoolRiskConfigurationAttachment.AccountTakeoverRiskConfigurationTypeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AccountTakeoverRiskConfigurationTypeProperty.Jsii$Proxy that = (AccountTakeoverRiskConfigurationTypeProperty.Jsii$Proxy) o;

                if (!actions.equals(that.actions)) return false;
                return this.notifyConfiguration != null ? this.notifyConfiguration.equals(that.notifyConfiguration) : that.notifyConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.actions.hashCode();
                result = 31 * result + (this.notifyConfiguration != null ? this.notifyConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The compromised credentials actions type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cognito.*;
     * CompromisedCredentialsActionsTypeProperty compromisedCredentialsActionsTypeProperty = CompromisedCredentialsActionsTypeProperty.builder()
     *         .eventAction("eventAction")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-compromisedcredentialsactionstype.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-compromisedcredentialsactionstype.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.CfnUserPoolRiskConfigurationAttachment.CompromisedCredentialsActionsTypeProperty")
    @software.amazon.jsii.Jsii.Proxy(CompromisedCredentialsActionsTypeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CompromisedCredentialsActionsTypeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The event action.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-compromisedcredentialsactionstype.html#cfn-cognito-userpoolriskconfigurationattachment-compromisedcredentialsactionstype-eventaction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-compromisedcredentialsactionstype.html#cfn-cognito-userpoolriskconfigurationattachment-compromisedcredentialsactionstype-eventaction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEventAction();

        /**
         * @return a {@link Builder} of {@link CompromisedCredentialsActionsTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CompromisedCredentialsActionsTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CompromisedCredentialsActionsTypeProperty> {
            java.lang.String eventAction;

            /**
             * Sets the value of {@link CompromisedCredentialsActionsTypeProperty#getEventAction}
             * @param eventAction The event action. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventAction(java.lang.String eventAction) {
                this.eventAction = eventAction;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CompromisedCredentialsActionsTypeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CompromisedCredentialsActionsTypeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CompromisedCredentialsActionsTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CompromisedCredentialsActionsTypeProperty {
            private final java.lang.String eventAction;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.eventAction = software.amazon.jsii.Kernel.get(this, "eventAction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.eventAction = java.util.Objects.requireNonNull(builder.eventAction, "eventAction is required");
            }

            @Override
            public final java.lang.String getEventAction() {
                return this.eventAction;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("eventAction", om.valueToTree(this.getEventAction()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito.CfnUserPoolRiskConfigurationAttachment.CompromisedCredentialsActionsTypeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CompromisedCredentialsActionsTypeProperty.Jsii$Proxy that = (CompromisedCredentialsActionsTypeProperty.Jsii$Proxy) o;

                return this.eventAction.equals(that.eventAction);
            }

            @Override
            public final int hashCode() {
                int result = this.eventAction.hashCode();
                return result;
            }
        }
    }
    /**
     * The compromised credentials risk configuration type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cognito.*;
     * CompromisedCredentialsRiskConfigurationTypeProperty compromisedCredentialsRiskConfigurationTypeProperty = CompromisedCredentialsRiskConfigurationTypeProperty.builder()
     *         .actions(CompromisedCredentialsActionsTypeProperty.builder()
     *                 .eventAction("eventAction")
     *                 .build())
     *         // the properties below are optional
     *         .eventFilter(List.of("eventFilter"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-compromisedcredentialsriskconfigurationtype.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-compromisedcredentialsriskconfigurationtype.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.CfnUserPoolRiskConfigurationAttachment.CompromisedCredentialsRiskConfigurationTypeProperty")
    @software.amazon.jsii.Jsii.Proxy(CompromisedCredentialsRiskConfigurationTypeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CompromisedCredentialsRiskConfigurationTypeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The compromised credentials risk configuration actions.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-compromisedcredentialsriskconfigurationtype.html#cfn-cognito-userpoolriskconfigurationattachment-compromisedcredentialsriskconfigurationtype-actions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-compromisedcredentialsriskconfigurationtype.html#cfn-cognito-userpoolriskconfigurationattachment-compromisedcredentialsriskconfigurationtype-actions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getActions();

        /**
         * Perform the action for these events.
         * <p>
         * The default is to perform all events if no event filter is specified.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-compromisedcredentialsriskconfigurationtype.html#cfn-cognito-userpoolriskconfigurationattachment-compromisedcredentialsriskconfigurationtype-eventfilter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-compromisedcredentialsriskconfigurationtype.html#cfn-cognito-userpoolriskconfigurationattachment-compromisedcredentialsriskconfigurationtype-eventfilter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEventFilter() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CompromisedCredentialsRiskConfigurationTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CompromisedCredentialsRiskConfigurationTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CompromisedCredentialsRiskConfigurationTypeProperty> {
            java.lang.Object actions;
            java.util.List<java.lang.String> eventFilter;

            /**
             * Sets the value of {@link CompromisedCredentialsRiskConfigurationTypeProperty#getActions}
             * @param actions The compromised credentials risk configuration actions. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actions(software.amazon.awscdk.IResolvable actions) {
                this.actions = actions;
                return this;
            }

            /**
             * Sets the value of {@link CompromisedCredentialsRiskConfigurationTypeProperty#getActions}
             * @param actions The compromised credentials risk configuration actions. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actions(software.amazon.awscdk.services.cognito.CfnUserPoolRiskConfigurationAttachment.CompromisedCredentialsActionsTypeProperty actions) {
                this.actions = actions;
                return this;
            }

            /**
             * Sets the value of {@link CompromisedCredentialsRiskConfigurationTypeProperty#getEventFilter}
             * @param eventFilter Perform the action for these events.
             *                    The default is to perform all events if no event filter is specified.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventFilter(java.util.List<java.lang.String> eventFilter) {
                this.eventFilter = eventFilter;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CompromisedCredentialsRiskConfigurationTypeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CompromisedCredentialsRiskConfigurationTypeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CompromisedCredentialsRiskConfigurationTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CompromisedCredentialsRiskConfigurationTypeProperty {
            private final java.lang.Object actions;
            private final java.util.List<java.lang.String> eventFilter;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.actions = software.amazon.jsii.Kernel.get(this, "actions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.eventFilter = software.amazon.jsii.Kernel.get(this, "eventFilter", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.actions = java.util.Objects.requireNonNull(builder.actions, "actions is required");
                this.eventFilter = builder.eventFilter;
            }

            @Override
            public final java.lang.Object getActions() {
                return this.actions;
            }

            @Override
            public final java.util.List<java.lang.String> getEventFilter() {
                return this.eventFilter;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("actions", om.valueToTree(this.getActions()));
                if (this.getEventFilter() != null) {
                    data.set("eventFilter", om.valueToTree(this.getEventFilter()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito.CfnUserPoolRiskConfigurationAttachment.CompromisedCredentialsRiskConfigurationTypeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CompromisedCredentialsRiskConfigurationTypeProperty.Jsii$Proxy that = (CompromisedCredentialsRiskConfigurationTypeProperty.Jsii$Proxy) o;

                if (!actions.equals(that.actions)) return false;
                return this.eventFilter != null ? this.eventFilter.equals(that.eventFilter) : that.eventFilter == null;
            }

            @Override
            public final int hashCode() {
                int result = this.actions.hashCode();
                result = 31 * result + (this.eventFilter != null ? this.eventFilter.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The notify configuration type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cognito.*;
     * NotifyConfigurationTypeProperty notifyConfigurationTypeProperty = NotifyConfigurationTypeProperty.builder()
     *         .sourceArn("sourceArn")
     *         // the properties below are optional
     *         .blockEmail(NotifyEmailTypeProperty.builder()
     *                 .subject("subject")
     *                 // the properties below are optional
     *                 .htmlBody("htmlBody")
     *                 .textBody("textBody")
     *                 .build())
     *         .from("from")
     *         .mfaEmail(NotifyEmailTypeProperty.builder()
     *                 .subject("subject")
     *                 // the properties below are optional
     *                 .htmlBody("htmlBody")
     *                 .textBody("textBody")
     *                 .build())
     *         .noActionEmail(NotifyEmailTypeProperty.builder()
     *                 .subject("subject")
     *                 // the properties below are optional
     *                 .htmlBody("htmlBody")
     *                 .textBody("textBody")
     *                 .build())
     *         .replyTo("replyTo")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-notifyconfigurationtype.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-notifyconfigurationtype.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.CfnUserPoolRiskConfigurationAttachment.NotifyConfigurationTypeProperty")
    @software.amazon.jsii.Jsii.Proxy(NotifyConfigurationTypeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NotifyConfigurationTypeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the identity that is associated with the sending authorization policy.
         * <p>
         * This identity permits Amazon Cognito to send for the email address specified in the <code>From</code> parameter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-notifyconfigurationtype.html#cfn-cognito-userpoolriskconfigurationattachment-notifyconfigurationtype-sourcearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-notifyconfigurationtype.html#cfn-cognito-userpoolriskconfigurationattachment-notifyconfigurationtype-sourcearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSourceArn();

        /**
         * Email template used when a detected risk event is blocked.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-notifyconfigurationtype.html#cfn-cognito-userpoolriskconfigurationattachment-notifyconfigurationtype-blockemail">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-notifyconfigurationtype.html#cfn-cognito-userpoolriskconfigurationattachment-notifyconfigurationtype-blockemail</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBlockEmail() {
            return null;
        }

        /**
         * The email address that is sending the email.
         * <p>
         * The address must be either individually verified with Amazon Simple Email Service, or from a domain that has been verified with Amazon SES.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-notifyconfigurationtype.html#cfn-cognito-userpoolriskconfigurationattachment-notifyconfigurationtype-from">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-notifyconfigurationtype.html#cfn-cognito-userpoolriskconfigurationattachment-notifyconfigurationtype-from</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFrom() {
            return null;
        }

        /**
         * The multi-factor authentication (MFA) email template used when MFA is challenged as part of a detected risk.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-notifyconfigurationtype.html#cfn-cognito-userpoolriskconfigurationattachment-notifyconfigurationtype-mfaemail">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-notifyconfigurationtype.html#cfn-cognito-userpoolriskconfigurationattachment-notifyconfigurationtype-mfaemail</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMfaEmail() {
            return null;
        }

        /**
         * The email template used when a detected risk event is allowed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-notifyconfigurationtype.html#cfn-cognito-userpoolriskconfigurationattachment-notifyconfigurationtype-noactionemail">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-notifyconfigurationtype.html#cfn-cognito-userpoolriskconfigurationattachment-notifyconfigurationtype-noactionemail</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNoActionEmail() {
            return null;
        }

        /**
         * The destination to which the receiver of an email should reply to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-notifyconfigurationtype.html#cfn-cognito-userpoolriskconfigurationattachment-notifyconfigurationtype-replyto">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-notifyconfigurationtype.html#cfn-cognito-userpoolriskconfigurationattachment-notifyconfigurationtype-replyto</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getReplyTo() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NotifyConfigurationTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NotifyConfigurationTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NotifyConfigurationTypeProperty> {
            java.lang.String sourceArn;
            java.lang.Object blockEmail;
            java.lang.String from;
            java.lang.Object mfaEmail;
            java.lang.Object noActionEmail;
            java.lang.String replyTo;

            /**
             * Sets the value of {@link NotifyConfigurationTypeProperty#getSourceArn}
             * @param sourceArn The Amazon Resource Name (ARN) of the identity that is associated with the sending authorization policy. This parameter is required.
             *                  This identity permits Amazon Cognito to send for the email address specified in the <code>From</code> parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceArn(java.lang.String sourceArn) {
                this.sourceArn = sourceArn;
                return this;
            }

            /**
             * Sets the value of {@link NotifyConfigurationTypeProperty#getBlockEmail}
             * @param blockEmail Email template used when a detected risk event is blocked.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blockEmail(software.amazon.awscdk.IResolvable blockEmail) {
                this.blockEmail = blockEmail;
                return this;
            }

            /**
             * Sets the value of {@link NotifyConfigurationTypeProperty#getBlockEmail}
             * @param blockEmail Email template used when a detected risk event is blocked.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blockEmail(software.amazon.awscdk.services.cognito.CfnUserPoolRiskConfigurationAttachment.NotifyEmailTypeProperty blockEmail) {
                this.blockEmail = blockEmail;
                return this;
            }

            /**
             * Sets the value of {@link NotifyConfigurationTypeProperty#getFrom}
             * @param from The email address that is sending the email.
             *             The address must be either individually verified with Amazon Simple Email Service, or from a domain that has been verified with Amazon SES.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder from(java.lang.String from) {
                this.from = from;
                return this;
            }

            /**
             * Sets the value of {@link NotifyConfigurationTypeProperty#getMfaEmail}
             * @param mfaEmail The multi-factor authentication (MFA) email template used when MFA is challenged as part of a detected risk.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mfaEmail(software.amazon.awscdk.IResolvable mfaEmail) {
                this.mfaEmail = mfaEmail;
                return this;
            }

            /**
             * Sets the value of {@link NotifyConfigurationTypeProperty#getMfaEmail}
             * @param mfaEmail The multi-factor authentication (MFA) email template used when MFA is challenged as part of a detected risk.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mfaEmail(software.amazon.awscdk.services.cognito.CfnUserPoolRiskConfigurationAttachment.NotifyEmailTypeProperty mfaEmail) {
                this.mfaEmail = mfaEmail;
                return this;
            }

            /**
             * Sets the value of {@link NotifyConfigurationTypeProperty#getNoActionEmail}
             * @param noActionEmail The email template used when a detected risk event is allowed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder noActionEmail(software.amazon.awscdk.IResolvable noActionEmail) {
                this.noActionEmail = noActionEmail;
                return this;
            }

            /**
             * Sets the value of {@link NotifyConfigurationTypeProperty#getNoActionEmail}
             * @param noActionEmail The email template used when a detected risk event is allowed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder noActionEmail(software.amazon.awscdk.services.cognito.CfnUserPoolRiskConfigurationAttachment.NotifyEmailTypeProperty noActionEmail) {
                this.noActionEmail = noActionEmail;
                return this;
            }

            /**
             * Sets the value of {@link NotifyConfigurationTypeProperty#getReplyTo}
             * @param replyTo The destination to which the receiver of an email should reply to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder replyTo(java.lang.String replyTo) {
                this.replyTo = replyTo;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NotifyConfigurationTypeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NotifyConfigurationTypeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NotifyConfigurationTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NotifyConfigurationTypeProperty {
            private final java.lang.String sourceArn;
            private final java.lang.Object blockEmail;
            private final java.lang.String from;
            private final java.lang.Object mfaEmail;
            private final java.lang.Object noActionEmail;
            private final java.lang.String replyTo;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.sourceArn = software.amazon.jsii.Kernel.get(this, "sourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.blockEmail = software.amazon.jsii.Kernel.get(this, "blockEmail", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.from = software.amazon.jsii.Kernel.get(this, "from", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.mfaEmail = software.amazon.jsii.Kernel.get(this, "mfaEmail", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.noActionEmail = software.amazon.jsii.Kernel.get(this, "noActionEmail", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.replyTo = software.amazon.jsii.Kernel.get(this, "replyTo", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sourceArn = java.util.Objects.requireNonNull(builder.sourceArn, "sourceArn is required");
                this.blockEmail = builder.blockEmail;
                this.from = builder.from;
                this.mfaEmail = builder.mfaEmail;
                this.noActionEmail = builder.noActionEmail;
                this.replyTo = builder.replyTo;
            }

            @Override
            public final java.lang.String getSourceArn() {
                return this.sourceArn;
            }

            @Override
            public final java.lang.Object getBlockEmail() {
                return this.blockEmail;
            }

            @Override
            public final java.lang.String getFrom() {
                return this.from;
            }

            @Override
            public final java.lang.Object getMfaEmail() {
                return this.mfaEmail;
            }

            @Override
            public final java.lang.Object getNoActionEmail() {
                return this.noActionEmail;
            }

            @Override
            public final java.lang.String getReplyTo() {
                return this.replyTo;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("sourceArn", om.valueToTree(this.getSourceArn()));
                if (this.getBlockEmail() != null) {
                    data.set("blockEmail", om.valueToTree(this.getBlockEmail()));
                }
                if (this.getFrom() != null) {
                    data.set("from", om.valueToTree(this.getFrom()));
                }
                if (this.getMfaEmail() != null) {
                    data.set("mfaEmail", om.valueToTree(this.getMfaEmail()));
                }
                if (this.getNoActionEmail() != null) {
                    data.set("noActionEmail", om.valueToTree(this.getNoActionEmail()));
                }
                if (this.getReplyTo() != null) {
                    data.set("replyTo", om.valueToTree(this.getReplyTo()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito.CfnUserPoolRiskConfigurationAttachment.NotifyConfigurationTypeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NotifyConfigurationTypeProperty.Jsii$Proxy that = (NotifyConfigurationTypeProperty.Jsii$Proxy) o;

                if (!sourceArn.equals(that.sourceArn)) return false;
                if (this.blockEmail != null ? !this.blockEmail.equals(that.blockEmail) : that.blockEmail != null) return false;
                if (this.from != null ? !this.from.equals(that.from) : that.from != null) return false;
                if (this.mfaEmail != null ? !this.mfaEmail.equals(that.mfaEmail) : that.mfaEmail != null) return false;
                if (this.noActionEmail != null ? !this.noActionEmail.equals(that.noActionEmail) : that.noActionEmail != null) return false;
                return this.replyTo != null ? this.replyTo.equals(that.replyTo) : that.replyTo == null;
            }

            @Override
            public final int hashCode() {
                int result = this.sourceArn.hashCode();
                result = 31 * result + (this.blockEmail != null ? this.blockEmail.hashCode() : 0);
                result = 31 * result + (this.from != null ? this.from.hashCode() : 0);
                result = 31 * result + (this.mfaEmail != null ? this.mfaEmail.hashCode() : 0);
                result = 31 * result + (this.noActionEmail != null ? this.noActionEmail.hashCode() : 0);
                result = 31 * result + (this.replyTo != null ? this.replyTo.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The notify email type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cognito.*;
     * NotifyEmailTypeProperty notifyEmailTypeProperty = NotifyEmailTypeProperty.builder()
     *         .subject("subject")
     *         // the properties below are optional
     *         .htmlBody("htmlBody")
     *         .textBody("textBody")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-notifyemailtype.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-notifyemailtype.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.CfnUserPoolRiskConfigurationAttachment.NotifyEmailTypeProperty")
    @software.amazon.jsii.Jsii.Proxy(NotifyEmailTypeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NotifyEmailTypeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The email subject.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-notifyemailtype.html#cfn-cognito-userpoolriskconfigurationattachment-notifyemailtype-subject">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-notifyemailtype.html#cfn-cognito-userpoolriskconfigurationattachment-notifyemailtype-subject</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSubject();

        /**
         * The email HTML body.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-notifyemailtype.html#cfn-cognito-userpoolriskconfigurationattachment-notifyemailtype-htmlbody">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-notifyemailtype.html#cfn-cognito-userpoolriskconfigurationattachment-notifyemailtype-htmlbody</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHtmlBody() {
            return null;
        }

        /**
         * The email text body.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-notifyemailtype.html#cfn-cognito-userpoolriskconfigurationattachment-notifyemailtype-textbody">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-notifyemailtype.html#cfn-cognito-userpoolriskconfigurationattachment-notifyemailtype-textbody</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTextBody() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NotifyEmailTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NotifyEmailTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NotifyEmailTypeProperty> {
            java.lang.String subject;
            java.lang.String htmlBody;
            java.lang.String textBody;

            /**
             * Sets the value of {@link NotifyEmailTypeProperty#getSubject}
             * @param subject The email subject. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subject(java.lang.String subject) {
                this.subject = subject;
                return this;
            }

            /**
             * Sets the value of {@link NotifyEmailTypeProperty#getHtmlBody}
             * @param htmlBody The email HTML body.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder htmlBody(java.lang.String htmlBody) {
                this.htmlBody = htmlBody;
                return this;
            }

            /**
             * Sets the value of {@link NotifyEmailTypeProperty#getTextBody}
             * @param textBody The email text body.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder textBody(java.lang.String textBody) {
                this.textBody = textBody;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NotifyEmailTypeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NotifyEmailTypeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NotifyEmailTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NotifyEmailTypeProperty {
            private final java.lang.String subject;
            private final java.lang.String htmlBody;
            private final java.lang.String textBody;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.subject = software.amazon.jsii.Kernel.get(this, "subject", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.htmlBody = software.amazon.jsii.Kernel.get(this, "htmlBody", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.textBody = software.amazon.jsii.Kernel.get(this, "textBody", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.subject = java.util.Objects.requireNonNull(builder.subject, "subject is required");
                this.htmlBody = builder.htmlBody;
                this.textBody = builder.textBody;
            }

            @Override
            public final java.lang.String getSubject() {
                return this.subject;
            }

            @Override
            public final java.lang.String getHtmlBody() {
                return this.htmlBody;
            }

            @Override
            public final java.lang.String getTextBody() {
                return this.textBody;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("subject", om.valueToTree(this.getSubject()));
                if (this.getHtmlBody() != null) {
                    data.set("htmlBody", om.valueToTree(this.getHtmlBody()));
                }
                if (this.getTextBody() != null) {
                    data.set("textBody", om.valueToTree(this.getTextBody()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito.CfnUserPoolRiskConfigurationAttachment.NotifyEmailTypeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NotifyEmailTypeProperty.Jsii$Proxy that = (NotifyEmailTypeProperty.Jsii$Proxy) o;

                if (!subject.equals(that.subject)) return false;
                if (this.htmlBody != null ? !this.htmlBody.equals(that.htmlBody) : that.htmlBody != null) return false;
                return this.textBody != null ? this.textBody.equals(that.textBody) : that.textBody == null;
            }

            @Override
            public final int hashCode() {
                int result = this.subject.hashCode();
                result = 31 * result + (this.htmlBody != null ? this.htmlBody.hashCode() : 0);
                result = 31 * result + (this.textBody != null ? this.textBody.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The type of the configuration to override the risk decision.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cognito.*;
     * RiskExceptionConfigurationTypeProperty riskExceptionConfigurationTypeProperty = RiskExceptionConfigurationTypeProperty.builder()
     *         .blockedIpRangeList(List.of("blockedIpRangeList"))
     *         .skippedIpRangeList(List.of("skippedIpRangeList"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-riskexceptionconfigurationtype.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-riskexceptionconfigurationtype.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.CfnUserPoolRiskConfigurationAttachment.RiskExceptionConfigurationTypeProperty")
    @software.amazon.jsii.Jsii.Proxy(RiskExceptionConfigurationTypeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RiskExceptionConfigurationTypeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Overrides the risk decision to always block the pre-authentication requests.
         * <p>
         * The IP range is in CIDR notation, a compact representation of an IP address and its routing prefix.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-riskexceptionconfigurationtype.html#cfn-cognito-userpoolriskconfigurationattachment-riskexceptionconfigurationtype-blockediprangelist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-riskexceptionconfigurationtype.html#cfn-cognito-userpoolriskconfigurationattachment-riskexceptionconfigurationtype-blockediprangelist</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getBlockedIpRangeList() {
            return null;
        }

        /**
         * Risk detection isn't performed on the IP addresses in this range list.
         * <p>
         * The IP range is in CIDR notation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-riskexceptionconfigurationtype.html#cfn-cognito-userpoolriskconfigurationattachment-riskexceptionconfigurationtype-skippediprangelist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-riskexceptionconfigurationtype.html#cfn-cognito-userpoolriskconfigurationattachment-riskexceptionconfigurationtype-skippediprangelist</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSkippedIpRangeList() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RiskExceptionConfigurationTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RiskExceptionConfigurationTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RiskExceptionConfigurationTypeProperty> {
            java.util.List<java.lang.String> blockedIpRangeList;
            java.util.List<java.lang.String> skippedIpRangeList;

            /**
             * Sets the value of {@link RiskExceptionConfigurationTypeProperty#getBlockedIpRangeList}
             * @param blockedIpRangeList Overrides the risk decision to always block the pre-authentication requests.
             *                           The IP range is in CIDR notation, a compact representation of an IP address and its routing prefix.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blockedIpRangeList(java.util.List<java.lang.String> blockedIpRangeList) {
                this.blockedIpRangeList = blockedIpRangeList;
                return this;
            }

            /**
             * Sets the value of {@link RiskExceptionConfigurationTypeProperty#getSkippedIpRangeList}
             * @param skippedIpRangeList Risk detection isn't performed on the IP addresses in this range list.
             *                           The IP range is in CIDR notation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder skippedIpRangeList(java.util.List<java.lang.String> skippedIpRangeList) {
                this.skippedIpRangeList = skippedIpRangeList;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RiskExceptionConfigurationTypeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RiskExceptionConfigurationTypeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RiskExceptionConfigurationTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RiskExceptionConfigurationTypeProperty {
            private final java.util.List<java.lang.String> blockedIpRangeList;
            private final java.util.List<java.lang.String> skippedIpRangeList;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.blockedIpRangeList = software.amazon.jsii.Kernel.get(this, "blockedIpRangeList", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.skippedIpRangeList = software.amazon.jsii.Kernel.get(this, "skippedIpRangeList", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.blockedIpRangeList = builder.blockedIpRangeList;
                this.skippedIpRangeList = builder.skippedIpRangeList;
            }

            @Override
            public final java.util.List<java.lang.String> getBlockedIpRangeList() {
                return this.blockedIpRangeList;
            }

            @Override
            public final java.util.List<java.lang.String> getSkippedIpRangeList() {
                return this.skippedIpRangeList;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBlockedIpRangeList() != null) {
                    data.set("blockedIpRangeList", om.valueToTree(this.getBlockedIpRangeList()));
                }
                if (this.getSkippedIpRangeList() != null) {
                    data.set("skippedIpRangeList", om.valueToTree(this.getSkippedIpRangeList()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito.CfnUserPoolRiskConfigurationAttachment.RiskExceptionConfigurationTypeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RiskExceptionConfigurationTypeProperty.Jsii$Proxy that = (RiskExceptionConfigurationTypeProperty.Jsii$Proxy) o;

                if (this.blockedIpRangeList != null ? !this.blockedIpRangeList.equals(that.blockedIpRangeList) : that.blockedIpRangeList != null) return false;
                return this.skippedIpRangeList != null ? this.skippedIpRangeList.equals(that.skippedIpRangeList) : that.skippedIpRangeList == null;
            }

            @Override
            public final int hashCode() {
                int result = this.blockedIpRangeList != null ? this.blockedIpRangeList.hashCode() : 0;
                result = 31 * result + (this.skippedIpRangeList != null ? this.skippedIpRangeList.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cognito.CfnUserPoolRiskConfigurationAttachment}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cognito.CfnUserPoolRiskConfigurationAttachment> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.cognito.CfnUserPoolRiskConfigurationAttachmentProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.cognito.CfnUserPoolRiskConfigurationAttachmentProps.Builder();
        }

        /**
         * The app client ID.
         * <p>
         * You can specify the risk configuration for a single client (with a specific ClientId) or for all clients (by setting the ClientId to <code>ALL</code> ).
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html#cfn-cognito-userpoolriskconfigurationattachment-clientid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html#cfn-cognito-userpoolriskconfigurationattachment-clientid</a>
         * @param clientId The app client ID. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientId(final java.lang.String clientId) {
            this.props.clientId(clientId);
            return this;
        }

        /**
         * The user pool ID.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html#cfn-cognito-userpoolriskconfigurationattachment-userpoolid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html#cfn-cognito-userpoolriskconfigurationattachment-userpoolid</a>
         * @param userPoolId The user pool ID. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPoolId(final java.lang.String userPoolId) {
            this.props.userPoolId(userPoolId);
            return this;
        }

        /**
         * The account takeover risk configuration object, including the <code>NotifyConfiguration</code> object and <code>Actions</code> to take if there is an account takeover.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html#cfn-cognito-userpoolriskconfigurationattachment-accounttakeoverriskconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html#cfn-cognito-userpoolriskconfigurationattachment-accounttakeoverriskconfiguration</a>
         * @param accountTakeoverRiskConfiguration The account takeover risk configuration object, including the <code>NotifyConfiguration</code> object and <code>Actions</code> to take if there is an account takeover. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accountTakeoverRiskConfiguration(final software.amazon.awscdk.IResolvable accountTakeoverRiskConfiguration) {
            this.props.accountTakeoverRiskConfiguration(accountTakeoverRiskConfiguration);
            return this;
        }
        /**
         * The account takeover risk configuration object, including the <code>NotifyConfiguration</code> object and <code>Actions</code> to take if there is an account takeover.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html#cfn-cognito-userpoolriskconfigurationattachment-accounttakeoverriskconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html#cfn-cognito-userpoolriskconfigurationattachment-accounttakeoverriskconfiguration</a>
         * @param accountTakeoverRiskConfiguration The account takeover risk configuration object, including the <code>NotifyConfiguration</code> object and <code>Actions</code> to take if there is an account takeover. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accountTakeoverRiskConfiguration(final software.amazon.awscdk.services.cognito.CfnUserPoolRiskConfigurationAttachment.AccountTakeoverRiskConfigurationTypeProperty accountTakeoverRiskConfiguration) {
            this.props.accountTakeoverRiskConfiguration(accountTakeoverRiskConfiguration);
            return this;
        }

        /**
         * The compromised credentials risk configuration object, including the <code>EventFilter</code> and the <code>EventAction</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html#cfn-cognito-userpoolriskconfigurationattachment-compromisedcredentialsriskconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html#cfn-cognito-userpoolriskconfigurationattachment-compromisedcredentialsriskconfiguration</a>
         * @param compromisedCredentialsRiskConfiguration The compromised credentials risk configuration object, including the <code>EventFilter</code> and the <code>EventAction</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder compromisedCredentialsRiskConfiguration(final software.amazon.awscdk.IResolvable compromisedCredentialsRiskConfiguration) {
            this.props.compromisedCredentialsRiskConfiguration(compromisedCredentialsRiskConfiguration);
            return this;
        }
        /**
         * The compromised credentials risk configuration object, including the <code>EventFilter</code> and the <code>EventAction</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html#cfn-cognito-userpoolriskconfigurationattachment-compromisedcredentialsriskconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html#cfn-cognito-userpoolriskconfigurationattachment-compromisedcredentialsriskconfiguration</a>
         * @param compromisedCredentialsRiskConfiguration The compromised credentials risk configuration object, including the <code>EventFilter</code> and the <code>EventAction</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder compromisedCredentialsRiskConfiguration(final software.amazon.awscdk.services.cognito.CfnUserPoolRiskConfigurationAttachment.CompromisedCredentialsRiskConfigurationTypeProperty compromisedCredentialsRiskConfiguration) {
            this.props.compromisedCredentialsRiskConfiguration(compromisedCredentialsRiskConfiguration);
            return this;
        }

        /**
         * The configuration to override the risk decision.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html#cfn-cognito-userpoolriskconfigurationattachment-riskexceptionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html#cfn-cognito-userpoolriskconfigurationattachment-riskexceptionconfiguration</a>
         * @param riskExceptionConfiguration The configuration to override the risk decision. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder riskExceptionConfiguration(final software.amazon.awscdk.IResolvable riskExceptionConfiguration) {
            this.props.riskExceptionConfiguration(riskExceptionConfiguration);
            return this;
        }
        /**
         * The configuration to override the risk decision.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html#cfn-cognito-userpoolriskconfigurationattachment-riskexceptionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html#cfn-cognito-userpoolriskconfigurationattachment-riskexceptionconfiguration</a>
         * @param riskExceptionConfiguration The configuration to override the risk decision. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder riskExceptionConfiguration(final software.amazon.awscdk.services.cognito.CfnUserPoolRiskConfigurationAttachment.RiskExceptionConfigurationTypeProperty riskExceptionConfiguration) {
            this.props.riskExceptionConfiguration(riskExceptionConfiguration);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.cognito.CfnUserPoolRiskConfigurationAttachment}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cognito.CfnUserPoolRiskConfigurationAttachment build() {
            return new software.amazon.awscdk.services.cognito.CfnUserPoolRiskConfigurationAttachment(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
