package software.amazon.awscdk.services.connect;

/**
 * Creates an evaluation form for the specified Amazon Connect instance.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.connect.*;
 * EvaluationFormSectionProperty evaluationFormSectionProperty_;
 * CfnEvaluationForm cfnEvaluationForm = CfnEvaluationForm.Builder.create(this, "MyCfnEvaluationForm")
 *         .instanceArn("instanceArn")
 *         .items(List.of(EvaluationFormBaseItemProperty.builder()
 *                 .section(EvaluationFormSectionProperty.builder()
 *                         .refId("refId")
 *                         .title("title")
 *                         // the properties below are optional
 *                         .instructions("instructions")
 *                         .items(List.of(EvaluationFormItemProperty.builder()
 *                                 .question(EvaluationFormQuestionProperty.builder()
 *                                         .questionType("questionType")
 *                                         .refId("refId")
 *                                         .title("title")
 *                                         // the properties below are optional
 *                                         .instructions("instructions")
 *                                         .notApplicableEnabled(false)
 *                                         .questionTypeProperties(EvaluationFormQuestionTypePropertiesProperty.builder()
 *                                                 .numeric(EvaluationFormNumericQuestionPropertiesProperty.builder()
 *                                                         .maxValue(123)
 *                                                         .minValue(123)
 *                                                         // the properties below are optional
 *                                                         .automation(EvaluationFormNumericQuestionAutomationProperty.builder()
 *                                                                 .propertyValue(NumericQuestionPropertyValueAutomationProperty.builder()
 *                                                                         .label("label")
 *                                                                         .build())
 *                                                                 .build())
 *                                                         .options(List.of(EvaluationFormNumericQuestionOptionProperty.builder()
 *                                                                 .maxValue(123)
 *                                                                 .minValue(123)
 *                                                                 // the properties below are optional
 *                                                                 .automaticFail(false)
 *                                                                 .score(123)
 *                                                                 .build()))
 *                                                         .build())
 *                                                 .singleSelect(EvaluationFormSingleSelectQuestionPropertiesProperty.builder()
 *                                                         .options(List.of(EvaluationFormSingleSelectQuestionOptionProperty.builder()
 *                                                                 .refId("refId")
 *                                                                 .text("text")
 *                                                                 // the properties below are optional
 *                                                                 .automaticFail(false)
 *                                                                 .score(123)
 *                                                                 .build()))
 *                                                         // the properties below are optional
 *                                                         .automation(EvaluationFormSingleSelectQuestionAutomationProperty.builder()
 *                                                                 .options(List.of(EvaluationFormSingleSelectQuestionAutomationOptionProperty.builder()
 *                                                                         .ruleCategory(SingleSelectQuestionRuleCategoryAutomationProperty.builder()
 *                                                                                 .category("category")
 *                                                                                 .condition("condition")
 *                                                                                 .optionRefId("optionRefId")
 *                                                                                 .build())
 *                                                                         .build()))
 *                                                                 // the properties below are optional
 *                                                                 .defaultOptionRefId("defaultOptionRefId")
 *                                                                 .build())
 *                                                         .displayAs("displayAs")
 *                                                         .build())
 *                                                 .build())
 *                                         .weight(123)
 *                                         .build())
 *                                 .section(evaluationFormSectionProperty_)
 *                                 .build()))
 *                         .weight(123)
 *                         .build())
 *                 .build()))
 *         .status("status")
 *         .title("title")
 *         // the properties below are optional
 *         .description("description")
 *         .scoringStrategy(ScoringStrategyProperty.builder()
 *                 .mode("mode")
 *                 .status("status")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-22T22:42:49.520Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnEvaluationForm")
public class CfnEvaluationForm extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnEvaluationForm(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnEvaluationForm(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.connect.CfnEvaluationForm.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnEvaluationForm(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.connect.CfnEvaluationFormProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the evaluation form.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrEvaluationFormArn() {
        return software.amazon.jsii.Kernel.get(this, "attrEvaluationFormArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The identifier of the Amazon Connect instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getInstanceArn() {
        return software.amazon.jsii.Kernel.get(this, "instanceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier of the Amazon Connect instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstanceArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "instanceArn", java.util.Objects.requireNonNull(value, "instanceArn is required"));
    }

    /**
     * Items that are part of the evaluation form.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getItems() {
        return software.amazon.jsii.Kernel.get(this, "items", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Items that are part of the evaluation form.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setItems(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "items", java.util.Objects.requireNonNull(value, "items is required"));
    }

    /**
     * Items that are part of the evaluation form.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setItems(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.connect.CfnEvaluationForm.EvaluationFormBaseItemProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.connect.CfnEvaluationForm.EvaluationFormBaseItemProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "items", java.util.Objects.requireNonNull(value, "items is required"));
    }

    /**
     * The status of the evaluation form.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getStatus() {
        return software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The status of the evaluation form.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStatus(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "status", java.util.Objects.requireNonNull(value, "status is required"));
    }

    /**
     * A title of the evaluation form.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getTitle() {
        return software.amazon.jsii.Kernel.get(this, "title", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A title of the evaluation form.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTitle(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "title", java.util.Objects.requireNonNull(value, "title is required"));
    }

    /**
     * The description of the evaluation form.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description of the evaluation form.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * A scoring strategy of the evaluation form.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getScoringStrategy() {
        return software.amazon.jsii.Kernel.get(this, "scoringStrategy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A scoring strategy of the evaluation form.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScoringStrategy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "scoringStrategy", value);
    }

    /**
     * A scoring strategy of the evaluation form.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScoringStrategy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.connect.CfnEvaluationForm.ScoringStrategyProperty value) {
        software.amazon.jsii.Kernel.set(this, "scoringStrategy", value);
    }

    /**
     * The tags used to organize, track, or control access for this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The tags used to organize, track, or control access for this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * An item at the root level.
     * <p>
     * All items must be sections.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * EvaluationFormSectionProperty evaluationFormSectionProperty_;
     * EvaluationFormBaseItemProperty evaluationFormBaseItemProperty = EvaluationFormBaseItemProperty.builder()
     *         .section(EvaluationFormSectionProperty.builder()
     *                 .refId("refId")
     *                 .title("title")
     *                 // the properties below are optional
     *                 .instructions("instructions")
     *                 .items(List.of(EvaluationFormItemProperty.builder()
     *                         .question(EvaluationFormQuestionProperty.builder()
     *                                 .questionType("questionType")
     *                                 .refId("refId")
     *                                 .title("title")
     *                                 // the properties below are optional
     *                                 .instructions("instructions")
     *                                 .notApplicableEnabled(false)
     *                                 .questionTypeProperties(EvaluationFormQuestionTypePropertiesProperty.builder()
     *                                         .numeric(EvaluationFormNumericQuestionPropertiesProperty.builder()
     *                                                 .maxValue(123)
     *                                                 .minValue(123)
     *                                                 // the properties below are optional
     *                                                 .automation(EvaluationFormNumericQuestionAutomationProperty.builder()
     *                                                         .propertyValue(NumericQuestionPropertyValueAutomationProperty.builder()
     *                                                                 .label("label")
     *                                                                 .build())
     *                                                         .build())
     *                                                 .options(List.of(EvaluationFormNumericQuestionOptionProperty.builder()
     *                                                         .maxValue(123)
     *                                                         .minValue(123)
     *                                                         // the properties below are optional
     *                                                         .automaticFail(false)
     *                                                         .score(123)
     *                                                         .build()))
     *                                                 .build())
     *                                         .singleSelect(EvaluationFormSingleSelectQuestionPropertiesProperty.builder()
     *                                                 .options(List.of(EvaluationFormSingleSelectQuestionOptionProperty.builder()
     *                                                         .refId("refId")
     *                                                         .text("text")
     *                                                         // the properties below are optional
     *                                                         .automaticFail(false)
     *                                                         .score(123)
     *                                                         .build()))
     *                                                 // the properties below are optional
     *                                                 .automation(EvaluationFormSingleSelectQuestionAutomationProperty.builder()
     *                                                         .options(List.of(EvaluationFormSingleSelectQuestionAutomationOptionProperty.builder()
     *                                                                 .ruleCategory(SingleSelectQuestionRuleCategoryAutomationProperty.builder()
     *                                                                         .category("category")
     *                                                                         .condition("condition")
     *                                                                         .optionRefId("optionRefId")
     *                                                                         .build())
     *                                                                 .build()))
     *                                                         // the properties below are optional
     *                                                         .defaultOptionRefId("defaultOptionRefId")
     *                                                         .build())
     *                                                 .displayAs("displayAs")
     *                                                 .build())
     *                                         .build())
     *                                 .weight(123)
     *                                 .build())
     *                         .section(evaluationFormSectionProperty_)
     *                         .build()))
     *                 .weight(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformbaseitem.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformbaseitem.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormBaseItemProperty")
    @software.amazon.jsii.Jsii.Proxy(EvaluationFormBaseItemProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EvaluationFormBaseItemProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A subsection or inner section of an item.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformbaseitem.html#cfn-connect-evaluationform-evaluationformbaseitem-section">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformbaseitem.html#cfn-connect-evaluationform-evaluationformbaseitem-section</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getSection();

        /**
         * @return a {@link Builder} of {@link EvaluationFormBaseItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EvaluationFormBaseItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EvaluationFormBaseItemProperty> {
            java.lang.Object section;

            /**
             * Sets the value of {@link EvaluationFormBaseItemProperty#getSection}
             * @param section A subsection or inner section of an item. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder section(software.amazon.awscdk.IResolvable section) {
                this.section = section;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormBaseItemProperty#getSection}
             * @param section A subsection or inner section of an item. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder section(software.amazon.awscdk.services.connect.CfnEvaluationForm.EvaluationFormSectionProperty section) {
                this.section = section;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EvaluationFormBaseItemProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EvaluationFormBaseItemProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EvaluationFormBaseItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EvaluationFormBaseItemProperty {
            private final java.lang.Object section;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.section = software.amazon.jsii.Kernel.get(this, "section", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.section = java.util.Objects.requireNonNull(builder.section, "section is required");
            }

            @Override
            public final java.lang.Object getSection() {
                return this.section;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("section", om.valueToTree(this.getSection()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormBaseItemProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EvaluationFormBaseItemProperty.Jsii$Proxy that = (EvaluationFormBaseItemProperty.Jsii$Proxy) o;

                return this.section.equals(that.section);
            }

            @Override
            public final int hashCode() {
                int result = this.section.hashCode();
                return result;
            }
        }
    }
    /**
     * Items that are part of the evaluation form.
     * <p>
     * The total number of sections and questions must not exceed 100 each. Questions must be contained in a section.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * EvaluationFormItemProperty evaluationFormItemProperty_;
     * EvaluationFormItemProperty evaluationFormItemProperty = EvaluationFormItemProperty.builder()
     *         .question(EvaluationFormQuestionProperty.builder()
     *                 .questionType("questionType")
     *                 .refId("refId")
     *                 .title("title")
     *                 // the properties below are optional
     *                 .instructions("instructions")
     *                 .notApplicableEnabled(false)
     *                 .questionTypeProperties(EvaluationFormQuestionTypePropertiesProperty.builder()
     *                         .numeric(EvaluationFormNumericQuestionPropertiesProperty.builder()
     *                                 .maxValue(123)
     *                                 .minValue(123)
     *                                 // the properties below are optional
     *                                 .automation(EvaluationFormNumericQuestionAutomationProperty.builder()
     *                                         .propertyValue(NumericQuestionPropertyValueAutomationProperty.builder()
     *                                                 .label("label")
     *                                                 .build())
     *                                         .build())
     *                                 .options(List.of(EvaluationFormNumericQuestionOptionProperty.builder()
     *                                         .maxValue(123)
     *                                         .minValue(123)
     *                                         // the properties below are optional
     *                                         .automaticFail(false)
     *                                         .score(123)
     *                                         .build()))
     *                                 .build())
     *                         .singleSelect(EvaluationFormSingleSelectQuestionPropertiesProperty.builder()
     *                                 .options(List.of(EvaluationFormSingleSelectQuestionOptionProperty.builder()
     *                                         .refId("refId")
     *                                         .text("text")
     *                                         // the properties below are optional
     *                                         .automaticFail(false)
     *                                         .score(123)
     *                                         .build()))
     *                                 // the properties below are optional
     *                                 .automation(EvaluationFormSingleSelectQuestionAutomationProperty.builder()
     *                                         .options(List.of(EvaluationFormSingleSelectQuestionAutomationOptionProperty.builder()
     *                                                 .ruleCategory(SingleSelectQuestionRuleCategoryAutomationProperty.builder()
     *                                                         .category("category")
     *                                                         .condition("condition")
     *                                                         .optionRefId("optionRefId")
     *                                                         .build())
     *                                                 .build()))
     *                                         // the properties below are optional
     *                                         .defaultOptionRefId("defaultOptionRefId")
     *                                         .build())
     *                                 .displayAs("displayAs")
     *                                 .build())
     *                         .build())
     *                 .weight(123)
     *                 .build())
     *         .section(EvaluationFormSectionProperty.builder()
     *                 .refId("refId")
     *                 .title("title")
     *                 // the properties below are optional
     *                 .instructions("instructions")
     *                 .items(List.of(evaluationFormItemProperty_))
     *                 .weight(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformitem.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformitem.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormItemProperty")
    @software.amazon.jsii.Jsii.Proxy(EvaluationFormItemProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EvaluationFormItemProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The information of the question.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformitem.html#cfn-connect-evaluationform-evaluationformitem-question">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformitem.html#cfn-connect-evaluationform-evaluationformitem-question</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getQuestion() {
            return null;
        }

        /**
         * The information of the section.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformitem.html#cfn-connect-evaluationform-evaluationformitem-section">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformitem.html#cfn-connect-evaluationform-evaluationformitem-section</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSection() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EvaluationFormItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EvaluationFormItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EvaluationFormItemProperty> {
            java.lang.Object question;
            java.lang.Object section;

            /**
             * Sets the value of {@link EvaluationFormItemProperty#getQuestion}
             * @param question The information of the question.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder question(software.amazon.awscdk.IResolvable question) {
                this.question = question;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormItemProperty#getQuestion}
             * @param question The information of the question.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder question(software.amazon.awscdk.services.connect.CfnEvaluationForm.EvaluationFormQuestionProperty question) {
                this.question = question;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormItemProperty#getSection}
             * @param section The information of the section.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder section(software.amazon.awscdk.IResolvable section) {
                this.section = section;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormItemProperty#getSection}
             * @param section The information of the section.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder section(software.amazon.awscdk.services.connect.CfnEvaluationForm.EvaluationFormSectionProperty section) {
                this.section = section;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EvaluationFormItemProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EvaluationFormItemProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EvaluationFormItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EvaluationFormItemProperty {
            private final java.lang.Object question;
            private final java.lang.Object section;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.question = software.amazon.jsii.Kernel.get(this, "question", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.section = software.amazon.jsii.Kernel.get(this, "section", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.question = builder.question;
                this.section = builder.section;
            }

            @Override
            public final java.lang.Object getQuestion() {
                return this.question;
            }

            @Override
            public final java.lang.Object getSection() {
                return this.section;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getQuestion() != null) {
                    data.set("question", om.valueToTree(this.getQuestion()));
                }
                if (this.getSection() != null) {
                    data.set("section", om.valueToTree(this.getSection()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormItemProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EvaluationFormItemProperty.Jsii$Proxy that = (EvaluationFormItemProperty.Jsii$Proxy) o;

                if (this.question != null ? !this.question.equals(that.question) : that.question != null) return false;
                return this.section != null ? this.section.equals(that.section) : that.section == null;
            }

            @Override
            public final int hashCode() {
                int result = this.question != null ? this.question.hashCode() : 0;
                result = 31 * result + (this.section != null ? this.section.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about the automation configuration in numeric questions.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * EvaluationFormNumericQuestionAutomationProperty evaluationFormNumericQuestionAutomationProperty = EvaluationFormNumericQuestionAutomationProperty.builder()
     *         .propertyValue(NumericQuestionPropertyValueAutomationProperty.builder()
     *                 .label("label")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformnumericquestionautomation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformnumericquestionautomation.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormNumericQuestionAutomationProperty")
    @software.amazon.jsii.Jsii.Proxy(EvaluationFormNumericQuestionAutomationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EvaluationFormNumericQuestionAutomationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The property value of the automation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformnumericquestionautomation.html#cfn-connect-evaluationform-evaluationformnumericquestionautomation-propertyvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformnumericquestionautomation.html#cfn-connect-evaluationform-evaluationformnumericquestionautomation-propertyvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getPropertyValue();

        /**
         * @return a {@link Builder} of {@link EvaluationFormNumericQuestionAutomationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EvaluationFormNumericQuestionAutomationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EvaluationFormNumericQuestionAutomationProperty> {
            java.lang.Object propertyValue;

            /**
             * Sets the value of {@link EvaluationFormNumericQuestionAutomationProperty#getPropertyValue}
             * @param propertyValue The property value of the automation. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder propertyValue(software.amazon.awscdk.IResolvable propertyValue) {
                this.propertyValue = propertyValue;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormNumericQuestionAutomationProperty#getPropertyValue}
             * @param propertyValue The property value of the automation. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder propertyValue(software.amazon.awscdk.services.connect.CfnEvaluationForm.NumericQuestionPropertyValueAutomationProperty propertyValue) {
                this.propertyValue = propertyValue;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EvaluationFormNumericQuestionAutomationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EvaluationFormNumericQuestionAutomationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EvaluationFormNumericQuestionAutomationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EvaluationFormNumericQuestionAutomationProperty {
            private final java.lang.Object propertyValue;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.propertyValue = software.amazon.jsii.Kernel.get(this, "propertyValue", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.propertyValue = java.util.Objects.requireNonNull(builder.propertyValue, "propertyValue is required");
            }

            @Override
            public final java.lang.Object getPropertyValue() {
                return this.propertyValue;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("propertyValue", om.valueToTree(this.getPropertyValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormNumericQuestionAutomationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EvaluationFormNumericQuestionAutomationProperty.Jsii$Proxy that = (EvaluationFormNumericQuestionAutomationProperty.Jsii$Proxy) o;

                return this.propertyValue.equals(that.propertyValue);
            }

            @Override
            public final int hashCode() {
                int result = this.propertyValue.hashCode();
                return result;
            }
        }
    }
    /**
     * Information about the option range used for scoring in numeric questions.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * EvaluationFormNumericQuestionOptionProperty evaluationFormNumericQuestionOptionProperty = EvaluationFormNumericQuestionOptionProperty.builder()
     *         .maxValue(123)
     *         .minValue(123)
     *         // the properties below are optional
     *         .automaticFail(false)
     *         .score(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformnumericquestionoption.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformnumericquestionoption.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormNumericQuestionOptionProperty")
    @software.amazon.jsii.Jsii.Proxy(EvaluationFormNumericQuestionOptionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EvaluationFormNumericQuestionOptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum answer value of the range option.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformnumericquestionoption.html#cfn-connect-evaluationform-evaluationformnumericquestionoption-maxvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformnumericquestionoption.html#cfn-connect-evaluationform-evaluationformnumericquestionoption-maxvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMaxValue();

        /**
         * The minimum answer value of the range option.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformnumericquestionoption.html#cfn-connect-evaluationform-evaluationformnumericquestionoption-minvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformnumericquestionoption.html#cfn-connect-evaluationform-evaluationformnumericquestionoption-minvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMinValue();

        /**
         * The flag to mark the option as automatic fail.
         * <p>
         * If an automatic fail answer is provided, the overall evaluation gets a score of 0.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformnumericquestionoption.html#cfn-connect-evaluationform-evaluationformnumericquestionoption-automaticfail">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformnumericquestionoption.html#cfn-connect-evaluationform-evaluationformnumericquestionoption-automaticfail</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAutomaticFail() {
            return null;
        }

        /**
         * The score assigned to answer values within the range option.
         * <p>
         * <em>Minimum</em> : 0
         * <p>
         * <em>Maximum</em> : 10
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformnumericquestionoption.html#cfn-connect-evaluationform-evaluationformnumericquestionoption-score">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformnumericquestionoption.html#cfn-connect-evaluationform-evaluationformnumericquestionoption-score</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getScore() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EvaluationFormNumericQuestionOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EvaluationFormNumericQuestionOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EvaluationFormNumericQuestionOptionProperty> {
            java.lang.Number maxValue;
            java.lang.Number minValue;
            java.lang.Object automaticFail;
            java.lang.Number score;

            /**
             * Sets the value of {@link EvaluationFormNumericQuestionOptionProperty#getMaxValue}
             * @param maxValue The maximum answer value of the range option. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxValue(java.lang.Number maxValue) {
                this.maxValue = maxValue;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormNumericQuestionOptionProperty#getMinValue}
             * @param minValue The minimum answer value of the range option. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minValue(java.lang.Number minValue) {
                this.minValue = minValue;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormNumericQuestionOptionProperty#getAutomaticFail}
             * @param automaticFail The flag to mark the option as automatic fail.
             *                      If an automatic fail answer is provided, the overall evaluation gets a score of 0.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder automaticFail(java.lang.Boolean automaticFail) {
                this.automaticFail = automaticFail;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormNumericQuestionOptionProperty#getAutomaticFail}
             * @param automaticFail The flag to mark the option as automatic fail.
             *                      If an automatic fail answer is provided, the overall evaluation gets a score of 0.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder automaticFail(software.amazon.awscdk.IResolvable automaticFail) {
                this.automaticFail = automaticFail;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormNumericQuestionOptionProperty#getScore}
             * @param score The score assigned to answer values within the range option.
             *              <em>Minimum</em> : 0
             *              <p>
             *              <em>Maximum</em> : 10
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder score(java.lang.Number score) {
                this.score = score;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EvaluationFormNumericQuestionOptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EvaluationFormNumericQuestionOptionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EvaluationFormNumericQuestionOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EvaluationFormNumericQuestionOptionProperty {
            private final java.lang.Number maxValue;
            private final java.lang.Number minValue;
            private final java.lang.Object automaticFail;
            private final java.lang.Number score;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxValue = software.amazon.jsii.Kernel.get(this, "maxValue", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.minValue = software.amazon.jsii.Kernel.get(this, "minValue", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.automaticFail = software.amazon.jsii.Kernel.get(this, "automaticFail", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.score = software.amazon.jsii.Kernel.get(this, "score", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxValue = java.util.Objects.requireNonNull(builder.maxValue, "maxValue is required");
                this.minValue = java.util.Objects.requireNonNull(builder.minValue, "minValue is required");
                this.automaticFail = builder.automaticFail;
                this.score = builder.score;
            }

            @Override
            public final java.lang.Number getMaxValue() {
                return this.maxValue;
            }

            @Override
            public final java.lang.Number getMinValue() {
                return this.minValue;
            }

            @Override
            public final java.lang.Object getAutomaticFail() {
                return this.automaticFail;
            }

            @Override
            public final java.lang.Number getScore() {
                return this.score;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("maxValue", om.valueToTree(this.getMaxValue()));
                data.set("minValue", om.valueToTree(this.getMinValue()));
                if (this.getAutomaticFail() != null) {
                    data.set("automaticFail", om.valueToTree(this.getAutomaticFail()));
                }
                if (this.getScore() != null) {
                    data.set("score", om.valueToTree(this.getScore()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormNumericQuestionOptionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EvaluationFormNumericQuestionOptionProperty.Jsii$Proxy that = (EvaluationFormNumericQuestionOptionProperty.Jsii$Proxy) o;

                if (!maxValue.equals(that.maxValue)) return false;
                if (!minValue.equals(that.minValue)) return false;
                if (this.automaticFail != null ? !this.automaticFail.equals(that.automaticFail) : that.automaticFail != null) return false;
                return this.score != null ? this.score.equals(that.score) : that.score == null;
            }

            @Override
            public final int hashCode() {
                int result = this.maxValue.hashCode();
                result = 31 * result + (this.minValue.hashCode());
                result = 31 * result + (this.automaticFail != null ? this.automaticFail.hashCode() : 0);
                result = 31 * result + (this.score != null ? this.score.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about properties for a numeric question in an evaluation form.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * EvaluationFormNumericQuestionPropertiesProperty evaluationFormNumericQuestionPropertiesProperty = EvaluationFormNumericQuestionPropertiesProperty.builder()
     *         .maxValue(123)
     *         .minValue(123)
     *         // the properties below are optional
     *         .automation(EvaluationFormNumericQuestionAutomationProperty.builder()
     *                 .propertyValue(NumericQuestionPropertyValueAutomationProperty.builder()
     *                         .label("label")
     *                         .build())
     *                 .build())
     *         .options(List.of(EvaluationFormNumericQuestionOptionProperty.builder()
     *                 .maxValue(123)
     *                 .minValue(123)
     *                 // the properties below are optional
     *                 .automaticFail(false)
     *                 .score(123)
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformnumericquestionproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformnumericquestionproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormNumericQuestionPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(EvaluationFormNumericQuestionPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EvaluationFormNumericQuestionPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum answer value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformnumericquestionproperties.html#cfn-connect-evaluationform-evaluationformnumericquestionproperties-maxvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformnumericquestionproperties.html#cfn-connect-evaluationform-evaluationformnumericquestionproperties-maxvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMaxValue();

        /**
         * The minimum answer value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformnumericquestionproperties.html#cfn-connect-evaluationform-evaluationformnumericquestionproperties-minvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformnumericquestionproperties.html#cfn-connect-evaluationform-evaluationformnumericquestionproperties-minvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMinValue();

        /**
         * The automation properties of the numeric question.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformnumericquestionproperties.html#cfn-connect-evaluationform-evaluationformnumericquestionproperties-automation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformnumericquestionproperties.html#cfn-connect-evaluationform-evaluationformnumericquestionproperties-automation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAutomation() {
            return null;
        }

        /**
         * The scoring options of the numeric question.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformnumericquestionproperties.html#cfn-connect-evaluationform-evaluationformnumericquestionproperties-options">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformnumericquestionproperties.html#cfn-connect-evaluationform-evaluationformnumericquestionproperties-options</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOptions() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EvaluationFormNumericQuestionPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EvaluationFormNumericQuestionPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EvaluationFormNumericQuestionPropertiesProperty> {
            java.lang.Number maxValue;
            java.lang.Number minValue;
            java.lang.Object automation;
            java.lang.Object options;

            /**
             * Sets the value of {@link EvaluationFormNumericQuestionPropertiesProperty#getMaxValue}
             * @param maxValue The maximum answer value. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxValue(java.lang.Number maxValue) {
                this.maxValue = maxValue;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormNumericQuestionPropertiesProperty#getMinValue}
             * @param minValue The minimum answer value. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minValue(java.lang.Number minValue) {
                this.minValue = minValue;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormNumericQuestionPropertiesProperty#getAutomation}
             * @param automation The automation properties of the numeric question.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder automation(software.amazon.awscdk.IResolvable automation) {
                this.automation = automation;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormNumericQuestionPropertiesProperty#getAutomation}
             * @param automation The automation properties of the numeric question.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder automation(software.amazon.awscdk.services.connect.CfnEvaluationForm.EvaluationFormNumericQuestionAutomationProperty automation) {
                this.automation = automation;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormNumericQuestionPropertiesProperty#getOptions}
             * @param options The scoring options of the numeric question.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder options(software.amazon.awscdk.IResolvable options) {
                this.options = options;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormNumericQuestionPropertiesProperty#getOptions}
             * @param options The scoring options of the numeric question.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder options(java.util.List<? extends java.lang.Object> options) {
                this.options = options;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EvaluationFormNumericQuestionPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EvaluationFormNumericQuestionPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EvaluationFormNumericQuestionPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EvaluationFormNumericQuestionPropertiesProperty {
            private final java.lang.Number maxValue;
            private final java.lang.Number minValue;
            private final java.lang.Object automation;
            private final java.lang.Object options;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxValue = software.amazon.jsii.Kernel.get(this, "maxValue", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.minValue = software.amazon.jsii.Kernel.get(this, "minValue", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.automation = software.amazon.jsii.Kernel.get(this, "automation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.options = software.amazon.jsii.Kernel.get(this, "options", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxValue = java.util.Objects.requireNonNull(builder.maxValue, "maxValue is required");
                this.minValue = java.util.Objects.requireNonNull(builder.minValue, "minValue is required");
                this.automation = builder.automation;
                this.options = builder.options;
            }

            @Override
            public final java.lang.Number getMaxValue() {
                return this.maxValue;
            }

            @Override
            public final java.lang.Number getMinValue() {
                return this.minValue;
            }

            @Override
            public final java.lang.Object getAutomation() {
                return this.automation;
            }

            @Override
            public final java.lang.Object getOptions() {
                return this.options;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("maxValue", om.valueToTree(this.getMaxValue()));
                data.set("minValue", om.valueToTree(this.getMinValue()));
                if (this.getAutomation() != null) {
                    data.set("automation", om.valueToTree(this.getAutomation()));
                }
                if (this.getOptions() != null) {
                    data.set("options", om.valueToTree(this.getOptions()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormNumericQuestionPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EvaluationFormNumericQuestionPropertiesProperty.Jsii$Proxy that = (EvaluationFormNumericQuestionPropertiesProperty.Jsii$Proxy) o;

                if (!maxValue.equals(that.maxValue)) return false;
                if (!minValue.equals(that.minValue)) return false;
                if (this.automation != null ? !this.automation.equals(that.automation) : that.automation != null) return false;
                return this.options != null ? this.options.equals(that.options) : that.options == null;
            }

            @Override
            public final int hashCode() {
                int result = this.maxValue.hashCode();
                result = 31 * result + (this.minValue.hashCode());
                result = 31 * result + (this.automation != null ? this.automation.hashCode() : 0);
                result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about a question from an evaluation form.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * EvaluationFormQuestionProperty evaluationFormQuestionProperty = EvaluationFormQuestionProperty.builder()
     *         .questionType("questionType")
     *         .refId("refId")
     *         .title("title")
     *         // the properties below are optional
     *         .instructions("instructions")
     *         .notApplicableEnabled(false)
     *         .questionTypeProperties(EvaluationFormQuestionTypePropertiesProperty.builder()
     *                 .numeric(EvaluationFormNumericQuestionPropertiesProperty.builder()
     *                         .maxValue(123)
     *                         .minValue(123)
     *                         // the properties below are optional
     *                         .automation(EvaluationFormNumericQuestionAutomationProperty.builder()
     *                                 .propertyValue(NumericQuestionPropertyValueAutomationProperty.builder()
     *                                         .label("label")
     *                                         .build())
     *                                 .build())
     *                         .options(List.of(EvaluationFormNumericQuestionOptionProperty.builder()
     *                                 .maxValue(123)
     *                                 .minValue(123)
     *                                 // the properties below are optional
     *                                 .automaticFail(false)
     *                                 .score(123)
     *                                 .build()))
     *                         .build())
     *                 .singleSelect(EvaluationFormSingleSelectQuestionPropertiesProperty.builder()
     *                         .options(List.of(EvaluationFormSingleSelectQuestionOptionProperty.builder()
     *                                 .refId("refId")
     *                                 .text("text")
     *                                 // the properties below are optional
     *                                 .automaticFail(false)
     *                                 .score(123)
     *                                 .build()))
     *                         // the properties below are optional
     *                         .automation(EvaluationFormSingleSelectQuestionAutomationProperty.builder()
     *                                 .options(List.of(EvaluationFormSingleSelectQuestionAutomationOptionProperty.builder()
     *                                         .ruleCategory(SingleSelectQuestionRuleCategoryAutomationProperty.builder()
     *                                                 .category("category")
     *                                                 .condition("condition")
     *                                                 .optionRefId("optionRefId")
     *                                                 .build())
     *                                         .build()))
     *                                 // the properties below are optional
     *                                 .defaultOptionRefId("defaultOptionRefId")
     *                                 .build())
     *                         .displayAs("displayAs")
     *                         .build())
     *                 .build())
     *         .weight(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformquestion.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformquestion.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormQuestionProperty")
    @software.amazon.jsii.Jsii.Proxy(EvaluationFormQuestionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EvaluationFormQuestionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of the question.
         * <p>
         * <em>Allowed values</em> : <code>NUMERIC</code> | <code>SINGLESELECT</code> | <code>TEXT</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformquestion.html#cfn-connect-evaluationform-evaluationformquestion-questiontype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformquestion.html#cfn-connect-evaluationform-evaluationformquestion-questiontype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getQuestionType();

        /**
         * The identifier of the question. An identifier must be unique within the evaluation form.
         * <p>
         * <em>Length Constraints</em> : Minimum length of 1. Maximum length of 40.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformquestion.html#cfn-connect-evaluationform-evaluationformquestion-refid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformquestion.html#cfn-connect-evaluationform-evaluationformquestion-refid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRefId();

        /**
         * The title of the question.
         * <p>
         * <em>Length Constraints</em> : Minimum length of 1. Maximum length of 350.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformquestion.html#cfn-connect-evaluationform-evaluationformquestion-title">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformquestion.html#cfn-connect-evaluationform-evaluationformquestion-title</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTitle();

        /**
         * The instructions of the section.
         * <p>
         * <em>Length Constraints</em> : Minimum length of 0. Maximum length of 1024.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformquestion.html#cfn-connect-evaluationform-evaluationformquestion-instructions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformquestion.html#cfn-connect-evaluationform-evaluationformquestion-instructions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInstructions() {
            return null;
        }

        /**
         * The flag to enable not applicable answers to the question.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformquestion.html#cfn-connect-evaluationform-evaluationformquestion-notapplicableenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformquestion.html#cfn-connect-evaluationform-evaluationformquestion-notapplicableenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNotApplicableEnabled() {
            return null;
        }

        /**
         * The properties of the type of question.
         * <p>
         * Text questions do not have to define question type properties.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformquestion.html#cfn-connect-evaluationform-evaluationformquestion-questiontypeproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformquestion.html#cfn-connect-evaluationform-evaluationformquestion-questiontypeproperties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getQuestionTypeProperties() {
            return null;
        }

        /**
         * The scoring weight of the section.
         * <p>
         * <em>Minimum</em> : 0
         * <p>
         * <em>Maximum</em> : 100
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformquestion.html#cfn-connect-evaluationform-evaluationformquestion-weight">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformquestion.html#cfn-connect-evaluationform-evaluationformquestion-weight</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getWeight() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EvaluationFormQuestionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EvaluationFormQuestionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EvaluationFormQuestionProperty> {
            java.lang.String questionType;
            java.lang.String refId;
            java.lang.String title;
            java.lang.String instructions;
            java.lang.Object notApplicableEnabled;
            java.lang.Object questionTypeProperties;
            java.lang.Number weight;

            /**
             * Sets the value of {@link EvaluationFormQuestionProperty#getQuestionType}
             * @param questionType The type of the question. This parameter is required.
             *                     <em>Allowed values</em> : <code>NUMERIC</code> | <code>SINGLESELECT</code> | <code>TEXT</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder questionType(java.lang.String questionType) {
                this.questionType = questionType;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormQuestionProperty#getRefId}
             * @param refId The identifier of the question. An identifier must be unique within the evaluation form. This parameter is required.
             *              <em>Length Constraints</em> : Minimum length of 1. Maximum length of 40.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder refId(java.lang.String refId) {
                this.refId = refId;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormQuestionProperty#getTitle}
             * @param title The title of the question. This parameter is required.
             *              <em>Length Constraints</em> : Minimum length of 1. Maximum length of 350.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder title(java.lang.String title) {
                this.title = title;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormQuestionProperty#getInstructions}
             * @param instructions The instructions of the section.
             *                     <em>Length Constraints</em> : Minimum length of 0. Maximum length of 1024.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instructions(java.lang.String instructions) {
                this.instructions = instructions;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormQuestionProperty#getNotApplicableEnabled}
             * @param notApplicableEnabled The flag to enable not applicable answers to the question.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder notApplicableEnabled(java.lang.Boolean notApplicableEnabled) {
                this.notApplicableEnabled = notApplicableEnabled;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormQuestionProperty#getNotApplicableEnabled}
             * @param notApplicableEnabled The flag to enable not applicable answers to the question.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder notApplicableEnabled(software.amazon.awscdk.IResolvable notApplicableEnabled) {
                this.notApplicableEnabled = notApplicableEnabled;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormQuestionProperty#getQuestionTypeProperties}
             * @param questionTypeProperties The properties of the type of question.
             *                               Text questions do not have to define question type properties.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder questionTypeProperties(software.amazon.awscdk.IResolvable questionTypeProperties) {
                this.questionTypeProperties = questionTypeProperties;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormQuestionProperty#getQuestionTypeProperties}
             * @param questionTypeProperties The properties of the type of question.
             *                               Text questions do not have to define question type properties.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder questionTypeProperties(software.amazon.awscdk.services.connect.CfnEvaluationForm.EvaluationFormQuestionTypePropertiesProperty questionTypeProperties) {
                this.questionTypeProperties = questionTypeProperties;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormQuestionProperty#getWeight}
             * @param weight The scoring weight of the section.
             *               <em>Minimum</em> : 0
             *               <p>
             *               <em>Maximum</em> : 100
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder weight(java.lang.Number weight) {
                this.weight = weight;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EvaluationFormQuestionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EvaluationFormQuestionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EvaluationFormQuestionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EvaluationFormQuestionProperty {
            private final java.lang.String questionType;
            private final java.lang.String refId;
            private final java.lang.String title;
            private final java.lang.String instructions;
            private final java.lang.Object notApplicableEnabled;
            private final java.lang.Object questionTypeProperties;
            private final java.lang.Number weight;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.questionType = software.amazon.jsii.Kernel.get(this, "questionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.refId = software.amazon.jsii.Kernel.get(this, "refId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.title = software.amazon.jsii.Kernel.get(this, "title", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.instructions = software.amazon.jsii.Kernel.get(this, "instructions", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.notApplicableEnabled = software.amazon.jsii.Kernel.get(this, "notApplicableEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.questionTypeProperties = software.amazon.jsii.Kernel.get(this, "questionTypeProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.weight = software.amazon.jsii.Kernel.get(this, "weight", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.questionType = java.util.Objects.requireNonNull(builder.questionType, "questionType is required");
                this.refId = java.util.Objects.requireNonNull(builder.refId, "refId is required");
                this.title = java.util.Objects.requireNonNull(builder.title, "title is required");
                this.instructions = builder.instructions;
                this.notApplicableEnabled = builder.notApplicableEnabled;
                this.questionTypeProperties = builder.questionTypeProperties;
                this.weight = builder.weight;
            }

            @Override
            public final java.lang.String getQuestionType() {
                return this.questionType;
            }

            @Override
            public final java.lang.String getRefId() {
                return this.refId;
            }

            @Override
            public final java.lang.String getTitle() {
                return this.title;
            }

            @Override
            public final java.lang.String getInstructions() {
                return this.instructions;
            }

            @Override
            public final java.lang.Object getNotApplicableEnabled() {
                return this.notApplicableEnabled;
            }

            @Override
            public final java.lang.Object getQuestionTypeProperties() {
                return this.questionTypeProperties;
            }

            @Override
            public final java.lang.Number getWeight() {
                return this.weight;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("questionType", om.valueToTree(this.getQuestionType()));
                data.set("refId", om.valueToTree(this.getRefId()));
                data.set("title", om.valueToTree(this.getTitle()));
                if (this.getInstructions() != null) {
                    data.set("instructions", om.valueToTree(this.getInstructions()));
                }
                if (this.getNotApplicableEnabled() != null) {
                    data.set("notApplicableEnabled", om.valueToTree(this.getNotApplicableEnabled()));
                }
                if (this.getQuestionTypeProperties() != null) {
                    data.set("questionTypeProperties", om.valueToTree(this.getQuestionTypeProperties()));
                }
                if (this.getWeight() != null) {
                    data.set("weight", om.valueToTree(this.getWeight()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormQuestionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EvaluationFormQuestionProperty.Jsii$Proxy that = (EvaluationFormQuestionProperty.Jsii$Proxy) o;

                if (!questionType.equals(that.questionType)) return false;
                if (!refId.equals(that.refId)) return false;
                if (!title.equals(that.title)) return false;
                if (this.instructions != null ? !this.instructions.equals(that.instructions) : that.instructions != null) return false;
                if (this.notApplicableEnabled != null ? !this.notApplicableEnabled.equals(that.notApplicableEnabled) : that.notApplicableEnabled != null) return false;
                if (this.questionTypeProperties != null ? !this.questionTypeProperties.equals(that.questionTypeProperties) : that.questionTypeProperties != null) return false;
                return this.weight != null ? this.weight.equals(that.weight) : that.weight == null;
            }

            @Override
            public final int hashCode() {
                int result = this.questionType.hashCode();
                result = 31 * result + (this.refId.hashCode());
                result = 31 * result + (this.title.hashCode());
                result = 31 * result + (this.instructions != null ? this.instructions.hashCode() : 0);
                result = 31 * result + (this.notApplicableEnabled != null ? this.notApplicableEnabled.hashCode() : 0);
                result = 31 * result + (this.questionTypeProperties != null ? this.questionTypeProperties.hashCode() : 0);
                result = 31 * result + (this.weight != null ? this.weight.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about properties for a question in an evaluation form.
     * <p>
     * The question type properties must be either for a numeric question or a single select question.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * EvaluationFormQuestionTypePropertiesProperty evaluationFormQuestionTypePropertiesProperty = EvaluationFormQuestionTypePropertiesProperty.builder()
     *         .numeric(EvaluationFormNumericQuestionPropertiesProperty.builder()
     *                 .maxValue(123)
     *                 .minValue(123)
     *                 // the properties below are optional
     *                 .automation(EvaluationFormNumericQuestionAutomationProperty.builder()
     *                         .propertyValue(NumericQuestionPropertyValueAutomationProperty.builder()
     *                                 .label("label")
     *                                 .build())
     *                         .build())
     *                 .options(List.of(EvaluationFormNumericQuestionOptionProperty.builder()
     *                         .maxValue(123)
     *                         .minValue(123)
     *                         // the properties below are optional
     *                         .automaticFail(false)
     *                         .score(123)
     *                         .build()))
     *                 .build())
     *         .singleSelect(EvaluationFormSingleSelectQuestionPropertiesProperty.builder()
     *                 .options(List.of(EvaluationFormSingleSelectQuestionOptionProperty.builder()
     *                         .refId("refId")
     *                         .text("text")
     *                         // the properties below are optional
     *                         .automaticFail(false)
     *                         .score(123)
     *                         .build()))
     *                 // the properties below are optional
     *                 .automation(EvaluationFormSingleSelectQuestionAutomationProperty.builder()
     *                         .options(List.of(EvaluationFormSingleSelectQuestionAutomationOptionProperty.builder()
     *                                 .ruleCategory(SingleSelectQuestionRuleCategoryAutomationProperty.builder()
     *                                         .category("category")
     *                                         .condition("condition")
     *                                         .optionRefId("optionRefId")
     *                                         .build())
     *                                 .build()))
     *                         // the properties below are optional
     *                         .defaultOptionRefId("defaultOptionRefId")
     *                         .build())
     *                 .displayAs("displayAs")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformquestiontypeproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformquestiontypeproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormQuestionTypePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(EvaluationFormQuestionTypePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EvaluationFormQuestionTypePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The properties of the numeric question.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformquestiontypeproperties.html#cfn-connect-evaluationform-evaluationformquestiontypeproperties-numeric">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformquestiontypeproperties.html#cfn-connect-evaluationform-evaluationformquestiontypeproperties-numeric</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNumeric() {
            return null;
        }

        /**
         * The properties of the numeric question.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformquestiontypeproperties.html#cfn-connect-evaluationform-evaluationformquestiontypeproperties-singleselect">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformquestiontypeproperties.html#cfn-connect-evaluationform-evaluationformquestiontypeproperties-singleselect</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSingleSelect() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EvaluationFormQuestionTypePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EvaluationFormQuestionTypePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EvaluationFormQuestionTypePropertiesProperty> {
            java.lang.Object numeric;
            java.lang.Object singleSelect;

            /**
             * Sets the value of {@link EvaluationFormQuestionTypePropertiesProperty#getNumeric}
             * @param numeric The properties of the numeric question.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder numeric(software.amazon.awscdk.IResolvable numeric) {
                this.numeric = numeric;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormQuestionTypePropertiesProperty#getNumeric}
             * @param numeric The properties of the numeric question.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder numeric(software.amazon.awscdk.services.connect.CfnEvaluationForm.EvaluationFormNumericQuestionPropertiesProperty numeric) {
                this.numeric = numeric;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormQuestionTypePropertiesProperty#getSingleSelect}
             * @param singleSelect The properties of the numeric question.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder singleSelect(software.amazon.awscdk.IResolvable singleSelect) {
                this.singleSelect = singleSelect;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormQuestionTypePropertiesProperty#getSingleSelect}
             * @param singleSelect The properties of the numeric question.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder singleSelect(software.amazon.awscdk.services.connect.CfnEvaluationForm.EvaluationFormSingleSelectQuestionPropertiesProperty singleSelect) {
                this.singleSelect = singleSelect;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EvaluationFormQuestionTypePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EvaluationFormQuestionTypePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EvaluationFormQuestionTypePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EvaluationFormQuestionTypePropertiesProperty {
            private final java.lang.Object numeric;
            private final java.lang.Object singleSelect;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.numeric = software.amazon.jsii.Kernel.get(this, "numeric", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.singleSelect = software.amazon.jsii.Kernel.get(this, "singleSelect", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.numeric = builder.numeric;
                this.singleSelect = builder.singleSelect;
            }

            @Override
            public final java.lang.Object getNumeric() {
                return this.numeric;
            }

            @Override
            public final java.lang.Object getSingleSelect() {
                return this.singleSelect;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getNumeric() != null) {
                    data.set("numeric", om.valueToTree(this.getNumeric()));
                }
                if (this.getSingleSelect() != null) {
                    data.set("singleSelect", om.valueToTree(this.getSingleSelect()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormQuestionTypePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EvaluationFormQuestionTypePropertiesProperty.Jsii$Proxy that = (EvaluationFormQuestionTypePropertiesProperty.Jsii$Proxy) o;

                if (this.numeric != null ? !this.numeric.equals(that.numeric) : that.numeric != null) return false;
                return this.singleSelect != null ? this.singleSelect.equals(that.singleSelect) : that.singleSelect == null;
            }

            @Override
            public final int hashCode() {
                int result = this.numeric != null ? this.numeric.hashCode() : 0;
                result = 31 * result + (this.singleSelect != null ? this.singleSelect.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about a section from an evaluation form.
     * <p>
     * A section can contain sections and/or questions. Evaluation forms can only contain sections and subsections (two level nesting).
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * EvaluationFormSectionProperty evaluationFormSectionProperty_;
     * EvaluationFormSectionProperty evaluationFormSectionProperty = EvaluationFormSectionProperty.builder()
     *         .refId("refId")
     *         .title("title")
     *         // the properties below are optional
     *         .instructions("instructions")
     *         .items(List.of(EvaluationFormItemProperty.builder()
     *                 .question(EvaluationFormQuestionProperty.builder()
     *                         .questionType("questionType")
     *                         .refId("refId")
     *                         .title("title")
     *                         // the properties below are optional
     *                         .instructions("instructions")
     *                         .notApplicableEnabled(false)
     *                         .questionTypeProperties(EvaluationFormQuestionTypePropertiesProperty.builder()
     *                                 .numeric(EvaluationFormNumericQuestionPropertiesProperty.builder()
     *                                         .maxValue(123)
     *                                         .minValue(123)
     *                                         // the properties below are optional
     *                                         .automation(EvaluationFormNumericQuestionAutomationProperty.builder()
     *                                                 .propertyValue(NumericQuestionPropertyValueAutomationProperty.builder()
     *                                                         .label("label")
     *                                                         .build())
     *                                                 .build())
     *                                         .options(List.of(EvaluationFormNumericQuestionOptionProperty.builder()
     *                                                 .maxValue(123)
     *                                                 .minValue(123)
     *                                                 // the properties below are optional
     *                                                 .automaticFail(false)
     *                                                 .score(123)
     *                                                 .build()))
     *                                         .build())
     *                                 .singleSelect(EvaluationFormSingleSelectQuestionPropertiesProperty.builder()
     *                                         .options(List.of(EvaluationFormSingleSelectQuestionOptionProperty.builder()
     *                                                 .refId("refId")
     *                                                 .text("text")
     *                                                 // the properties below are optional
     *                                                 .automaticFail(false)
     *                                                 .score(123)
     *                                                 .build()))
     *                                         // the properties below are optional
     *                                         .automation(EvaluationFormSingleSelectQuestionAutomationProperty.builder()
     *                                                 .options(List.of(EvaluationFormSingleSelectQuestionAutomationOptionProperty.builder()
     *                                                         .ruleCategory(SingleSelectQuestionRuleCategoryAutomationProperty.builder()
     *                                                                 .category("category")
     *                                                                 .condition("condition")
     *                                                                 .optionRefId("optionRefId")
     *                                                                 .build())
     *                                                         .build()))
     *                                                 // the properties below are optional
     *                                                 .defaultOptionRefId("defaultOptionRefId")
     *                                                 .build())
     *                                         .displayAs("displayAs")
     *                                         .build())
     *                                 .build())
     *                         .weight(123)
     *                         .build())
     *                 .section(evaluationFormSectionProperty_)
     *                 .build()))
     *         .weight(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsection.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsection.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormSectionProperty")
    @software.amazon.jsii.Jsii.Proxy(EvaluationFormSectionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EvaluationFormSectionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The identifier of the section. An identifier must be unique within the evaluation form.
         * <p>
         * <em>Length Constraints</em> : Minimum length of 1. Maximum length of 40.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsection.html#cfn-connect-evaluationform-evaluationformsection-refid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsection.html#cfn-connect-evaluationform-evaluationformsection-refid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRefId();

        /**
         * The title of the section.
         * <p>
         * <em>Length Constraints</em> : Minimum length of 1. Maximum length of 128.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsection.html#cfn-connect-evaluationform-evaluationformsection-title">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsection.html#cfn-connect-evaluationform-evaluationformsection-title</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTitle();

        /**
         * The instructions of the section.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsection.html#cfn-connect-evaluationform-evaluationformsection-instructions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsection.html#cfn-connect-evaluationform-evaluationformsection-instructions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInstructions() {
            return null;
        }

        /**
         * The items of the section.
         * <p>
         * <em>Minimum</em> : 1
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsection.html#cfn-connect-evaluationform-evaluationformsection-items">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsection.html#cfn-connect-evaluationform-evaluationformsection-items</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getItems() {
            return null;
        }

        /**
         * The scoring weight of the section.
         * <p>
         * <em>Minimum</em> : 0
         * <p>
         * <em>Maximum</em> : 100
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsection.html#cfn-connect-evaluationform-evaluationformsection-weight">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsection.html#cfn-connect-evaluationform-evaluationformsection-weight</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getWeight() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EvaluationFormSectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EvaluationFormSectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EvaluationFormSectionProperty> {
            java.lang.String refId;
            java.lang.String title;
            java.lang.String instructions;
            java.lang.Object items;
            java.lang.Number weight;

            /**
             * Sets the value of {@link EvaluationFormSectionProperty#getRefId}
             * @param refId The identifier of the section. An identifier must be unique within the evaluation form. This parameter is required.
             *              <em>Length Constraints</em> : Minimum length of 1. Maximum length of 40.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder refId(java.lang.String refId) {
                this.refId = refId;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormSectionProperty#getTitle}
             * @param title The title of the section. This parameter is required.
             *              <em>Length Constraints</em> : Minimum length of 1. Maximum length of 128.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder title(java.lang.String title) {
                this.title = title;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormSectionProperty#getInstructions}
             * @param instructions The instructions of the section.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instructions(java.lang.String instructions) {
                this.instructions = instructions;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormSectionProperty#getItems}
             * @param items The items of the section.
             *              <em>Minimum</em> : 1
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder items(software.amazon.awscdk.IResolvable items) {
                this.items = items;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormSectionProperty#getItems}
             * @param items The items of the section.
             *              <em>Minimum</em> : 1
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder items(java.util.List<? extends java.lang.Object> items) {
                this.items = items;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormSectionProperty#getWeight}
             * @param weight The scoring weight of the section.
             *               <em>Minimum</em> : 0
             *               <p>
             *               <em>Maximum</em> : 100
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder weight(java.lang.Number weight) {
                this.weight = weight;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EvaluationFormSectionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EvaluationFormSectionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EvaluationFormSectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EvaluationFormSectionProperty {
            private final java.lang.String refId;
            private final java.lang.String title;
            private final java.lang.String instructions;
            private final java.lang.Object items;
            private final java.lang.Number weight;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.refId = software.amazon.jsii.Kernel.get(this, "refId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.title = software.amazon.jsii.Kernel.get(this, "title", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.instructions = software.amazon.jsii.Kernel.get(this, "instructions", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.items = software.amazon.jsii.Kernel.get(this, "items", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.weight = software.amazon.jsii.Kernel.get(this, "weight", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.refId = java.util.Objects.requireNonNull(builder.refId, "refId is required");
                this.title = java.util.Objects.requireNonNull(builder.title, "title is required");
                this.instructions = builder.instructions;
                this.items = builder.items;
                this.weight = builder.weight;
            }

            @Override
            public final java.lang.String getRefId() {
                return this.refId;
            }

            @Override
            public final java.lang.String getTitle() {
                return this.title;
            }

            @Override
            public final java.lang.String getInstructions() {
                return this.instructions;
            }

            @Override
            public final java.lang.Object getItems() {
                return this.items;
            }

            @Override
            public final java.lang.Number getWeight() {
                return this.weight;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("refId", om.valueToTree(this.getRefId()));
                data.set("title", om.valueToTree(this.getTitle()));
                if (this.getInstructions() != null) {
                    data.set("instructions", om.valueToTree(this.getInstructions()));
                }
                if (this.getItems() != null) {
                    data.set("items", om.valueToTree(this.getItems()));
                }
                if (this.getWeight() != null) {
                    data.set("weight", om.valueToTree(this.getWeight()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormSectionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EvaluationFormSectionProperty.Jsii$Proxy that = (EvaluationFormSectionProperty.Jsii$Proxy) o;

                if (!refId.equals(that.refId)) return false;
                if (!title.equals(that.title)) return false;
                if (this.instructions != null ? !this.instructions.equals(that.instructions) : that.instructions != null) return false;
                if (this.items != null ? !this.items.equals(that.items) : that.items != null) return false;
                return this.weight != null ? this.weight.equals(that.weight) : that.weight == null;
            }

            @Override
            public final int hashCode() {
                int result = this.refId.hashCode();
                result = 31 * result + (this.title.hashCode());
                result = 31 * result + (this.instructions != null ? this.instructions.hashCode() : 0);
                result = 31 * result + (this.items != null ? this.items.hashCode() : 0);
                result = 31 * result + (this.weight != null ? this.weight.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The automation options of the single select question.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * EvaluationFormSingleSelectQuestionAutomationOptionProperty evaluationFormSingleSelectQuestionAutomationOptionProperty = EvaluationFormSingleSelectQuestionAutomationOptionProperty.builder()
     *         .ruleCategory(SingleSelectQuestionRuleCategoryAutomationProperty.builder()
     *                 .category("category")
     *                 .condition("condition")
     *                 .optionRefId("optionRefId")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsingleselectquestionautomationoption.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsingleselectquestionautomationoption.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormSingleSelectQuestionAutomationOptionProperty")
    @software.amazon.jsii.Jsii.Proxy(EvaluationFormSingleSelectQuestionAutomationOptionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EvaluationFormSingleSelectQuestionAutomationOptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The automation option based on a rule category for the single select question.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsingleselectquestionautomationoption.html#cfn-connect-evaluationform-evaluationformsingleselectquestionautomationoption-rulecategory">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsingleselectquestionautomationoption.html#cfn-connect-evaluationform-evaluationformsingleselectquestionautomationoption-rulecategory</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getRuleCategory();

        /**
         * @return a {@link Builder} of {@link EvaluationFormSingleSelectQuestionAutomationOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EvaluationFormSingleSelectQuestionAutomationOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EvaluationFormSingleSelectQuestionAutomationOptionProperty> {
            java.lang.Object ruleCategory;

            /**
             * Sets the value of {@link EvaluationFormSingleSelectQuestionAutomationOptionProperty#getRuleCategory}
             * @param ruleCategory The automation option based on a rule category for the single select question. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ruleCategory(software.amazon.awscdk.IResolvable ruleCategory) {
                this.ruleCategory = ruleCategory;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormSingleSelectQuestionAutomationOptionProperty#getRuleCategory}
             * @param ruleCategory The automation option based on a rule category for the single select question. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ruleCategory(software.amazon.awscdk.services.connect.CfnEvaluationForm.SingleSelectQuestionRuleCategoryAutomationProperty ruleCategory) {
                this.ruleCategory = ruleCategory;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EvaluationFormSingleSelectQuestionAutomationOptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EvaluationFormSingleSelectQuestionAutomationOptionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EvaluationFormSingleSelectQuestionAutomationOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EvaluationFormSingleSelectQuestionAutomationOptionProperty {
            private final java.lang.Object ruleCategory;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.ruleCategory = software.amazon.jsii.Kernel.get(this, "ruleCategory", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ruleCategory = java.util.Objects.requireNonNull(builder.ruleCategory, "ruleCategory is required");
            }

            @Override
            public final java.lang.Object getRuleCategory() {
                return this.ruleCategory;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("ruleCategory", om.valueToTree(this.getRuleCategory()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormSingleSelectQuestionAutomationOptionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EvaluationFormSingleSelectQuestionAutomationOptionProperty.Jsii$Proxy that = (EvaluationFormSingleSelectQuestionAutomationOptionProperty.Jsii$Proxy) o;

                return this.ruleCategory.equals(that.ruleCategory);
            }

            @Override
            public final int hashCode() {
                int result = this.ruleCategory.hashCode();
                return result;
            }
        }
    }
    /**
     * Information about the automation configuration in single select questions.
     * <p>
     * Automation options are evaluated in order, and the first matched option is applied. If no automation option matches, and there is a default option, then the default option is applied.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * EvaluationFormSingleSelectQuestionAutomationProperty evaluationFormSingleSelectQuestionAutomationProperty = EvaluationFormSingleSelectQuestionAutomationProperty.builder()
     *         .options(List.of(EvaluationFormSingleSelectQuestionAutomationOptionProperty.builder()
     *                 .ruleCategory(SingleSelectQuestionRuleCategoryAutomationProperty.builder()
     *                         .category("category")
     *                         .condition("condition")
     *                         .optionRefId("optionRefId")
     *                         .build())
     *                 .build()))
     *         // the properties below are optional
     *         .defaultOptionRefId("defaultOptionRefId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsingleselectquestionautomation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsingleselectquestionautomation.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormSingleSelectQuestionAutomationProperty")
    @software.amazon.jsii.Jsii.Proxy(EvaluationFormSingleSelectQuestionAutomationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EvaluationFormSingleSelectQuestionAutomationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The automation options of the single select question.
         * <p>
         * <em>Minimum</em> : 1
         * <p>
         * <em>Maximum</em> : 20
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsingleselectquestionautomation.html#cfn-connect-evaluationform-evaluationformsingleselectquestionautomation-options">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsingleselectquestionautomation.html#cfn-connect-evaluationform-evaluationformsingleselectquestionautomation-options</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getOptions();

        /**
         * The identifier of the default answer option, when none of the automation options match the criteria.
         * <p>
         * <em>Length Constraints</em> : Minimum length of 1. Maximum length of 40.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsingleselectquestionautomation.html#cfn-connect-evaluationform-evaluationformsingleselectquestionautomation-defaultoptionrefid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsingleselectquestionautomation.html#cfn-connect-evaluationform-evaluationformsingleselectquestionautomation-defaultoptionrefid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDefaultOptionRefId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EvaluationFormSingleSelectQuestionAutomationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EvaluationFormSingleSelectQuestionAutomationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EvaluationFormSingleSelectQuestionAutomationProperty> {
            java.lang.Object options;
            java.lang.String defaultOptionRefId;

            /**
             * Sets the value of {@link EvaluationFormSingleSelectQuestionAutomationProperty#getOptions}
             * @param options The automation options of the single select question. This parameter is required.
             *                <em>Minimum</em> : 1
             *                <p>
             *                <em>Maximum</em> : 20
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder options(software.amazon.awscdk.IResolvable options) {
                this.options = options;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormSingleSelectQuestionAutomationProperty#getOptions}
             * @param options The automation options of the single select question. This parameter is required.
             *                <em>Minimum</em> : 1
             *                <p>
             *                <em>Maximum</em> : 20
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder options(java.util.List<? extends java.lang.Object> options) {
                this.options = options;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormSingleSelectQuestionAutomationProperty#getDefaultOptionRefId}
             * @param defaultOptionRefId The identifier of the default answer option, when none of the automation options match the criteria.
             *                           <em>Length Constraints</em> : Minimum length of 1. Maximum length of 40.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultOptionRefId(java.lang.String defaultOptionRefId) {
                this.defaultOptionRefId = defaultOptionRefId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EvaluationFormSingleSelectQuestionAutomationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EvaluationFormSingleSelectQuestionAutomationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EvaluationFormSingleSelectQuestionAutomationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EvaluationFormSingleSelectQuestionAutomationProperty {
            private final java.lang.Object options;
            private final java.lang.String defaultOptionRefId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.options = software.amazon.jsii.Kernel.get(this, "options", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.defaultOptionRefId = software.amazon.jsii.Kernel.get(this, "defaultOptionRefId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.options = java.util.Objects.requireNonNull(builder.options, "options is required");
                this.defaultOptionRefId = builder.defaultOptionRefId;
            }

            @Override
            public final java.lang.Object getOptions() {
                return this.options;
            }

            @Override
            public final java.lang.String getDefaultOptionRefId() {
                return this.defaultOptionRefId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("options", om.valueToTree(this.getOptions()));
                if (this.getDefaultOptionRefId() != null) {
                    data.set("defaultOptionRefId", om.valueToTree(this.getDefaultOptionRefId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormSingleSelectQuestionAutomationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EvaluationFormSingleSelectQuestionAutomationProperty.Jsii$Proxy that = (EvaluationFormSingleSelectQuestionAutomationProperty.Jsii$Proxy) o;

                if (!options.equals(that.options)) return false;
                return this.defaultOptionRefId != null ? this.defaultOptionRefId.equals(that.defaultOptionRefId) : that.defaultOptionRefId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.options.hashCode();
                result = 31 * result + (this.defaultOptionRefId != null ? this.defaultOptionRefId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about the automation configuration in single select questions.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * EvaluationFormSingleSelectQuestionOptionProperty evaluationFormSingleSelectQuestionOptionProperty = EvaluationFormSingleSelectQuestionOptionProperty.builder()
     *         .refId("refId")
     *         .text("text")
     *         // the properties below are optional
     *         .automaticFail(false)
     *         .score(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsingleselectquestionoption.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsingleselectquestionoption.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormSingleSelectQuestionOptionProperty")
    @software.amazon.jsii.Jsii.Proxy(EvaluationFormSingleSelectQuestionOptionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EvaluationFormSingleSelectQuestionOptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The identifier of the answer option. An identifier must be unique within the question.
         * <p>
         * <em>Length Constraints</em> : Minimum length of 1. Maximum length of 40.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsingleselectquestionoption.html#cfn-connect-evaluationform-evaluationformsingleselectquestionoption-refid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsingleselectquestionoption.html#cfn-connect-evaluationform-evaluationformsingleselectquestionoption-refid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRefId();

        /**
         * The title of the answer option.
         * <p>
         * <em>Length Constraints</em> : Minimum length of 1. Maximum length of 128.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsingleselectquestionoption.html#cfn-connect-evaluationform-evaluationformsingleselectquestionoption-text">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsingleselectquestionoption.html#cfn-connect-evaluationform-evaluationformsingleselectquestionoption-text</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getText();

        /**
         * The flag to mark the option as automatic fail.
         * <p>
         * If an automatic fail answer is provided, the overall evaluation gets a score of 0.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsingleselectquestionoption.html#cfn-connect-evaluationform-evaluationformsingleselectquestionoption-automaticfail">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsingleselectquestionoption.html#cfn-connect-evaluationform-evaluationformsingleselectquestionoption-automaticfail</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAutomaticFail() {
            return null;
        }

        /**
         * The score assigned to the answer option.
         * <p>
         * <em>Minimum</em> : 0
         * <p>
         * <em>Maximum</em> : 10
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsingleselectquestionoption.html#cfn-connect-evaluationform-evaluationformsingleselectquestionoption-score">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsingleselectquestionoption.html#cfn-connect-evaluationform-evaluationformsingleselectquestionoption-score</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getScore() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EvaluationFormSingleSelectQuestionOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EvaluationFormSingleSelectQuestionOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EvaluationFormSingleSelectQuestionOptionProperty> {
            java.lang.String refId;
            java.lang.String text;
            java.lang.Object automaticFail;
            java.lang.Number score;

            /**
             * Sets the value of {@link EvaluationFormSingleSelectQuestionOptionProperty#getRefId}
             * @param refId The identifier of the answer option. An identifier must be unique within the question. This parameter is required.
             *              <em>Length Constraints</em> : Minimum length of 1. Maximum length of 40.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder refId(java.lang.String refId) {
                this.refId = refId;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormSingleSelectQuestionOptionProperty#getText}
             * @param text The title of the answer option. This parameter is required.
             *             <em>Length Constraints</em> : Minimum length of 1. Maximum length of 128.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder text(java.lang.String text) {
                this.text = text;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormSingleSelectQuestionOptionProperty#getAutomaticFail}
             * @param automaticFail The flag to mark the option as automatic fail.
             *                      If an automatic fail answer is provided, the overall evaluation gets a score of 0.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder automaticFail(java.lang.Boolean automaticFail) {
                this.automaticFail = automaticFail;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormSingleSelectQuestionOptionProperty#getAutomaticFail}
             * @param automaticFail The flag to mark the option as automatic fail.
             *                      If an automatic fail answer is provided, the overall evaluation gets a score of 0.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder automaticFail(software.amazon.awscdk.IResolvable automaticFail) {
                this.automaticFail = automaticFail;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormSingleSelectQuestionOptionProperty#getScore}
             * @param score The score assigned to the answer option.
             *              <em>Minimum</em> : 0
             *              <p>
             *              <em>Maximum</em> : 10
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder score(java.lang.Number score) {
                this.score = score;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EvaluationFormSingleSelectQuestionOptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EvaluationFormSingleSelectQuestionOptionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EvaluationFormSingleSelectQuestionOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EvaluationFormSingleSelectQuestionOptionProperty {
            private final java.lang.String refId;
            private final java.lang.String text;
            private final java.lang.Object automaticFail;
            private final java.lang.Number score;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.refId = software.amazon.jsii.Kernel.get(this, "refId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.text = software.amazon.jsii.Kernel.get(this, "text", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.automaticFail = software.amazon.jsii.Kernel.get(this, "automaticFail", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.score = software.amazon.jsii.Kernel.get(this, "score", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.refId = java.util.Objects.requireNonNull(builder.refId, "refId is required");
                this.text = java.util.Objects.requireNonNull(builder.text, "text is required");
                this.automaticFail = builder.automaticFail;
                this.score = builder.score;
            }

            @Override
            public final java.lang.String getRefId() {
                return this.refId;
            }

            @Override
            public final java.lang.String getText() {
                return this.text;
            }

            @Override
            public final java.lang.Object getAutomaticFail() {
                return this.automaticFail;
            }

            @Override
            public final java.lang.Number getScore() {
                return this.score;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("refId", om.valueToTree(this.getRefId()));
                data.set("text", om.valueToTree(this.getText()));
                if (this.getAutomaticFail() != null) {
                    data.set("automaticFail", om.valueToTree(this.getAutomaticFail()));
                }
                if (this.getScore() != null) {
                    data.set("score", om.valueToTree(this.getScore()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormSingleSelectQuestionOptionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EvaluationFormSingleSelectQuestionOptionProperty.Jsii$Proxy that = (EvaluationFormSingleSelectQuestionOptionProperty.Jsii$Proxy) o;

                if (!refId.equals(that.refId)) return false;
                if (!text.equals(that.text)) return false;
                if (this.automaticFail != null ? !this.automaticFail.equals(that.automaticFail) : that.automaticFail != null) return false;
                return this.score != null ? this.score.equals(that.score) : that.score == null;
            }

            @Override
            public final int hashCode() {
                int result = this.refId.hashCode();
                result = 31 * result + (this.text.hashCode());
                result = 31 * result + (this.automaticFail != null ? this.automaticFail.hashCode() : 0);
                result = 31 * result + (this.score != null ? this.score.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about the options in single select questions.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * EvaluationFormSingleSelectQuestionPropertiesProperty evaluationFormSingleSelectQuestionPropertiesProperty = EvaluationFormSingleSelectQuestionPropertiesProperty.builder()
     *         .options(List.of(EvaluationFormSingleSelectQuestionOptionProperty.builder()
     *                 .refId("refId")
     *                 .text("text")
     *                 // the properties below are optional
     *                 .automaticFail(false)
     *                 .score(123)
     *                 .build()))
     *         // the properties below are optional
     *         .automation(EvaluationFormSingleSelectQuestionAutomationProperty.builder()
     *                 .options(List.of(EvaluationFormSingleSelectQuestionAutomationOptionProperty.builder()
     *                         .ruleCategory(SingleSelectQuestionRuleCategoryAutomationProperty.builder()
     *                                 .category("category")
     *                                 .condition("condition")
     *                                 .optionRefId("optionRefId")
     *                                 .build())
     *                         .build()))
     *                 // the properties below are optional
     *                 .defaultOptionRefId("defaultOptionRefId")
     *                 .build())
     *         .displayAs("displayAs")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsingleselectquestionproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsingleselectquestionproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormSingleSelectQuestionPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(EvaluationFormSingleSelectQuestionPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EvaluationFormSingleSelectQuestionPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The answer options of the single select question.
         * <p>
         * <em>Minimum</em> : 2
         * <p>
         * <em>Maximum</em> : 256
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsingleselectquestionproperties.html#cfn-connect-evaluationform-evaluationformsingleselectquestionproperties-options">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsingleselectquestionproperties.html#cfn-connect-evaluationform-evaluationformsingleselectquestionproperties-options</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getOptions();

        /**
         * The display mode of the single select question.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsingleselectquestionproperties.html#cfn-connect-evaluationform-evaluationformsingleselectquestionproperties-automation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsingleselectquestionproperties.html#cfn-connect-evaluationform-evaluationformsingleselectquestionproperties-automation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAutomation() {
            return null;
        }

        /**
         * The display mode of the single select question.
         * <p>
         * <em>Allowed values</em> : <code>DROPDOWN</code> | <code>RADIO</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsingleselectquestionproperties.html#cfn-connect-evaluationform-evaluationformsingleselectquestionproperties-displayas">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsingleselectquestionproperties.html#cfn-connect-evaluationform-evaluationformsingleselectquestionproperties-displayas</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDisplayAs() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EvaluationFormSingleSelectQuestionPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EvaluationFormSingleSelectQuestionPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EvaluationFormSingleSelectQuestionPropertiesProperty> {
            java.lang.Object options;
            java.lang.Object automation;
            java.lang.String displayAs;

            /**
             * Sets the value of {@link EvaluationFormSingleSelectQuestionPropertiesProperty#getOptions}
             * @param options The answer options of the single select question. This parameter is required.
             *                <em>Minimum</em> : 2
             *                <p>
             *                <em>Maximum</em> : 256
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder options(software.amazon.awscdk.IResolvable options) {
                this.options = options;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormSingleSelectQuestionPropertiesProperty#getOptions}
             * @param options The answer options of the single select question. This parameter is required.
             *                <em>Minimum</em> : 2
             *                <p>
             *                <em>Maximum</em> : 256
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder options(java.util.List<? extends java.lang.Object> options) {
                this.options = options;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormSingleSelectQuestionPropertiesProperty#getAutomation}
             * @param automation The display mode of the single select question.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder automation(software.amazon.awscdk.IResolvable automation) {
                this.automation = automation;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormSingleSelectQuestionPropertiesProperty#getAutomation}
             * @param automation The display mode of the single select question.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder automation(software.amazon.awscdk.services.connect.CfnEvaluationForm.EvaluationFormSingleSelectQuestionAutomationProperty automation) {
                this.automation = automation;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormSingleSelectQuestionPropertiesProperty#getDisplayAs}
             * @param displayAs The display mode of the single select question.
             *                  <em>Allowed values</em> : <code>DROPDOWN</code> | <code>RADIO</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder displayAs(java.lang.String displayAs) {
                this.displayAs = displayAs;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EvaluationFormSingleSelectQuestionPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EvaluationFormSingleSelectQuestionPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EvaluationFormSingleSelectQuestionPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EvaluationFormSingleSelectQuestionPropertiesProperty {
            private final java.lang.Object options;
            private final java.lang.Object automation;
            private final java.lang.String displayAs;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.options = software.amazon.jsii.Kernel.get(this, "options", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.automation = software.amazon.jsii.Kernel.get(this, "automation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.displayAs = software.amazon.jsii.Kernel.get(this, "displayAs", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.options = java.util.Objects.requireNonNull(builder.options, "options is required");
                this.automation = builder.automation;
                this.displayAs = builder.displayAs;
            }

            @Override
            public final java.lang.Object getOptions() {
                return this.options;
            }

            @Override
            public final java.lang.Object getAutomation() {
                return this.automation;
            }

            @Override
            public final java.lang.String getDisplayAs() {
                return this.displayAs;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("options", om.valueToTree(this.getOptions()));
                if (this.getAutomation() != null) {
                    data.set("automation", om.valueToTree(this.getAutomation()));
                }
                if (this.getDisplayAs() != null) {
                    data.set("displayAs", om.valueToTree(this.getDisplayAs()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormSingleSelectQuestionPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EvaluationFormSingleSelectQuestionPropertiesProperty.Jsii$Proxy that = (EvaluationFormSingleSelectQuestionPropertiesProperty.Jsii$Proxy) o;

                if (!options.equals(that.options)) return false;
                if (this.automation != null ? !this.automation.equals(that.automation) : that.automation != null) return false;
                return this.displayAs != null ? this.displayAs.equals(that.displayAs) : that.displayAs == null;
            }

            @Override
            public final int hashCode() {
                int result = this.options.hashCode();
                result = 31 * result + (this.automation != null ? this.automation.hashCode() : 0);
                result = 31 * result + (this.displayAs != null ? this.displayAs.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about the property value used in automation of a numeric questions.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * NumericQuestionPropertyValueAutomationProperty numericQuestionPropertyValueAutomationProperty = NumericQuestionPropertyValueAutomationProperty.builder()
     *         .label("label")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-numericquestionpropertyvalueautomation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-numericquestionpropertyvalueautomation.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnEvaluationForm.NumericQuestionPropertyValueAutomationProperty")
    @software.amazon.jsii.Jsii.Proxy(NumericQuestionPropertyValueAutomationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NumericQuestionPropertyValueAutomationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The property label of the automation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-numericquestionpropertyvalueautomation.html#cfn-connect-evaluationform-numericquestionpropertyvalueautomation-label">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-numericquestionpropertyvalueautomation.html#cfn-connect-evaluationform-numericquestionpropertyvalueautomation-label</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLabel();

        /**
         * @return a {@link Builder} of {@link NumericQuestionPropertyValueAutomationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NumericQuestionPropertyValueAutomationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NumericQuestionPropertyValueAutomationProperty> {
            java.lang.String label;

            /**
             * Sets the value of {@link NumericQuestionPropertyValueAutomationProperty#getLabel}
             * @param label The property label of the automation. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder label(java.lang.String label) {
                this.label = label;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NumericQuestionPropertyValueAutomationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NumericQuestionPropertyValueAutomationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NumericQuestionPropertyValueAutomationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NumericQuestionPropertyValueAutomationProperty {
            private final java.lang.String label;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.label = software.amazon.jsii.Kernel.get(this, "label", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.label = java.util.Objects.requireNonNull(builder.label, "label is required");
            }

            @Override
            public final java.lang.String getLabel() {
                return this.label;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("label", om.valueToTree(this.getLabel()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnEvaluationForm.NumericQuestionPropertyValueAutomationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NumericQuestionPropertyValueAutomationProperty.Jsii$Proxy that = (NumericQuestionPropertyValueAutomationProperty.Jsii$Proxy) o;

                return this.label.equals(that.label);
            }

            @Override
            public final int hashCode() {
                int result = this.label.hashCode();
                return result;
            }
        }
    }
    /**
     * A scoring strategy of the evaluation form.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * ScoringStrategyProperty scoringStrategyProperty = ScoringStrategyProperty.builder()
     *         .mode("mode")
     *         .status("status")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-scoringstrategy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-scoringstrategy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnEvaluationForm.ScoringStrategyProperty")
    @software.amazon.jsii.Jsii.Proxy(ScoringStrategyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ScoringStrategyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The scoring mode of the evaluation form.
         * <p>
         * <em>Allowed values</em> : <code>QUESTION_ONLY</code> | <code>SECTION_ONLY</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-scoringstrategy.html#cfn-connect-evaluationform-scoringstrategy-mode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-scoringstrategy.html#cfn-connect-evaluationform-scoringstrategy-mode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMode();

        /**
         * The scoring status of the evaluation form.
         * <p>
         * <em>Allowed values</em> : <code>ENABLED</code> | <code>DISABLED</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-scoringstrategy.html#cfn-connect-evaluationform-scoringstrategy-status">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-scoringstrategy.html#cfn-connect-evaluationform-scoringstrategy-status</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStatus();

        /**
         * @return a {@link Builder} of {@link ScoringStrategyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScoringStrategyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ScoringStrategyProperty> {
            java.lang.String mode;
            java.lang.String status;

            /**
             * Sets the value of {@link ScoringStrategyProperty#getMode}
             * @param mode The scoring mode of the evaluation form. This parameter is required.
             *             <em>Allowed values</em> : <code>QUESTION_ONLY</code> | <code>SECTION_ONLY</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mode(java.lang.String mode) {
                this.mode = mode;
                return this;
            }

            /**
             * Sets the value of {@link ScoringStrategyProperty#getStatus}
             * @param status The scoring status of the evaluation form. This parameter is required.
             *               <em>Allowed values</em> : <code>ENABLED</code> | <code>DISABLED</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScoringStrategyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ScoringStrategyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ScoringStrategyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScoringStrategyProperty {
            private final java.lang.String mode;
            private final java.lang.String status;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.mode = software.amazon.jsii.Kernel.get(this, "mode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.mode = java.util.Objects.requireNonNull(builder.mode, "mode is required");
                this.status = java.util.Objects.requireNonNull(builder.status, "status is required");
            }

            @Override
            public final java.lang.String getMode() {
                return this.mode;
            }

            @Override
            public final java.lang.String getStatus() {
                return this.status;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("mode", om.valueToTree(this.getMode()));
                data.set("status", om.valueToTree(this.getStatus()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnEvaluationForm.ScoringStrategyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScoringStrategyProperty.Jsii$Proxy that = (ScoringStrategyProperty.Jsii$Proxy) o;

                if (!mode.equals(that.mode)) return false;
                return this.status.equals(that.status);
            }

            @Override
            public final int hashCode() {
                int result = this.mode.hashCode();
                result = 31 * result + (this.status.hashCode());
                return result;
            }
        }
    }
    /**
     * Information about the automation option based on a rule category for a single select question.
     * <p>
     * <em>Length Constraints</em> : Minimum length of 1. Maximum length of 50.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * SingleSelectQuestionRuleCategoryAutomationProperty singleSelectQuestionRuleCategoryAutomationProperty = SingleSelectQuestionRuleCategoryAutomationProperty.builder()
     *         .category("category")
     *         .condition("condition")
     *         .optionRefId("optionRefId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-singleselectquestionrulecategoryautomation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-singleselectquestionrulecategoryautomation.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnEvaluationForm.SingleSelectQuestionRuleCategoryAutomationProperty")
    @software.amazon.jsii.Jsii.Proxy(SingleSelectQuestionRuleCategoryAutomationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SingleSelectQuestionRuleCategoryAutomationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The category name, as defined in Rules.
         * <p>
         * <em>Minimum</em> : 1
         * <p>
         * <em>Maximum</em> : 50
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-singleselectquestionrulecategoryautomation.html#cfn-connect-evaluationform-singleselectquestionrulecategoryautomation-category">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-singleselectquestionrulecategoryautomation.html#cfn-connect-evaluationform-singleselectquestionrulecategoryautomation-category</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCategory();

        /**
         * The condition to apply for the automation option.
         * <p>
         * If the condition is PRESENT, then the option is applied when the contact data includes the category. Similarly, if the condition is NOT_PRESENT, then the option is applied when the contact data does not include the category.
         * <p>
         * <em>Allowed values</em> : <code>PRESENT</code> | <code>NOT_PRESENT</code>
         * <p>
         * <em>Maximum</em> : 50
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-singleselectquestionrulecategoryautomation.html#cfn-connect-evaluationform-singleselectquestionrulecategoryautomation-condition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-singleselectquestionrulecategoryautomation.html#cfn-connect-evaluationform-singleselectquestionrulecategoryautomation-condition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCondition();

        /**
         * The identifier of the answer option. An identifier must be unique within the question.
         * <p>
         * <em>Length Constraints</em> : Minimum length of 1. Maximum length of 40.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-singleselectquestionrulecategoryautomation.html#cfn-connect-evaluationform-singleselectquestionrulecategoryautomation-optionrefid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-singleselectquestionrulecategoryautomation.html#cfn-connect-evaluationform-singleselectquestionrulecategoryautomation-optionrefid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOptionRefId();

        /**
         * @return a {@link Builder} of {@link SingleSelectQuestionRuleCategoryAutomationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SingleSelectQuestionRuleCategoryAutomationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SingleSelectQuestionRuleCategoryAutomationProperty> {
            java.lang.String category;
            java.lang.String condition;
            java.lang.String optionRefId;

            /**
             * Sets the value of {@link SingleSelectQuestionRuleCategoryAutomationProperty#getCategory}
             * @param category The category name, as defined in Rules. This parameter is required.
             *                 <em>Minimum</em> : 1
             *                 <p>
             *                 <em>Maximum</em> : 50
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder category(java.lang.String category) {
                this.category = category;
                return this;
            }

            /**
             * Sets the value of {@link SingleSelectQuestionRuleCategoryAutomationProperty#getCondition}
             * @param condition The condition to apply for the automation option. This parameter is required.
             *                  If the condition is PRESENT, then the option is applied when the contact data includes the category. Similarly, if the condition is NOT_PRESENT, then the option is applied when the contact data does not include the category.
             *                  <p>
             *                  <em>Allowed values</em> : <code>PRESENT</code> | <code>NOT_PRESENT</code>
             *                  <p>
             *                  <em>Maximum</em> : 50
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder condition(java.lang.String condition) {
                this.condition = condition;
                return this;
            }

            /**
             * Sets the value of {@link SingleSelectQuestionRuleCategoryAutomationProperty#getOptionRefId}
             * @param optionRefId The identifier of the answer option. An identifier must be unique within the question. This parameter is required.
             *                    <em>Length Constraints</em> : Minimum length of 1. Maximum length of 40.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder optionRefId(java.lang.String optionRefId) {
                this.optionRefId = optionRefId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SingleSelectQuestionRuleCategoryAutomationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SingleSelectQuestionRuleCategoryAutomationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SingleSelectQuestionRuleCategoryAutomationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SingleSelectQuestionRuleCategoryAutomationProperty {
            private final java.lang.String category;
            private final java.lang.String condition;
            private final java.lang.String optionRefId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.category = software.amazon.jsii.Kernel.get(this, "category", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.condition = software.amazon.jsii.Kernel.get(this, "condition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.optionRefId = software.amazon.jsii.Kernel.get(this, "optionRefId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.category = java.util.Objects.requireNonNull(builder.category, "category is required");
                this.condition = java.util.Objects.requireNonNull(builder.condition, "condition is required");
                this.optionRefId = java.util.Objects.requireNonNull(builder.optionRefId, "optionRefId is required");
            }

            @Override
            public final java.lang.String getCategory() {
                return this.category;
            }

            @Override
            public final java.lang.String getCondition() {
                return this.condition;
            }

            @Override
            public final java.lang.String getOptionRefId() {
                return this.optionRefId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("category", om.valueToTree(this.getCategory()));
                data.set("condition", om.valueToTree(this.getCondition()));
                data.set("optionRefId", om.valueToTree(this.getOptionRefId()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnEvaluationForm.SingleSelectQuestionRuleCategoryAutomationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SingleSelectQuestionRuleCategoryAutomationProperty.Jsii$Proxy that = (SingleSelectQuestionRuleCategoryAutomationProperty.Jsii$Proxy) o;

                if (!category.equals(that.category)) return false;
                if (!condition.equals(that.condition)) return false;
                return this.optionRefId.equals(that.optionRefId);
            }

            @Override
            public final int hashCode() {
                int result = this.category.hashCode();
                result = 31 * result + (this.condition.hashCode());
                result = 31 * result + (this.optionRefId.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.connect.CfnEvaluationForm}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.connect.CfnEvaluationForm> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.connect.CfnEvaluationFormProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.connect.CfnEvaluationFormProps.Builder();
        }

        /**
         * The identifier of the Amazon Connect instance.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html#cfn-connect-evaluationform-instancearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html#cfn-connect-evaluationform-instancearn</a>
         * @param instanceArn The identifier of the Amazon Connect instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceArn(final java.lang.String instanceArn) {
            this.props.instanceArn(instanceArn);
            return this;
        }

        /**
         * Items that are part of the evaluation form.
         * <p>
         * The total number of sections and questions must not exceed 100 each. Questions must be contained in a section.
         * <p>
         * <em>Minimum size</em> : 1
         * <p>
         * <em>Maximum size</em> : 100
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html#cfn-connect-evaluationform-items">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html#cfn-connect-evaluationform-items</a>
         * @param items Items that are part of the evaluation form. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder items(final software.amazon.awscdk.IResolvable items) {
            this.props.items(items);
            return this;
        }
        /**
         * Items that are part of the evaluation form.
         * <p>
         * The total number of sections and questions must not exceed 100 each. Questions must be contained in a section.
         * <p>
         * <em>Minimum size</em> : 1
         * <p>
         * <em>Maximum size</em> : 100
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html#cfn-connect-evaluationform-items">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html#cfn-connect-evaluationform-items</a>
         * @param items Items that are part of the evaluation form. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder items(final java.util.List<? extends java.lang.Object> items) {
            this.props.items(items);
            return this;
        }

        /**
         * The status of the evaluation form.
         * <p>
         * <em>Allowed values</em> : <code>DRAFT</code> | <code>ACTIVE</code>
         * <p>
         * Default: - "DRAFT"
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html#cfn-connect-evaluationform-status">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html#cfn-connect-evaluationform-status</a>
         * @param status The status of the evaluation form. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder status(final java.lang.String status) {
            this.props.status(status);
            return this;
        }

        /**
         * A title of the evaluation form.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html#cfn-connect-evaluationform-title">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html#cfn-connect-evaluationform-title</a>
         * @param title A title of the evaluation form. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder title(final java.lang.String title) {
            this.props.title(title);
            return this;
        }

        /**
         * The description of the evaluation form.
         * <p>
         * <em>Length Constraints</em> : Minimum length of 0. Maximum length of 1024.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html#cfn-connect-evaluationform-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html#cfn-connect-evaluationform-description</a>
         * @param description The description of the evaluation form. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * A scoring strategy of the evaluation form.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html#cfn-connect-evaluationform-scoringstrategy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html#cfn-connect-evaluationform-scoringstrategy</a>
         * @param scoringStrategy A scoring strategy of the evaluation form. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scoringStrategy(final software.amazon.awscdk.IResolvable scoringStrategy) {
            this.props.scoringStrategy(scoringStrategy);
            return this;
        }
        /**
         * A scoring strategy of the evaluation form.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html#cfn-connect-evaluationform-scoringstrategy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html#cfn-connect-evaluationform-scoringstrategy</a>
         * @param scoringStrategy A scoring strategy of the evaluation form. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scoringStrategy(final software.amazon.awscdk.services.connect.CfnEvaluationForm.ScoringStrategyProperty scoringStrategy) {
            this.props.scoringStrategy(scoringStrategy);
            return this;
        }

        /**
         * The tags used to organize, track, or control access for this resource.
         * <p>
         * For example, { "tags": {"key1":"value1", "key2":"value2"} }.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html#cfn-connect-evaluationform-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html#cfn-connect-evaluationform-tags</a>
         * @param tags The tags used to organize, track, or control access for this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.connect.CfnEvaluationForm}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.connect.CfnEvaluationForm build() {
            return new software.amazon.awscdk.services.connect.CfnEvaluationForm(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
