package software.amazon.awscdk.services.connect;

/**
 * Properties for defining a <code>CfnRoutingProfile</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.connect.*;
 * CfnRoutingProfileProps cfnRoutingProfileProps = CfnRoutingProfileProps.builder()
 *         .defaultOutboundQueueArn("defaultOutboundQueueArn")
 *         .description("description")
 *         .instanceArn("instanceArn")
 *         .mediaConcurrencies(List.of(MediaConcurrencyProperty.builder()
 *                 .channel("channel")
 *                 .concurrency(123)
 *                 // the properties below are optional
 *                 .crossChannelBehavior(CrossChannelBehaviorProperty.builder()
 *                         .behaviorType("behaviorType")
 *                         .build())
 *                 .build()))
 *         .name("name")
 *         // the properties below are optional
 *         .agentAvailabilityTimer("agentAvailabilityTimer")
 *         .queueConfigs(List.of(RoutingProfileQueueConfigProperty.builder()
 *                 .delay(123)
 *                 .priority(123)
 *                 .queueReference(RoutingProfileQueueReferenceProperty.builder()
 *                         .channel("channel")
 *                         .queueArn("queueArn")
 *                         .build())
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-routingprofile.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-routingprofile.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-22T22:42:49.569Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnRoutingProfileProps")
@software.amazon.jsii.Jsii.Proxy(CfnRoutingProfileProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnRoutingProfileProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon Resource Name (ARN) of the default outbound queue for the routing profile.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-routingprofile.html#cfn-connect-routingprofile-defaultoutboundqueuearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-routingprofile.html#cfn-connect-routingprofile-defaultoutboundqueuearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDefaultOutboundQueueArn();

    /**
     * The description of the routing profile.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-routingprofile.html#cfn-connect-routingprofile-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-routingprofile.html#cfn-connect-routingprofile-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDescription();

    /**
     * The identifier of the Amazon Connect instance.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-routingprofile.html#cfn-connect-routingprofile-instancearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-routingprofile.html#cfn-connect-routingprofile-instancearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getInstanceArn();

    /**
     * The channels agents can handle in the Contact Control Panel (CCP) for this routing profile.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-routingprofile.html#cfn-connect-routingprofile-mediaconcurrencies">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-routingprofile.html#cfn-connect-routingprofile-mediaconcurrencies</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getMediaConcurrencies();

    /**
     * The name of the routing profile.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-routingprofile.html#cfn-connect-routingprofile-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-routingprofile.html#cfn-connect-routingprofile-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * Whether agents with this routing profile will have their routing order calculated based on <em>time since their last inbound contact</em> or <em>longest idle time</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-routingprofile.html#cfn-connect-routingprofile-agentavailabilitytimer">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-routingprofile.html#cfn-connect-routingprofile-agentavailabilitytimer</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAgentAvailabilityTimer() {
        return null;
    }

    /**
     * The inbound queues associated with the routing profile.
     * <p>
     * If no queue is added, the agent can make only outbound calls.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-routingprofile.html#cfn-connect-routingprofile-queueconfigs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-routingprofile.html#cfn-connect-routingprofile-queueconfigs</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getQueueConfigs() {
        return null;
    }

    /**
     * The tags used to organize, track, or control access for this resource.
     * <p>
     * For example, { "Tags": {"key1":"value1", "key2":"value2"} }.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-routingprofile.html#cfn-connect-routingprofile-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-routingprofile.html#cfn-connect-routingprofile-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnRoutingProfileProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnRoutingProfileProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnRoutingProfileProps> {
        java.lang.String defaultOutboundQueueArn;
        java.lang.String description;
        java.lang.String instanceArn;
        java.lang.Object mediaConcurrencies;
        java.lang.String name;
        java.lang.String agentAvailabilityTimer;
        java.lang.Object queueConfigs;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnRoutingProfileProps#getDefaultOutboundQueueArn}
         * @param defaultOutboundQueueArn The Amazon Resource Name (ARN) of the default outbound queue for the routing profile. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultOutboundQueueArn(java.lang.String defaultOutboundQueueArn) {
            this.defaultOutboundQueueArn = defaultOutboundQueueArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnRoutingProfileProps#getDescription}
         * @param description The description of the routing profile. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnRoutingProfileProps#getInstanceArn}
         * @param instanceArn The identifier of the Amazon Connect instance. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceArn(java.lang.String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnRoutingProfileProps#getMediaConcurrencies}
         * @param mediaConcurrencies The channels agents can handle in the Contact Control Panel (CCP) for this routing profile. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mediaConcurrencies(software.amazon.awscdk.IResolvable mediaConcurrencies) {
            this.mediaConcurrencies = mediaConcurrencies;
            return this;
        }

        /**
         * Sets the value of {@link CfnRoutingProfileProps#getMediaConcurrencies}
         * @param mediaConcurrencies The channels agents can handle in the Contact Control Panel (CCP) for this routing profile. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mediaConcurrencies(java.util.List<? extends java.lang.Object> mediaConcurrencies) {
            this.mediaConcurrencies = mediaConcurrencies;
            return this;
        }

        /**
         * Sets the value of {@link CfnRoutingProfileProps#getName}
         * @param name The name of the routing profile. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnRoutingProfileProps#getAgentAvailabilityTimer}
         * @param agentAvailabilityTimer Whether agents with this routing profile will have their routing order calculated based on <em>time since their last inbound contact</em> or <em>longest idle time</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder agentAvailabilityTimer(java.lang.String agentAvailabilityTimer) {
            this.agentAvailabilityTimer = agentAvailabilityTimer;
            return this;
        }

        /**
         * Sets the value of {@link CfnRoutingProfileProps#getQueueConfigs}
         * @param queueConfigs The inbound queues associated with the routing profile.
         *                     If no queue is added, the agent can make only outbound calls.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queueConfigs(software.amazon.awscdk.IResolvable queueConfigs) {
            this.queueConfigs = queueConfigs;
            return this;
        }

        /**
         * Sets the value of {@link CfnRoutingProfileProps#getQueueConfigs}
         * @param queueConfigs The inbound queues associated with the routing profile.
         *                     If no queue is added, the agent can make only outbound calls.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queueConfigs(java.util.List<? extends java.lang.Object> queueConfigs) {
            this.queueConfigs = queueConfigs;
            return this;
        }

        /**
         * Sets the value of {@link CfnRoutingProfileProps#getTags}
         * @param tags The tags used to organize, track, or control access for this resource.
         *             For example, { "Tags": {"key1":"value1", "key2":"value2"} }.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnRoutingProfileProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnRoutingProfileProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnRoutingProfileProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnRoutingProfileProps {
        private final java.lang.String defaultOutboundQueueArn;
        private final java.lang.String description;
        private final java.lang.String instanceArn;
        private final java.lang.Object mediaConcurrencies;
        private final java.lang.String name;
        private final java.lang.String agentAvailabilityTimer;
        private final java.lang.Object queueConfigs;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.defaultOutboundQueueArn = software.amazon.jsii.Kernel.get(this, "defaultOutboundQueueArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.instanceArn = software.amazon.jsii.Kernel.get(this, "instanceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.mediaConcurrencies = software.amazon.jsii.Kernel.get(this, "mediaConcurrencies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.agentAvailabilityTimer = software.amazon.jsii.Kernel.get(this, "agentAvailabilityTimer", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.queueConfigs = software.amazon.jsii.Kernel.get(this, "queueConfigs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.defaultOutboundQueueArn = java.util.Objects.requireNonNull(builder.defaultOutboundQueueArn, "defaultOutboundQueueArn is required");
            this.description = java.util.Objects.requireNonNull(builder.description, "description is required");
            this.instanceArn = java.util.Objects.requireNonNull(builder.instanceArn, "instanceArn is required");
            this.mediaConcurrencies = java.util.Objects.requireNonNull(builder.mediaConcurrencies, "mediaConcurrencies is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.agentAvailabilityTimer = builder.agentAvailabilityTimer;
            this.queueConfigs = builder.queueConfigs;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getDefaultOutboundQueueArn() {
            return this.defaultOutboundQueueArn;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getInstanceArn() {
            return this.instanceArn;
        }

        @Override
        public final java.lang.Object getMediaConcurrencies() {
            return this.mediaConcurrencies;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getAgentAvailabilityTimer() {
            return this.agentAvailabilityTimer;
        }

        @Override
        public final java.lang.Object getQueueConfigs() {
            return this.queueConfigs;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("defaultOutboundQueueArn", om.valueToTree(this.getDefaultOutboundQueueArn()));
            data.set("description", om.valueToTree(this.getDescription()));
            data.set("instanceArn", om.valueToTree(this.getInstanceArn()));
            data.set("mediaConcurrencies", om.valueToTree(this.getMediaConcurrencies()));
            data.set("name", om.valueToTree(this.getName()));
            if (this.getAgentAvailabilityTimer() != null) {
                data.set("agentAvailabilityTimer", om.valueToTree(this.getAgentAvailabilityTimer()));
            }
            if (this.getQueueConfigs() != null) {
                data.set("queueConfigs", om.valueToTree(this.getQueueConfigs()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnRoutingProfileProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnRoutingProfileProps.Jsii$Proxy that = (CfnRoutingProfileProps.Jsii$Proxy) o;

            if (!defaultOutboundQueueArn.equals(that.defaultOutboundQueueArn)) return false;
            if (!description.equals(that.description)) return false;
            if (!instanceArn.equals(that.instanceArn)) return false;
            if (!mediaConcurrencies.equals(that.mediaConcurrencies)) return false;
            if (!name.equals(that.name)) return false;
            if (this.agentAvailabilityTimer != null ? !this.agentAvailabilityTimer.equals(that.agentAvailabilityTimer) : that.agentAvailabilityTimer != null) return false;
            if (this.queueConfigs != null ? !this.queueConfigs.equals(that.queueConfigs) : that.queueConfigs != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.defaultOutboundQueueArn.hashCode();
            result = 31 * result + (this.description.hashCode());
            result = 31 * result + (this.instanceArn.hashCode());
            result = 31 * result + (this.mediaConcurrencies.hashCode());
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.agentAvailabilityTimer != null ? this.agentAvailabilityTimer.hashCode() : 0);
            result = 31 * result + (this.queueConfigs != null ? this.queueConfigs.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
