package software.amazon.awscdk.services.controltower;

/**
 * Properties for defining a <code>CfnEnabledBaseline</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.controltower.*;
 * Object value;
 * CfnEnabledBaselineProps cfnEnabledBaselineProps = CfnEnabledBaselineProps.builder()
 *         .baselineIdentifier("baselineIdentifier")
 *         .baselineVersion("baselineVersion")
 *         .targetIdentifier("targetIdentifier")
 *         // the properties below are optional
 *         .parameters(List.of(ParameterProperty.builder()
 *                 .key("key")
 *                 .value(value)
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-controltower-enabledbaseline.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-controltower-enabledbaseline.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-22T22:42:49.616Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_controltower.CfnEnabledBaselineProps")
@software.amazon.jsii.Jsii.Proxy(CfnEnabledBaselineProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnEnabledBaselineProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The specific <code>Baseline</code> enabled as part of the <code>EnabledBaseline</code> resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-controltower-enabledbaseline.html#cfn-controltower-enabledbaseline-baselineidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-controltower-enabledbaseline.html#cfn-controltower-enabledbaseline-baselineidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBaselineIdentifier();

    /**
     * The enabled version of the <code>Baseline</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-controltower-enabledbaseline.html#cfn-controltower-enabledbaseline-baselineversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-controltower-enabledbaseline.html#cfn-controltower-enabledbaseline-baselineversion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBaselineVersion();

    /**
     * The target on which to enable the <code>Baseline</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-controltower-enabledbaseline.html#cfn-controltower-enabledbaseline-targetidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-controltower-enabledbaseline.html#cfn-controltower-enabledbaseline-targetidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTargetIdentifier();

    /**
     * Parameters that are applied when enabling this <code>Baseline</code> .
     * <p>
     * These parameters configure the behavior of the baseline.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-controltower-enabledbaseline.html#cfn-controltower-enabledbaseline-parameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-controltower-enabledbaseline.html#cfn-controltower-enabledbaseline-parameters</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getParameters() {
        return null;
    }

    /**
     * Tags associated with input to <code>EnableBaseline</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-controltower-enabledbaseline.html#cfn-controltower-enabledbaseline-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-controltower-enabledbaseline.html#cfn-controltower-enabledbaseline-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnEnabledBaselineProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnEnabledBaselineProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnEnabledBaselineProps> {
        java.lang.String baselineIdentifier;
        java.lang.String baselineVersion;
        java.lang.String targetIdentifier;
        java.lang.Object parameters;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnEnabledBaselineProps#getBaselineIdentifier}
         * @param baselineIdentifier The specific <code>Baseline</code> enabled as part of the <code>EnabledBaseline</code> resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder baselineIdentifier(java.lang.String baselineIdentifier) {
            this.baselineIdentifier = baselineIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnabledBaselineProps#getBaselineVersion}
         * @param baselineVersion The enabled version of the <code>Baseline</code> . This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder baselineVersion(java.lang.String baselineVersion) {
            this.baselineVersion = baselineVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnabledBaselineProps#getTargetIdentifier}
         * @param targetIdentifier The target on which to enable the <code>Baseline</code> . This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetIdentifier(java.lang.String targetIdentifier) {
            this.targetIdentifier = targetIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnabledBaselineProps#getParameters}
         * @param parameters Parameters that are applied when enabling this <code>Baseline</code> .
         *                   These parameters configure the behavior of the baseline.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(software.amazon.awscdk.IResolvable parameters) {
            this.parameters = parameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnabledBaselineProps#getParameters}
         * @param parameters Parameters that are applied when enabling this <code>Baseline</code> .
         *                   These parameters configure the behavior of the baseline.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(java.util.List<? extends java.lang.Object> parameters) {
            this.parameters = parameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnabledBaselineProps#getTags}
         * @param tags Tags associated with input to <code>EnableBaseline</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnEnabledBaselineProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnEnabledBaselineProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnEnabledBaselineProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnEnabledBaselineProps {
        private final java.lang.String baselineIdentifier;
        private final java.lang.String baselineVersion;
        private final java.lang.String targetIdentifier;
        private final java.lang.Object parameters;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.baselineIdentifier = software.amazon.jsii.Kernel.get(this, "baselineIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.baselineVersion = software.amazon.jsii.Kernel.get(this, "baselineVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.targetIdentifier = software.amazon.jsii.Kernel.get(this, "targetIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.baselineIdentifier = java.util.Objects.requireNonNull(builder.baselineIdentifier, "baselineIdentifier is required");
            this.baselineVersion = java.util.Objects.requireNonNull(builder.baselineVersion, "baselineVersion is required");
            this.targetIdentifier = java.util.Objects.requireNonNull(builder.targetIdentifier, "targetIdentifier is required");
            this.parameters = builder.parameters;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getBaselineIdentifier() {
            return this.baselineIdentifier;
        }

        @Override
        public final java.lang.String getBaselineVersion() {
            return this.baselineVersion;
        }

        @Override
        public final java.lang.String getTargetIdentifier() {
            return this.targetIdentifier;
        }

        @Override
        public final java.lang.Object getParameters() {
            return this.parameters;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("baselineIdentifier", om.valueToTree(this.getBaselineIdentifier()));
            data.set("baselineVersion", om.valueToTree(this.getBaselineVersion()));
            data.set("targetIdentifier", om.valueToTree(this.getTargetIdentifier()));
            if (this.getParameters() != null) {
                data.set("parameters", om.valueToTree(this.getParameters()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_controltower.CfnEnabledBaselineProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnEnabledBaselineProps.Jsii$Proxy that = (CfnEnabledBaselineProps.Jsii$Proxy) o;

            if (!baselineIdentifier.equals(that.baselineIdentifier)) return false;
            if (!baselineVersion.equals(that.baselineVersion)) return false;
            if (!targetIdentifier.equals(that.targetIdentifier)) return false;
            if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.baselineIdentifier.hashCode();
            result = 31 * result + (this.baselineVersion.hashCode());
            result = 31 * result + (this.targetIdentifier.hashCode());
            result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
