package software.amazon.awscdk.services.datasync;

/**
 * Properties for defining a <code>CfnLocationEFS</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.datasync.*;
 * CfnLocationEFSProps cfnLocationEFSProps = CfnLocationEFSProps.builder()
 *         .ec2Config(Ec2ConfigProperty.builder()
 *                 .securityGroupArns(List.of("securityGroupArns"))
 *                 .subnetArn("subnetArn")
 *                 .build())
 *         // the properties below are optional
 *         .accessPointArn("accessPointArn")
 *         .efsFilesystemArn("efsFilesystemArn")
 *         .fileSystemAccessRoleArn("fileSystemAccessRoleArn")
 *         .inTransitEncryption("inTransitEncryption")
 *         .subdirectory("subdirectory")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationefs.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationefs.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-22T22:42:49.742Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datasync.CfnLocationEFSProps")
@software.amazon.jsii.Jsii.Proxy(CfnLocationEFSProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnLocationEFSProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specifies the subnet and security groups DataSync uses to access your Amazon EFS file system.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationefs.html#cfn-datasync-locationefs-ec2config">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationefs.html#cfn-datasync-locationefs-ec2config</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getEc2Config();

    /**
     * Specifies the Amazon Resource Name (ARN) of the access point that DataSync uses to access the Amazon EFS file system.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationefs.html#cfn-datasync-locationefs-accesspointarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationefs.html#cfn-datasync-locationefs-accesspointarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAccessPointArn() {
        return null;
    }

    /**
     * Specifies the ARN for the Amazon EFS file system.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationefs.html#cfn-datasync-locationefs-efsfilesystemarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationefs.html#cfn-datasync-locationefs-efsfilesystemarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEfsFilesystemArn() {
        return null;
    }

    /**
     * Specifies an AWS Identity and Access Management (IAM) role that DataSync assumes when mounting the Amazon EFS file system.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationefs.html#cfn-datasync-locationefs-filesystemaccessrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationefs.html#cfn-datasync-locationefs-filesystemaccessrolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFileSystemAccessRoleArn() {
        return null;
    }

    /**
     * Specifies whether you want DataSync to use Transport Layer Security (TLS) 1.2 encryption when it copies data to or from the Amazon EFS file system.
     * <p>
     * If you specify an access point using <code>AccessPointArn</code> or an IAM role using <code>FileSystemAccessRoleArn</code> , you must set this parameter to <code>TLS1_2</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationefs.html#cfn-datasync-locationefs-intransitencryption">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationefs.html#cfn-datasync-locationefs-intransitencryption</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getInTransitEncryption() {
        return null;
    }

    /**
     * Specifies a mount path for your Amazon EFS file system.
     * <p>
     * This is where DataSync reads or writes data (depending on if this is a source or destination location). By default, DataSync uses the root directory, but you can also include subdirectories.
     * <p>
     * <blockquote>
     * <p>
     * You must specify a value with forward slashes (for example, <code>/path/to/folder</code> ).
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationefs.html#cfn-datasync-locationefs-subdirectory">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationefs.html#cfn-datasync-locationefs-subdirectory</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSubdirectory() {
        return null;
    }

    /**
     * Specifies the key-value pair that represents a tag that you want to add to the resource.
     * <p>
     * The value can be an empty string. This value helps you manage, filter, and search for your resources. We recommend that you create a name tag for your location.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationefs.html#cfn-datasync-locationefs-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationefs.html#cfn-datasync-locationefs-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnLocationEFSProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnLocationEFSProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnLocationEFSProps> {
        java.lang.Object ec2Config;
        java.lang.String accessPointArn;
        java.lang.String efsFilesystemArn;
        java.lang.String fileSystemAccessRoleArn;
        java.lang.String inTransitEncryption;
        java.lang.String subdirectory;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnLocationEFSProps#getEc2Config}
         * @param ec2Config Specifies the subnet and security groups DataSync uses to access your Amazon EFS file system. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ec2Config(software.amazon.awscdk.IResolvable ec2Config) {
            this.ec2Config = ec2Config;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationEFSProps#getEc2Config}
         * @param ec2Config Specifies the subnet and security groups DataSync uses to access your Amazon EFS file system. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ec2Config(software.amazon.awscdk.services.datasync.CfnLocationEFS.Ec2ConfigProperty ec2Config) {
            this.ec2Config = ec2Config;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationEFSProps#getAccessPointArn}
         * @param accessPointArn Specifies the Amazon Resource Name (ARN) of the access point that DataSync uses to access the Amazon EFS file system.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessPointArn(java.lang.String accessPointArn) {
            this.accessPointArn = accessPointArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationEFSProps#getEfsFilesystemArn}
         * @param efsFilesystemArn Specifies the ARN for the Amazon EFS file system.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder efsFilesystemArn(java.lang.String efsFilesystemArn) {
            this.efsFilesystemArn = efsFilesystemArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationEFSProps#getFileSystemAccessRoleArn}
         * @param fileSystemAccessRoleArn Specifies an AWS Identity and Access Management (IAM) role that DataSync assumes when mounting the Amazon EFS file system.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileSystemAccessRoleArn(java.lang.String fileSystemAccessRoleArn) {
            this.fileSystemAccessRoleArn = fileSystemAccessRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationEFSProps#getInTransitEncryption}
         * @param inTransitEncryption Specifies whether you want DataSync to use Transport Layer Security (TLS) 1.2 encryption when it copies data to or from the Amazon EFS file system.
         *                            If you specify an access point using <code>AccessPointArn</code> or an IAM role using <code>FileSystemAccessRoleArn</code> , you must set this parameter to <code>TLS1_2</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inTransitEncryption(java.lang.String inTransitEncryption) {
            this.inTransitEncryption = inTransitEncryption;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationEFSProps#getSubdirectory}
         * @param subdirectory Specifies a mount path for your Amazon EFS file system.
         *                     This is where DataSync reads or writes data (depending on if this is a source or destination location). By default, DataSync uses the root directory, but you can also include subdirectories.
         *                     <p>
         *                     <blockquote>
         *                     <p>
         *                     You must specify a value with forward slashes (for example, <code>/path/to/folder</code> ).
         *                     <p>
         *                     </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subdirectory(java.lang.String subdirectory) {
            this.subdirectory = subdirectory;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationEFSProps#getTags}
         * @param tags Specifies the key-value pair that represents a tag that you want to add to the resource.
         *             The value can be an empty string. This value helps you manage, filter, and search for your resources. We recommend that you create a name tag for your location.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnLocationEFSProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnLocationEFSProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnLocationEFSProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnLocationEFSProps {
        private final java.lang.Object ec2Config;
        private final java.lang.String accessPointArn;
        private final java.lang.String efsFilesystemArn;
        private final java.lang.String fileSystemAccessRoleArn;
        private final java.lang.String inTransitEncryption;
        private final java.lang.String subdirectory;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.ec2Config = software.amazon.jsii.Kernel.get(this, "ec2Config", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.accessPointArn = software.amazon.jsii.Kernel.get(this, "accessPointArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.efsFilesystemArn = software.amazon.jsii.Kernel.get(this, "efsFilesystemArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.fileSystemAccessRoleArn = software.amazon.jsii.Kernel.get(this, "fileSystemAccessRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.inTransitEncryption = software.amazon.jsii.Kernel.get(this, "inTransitEncryption", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.subdirectory = software.amazon.jsii.Kernel.get(this, "subdirectory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.ec2Config = java.util.Objects.requireNonNull(builder.ec2Config, "ec2Config is required");
            this.accessPointArn = builder.accessPointArn;
            this.efsFilesystemArn = builder.efsFilesystemArn;
            this.fileSystemAccessRoleArn = builder.fileSystemAccessRoleArn;
            this.inTransitEncryption = builder.inTransitEncryption;
            this.subdirectory = builder.subdirectory;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getEc2Config() {
            return this.ec2Config;
        }

        @Override
        public final java.lang.String getAccessPointArn() {
            return this.accessPointArn;
        }

        @Override
        public final java.lang.String getEfsFilesystemArn() {
            return this.efsFilesystemArn;
        }

        @Override
        public final java.lang.String getFileSystemAccessRoleArn() {
            return this.fileSystemAccessRoleArn;
        }

        @Override
        public final java.lang.String getInTransitEncryption() {
            return this.inTransitEncryption;
        }

        @Override
        public final java.lang.String getSubdirectory() {
            return this.subdirectory;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("ec2Config", om.valueToTree(this.getEc2Config()));
            if (this.getAccessPointArn() != null) {
                data.set("accessPointArn", om.valueToTree(this.getAccessPointArn()));
            }
            if (this.getEfsFilesystemArn() != null) {
                data.set("efsFilesystemArn", om.valueToTree(this.getEfsFilesystemArn()));
            }
            if (this.getFileSystemAccessRoleArn() != null) {
                data.set("fileSystemAccessRoleArn", om.valueToTree(this.getFileSystemAccessRoleArn()));
            }
            if (this.getInTransitEncryption() != null) {
                data.set("inTransitEncryption", om.valueToTree(this.getInTransitEncryption()));
            }
            if (this.getSubdirectory() != null) {
                data.set("subdirectory", om.valueToTree(this.getSubdirectory()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datasync.CfnLocationEFSProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnLocationEFSProps.Jsii$Proxy that = (CfnLocationEFSProps.Jsii$Proxy) o;

            if (!ec2Config.equals(that.ec2Config)) return false;
            if (this.accessPointArn != null ? !this.accessPointArn.equals(that.accessPointArn) : that.accessPointArn != null) return false;
            if (this.efsFilesystemArn != null ? !this.efsFilesystemArn.equals(that.efsFilesystemArn) : that.efsFilesystemArn != null) return false;
            if (this.fileSystemAccessRoleArn != null ? !this.fileSystemAccessRoleArn.equals(that.fileSystemAccessRoleArn) : that.fileSystemAccessRoleArn != null) return false;
            if (this.inTransitEncryption != null ? !this.inTransitEncryption.equals(that.inTransitEncryption) : that.inTransitEncryption != null) return false;
            if (this.subdirectory != null ? !this.subdirectory.equals(that.subdirectory) : that.subdirectory != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.ec2Config.hashCode();
            result = 31 * result + (this.accessPointArn != null ? this.accessPointArn.hashCode() : 0);
            result = 31 * result + (this.efsFilesystemArn != null ? this.efsFilesystemArn.hashCode() : 0);
            result = 31 * result + (this.fileSystemAccessRoleArn != null ? this.fileSystemAccessRoleArn.hashCode() : 0);
            result = 31 * result + (this.inTransitEncryption != null ? this.inTransitEncryption.hashCode() : 0);
            result = 31 * result + (this.subdirectory != null ? this.subdirectory.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
