package software.amazon.awscdk.services.ecr.assets;

/**
 * Props for DockerImageAssets.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.ecr.assets.DockerImageAsset;
 * DockerImageAsset asset = DockerImageAsset.Builder.create(this, "MyBuildImage")
 *         .directory(join(__dirname, "my-image"))
 *         .buildArgs(Map.of(
 *                 "HTTP_PROXY", "http://10.20.30.2:1234"))
 *         .invalidation(DockerImageAssetInvalidationOptions.builder()
 *                 .buildArgs(false)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-22T22:42:50.924Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecr_assets.DockerImageAssetProps")
@software.amazon.jsii.Jsii.Proxy(DockerImageAssetProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DockerImageAssetProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.ecr.assets.DockerImageAssetOptions {

    /**
     * The directory where the Dockerfile is stored.
     * <p>
     * Any directory inside with a name that matches the CDK output folder (cdk.out by default) will be excluded from the asset
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDirectory();

    /**
     * @return a {@link Builder} of {@link DockerImageAssetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DockerImageAssetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DockerImageAssetProps> {
        java.lang.String directory;
        java.lang.String assetName;
        java.util.Map<java.lang.String, java.lang.String> buildArgs;
        java.util.Map<java.lang.String, java.lang.String> buildSecrets;
        java.lang.String buildSsh;
        java.lang.Boolean cacheDisabled;
        java.util.List<software.amazon.awscdk.services.ecr.assets.DockerCacheOption> cacheFrom;
        software.amazon.awscdk.services.ecr.assets.DockerCacheOption cacheTo;
        java.lang.String file;
        software.amazon.awscdk.services.ecr.assets.DockerImageAssetInvalidationOptions invalidation;
        software.amazon.awscdk.services.ecr.assets.NetworkMode networkMode;
        java.util.List<java.lang.String> outputs;
        software.amazon.awscdk.services.ecr.assets.Platform platform;
        java.lang.String target;
        java.lang.String extraHash;
        java.util.List<java.lang.String> exclude;
        software.amazon.awscdk.SymlinkFollowMode followSymlinks;
        software.amazon.awscdk.IgnoreMode ignoreMode;

        /**
         * Sets the value of {@link DockerImageAssetProps#getDirectory}
         * @param directory The directory where the Dockerfile is stored. This parameter is required.
         *                  Any directory inside with a name that matches the CDK output folder (cdk.out by default) will be excluded from the asset
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder directory(java.lang.String directory) {
            this.directory = directory;
            return this;
        }

        /**
         * Sets the value of {@link DockerImageAssetProps#getAssetName}
         * @param assetName Unique identifier of the docker image asset and its potential revisions.
         *                  Required if using AppScopedStagingSynthesizer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetName(java.lang.String assetName) {
            this.assetName = assetName;
            return this;
        }

        /**
         * Sets the value of {@link DockerImageAssetProps#getBuildArgs}
         * @param buildArgs Build args to pass to the <code>docker build</code> command.
         *                  Since Docker build arguments are resolved before deployment, keys and
         *                  values cannot refer to unresolved tokens (such as <code>lambda.functionArn</code> or
         *                  <code>queue.queueUrl</code>).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder buildArgs(java.util.Map<java.lang.String, java.lang.String> buildArgs) {
            this.buildArgs = buildArgs;
            return this;
        }

        /**
         * Sets the value of {@link DockerImageAssetProps#getBuildSecrets}
         * @param buildSecrets Build secrets.
         *                     Docker BuildKit must be enabled to use build secrets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder buildSecrets(java.util.Map<java.lang.String, java.lang.String> buildSecrets) {
            this.buildSecrets = buildSecrets;
            return this;
        }

        /**
         * Sets the value of {@link DockerImageAssetProps#getBuildSsh}
         * @param buildSsh SSH agent socket or keys to pass to the <code>docker build</code> command.
         *                 Docker BuildKit must be enabled to use the ssh flag
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder buildSsh(java.lang.String buildSsh) {
            this.buildSsh = buildSsh;
            return this;
        }

        /**
         * Sets the value of {@link DockerImageAssetProps#getCacheDisabled}
         * @param cacheDisabled Disable the cache and pass <code>--no-cache</code> to the <code>docker build</code> command.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheDisabled(java.lang.Boolean cacheDisabled) {
            this.cacheDisabled = cacheDisabled;
            return this;
        }

        /**
         * Sets the value of {@link DockerImageAssetProps#getCacheFrom}
         * @param cacheFrom Cache from options to pass to the <code>docker build</code> command.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder cacheFrom(java.util.List<? extends software.amazon.awscdk.services.ecr.assets.DockerCacheOption> cacheFrom) {
            this.cacheFrom = (java.util.List<software.amazon.awscdk.services.ecr.assets.DockerCacheOption>)cacheFrom;
            return this;
        }

        /**
         * Sets the value of {@link DockerImageAssetProps#getCacheTo}
         * @param cacheTo Cache to options to pass to the <code>docker build</code> command.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheTo(software.amazon.awscdk.services.ecr.assets.DockerCacheOption cacheTo) {
            this.cacheTo = cacheTo;
            return this;
        }

        /**
         * Sets the value of {@link DockerImageAssetProps#getFile}
         * @param file Path to the Dockerfile (relative to the directory).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder file(java.lang.String file) {
            this.file = file;
            return this;
        }

        /**
         * Sets the value of {@link DockerImageAssetProps#getInvalidation}
         * @param invalidation Options to control which parameters are used to invalidate the asset hash.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder invalidation(software.amazon.awscdk.services.ecr.assets.DockerImageAssetInvalidationOptions invalidation) {
            this.invalidation = invalidation;
            return this;
        }

        /**
         * Sets the value of {@link DockerImageAssetProps#getNetworkMode}
         * @param networkMode Networking mode for the RUN commands during build.
         *                    Support docker API 1.25+.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkMode(software.amazon.awscdk.services.ecr.assets.NetworkMode networkMode) {
            this.networkMode = networkMode;
            return this;
        }

        /**
         * Sets the value of {@link DockerImageAssetProps#getOutputs}
         * @param outputs Outputs to pass to the <code>docker build</code> command.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputs(java.util.List<java.lang.String> outputs) {
            this.outputs = outputs;
            return this;
        }

        /**
         * Sets the value of {@link DockerImageAssetProps#getPlatform}
         * @param platform Platform to build for.
         *                 <em>Requires Docker Buildx</em>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder platform(software.amazon.awscdk.services.ecr.assets.Platform platform) {
            this.platform = platform;
            return this;
        }

        /**
         * Sets the value of {@link DockerImageAssetProps#getTarget}
         * @param target Docker target to build to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder target(java.lang.String target) {
            this.target = target;
            return this;
        }

        /**
         * Sets the value of {@link DockerImageAssetProps#getExtraHash}
         * @param extraHash Extra information to encode into the fingerprint (e.g. build instructions and other inputs).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder extraHash(java.lang.String extraHash) {
            this.extraHash = extraHash;
            return this;
        }

        /**
         * Sets the value of {@link DockerImageAssetProps#getExclude}
         * @param exclude File paths matching the patterns will be excluded.
         *                See <code>ignoreMode</code> to set the matching behavior.
         *                Has no effect on Assets bundled using the <code>bundling</code> property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder exclude(java.util.List<java.lang.String> exclude) {
            this.exclude = exclude;
            return this;
        }

        /**
         * Sets the value of {@link DockerImageAssetProps#getFollowSymlinks}
         * @param followSymlinks A strategy for how to handle symlinks.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder followSymlinks(software.amazon.awscdk.SymlinkFollowMode followSymlinks) {
            this.followSymlinks = followSymlinks;
            return this;
        }

        /**
         * Sets the value of {@link DockerImageAssetProps#getIgnoreMode}
         * @param ignoreMode The ignore behavior to use for <code>exclude</code> patterns.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ignoreMode(software.amazon.awscdk.IgnoreMode ignoreMode) {
            this.ignoreMode = ignoreMode;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DockerImageAssetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DockerImageAssetProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DockerImageAssetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DockerImageAssetProps {
        private final java.lang.String directory;
        private final java.lang.String assetName;
        private final java.util.Map<java.lang.String, java.lang.String> buildArgs;
        private final java.util.Map<java.lang.String, java.lang.String> buildSecrets;
        private final java.lang.String buildSsh;
        private final java.lang.Boolean cacheDisabled;
        private final java.util.List<software.amazon.awscdk.services.ecr.assets.DockerCacheOption> cacheFrom;
        private final software.amazon.awscdk.services.ecr.assets.DockerCacheOption cacheTo;
        private final java.lang.String file;
        private final software.amazon.awscdk.services.ecr.assets.DockerImageAssetInvalidationOptions invalidation;
        private final software.amazon.awscdk.services.ecr.assets.NetworkMode networkMode;
        private final java.util.List<java.lang.String> outputs;
        private final software.amazon.awscdk.services.ecr.assets.Platform platform;
        private final java.lang.String target;
        private final java.lang.String extraHash;
        private final java.util.List<java.lang.String> exclude;
        private final software.amazon.awscdk.SymlinkFollowMode followSymlinks;
        private final software.amazon.awscdk.IgnoreMode ignoreMode;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.directory = software.amazon.jsii.Kernel.get(this, "directory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.assetName = software.amazon.jsii.Kernel.get(this, "assetName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.buildArgs = software.amazon.jsii.Kernel.get(this, "buildArgs", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.buildSecrets = software.amazon.jsii.Kernel.get(this, "buildSecrets", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.buildSsh = software.amazon.jsii.Kernel.get(this, "buildSsh", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cacheDisabled = software.amazon.jsii.Kernel.get(this, "cacheDisabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.cacheFrom = software.amazon.jsii.Kernel.get(this, "cacheFrom", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecr.assets.DockerCacheOption.class)));
            this.cacheTo = software.amazon.jsii.Kernel.get(this, "cacheTo", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecr.assets.DockerCacheOption.class));
            this.file = software.amazon.jsii.Kernel.get(this, "file", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.invalidation = software.amazon.jsii.Kernel.get(this, "invalidation", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecr.assets.DockerImageAssetInvalidationOptions.class));
            this.networkMode = software.amazon.jsii.Kernel.get(this, "networkMode", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecr.assets.NetworkMode.class));
            this.outputs = software.amazon.jsii.Kernel.get(this, "outputs", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.platform = software.amazon.jsii.Kernel.get(this, "platform", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecr.assets.Platform.class));
            this.target = software.amazon.jsii.Kernel.get(this, "target", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.extraHash = software.amazon.jsii.Kernel.get(this, "extraHash", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.exclude = software.amazon.jsii.Kernel.get(this, "exclude", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.followSymlinks = software.amazon.jsii.Kernel.get(this, "followSymlinks", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.SymlinkFollowMode.class));
            this.ignoreMode = software.amazon.jsii.Kernel.get(this, "ignoreMode", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IgnoreMode.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.directory = java.util.Objects.requireNonNull(builder.directory, "directory is required");
            this.assetName = builder.assetName;
            this.buildArgs = builder.buildArgs;
            this.buildSecrets = builder.buildSecrets;
            this.buildSsh = builder.buildSsh;
            this.cacheDisabled = builder.cacheDisabled;
            this.cacheFrom = (java.util.List<software.amazon.awscdk.services.ecr.assets.DockerCacheOption>)builder.cacheFrom;
            this.cacheTo = builder.cacheTo;
            this.file = builder.file;
            this.invalidation = builder.invalidation;
            this.networkMode = builder.networkMode;
            this.outputs = builder.outputs;
            this.platform = builder.platform;
            this.target = builder.target;
            this.extraHash = builder.extraHash;
            this.exclude = builder.exclude;
            this.followSymlinks = builder.followSymlinks;
            this.ignoreMode = builder.ignoreMode;
        }

        @Override
        public final java.lang.String getDirectory() {
            return this.directory;
        }

        @Override
        public final java.lang.String getAssetName() {
            return this.assetName;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getBuildArgs() {
            return this.buildArgs;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getBuildSecrets() {
            return this.buildSecrets;
        }

        @Override
        public final java.lang.String getBuildSsh() {
            return this.buildSsh;
        }

        @Override
        public final java.lang.Boolean getCacheDisabled() {
            return this.cacheDisabled;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ecr.assets.DockerCacheOption> getCacheFrom() {
            return this.cacheFrom;
        }

        @Override
        public final software.amazon.awscdk.services.ecr.assets.DockerCacheOption getCacheTo() {
            return this.cacheTo;
        }

        @Override
        public final java.lang.String getFile() {
            return this.file;
        }

        @Override
        public final software.amazon.awscdk.services.ecr.assets.DockerImageAssetInvalidationOptions getInvalidation() {
            return this.invalidation;
        }

        @Override
        public final software.amazon.awscdk.services.ecr.assets.NetworkMode getNetworkMode() {
            return this.networkMode;
        }

        @Override
        public final java.util.List<java.lang.String> getOutputs() {
            return this.outputs;
        }

        @Override
        public final software.amazon.awscdk.services.ecr.assets.Platform getPlatform() {
            return this.platform;
        }

        @Override
        public final java.lang.String getTarget() {
            return this.target;
        }

        @Override
        public final java.lang.String getExtraHash() {
            return this.extraHash;
        }

        @Override
        public final java.util.List<java.lang.String> getExclude() {
            return this.exclude;
        }

        @Override
        public final software.amazon.awscdk.SymlinkFollowMode getFollowSymlinks() {
            return this.followSymlinks;
        }

        @Override
        public final software.amazon.awscdk.IgnoreMode getIgnoreMode() {
            return this.ignoreMode;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("directory", om.valueToTree(this.getDirectory()));
            if (this.getAssetName() != null) {
                data.set("assetName", om.valueToTree(this.getAssetName()));
            }
            if (this.getBuildArgs() != null) {
                data.set("buildArgs", om.valueToTree(this.getBuildArgs()));
            }
            if (this.getBuildSecrets() != null) {
                data.set("buildSecrets", om.valueToTree(this.getBuildSecrets()));
            }
            if (this.getBuildSsh() != null) {
                data.set("buildSsh", om.valueToTree(this.getBuildSsh()));
            }
            if (this.getCacheDisabled() != null) {
                data.set("cacheDisabled", om.valueToTree(this.getCacheDisabled()));
            }
            if (this.getCacheFrom() != null) {
                data.set("cacheFrom", om.valueToTree(this.getCacheFrom()));
            }
            if (this.getCacheTo() != null) {
                data.set("cacheTo", om.valueToTree(this.getCacheTo()));
            }
            if (this.getFile() != null) {
                data.set("file", om.valueToTree(this.getFile()));
            }
            if (this.getInvalidation() != null) {
                data.set("invalidation", om.valueToTree(this.getInvalidation()));
            }
            if (this.getNetworkMode() != null) {
                data.set("networkMode", om.valueToTree(this.getNetworkMode()));
            }
            if (this.getOutputs() != null) {
                data.set("outputs", om.valueToTree(this.getOutputs()));
            }
            if (this.getPlatform() != null) {
                data.set("platform", om.valueToTree(this.getPlatform()));
            }
            if (this.getTarget() != null) {
                data.set("target", om.valueToTree(this.getTarget()));
            }
            if (this.getExtraHash() != null) {
                data.set("extraHash", om.valueToTree(this.getExtraHash()));
            }
            if (this.getExclude() != null) {
                data.set("exclude", om.valueToTree(this.getExclude()));
            }
            if (this.getFollowSymlinks() != null) {
                data.set("followSymlinks", om.valueToTree(this.getFollowSymlinks()));
            }
            if (this.getIgnoreMode() != null) {
                data.set("ignoreMode", om.valueToTree(this.getIgnoreMode()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecr_assets.DockerImageAssetProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DockerImageAssetProps.Jsii$Proxy that = (DockerImageAssetProps.Jsii$Proxy) o;

            if (!directory.equals(that.directory)) return false;
            if (this.assetName != null ? !this.assetName.equals(that.assetName) : that.assetName != null) return false;
            if (this.buildArgs != null ? !this.buildArgs.equals(that.buildArgs) : that.buildArgs != null) return false;
            if (this.buildSecrets != null ? !this.buildSecrets.equals(that.buildSecrets) : that.buildSecrets != null) return false;
            if (this.buildSsh != null ? !this.buildSsh.equals(that.buildSsh) : that.buildSsh != null) return false;
            if (this.cacheDisabled != null ? !this.cacheDisabled.equals(that.cacheDisabled) : that.cacheDisabled != null) return false;
            if (this.cacheFrom != null ? !this.cacheFrom.equals(that.cacheFrom) : that.cacheFrom != null) return false;
            if (this.cacheTo != null ? !this.cacheTo.equals(that.cacheTo) : that.cacheTo != null) return false;
            if (this.file != null ? !this.file.equals(that.file) : that.file != null) return false;
            if (this.invalidation != null ? !this.invalidation.equals(that.invalidation) : that.invalidation != null) return false;
            if (this.networkMode != null ? !this.networkMode.equals(that.networkMode) : that.networkMode != null) return false;
            if (this.outputs != null ? !this.outputs.equals(that.outputs) : that.outputs != null) return false;
            if (this.platform != null ? !this.platform.equals(that.platform) : that.platform != null) return false;
            if (this.target != null ? !this.target.equals(that.target) : that.target != null) return false;
            if (this.extraHash != null ? !this.extraHash.equals(that.extraHash) : that.extraHash != null) return false;
            if (this.exclude != null ? !this.exclude.equals(that.exclude) : that.exclude != null) return false;
            if (this.followSymlinks != null ? !this.followSymlinks.equals(that.followSymlinks) : that.followSymlinks != null) return false;
            return this.ignoreMode != null ? this.ignoreMode.equals(that.ignoreMode) : that.ignoreMode == null;
        }

        @Override
        public final int hashCode() {
            int result = this.directory.hashCode();
            result = 31 * result + (this.assetName != null ? this.assetName.hashCode() : 0);
            result = 31 * result + (this.buildArgs != null ? this.buildArgs.hashCode() : 0);
            result = 31 * result + (this.buildSecrets != null ? this.buildSecrets.hashCode() : 0);
            result = 31 * result + (this.buildSsh != null ? this.buildSsh.hashCode() : 0);
            result = 31 * result + (this.cacheDisabled != null ? this.cacheDisabled.hashCode() : 0);
            result = 31 * result + (this.cacheFrom != null ? this.cacheFrom.hashCode() : 0);
            result = 31 * result + (this.cacheTo != null ? this.cacheTo.hashCode() : 0);
            result = 31 * result + (this.file != null ? this.file.hashCode() : 0);
            result = 31 * result + (this.invalidation != null ? this.invalidation.hashCode() : 0);
            result = 31 * result + (this.networkMode != null ? this.networkMode.hashCode() : 0);
            result = 31 * result + (this.outputs != null ? this.outputs.hashCode() : 0);
            result = 31 * result + (this.platform != null ? this.platform.hashCode() : 0);
            result = 31 * result + (this.target != null ? this.target.hashCode() : 0);
            result = 31 * result + (this.extraHash != null ? this.extraHash.hashCode() : 0);
            result = 31 * result + (this.exclude != null ? this.exclude.hashCode() : 0);
            result = 31 * result + (this.followSymlinks != null ? this.followSymlinks.hashCode() : 0);
            result = 31 * result + (this.ignoreMode != null ? this.ignoreMode.hashCode() : 0);
            return result;
        }
    }
}
