package software.amazon.awscdk.services.eks;

/**
 * Creates an Amazon EKS control plane.
 * <p>
 * The Amazon EKS control plane consists of control plane instances that run the Kubernetes software, such as <code>etcd</code> and the API server. The control plane runs in an account managed by AWS , and the Kubernetes API is exposed by the Amazon EKS API server endpoint. Each Amazon EKS cluster control plane is single tenant and unique. It runs on its own set of Amazon EC2 instances.
 * <p>
 * The cluster control plane is provisioned across multiple Availability Zones and fronted by an Elastic Load Balancing Network Load Balancer. Amazon EKS also provisions elastic network interfaces in your VPC subnets to provide connectivity from the control plane instances to the nodes (for example, to support <code>kubectl exec</code> , <code>logs</code> , and <code>proxy</code> data flows).
 * <p>
 * Amazon EKS nodes run in your AWS account and connect to your cluster's control plane over the Kubernetes API server endpoint and a certificate file that is created for your cluster.
 * <p>
 * You can use the <code>endpointPublicAccess</code> and <code>endpointPrivateAccess</code> parameters to enable or disable public and private access to your cluster's Kubernetes API server endpoint. By default, public access is enabled, and private access is disabled. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html">Amazon EKS Cluster Endpoint Access Control</a> in the <strong>Amazon EKS User Guide</strong> .
 * <p>
 * You can use the <code>logging</code> parameter to enable or disable exporting the Kubernetes control plane logs for your cluster to CloudWatch Logs. By default, cluster control plane logs aren't exported to CloudWatch Logs. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html">Amazon EKS Cluster Control Plane Logs</a> in the <strong>Amazon EKS User Guide</strong> .
 * <p>
 * <blockquote>
 * <p>
 * CloudWatch Logs ingestion, archive storage, and data scanning rates apply to exported control plane logs. For more information, see <a href="https://docs.aws.amazon.com/cloudwatch/pricing/">CloudWatch Pricing</a> .
 * <p>
 * </blockquote>
 * <p>
 * In most cases, it takes several minutes to create a cluster. After you create an Amazon EKS cluster, you must configure your Kubernetes tooling to communicate with the API server and launch nodes into your cluster. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-auth.html">Allowing users to access your cluster</a> and <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-workers.html">Launching Amazon EKS nodes</a> in the <em>Amazon EKS User Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.eks.*;
 * CfnCluster cfnCluster = CfnCluster.Builder.create(this, "MyCfnCluster")
 *         .resourcesVpcConfig(ResourcesVpcConfigProperty.builder()
 *                 .subnetIds(List.of("subnetIds"))
 *                 // the properties below are optional
 *                 .endpointPrivateAccess(false)
 *                 .endpointPublicAccess(false)
 *                 .publicAccessCidrs(List.of("publicAccessCidrs"))
 *                 .securityGroupIds(List.of("securityGroupIds"))
 *                 .build())
 *         .roleArn("roleArn")
 *         // the properties below are optional
 *         .accessConfig(AccessConfigProperty.builder()
 *                 .authenticationMode("authenticationMode")
 *                 .bootstrapClusterCreatorAdminPermissions(false)
 *                 .build())
 *         .bootstrapSelfManagedAddons(false)
 *         .encryptionConfig(List.of(EncryptionConfigProperty.builder()
 *                 .provider(ProviderProperty.builder()
 *                         .keyArn("keyArn")
 *                         .build())
 *                 .resources(List.of("resources"))
 *                 .build()))
 *         .kubernetesNetworkConfig(KubernetesNetworkConfigProperty.builder()
 *                 .ipFamily("ipFamily")
 *                 .serviceIpv4Cidr("serviceIpv4Cidr")
 *                 .serviceIpv6Cidr("serviceIpv6Cidr")
 *                 .build())
 *         .logging(LoggingProperty.builder()
 *                 .clusterLogging(ClusterLoggingProperty.builder()
 *                         .enabledTypes(List.of(LoggingTypeConfigProperty.builder()
 *                                 .type("type")
 *                                 .build()))
 *                         .build())
 *                 .build())
 *         .name("name")
 *         .outpostConfig(OutpostConfigProperty.builder()
 *                 .controlPlaneInstanceType("controlPlaneInstanceType")
 *                 .outpostArns(List.of("outpostArns"))
 *                 // the properties below are optional
 *                 .controlPlanePlacement(ControlPlanePlacementProperty.builder()
 *                         .groupName("groupName")
 *                         .build())
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .version("version")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-22T22:42:51.416Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.CfnCluster")
public class CfnCluster extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnCluster(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCluster(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.CfnCluster.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnCluster(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.CfnClusterProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ARN of the cluster, such as <code>arn:aws:eks:us-west-2:666666666666:cluster/prod</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The <code>certificate-authority-data</code> for your cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCertificateAuthorityData() {
        return software.amazon.jsii.Kernel.get(this, "attrCertificateAuthorityData", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The cluster security group that was created by Amazon EKS for the cluster.
     * <p>
     * Managed node groups use this security group for control plane to data plane communication.
     * <p>
     * This parameter is only returned by Amazon EKS clusters that support managed node groups. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/managed-node-groups.html">Managed node groups</a> in the <em>Amazon EKS User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrClusterSecurityGroupId() {
        return software.amazon.jsii.Kernel.get(this, "attrClusterSecurityGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Amazon Resource Name (ARN) or alias of the customer master key (CMK).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrEncryptionConfigKeyArn() {
        return software.amazon.jsii.Kernel.get(this, "attrEncryptionConfigKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The endpoint for your Kubernetes API server, such as <code>https://5E1D0CEXAMPLEA591B746AFC5AB30262.yl4.us-west-2.eks.amazonaws.com</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrEndpoint() {
        return software.amazon.jsii.Kernel.get(this, "attrEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of your local Amazon EKS cluster on an AWS Outpost.
     * <p>
     * This property isn't available for an Amazon EKS cluster on the AWS cloud.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The CIDR block that Kubernetes Service IP addresses are assigned from if you created a <code>1.21</code> or later cluster with version <code>&gt;1.10.1</code> or later of the Amazon VPC CNI add-on and specified <code>ipv6</code> for <em>ipFamily</em> when you created the cluster. Kubernetes assigns Service addresses from the unique local address range ( <code>fc00::/7</code> ) because you can't specify a custom <code>IPv6</code> CIDR block when you create the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrKubernetesNetworkConfigServiceIpv6Cidr() {
        return software.amazon.jsii.Kernel.get(this, "attrKubernetesNetworkConfigServiceIpv6Cidr", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The issuer URL for the OIDC identity provider of the cluster, such as <code>https://oidc.eks.us-west-2.amazonaws.com/id/EXAMPLED539D4633E53DE1B716D3041E</code> . If you need to remove <code>https://</code> from this output value, you can include the following code in your template.
     * <p>
     * <code>!Select [1, !Split ["//", !GetAtt EKSCluster.OpenIdConnectIssuerUrl]]</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrOpenIdConnectIssuerUrl() {
        return software.amazon.jsii.Kernel.get(this, "attrOpenIdConnectIssuerUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The VPC configuration that's used by the cluster control plane.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getResourcesVpcConfig() {
        return software.amazon.jsii.Kernel.get(this, "resourcesVpcConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The VPC configuration that's used by the cluster control plane.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourcesVpcConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "resourcesVpcConfig", java.util.Objects.requireNonNull(value, "resourcesVpcConfig is required"));
    }

    /**
     * The VPC configuration that's used by the cluster control plane.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourcesVpcConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.CfnCluster.ResourcesVpcConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "resourcesVpcConfig", java.util.Objects.requireNonNull(value, "resourcesVpcConfig is required"));
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM role that provides permissions for the Kubernetes control plane to make calls to AWS API operations on your behalf.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM role that provides permissions for the Kubernetes control plane to make calls to AWS API operations on your behalf.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRoleArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "roleArn", java.util.Objects.requireNonNull(value, "roleArn is required"));
    }

    /**
     * The access configuration for the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAccessConfig() {
        return software.amazon.jsii.Kernel.get(this, "accessConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The access configuration for the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAccessConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "accessConfig", value);
    }

    /**
     * The access configuration for the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAccessConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.eks.CfnCluster.AccessConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "accessConfig", value);
    }

    /**
     * If you set this value to <code>False</code> when creating a cluster, the default networking add-ons will not be installed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getBootstrapSelfManagedAddons() {
        return software.amazon.jsii.Kernel.get(this, "bootstrapSelfManagedAddons", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * If you set this value to <code>False</code> when creating a cluster, the default networking add-ons will not be installed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBootstrapSelfManagedAddons(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "bootstrapSelfManagedAddons", value);
    }

    /**
     * If you set this value to <code>False</code> when creating a cluster, the default networking add-ons will not be installed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBootstrapSelfManagedAddons(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "bootstrapSelfManagedAddons", value);
    }

    /**
     * The encryption configuration for the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEncryptionConfig() {
        return software.amazon.jsii.Kernel.get(this, "encryptionConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The encryption configuration for the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEncryptionConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "encryptionConfig", value);
    }

    /**
     * The encryption configuration for the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEncryptionConfig(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.eks.CfnCluster.EncryptionConfigProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.eks.CfnCluster.EncryptionConfigProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "encryptionConfig", value);
    }

    /**
     * The Kubernetes network configuration for the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getKubernetesNetworkConfig() {
        return software.amazon.jsii.Kernel.get(this, "kubernetesNetworkConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The Kubernetes network configuration for the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKubernetesNetworkConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "kubernetesNetworkConfig", value);
    }

    /**
     * The Kubernetes network configuration for the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKubernetesNetworkConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.eks.CfnCluster.KubernetesNetworkConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "kubernetesNetworkConfig", value);
    }

    /**
     * The logging configuration for your cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLogging() {
        return software.amazon.jsii.Kernel.get(this, "logging", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The logging configuration for your cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogging(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "logging", value);
    }

    /**
     * The logging configuration for your cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogging(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.eks.CfnCluster.LoggingProperty value) {
        software.amazon.jsii.Kernel.set(this, "logging", value);
    }

    /**
     * The unique name to give to your cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique name to give to your cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * An object representing the configuration of your local Amazon EKS cluster on an AWS Outpost.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getOutpostConfig() {
        return software.amazon.jsii.Kernel.get(this, "outpostConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An object representing the configuration of your local Amazon EKS cluster on an AWS Outpost.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOutpostConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "outpostConfig", value);
    }

    /**
     * An object representing the configuration of your local Amazon EKS cluster on an AWS Outpost.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOutpostConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.eks.CfnCluster.OutpostConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "outpostConfig", value);
    }

    /**
     * The metadata that you apply to the cluster to assist with categorization and organization.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The metadata that you apply to the cluster to assist with categorization and organization.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }

    /**
     * The desired Kubernetes version for your cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getVersion() {
        return software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The desired Kubernetes version for your cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVersion(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "version", value);
    }
    /**
     * The access configuration for the cluster.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.eks.*;
     * AccessConfigProperty accessConfigProperty = AccessConfigProperty.builder()
     *         .authenticationMode("authenticationMode")
     *         .bootstrapClusterCreatorAdminPermissions(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-accessconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-accessconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.CfnCluster.AccessConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(AccessConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AccessConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The desired authentication mode for the cluster.
         * <p>
         * If you create a cluster by using the EKS API, AWS SDKs, or AWS CloudFormation , the default is <code>CONFIG_MAP</code> . If you create the cluster by using the AWS Management Console , the default value is <code>API_AND_CONFIG_MAP</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-accessconfig.html#cfn-eks-cluster-accessconfig-authenticationmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-accessconfig.html#cfn-eks-cluster-accessconfig-authenticationmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAuthenticationMode() {
            return null;
        }

        /**
         * Specifies whether or not the cluster creator IAM principal was set as a cluster admin access entry during cluster creation time.
         * <p>
         * The default value is <code>true</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-accessconfig.html#cfn-eks-cluster-accessconfig-bootstrapclustercreatoradminpermissions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-accessconfig.html#cfn-eks-cluster-accessconfig-bootstrapclustercreatoradminpermissions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBootstrapClusterCreatorAdminPermissions() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AccessConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AccessConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AccessConfigProperty> {
            java.lang.String authenticationMode;
            java.lang.Object bootstrapClusterCreatorAdminPermissions;

            /**
             * Sets the value of {@link AccessConfigProperty#getAuthenticationMode}
             * @param authenticationMode The desired authentication mode for the cluster.
             *                           If you create a cluster by using the EKS API, AWS SDKs, or AWS CloudFormation , the default is <code>CONFIG_MAP</code> . If you create the cluster by using the AWS Management Console , the default value is <code>API_AND_CONFIG_MAP</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authenticationMode(java.lang.String authenticationMode) {
                this.authenticationMode = authenticationMode;
                return this;
            }

            /**
             * Sets the value of {@link AccessConfigProperty#getBootstrapClusterCreatorAdminPermissions}
             * @param bootstrapClusterCreatorAdminPermissions Specifies whether or not the cluster creator IAM principal was set as a cluster admin access entry during cluster creation time.
             *                                                The default value is <code>true</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bootstrapClusterCreatorAdminPermissions(java.lang.Boolean bootstrapClusterCreatorAdminPermissions) {
                this.bootstrapClusterCreatorAdminPermissions = bootstrapClusterCreatorAdminPermissions;
                return this;
            }

            /**
             * Sets the value of {@link AccessConfigProperty#getBootstrapClusterCreatorAdminPermissions}
             * @param bootstrapClusterCreatorAdminPermissions Specifies whether or not the cluster creator IAM principal was set as a cluster admin access entry during cluster creation time.
             *                                                The default value is <code>true</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bootstrapClusterCreatorAdminPermissions(software.amazon.awscdk.IResolvable bootstrapClusterCreatorAdminPermissions) {
                this.bootstrapClusterCreatorAdminPermissions = bootstrapClusterCreatorAdminPermissions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AccessConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AccessConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AccessConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AccessConfigProperty {
            private final java.lang.String authenticationMode;
            private final java.lang.Object bootstrapClusterCreatorAdminPermissions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.authenticationMode = software.amazon.jsii.Kernel.get(this, "authenticationMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bootstrapClusterCreatorAdminPermissions = software.amazon.jsii.Kernel.get(this, "bootstrapClusterCreatorAdminPermissions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.authenticationMode = builder.authenticationMode;
                this.bootstrapClusterCreatorAdminPermissions = builder.bootstrapClusterCreatorAdminPermissions;
            }

            @Override
            public final java.lang.String getAuthenticationMode() {
                return this.authenticationMode;
            }

            @Override
            public final java.lang.Object getBootstrapClusterCreatorAdminPermissions() {
                return this.bootstrapClusterCreatorAdminPermissions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAuthenticationMode() != null) {
                    data.set("authenticationMode", om.valueToTree(this.getAuthenticationMode()));
                }
                if (this.getBootstrapClusterCreatorAdminPermissions() != null) {
                    data.set("bootstrapClusterCreatorAdminPermissions", om.valueToTree(this.getBootstrapClusterCreatorAdminPermissions()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_eks.CfnCluster.AccessConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AccessConfigProperty.Jsii$Proxy that = (AccessConfigProperty.Jsii$Proxy) o;

                if (this.authenticationMode != null ? !this.authenticationMode.equals(that.authenticationMode) : that.authenticationMode != null) return false;
                return this.bootstrapClusterCreatorAdminPermissions != null ? this.bootstrapClusterCreatorAdminPermissions.equals(that.bootstrapClusterCreatorAdminPermissions) : that.bootstrapClusterCreatorAdminPermissions == null;
            }

            @Override
            public final int hashCode() {
                int result = this.authenticationMode != null ? this.authenticationMode.hashCode() : 0;
                result = 31 * result + (this.bootstrapClusterCreatorAdminPermissions != null ? this.bootstrapClusterCreatorAdminPermissions.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The cluster control plane logging configuration for your cluster.
     * <p>
     * <blockquote>
     * <p>
     * When updating a resource, you must include this <code>ClusterLogging</code> property if the previous CloudFormation template of the resource had it.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.eks.*;
     * ClusterLoggingProperty clusterLoggingProperty = ClusterLoggingProperty.builder()
     *         .enabledTypes(List.of(LoggingTypeConfigProperty.builder()
     *                 .type("type")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-clusterlogging.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-clusterlogging.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.CfnCluster.ClusterLoggingProperty")
    @software.amazon.jsii.Jsii.Proxy(ClusterLoggingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ClusterLoggingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The enabled control plane logs for your cluster. All log types are disabled if the array is empty.
         * <p>
         * <blockquote>
         * <p>
         * When updating a resource, you must include this <code>EnabledTypes</code> property if the previous CloudFormation template of the resource had it.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-clusterlogging.html#cfn-eks-cluster-clusterlogging-enabledtypes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-clusterlogging.html#cfn-eks-cluster-clusterlogging-enabledtypes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabledTypes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ClusterLoggingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ClusterLoggingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ClusterLoggingProperty> {
            java.lang.Object enabledTypes;

            /**
             * Sets the value of {@link ClusterLoggingProperty#getEnabledTypes}
             * @param enabledTypes The enabled control plane logs for your cluster. All log types are disabled if the array is empty.
             *                     <blockquote>
             *                     <p>
             *                     When updating a resource, you must include this <code>EnabledTypes</code> property if the previous CloudFormation template of the resource had it.
             *                     <p>
             *                     </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabledTypes(software.amazon.awscdk.IResolvable enabledTypes) {
                this.enabledTypes = enabledTypes;
                return this;
            }

            /**
             * Sets the value of {@link ClusterLoggingProperty#getEnabledTypes}
             * @param enabledTypes The enabled control plane logs for your cluster. All log types are disabled if the array is empty.
             *                     <blockquote>
             *                     <p>
             *                     When updating a resource, you must include this <code>EnabledTypes</code> property if the previous CloudFormation template of the resource had it.
             *                     <p>
             *                     </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabledTypes(java.util.List<? extends java.lang.Object> enabledTypes) {
                this.enabledTypes = enabledTypes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ClusterLoggingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ClusterLoggingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ClusterLoggingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClusterLoggingProperty {
            private final java.lang.Object enabledTypes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabledTypes = software.amazon.jsii.Kernel.get(this, "enabledTypes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabledTypes = builder.enabledTypes;
            }

            @Override
            public final java.lang.Object getEnabledTypes() {
                return this.enabledTypes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnabledTypes() != null) {
                    data.set("enabledTypes", om.valueToTree(this.getEnabledTypes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_eks.CfnCluster.ClusterLoggingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ClusterLoggingProperty.Jsii$Proxy that = (ClusterLoggingProperty.Jsii$Proxy) o;

                return this.enabledTypes != null ? this.enabledTypes.equals(that.enabledTypes) : that.enabledTypes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabledTypes != null ? this.enabledTypes.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The placement configuration for all the control plane instances of your local Amazon EKS cluster on an AWS Outpost.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/eks-outposts-capacity-considerations.html">Capacity considerations</a> in the Amazon EKS User Guide.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.eks.*;
     * ControlPlanePlacementProperty controlPlanePlacementProperty = ControlPlanePlacementProperty.builder()
     *         .groupName("groupName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-controlplaneplacement.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-controlplaneplacement.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.CfnCluster.ControlPlanePlacementProperty")
    @software.amazon.jsii.Jsii.Proxy(ControlPlanePlacementProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ControlPlanePlacementProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the placement group for the Kubernetes control plane instances.
         * <p>
         * This property is only used for a local cluster on an AWS Outpost.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-controlplaneplacement.html#cfn-eks-cluster-controlplaneplacement-groupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-controlplaneplacement.html#cfn-eks-cluster-controlplaneplacement-groupname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getGroupName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ControlPlanePlacementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ControlPlanePlacementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ControlPlanePlacementProperty> {
            java.lang.String groupName;

            /**
             * Sets the value of {@link ControlPlanePlacementProperty#getGroupName}
             * @param groupName The name of the placement group for the Kubernetes control plane instances.
             *                  This property is only used for a local cluster on an AWS Outpost.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groupName(java.lang.String groupName) {
                this.groupName = groupName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ControlPlanePlacementProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ControlPlanePlacementProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ControlPlanePlacementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ControlPlanePlacementProperty {
            private final java.lang.String groupName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.groupName = software.amazon.jsii.Kernel.get(this, "groupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.groupName = builder.groupName;
            }

            @Override
            public final java.lang.String getGroupName() {
                return this.groupName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getGroupName() != null) {
                    data.set("groupName", om.valueToTree(this.getGroupName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_eks.CfnCluster.ControlPlanePlacementProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ControlPlanePlacementProperty.Jsii$Proxy that = (ControlPlanePlacementProperty.Jsii$Proxy) o;

                return this.groupName != null ? this.groupName.equals(that.groupName) : that.groupName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.groupName != null ? this.groupName.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The encryption configuration for the cluster.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.eks.*;
     * EncryptionConfigProperty encryptionConfigProperty = EncryptionConfigProperty.builder()
     *         .provider(ProviderProperty.builder()
     *                 .keyArn("keyArn")
     *                 .build())
     *         .resources(List.of("resources"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-encryptionconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-encryptionconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.CfnCluster.EncryptionConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(EncryptionConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EncryptionConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The encryption provider for the cluster.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-encryptionconfig.html#cfn-eks-cluster-encryptionconfig-provider">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-encryptionconfig.html#cfn-eks-cluster-encryptionconfig-provider</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProvider() {
            return null;
        }

        /**
         * Specifies the resources to be encrypted.
         * <p>
         * The only supported value is <code>secrets</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-encryptionconfig.html#cfn-eks-cluster-encryptionconfig-resources">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-encryptionconfig.html#cfn-eks-cluster-encryptionconfig-resources</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getResources() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EncryptionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EncryptionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EncryptionConfigProperty> {
            java.lang.Object provider;
            java.util.List<java.lang.String> resources;

            /**
             * Sets the value of {@link EncryptionConfigProperty#getProvider}
             * @param provider The encryption provider for the cluster.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder provider(software.amazon.awscdk.IResolvable provider) {
                this.provider = provider;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionConfigProperty#getProvider}
             * @param provider The encryption provider for the cluster.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder provider(software.amazon.awscdk.services.eks.CfnCluster.ProviderProperty provider) {
                this.provider = provider;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionConfigProperty#getResources}
             * @param resources Specifies the resources to be encrypted.
             *                  The only supported value is <code>secrets</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resources(java.util.List<java.lang.String> resources) {
                this.resources = resources;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EncryptionConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EncryptionConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EncryptionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EncryptionConfigProperty {
            private final java.lang.Object provider;
            private final java.util.List<java.lang.String> resources;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.provider = software.amazon.jsii.Kernel.get(this, "provider", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resources = software.amazon.jsii.Kernel.get(this, "resources", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.provider = builder.provider;
                this.resources = builder.resources;
            }

            @Override
            public final java.lang.Object getProvider() {
                return this.provider;
            }

            @Override
            public final java.util.List<java.lang.String> getResources() {
                return this.resources;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getProvider() != null) {
                    data.set("provider", om.valueToTree(this.getProvider()));
                }
                if (this.getResources() != null) {
                    data.set("resources", om.valueToTree(this.getResources()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_eks.CfnCluster.EncryptionConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EncryptionConfigProperty.Jsii$Proxy that = (EncryptionConfigProperty.Jsii$Proxy) o;

                if (this.provider != null ? !this.provider.equals(that.provider) : that.provider != null) return false;
                return this.resources != null ? this.resources.equals(that.resources) : that.resources == null;
            }

            @Override
            public final int hashCode() {
                int result = this.provider != null ? this.provider.hashCode() : 0;
                result = 31 * result + (this.resources != null ? this.resources.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The Kubernetes network configuration for the cluster.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.eks.*;
     * KubernetesNetworkConfigProperty kubernetesNetworkConfigProperty = KubernetesNetworkConfigProperty.builder()
     *         .ipFamily("ipFamily")
     *         .serviceIpv4Cidr("serviceIpv4Cidr")
     *         .serviceIpv6Cidr("serviceIpv6Cidr")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-kubernetesnetworkconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-kubernetesnetworkconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.CfnCluster.KubernetesNetworkConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(KubernetesNetworkConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KubernetesNetworkConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specify which IP family is used to assign Kubernetes pod and service IP addresses.
         * <p>
         * If you don't specify a value, <code>ipv4</code> is used by default. You can only specify an IP family when you create a cluster and can't change this value once the cluster is created. If you specify <code>ipv6</code> , the VPC and subnets that you specify for cluster creation must have both <code>IPv4</code> and <code>IPv6</code> CIDR blocks assigned to them. You can't specify <code>ipv6</code> for clusters in China Regions.
         * <p>
         * You can only specify <code>ipv6</code> for <code>1.21</code> and later clusters that use version <code>1.10.1</code> or later of the Amazon VPC CNI add-on. If you specify <code>ipv6</code> , then ensure that your VPC meets the requirements listed in the considerations listed in <a href="https://docs.aws.amazon.com/eks/latest/userguide/cni-ipv6.html">Assigning IPv6 addresses to pods and services</a> in the Amazon EKS User Guide. Kubernetes assigns services <code>IPv6</code> addresses from the unique local address range <code>(fc00::/7)</code> . You can't specify a custom <code>IPv6</code> CIDR block. Pod addresses are assigned from the subnet's <code>IPv6</code> CIDR.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-kubernetesnetworkconfig.html#cfn-eks-cluster-kubernetesnetworkconfig-ipfamily">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-kubernetesnetworkconfig.html#cfn-eks-cluster-kubernetesnetworkconfig-ipfamily</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIpFamily() {
            return null;
        }

        /**
         * Don't specify a value if you select <code>ipv6</code> for <em>ipFamily</em> .
         * <p>
         * The CIDR block to assign Kubernetes service IP addresses from. If you don't specify a block, Kubernetes assigns addresses from either the <code>10.100.0.0/16</code> or <code>172.20.0.0/16</code> CIDR blocks. We recommend that you specify a block that does not overlap with resources in other networks that are peered or connected to your VPC. The block must meet the following requirements:
         * <p>
         * <ul>
         * <li>Within one of the following private IP address blocks: <code>10.0.0.0/8</code> , <code>172.16.0.0/12</code> , or <code>192.168.0.0/16</code> .</li>
         * <li>Doesn't overlap with any CIDR block assigned to the VPC that you selected for VPC.</li>
         * <li>Between <code>/24</code> and <code>/12</code> .</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * You can only specify a custom CIDR block when you create a cluster. You can't change this value after the cluster is created.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-kubernetesnetworkconfig.html#cfn-eks-cluster-kubernetesnetworkconfig-serviceipv4cidr">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-kubernetesnetworkconfig.html#cfn-eks-cluster-kubernetesnetworkconfig-serviceipv4cidr</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServiceIpv4Cidr() {
            return null;
        }

        /**
         * The CIDR block that Kubernetes pod and service IP addresses are assigned from if you created a 1.21 or later cluster with version 1.10.1 or later of the Amazon VPC CNI add-on and specified <code>ipv6</code> for <em>ipFamily</em> when you created the cluster. Kubernetes assigns service addresses from the unique local address range ( <code>fc00::/7</code> ) because you can't specify a custom IPv6 CIDR block when you create the cluster.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-kubernetesnetworkconfig.html#cfn-eks-cluster-kubernetesnetworkconfig-serviceipv6cidr">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-kubernetesnetworkconfig.html#cfn-eks-cluster-kubernetesnetworkconfig-serviceipv6cidr</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServiceIpv6Cidr() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link KubernetesNetworkConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KubernetesNetworkConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KubernetesNetworkConfigProperty> {
            java.lang.String ipFamily;
            java.lang.String serviceIpv4Cidr;
            java.lang.String serviceIpv6Cidr;

            /**
             * Sets the value of {@link KubernetesNetworkConfigProperty#getIpFamily}
             * @param ipFamily Specify which IP family is used to assign Kubernetes pod and service IP addresses.
             *                 If you don't specify a value, <code>ipv4</code> is used by default. You can only specify an IP family when you create a cluster and can't change this value once the cluster is created. If you specify <code>ipv6</code> , the VPC and subnets that you specify for cluster creation must have both <code>IPv4</code> and <code>IPv6</code> CIDR blocks assigned to them. You can't specify <code>ipv6</code> for clusters in China Regions.
             *                 <p>
             *                 You can only specify <code>ipv6</code> for <code>1.21</code> and later clusters that use version <code>1.10.1</code> or later of the Amazon VPC CNI add-on. If you specify <code>ipv6</code> , then ensure that your VPC meets the requirements listed in the considerations listed in <a href="https://docs.aws.amazon.com/eks/latest/userguide/cni-ipv6.html">Assigning IPv6 addresses to pods and services</a> in the Amazon EKS User Guide. Kubernetes assigns services <code>IPv6</code> addresses from the unique local address range <code>(fc00::/7)</code> . You can't specify a custom <code>IPv6</code> CIDR block. Pod addresses are assigned from the subnet's <code>IPv6</code> CIDR.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipFamily(java.lang.String ipFamily) {
                this.ipFamily = ipFamily;
                return this;
            }

            /**
             * Sets the value of {@link KubernetesNetworkConfigProperty#getServiceIpv4Cidr}
             * @param serviceIpv4Cidr Don't specify a value if you select <code>ipv6</code> for <em>ipFamily</em> .
             *                        The CIDR block to assign Kubernetes service IP addresses from. If you don't specify a block, Kubernetes assigns addresses from either the <code>10.100.0.0/16</code> or <code>172.20.0.0/16</code> CIDR blocks. We recommend that you specify a block that does not overlap with resources in other networks that are peered or connected to your VPC. The block must meet the following requirements:
             *                        <p>
             *                        <ul>
             *                        <li>Within one of the following private IP address blocks: <code>10.0.0.0/8</code> , <code>172.16.0.0/12</code> , or <code>192.168.0.0/16</code> .</li>
             *                        <li>Doesn't overlap with any CIDR block assigned to the VPC that you selected for VPC.</li>
             *                        <li>Between <code>/24</code> and <code>/12</code> .</li>
             *                        </ul>
             *                        <p>
             *                        <blockquote>
             *                        <p>
             *                        You can only specify a custom CIDR block when you create a cluster. You can't change this value after the cluster is created.
             *                        <p>
             *                        </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceIpv4Cidr(java.lang.String serviceIpv4Cidr) {
                this.serviceIpv4Cidr = serviceIpv4Cidr;
                return this;
            }

            /**
             * Sets the value of {@link KubernetesNetworkConfigProperty#getServiceIpv6Cidr}
             * @param serviceIpv6Cidr The CIDR block that Kubernetes pod and service IP addresses are assigned from if you created a 1.21 or later cluster with version 1.10.1 or later of the Amazon VPC CNI add-on and specified <code>ipv6</code> for <em>ipFamily</em> when you created the cluster. Kubernetes assigns service addresses from the unique local address range ( <code>fc00::/7</code> ) because you can't specify a custom IPv6 CIDR block when you create the cluster.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceIpv6Cidr(java.lang.String serviceIpv6Cidr) {
                this.serviceIpv6Cidr = serviceIpv6Cidr;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KubernetesNetworkConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KubernetesNetworkConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KubernetesNetworkConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KubernetesNetworkConfigProperty {
            private final java.lang.String ipFamily;
            private final java.lang.String serviceIpv4Cidr;
            private final java.lang.String serviceIpv6Cidr;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.ipFamily = software.amazon.jsii.Kernel.get(this, "ipFamily", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.serviceIpv4Cidr = software.amazon.jsii.Kernel.get(this, "serviceIpv4Cidr", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.serviceIpv6Cidr = software.amazon.jsii.Kernel.get(this, "serviceIpv6Cidr", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ipFamily = builder.ipFamily;
                this.serviceIpv4Cidr = builder.serviceIpv4Cidr;
                this.serviceIpv6Cidr = builder.serviceIpv6Cidr;
            }

            @Override
            public final java.lang.String getIpFamily() {
                return this.ipFamily;
            }

            @Override
            public final java.lang.String getServiceIpv4Cidr() {
                return this.serviceIpv4Cidr;
            }

            @Override
            public final java.lang.String getServiceIpv6Cidr() {
                return this.serviceIpv6Cidr;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIpFamily() != null) {
                    data.set("ipFamily", om.valueToTree(this.getIpFamily()));
                }
                if (this.getServiceIpv4Cidr() != null) {
                    data.set("serviceIpv4Cidr", om.valueToTree(this.getServiceIpv4Cidr()));
                }
                if (this.getServiceIpv6Cidr() != null) {
                    data.set("serviceIpv6Cidr", om.valueToTree(this.getServiceIpv6Cidr()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_eks.CfnCluster.KubernetesNetworkConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KubernetesNetworkConfigProperty.Jsii$Proxy that = (KubernetesNetworkConfigProperty.Jsii$Proxy) o;

                if (this.ipFamily != null ? !this.ipFamily.equals(that.ipFamily) : that.ipFamily != null) return false;
                if (this.serviceIpv4Cidr != null ? !this.serviceIpv4Cidr.equals(that.serviceIpv4Cidr) : that.serviceIpv4Cidr != null) return false;
                return this.serviceIpv6Cidr != null ? this.serviceIpv6Cidr.equals(that.serviceIpv6Cidr) : that.serviceIpv6Cidr == null;
            }

            @Override
            public final int hashCode() {
                int result = this.ipFamily != null ? this.ipFamily.hashCode() : 0;
                result = 31 * result + (this.serviceIpv4Cidr != null ? this.serviceIpv4Cidr.hashCode() : 0);
                result = 31 * result + (this.serviceIpv6Cidr != null ? this.serviceIpv6Cidr.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Enable or disable exporting the Kubernetes control plane logs for your cluster to CloudWatch Logs.
     * <p>
     * By default, cluster control plane logs aren't exported to CloudWatch Logs. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html">Amazon EKS Cluster control plane logs</a> in the <strong>Amazon EKS User Guide</strong> .
     * <p>
     * <blockquote>
     * <p>
     * When updating a resource, you must include this <code>Logging</code> property if the previous CloudFormation template of the resource had it. &gt; CloudWatch Logs ingestion, archive storage, and data scanning rates apply to exported control plane logs. For more information, see <a href="https://docs.aws.amazon.com/cloudwatch/pricing/">CloudWatch Pricing</a> .
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.eks.*;
     * LoggingProperty loggingProperty = LoggingProperty.builder()
     *         .clusterLogging(ClusterLoggingProperty.builder()
     *                 .enabledTypes(List.of(LoggingTypeConfigProperty.builder()
     *                         .type("type")
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-logging.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-logging.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.CfnCluster.LoggingProperty")
    @software.amazon.jsii.Jsii.Proxy(LoggingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LoggingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The cluster control plane logging configuration for your cluster.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-logging.html#cfn-eks-cluster-logging-clusterlogging">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-logging.html#cfn-eks-cluster-logging-clusterlogging</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getClusterLogging() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LoggingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LoggingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LoggingProperty> {
            java.lang.Object clusterLogging;

            /**
             * Sets the value of {@link LoggingProperty#getClusterLogging}
             * @param clusterLogging The cluster control plane logging configuration for your cluster.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clusterLogging(software.amazon.awscdk.IResolvable clusterLogging) {
                this.clusterLogging = clusterLogging;
                return this;
            }

            /**
             * Sets the value of {@link LoggingProperty#getClusterLogging}
             * @param clusterLogging The cluster control plane logging configuration for your cluster.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clusterLogging(software.amazon.awscdk.services.eks.CfnCluster.ClusterLoggingProperty clusterLogging) {
                this.clusterLogging = clusterLogging;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LoggingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LoggingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LoggingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LoggingProperty {
            private final java.lang.Object clusterLogging;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.clusterLogging = software.amazon.jsii.Kernel.get(this, "clusterLogging", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.clusterLogging = builder.clusterLogging;
            }

            @Override
            public final java.lang.Object getClusterLogging() {
                return this.clusterLogging;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getClusterLogging() != null) {
                    data.set("clusterLogging", om.valueToTree(this.getClusterLogging()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_eks.CfnCluster.LoggingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LoggingProperty.Jsii$Proxy that = (LoggingProperty.Jsii$Proxy) o;

                return this.clusterLogging != null ? this.clusterLogging.equals(that.clusterLogging) : that.clusterLogging == null;
            }

            @Override
            public final int hashCode() {
                int result = this.clusterLogging != null ? this.clusterLogging.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The enabled logging type.
     * <p>
     * For a list of the valid logging types, see the <a href="https://docs.aws.amazon.com/eks/latest/APIReference/API_LogSetup.html#AmazonEKS-Type-LogSetup-types"><code>types</code> property of <code>LogSetup</code></a> in the <em>Amazon EKS API Reference</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.eks.*;
     * LoggingTypeConfigProperty loggingTypeConfigProperty = LoggingTypeConfigProperty.builder()
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-loggingtypeconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-loggingtypeconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.CfnCluster.LoggingTypeConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(LoggingTypeConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LoggingTypeConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the log type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-loggingtypeconfig.html#cfn-eks-cluster-loggingtypeconfig-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-loggingtypeconfig.html#cfn-eks-cluster-loggingtypeconfig-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LoggingTypeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LoggingTypeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LoggingTypeConfigProperty> {
            java.lang.String type;

            /**
             * Sets the value of {@link LoggingTypeConfigProperty#getType}
             * @param type The name of the log type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LoggingTypeConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LoggingTypeConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LoggingTypeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LoggingTypeConfigProperty {
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = builder.type;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_eks.CfnCluster.LoggingTypeConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LoggingTypeConfigProperty.Jsii$Proxy that = (LoggingTypeConfigProperty.Jsii$Proxy) o;

                return this.type != null ? this.type.equals(that.type) : that.type == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type != null ? this.type.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The configuration of your local Amazon EKS cluster on an AWS Outpost.
     * <p>
     * Before creating a cluster on an Outpost, review <a href="https://docs.aws.amazon.com/eks/latest/userguide/eks-outposts-local-cluster-create.html">Creating a local cluster on an Outpost</a> in the <em>Amazon EKS User Guide</em> . This API isn't available for Amazon EKS clusters on the AWS cloud.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.eks.*;
     * OutpostConfigProperty outpostConfigProperty = OutpostConfigProperty.builder()
     *         .controlPlaneInstanceType("controlPlaneInstanceType")
     *         .outpostArns(List.of("outpostArns"))
     *         // the properties below are optional
     *         .controlPlanePlacement(ControlPlanePlacementProperty.builder()
     *                 .groupName("groupName")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-outpostconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-outpostconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.CfnCluster.OutpostConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(OutpostConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OutpostConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon EC2 instance type that you want to use for your local Amazon EKS cluster on Outposts.
         * <p>
         * Choose an instance type based on the number of nodes that your cluster will have. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/eks-outposts-capacity-considerations.html">Capacity considerations</a> in the <em>Amazon EKS User Guide</em> .
         * <p>
         * The instance type that you specify is used for all Kubernetes control plane instances. The instance type can't be changed after cluster creation. The control plane is not automatically scaled by Amazon EKS.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-outpostconfig.html#cfn-eks-cluster-outpostconfig-controlplaneinstancetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-outpostconfig.html#cfn-eks-cluster-outpostconfig-controlplaneinstancetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getControlPlaneInstanceType();

        /**
         * The ARN of the Outpost that you want to use for your local Amazon EKS cluster on Outposts.
         * <p>
         * Only a single Outpost ARN is supported.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-outpostconfig.html#cfn-eks-cluster-outpostconfig-outpostarns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-outpostconfig.html#cfn-eks-cluster-outpostconfig-outpostarns</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getOutpostArns();

        /**
         * An object representing the placement configuration for all the control plane instances of your local Amazon EKS cluster on an AWS Outpost.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/eks-outposts-capacity-considerations.html">Capacity considerations</a> in the <em>Amazon EKS User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-outpostconfig.html#cfn-eks-cluster-outpostconfig-controlplaneplacement">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-outpostconfig.html#cfn-eks-cluster-outpostconfig-controlplaneplacement</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getControlPlanePlacement() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OutpostConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OutpostConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OutpostConfigProperty> {
            java.lang.String controlPlaneInstanceType;
            java.util.List<java.lang.String> outpostArns;
            java.lang.Object controlPlanePlacement;

            /**
             * Sets the value of {@link OutpostConfigProperty#getControlPlaneInstanceType}
             * @param controlPlaneInstanceType The Amazon EC2 instance type that you want to use for your local Amazon EKS cluster on Outposts. This parameter is required.
             *                                 Choose an instance type based on the number of nodes that your cluster will have. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/eks-outposts-capacity-considerations.html">Capacity considerations</a> in the <em>Amazon EKS User Guide</em> .
             *                                 <p>
             *                                 The instance type that you specify is used for all Kubernetes control plane instances. The instance type can't be changed after cluster creation. The control plane is not automatically scaled by Amazon EKS.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder controlPlaneInstanceType(java.lang.String controlPlaneInstanceType) {
                this.controlPlaneInstanceType = controlPlaneInstanceType;
                return this;
            }

            /**
             * Sets the value of {@link OutpostConfigProperty#getOutpostArns}
             * @param outpostArns The ARN of the Outpost that you want to use for your local Amazon EKS cluster on Outposts. This parameter is required.
             *                    Only a single Outpost ARN is supported.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outpostArns(java.util.List<java.lang.String> outpostArns) {
                this.outpostArns = outpostArns;
                return this;
            }

            /**
             * Sets the value of {@link OutpostConfigProperty#getControlPlanePlacement}
             * @param controlPlanePlacement An object representing the placement configuration for all the control plane instances of your local Amazon EKS cluster on an AWS Outpost.
             *                              For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/eks-outposts-capacity-considerations.html">Capacity considerations</a> in the <em>Amazon EKS User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder controlPlanePlacement(software.amazon.awscdk.IResolvable controlPlanePlacement) {
                this.controlPlanePlacement = controlPlanePlacement;
                return this;
            }

            /**
             * Sets the value of {@link OutpostConfigProperty#getControlPlanePlacement}
             * @param controlPlanePlacement An object representing the placement configuration for all the control plane instances of your local Amazon EKS cluster on an AWS Outpost.
             *                              For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/eks-outposts-capacity-considerations.html">Capacity considerations</a> in the <em>Amazon EKS User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder controlPlanePlacement(software.amazon.awscdk.services.eks.CfnCluster.ControlPlanePlacementProperty controlPlanePlacement) {
                this.controlPlanePlacement = controlPlanePlacement;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OutpostConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OutpostConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OutpostConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OutpostConfigProperty {
            private final java.lang.String controlPlaneInstanceType;
            private final java.util.List<java.lang.String> outpostArns;
            private final java.lang.Object controlPlanePlacement;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.controlPlaneInstanceType = software.amazon.jsii.Kernel.get(this, "controlPlaneInstanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.outpostArns = software.amazon.jsii.Kernel.get(this, "outpostArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.controlPlanePlacement = software.amazon.jsii.Kernel.get(this, "controlPlanePlacement", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.controlPlaneInstanceType = java.util.Objects.requireNonNull(builder.controlPlaneInstanceType, "controlPlaneInstanceType is required");
                this.outpostArns = java.util.Objects.requireNonNull(builder.outpostArns, "outpostArns is required");
                this.controlPlanePlacement = builder.controlPlanePlacement;
            }

            @Override
            public final java.lang.String getControlPlaneInstanceType() {
                return this.controlPlaneInstanceType;
            }

            @Override
            public final java.util.List<java.lang.String> getOutpostArns() {
                return this.outpostArns;
            }

            @Override
            public final java.lang.Object getControlPlanePlacement() {
                return this.controlPlanePlacement;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("controlPlaneInstanceType", om.valueToTree(this.getControlPlaneInstanceType()));
                data.set("outpostArns", om.valueToTree(this.getOutpostArns()));
                if (this.getControlPlanePlacement() != null) {
                    data.set("controlPlanePlacement", om.valueToTree(this.getControlPlanePlacement()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_eks.CfnCluster.OutpostConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OutpostConfigProperty.Jsii$Proxy that = (OutpostConfigProperty.Jsii$Proxy) o;

                if (!controlPlaneInstanceType.equals(that.controlPlaneInstanceType)) return false;
                if (!outpostArns.equals(that.outpostArns)) return false;
                return this.controlPlanePlacement != null ? this.controlPlanePlacement.equals(that.controlPlanePlacement) : that.controlPlanePlacement == null;
            }

            @Override
            public final int hashCode() {
                int result = this.controlPlaneInstanceType.hashCode();
                result = 31 * result + (this.outpostArns.hashCode());
                result = 31 * result + (this.controlPlanePlacement != null ? this.controlPlanePlacement.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Identifies the AWS Key Management Service ( AWS KMS ) key used to encrypt the secrets.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.eks.*;
     * ProviderProperty providerProperty = ProviderProperty.builder()
     *         .keyArn("keyArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-provider.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-provider.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.CfnCluster.ProviderProperty")
    @software.amazon.jsii.Jsii.Proxy(ProviderProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProviderProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Amazon Resource Name (ARN) or alias of the KMS key.
         * <p>
         * The KMS key must be symmetric and created in the same AWS Region as the cluster. If the KMS key was created in a different account, the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html">IAM principal</a> must have access to the KMS key. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policy-modifying-external-accounts.html">Allowing users in other accounts to use a KMS key</a> in the <em>AWS Key Management Service Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-provider.html#cfn-eks-cluster-provider-keyarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-provider.html#cfn-eks-cluster-provider-keyarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKeyArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ProviderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProviderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProviderProperty> {
            java.lang.String keyArn;

            /**
             * Sets the value of {@link ProviderProperty#getKeyArn}
             * @param keyArn Amazon Resource Name (ARN) or alias of the KMS key.
             *               The KMS key must be symmetric and created in the same AWS Region as the cluster. If the KMS key was created in a different account, the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html">IAM principal</a> must have access to the KMS key. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policy-modifying-external-accounts.html">Allowing users in other accounts to use a KMS key</a> in the <em>AWS Key Management Service Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyArn(java.lang.String keyArn) {
                this.keyArn = keyArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProviderProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProviderProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ProviderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProviderProperty {
            private final java.lang.String keyArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.keyArn = software.amazon.jsii.Kernel.get(this, "keyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.keyArn = builder.keyArn;
            }

            @Override
            public final java.lang.String getKeyArn() {
                return this.keyArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getKeyArn() != null) {
                    data.set("keyArn", om.valueToTree(this.getKeyArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_eks.CfnCluster.ProviderProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProviderProperty.Jsii$Proxy that = (ProviderProperty.Jsii$Proxy) o;

                return this.keyArn != null ? this.keyArn.equals(that.keyArn) : that.keyArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.keyArn != null ? this.keyArn.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * An object representing the VPC configuration to use for an Amazon EKS cluster.
     * <p>
     * <blockquote>
     * <p>
     * When updating a resource, you must include these properties if the previous CloudFormation template of the resource had them:
     * <p>
     * <ul>
     * <li><code>EndpointPublicAccess</code></li>
     * <li><code>EndpointPrivateAccess</code></li>
     * <li><code>PublicAccessCidrs</code></li>
     * </ul>
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.eks.*;
     * ResourcesVpcConfigProperty resourcesVpcConfigProperty = ResourcesVpcConfigProperty.builder()
     *         .subnetIds(List.of("subnetIds"))
     *         // the properties below are optional
     *         .endpointPrivateAccess(false)
     *         .endpointPublicAccess(false)
     *         .publicAccessCidrs(List.of("publicAccessCidrs"))
     *         .securityGroupIds(List.of("securityGroupIds"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-resourcesvpcconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-resourcesvpcconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.CfnCluster.ResourcesVpcConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ResourcesVpcConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ResourcesVpcConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specify subnets for your Amazon EKS nodes.
         * <p>
         * Amazon EKS creates cross-account elastic network interfaces in these subnets to allow communication between your nodes and the Kubernetes control plane.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-resourcesvpcconfig.html#cfn-eks-cluster-resourcesvpcconfig-subnetids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-resourcesvpcconfig.html#cfn-eks-cluster-resourcesvpcconfig-subnetids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSubnetIds();

        /**
         * Set this value to <code>true</code> to enable private access for your cluster's Kubernetes API server endpoint.
         * <p>
         * If you enable private access, Kubernetes API requests from within your cluster's VPC use the private VPC endpoint. The default value for this parameter is <code>false</code> , which disables private access for your Kubernetes API server. If you disable private access and you have nodes or AWS Fargate pods in the cluster, then ensure that <code>publicAccessCidrs</code> includes the necessary CIDR blocks for communication with the nodes or Fargate pods. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html">Amazon EKS cluster endpoint access control</a> in the <strong>Amazon EKS User Guide</strong> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-resourcesvpcconfig.html#cfn-eks-cluster-resourcesvpcconfig-endpointprivateaccess">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-resourcesvpcconfig.html#cfn-eks-cluster-resourcesvpcconfig-endpointprivateaccess</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEndpointPrivateAccess() {
            return null;
        }

        /**
         * Set this value to <code>false</code> to disable public access to your cluster's Kubernetes API server endpoint.
         * <p>
         * If you disable public access, your cluster's Kubernetes API server can only receive requests from within the cluster VPC. The default value for this parameter is <code>true</code> , which enables public access for your Kubernetes API server. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html">Amazon EKS cluster endpoint access control</a> in the <strong>Amazon EKS User Guide</strong> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-resourcesvpcconfig.html#cfn-eks-cluster-resourcesvpcconfig-endpointpublicaccess">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-resourcesvpcconfig.html#cfn-eks-cluster-resourcesvpcconfig-endpointpublicaccess</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEndpointPublicAccess() {
            return null;
        }

        /**
         * The CIDR blocks that are allowed access to your cluster's public Kubernetes API server endpoint.
         * <p>
         * Communication to the endpoint from addresses outside of the CIDR blocks that you specify is denied. The default value is <code>0.0.0.0/0</code> . If you've disabled private endpoint access, make sure that you specify the necessary CIDR blocks for every node and AWS Fargate <code>Pod</code> in the cluster. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html">Amazon EKS cluster endpoint access control</a> in the <strong>Amazon EKS User Guide</strong> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-resourcesvpcconfig.html#cfn-eks-cluster-resourcesvpcconfig-publicaccesscidrs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-resourcesvpcconfig.html#cfn-eks-cluster-resourcesvpcconfig-publicaccesscidrs</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPublicAccessCidrs() {
            return null;
        }

        /**
         * Specify one or more security groups for the cross-account elastic network interfaces that Amazon EKS creates to use that allow communication between your nodes and the Kubernetes control plane.
         * <p>
         * If you don't specify any security groups, then familiarize yourself with the difference between Amazon EKS defaults for clusters deployed with Kubernetes. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html">Amazon EKS security group considerations</a> in the <strong>Amazon EKS User Guide</strong> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-resourcesvpcconfig.html#cfn-eks-cluster-resourcesvpcconfig-securitygroupids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-resourcesvpcconfig.html#cfn-eks-cluster-resourcesvpcconfig-securitygroupids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroupIds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ResourcesVpcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ResourcesVpcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ResourcesVpcConfigProperty> {
            java.util.List<java.lang.String> subnetIds;
            java.lang.Object endpointPrivateAccess;
            java.lang.Object endpointPublicAccess;
            java.util.List<java.lang.String> publicAccessCidrs;
            java.util.List<java.lang.String> securityGroupIds;

            /**
             * Sets the value of {@link ResourcesVpcConfigProperty#getSubnetIds}
             * @param subnetIds Specify subnets for your Amazon EKS nodes. This parameter is required.
             *                  Amazon EKS creates cross-account elastic network interfaces in these subnets to allow communication between your nodes and the Kubernetes control plane.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnetIds(java.util.List<java.lang.String> subnetIds) {
                this.subnetIds = subnetIds;
                return this;
            }

            /**
             * Sets the value of {@link ResourcesVpcConfigProperty#getEndpointPrivateAccess}
             * @param endpointPrivateAccess Set this value to <code>true</code> to enable private access for your cluster's Kubernetes API server endpoint.
             *                              If you enable private access, Kubernetes API requests from within your cluster's VPC use the private VPC endpoint. The default value for this parameter is <code>false</code> , which disables private access for your Kubernetes API server. If you disable private access and you have nodes or AWS Fargate pods in the cluster, then ensure that <code>publicAccessCidrs</code> includes the necessary CIDR blocks for communication with the nodes or Fargate pods. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html">Amazon EKS cluster endpoint access control</a> in the <strong>Amazon EKS User Guide</strong> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endpointPrivateAccess(java.lang.Boolean endpointPrivateAccess) {
                this.endpointPrivateAccess = endpointPrivateAccess;
                return this;
            }

            /**
             * Sets the value of {@link ResourcesVpcConfigProperty#getEndpointPrivateAccess}
             * @param endpointPrivateAccess Set this value to <code>true</code> to enable private access for your cluster's Kubernetes API server endpoint.
             *                              If you enable private access, Kubernetes API requests from within your cluster's VPC use the private VPC endpoint. The default value for this parameter is <code>false</code> , which disables private access for your Kubernetes API server. If you disable private access and you have nodes or AWS Fargate pods in the cluster, then ensure that <code>publicAccessCidrs</code> includes the necessary CIDR blocks for communication with the nodes or Fargate pods. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html">Amazon EKS cluster endpoint access control</a> in the <strong>Amazon EKS User Guide</strong> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endpointPrivateAccess(software.amazon.awscdk.IResolvable endpointPrivateAccess) {
                this.endpointPrivateAccess = endpointPrivateAccess;
                return this;
            }

            /**
             * Sets the value of {@link ResourcesVpcConfigProperty#getEndpointPublicAccess}
             * @param endpointPublicAccess Set this value to <code>false</code> to disable public access to your cluster's Kubernetes API server endpoint.
             *                             If you disable public access, your cluster's Kubernetes API server can only receive requests from within the cluster VPC. The default value for this parameter is <code>true</code> , which enables public access for your Kubernetes API server. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html">Amazon EKS cluster endpoint access control</a> in the <strong>Amazon EKS User Guide</strong> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endpointPublicAccess(java.lang.Boolean endpointPublicAccess) {
                this.endpointPublicAccess = endpointPublicAccess;
                return this;
            }

            /**
             * Sets the value of {@link ResourcesVpcConfigProperty#getEndpointPublicAccess}
             * @param endpointPublicAccess Set this value to <code>false</code> to disable public access to your cluster's Kubernetes API server endpoint.
             *                             If you disable public access, your cluster's Kubernetes API server can only receive requests from within the cluster VPC. The default value for this parameter is <code>true</code> , which enables public access for your Kubernetes API server. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html">Amazon EKS cluster endpoint access control</a> in the <strong>Amazon EKS User Guide</strong> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endpointPublicAccess(software.amazon.awscdk.IResolvable endpointPublicAccess) {
                this.endpointPublicAccess = endpointPublicAccess;
                return this;
            }

            /**
             * Sets the value of {@link ResourcesVpcConfigProperty#getPublicAccessCidrs}
             * @param publicAccessCidrs The CIDR blocks that are allowed access to your cluster's public Kubernetes API server endpoint.
             *                          Communication to the endpoint from addresses outside of the CIDR blocks that you specify is denied. The default value is <code>0.0.0.0/0</code> . If you've disabled private endpoint access, make sure that you specify the necessary CIDR blocks for every node and AWS Fargate <code>Pod</code> in the cluster. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html">Amazon EKS cluster endpoint access control</a> in the <strong>Amazon EKS User Guide</strong> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder publicAccessCidrs(java.util.List<java.lang.String> publicAccessCidrs) {
                this.publicAccessCidrs = publicAccessCidrs;
                return this;
            }

            /**
             * Sets the value of {@link ResourcesVpcConfigProperty#getSecurityGroupIds}
             * @param securityGroupIds Specify one or more security groups for the cross-account elastic network interfaces that Amazon EKS creates to use that allow communication between your nodes and the Kubernetes control plane.
             *                         If you don't specify any security groups, then familiarize yourself with the difference between Amazon EKS defaults for clusters deployed with Kubernetes. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html">Amazon EKS security group considerations</a> in the <strong>Amazon EKS User Guide</strong> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroupIds(java.util.List<java.lang.String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ResourcesVpcConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ResourcesVpcConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ResourcesVpcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResourcesVpcConfigProperty {
            private final java.util.List<java.lang.String> subnetIds;
            private final java.lang.Object endpointPrivateAccess;
            private final java.lang.Object endpointPublicAccess;
            private final java.util.List<java.lang.String> publicAccessCidrs;
            private final java.util.List<java.lang.String> securityGroupIds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.subnetIds = software.amazon.jsii.Kernel.get(this, "subnetIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.endpointPrivateAccess = software.amazon.jsii.Kernel.get(this, "endpointPrivateAccess", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.endpointPublicAccess = software.amazon.jsii.Kernel.get(this, "endpointPublicAccess", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.publicAccessCidrs = software.amazon.jsii.Kernel.get(this, "publicAccessCidrs", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.securityGroupIds = software.amazon.jsii.Kernel.get(this, "securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.subnetIds = java.util.Objects.requireNonNull(builder.subnetIds, "subnetIds is required");
                this.endpointPrivateAccess = builder.endpointPrivateAccess;
                this.endpointPublicAccess = builder.endpointPublicAccess;
                this.publicAccessCidrs = builder.publicAccessCidrs;
                this.securityGroupIds = builder.securityGroupIds;
            }

            @Override
            public final java.util.List<java.lang.String> getSubnetIds() {
                return this.subnetIds;
            }

            @Override
            public final java.lang.Object getEndpointPrivateAccess() {
                return this.endpointPrivateAccess;
            }

            @Override
            public final java.lang.Object getEndpointPublicAccess() {
                return this.endpointPublicAccess;
            }

            @Override
            public final java.util.List<java.lang.String> getPublicAccessCidrs() {
                return this.publicAccessCidrs;
            }

            @Override
            public final java.util.List<java.lang.String> getSecurityGroupIds() {
                return this.securityGroupIds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("subnetIds", om.valueToTree(this.getSubnetIds()));
                if (this.getEndpointPrivateAccess() != null) {
                    data.set("endpointPrivateAccess", om.valueToTree(this.getEndpointPrivateAccess()));
                }
                if (this.getEndpointPublicAccess() != null) {
                    data.set("endpointPublicAccess", om.valueToTree(this.getEndpointPublicAccess()));
                }
                if (this.getPublicAccessCidrs() != null) {
                    data.set("publicAccessCidrs", om.valueToTree(this.getPublicAccessCidrs()));
                }
                if (this.getSecurityGroupIds() != null) {
                    data.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_eks.CfnCluster.ResourcesVpcConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ResourcesVpcConfigProperty.Jsii$Proxy that = (ResourcesVpcConfigProperty.Jsii$Proxy) o;

                if (!subnetIds.equals(that.subnetIds)) return false;
                if (this.endpointPrivateAccess != null ? !this.endpointPrivateAccess.equals(that.endpointPrivateAccess) : that.endpointPrivateAccess != null) return false;
                if (this.endpointPublicAccess != null ? !this.endpointPublicAccess.equals(that.endpointPublicAccess) : that.endpointPublicAccess != null) return false;
                if (this.publicAccessCidrs != null ? !this.publicAccessCidrs.equals(that.publicAccessCidrs) : that.publicAccessCidrs != null) return false;
                return this.securityGroupIds != null ? this.securityGroupIds.equals(that.securityGroupIds) : that.securityGroupIds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.subnetIds.hashCode();
                result = 31 * result + (this.endpointPrivateAccess != null ? this.endpointPrivateAccess.hashCode() : 0);
                result = 31 * result + (this.endpointPublicAccess != null ? this.endpointPublicAccess.hashCode() : 0);
                result = 31 * result + (this.publicAccessCidrs != null ? this.publicAccessCidrs.hashCode() : 0);
                result = 31 * result + (this.securityGroupIds != null ? this.securityGroupIds.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.eks.CfnCluster}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.eks.CfnCluster> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.eks.CfnClusterProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.eks.CfnClusterProps.Builder();
        }

        /**
         * The VPC configuration that's used by the cluster control plane.
         * <p>
         * Amazon EKS VPC resources have specific requirements to work properly with Kubernetes. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html">Cluster VPC Considerations</a> and <a href="https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html">Cluster Security Group Considerations</a> in the <em>Amazon EKS User Guide</em> . You must specify at least two subnets. You can specify up to five security groups, but we recommend that you use a dedicated security group for your cluster control plane.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-resourcesvpcconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-resourcesvpcconfig</a>
         * @param resourcesVpcConfig The VPC configuration that's used by the cluster control plane. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourcesVpcConfig(final software.amazon.awscdk.IResolvable resourcesVpcConfig) {
            this.props.resourcesVpcConfig(resourcesVpcConfig);
            return this;
        }
        /**
         * The VPC configuration that's used by the cluster control plane.
         * <p>
         * Amazon EKS VPC resources have specific requirements to work properly with Kubernetes. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html">Cluster VPC Considerations</a> and <a href="https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html">Cluster Security Group Considerations</a> in the <em>Amazon EKS User Guide</em> . You must specify at least two subnets. You can specify up to five security groups, but we recommend that you use a dedicated security group for your cluster control plane.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-resourcesvpcconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-resourcesvpcconfig</a>
         * @param resourcesVpcConfig The VPC configuration that's used by the cluster control plane. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourcesVpcConfig(final software.amazon.awscdk.services.eks.CfnCluster.ResourcesVpcConfigProperty resourcesVpcConfig) {
            this.props.resourcesVpcConfig(resourcesVpcConfig);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the IAM role that provides permissions for the Kubernetes control plane to make calls to AWS API operations on your behalf.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/service_IAM_role.html">Amazon EKS Service IAM Role</a> in the <strong>Amazon EKS User Guide</strong> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-rolearn</a>
         * @param roleArn The Amazon Resource Name (ARN) of the IAM role that provides permissions for the Kubernetes control plane to make calls to AWS API operations on your behalf. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(final java.lang.String roleArn) {
            this.props.roleArn(roleArn);
            return this;
        }

        /**
         * The access configuration for the cluster.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-accessconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-accessconfig</a>
         * @param accessConfig The access configuration for the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessConfig(final software.amazon.awscdk.IResolvable accessConfig) {
            this.props.accessConfig(accessConfig);
            return this;
        }
        /**
         * The access configuration for the cluster.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-accessconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-accessconfig</a>
         * @param accessConfig The access configuration for the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessConfig(final software.amazon.awscdk.services.eks.CfnCluster.AccessConfigProperty accessConfig) {
            this.props.accessConfig(accessConfig);
            return this;
        }

        /**
         * If you set this value to <code>False</code> when creating a cluster, the default networking add-ons will not be installed.
         * <p>
         * The default networking addons include vpc-cni, coredns, and kube-proxy.
         * <p>
         * Use this option when you plan to install third-party alternative add-ons or self-manage the default networking add-ons.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-bootstrapselfmanagedaddons">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-bootstrapselfmanagedaddons</a>
         * @param bootstrapSelfManagedAddons If you set this value to <code>False</code> when creating a cluster, the default networking add-ons will not be installed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bootstrapSelfManagedAddons(final java.lang.Boolean bootstrapSelfManagedAddons) {
            this.props.bootstrapSelfManagedAddons(bootstrapSelfManagedAddons);
            return this;
        }
        /**
         * If you set this value to <code>False</code> when creating a cluster, the default networking add-ons will not be installed.
         * <p>
         * The default networking addons include vpc-cni, coredns, and kube-proxy.
         * <p>
         * Use this option when you plan to install third-party alternative add-ons or self-manage the default networking add-ons.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-bootstrapselfmanagedaddons">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-bootstrapselfmanagedaddons</a>
         * @param bootstrapSelfManagedAddons If you set this value to <code>False</code> when creating a cluster, the default networking add-ons will not be installed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bootstrapSelfManagedAddons(final software.amazon.awscdk.IResolvable bootstrapSelfManagedAddons) {
            this.props.bootstrapSelfManagedAddons(bootstrapSelfManagedAddons);
            return this;
        }

        /**
         * The encryption configuration for the cluster.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-encryptionconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-encryptionconfig</a>
         * @param encryptionConfig The encryption configuration for the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionConfig(final software.amazon.awscdk.IResolvable encryptionConfig) {
            this.props.encryptionConfig(encryptionConfig);
            return this;
        }
        /**
         * The encryption configuration for the cluster.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-encryptionconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-encryptionconfig</a>
         * @param encryptionConfig The encryption configuration for the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionConfig(final java.util.List<? extends java.lang.Object> encryptionConfig) {
            this.props.encryptionConfig(encryptionConfig);
            return this;
        }

        /**
         * The Kubernetes network configuration for the cluster.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-kubernetesnetworkconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-kubernetesnetworkconfig</a>
         * @param kubernetesNetworkConfig The Kubernetes network configuration for the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kubernetesNetworkConfig(final software.amazon.awscdk.IResolvable kubernetesNetworkConfig) {
            this.props.kubernetesNetworkConfig(kubernetesNetworkConfig);
            return this;
        }
        /**
         * The Kubernetes network configuration for the cluster.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-kubernetesnetworkconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-kubernetesnetworkconfig</a>
         * @param kubernetesNetworkConfig The Kubernetes network configuration for the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kubernetesNetworkConfig(final software.amazon.awscdk.services.eks.CfnCluster.KubernetesNetworkConfigProperty kubernetesNetworkConfig) {
            this.props.kubernetesNetworkConfig(kubernetesNetworkConfig);
            return this;
        }

        /**
         * The logging configuration for your cluster.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-logging">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-logging</a>
         * @param logging The logging configuration for your cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logging(final software.amazon.awscdk.IResolvable logging) {
            this.props.logging(logging);
            return this;
        }
        /**
         * The logging configuration for your cluster.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-logging">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-logging</a>
         * @param logging The logging configuration for your cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logging(final software.amazon.awscdk.services.eks.CfnCluster.LoggingProperty logging) {
            this.props.logging(logging);
            return this;
        }

        /**
         * The unique name to give to your cluster.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-name</a>
         * @param name The unique name to give to your cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * An object representing the configuration of your local Amazon EKS cluster on an AWS Outpost.
         * <p>
         * This object isn't available for clusters on the AWS cloud.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-outpostconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-outpostconfig</a>
         * @param outpostConfig An object representing the configuration of your local Amazon EKS cluster on an AWS Outpost. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outpostConfig(final software.amazon.awscdk.IResolvable outpostConfig) {
            this.props.outpostConfig(outpostConfig);
            return this;
        }
        /**
         * An object representing the configuration of your local Amazon EKS cluster on an AWS Outpost.
         * <p>
         * This object isn't available for clusters on the AWS cloud.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-outpostconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-outpostconfig</a>
         * @param outpostConfig An object representing the configuration of your local Amazon EKS cluster on an AWS Outpost. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outpostConfig(final software.amazon.awscdk.services.eks.CfnCluster.OutpostConfigProperty outpostConfig) {
            this.props.outpostConfig(outpostConfig);
            return this;
        }

        /**
         * The metadata that you apply to the cluster to assist with categorization and organization.
         * <p>
         * Each tag consists of a key and an optional value, both of which you define. Cluster tags don't propagate to any other resources associated with the cluster.
         * <p>
         * <blockquote>
         * <p>
         * You must have the <code>eks:TagResource</code> and <code>eks:UntagResource</code> permissions for your <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html">IAM principal</a> to manage the AWS CloudFormation stack. If you don't have these permissions, there might be unexpected behavior with stack-level tags propagating to the resource during resource creation and update.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-tags</a>
         * @param tags The metadata that you apply to the cluster to assist with categorization and organization. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * The desired Kubernetes version for your cluster.
         * <p>
         * If you don't specify a value here, the default version available in Amazon EKS is used.
         * <p>
         * <blockquote>
         * <p>
         * The default version might not be the latest version available.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-version">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-version</a>
         * @param version The desired Kubernetes version for your cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder version(final java.lang.String version) {
            this.props.version(version);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.eks.CfnCluster}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.eks.CfnCluster build() {
            return new software.amazon.awscdk.services.eks.CfnCluster(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
