package software.amazon.awscdk.services.eks;

/**
 * Fargate profiles allows an administrator to declare which pods run on Fargate.
 * <p>
 * This declaration is done through the profile’s selectors. Each
 * profile can have up to five selectors that contain a namespace and optional
 * labels. You must define a namespace for every selector. The label field
 * consists of multiple optional key-value pairs. Pods that match a selector (by
 * matching a namespace for the selector and all of the labels specified in the
 * selector) are scheduled on Fargate. If a namespace selector is defined
 * without any labels, Amazon EKS will attempt to schedule all pods that run in
 * that namespace onto Fargate using the profile. If a to-be-scheduled pod
 * matches any of the selectors in the Fargate profile, then that pod is
 * scheduled on Fargate.
 * <p>
 * If a pod matches multiple Fargate profiles, Amazon EKS picks one of the
 * matches at random. In this case, you can specify which profile a pod should
 * use by adding the following Kubernetes label to the pod specification:
 * eks.amazonaws.com/fargate-profile: profile_name. However, the pod must still
 * match a selector in that profile in order to be scheduled onto Fargate.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Cluster cluster;
 * FargateProfile.Builder.create(this, "MyProfile")
 *         .cluster(cluster)
 *         .selectors(List.of(Selector.builder().namespace("default").build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-22T22:42:51.474Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.FargateProfile")
public class FargateProfile extends software.constructs.Construct implements software.amazon.awscdk.ITaggable {

    protected FargateProfile(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected FargateProfile(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public FargateProfile(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.FargateProfileProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * The full Amazon Resource Name (ARN) of the Fargate profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFargateProfileArn() {
        return software.amazon.jsii.Kernel.get(this, "fargateProfileArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the Fargate profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFargateProfileName() {
        return software.amazon.jsii.Kernel.get(this, "fargateProfileName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The pod execution role to use for pods that match the selectors in the Fargate profile.
     * <p>
     * The pod execution role allows Fargate infrastructure to
     * register with your cluster as a node, and it provides read access to Amazon
     * ECR image repositories.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole getPodExecutionRole() {
        return software.amazon.jsii.Kernel.get(this, "podExecutionRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
    }

    /**
     * Resource tags.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.eks.FargateProfile}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.eks.FargateProfile> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.eks.FargateProfileProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.eks.FargateProfileProps.Builder();
        }

        /**
         * The selectors to match for pods to use this Fargate profile.
         * <p>
         * Each selector
         * must have an associated namespace. Optionally, you can also specify labels
         * for a namespace.
         * <p>
         * At least one selector is required and you may specify up to five selectors.
         * <p>
         * @return {@code this}
         * @param selectors The selectors to match for pods to use this Fargate profile. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder selectors(final java.util.List<? extends software.amazon.awscdk.services.eks.Selector> selectors) {
            this.props.selectors(selectors);
            return this;
        }

        /**
         * The name of the Fargate profile.
         * <p>
         * Default: - generated
         * <p>
         * @return {@code this}
         * @param fargateProfileName The name of the Fargate profile. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fargateProfileName(final java.lang.String fargateProfileName) {
            this.props.fargateProfileName(fargateProfileName);
            return this;
        }

        /**
         * The pod execution role to use for pods that match the selectors in the Fargate profile.
         * <p>
         * The pod execution role allows Fargate infrastructure to
         * register with your cluster as a node, and it provides read access to Amazon
         * ECR image repositories.
         * <p>
         * Default: - a role will be automatically created
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/eks/latest/userguide/pod-execution-role.html">https://docs.aws.amazon.com/eks/latest/userguide/pod-execution-role.html</a>
         * @param podExecutionRole The pod execution role to use for pods that match the selectors in the Fargate profile. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder podExecutionRole(final software.amazon.awscdk.services.iam.IRole podExecutionRole) {
            this.props.podExecutionRole(podExecutionRole);
            return this;
        }

        /**
         * Select which subnets to launch your pods into.
         * <p>
         * At this time, pods running
         * on Fargate are not assigned public IP addresses, so only private subnets
         * (with no direct route to an Internet Gateway) are allowed.
         * <p>
         * You must specify the VPC to customize the subnet selection
         * <p>
         * Default: - all private subnets of the VPC are selected.
         * <p>
         * @return {@code this}
         * @param subnetSelection Select which subnets to launch your pods into. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetSelection(final software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection) {
            this.props.subnetSelection(subnetSelection);
            return this;
        }

        /**
         * The VPC from which to select subnets to launch your pods into.
         * <p>
         * By default, all private subnets are selected. You can customize this using
         * <code>subnetSelection</code>.
         * <p>
         * Default: - all private subnets used by the EKS cluster
         * <p>
         * @return {@code this}
         * @param vpc The VPC from which to select subnets to launch your pods into. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        /**
         * The EKS cluster to apply the Fargate profile to.
         * <p>
         * [disable-awslint:ref-via-interface]
         * <p>
         * @return {@code this}
         * @param cluster The EKS cluster to apply the Fargate profile to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cluster(final software.amazon.awscdk.services.eks.Cluster cluster) {
            this.props.cluster(cluster);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.eks.FargateProfile}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.eks.FargateProfile build() {
            return new software.amazon.awscdk.services.eks.FargateProfile(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
