package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * What kind of addresses to allocate to the load balancer.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * ApplicationLoadBalancer lb = ApplicationLoadBalancer.Builder.create(this, "LB")
 *         .vpc(vpc)
 *         .internetFacing(true)
 *         // Whether HTTP/2 is enabled
 *         .http2Enabled(false)
 *         // The idle timeout value, in seconds
 *         .idleTimeout(Duration.seconds(1000))
 *         // Whether HTTP headers with header fields thatare not valid
 *         // are removed by the load balancer (true), or routed to targets
 *         .dropInvalidHeaderFields(true)
 *         // How the load balancer handles requests that might
 *         // pose a security risk to your application
 *         .desyncMitigationMode(DesyncMitigationMode.DEFENSIVE)
 *         // The type of IP addresses to use.
 *         .ipAddressType(IpAddressType.IPV4)
 *         // The duration of client keep-alive connections
 *         .clientKeepAlive(Duration.seconds(500))
 *         // Whether cross-zone load balancing is enabled.
 *         .crossZoneEnabled(true)
 *         // Whether the load balancer blocks traffic through the Internet Gateway (IGW).
 *         .denyAllIgwTraffic(false)
 *         // Whether to preserve host header in the request to the target
 *         .preserveHostHeader(true)
 *         // Whether to add the TLS information header to the request
 *         .xAmznTlsVersionAndCipherSuiteHeaders(true)
 *         // Whether the X-Forwarded-For header should preserve the source port
 *         .preserveXffClientPort(true)
 *         // The processing mode for X-Forwarded-For headers
 *         .xffHeaderProcessingMode(XffHeaderProcessingMode.APPEND)
 *         // Whether to allow a load balancer to route requests to targets if it is unable to forward the request to AWS WAF.
 *         .wafFailOpen(true)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-22T22:42:51.730Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.IpAddressType")
public enum IpAddressType {
    /**
     * Allocate IPv4 addresses.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    IPV4,
    /**
     * Allocate both IPv4 and IPv6 addresses.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DUAL_STACK,
}
