package software.amazon.awscdk.services.greengrass;

/**
 * AWS IoT Greengrass seamlessly extends AWS to edge devices so they can act locally on the data they generate, while still using the cloud for management, analytics, and durable storage.
 * <p>
 * With AWS IoT Greengrass , connected devices can run AWS Lambda functions, execute predictions based on machine learning models, keep device data in sync, and communicate with other devices securely – even when not connected to the internet. For more information, see the <a href="https://docs.aws.amazon.com/greengrass/v1/developerguide/what-is-gg.html">Developer Guide</a> .
 * <p>
 * <blockquote>
 * <p>
 * For AWS Region support, see <a href="https://docs.aws.amazon.com/greengrass/v1/developerguide/cloudformation-support.html">AWS CloudFormation Support for AWS IoT Greengrass</a> in the <em>Developer Guide</em> .
 * <p>
 * </blockquote>
 * <p>
 * The <code>AWS::Greengrass::Group</code> resource represents a group in AWS IoT Greengrass . In the AWS IoT Greengrass API, groups are used to organize your group versions.
 * <p>
 * Groups can reference multiple group versions. All group versions must be associated with a group. A group version references a device definition version, subscription definition version, and other version types that contain the components you want to deploy to a Greengrass core device.
 * <p>
 * To deploy a group version, the group version must reference a core definition version that contains one core. Other version types are optionally included, depending on your business need.
 * <p>
 * <blockquote>
 * <p>
 * When you create a group, you can optionally include an initial group version. To associate a group version later, create a <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html"><code>AWS::Greengrass::GroupVersion</code></a> resource and specify the ID of this group.
 * <p>
 * To change group components (such as devices, subscriptions, or functions), you must create new versions. This is because versions are immutable. For example, to add a function, you create a function definition version that contains the new function (and all other functions that you want to deploy). Then you create a group version that references the new function definition version (and all other version types that you want to deploy).
 * <p>
 * </blockquote>
 * <p>
 * <em>Deploying a Group Version</em>
 * <p>
 * After you create the group version in your AWS CloudFormation template, you can deploy it using the <a href="https://docs.aws.amazon.com/greengrass/v1/apireference/createdeployment-post.html"><code>aws greengrass create-deployment</code></a> command in the AWS CLI or from the <em>Greengrass</em> node in the AWS IoT console. To deploy a group version, you must have a Greengrass service role associated with your AWS account . For more information, see <a href="https://docs.aws.amazon.com/greengrass/v1/developerguide/cloudformation-support.html">AWS CloudFormation Support for AWS IoT Greengrass</a> in the <em>Developer Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.greengrass.*;
 * Object tags;
 * CfnGroup cfnGroup = CfnGroup.Builder.create(this, "MyCfnGroup")
 *         .name("name")
 *         // the properties below are optional
 *         .initialVersion(GroupVersionProperty.builder()
 *                 .connectorDefinitionVersionArn("connectorDefinitionVersionArn")
 *                 .coreDefinitionVersionArn("coreDefinitionVersionArn")
 *                 .deviceDefinitionVersionArn("deviceDefinitionVersionArn")
 *                 .functionDefinitionVersionArn("functionDefinitionVersionArn")
 *                 .loggerDefinitionVersionArn("loggerDefinitionVersionArn")
 *                 .resourceDefinitionVersionArn("resourceDefinitionVersionArn")
 *                 .subscriptionDefinitionVersionArn("subscriptionDefinitionVersionArn")
 *                 .build())
 *         .roleArn("roleArn")
 *         .tags(tags)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-group.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-group.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-22T22:42:52.485Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrass.CfnGroup")
public class CfnGroup extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnGroup(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnGroup(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.greengrass.CfnGroup.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnGroup(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.greengrass.CfnGroupProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ARN of the <code>Group</code> , such as <code>arn:aws:greengrass:us-east-1:  :/greengrass/definition/groups/1234a5b6-78cd-901e-2fgh-3i45j6k178l9</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the <code>Group</code> , such as <code>1234a5b6-78cd-901e-2fgh-3i45j6k178l9</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the last <code>GroupVersion</code> that was added to the <code>Group</code> , such as <code>arn:aws:greengrass:us-east-1:  :/greengrass/definition/groups/1234a5b6-78cd-901e-2fgh-3i45j6k178l9/versions/9876ac30-4bdb-4f9d-95af-b5fdb66be1a2</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLatestVersionArn() {
        return software.amazon.jsii.Kernel.get(this, "attrLatestVersionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the <code>Group</code> , such as <code>MyGroup</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrName() {
        return software.amazon.jsii.Kernel.get(this, "attrName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the IAM role that's attached to the <code>Group</code> , such as <code>arn:aws:iam::  :role/role-name</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "attrRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The time (in milliseconds since the epoch) when the group role was attached to the <code>Group</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrRoleAttachedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrRoleAttachedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The name of the group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The group version to include when the group is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getInitialVersion() {
        return software.amazon.jsii.Kernel.get(this, "initialVersion", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The group version to include when the group is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInitialVersion(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "initialVersion", value);
    }

    /**
     * The group version to include when the group is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInitialVersion(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.greengrass.CfnGroup.GroupVersionProperty value) {
        software.amazon.jsii.Kernel.set(this, "initialVersion", value);
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM role attached to the group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM role attached to the group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRoleArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "roleArn", value);
    }

    /**
     * Application-specific metadata to attach to the group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTagsRaw() {
        return software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Application-specific metadata to attach to the group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * A group version in AWS IoT Greengrass , which references of a core definition version, device definition version, subscription definition version, and other version types that contain the components you want to deploy to a Greengrass core device.
     * <p>
     * The group version must reference a core definition version that contains one core. Other version types are optionally included, depending on your business need.
     * <p>
     * In an AWS CloudFormation template, <code>GroupVersion</code> is the property type of the <code>InitialVersion</code> property in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-group.html"><code>AWS::Greengrass::Group</code></a> resource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.greengrass.*;
     * GroupVersionProperty groupVersionProperty = GroupVersionProperty.builder()
     *         .connectorDefinitionVersionArn("connectorDefinitionVersionArn")
     *         .coreDefinitionVersionArn("coreDefinitionVersionArn")
     *         .deviceDefinitionVersionArn("deviceDefinitionVersionArn")
     *         .functionDefinitionVersionArn("functionDefinitionVersionArn")
     *         .loggerDefinitionVersionArn("loggerDefinitionVersionArn")
     *         .resourceDefinitionVersionArn("resourceDefinitionVersionArn")
     *         .subscriptionDefinitionVersionArn("subscriptionDefinitionVersionArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-group-groupversion.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-group-groupversion.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrass.CfnGroup.GroupVersionProperty")
    @software.amazon.jsii.Jsii.Proxy(GroupVersionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GroupVersionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the connector definition version that contains the connectors you want to deploy with the group version.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-group-groupversion.html#cfn-greengrass-group-groupversion-connectordefinitionversionarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-group-groupversion.html#cfn-greengrass-group-groupversion-connectordefinitionversionarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getConnectorDefinitionVersionArn() {
            return null;
        }

        /**
         * The ARN of the core definition version that contains the core you want to deploy with the group version.
         * <p>
         * Currently, the core definition version can contain only one core.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-group-groupversion.html#cfn-greengrass-group-groupversion-coredefinitionversionarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-group-groupversion.html#cfn-greengrass-group-groupversion-coredefinitionversionarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCoreDefinitionVersionArn() {
            return null;
        }

        /**
         * The ARN of the device definition version that contains the devices you want to deploy with the group version.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-group-groupversion.html#cfn-greengrass-group-groupversion-devicedefinitionversionarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-group-groupversion.html#cfn-greengrass-group-groupversion-devicedefinitionversionarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDeviceDefinitionVersionArn() {
            return null;
        }

        /**
         * The ARN of the function definition version that contains the functions you want to deploy with the group version.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-group-groupversion.html#cfn-greengrass-group-groupversion-functiondefinitionversionarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-group-groupversion.html#cfn-greengrass-group-groupversion-functiondefinitionversionarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFunctionDefinitionVersionArn() {
            return null;
        }

        /**
         * The ARN of the logger definition version that contains the loggers you want to deploy with the group version.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-group-groupversion.html#cfn-greengrass-group-groupversion-loggerdefinitionversionarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-group-groupversion.html#cfn-greengrass-group-groupversion-loggerdefinitionversionarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLoggerDefinitionVersionArn() {
            return null;
        }

        /**
         * The ARN of the resource definition version that contains the resources you want to deploy with the group version.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-group-groupversion.html#cfn-greengrass-group-groupversion-resourcedefinitionversionarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-group-groupversion.html#cfn-greengrass-group-groupversion-resourcedefinitionversionarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResourceDefinitionVersionArn() {
            return null;
        }

        /**
         * The ARN of the subscription definition version that contains the subscriptions you want to deploy with the group version.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-group-groupversion.html#cfn-greengrass-group-groupversion-subscriptiondefinitionversionarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-group-groupversion.html#cfn-greengrass-group-groupversion-subscriptiondefinitionversionarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSubscriptionDefinitionVersionArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GroupVersionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GroupVersionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GroupVersionProperty> {
            java.lang.String connectorDefinitionVersionArn;
            java.lang.String coreDefinitionVersionArn;
            java.lang.String deviceDefinitionVersionArn;
            java.lang.String functionDefinitionVersionArn;
            java.lang.String loggerDefinitionVersionArn;
            java.lang.String resourceDefinitionVersionArn;
            java.lang.String subscriptionDefinitionVersionArn;

            /**
             * Sets the value of {@link GroupVersionProperty#getConnectorDefinitionVersionArn}
             * @param connectorDefinitionVersionArn The Amazon Resource Name (ARN) of the connector definition version that contains the connectors you want to deploy with the group version.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectorDefinitionVersionArn(java.lang.String connectorDefinitionVersionArn) {
                this.connectorDefinitionVersionArn = connectorDefinitionVersionArn;
                return this;
            }

            /**
             * Sets the value of {@link GroupVersionProperty#getCoreDefinitionVersionArn}
             * @param coreDefinitionVersionArn The ARN of the core definition version that contains the core you want to deploy with the group version.
             *                                 Currently, the core definition version can contain only one core.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder coreDefinitionVersionArn(java.lang.String coreDefinitionVersionArn) {
                this.coreDefinitionVersionArn = coreDefinitionVersionArn;
                return this;
            }

            /**
             * Sets the value of {@link GroupVersionProperty#getDeviceDefinitionVersionArn}
             * @param deviceDefinitionVersionArn The ARN of the device definition version that contains the devices you want to deploy with the group version.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deviceDefinitionVersionArn(java.lang.String deviceDefinitionVersionArn) {
                this.deviceDefinitionVersionArn = deviceDefinitionVersionArn;
                return this;
            }

            /**
             * Sets the value of {@link GroupVersionProperty#getFunctionDefinitionVersionArn}
             * @param functionDefinitionVersionArn The ARN of the function definition version that contains the functions you want to deploy with the group version.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder functionDefinitionVersionArn(java.lang.String functionDefinitionVersionArn) {
                this.functionDefinitionVersionArn = functionDefinitionVersionArn;
                return this;
            }

            /**
             * Sets the value of {@link GroupVersionProperty#getLoggerDefinitionVersionArn}
             * @param loggerDefinitionVersionArn The ARN of the logger definition version that contains the loggers you want to deploy with the group version.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder loggerDefinitionVersionArn(java.lang.String loggerDefinitionVersionArn) {
                this.loggerDefinitionVersionArn = loggerDefinitionVersionArn;
                return this;
            }

            /**
             * Sets the value of {@link GroupVersionProperty#getResourceDefinitionVersionArn}
             * @param resourceDefinitionVersionArn The ARN of the resource definition version that contains the resources you want to deploy with the group version.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceDefinitionVersionArn(java.lang.String resourceDefinitionVersionArn) {
                this.resourceDefinitionVersionArn = resourceDefinitionVersionArn;
                return this;
            }

            /**
             * Sets the value of {@link GroupVersionProperty#getSubscriptionDefinitionVersionArn}
             * @param subscriptionDefinitionVersionArn The ARN of the subscription definition version that contains the subscriptions you want to deploy with the group version.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subscriptionDefinitionVersionArn(java.lang.String subscriptionDefinitionVersionArn) {
                this.subscriptionDefinitionVersionArn = subscriptionDefinitionVersionArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GroupVersionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GroupVersionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GroupVersionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GroupVersionProperty {
            private final java.lang.String connectorDefinitionVersionArn;
            private final java.lang.String coreDefinitionVersionArn;
            private final java.lang.String deviceDefinitionVersionArn;
            private final java.lang.String functionDefinitionVersionArn;
            private final java.lang.String loggerDefinitionVersionArn;
            private final java.lang.String resourceDefinitionVersionArn;
            private final java.lang.String subscriptionDefinitionVersionArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.connectorDefinitionVersionArn = software.amazon.jsii.Kernel.get(this, "connectorDefinitionVersionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.coreDefinitionVersionArn = software.amazon.jsii.Kernel.get(this, "coreDefinitionVersionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.deviceDefinitionVersionArn = software.amazon.jsii.Kernel.get(this, "deviceDefinitionVersionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.functionDefinitionVersionArn = software.amazon.jsii.Kernel.get(this, "functionDefinitionVersionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.loggerDefinitionVersionArn = software.amazon.jsii.Kernel.get(this, "loggerDefinitionVersionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.resourceDefinitionVersionArn = software.amazon.jsii.Kernel.get(this, "resourceDefinitionVersionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.subscriptionDefinitionVersionArn = software.amazon.jsii.Kernel.get(this, "subscriptionDefinitionVersionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.connectorDefinitionVersionArn = builder.connectorDefinitionVersionArn;
                this.coreDefinitionVersionArn = builder.coreDefinitionVersionArn;
                this.deviceDefinitionVersionArn = builder.deviceDefinitionVersionArn;
                this.functionDefinitionVersionArn = builder.functionDefinitionVersionArn;
                this.loggerDefinitionVersionArn = builder.loggerDefinitionVersionArn;
                this.resourceDefinitionVersionArn = builder.resourceDefinitionVersionArn;
                this.subscriptionDefinitionVersionArn = builder.subscriptionDefinitionVersionArn;
            }

            @Override
            public final java.lang.String getConnectorDefinitionVersionArn() {
                return this.connectorDefinitionVersionArn;
            }

            @Override
            public final java.lang.String getCoreDefinitionVersionArn() {
                return this.coreDefinitionVersionArn;
            }

            @Override
            public final java.lang.String getDeviceDefinitionVersionArn() {
                return this.deviceDefinitionVersionArn;
            }

            @Override
            public final java.lang.String getFunctionDefinitionVersionArn() {
                return this.functionDefinitionVersionArn;
            }

            @Override
            public final java.lang.String getLoggerDefinitionVersionArn() {
                return this.loggerDefinitionVersionArn;
            }

            @Override
            public final java.lang.String getResourceDefinitionVersionArn() {
                return this.resourceDefinitionVersionArn;
            }

            @Override
            public final java.lang.String getSubscriptionDefinitionVersionArn() {
                return this.subscriptionDefinitionVersionArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getConnectorDefinitionVersionArn() != null) {
                    data.set("connectorDefinitionVersionArn", om.valueToTree(this.getConnectorDefinitionVersionArn()));
                }
                if (this.getCoreDefinitionVersionArn() != null) {
                    data.set("coreDefinitionVersionArn", om.valueToTree(this.getCoreDefinitionVersionArn()));
                }
                if (this.getDeviceDefinitionVersionArn() != null) {
                    data.set("deviceDefinitionVersionArn", om.valueToTree(this.getDeviceDefinitionVersionArn()));
                }
                if (this.getFunctionDefinitionVersionArn() != null) {
                    data.set("functionDefinitionVersionArn", om.valueToTree(this.getFunctionDefinitionVersionArn()));
                }
                if (this.getLoggerDefinitionVersionArn() != null) {
                    data.set("loggerDefinitionVersionArn", om.valueToTree(this.getLoggerDefinitionVersionArn()));
                }
                if (this.getResourceDefinitionVersionArn() != null) {
                    data.set("resourceDefinitionVersionArn", om.valueToTree(this.getResourceDefinitionVersionArn()));
                }
                if (this.getSubscriptionDefinitionVersionArn() != null) {
                    data.set("subscriptionDefinitionVersionArn", om.valueToTree(this.getSubscriptionDefinitionVersionArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_greengrass.CfnGroup.GroupVersionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GroupVersionProperty.Jsii$Proxy that = (GroupVersionProperty.Jsii$Proxy) o;

                if (this.connectorDefinitionVersionArn != null ? !this.connectorDefinitionVersionArn.equals(that.connectorDefinitionVersionArn) : that.connectorDefinitionVersionArn != null) return false;
                if (this.coreDefinitionVersionArn != null ? !this.coreDefinitionVersionArn.equals(that.coreDefinitionVersionArn) : that.coreDefinitionVersionArn != null) return false;
                if (this.deviceDefinitionVersionArn != null ? !this.deviceDefinitionVersionArn.equals(that.deviceDefinitionVersionArn) : that.deviceDefinitionVersionArn != null) return false;
                if (this.functionDefinitionVersionArn != null ? !this.functionDefinitionVersionArn.equals(that.functionDefinitionVersionArn) : that.functionDefinitionVersionArn != null) return false;
                if (this.loggerDefinitionVersionArn != null ? !this.loggerDefinitionVersionArn.equals(that.loggerDefinitionVersionArn) : that.loggerDefinitionVersionArn != null) return false;
                if (this.resourceDefinitionVersionArn != null ? !this.resourceDefinitionVersionArn.equals(that.resourceDefinitionVersionArn) : that.resourceDefinitionVersionArn != null) return false;
                return this.subscriptionDefinitionVersionArn != null ? this.subscriptionDefinitionVersionArn.equals(that.subscriptionDefinitionVersionArn) : that.subscriptionDefinitionVersionArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.connectorDefinitionVersionArn != null ? this.connectorDefinitionVersionArn.hashCode() : 0;
                result = 31 * result + (this.coreDefinitionVersionArn != null ? this.coreDefinitionVersionArn.hashCode() : 0);
                result = 31 * result + (this.deviceDefinitionVersionArn != null ? this.deviceDefinitionVersionArn.hashCode() : 0);
                result = 31 * result + (this.functionDefinitionVersionArn != null ? this.functionDefinitionVersionArn.hashCode() : 0);
                result = 31 * result + (this.loggerDefinitionVersionArn != null ? this.loggerDefinitionVersionArn.hashCode() : 0);
                result = 31 * result + (this.resourceDefinitionVersionArn != null ? this.resourceDefinitionVersionArn.hashCode() : 0);
                result = 31 * result + (this.subscriptionDefinitionVersionArn != null ? this.subscriptionDefinitionVersionArn.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.greengrass.CfnGroup}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.greengrass.CfnGroup> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.greengrass.CfnGroupProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.greengrass.CfnGroupProps.Builder();
        }

        /**
         * The name of the group.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-group.html#cfn-greengrass-group-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-group.html#cfn-greengrass-group-name</a>
         * @param name The name of the group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The group version to include when the group is created.
         * <p>
         * A group version references the Amazon Resource Name (ARN) of a core definition version, device definition version, subscription definition version, and other version types. The group version must reference a core definition version that contains one core. Other version types are optionally included, depending on your business need.
         * <p>
         * <blockquote>
         * <p>
         * To associate a group version after the group is created, create an <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html"><code>AWS::Greengrass::GroupVersion</code></a> resource and specify the ID of this group.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-group.html#cfn-greengrass-group-initialversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-group.html#cfn-greengrass-group-initialversion</a>
         * @param initialVersion The group version to include when the group is created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder initialVersion(final software.amazon.awscdk.IResolvable initialVersion) {
            this.props.initialVersion(initialVersion);
            return this;
        }
        /**
         * The group version to include when the group is created.
         * <p>
         * A group version references the Amazon Resource Name (ARN) of a core definition version, device definition version, subscription definition version, and other version types. The group version must reference a core definition version that contains one core. Other version types are optionally included, depending on your business need.
         * <p>
         * <blockquote>
         * <p>
         * To associate a group version after the group is created, create an <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html"><code>AWS::Greengrass::GroupVersion</code></a> resource and specify the ID of this group.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-group.html#cfn-greengrass-group-initialversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-group.html#cfn-greengrass-group-initialversion</a>
         * @param initialVersion The group version to include when the group is created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder initialVersion(final software.amazon.awscdk.services.greengrass.CfnGroup.GroupVersionProperty initialVersion) {
            this.props.initialVersion(initialVersion);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the IAM role attached to the group.
         * <p>
         * This role contains the permissions that Lambda functions and connectors use to interact with other AWS services.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-group.html#cfn-greengrass-group-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-group.html#cfn-greengrass-group-rolearn</a>
         * @param roleArn The Amazon Resource Name (ARN) of the IAM role attached to the group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(final java.lang.String roleArn) {
            this.props.roleArn(roleArn);
            return this;
        }

        /**
         * Application-specific metadata to attach to the group.
         * <p>
         * You can use tags in IAM policies to control access to AWS IoT Greengrass resources. You can also use tags to categorize your resources. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v1/developerguide/tagging.html">Tagging Your AWS IoT Greengrass Resources</a> in the <em>Developer Guide</em> .
         * <p>
         * This <code>Json</code> property type is processed as a map of key-value pairs. It uses the following format, which is different from most <code>Tags</code> implementations in AWS CloudFormation templates.
         * <p>
         * <blockquote><pre>
         * "Tags": { "KeyName0": "value", "KeyName1": "value", "KeyName2": "value"
         * }
         * </pre></blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-group.html#cfn-greengrass-group-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-group.html#cfn-greengrass-group-tags</a>
         * @param tags Application-specific metadata to attach to the group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.lang.Object tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.greengrass.CfnGroup}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.greengrass.CfnGroup build() {
            return new software.amazon.awscdk.services.greengrass.CfnGroup(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
