package software.amazon.awscdk.services.greengrass;

/**
 * Properties for defining a <code>CfnLoggerDefinitionVersion</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.greengrass.*;
 * CfnLoggerDefinitionVersionProps cfnLoggerDefinitionVersionProps = CfnLoggerDefinitionVersionProps.builder()
 *         .loggerDefinitionId("loggerDefinitionId")
 *         .loggers(List.of(LoggerProperty.builder()
 *                 .component("component")
 *                 .id("id")
 *                 .level("level")
 *                 .type("type")
 *                 // the properties below are optional
 *                 .space(123)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-loggerdefinitionversion.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-loggerdefinitionversion.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-22T22:42:52.494Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrass.CfnLoggerDefinitionVersionProps")
@software.amazon.jsii.Jsii.Proxy(CfnLoggerDefinitionVersionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnLoggerDefinitionVersionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of the logger definition associated with this version.
     * <p>
     * This value is a GUID.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-loggerdefinitionversion.html#cfn-greengrass-loggerdefinitionversion-loggerdefinitionid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-loggerdefinitionversion.html#cfn-greengrass-loggerdefinitionversion-loggerdefinitionid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getLoggerDefinitionId();

    /**
     * The loggers in this version.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-loggerdefinitionversion.html#cfn-greengrass-loggerdefinitionversion-loggers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-loggerdefinitionversion.html#cfn-greengrass-loggerdefinitionversion-loggers</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getLoggers();

    /**
     * @return a {@link Builder} of {@link CfnLoggerDefinitionVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnLoggerDefinitionVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnLoggerDefinitionVersionProps> {
        java.lang.String loggerDefinitionId;
        java.lang.Object loggers;

        /**
         * Sets the value of {@link CfnLoggerDefinitionVersionProps#getLoggerDefinitionId}
         * @param loggerDefinitionId The ID of the logger definition associated with this version. This parameter is required.
         *                           This value is a GUID.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggerDefinitionId(java.lang.String loggerDefinitionId) {
            this.loggerDefinitionId = loggerDefinitionId;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoggerDefinitionVersionProps#getLoggers}
         * @param loggers The loggers in this version. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggers(software.amazon.awscdk.IResolvable loggers) {
            this.loggers = loggers;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoggerDefinitionVersionProps#getLoggers}
         * @param loggers The loggers in this version. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggers(java.util.List<? extends java.lang.Object> loggers) {
            this.loggers = loggers;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnLoggerDefinitionVersionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnLoggerDefinitionVersionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnLoggerDefinitionVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnLoggerDefinitionVersionProps {
        private final java.lang.String loggerDefinitionId;
        private final java.lang.Object loggers;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.loggerDefinitionId = software.amazon.jsii.Kernel.get(this, "loggerDefinitionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.loggers = software.amazon.jsii.Kernel.get(this, "loggers", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.loggerDefinitionId = java.util.Objects.requireNonNull(builder.loggerDefinitionId, "loggerDefinitionId is required");
            this.loggers = java.util.Objects.requireNonNull(builder.loggers, "loggers is required");
        }

        @Override
        public final java.lang.String getLoggerDefinitionId() {
            return this.loggerDefinitionId;
        }

        @Override
        public final java.lang.Object getLoggers() {
            return this.loggers;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("loggerDefinitionId", om.valueToTree(this.getLoggerDefinitionId()));
            data.set("loggers", om.valueToTree(this.getLoggers()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_greengrass.CfnLoggerDefinitionVersionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnLoggerDefinitionVersionProps.Jsii$Proxy that = (CfnLoggerDefinitionVersionProps.Jsii$Proxy) o;

            if (!loggerDefinitionId.equals(that.loggerDefinitionId)) return false;
            return this.loggers.equals(that.loggers);
        }

        @Override
        public final int hashCode() {
            int result = this.loggerDefinitionId.hashCode();
            result = 31 * result + (this.loggers.hashCode());
            return result;
        }
    }
}
