package software.amazon.awscdk.services.iam;

/**
 * Result of a grant() operation.
 * <p>
 * This class is not instantiable by consumers on purpose, so that they will be
 * required to call the Grant factory functions.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Instance instance;
 * Volume volume;
 * Grant attachGrant = volume.grantAttachVolumeByResourceTag(instance.getGrantPrincipal(), List.of(instance));
 * Grant detachGrant = volume.grantDetachVolumeByResourceTag(instance.getGrantPrincipal(), List.of(instance));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-22T22:42:52.680Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iam.Grant")
public class Grant extends software.amazon.jsii.JsiiObject implements software.constructs.IDependable {

    protected Grant(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Grant(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Try to grant the given permissions to the given principal.
     * <p>
     * Absence of a principal leads to a warning, but failing to add
     * the permissions to a present principal is not an error.
     * <p>
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant addToPrincipal(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.GrantOnPrincipalOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iam.Grant.class, "addToPrincipal", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Add a grant both on the principal and on the resource.
     * <p>
     * As long as any principal is given, granting on the principal may fail (in
     * case of a non-identity principal), but granting on the resource will
     * never fail.
     * <p>
     * Statement will be the resource statement.
     * <p>
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant addToPrincipalAndResource(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.GrantOnPrincipalAndResourceOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iam.Grant.class, "addToPrincipalAndResource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Grant the given permissions to the principal.
     * <p>
     * The permissions will be added to the principal policy primarily, falling
     * back to the resource policy if necessary. The permissions must be granted
     * somewhere.
     * <p>
     * <ul>
     * <li>Trying to grant permissions to a principal that does not admit adding to
     * the principal policy while not providing a resource with a resource policy
     * is an error.</li>
     * <li>Trying to grant permissions to an absent principal (possible in the
     * case of imported resources) leads to a warning being added to the
     * resource construct.</li>
     * </ul>
     * <p>
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant addToPrincipalOrResource(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.GrantWithResourceOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iam.Grant.class, "addToPrincipalOrResource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Returns a "no-op" <code>Grant</code> object which represents a "dropped grant".
     * <p>
     * This can be used for e.g. imported resources where you may not be able to modify
     * the resource's policy or some underlying policy which you don't know about.
     * <p>
     * @param grantee The intended grantee. This parameter is required.
     * @param _intent The user's intent (will be ignored at the moment). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant drop(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.lang.String _intent) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iam.Grant.class, "drop", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required"), java.util.Objects.requireNonNull(_intent, "_intent is required") });
    }

    /**
     * Make sure this grant is applied before the given constructs are deployed.
     * <p>
     * The same as construct.node.addDependency(grant), but slightly nicer to read.
     * <p>
     * @param constructs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void applyBefore(final @org.jetbrains.annotations.NotNull software.constructs.IConstruct... constructs) {
        software.amazon.jsii.Kernel.call(this, "applyBefore", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(constructs).toArray(Object[]::new));
    }

    /**
     * Throw an error if this grant wasn't successful.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void assertSuccess() {
        software.amazon.jsii.Kernel.call(this, "assertSuccess", software.amazon.jsii.NativeType.VOID);
    }

    /**
     * Combine two grants into a new one.
     * <p>
     * @param rhs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant combine(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant rhs) {
        return software.amazon.jsii.Kernel.call(this, "combine", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(rhs, "rhs is required") });
    }

    /**
     * The statements that were added to the principal's policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getPrincipalStatements() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "principalStatements", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyStatement.class))));
    }

    /**
     * The statements that were added to the principal's policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getResourceStatements() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "resourceStatements", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyStatement.class))));
    }

    /**
     * Whether the grant operation was successful.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getSuccess() {
        return software.amazon.jsii.Kernel.get(this, "success", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * (deprecated) The statement that was added to the principal's policy.
     * <p>
     * @deprecated Use <code>principalStatements</code> instead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.PolicyStatement getPrincipalStatement() {
        return software.amazon.jsii.Kernel.get(this, "principalStatement", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyStatement.class));
    }

    /**
     * (deprecated) The statement that was added to the resource policy.
     * <p>
     * @deprecated Use <code>resourceStatements</code> instead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.PolicyStatement getResourceStatement() {
        return software.amazon.jsii.Kernel.get(this, "resourceStatement", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyStatement.class));
    }
}
