package software.amazon.awscdk.services.inspectorv2;

/**
 * Details about a filter.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.inspectorv2.*;
 * CfnFilter cfnFilter = CfnFilter.Builder.create(this, "MyCfnFilter")
 *         .filterAction("filterAction")
 *         .filterCriteria(FilterCriteriaProperty.builder()
 *                 .awsAccountId(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .componentId(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .componentType(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .ec2InstanceImageId(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .ec2InstanceSubnetId(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .ec2InstanceVpcId(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .ecrImageArchitecture(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .ecrImageHash(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .ecrImagePushedAt(List.of(DateFilterProperty.builder()
 *                         .endInclusive(123)
 *                         .startInclusive(123)
 *                         .build()))
 *                 .ecrImageRegistry(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .ecrImageRepositoryName(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .ecrImageTags(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .findingArn(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .findingStatus(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .findingType(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .firstObservedAt(List.of(DateFilterProperty.builder()
 *                         .endInclusive(123)
 *                         .startInclusive(123)
 *                         .build()))
 *                 .inspectorScore(List.of(NumberFilterProperty.builder()
 *                         .lowerInclusive(123)
 *                         .upperInclusive(123)
 *                         .build()))
 *                 .lastObservedAt(List.of(DateFilterProperty.builder()
 *                         .endInclusive(123)
 *                         .startInclusive(123)
 *                         .build()))
 *                 .networkProtocol(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .portRange(List.of(PortRangeFilterProperty.builder()
 *                         .beginInclusive(123)
 *                         .endInclusive(123)
 *                         .build()))
 *                 .relatedVulnerabilities(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .resourceId(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .resourceTags(List.of(MapFilterProperty.builder()
 *                         .comparison("comparison")
 *                         // the properties below are optional
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .resourceType(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .severity(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .title(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .updatedAt(List.of(DateFilterProperty.builder()
 *                         .endInclusive(123)
 *                         .startInclusive(123)
 *                         .build()))
 *                 .vendorSeverity(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .vulnerabilityId(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .vulnerabilitySource(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .vulnerablePackages(List.of(PackageFilterProperty.builder()
 *                         .architecture(StringFilterProperty.builder()
 *                                 .comparison("comparison")
 *                                 .value("value")
 *                                 .build())
 *                         .epoch(NumberFilterProperty.builder()
 *                                 .lowerInclusive(123)
 *                                 .upperInclusive(123)
 *                                 .build())
 *                         .name(StringFilterProperty.builder()
 *                                 .comparison("comparison")
 *                                 .value("value")
 *                                 .build())
 *                         .release(StringFilterProperty.builder()
 *                                 .comparison("comparison")
 *                                 .value("value")
 *                                 .build())
 *                         .sourceLayerHash(StringFilterProperty.builder()
 *                                 .comparison("comparison")
 *                                 .value("value")
 *                                 .build())
 *                         .version(StringFilterProperty.builder()
 *                                 .comparison("comparison")
 *                                 .value("value")
 *                                 .build())
 *                         .build()))
 *                 .build())
 *         .name("name")
 *         // the properties below are optional
 *         .description("description")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-filter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-filter.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-22T22:42:52.813Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_inspectorv2.CfnFilter")
public class CfnFilter extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnFilter(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnFilter(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.inspectorv2.CfnFilter.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnFilter(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.inspectorv2.CfnFilterProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Number (ARN) associated with this filter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The action that is to be applied to the findings that match the filter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFilterAction() {
        return software.amazon.jsii.Kernel.get(this, "filterAction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The action that is to be applied to the findings that match the filter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFilterAction(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "filterAction", java.util.Objects.requireNonNull(value, "filterAction is required"));
    }

    /**
     * Details on the filter criteria associated with this filter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getFilterCriteria() {
        return software.amazon.jsii.Kernel.get(this, "filterCriteria", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Details on the filter criteria associated with this filter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFilterCriteria(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "filterCriteria", java.util.Objects.requireNonNull(value, "filterCriteria is required"));
    }

    /**
     * Details on the filter criteria associated with this filter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFilterCriteria(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.inspectorv2.CfnFilter.FilterCriteriaProperty value) {
        software.amazon.jsii.Kernel.set(this, "filterCriteria", java.util.Objects.requireNonNull(value, "filterCriteria is required"));
    }

    /**
     * The name of the filter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the filter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * A description of the filter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A description of the filter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }
    /**
     * Contains details on the time range used to filter findings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.inspectorv2.*;
     * DateFilterProperty dateFilterProperty = DateFilterProperty.builder()
     *         .endInclusive(123)
     *         .startInclusive(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-datefilter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-datefilter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_inspectorv2.CfnFilter.DateFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(DateFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DateFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A timestamp representing the end of the time period filtered on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-datefilter.html#cfn-inspectorv2-filter-datefilter-endinclusive">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-datefilter.html#cfn-inspectorv2-filter-datefilter-endinclusive</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getEndInclusive() {
            return null;
        }

        /**
         * A timestamp representing the start of the time period filtered on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-datefilter.html#cfn-inspectorv2-filter-datefilter-startinclusive">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-datefilter.html#cfn-inspectorv2-filter-datefilter-startinclusive</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getStartInclusive() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DateFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DateFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DateFilterProperty> {
            java.lang.Number endInclusive;
            java.lang.Number startInclusive;

            /**
             * Sets the value of {@link DateFilterProperty#getEndInclusive}
             * @param endInclusive A timestamp representing the end of the time period filtered on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endInclusive(java.lang.Number endInclusive) {
                this.endInclusive = endInclusive;
                return this;
            }

            /**
             * Sets the value of {@link DateFilterProperty#getStartInclusive}
             * @param startInclusive A timestamp representing the start of the time period filtered on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startInclusive(java.lang.Number startInclusive) {
                this.startInclusive = startInclusive;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DateFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DateFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DateFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DateFilterProperty {
            private final java.lang.Number endInclusive;
            private final java.lang.Number startInclusive;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.endInclusive = software.amazon.jsii.Kernel.get(this, "endInclusive", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.startInclusive = software.amazon.jsii.Kernel.get(this, "startInclusive", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.endInclusive = builder.endInclusive;
                this.startInclusive = builder.startInclusive;
            }

            @Override
            public final java.lang.Number getEndInclusive() {
                return this.endInclusive;
            }

            @Override
            public final java.lang.Number getStartInclusive() {
                return this.startInclusive;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEndInclusive() != null) {
                    data.set("endInclusive", om.valueToTree(this.getEndInclusive()));
                }
                if (this.getStartInclusive() != null) {
                    data.set("startInclusive", om.valueToTree(this.getStartInclusive()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_inspectorv2.CfnFilter.DateFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DateFilterProperty.Jsii$Proxy that = (DateFilterProperty.Jsii$Proxy) o;

                if (this.endInclusive != null ? !this.endInclusive.equals(that.endInclusive) : that.endInclusive != null) return false;
                return this.startInclusive != null ? this.startInclusive.equals(that.startInclusive) : that.startInclusive == null;
            }

            @Override
            public final int hashCode() {
                int result = this.endInclusive != null ? this.endInclusive.hashCode() : 0;
                result = 31 * result + (this.startInclusive != null ? this.startInclusive.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Details on the criteria used to define the filter.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.inspectorv2.*;
     * FilterCriteriaProperty filterCriteriaProperty = FilterCriteriaProperty.builder()
     *         .awsAccountId(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .componentId(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .componentType(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .ec2InstanceImageId(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .ec2InstanceSubnetId(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .ec2InstanceVpcId(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .ecrImageArchitecture(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .ecrImageHash(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .ecrImagePushedAt(List.of(DateFilterProperty.builder()
     *                 .endInclusive(123)
     *                 .startInclusive(123)
     *                 .build()))
     *         .ecrImageRegistry(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .ecrImageRepositoryName(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .ecrImageTags(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .findingArn(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .findingStatus(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .findingType(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .firstObservedAt(List.of(DateFilterProperty.builder()
     *                 .endInclusive(123)
     *                 .startInclusive(123)
     *                 .build()))
     *         .inspectorScore(List.of(NumberFilterProperty.builder()
     *                 .lowerInclusive(123)
     *                 .upperInclusive(123)
     *                 .build()))
     *         .lastObservedAt(List.of(DateFilterProperty.builder()
     *                 .endInclusive(123)
     *                 .startInclusive(123)
     *                 .build()))
     *         .networkProtocol(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .portRange(List.of(PortRangeFilterProperty.builder()
     *                 .beginInclusive(123)
     *                 .endInclusive(123)
     *                 .build()))
     *         .relatedVulnerabilities(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .resourceId(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .resourceTags(List.of(MapFilterProperty.builder()
     *                 .comparison("comparison")
     *                 // the properties below are optional
     *                 .key("key")
     *                 .value("value")
     *                 .build()))
     *         .resourceType(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .severity(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .title(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .updatedAt(List.of(DateFilterProperty.builder()
     *                 .endInclusive(123)
     *                 .startInclusive(123)
     *                 .build()))
     *         .vendorSeverity(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .vulnerabilityId(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .vulnerabilitySource(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .vulnerablePackages(List.of(PackageFilterProperty.builder()
     *                 .architecture(StringFilterProperty.builder()
     *                         .comparison("comparison")
     *                         .value("value")
     *                         .build())
     *                 .epoch(NumberFilterProperty.builder()
     *                         .lowerInclusive(123)
     *                         .upperInclusive(123)
     *                         .build())
     *                 .name(StringFilterProperty.builder()
     *                         .comparison("comparison")
     *                         .value("value")
     *                         .build())
     *                 .release(StringFilterProperty.builder()
     *                         .comparison("comparison")
     *                         .value("value")
     *                         .build())
     *                 .sourceLayerHash(StringFilterProperty.builder()
     *                         .comparison("comparison")
     *                         .value("value")
     *                         .build())
     *                 .version(StringFilterProperty.builder()
     *                         .comparison("comparison")
     *                         .value("value")
     *                         .build())
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_inspectorv2.CfnFilter.FilterCriteriaProperty")
    @software.amazon.jsii.Jsii.Proxy(FilterCriteriaProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FilterCriteriaProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Details of the AWS account IDs used to filter findings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-awsaccountid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-awsaccountid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAwsAccountId() {
            return null;
        }

        /**
         * Details of the component IDs used to filter findings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-componentid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-componentid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getComponentId() {
            return null;
        }

        /**
         * Details of the component types used to filter findings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-componenttype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-componenttype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getComponentType() {
            return null;
        }

        /**
         * Details of the Amazon EC2 instance image IDs used to filter findings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-ec2instanceimageid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-ec2instanceimageid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEc2InstanceImageId() {
            return null;
        }

        /**
         * Details of the Amazon EC2 instance subnet IDs used to filter findings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-ec2instancesubnetid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-ec2instancesubnetid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEc2InstanceSubnetId() {
            return null;
        }

        /**
         * Details of the Amazon EC2 instance VPC IDs used to filter findings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-ec2instancevpcid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-ec2instancevpcid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEc2InstanceVpcId() {
            return null;
        }

        /**
         * Details of the Amazon ECR image architecture types used to filter findings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-ecrimagearchitecture">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-ecrimagearchitecture</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEcrImageArchitecture() {
            return null;
        }

        /**
         * Details of the Amazon ECR image hashes used to filter findings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-ecrimagehash">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-ecrimagehash</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEcrImageHash() {
            return null;
        }

        /**
         * Details on the Amazon ECR image push date and time used to filter findings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-ecrimagepushedat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-ecrimagepushedat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEcrImagePushedAt() {
            return null;
        }

        /**
         * Details on the Amazon ECR registry used to filter findings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-ecrimageregistry">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-ecrimageregistry</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEcrImageRegistry() {
            return null;
        }

        /**
         * Details on the name of the Amazon ECR repository used to filter findings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-ecrimagerepositoryname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-ecrimagerepositoryname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEcrImageRepositoryName() {
            return null;
        }

        /**
         * The tags attached to the Amazon ECR container image.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-ecrimagetags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-ecrimagetags</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEcrImageTags() {
            return null;
        }

        /**
         * Details on the finding ARNs used to filter findings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-findingarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-findingarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFindingArn() {
            return null;
        }

        /**
         * Details on the finding status types used to filter findings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-findingstatus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-findingstatus</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFindingStatus() {
            return null;
        }

        /**
         * Details on the finding types used to filter findings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-findingtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-findingtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFindingType() {
            return null;
        }

        /**
         * Details on the date and time a finding was first seen used to filter findings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-firstobservedat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-firstobservedat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFirstObservedAt() {
            return null;
        }

        /**
         * The Amazon Inspector score to filter on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-inspectorscore">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-inspectorscore</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInspectorScore() {
            return null;
        }

        /**
         * Details on the date and time a finding was last seen used to filter findings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-lastobservedat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-lastobservedat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLastObservedAt() {
            return null;
        }

        /**
         * Details on network protocol used to filter findings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-networkprotocol">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-networkprotocol</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNetworkProtocol() {
            return null;
        }

        /**
         * Details on the port ranges used to filter findings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-portrange">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-portrange</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPortRange() {
            return null;
        }

        /**
         * Details on the related vulnerabilities used to filter findings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-relatedvulnerabilities">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-relatedvulnerabilities</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRelatedVulnerabilities() {
            return null;
        }

        /**
         * Details on the resource IDs used to filter findings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-resourceid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-resourceid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResourceId() {
            return null;
        }

        /**
         * Details on the resource tags used to filter findings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-resourcetags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-resourcetags</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResourceTags() {
            return null;
        }

        /**
         * Details on the resource types used to filter findings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-resourcetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-resourcetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResourceType() {
            return null;
        }

        /**
         * Details on the severity used to filter findings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-severity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-severity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSeverity() {
            return null;
        }

        /**
         * Details on the finding title used to filter findings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-title">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-title</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTitle() {
            return null;
        }

        /**
         * Details on the date and time a finding was last updated at used to filter findings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-updatedat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-updatedat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUpdatedAt() {
            return null;
        }

        /**
         * Details on the vendor severity used to filter findings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-vendorseverity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-vendorseverity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVendorSeverity() {
            return null;
        }

        /**
         * Details on the vulnerability ID used to filter findings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-vulnerabilityid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-vulnerabilityid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVulnerabilityId() {
            return null;
        }

        /**
         * Details on the vulnerability score to filter findings by.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-vulnerabilitysource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-vulnerabilitysource</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVulnerabilitySource() {
            return null;
        }

        /**
         * Details on the vulnerable packages used to filter findings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-vulnerablepackages">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-vulnerablepackages</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVulnerablePackages() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FilterCriteriaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FilterCriteriaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FilterCriteriaProperty> {
            java.lang.Object awsAccountId;
            java.lang.Object componentId;
            java.lang.Object componentType;
            java.lang.Object ec2InstanceImageId;
            java.lang.Object ec2InstanceSubnetId;
            java.lang.Object ec2InstanceVpcId;
            java.lang.Object ecrImageArchitecture;
            java.lang.Object ecrImageHash;
            java.lang.Object ecrImagePushedAt;
            java.lang.Object ecrImageRegistry;
            java.lang.Object ecrImageRepositoryName;
            java.lang.Object ecrImageTags;
            java.lang.Object findingArn;
            java.lang.Object findingStatus;
            java.lang.Object findingType;
            java.lang.Object firstObservedAt;
            java.lang.Object inspectorScore;
            java.lang.Object lastObservedAt;
            java.lang.Object networkProtocol;
            java.lang.Object portRange;
            java.lang.Object relatedVulnerabilities;
            java.lang.Object resourceId;
            java.lang.Object resourceTags;
            java.lang.Object resourceType;
            java.lang.Object severity;
            java.lang.Object title;
            java.lang.Object updatedAt;
            java.lang.Object vendorSeverity;
            java.lang.Object vulnerabilityId;
            java.lang.Object vulnerabilitySource;
            java.lang.Object vulnerablePackages;

            /**
             * Sets the value of {@link FilterCriteriaProperty#getAwsAccountId}
             * @param awsAccountId Details of the AWS account IDs used to filter findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsAccountId(software.amazon.awscdk.IResolvable awsAccountId) {
                this.awsAccountId = awsAccountId;
                return this;
            }

            /**
             * Sets the value of {@link FilterCriteriaProperty#getAwsAccountId}
             * @param awsAccountId Details of the AWS account IDs used to filter findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsAccountId(java.util.List<? extends java.lang.Object> awsAccountId) {
                this.awsAccountId = awsAccountId;
                return this;
            }

            /**
             * Sets the value of {@link FilterCriteriaProperty#getComponentId}
             * @param componentId Details of the component IDs used to filter findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder componentId(software.amazon.awscdk.IResolvable componentId) {
                this.componentId = componentId;
                return this;
            }

            /**
             * Sets the value of {@link FilterCriteriaProperty#getComponentId}
             * @param componentId Details of the component IDs used to filter findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder componentId(java.util.List<? extends java.lang.Object> componentId) {
                this.componentId = componentId;
                return this;
            }

            /**
             * Sets the value of {@link FilterCriteriaProperty#getComponentType}
             * @param componentType Details of the component types used to filter findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder componentType(software.amazon.awscdk.IResolvable componentType) {
                this.componentType = componentType;
                return this;
            }

            /**
             * Sets the value of {@link FilterCriteriaProperty#getComponentType}
             * @param componentType Details of the component types used to filter findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder componentType(java.util.List<? extends java.lang.Object> componentType) {
                this.componentType = componentType;
                return this;
            }

            /**
             * Sets the value of {@link FilterCriteriaProperty#getEc2InstanceImageId}
             * @param ec2InstanceImageId Details of the Amazon EC2 instance image IDs used to filter findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ec2InstanceImageId(software.amazon.awscdk.IResolvable ec2InstanceImageId) {
                this.ec2InstanceImageId = ec2InstanceImageId;
                return this;
            }

            /**
             * Sets the value of {@link FilterCriteriaProperty#getEc2InstanceImageId}
             * @param ec2InstanceImageId Details of the Amazon EC2 instance image IDs used to filter findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ec2InstanceImageId(java.util.List<? extends java.lang.Object> ec2InstanceImageId) {
                this.ec2InstanceImageId = ec2InstanceImageId;
                return this;
            }

            /**
             * Sets the value of {@link FilterCriteriaProperty#getEc2InstanceSubnetId}
             * @param ec2InstanceSubnetId Details of the Amazon EC2 instance subnet IDs used to filter findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ec2InstanceSubnetId(software.amazon.awscdk.IResolvable ec2InstanceSubnetId) {
                this.ec2InstanceSubnetId = ec2InstanceSubnetId;
                return this;
            }

            /**
             * Sets the value of {@link FilterCriteriaProperty#getEc2InstanceSubnetId}
             * @param ec2InstanceSubnetId Details of the Amazon EC2 instance subnet IDs used to filter findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ec2InstanceSubnetId(java.util.List<? extends java.lang.Object> ec2InstanceSubnetId) {
                this.ec2InstanceSubnetId = ec2InstanceSubnetId;
                return this;
            }

            /**
             * Sets the value of {@link FilterCriteriaProperty#getEc2InstanceVpcId}
             * @param ec2InstanceVpcId Details of the Amazon EC2 instance VPC IDs used to filter findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ec2InstanceVpcId(software.amazon.awscdk.IResolvable ec2InstanceVpcId) {
                this.ec2InstanceVpcId = ec2InstanceVpcId;
                return this;
            }

            /**
             * Sets the value of {@link FilterCriteriaProperty#getEc2InstanceVpcId}
             * @param ec2InstanceVpcId Details of the Amazon EC2 instance VPC IDs used to filter findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ec2InstanceVpcId(java.util.List<? extends java.lang.Object> ec2InstanceVpcId) {
                this.ec2InstanceVpcId = ec2InstanceVpcId;
                return this;
            }

            /**
             * Sets the value of {@link FilterCriteriaProperty#getEcrImageArchitecture}
             * @param ecrImageArchitecture Details of the Amazon ECR image architecture types used to filter findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ecrImageArchitecture(software.amazon.awscdk.IResolvable ecrImageArchitecture) {
                this.ecrImageArchitecture = ecrImageArchitecture;
                return this;
            }

            /**
             * Sets the value of {@link FilterCriteriaProperty#getEcrImageArchitecture}
             * @param ecrImageArchitecture Details of the Amazon ECR image architecture types used to filter findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ecrImageArchitecture(java.util.List<? extends java.lang.Object> ecrImageArchitecture) {
                this.ecrImageArchitecture = ecrImageArchitecture;
                return this;
            }

            /**
             * Sets the value of {@link FilterCriteriaProperty#getEcrImageHash}
             * @param ecrImageHash Details of the Amazon ECR image hashes used to filter findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ecrImageHash(software.amazon.awscdk.IResolvable ecrImageHash) {
                this.ecrImageHash = ecrImageHash;
                return this;
            }

            /**
             * Sets the value of {@link FilterCriteriaProperty#getEcrImageHash}
             * @param ecrImageHash Details of the Amazon ECR image hashes used to filter findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ecrImageHash(java.util.List<? extends java.lang.Object> ecrImageHash) {
                this.ecrImageHash = ecrImageHash;
                return this;
            }

            /**
             * Sets the value of {@link FilterCriteriaProperty#getEcrImagePushedAt}
             * @param ecrImagePushedAt Details on the Amazon ECR image push date and time used to filter findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ecrImagePushedAt(software.amazon.awscdk.IResolvable ecrImagePushedAt) {
                this.ecrImagePushedAt = ecrImagePushedAt;
                return this;
            }

            /**
             * Sets the value of {@link FilterCriteriaProperty#getEcrImagePushedAt}
             * @param ecrImagePushedAt Details on the Amazon ECR image push date and time used to filter findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ecrImagePushedAt(java.util.List<? extends java.lang.Object> ecrImagePushedAt) {
                this.ecrImagePushedAt = ecrImagePushedAt;
                return this;
            }

            /**
             * Sets the value of {@link FilterCriteriaProperty#getEcrImageRegistry}
             * @param ecrImageRegistry Details on the Amazon ECR registry used to filter findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ecrImageRegistry(software.amazon.awscdk.IResolvable ecrImageRegistry) {
                this.ecrImageRegistry = ecrImageRegistry;
                return this;
            }

            /**
             * Sets the value of {@link FilterCriteriaProperty#getEcrImageRegistry}
             * @param ecrImageRegistry Details on the Amazon ECR registry used to filter findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ecrImageRegistry(java.util.List<? extends java.lang.Object> ecrImageRegistry) {
                this.ecrImageRegistry = ecrImageRegistry;
                return this;
            }

            /**
             * Sets the value of {@link FilterCriteriaProperty#getEcrImageRepositoryName}
             * @param ecrImageRepositoryName Details on the name of the Amazon ECR repository used to filter findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ecrImageRepositoryName(software.amazon.awscdk.IResolvable ecrImageRepositoryName) {
                this.ecrImageRepositoryName = ecrImageRepositoryName;
                return this;
            }

            /**
             * Sets the value of {@link FilterCriteriaProperty#getEcrImageRepositoryName}
             * @param ecrImageRepositoryName Details on the name of the Amazon ECR repository used to filter findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ecrImageRepositoryName(java.util.List<? extends java.lang.Object> ecrImageRepositoryName) {
                this.ecrImageRepositoryName = ecrImageRepositoryName;
                return this;
            }

            /**
             * Sets the value of {@link FilterCriteriaProperty#getEcrImageTags}
             * @param ecrImageTags The tags attached to the Amazon ECR container image.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ecrImageTags(software.amazon.awscdk.IResolvable ecrImageTags) {
                this.ecrImageTags = ecrImageTags;
                return this;
            }

            /**
             * Sets the value of {@link FilterCriteriaProperty#getEcrImageTags}
             * @param ecrImageTags The tags attached to the Amazon ECR container image.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ecrImageTags(java.util.List<? extends java.lang.Object> ecrImageTags) {
                this.ecrImageTags = ecrImageTags;
                return this;
            }

            /**
             * Sets the value of {@link FilterCriteriaProperty#getFindingArn}
             * @param findingArn Details on the finding ARNs used to filter findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder findingArn(software.amazon.awscdk.IResolvable findingArn) {
                this.findingArn = findingArn;
                return this;
            }

            /**
             * Sets the value of {@link FilterCriteriaProperty#getFindingArn}
             * @param findingArn Details on the finding ARNs used to filter findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder findingArn(java.util.List<? extends java.lang.Object> findingArn) {
                this.findingArn = findingArn;
                return this;
            }

            /**
             * Sets the value of {@link FilterCriteriaProperty#getFindingStatus}
             * @param findingStatus Details on the finding status types used to filter findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder findingStatus(software.amazon.awscdk.IResolvable findingStatus) {
                this.findingStatus = findingStatus;
                return this;
            }

            /**
             * Sets the value of {@link FilterCriteriaProperty#getFindingStatus}
             * @param findingStatus Details on the finding status types used to filter findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder findingStatus(java.util.List<? extends java.lang.Object> findingStatus) {
                this.findingStatus = findingStatus;
                return this;
            }

            /**
             * Sets the value of {@link FilterCriteriaProperty#getFindingType}
             * @param findingType Details on the finding types used to filter findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder findingType(software.amazon.awscdk.IResolvable findingType) {
                this.findingType = findingType;
                return this;
            }

            /**
             * Sets the value of {@link FilterCriteriaProperty#getFindingType}
             * @param findingType Details on the finding types used to filter findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder findingType(java.util.List<? extends java.lang.Object> findingType) {
                this.findingType = findingType;
                return this;
            }

            /**
             * Sets the value of {@link FilterCriteriaProperty#getFirstObservedAt}
             * @param firstObservedAt Details on the date and time a finding was first seen used to filter findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder firstObservedAt(software.amazon.awscdk.IResolvable firstObservedAt) {
                this.firstObservedAt = firstObservedAt;
                return this;
            }

            /**
             * Sets the value of {@link FilterCriteriaProperty#getFirstObservedAt}
             * @param firstObservedAt Details on the date and time a finding was first seen used to filter findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder firstObservedAt(java.util.List<? extends java.lang.Object> firstObservedAt) {
                this.firstObservedAt = firstObservedAt;
                return this;
            }

            /**
             * Sets the value of {@link FilterCriteriaProperty#getInspectorScore}
             * @param inspectorScore The Amazon Inspector score to filter on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inspectorScore(software.amazon.awscdk.IResolvable inspectorScore) {
                this.inspectorScore = inspectorScore;
                return this;
            }

            /**
             * Sets the value of {@link FilterCriteriaProperty#getInspectorScore}
             * @param inspectorScore The Amazon Inspector score to filter on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inspectorScore(java.util.List<? extends java.lang.Object> inspectorScore) {
                this.inspectorScore = inspectorScore;
                return this;
            }

            /**
             * Sets the value of {@link FilterCriteriaProperty#getLastObservedAt}
             * @param lastObservedAt Details on the date and time a finding was last seen used to filter findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lastObservedAt(software.amazon.awscdk.IResolvable lastObservedAt) {
                this.lastObservedAt = lastObservedAt;
                return this;
            }

            /**
             * Sets the value of {@link FilterCriteriaProperty#getLastObservedAt}
             * @param lastObservedAt Details on the date and time a finding was last seen used to filter findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lastObservedAt(java.util.List<? extends java.lang.Object> lastObservedAt) {
                this.lastObservedAt = lastObservedAt;
                return this;
            }

            /**
             * Sets the value of {@link FilterCriteriaProperty#getNetworkProtocol}
             * @param networkProtocol Details on network protocol used to filter findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkProtocol(software.amazon.awscdk.IResolvable networkProtocol) {
                this.networkProtocol = networkProtocol;
                return this;
            }

            /**
             * Sets the value of {@link FilterCriteriaProperty#getNetworkProtocol}
             * @param networkProtocol Details on network protocol used to filter findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkProtocol(java.util.List<? extends java.lang.Object> networkProtocol) {
                this.networkProtocol = networkProtocol;
                return this;
            }

            /**
             * Sets the value of {@link FilterCriteriaProperty#getPortRange}
             * @param portRange Details on the port ranges used to filter findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder portRange(software.amazon.awscdk.IResolvable portRange) {
                this.portRange = portRange;
                return this;
            }

            /**
             * Sets the value of {@link FilterCriteriaProperty#getPortRange}
             * @param portRange Details on the port ranges used to filter findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder portRange(java.util.List<? extends java.lang.Object> portRange) {
                this.portRange = portRange;
                return this;
            }

            /**
             * Sets the value of {@link FilterCriteriaProperty#getRelatedVulnerabilities}
             * @param relatedVulnerabilities Details on the related vulnerabilities used to filter findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder relatedVulnerabilities(software.amazon.awscdk.IResolvable relatedVulnerabilities) {
                this.relatedVulnerabilities = relatedVulnerabilities;
                return this;
            }

            /**
             * Sets the value of {@link FilterCriteriaProperty#getRelatedVulnerabilities}
             * @param relatedVulnerabilities Details on the related vulnerabilities used to filter findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder relatedVulnerabilities(java.util.List<? extends java.lang.Object> relatedVulnerabilities) {
                this.relatedVulnerabilities = relatedVulnerabilities;
                return this;
            }

            /**
             * Sets the value of {@link FilterCriteriaProperty#getResourceId}
             * @param resourceId Details on the resource IDs used to filter findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceId(software.amazon.awscdk.IResolvable resourceId) {
                this.resourceId = resourceId;
                return this;
            }

            /**
             * Sets the value of {@link FilterCriteriaProperty#getResourceId}
             * @param resourceId Details on the resource IDs used to filter findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceId(java.util.List<? extends java.lang.Object> resourceId) {
                this.resourceId = resourceId;
                return this;
            }

            /**
             * Sets the value of {@link FilterCriteriaProperty#getResourceTags}
             * @param resourceTags Details on the resource tags used to filter findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceTags(software.amazon.awscdk.IResolvable resourceTags) {
                this.resourceTags = resourceTags;
                return this;
            }

            /**
             * Sets the value of {@link FilterCriteriaProperty#getResourceTags}
             * @param resourceTags Details on the resource tags used to filter findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceTags(java.util.List<? extends java.lang.Object> resourceTags) {
                this.resourceTags = resourceTags;
                return this;
            }

            /**
             * Sets the value of {@link FilterCriteriaProperty#getResourceType}
             * @param resourceType Details on the resource types used to filter findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceType(software.amazon.awscdk.IResolvable resourceType) {
                this.resourceType = resourceType;
                return this;
            }

            /**
             * Sets the value of {@link FilterCriteriaProperty#getResourceType}
             * @param resourceType Details on the resource types used to filter findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceType(java.util.List<? extends java.lang.Object> resourceType) {
                this.resourceType = resourceType;
                return this;
            }

            /**
             * Sets the value of {@link FilterCriteriaProperty#getSeverity}
             * @param severity Details on the severity used to filter findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder severity(software.amazon.awscdk.IResolvable severity) {
                this.severity = severity;
                return this;
            }

            /**
             * Sets the value of {@link FilterCriteriaProperty#getSeverity}
             * @param severity Details on the severity used to filter findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder severity(java.util.List<? extends java.lang.Object> severity) {
                this.severity = severity;
                return this;
            }

            /**
             * Sets the value of {@link FilterCriteriaProperty#getTitle}
             * @param title Details on the finding title used to filter findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder title(software.amazon.awscdk.IResolvable title) {
                this.title = title;
                return this;
            }

            /**
             * Sets the value of {@link FilterCriteriaProperty#getTitle}
             * @param title Details on the finding title used to filter findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder title(java.util.List<? extends java.lang.Object> title) {
                this.title = title;
                return this;
            }

            /**
             * Sets the value of {@link FilterCriteriaProperty#getUpdatedAt}
             * @param updatedAt Details on the date and time a finding was last updated at used to filter findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder updatedAt(software.amazon.awscdk.IResolvable updatedAt) {
                this.updatedAt = updatedAt;
                return this;
            }

            /**
             * Sets the value of {@link FilterCriteriaProperty#getUpdatedAt}
             * @param updatedAt Details on the date and time a finding was last updated at used to filter findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder updatedAt(java.util.List<? extends java.lang.Object> updatedAt) {
                this.updatedAt = updatedAt;
                return this;
            }

            /**
             * Sets the value of {@link FilterCriteriaProperty#getVendorSeverity}
             * @param vendorSeverity Details on the vendor severity used to filter findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vendorSeverity(software.amazon.awscdk.IResolvable vendorSeverity) {
                this.vendorSeverity = vendorSeverity;
                return this;
            }

            /**
             * Sets the value of {@link FilterCriteriaProperty#getVendorSeverity}
             * @param vendorSeverity Details on the vendor severity used to filter findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vendorSeverity(java.util.List<? extends java.lang.Object> vendorSeverity) {
                this.vendorSeverity = vendorSeverity;
                return this;
            }

            /**
             * Sets the value of {@link FilterCriteriaProperty#getVulnerabilityId}
             * @param vulnerabilityId Details on the vulnerability ID used to filter findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vulnerabilityId(software.amazon.awscdk.IResolvable vulnerabilityId) {
                this.vulnerabilityId = vulnerabilityId;
                return this;
            }

            /**
             * Sets the value of {@link FilterCriteriaProperty#getVulnerabilityId}
             * @param vulnerabilityId Details on the vulnerability ID used to filter findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vulnerabilityId(java.util.List<? extends java.lang.Object> vulnerabilityId) {
                this.vulnerabilityId = vulnerabilityId;
                return this;
            }

            /**
             * Sets the value of {@link FilterCriteriaProperty#getVulnerabilitySource}
             * @param vulnerabilitySource Details on the vulnerability score to filter findings by.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vulnerabilitySource(software.amazon.awscdk.IResolvable vulnerabilitySource) {
                this.vulnerabilitySource = vulnerabilitySource;
                return this;
            }

            /**
             * Sets the value of {@link FilterCriteriaProperty#getVulnerabilitySource}
             * @param vulnerabilitySource Details on the vulnerability score to filter findings by.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vulnerabilitySource(java.util.List<? extends java.lang.Object> vulnerabilitySource) {
                this.vulnerabilitySource = vulnerabilitySource;
                return this;
            }

            /**
             * Sets the value of {@link FilterCriteriaProperty#getVulnerablePackages}
             * @param vulnerablePackages Details on the vulnerable packages used to filter findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vulnerablePackages(software.amazon.awscdk.IResolvable vulnerablePackages) {
                this.vulnerablePackages = vulnerablePackages;
                return this;
            }

            /**
             * Sets the value of {@link FilterCriteriaProperty#getVulnerablePackages}
             * @param vulnerablePackages Details on the vulnerable packages used to filter findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vulnerablePackages(java.util.List<? extends java.lang.Object> vulnerablePackages) {
                this.vulnerablePackages = vulnerablePackages;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FilterCriteriaProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FilterCriteriaProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FilterCriteriaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FilterCriteriaProperty {
            private final java.lang.Object awsAccountId;
            private final java.lang.Object componentId;
            private final java.lang.Object componentType;
            private final java.lang.Object ec2InstanceImageId;
            private final java.lang.Object ec2InstanceSubnetId;
            private final java.lang.Object ec2InstanceVpcId;
            private final java.lang.Object ecrImageArchitecture;
            private final java.lang.Object ecrImageHash;
            private final java.lang.Object ecrImagePushedAt;
            private final java.lang.Object ecrImageRegistry;
            private final java.lang.Object ecrImageRepositoryName;
            private final java.lang.Object ecrImageTags;
            private final java.lang.Object findingArn;
            private final java.lang.Object findingStatus;
            private final java.lang.Object findingType;
            private final java.lang.Object firstObservedAt;
            private final java.lang.Object inspectorScore;
            private final java.lang.Object lastObservedAt;
            private final java.lang.Object networkProtocol;
            private final java.lang.Object portRange;
            private final java.lang.Object relatedVulnerabilities;
            private final java.lang.Object resourceId;
            private final java.lang.Object resourceTags;
            private final java.lang.Object resourceType;
            private final java.lang.Object severity;
            private final java.lang.Object title;
            private final java.lang.Object updatedAt;
            private final java.lang.Object vendorSeverity;
            private final java.lang.Object vulnerabilityId;
            private final java.lang.Object vulnerabilitySource;
            private final java.lang.Object vulnerablePackages;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.awsAccountId = software.amazon.jsii.Kernel.get(this, "awsAccountId", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.componentId = software.amazon.jsii.Kernel.get(this, "componentId", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.componentType = software.amazon.jsii.Kernel.get(this, "componentType", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ec2InstanceImageId = software.amazon.jsii.Kernel.get(this, "ec2InstanceImageId", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ec2InstanceSubnetId = software.amazon.jsii.Kernel.get(this, "ec2InstanceSubnetId", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ec2InstanceVpcId = software.amazon.jsii.Kernel.get(this, "ec2InstanceVpcId", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ecrImageArchitecture = software.amazon.jsii.Kernel.get(this, "ecrImageArchitecture", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ecrImageHash = software.amazon.jsii.Kernel.get(this, "ecrImageHash", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ecrImagePushedAt = software.amazon.jsii.Kernel.get(this, "ecrImagePushedAt", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ecrImageRegistry = software.amazon.jsii.Kernel.get(this, "ecrImageRegistry", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ecrImageRepositoryName = software.amazon.jsii.Kernel.get(this, "ecrImageRepositoryName", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ecrImageTags = software.amazon.jsii.Kernel.get(this, "ecrImageTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.findingArn = software.amazon.jsii.Kernel.get(this, "findingArn", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.findingStatus = software.amazon.jsii.Kernel.get(this, "findingStatus", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.findingType = software.amazon.jsii.Kernel.get(this, "findingType", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.firstObservedAt = software.amazon.jsii.Kernel.get(this, "firstObservedAt", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.inspectorScore = software.amazon.jsii.Kernel.get(this, "inspectorScore", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.lastObservedAt = software.amazon.jsii.Kernel.get(this, "lastObservedAt", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.networkProtocol = software.amazon.jsii.Kernel.get(this, "networkProtocol", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.portRange = software.amazon.jsii.Kernel.get(this, "portRange", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.relatedVulnerabilities = software.amazon.jsii.Kernel.get(this, "relatedVulnerabilities", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resourceId = software.amazon.jsii.Kernel.get(this, "resourceId", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resourceTags = software.amazon.jsii.Kernel.get(this, "resourceTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resourceType = software.amazon.jsii.Kernel.get(this, "resourceType", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.severity = software.amazon.jsii.Kernel.get(this, "severity", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.title = software.amazon.jsii.Kernel.get(this, "title", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.updatedAt = software.amazon.jsii.Kernel.get(this, "updatedAt", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.vendorSeverity = software.amazon.jsii.Kernel.get(this, "vendorSeverity", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.vulnerabilityId = software.amazon.jsii.Kernel.get(this, "vulnerabilityId", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.vulnerabilitySource = software.amazon.jsii.Kernel.get(this, "vulnerabilitySource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.vulnerablePackages = software.amazon.jsii.Kernel.get(this, "vulnerablePackages", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.awsAccountId = builder.awsAccountId;
                this.componentId = builder.componentId;
                this.componentType = builder.componentType;
                this.ec2InstanceImageId = builder.ec2InstanceImageId;
                this.ec2InstanceSubnetId = builder.ec2InstanceSubnetId;
                this.ec2InstanceVpcId = builder.ec2InstanceVpcId;
                this.ecrImageArchitecture = builder.ecrImageArchitecture;
                this.ecrImageHash = builder.ecrImageHash;
                this.ecrImagePushedAt = builder.ecrImagePushedAt;
                this.ecrImageRegistry = builder.ecrImageRegistry;
                this.ecrImageRepositoryName = builder.ecrImageRepositoryName;
                this.ecrImageTags = builder.ecrImageTags;
                this.findingArn = builder.findingArn;
                this.findingStatus = builder.findingStatus;
                this.findingType = builder.findingType;
                this.firstObservedAt = builder.firstObservedAt;
                this.inspectorScore = builder.inspectorScore;
                this.lastObservedAt = builder.lastObservedAt;
                this.networkProtocol = builder.networkProtocol;
                this.portRange = builder.portRange;
                this.relatedVulnerabilities = builder.relatedVulnerabilities;
                this.resourceId = builder.resourceId;
                this.resourceTags = builder.resourceTags;
                this.resourceType = builder.resourceType;
                this.severity = builder.severity;
                this.title = builder.title;
                this.updatedAt = builder.updatedAt;
                this.vendorSeverity = builder.vendorSeverity;
                this.vulnerabilityId = builder.vulnerabilityId;
                this.vulnerabilitySource = builder.vulnerabilitySource;
                this.vulnerablePackages = builder.vulnerablePackages;
            }

            @Override
            public final java.lang.Object getAwsAccountId() {
                return this.awsAccountId;
            }

            @Override
            public final java.lang.Object getComponentId() {
                return this.componentId;
            }

            @Override
            public final java.lang.Object getComponentType() {
                return this.componentType;
            }

            @Override
            public final java.lang.Object getEc2InstanceImageId() {
                return this.ec2InstanceImageId;
            }

            @Override
            public final java.lang.Object getEc2InstanceSubnetId() {
                return this.ec2InstanceSubnetId;
            }

            @Override
            public final java.lang.Object getEc2InstanceVpcId() {
                return this.ec2InstanceVpcId;
            }

            @Override
            public final java.lang.Object getEcrImageArchitecture() {
                return this.ecrImageArchitecture;
            }

            @Override
            public final java.lang.Object getEcrImageHash() {
                return this.ecrImageHash;
            }

            @Override
            public final java.lang.Object getEcrImagePushedAt() {
                return this.ecrImagePushedAt;
            }

            @Override
            public final java.lang.Object getEcrImageRegistry() {
                return this.ecrImageRegistry;
            }

            @Override
            public final java.lang.Object getEcrImageRepositoryName() {
                return this.ecrImageRepositoryName;
            }

            @Override
            public final java.lang.Object getEcrImageTags() {
                return this.ecrImageTags;
            }

            @Override
            public final java.lang.Object getFindingArn() {
                return this.findingArn;
            }

            @Override
            public final java.lang.Object getFindingStatus() {
                return this.findingStatus;
            }

            @Override
            public final java.lang.Object getFindingType() {
                return this.findingType;
            }

            @Override
            public final java.lang.Object getFirstObservedAt() {
                return this.firstObservedAt;
            }

            @Override
            public final java.lang.Object getInspectorScore() {
                return this.inspectorScore;
            }

            @Override
            public final java.lang.Object getLastObservedAt() {
                return this.lastObservedAt;
            }

            @Override
            public final java.lang.Object getNetworkProtocol() {
                return this.networkProtocol;
            }

            @Override
            public final java.lang.Object getPortRange() {
                return this.portRange;
            }

            @Override
            public final java.lang.Object getRelatedVulnerabilities() {
                return this.relatedVulnerabilities;
            }

            @Override
            public final java.lang.Object getResourceId() {
                return this.resourceId;
            }

            @Override
            public final java.lang.Object getResourceTags() {
                return this.resourceTags;
            }

            @Override
            public final java.lang.Object getResourceType() {
                return this.resourceType;
            }

            @Override
            public final java.lang.Object getSeverity() {
                return this.severity;
            }

            @Override
            public final java.lang.Object getTitle() {
                return this.title;
            }

            @Override
            public final java.lang.Object getUpdatedAt() {
                return this.updatedAt;
            }

            @Override
            public final java.lang.Object getVendorSeverity() {
                return this.vendorSeverity;
            }

            @Override
            public final java.lang.Object getVulnerabilityId() {
                return this.vulnerabilityId;
            }

            @Override
            public final java.lang.Object getVulnerabilitySource() {
                return this.vulnerabilitySource;
            }

            @Override
            public final java.lang.Object getVulnerablePackages() {
                return this.vulnerablePackages;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAwsAccountId() != null) {
                    data.set("awsAccountId", om.valueToTree(this.getAwsAccountId()));
                }
                if (this.getComponentId() != null) {
                    data.set("componentId", om.valueToTree(this.getComponentId()));
                }
                if (this.getComponentType() != null) {
                    data.set("componentType", om.valueToTree(this.getComponentType()));
                }
                if (this.getEc2InstanceImageId() != null) {
                    data.set("ec2InstanceImageId", om.valueToTree(this.getEc2InstanceImageId()));
                }
                if (this.getEc2InstanceSubnetId() != null) {
                    data.set("ec2InstanceSubnetId", om.valueToTree(this.getEc2InstanceSubnetId()));
                }
                if (this.getEc2InstanceVpcId() != null) {
                    data.set("ec2InstanceVpcId", om.valueToTree(this.getEc2InstanceVpcId()));
                }
                if (this.getEcrImageArchitecture() != null) {
                    data.set("ecrImageArchitecture", om.valueToTree(this.getEcrImageArchitecture()));
                }
                if (this.getEcrImageHash() != null) {
                    data.set("ecrImageHash", om.valueToTree(this.getEcrImageHash()));
                }
                if (this.getEcrImagePushedAt() != null) {
                    data.set("ecrImagePushedAt", om.valueToTree(this.getEcrImagePushedAt()));
                }
                if (this.getEcrImageRegistry() != null) {
                    data.set("ecrImageRegistry", om.valueToTree(this.getEcrImageRegistry()));
                }
                if (this.getEcrImageRepositoryName() != null) {
                    data.set("ecrImageRepositoryName", om.valueToTree(this.getEcrImageRepositoryName()));
                }
                if (this.getEcrImageTags() != null) {
                    data.set("ecrImageTags", om.valueToTree(this.getEcrImageTags()));
                }
                if (this.getFindingArn() != null) {
                    data.set("findingArn", om.valueToTree(this.getFindingArn()));
                }
                if (this.getFindingStatus() != null) {
                    data.set("findingStatus", om.valueToTree(this.getFindingStatus()));
                }
                if (this.getFindingType() != null) {
                    data.set("findingType", om.valueToTree(this.getFindingType()));
                }
                if (this.getFirstObservedAt() != null) {
                    data.set("firstObservedAt", om.valueToTree(this.getFirstObservedAt()));
                }
                if (this.getInspectorScore() != null) {
                    data.set("inspectorScore", om.valueToTree(this.getInspectorScore()));
                }
                if (this.getLastObservedAt() != null) {
                    data.set("lastObservedAt", om.valueToTree(this.getLastObservedAt()));
                }
                if (this.getNetworkProtocol() != null) {
                    data.set("networkProtocol", om.valueToTree(this.getNetworkProtocol()));
                }
                if (this.getPortRange() != null) {
                    data.set("portRange", om.valueToTree(this.getPortRange()));
                }
                if (this.getRelatedVulnerabilities() != null) {
                    data.set("relatedVulnerabilities", om.valueToTree(this.getRelatedVulnerabilities()));
                }
                if (this.getResourceId() != null) {
                    data.set("resourceId", om.valueToTree(this.getResourceId()));
                }
                if (this.getResourceTags() != null) {
                    data.set("resourceTags", om.valueToTree(this.getResourceTags()));
                }
                if (this.getResourceType() != null) {
                    data.set("resourceType", om.valueToTree(this.getResourceType()));
                }
                if (this.getSeverity() != null) {
                    data.set("severity", om.valueToTree(this.getSeverity()));
                }
                if (this.getTitle() != null) {
                    data.set("title", om.valueToTree(this.getTitle()));
                }
                if (this.getUpdatedAt() != null) {
                    data.set("updatedAt", om.valueToTree(this.getUpdatedAt()));
                }
                if (this.getVendorSeverity() != null) {
                    data.set("vendorSeverity", om.valueToTree(this.getVendorSeverity()));
                }
                if (this.getVulnerabilityId() != null) {
                    data.set("vulnerabilityId", om.valueToTree(this.getVulnerabilityId()));
                }
                if (this.getVulnerabilitySource() != null) {
                    data.set("vulnerabilitySource", om.valueToTree(this.getVulnerabilitySource()));
                }
                if (this.getVulnerablePackages() != null) {
                    data.set("vulnerablePackages", om.valueToTree(this.getVulnerablePackages()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_inspectorv2.CfnFilter.FilterCriteriaProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FilterCriteriaProperty.Jsii$Proxy that = (FilterCriteriaProperty.Jsii$Proxy) o;

                if (this.awsAccountId != null ? !this.awsAccountId.equals(that.awsAccountId) : that.awsAccountId != null) return false;
                if (this.componentId != null ? !this.componentId.equals(that.componentId) : that.componentId != null) return false;
                if (this.componentType != null ? !this.componentType.equals(that.componentType) : that.componentType != null) return false;
                if (this.ec2InstanceImageId != null ? !this.ec2InstanceImageId.equals(that.ec2InstanceImageId) : that.ec2InstanceImageId != null) return false;
                if (this.ec2InstanceSubnetId != null ? !this.ec2InstanceSubnetId.equals(that.ec2InstanceSubnetId) : that.ec2InstanceSubnetId != null) return false;
                if (this.ec2InstanceVpcId != null ? !this.ec2InstanceVpcId.equals(that.ec2InstanceVpcId) : that.ec2InstanceVpcId != null) return false;
                if (this.ecrImageArchitecture != null ? !this.ecrImageArchitecture.equals(that.ecrImageArchitecture) : that.ecrImageArchitecture != null) return false;
                if (this.ecrImageHash != null ? !this.ecrImageHash.equals(that.ecrImageHash) : that.ecrImageHash != null) return false;
                if (this.ecrImagePushedAt != null ? !this.ecrImagePushedAt.equals(that.ecrImagePushedAt) : that.ecrImagePushedAt != null) return false;
                if (this.ecrImageRegistry != null ? !this.ecrImageRegistry.equals(that.ecrImageRegistry) : that.ecrImageRegistry != null) return false;
                if (this.ecrImageRepositoryName != null ? !this.ecrImageRepositoryName.equals(that.ecrImageRepositoryName) : that.ecrImageRepositoryName != null) return false;
                if (this.ecrImageTags != null ? !this.ecrImageTags.equals(that.ecrImageTags) : that.ecrImageTags != null) return false;
                if (this.findingArn != null ? !this.findingArn.equals(that.findingArn) : that.findingArn != null) return false;
                if (this.findingStatus != null ? !this.findingStatus.equals(that.findingStatus) : that.findingStatus != null) return false;
                if (this.findingType != null ? !this.findingType.equals(that.findingType) : that.findingType != null) return false;
                if (this.firstObservedAt != null ? !this.firstObservedAt.equals(that.firstObservedAt) : that.firstObservedAt != null) return false;
                if (this.inspectorScore != null ? !this.inspectorScore.equals(that.inspectorScore) : that.inspectorScore != null) return false;
                if (this.lastObservedAt != null ? !this.lastObservedAt.equals(that.lastObservedAt) : that.lastObservedAt != null) return false;
                if (this.networkProtocol != null ? !this.networkProtocol.equals(that.networkProtocol) : that.networkProtocol != null) return false;
                if (this.portRange != null ? !this.portRange.equals(that.portRange) : that.portRange != null) return false;
                if (this.relatedVulnerabilities != null ? !this.relatedVulnerabilities.equals(that.relatedVulnerabilities) : that.relatedVulnerabilities != null) return false;
                if (this.resourceId != null ? !this.resourceId.equals(that.resourceId) : that.resourceId != null) return false;
                if (this.resourceTags != null ? !this.resourceTags.equals(that.resourceTags) : that.resourceTags != null) return false;
                if (this.resourceType != null ? !this.resourceType.equals(that.resourceType) : that.resourceType != null) return false;
                if (this.severity != null ? !this.severity.equals(that.severity) : that.severity != null) return false;
                if (this.title != null ? !this.title.equals(that.title) : that.title != null) return false;
                if (this.updatedAt != null ? !this.updatedAt.equals(that.updatedAt) : that.updatedAt != null) return false;
                if (this.vendorSeverity != null ? !this.vendorSeverity.equals(that.vendorSeverity) : that.vendorSeverity != null) return false;
                if (this.vulnerabilityId != null ? !this.vulnerabilityId.equals(that.vulnerabilityId) : that.vulnerabilityId != null) return false;
                if (this.vulnerabilitySource != null ? !this.vulnerabilitySource.equals(that.vulnerabilitySource) : that.vulnerabilitySource != null) return false;
                return this.vulnerablePackages != null ? this.vulnerablePackages.equals(that.vulnerablePackages) : that.vulnerablePackages == null;
            }

            @Override
            public final int hashCode() {
                int result = this.awsAccountId != null ? this.awsAccountId.hashCode() : 0;
                result = 31 * result + (this.componentId != null ? this.componentId.hashCode() : 0);
                result = 31 * result + (this.componentType != null ? this.componentType.hashCode() : 0);
                result = 31 * result + (this.ec2InstanceImageId != null ? this.ec2InstanceImageId.hashCode() : 0);
                result = 31 * result + (this.ec2InstanceSubnetId != null ? this.ec2InstanceSubnetId.hashCode() : 0);
                result = 31 * result + (this.ec2InstanceVpcId != null ? this.ec2InstanceVpcId.hashCode() : 0);
                result = 31 * result + (this.ecrImageArchitecture != null ? this.ecrImageArchitecture.hashCode() : 0);
                result = 31 * result + (this.ecrImageHash != null ? this.ecrImageHash.hashCode() : 0);
                result = 31 * result + (this.ecrImagePushedAt != null ? this.ecrImagePushedAt.hashCode() : 0);
                result = 31 * result + (this.ecrImageRegistry != null ? this.ecrImageRegistry.hashCode() : 0);
                result = 31 * result + (this.ecrImageRepositoryName != null ? this.ecrImageRepositoryName.hashCode() : 0);
                result = 31 * result + (this.ecrImageTags != null ? this.ecrImageTags.hashCode() : 0);
                result = 31 * result + (this.findingArn != null ? this.findingArn.hashCode() : 0);
                result = 31 * result + (this.findingStatus != null ? this.findingStatus.hashCode() : 0);
                result = 31 * result + (this.findingType != null ? this.findingType.hashCode() : 0);
                result = 31 * result + (this.firstObservedAt != null ? this.firstObservedAt.hashCode() : 0);
                result = 31 * result + (this.inspectorScore != null ? this.inspectorScore.hashCode() : 0);
                result = 31 * result + (this.lastObservedAt != null ? this.lastObservedAt.hashCode() : 0);
                result = 31 * result + (this.networkProtocol != null ? this.networkProtocol.hashCode() : 0);
                result = 31 * result + (this.portRange != null ? this.portRange.hashCode() : 0);
                result = 31 * result + (this.relatedVulnerabilities != null ? this.relatedVulnerabilities.hashCode() : 0);
                result = 31 * result + (this.resourceId != null ? this.resourceId.hashCode() : 0);
                result = 31 * result + (this.resourceTags != null ? this.resourceTags.hashCode() : 0);
                result = 31 * result + (this.resourceType != null ? this.resourceType.hashCode() : 0);
                result = 31 * result + (this.severity != null ? this.severity.hashCode() : 0);
                result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
                result = 31 * result + (this.updatedAt != null ? this.updatedAt.hashCode() : 0);
                result = 31 * result + (this.vendorSeverity != null ? this.vendorSeverity.hashCode() : 0);
                result = 31 * result + (this.vulnerabilityId != null ? this.vulnerabilityId.hashCode() : 0);
                result = 31 * result + (this.vulnerabilitySource != null ? this.vulnerabilitySource.hashCode() : 0);
                result = 31 * result + (this.vulnerablePackages != null ? this.vulnerablePackages.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that describes details of a map filter.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.inspectorv2.*;
     * MapFilterProperty mapFilterProperty = MapFilterProperty.builder()
     *         .comparison("comparison")
     *         // the properties below are optional
     *         .key("key")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-mapfilter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-mapfilter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_inspectorv2.CfnFilter.MapFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(MapFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MapFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The operator to use when comparing values in the filter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-mapfilter.html#cfn-inspectorv2-filter-mapfilter-comparison">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-mapfilter.html#cfn-inspectorv2-filter-mapfilter-comparison</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getComparison();

        /**
         * The tag key used in the filter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-mapfilter.html#cfn-inspectorv2-filter-mapfilter-key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-mapfilter.html#cfn-inspectorv2-filter-mapfilter-key</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKey() {
            return null;
        }

        /**
         * The tag value used in the filter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-mapfilter.html#cfn-inspectorv2-filter-mapfilter-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-mapfilter.html#cfn-inspectorv2-filter-mapfilter-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MapFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MapFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MapFilterProperty> {
            java.lang.String comparison;
            java.lang.String key;
            java.lang.String value;

            /**
             * Sets the value of {@link MapFilterProperty#getComparison}
             * @param comparison The operator to use when comparing values in the filter. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder comparison(java.lang.String comparison) {
                this.comparison = comparison;
                return this;
            }

            /**
             * Sets the value of {@link MapFilterProperty#getKey}
             * @param key The tag key used in the filter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link MapFilterProperty#getValue}
             * @param value The tag value used in the filter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MapFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MapFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MapFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MapFilterProperty {
            private final java.lang.String comparison;
            private final java.lang.String key;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.comparison = software.amazon.jsii.Kernel.get(this, "comparison", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.comparison = java.util.Objects.requireNonNull(builder.comparison, "comparison is required");
                this.key = builder.key;
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getComparison() {
                return this.comparison;
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("comparison", om.valueToTree(this.getComparison()));
                if (this.getKey() != null) {
                    data.set("key", om.valueToTree(this.getKey()));
                }
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_inspectorv2.CfnFilter.MapFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MapFilterProperty.Jsii$Proxy that = (MapFilterProperty.Jsii$Proxy) o;

                if (!comparison.equals(that.comparison)) return false;
                if (this.key != null ? !this.key.equals(that.key) : that.key != null) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.comparison.hashCode();
                result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that describes the details of a number filter.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.inspectorv2.*;
     * NumberFilterProperty numberFilterProperty = NumberFilterProperty.builder()
     *         .lowerInclusive(123)
     *         .upperInclusive(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-numberfilter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-numberfilter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_inspectorv2.CfnFilter.NumberFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(NumberFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NumberFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The lowest number to be included in the filter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-numberfilter.html#cfn-inspectorv2-filter-numberfilter-lowerinclusive">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-numberfilter.html#cfn-inspectorv2-filter-numberfilter-lowerinclusive</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getLowerInclusive() {
            return null;
        }

        /**
         * The highest number to be included in the filter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-numberfilter.html#cfn-inspectorv2-filter-numberfilter-upperinclusive">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-numberfilter.html#cfn-inspectorv2-filter-numberfilter-upperinclusive</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getUpperInclusive() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NumberFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NumberFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NumberFilterProperty> {
            java.lang.Number lowerInclusive;
            java.lang.Number upperInclusive;

            /**
             * Sets the value of {@link NumberFilterProperty#getLowerInclusive}
             * @param lowerInclusive The lowest number to be included in the filter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lowerInclusive(java.lang.Number lowerInclusive) {
                this.lowerInclusive = lowerInclusive;
                return this;
            }

            /**
             * Sets the value of {@link NumberFilterProperty#getUpperInclusive}
             * @param upperInclusive The highest number to be included in the filter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder upperInclusive(java.lang.Number upperInclusive) {
                this.upperInclusive = upperInclusive;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NumberFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NumberFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NumberFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NumberFilterProperty {
            private final java.lang.Number lowerInclusive;
            private final java.lang.Number upperInclusive;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.lowerInclusive = software.amazon.jsii.Kernel.get(this, "lowerInclusive", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.upperInclusive = software.amazon.jsii.Kernel.get(this, "upperInclusive", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.lowerInclusive = builder.lowerInclusive;
                this.upperInclusive = builder.upperInclusive;
            }

            @Override
            public final java.lang.Number getLowerInclusive() {
                return this.lowerInclusive;
            }

            @Override
            public final java.lang.Number getUpperInclusive() {
                return this.upperInclusive;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getLowerInclusive() != null) {
                    data.set("lowerInclusive", om.valueToTree(this.getLowerInclusive()));
                }
                if (this.getUpperInclusive() != null) {
                    data.set("upperInclusive", om.valueToTree(this.getUpperInclusive()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_inspectorv2.CfnFilter.NumberFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NumberFilterProperty.Jsii$Proxy that = (NumberFilterProperty.Jsii$Proxy) o;

                if (this.lowerInclusive != null ? !this.lowerInclusive.equals(that.lowerInclusive) : that.lowerInclusive != null) return false;
                return this.upperInclusive != null ? this.upperInclusive.equals(that.upperInclusive) : that.upperInclusive == null;
            }

            @Override
            public final int hashCode() {
                int result = this.lowerInclusive != null ? this.lowerInclusive.hashCode() : 0;
                result = 31 * result + (this.upperInclusive != null ? this.upperInclusive.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains information on the details of a package filter.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.inspectorv2.*;
     * PackageFilterProperty packageFilterProperty = PackageFilterProperty.builder()
     *         .architecture(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build())
     *         .epoch(NumberFilterProperty.builder()
     *                 .lowerInclusive(123)
     *                 .upperInclusive(123)
     *                 .build())
     *         .name(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build())
     *         .release(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build())
     *         .sourceLayerHash(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build())
     *         .version(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-packagefilter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-packagefilter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_inspectorv2.CfnFilter.PackageFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(PackageFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PackageFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An object that contains details on the package architecture type to filter on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-packagefilter.html#cfn-inspectorv2-filter-packagefilter-architecture">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-packagefilter.html#cfn-inspectorv2-filter-packagefilter-architecture</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getArchitecture() {
            return null;
        }

        /**
         * An object that contains details on the package epoch to filter on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-packagefilter.html#cfn-inspectorv2-filter-packagefilter-epoch">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-packagefilter.html#cfn-inspectorv2-filter-packagefilter-epoch</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEpoch() {
            return null;
        }

        /**
         * An object that contains details on the name of the package to filter on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-packagefilter.html#cfn-inspectorv2-filter-packagefilter-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-packagefilter.html#cfn-inspectorv2-filter-packagefilter-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getName() {
            return null;
        }

        /**
         * An object that contains details on the package release to filter on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-packagefilter.html#cfn-inspectorv2-filter-packagefilter-release">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-packagefilter.html#cfn-inspectorv2-filter-packagefilter-release</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRelease() {
            return null;
        }

        /**
         * An object that contains details on the source layer hash to filter on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-packagefilter.html#cfn-inspectorv2-filter-packagefilter-sourcelayerhash">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-packagefilter.html#cfn-inspectorv2-filter-packagefilter-sourcelayerhash</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSourceLayerHash() {
            return null;
        }

        /**
         * The package version to filter on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-packagefilter.html#cfn-inspectorv2-filter-packagefilter-version">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-packagefilter.html#cfn-inspectorv2-filter-packagefilter-version</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PackageFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PackageFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PackageFilterProperty> {
            java.lang.Object architecture;
            java.lang.Object epoch;
            java.lang.Object name;
            java.lang.Object release;
            java.lang.Object sourceLayerHash;
            java.lang.Object version;

            /**
             * Sets the value of {@link PackageFilterProperty#getArchitecture}
             * @param architecture An object that contains details on the package architecture type to filter on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder architecture(software.amazon.awscdk.IResolvable architecture) {
                this.architecture = architecture;
                return this;
            }

            /**
             * Sets the value of {@link PackageFilterProperty#getArchitecture}
             * @param architecture An object that contains details on the package architecture type to filter on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder architecture(software.amazon.awscdk.services.inspectorv2.CfnFilter.StringFilterProperty architecture) {
                this.architecture = architecture;
                return this;
            }

            /**
             * Sets the value of {@link PackageFilterProperty#getEpoch}
             * @param epoch An object that contains details on the package epoch to filter on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder epoch(software.amazon.awscdk.IResolvable epoch) {
                this.epoch = epoch;
                return this;
            }

            /**
             * Sets the value of {@link PackageFilterProperty#getEpoch}
             * @param epoch An object that contains details on the package epoch to filter on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder epoch(software.amazon.awscdk.services.inspectorv2.CfnFilter.NumberFilterProperty epoch) {
                this.epoch = epoch;
                return this;
            }

            /**
             * Sets the value of {@link PackageFilterProperty#getName}
             * @param name An object that contains details on the name of the package to filter on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(software.amazon.awscdk.IResolvable name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link PackageFilterProperty#getName}
             * @param name An object that contains details on the name of the package to filter on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(software.amazon.awscdk.services.inspectorv2.CfnFilter.StringFilterProperty name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link PackageFilterProperty#getRelease}
             * @param release An object that contains details on the package release to filter on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder release(software.amazon.awscdk.IResolvable release) {
                this.release = release;
                return this;
            }

            /**
             * Sets the value of {@link PackageFilterProperty#getRelease}
             * @param release An object that contains details on the package release to filter on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder release(software.amazon.awscdk.services.inspectorv2.CfnFilter.StringFilterProperty release) {
                this.release = release;
                return this;
            }

            /**
             * Sets the value of {@link PackageFilterProperty#getSourceLayerHash}
             * @param sourceLayerHash An object that contains details on the source layer hash to filter on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceLayerHash(software.amazon.awscdk.IResolvable sourceLayerHash) {
                this.sourceLayerHash = sourceLayerHash;
                return this;
            }

            /**
             * Sets the value of {@link PackageFilterProperty#getSourceLayerHash}
             * @param sourceLayerHash An object that contains details on the source layer hash to filter on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceLayerHash(software.amazon.awscdk.services.inspectorv2.CfnFilter.StringFilterProperty sourceLayerHash) {
                this.sourceLayerHash = sourceLayerHash;
                return this;
            }

            /**
             * Sets the value of {@link PackageFilterProperty#getVersion}
             * @param version The package version to filter on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder version(software.amazon.awscdk.IResolvable version) {
                this.version = version;
                return this;
            }

            /**
             * Sets the value of {@link PackageFilterProperty#getVersion}
             * @param version The package version to filter on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder version(software.amazon.awscdk.services.inspectorv2.CfnFilter.StringFilterProperty version) {
                this.version = version;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PackageFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PackageFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PackageFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PackageFilterProperty {
            private final java.lang.Object architecture;
            private final java.lang.Object epoch;
            private final java.lang.Object name;
            private final java.lang.Object release;
            private final java.lang.Object sourceLayerHash;
            private final java.lang.Object version;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.architecture = software.amazon.jsii.Kernel.get(this, "architecture", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.epoch = software.amazon.jsii.Kernel.get(this, "epoch", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.release = software.amazon.jsii.Kernel.get(this, "release", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sourceLayerHash = software.amazon.jsii.Kernel.get(this, "sourceLayerHash", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.architecture = builder.architecture;
                this.epoch = builder.epoch;
                this.name = builder.name;
                this.release = builder.release;
                this.sourceLayerHash = builder.sourceLayerHash;
                this.version = builder.version;
            }

            @Override
            public final java.lang.Object getArchitecture() {
                return this.architecture;
            }

            @Override
            public final java.lang.Object getEpoch() {
                return this.epoch;
            }

            @Override
            public final java.lang.Object getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getRelease() {
                return this.release;
            }

            @Override
            public final java.lang.Object getSourceLayerHash() {
                return this.sourceLayerHash;
            }

            @Override
            public final java.lang.Object getVersion() {
                return this.version;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getArchitecture() != null) {
                    data.set("architecture", om.valueToTree(this.getArchitecture()));
                }
                if (this.getEpoch() != null) {
                    data.set("epoch", om.valueToTree(this.getEpoch()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getRelease() != null) {
                    data.set("release", om.valueToTree(this.getRelease()));
                }
                if (this.getSourceLayerHash() != null) {
                    data.set("sourceLayerHash", om.valueToTree(this.getSourceLayerHash()));
                }
                if (this.getVersion() != null) {
                    data.set("version", om.valueToTree(this.getVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_inspectorv2.CfnFilter.PackageFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PackageFilterProperty.Jsii$Proxy that = (PackageFilterProperty.Jsii$Proxy) o;

                if (this.architecture != null ? !this.architecture.equals(that.architecture) : that.architecture != null) return false;
                if (this.epoch != null ? !this.epoch.equals(that.epoch) : that.epoch != null) return false;
                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                if (this.release != null ? !this.release.equals(that.release) : that.release != null) return false;
                if (this.sourceLayerHash != null ? !this.sourceLayerHash.equals(that.sourceLayerHash) : that.sourceLayerHash != null) return false;
                return this.version != null ? this.version.equals(that.version) : that.version == null;
            }

            @Override
            public final int hashCode() {
                int result = this.architecture != null ? this.architecture.hashCode() : 0;
                result = 31 * result + (this.epoch != null ? this.epoch.hashCode() : 0);
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                result = 31 * result + (this.release != null ? this.release.hashCode() : 0);
                result = 31 * result + (this.sourceLayerHash != null ? this.sourceLayerHash.hashCode() : 0);
                result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that describes the details of a port range filter.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.inspectorv2.*;
     * PortRangeFilterProperty portRangeFilterProperty = PortRangeFilterProperty.builder()
     *         .beginInclusive(123)
     *         .endInclusive(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-portrangefilter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-portrangefilter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_inspectorv2.CfnFilter.PortRangeFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(PortRangeFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PortRangeFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The port number the port range begins at.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-portrangefilter.html#cfn-inspectorv2-filter-portrangefilter-begininclusive">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-portrangefilter.html#cfn-inspectorv2-filter-portrangefilter-begininclusive</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBeginInclusive() {
            return null;
        }

        /**
         * The port number the port range ends at.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-portrangefilter.html#cfn-inspectorv2-filter-portrangefilter-endinclusive">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-portrangefilter.html#cfn-inspectorv2-filter-portrangefilter-endinclusive</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getEndInclusive() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PortRangeFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PortRangeFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PortRangeFilterProperty> {
            java.lang.Number beginInclusive;
            java.lang.Number endInclusive;

            /**
             * Sets the value of {@link PortRangeFilterProperty#getBeginInclusive}
             * @param beginInclusive The port number the port range begins at.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder beginInclusive(java.lang.Number beginInclusive) {
                this.beginInclusive = beginInclusive;
                return this;
            }

            /**
             * Sets the value of {@link PortRangeFilterProperty#getEndInclusive}
             * @param endInclusive The port number the port range ends at.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endInclusive(java.lang.Number endInclusive) {
                this.endInclusive = endInclusive;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PortRangeFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PortRangeFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PortRangeFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PortRangeFilterProperty {
            private final java.lang.Number beginInclusive;
            private final java.lang.Number endInclusive;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.beginInclusive = software.amazon.jsii.Kernel.get(this, "beginInclusive", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.endInclusive = software.amazon.jsii.Kernel.get(this, "endInclusive", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.beginInclusive = builder.beginInclusive;
                this.endInclusive = builder.endInclusive;
            }

            @Override
            public final java.lang.Number getBeginInclusive() {
                return this.beginInclusive;
            }

            @Override
            public final java.lang.Number getEndInclusive() {
                return this.endInclusive;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBeginInclusive() != null) {
                    data.set("beginInclusive", om.valueToTree(this.getBeginInclusive()));
                }
                if (this.getEndInclusive() != null) {
                    data.set("endInclusive", om.valueToTree(this.getEndInclusive()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_inspectorv2.CfnFilter.PortRangeFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PortRangeFilterProperty.Jsii$Proxy that = (PortRangeFilterProperty.Jsii$Proxy) o;

                if (this.beginInclusive != null ? !this.beginInclusive.equals(that.beginInclusive) : that.beginInclusive != null) return false;
                return this.endInclusive != null ? this.endInclusive.equals(that.endInclusive) : that.endInclusive == null;
            }

            @Override
            public final int hashCode() {
                int result = this.beginInclusive != null ? this.beginInclusive.hashCode() : 0;
                result = 31 * result + (this.endInclusive != null ? this.endInclusive.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that describes the details of a string filter.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.inspectorv2.*;
     * StringFilterProperty stringFilterProperty = StringFilterProperty.builder()
     *         .comparison("comparison")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-stringfilter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-stringfilter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_inspectorv2.CfnFilter.StringFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(StringFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StringFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The operator to use when comparing values in the filter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-stringfilter.html#cfn-inspectorv2-filter-stringfilter-comparison">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-stringfilter.html#cfn-inspectorv2-filter-stringfilter-comparison</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getComparison();

        /**
         * The value to filter on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-stringfilter.html#cfn-inspectorv2-filter-stringfilter-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-stringfilter.html#cfn-inspectorv2-filter-stringfilter-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link StringFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StringFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StringFilterProperty> {
            java.lang.String comparison;
            java.lang.String value;

            /**
             * Sets the value of {@link StringFilterProperty#getComparison}
             * @param comparison The operator to use when comparing values in the filter. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder comparison(java.lang.String comparison) {
                this.comparison = comparison;
                return this;
            }

            /**
             * Sets the value of {@link StringFilterProperty#getValue}
             * @param value The value to filter on. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StringFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StringFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StringFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StringFilterProperty {
            private final java.lang.String comparison;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.comparison = software.amazon.jsii.Kernel.get(this, "comparison", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.comparison = java.util.Objects.requireNonNull(builder.comparison, "comparison is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getComparison() {
                return this.comparison;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("comparison", om.valueToTree(this.getComparison()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_inspectorv2.CfnFilter.StringFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StringFilterProperty.Jsii$Proxy that = (StringFilterProperty.Jsii$Proxy) o;

                if (!comparison.equals(that.comparison)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.comparison.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.inspectorv2.CfnFilter}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.inspectorv2.CfnFilter> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.inspectorv2.CfnFilterProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.inspectorv2.CfnFilterProps.Builder();
        }

        /**
         * The action that is to be applied to the findings that match the filter.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-filter.html#cfn-inspectorv2-filter-filteraction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-filter.html#cfn-inspectorv2-filter-filteraction</a>
         * @param filterAction The action that is to be applied to the findings that match the filter. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filterAction(final java.lang.String filterAction) {
            this.props.filterAction(filterAction);
            return this;
        }

        /**
         * Details on the filter criteria associated with this filter.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-filter.html#cfn-inspectorv2-filter-filtercriteria">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-filter.html#cfn-inspectorv2-filter-filtercriteria</a>
         * @param filterCriteria Details on the filter criteria associated with this filter. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filterCriteria(final software.amazon.awscdk.IResolvable filterCriteria) {
            this.props.filterCriteria(filterCriteria);
            return this;
        }
        /**
         * Details on the filter criteria associated with this filter.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-filter.html#cfn-inspectorv2-filter-filtercriteria">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-filter.html#cfn-inspectorv2-filter-filtercriteria</a>
         * @param filterCriteria Details on the filter criteria associated with this filter. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filterCriteria(final software.amazon.awscdk.services.inspectorv2.CfnFilter.FilterCriteriaProperty filterCriteria) {
            this.props.filterCriteria(filterCriteria);
            return this;
        }

        /**
         * The name of the filter.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-filter.html#cfn-inspectorv2-filter-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-filter.html#cfn-inspectorv2-filter-name</a>
         * @param name The name of the filter. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * A description of the filter.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-filter.html#cfn-inspectorv2-filter-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-filter.html#cfn-inspectorv2-filter-description</a>
         * @param description A description of the filter. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.inspectorv2.CfnFilter}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.inspectorv2.CfnFilter build() {
            return new software.amazon.awscdk.services.inspectorv2.CfnFilter(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
