package software.amazon.awscdk.services.iotfleetwise;

/**
 * Creates an orchestration of data collection rules.
 * <p>
 * The AWS IoT FleetWise Edge Agent software running in vehicles uses campaigns to decide how to collect and transfer data to the cloud. You create campaigns in the cloud. After you or your team approve campaigns, AWS IoT FleetWise automatically deploys them to vehicles.
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/campaigns.html">Collect and transfer data with campaigns</a> in the <em>AWS IoT FleetWise Developer Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iotfleetwise.*;
 * CfnCampaign cfnCampaign = CfnCampaign.Builder.create(this, "MyCfnCampaign")
 *         .action("action")
 *         .collectionScheme(CollectionSchemeProperty.builder()
 *                 .conditionBasedCollectionScheme(ConditionBasedCollectionSchemeProperty.builder()
 *                         .expression("expression")
 *                         // the properties below are optional
 *                         .conditionLanguageVersion(123)
 *                         .minimumTriggerIntervalMs(123)
 *                         .triggerMode("triggerMode")
 *                         .build())
 *                 .timeBasedCollectionScheme(TimeBasedCollectionSchemeProperty.builder()
 *                         .periodMs(123)
 *                         .build())
 *                 .build())
 *         .name("name")
 *         .signalCatalogArn("signalCatalogArn")
 *         .targetArn("targetArn")
 *         // the properties below are optional
 *         .compression("compression")
 *         .dataDestinationConfigs(List.of(DataDestinationConfigProperty.builder()
 *                 .s3Config(S3ConfigProperty.builder()
 *                         .bucketArn("bucketArn")
 *                         // the properties below are optional
 *                         .dataFormat("dataFormat")
 *                         .prefix("prefix")
 *                         .storageCompressionFormat("storageCompressionFormat")
 *                         .build())
 *                 .timestreamConfig(TimestreamConfigProperty.builder()
 *                         .executionRoleArn("executionRoleArn")
 *                         .timestreamTableArn("timestreamTableArn")
 *                         .build())
 *                 .build()))
 *         .dataExtraDimensions(List.of("dataExtraDimensions"))
 *         .description("description")
 *         .diagnosticsMode("diagnosticsMode")
 *         .expiryTime("expiryTime")
 *         .postTriggerCollectionDuration(123)
 *         .priority(123)
 *         .signalsToCollect(List.of(SignalInformationProperty.builder()
 *                 .name("name")
 *                 // the properties below are optional
 *                 .maxSampleCount(123)
 *                 .minimumSamplingIntervalMs(123)
 *                 .build()))
 *         .spoolingMode("spoolingMode")
 *         .startTime("startTime")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-22T22:42:53.081Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotfleetwise.CfnCampaign")
public class CfnCampaign extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnCampaign(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCampaign(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.iotfleetwise.CfnCampaign.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnCampaign(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotfleetwise.CfnCampaignProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The time the campaign was created in seconds since epoch (January 1, 1970 at midnight UTC time).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreationTime() {
        return software.amazon.jsii.Kernel.get(this, "attrCreationTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The last time the campaign was modified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLastModificationTime() {
        return software.amazon.jsii.Kernel.get(this, "attrLastModificationTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The state of the campaign.
     * <p>
     * The status can be one of: <code>CREATING</code> , <code>WAITING_FOR_APPROVAL</code> , <code>RUNNING</code> , and <code>SUSPENDED</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * Specifies how to update a campaign.
     * <p>
     * The action can be one of the following:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAction() {
        return software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies how to update a campaign.
     * <p>
     * The action can be one of the following:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAction(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "action", java.util.Objects.requireNonNull(value, "action is required"));
    }

    /**
     * The data collection scheme associated with the campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getCollectionScheme() {
        return software.amazon.jsii.Kernel.get(this, "collectionScheme", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The data collection scheme associated with the campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCollectionScheme(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "collectionScheme", java.util.Objects.requireNonNull(value, "collectionScheme is required"));
    }

    /**
     * The data collection scheme associated with the campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCollectionScheme(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotfleetwise.CfnCampaign.CollectionSchemeProperty value) {
        software.amazon.jsii.Kernel.set(this, "collectionScheme", java.util.Objects.requireNonNull(value, "collectionScheme is required"));
    }

    /**
     * The name of a campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of a campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The Amazon Resource Name (ARN) of the signal catalog associated with the campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getSignalCatalogArn() {
        return software.amazon.jsii.Kernel.get(this, "signalCatalogArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the signal catalog associated with the campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSignalCatalogArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "signalCatalogArn", java.util.Objects.requireNonNull(value, "signalCatalogArn is required"));
    }

    /**
     * The Amazon Resource Name (ARN) of a vehicle or fleet to which the campaign is deployed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getTargetArn() {
        return software.amazon.jsii.Kernel.get(this, "targetArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of a vehicle or fleet to which the campaign is deployed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTargetArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "targetArn", java.util.Objects.requireNonNull(value, "targetArn is required"));
    }

    /**
     * (Optional) Whether to compress signals before transmitting data to AWS IoT FleetWise .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCompression() {
        return software.amazon.jsii.Kernel.get(this, "compression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (Optional) Whether to compress signals before transmitting data to AWS IoT FleetWise .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCompression(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "compression", value);
    }

    /**
     * (Optional) The destination where the campaign sends data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDataDestinationConfigs() {
        return software.amazon.jsii.Kernel.get(this, "dataDestinationConfigs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * (Optional) The destination where the campaign sends data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataDestinationConfigs(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "dataDestinationConfigs", value);
    }

    /**
     * (Optional) The destination where the campaign sends data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataDestinationConfigs(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.iotfleetwise.CfnCampaign.DataDestinationConfigProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.iotfleetwise.CfnCampaign.DataDestinationConfigProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "dataDestinationConfigs", value);
    }

    /**
     * (Optional) A list of vehicle attributes to associate with a campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDataExtraDimensions() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "dataExtraDimensions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * (Optional) A list of vehicle attributes to associate with a campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataExtraDimensions(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "dataExtraDimensions", value);
    }

    /**
     * (Optional) The description of the campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (Optional) The description of the campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * (Optional) Option for a vehicle to send diagnostic trouble codes to AWS IoT FleetWise .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDiagnosticsMode() {
        return software.amazon.jsii.Kernel.get(this, "diagnosticsMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (Optional) Option for a vehicle to send diagnostic trouble codes to AWS IoT FleetWise .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDiagnosticsMode(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "diagnosticsMode", value);
    }

    /**
     * (Optional) The time the campaign expires, in seconds since epoch (January 1, 1970 at midnight UTC time).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getExpiryTime() {
        return software.amazon.jsii.Kernel.get(this, "expiryTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (Optional) The time the campaign expires, in seconds since epoch (January 1, 1970 at midnight UTC time).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExpiryTime(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "expiryTime", value);
    }

    /**
     * (Optional) How long (in milliseconds) to collect raw data after a triggering event initiates the collection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getPostTriggerCollectionDuration() {
        return software.amazon.jsii.Kernel.get(this, "postTriggerCollectionDuration", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * (Optional) How long (in milliseconds) to collect raw data after a triggering event initiates the collection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPostTriggerCollectionDuration(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "postTriggerCollectionDuration", value);
    }

    /**
     * (Optional) A number indicating the priority of one campaign over another campaign for a certain vehicle or fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getPriority() {
        return software.amazon.jsii.Kernel.get(this, "priority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * (Optional) A number indicating the priority of one campaign over another campaign for a certain vehicle or fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPriority(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "priority", value);
    }

    /**
     * (Optional) A list of information about signals to collect.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSignalsToCollect() {
        return software.amazon.jsii.Kernel.get(this, "signalsToCollect", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * (Optional) A list of information about signals to collect.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSignalsToCollect(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "signalsToCollect", value);
    }

    /**
     * (Optional) A list of information about signals to collect.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSignalsToCollect(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.iotfleetwise.CfnCampaign.SignalInformationProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.iotfleetwise.CfnCampaign.SignalInformationProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "signalsToCollect", value);
    }

    /**
     * (Optional) Whether to store collected data after a vehicle lost a connection with the cloud.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSpoolingMode() {
        return software.amazon.jsii.Kernel.get(this, "spoolingMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (Optional) Whether to store collected data after a vehicle lost a connection with the cloud.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSpoolingMode(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "spoolingMode", value);
    }

    /**
     * (Optional) The time, in milliseconds, to deliver a campaign after it was approved.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getStartTime() {
        return software.amazon.jsii.Kernel.get(this, "startTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (Optional) The time, in milliseconds, to deliver a campaign after it was approved.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStartTime(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "startTime", value);
    }

    /**
     * (Optional) Metadata that can be used to manage the campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * (Optional) Metadata that can be used to manage the campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * Specifies what data to collect and how often or when to collect it.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotfleetwise.*;
     * CollectionSchemeProperty collectionSchemeProperty = CollectionSchemeProperty.builder()
     *         .conditionBasedCollectionScheme(ConditionBasedCollectionSchemeProperty.builder()
     *                 .expression("expression")
     *                 // the properties below are optional
     *                 .conditionLanguageVersion(123)
     *                 .minimumTriggerIntervalMs(123)
     *                 .triggerMode("triggerMode")
     *                 .build())
     *         .timeBasedCollectionScheme(TimeBasedCollectionSchemeProperty.builder()
     *                 .periodMs(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-campaign-collectionscheme.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-campaign-collectionscheme.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotfleetwise.CfnCampaign.CollectionSchemeProperty")
    @software.amazon.jsii.Jsii.Proxy(CollectionSchemeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CollectionSchemeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * (Optional) Information about a collection scheme that uses a simple logical expression to recognize what data to collect.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-campaign-collectionscheme.html#cfn-iotfleetwise-campaign-collectionscheme-conditionbasedcollectionscheme">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-campaign-collectionscheme.html#cfn-iotfleetwise-campaign-collectionscheme-conditionbasedcollectionscheme</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConditionBasedCollectionScheme() {
            return null;
        }

        /**
         * (Optional) Information about a collection scheme that uses a time period to decide how often to collect data.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-campaign-collectionscheme.html#cfn-iotfleetwise-campaign-collectionscheme-timebasedcollectionscheme">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-campaign-collectionscheme.html#cfn-iotfleetwise-campaign-collectionscheme-timebasedcollectionscheme</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTimeBasedCollectionScheme() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CollectionSchemeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CollectionSchemeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CollectionSchemeProperty> {
            java.lang.Object conditionBasedCollectionScheme;
            java.lang.Object timeBasedCollectionScheme;

            /**
             * Sets the value of {@link CollectionSchemeProperty#getConditionBasedCollectionScheme}
             * @param conditionBasedCollectionScheme (Optional) Information about a collection scheme that uses a simple logical expression to recognize what data to collect.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder conditionBasedCollectionScheme(software.amazon.awscdk.IResolvable conditionBasedCollectionScheme) {
                this.conditionBasedCollectionScheme = conditionBasedCollectionScheme;
                return this;
            }

            /**
             * Sets the value of {@link CollectionSchemeProperty#getConditionBasedCollectionScheme}
             * @param conditionBasedCollectionScheme (Optional) Information about a collection scheme that uses a simple logical expression to recognize what data to collect.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder conditionBasedCollectionScheme(software.amazon.awscdk.services.iotfleetwise.CfnCampaign.ConditionBasedCollectionSchemeProperty conditionBasedCollectionScheme) {
                this.conditionBasedCollectionScheme = conditionBasedCollectionScheme;
                return this;
            }

            /**
             * Sets the value of {@link CollectionSchemeProperty#getTimeBasedCollectionScheme}
             * @param timeBasedCollectionScheme (Optional) Information about a collection scheme that uses a time period to decide how often to collect data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeBasedCollectionScheme(software.amazon.awscdk.IResolvable timeBasedCollectionScheme) {
                this.timeBasedCollectionScheme = timeBasedCollectionScheme;
                return this;
            }

            /**
             * Sets the value of {@link CollectionSchemeProperty#getTimeBasedCollectionScheme}
             * @param timeBasedCollectionScheme (Optional) Information about a collection scheme that uses a time period to decide how often to collect data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeBasedCollectionScheme(software.amazon.awscdk.services.iotfleetwise.CfnCampaign.TimeBasedCollectionSchemeProperty timeBasedCollectionScheme) {
                this.timeBasedCollectionScheme = timeBasedCollectionScheme;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CollectionSchemeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CollectionSchemeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CollectionSchemeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CollectionSchemeProperty {
            private final java.lang.Object conditionBasedCollectionScheme;
            private final java.lang.Object timeBasedCollectionScheme;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.conditionBasedCollectionScheme = software.amazon.jsii.Kernel.get(this, "conditionBasedCollectionScheme", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.timeBasedCollectionScheme = software.amazon.jsii.Kernel.get(this, "timeBasedCollectionScheme", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.conditionBasedCollectionScheme = builder.conditionBasedCollectionScheme;
                this.timeBasedCollectionScheme = builder.timeBasedCollectionScheme;
            }

            @Override
            public final java.lang.Object getConditionBasedCollectionScheme() {
                return this.conditionBasedCollectionScheme;
            }

            @Override
            public final java.lang.Object getTimeBasedCollectionScheme() {
                return this.timeBasedCollectionScheme;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getConditionBasedCollectionScheme() != null) {
                    data.set("conditionBasedCollectionScheme", om.valueToTree(this.getConditionBasedCollectionScheme()));
                }
                if (this.getTimeBasedCollectionScheme() != null) {
                    data.set("timeBasedCollectionScheme", om.valueToTree(this.getTimeBasedCollectionScheme()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotfleetwise.CfnCampaign.CollectionSchemeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CollectionSchemeProperty.Jsii$Proxy that = (CollectionSchemeProperty.Jsii$Proxy) o;

                if (this.conditionBasedCollectionScheme != null ? !this.conditionBasedCollectionScheme.equals(that.conditionBasedCollectionScheme) : that.conditionBasedCollectionScheme != null) return false;
                return this.timeBasedCollectionScheme != null ? this.timeBasedCollectionScheme.equals(that.timeBasedCollectionScheme) : that.timeBasedCollectionScheme == null;
            }

            @Override
            public final int hashCode() {
                int result = this.conditionBasedCollectionScheme != null ? this.conditionBasedCollectionScheme.hashCode() : 0;
                result = 31 * result + (this.timeBasedCollectionScheme != null ? this.timeBasedCollectionScheme.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about a collection scheme that uses a simple logical expression to recognize what data to collect.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotfleetwise.*;
     * ConditionBasedCollectionSchemeProperty conditionBasedCollectionSchemeProperty = ConditionBasedCollectionSchemeProperty.builder()
     *         .expression("expression")
     *         // the properties below are optional
     *         .conditionLanguageVersion(123)
     *         .minimumTriggerIntervalMs(123)
     *         .triggerMode("triggerMode")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-campaign-conditionbasedcollectionscheme.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-campaign-conditionbasedcollectionscheme.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotfleetwise.CfnCampaign.ConditionBasedCollectionSchemeProperty")
    @software.amazon.jsii.Jsii.Proxy(ConditionBasedCollectionSchemeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConditionBasedCollectionSchemeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The logical expression used to recognize what data to collect.
         * <p>
         * For example, <code>$variable.Vehicle.OutsideAirTemperature &gt;= 105.0</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-campaign-conditionbasedcollectionscheme.html#cfn-iotfleetwise-campaign-conditionbasedcollectionscheme-expression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-campaign-conditionbasedcollectionscheme.html#cfn-iotfleetwise-campaign-conditionbasedcollectionscheme-expression</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getExpression();

        /**
         * (Optional) Specifies the version of the conditional expression language.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-campaign-conditionbasedcollectionscheme.html#cfn-iotfleetwise-campaign-conditionbasedcollectionscheme-conditionlanguageversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-campaign-conditionbasedcollectionscheme.html#cfn-iotfleetwise-campaign-conditionbasedcollectionscheme-conditionlanguageversion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getConditionLanguageVersion() {
            return null;
        }

        /**
         * (Optional) The minimum duration of time between two triggering events to collect data, in milliseconds.
         * <p>
         * <blockquote>
         * <p>
         * If a signal changes often, you might want to collect data at a slower rate.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-campaign-conditionbasedcollectionscheme.html#cfn-iotfleetwise-campaign-conditionbasedcollectionscheme-minimumtriggerintervalms">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-campaign-conditionbasedcollectionscheme.html#cfn-iotfleetwise-campaign-conditionbasedcollectionscheme-minimumtriggerintervalms</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMinimumTriggerIntervalMs() {
            return null;
        }

        /**
         * (Optional) Whether to collect data for all triggering events ( <code>ALWAYS</code> ).
         * <p>
         * Specify ( <code>RISING_EDGE</code> ), or specify only when the condition first evaluates to false. For example, triggering on "AirbagDeployed"; Users aren't interested on triggering when the airbag is already exploded; they only care about the change from not deployed =&gt; deployed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-campaign-conditionbasedcollectionscheme.html#cfn-iotfleetwise-campaign-conditionbasedcollectionscheme-triggermode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-campaign-conditionbasedcollectionscheme.html#cfn-iotfleetwise-campaign-conditionbasedcollectionscheme-triggermode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTriggerMode() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConditionBasedCollectionSchemeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConditionBasedCollectionSchemeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConditionBasedCollectionSchemeProperty> {
            java.lang.String expression;
            java.lang.Number conditionLanguageVersion;
            java.lang.Number minimumTriggerIntervalMs;
            java.lang.String triggerMode;

            /**
             * Sets the value of {@link ConditionBasedCollectionSchemeProperty#getExpression}
             * @param expression The logical expression used to recognize what data to collect. This parameter is required.
             *                   For example, <code>$variable.Vehicle.OutsideAirTemperature &gt;= 105.0</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder expression(java.lang.String expression) {
                this.expression = expression;
                return this;
            }

            /**
             * Sets the value of {@link ConditionBasedCollectionSchemeProperty#getConditionLanguageVersion}
             * @param conditionLanguageVersion (Optional) Specifies the version of the conditional expression language.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder conditionLanguageVersion(java.lang.Number conditionLanguageVersion) {
                this.conditionLanguageVersion = conditionLanguageVersion;
                return this;
            }

            /**
             * Sets the value of {@link ConditionBasedCollectionSchemeProperty#getMinimumTriggerIntervalMs}
             * @param minimumTriggerIntervalMs (Optional) The minimum duration of time between two triggering events to collect data, in milliseconds.
             *                                 <blockquote>
             *                                 <p>
             *                                 If a signal changes often, you might want to collect data at a slower rate.
             *                                 <p>
             *                                 </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minimumTriggerIntervalMs(java.lang.Number minimumTriggerIntervalMs) {
                this.minimumTriggerIntervalMs = minimumTriggerIntervalMs;
                return this;
            }

            /**
             * Sets the value of {@link ConditionBasedCollectionSchemeProperty#getTriggerMode}
             * @param triggerMode (Optional) Whether to collect data for all triggering events ( <code>ALWAYS</code> ).
             *                    Specify ( <code>RISING_EDGE</code> ), or specify only when the condition first evaluates to false. For example, triggering on "AirbagDeployed"; Users aren't interested on triggering when the airbag is already exploded; they only care about the change from not deployed =&gt; deployed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder triggerMode(java.lang.String triggerMode) {
                this.triggerMode = triggerMode;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConditionBasedCollectionSchemeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConditionBasedCollectionSchemeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConditionBasedCollectionSchemeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConditionBasedCollectionSchemeProperty {
            private final java.lang.String expression;
            private final java.lang.Number conditionLanguageVersion;
            private final java.lang.Number minimumTriggerIntervalMs;
            private final java.lang.String triggerMode;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.expression = software.amazon.jsii.Kernel.get(this, "expression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.conditionLanguageVersion = software.amazon.jsii.Kernel.get(this, "conditionLanguageVersion", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.minimumTriggerIntervalMs = software.amazon.jsii.Kernel.get(this, "minimumTriggerIntervalMs", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.triggerMode = software.amazon.jsii.Kernel.get(this, "triggerMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.expression = java.util.Objects.requireNonNull(builder.expression, "expression is required");
                this.conditionLanguageVersion = builder.conditionLanguageVersion;
                this.minimumTriggerIntervalMs = builder.minimumTriggerIntervalMs;
                this.triggerMode = builder.triggerMode;
            }

            @Override
            public final java.lang.String getExpression() {
                return this.expression;
            }

            @Override
            public final java.lang.Number getConditionLanguageVersion() {
                return this.conditionLanguageVersion;
            }

            @Override
            public final java.lang.Number getMinimumTriggerIntervalMs() {
                return this.minimumTriggerIntervalMs;
            }

            @Override
            public final java.lang.String getTriggerMode() {
                return this.triggerMode;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("expression", om.valueToTree(this.getExpression()));
                if (this.getConditionLanguageVersion() != null) {
                    data.set("conditionLanguageVersion", om.valueToTree(this.getConditionLanguageVersion()));
                }
                if (this.getMinimumTriggerIntervalMs() != null) {
                    data.set("minimumTriggerIntervalMs", om.valueToTree(this.getMinimumTriggerIntervalMs()));
                }
                if (this.getTriggerMode() != null) {
                    data.set("triggerMode", om.valueToTree(this.getTriggerMode()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotfleetwise.CfnCampaign.ConditionBasedCollectionSchemeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConditionBasedCollectionSchemeProperty.Jsii$Proxy that = (ConditionBasedCollectionSchemeProperty.Jsii$Proxy) o;

                if (!expression.equals(that.expression)) return false;
                if (this.conditionLanguageVersion != null ? !this.conditionLanguageVersion.equals(that.conditionLanguageVersion) : that.conditionLanguageVersion != null) return false;
                if (this.minimumTriggerIntervalMs != null ? !this.minimumTriggerIntervalMs.equals(that.minimumTriggerIntervalMs) : that.minimumTriggerIntervalMs != null) return false;
                return this.triggerMode != null ? this.triggerMode.equals(that.triggerMode) : that.triggerMode == null;
            }

            @Override
            public final int hashCode() {
                int result = this.expression.hashCode();
                result = 31 * result + (this.conditionLanguageVersion != null ? this.conditionLanguageVersion.hashCode() : 0);
                result = 31 * result + (this.minimumTriggerIntervalMs != null ? this.minimumTriggerIntervalMs.hashCode() : 0);
                result = 31 * result + (this.triggerMode != null ? this.triggerMode.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The destination where the AWS IoT FleetWise campaign sends data.
     * <p>
     * You can send data to be stored in Amazon S3 or Amazon Timestream .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotfleetwise.*;
     * DataDestinationConfigProperty dataDestinationConfigProperty = DataDestinationConfigProperty.builder()
     *         .s3Config(S3ConfigProperty.builder()
     *                 .bucketArn("bucketArn")
     *                 // the properties below are optional
     *                 .dataFormat("dataFormat")
     *                 .prefix("prefix")
     *                 .storageCompressionFormat("storageCompressionFormat")
     *                 .build())
     *         .timestreamConfig(TimestreamConfigProperty.builder()
     *                 .executionRoleArn("executionRoleArn")
     *                 .timestreamTableArn("timestreamTableArn")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-campaign-datadestinationconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-campaign-datadestinationconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotfleetwise.CfnCampaign.DataDestinationConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(DataDestinationConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataDestinationConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * (Optional) The Amazon S3 bucket where the AWS IoT FleetWise campaign sends data.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-campaign-datadestinationconfig.html#cfn-iotfleetwise-campaign-datadestinationconfig-s3config">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-campaign-datadestinationconfig.html#cfn-iotfleetwise-campaign-datadestinationconfig-s3config</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3Config() {
            return null;
        }

        /**
         * (Optional) The Amazon Timestream table where the campaign sends data.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-campaign-datadestinationconfig.html#cfn-iotfleetwise-campaign-datadestinationconfig-timestreamconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-campaign-datadestinationconfig.html#cfn-iotfleetwise-campaign-datadestinationconfig-timestreamconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTimestreamConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DataDestinationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataDestinationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataDestinationConfigProperty> {
            java.lang.Object s3Config;
            java.lang.Object timestreamConfig;

            /**
             * Sets the value of {@link DataDestinationConfigProperty#getS3Config}
             * @param s3Config (Optional) The Amazon S3 bucket where the AWS IoT FleetWise campaign sends data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Config(software.amazon.awscdk.IResolvable s3Config) {
                this.s3Config = s3Config;
                return this;
            }

            /**
             * Sets the value of {@link DataDestinationConfigProperty#getS3Config}
             * @param s3Config (Optional) The Amazon S3 bucket where the AWS IoT FleetWise campaign sends data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Config(software.amazon.awscdk.services.iotfleetwise.CfnCampaign.S3ConfigProperty s3Config) {
                this.s3Config = s3Config;
                return this;
            }

            /**
             * Sets the value of {@link DataDestinationConfigProperty#getTimestreamConfig}
             * @param timestreamConfig (Optional) The Amazon Timestream table where the campaign sends data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timestreamConfig(software.amazon.awscdk.IResolvable timestreamConfig) {
                this.timestreamConfig = timestreamConfig;
                return this;
            }

            /**
             * Sets the value of {@link DataDestinationConfigProperty#getTimestreamConfig}
             * @param timestreamConfig (Optional) The Amazon Timestream table where the campaign sends data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timestreamConfig(software.amazon.awscdk.services.iotfleetwise.CfnCampaign.TimestreamConfigProperty timestreamConfig) {
                this.timestreamConfig = timestreamConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataDestinationConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataDestinationConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataDestinationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataDestinationConfigProperty {
            private final java.lang.Object s3Config;
            private final java.lang.Object timestreamConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3Config = software.amazon.jsii.Kernel.get(this, "s3Config", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.timestreamConfig = software.amazon.jsii.Kernel.get(this, "timestreamConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3Config = builder.s3Config;
                this.timestreamConfig = builder.timestreamConfig;
            }

            @Override
            public final java.lang.Object getS3Config() {
                return this.s3Config;
            }

            @Override
            public final java.lang.Object getTimestreamConfig() {
                return this.timestreamConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getS3Config() != null) {
                    data.set("s3Config", om.valueToTree(this.getS3Config()));
                }
                if (this.getTimestreamConfig() != null) {
                    data.set("timestreamConfig", om.valueToTree(this.getTimestreamConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotfleetwise.CfnCampaign.DataDestinationConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataDestinationConfigProperty.Jsii$Proxy that = (DataDestinationConfigProperty.Jsii$Proxy) o;

                if (this.s3Config != null ? !this.s3Config.equals(that.s3Config) : that.s3Config != null) return false;
                return this.timestreamConfig != null ? this.timestreamConfig.equals(that.timestreamConfig) : that.timestreamConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.s3Config != null ? this.s3Config.hashCode() : 0;
                result = 31 * result + (this.timestreamConfig != null ? this.timestreamConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The Amazon S3 bucket where the AWS IoT FleetWise campaign sends data.
     * <p>
     * Amazon S3 is an object storage service that stores data as objects within buckets. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/creating-buckets-s3.html">Creating, configuring, and working with Amazon S3 buckets</a> in the <em>Amazon Simple Storage Service User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotfleetwise.*;
     * S3ConfigProperty s3ConfigProperty = S3ConfigProperty.builder()
     *         .bucketArn("bucketArn")
     *         // the properties below are optional
     *         .dataFormat("dataFormat")
     *         .prefix("prefix")
     *         .storageCompressionFormat("storageCompressionFormat")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-campaign-s3config.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-campaign-s3config.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotfleetwise.CfnCampaign.S3ConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(S3ConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3ConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the Amazon S3 bucket.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-campaign-s3config.html#cfn-iotfleetwise-campaign-s3config-bucketarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-campaign-s3config.html#cfn-iotfleetwise-campaign-s3config-bucketarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucketArn();

        /**
         * (Optional) Specify the format that files are saved in the Amazon S3 bucket.
         * <p>
         * You can save files in an Apache Parquet or JSON format.
         * <p>
         * <ul>
         * <li>Parquet - Store data in a columnar storage file format. Parquet is optimal for fast data retrieval and can reduce costs. This option is selected by default.</li>
         * <li>JSON - Store data in a standard text-based JSON file format.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-campaign-s3config.html#cfn-iotfleetwise-campaign-s3config-dataformat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-campaign-s3config.html#cfn-iotfleetwise-campaign-s3config-dataformat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDataFormat() {
            return null;
        }

        /**
         * (Optional) Enter an S3 bucket prefix.
         * <p>
         * The prefix is the string of characters after the bucket name and before the object name. You can use the prefix to organize data stored in Amazon S3 buckets. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-prefixes.html">Organizing objects using prefixes</a> in the <em>Amazon Simple Storage Service User Guide</em> .
         * <p>
         * By default, AWS IoT FleetWise sets the prefix <code>processed-data/year=YY/month=MM/date=DD/hour=HH/</code> (in UTC) to data it delivers to Amazon S3 . You can enter a prefix to append it to this default prefix. For example, if you enter the prefix <code>vehicles</code> , the prefix will be <code>vehicles/processed-data/year=YY/month=MM/date=DD/hour=HH/</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-campaign-s3config.html#cfn-iotfleetwise-campaign-s3config-prefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-campaign-s3config.html#cfn-iotfleetwise-campaign-s3config-prefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrefix() {
            return null;
        }

        /**
         * (Optional) By default, stored data is compressed as a .gzip file. Compressed files have a reduced file size, which can optimize the cost of data storage.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-campaign-s3config.html#cfn-iotfleetwise-campaign-s3config-storagecompressionformat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-campaign-s3config.html#cfn-iotfleetwise-campaign-s3config-storagecompressionformat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStorageCompressionFormat() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3ConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3ConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3ConfigProperty> {
            java.lang.String bucketArn;
            java.lang.String dataFormat;
            java.lang.String prefix;
            java.lang.String storageCompressionFormat;

            /**
             * Sets the value of {@link S3ConfigProperty#getBucketArn}
             * @param bucketArn The Amazon Resource Name (ARN) of the Amazon S3 bucket. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketArn(java.lang.String bucketArn) {
                this.bucketArn = bucketArn;
                return this;
            }

            /**
             * Sets the value of {@link S3ConfigProperty#getDataFormat}
             * @param dataFormat (Optional) Specify the format that files are saved in the Amazon S3 bucket.
             *                   You can save files in an Apache Parquet or JSON format.
             *                   <p>
             *                   <ul>
             *                   <li>Parquet - Store data in a columnar storage file format. Parquet is optimal for fast data retrieval and can reduce costs. This option is selected by default.</li>
             *                   <li>JSON - Store data in a standard text-based JSON file format.</li>
             *                   </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataFormat(java.lang.String dataFormat) {
                this.dataFormat = dataFormat;
                return this;
            }

            /**
             * Sets the value of {@link S3ConfigProperty#getPrefix}
             * @param prefix (Optional) Enter an S3 bucket prefix.
             *               The prefix is the string of characters after the bucket name and before the object name. You can use the prefix to organize data stored in Amazon S3 buckets. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-prefixes.html">Organizing objects using prefixes</a> in the <em>Amazon Simple Storage Service User Guide</em> .
             *               <p>
             *               By default, AWS IoT FleetWise sets the prefix <code>processed-data/year=YY/month=MM/date=DD/hour=HH/</code> (in UTC) to data it delivers to Amazon S3 . You can enter a prefix to append it to this default prefix. For example, if you enter the prefix <code>vehicles</code> , the prefix will be <code>vehicles/processed-data/year=YY/month=MM/date=DD/hour=HH/</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prefix(java.lang.String prefix) {
                this.prefix = prefix;
                return this;
            }

            /**
             * Sets the value of {@link S3ConfigProperty#getStorageCompressionFormat}
             * @param storageCompressionFormat (Optional) By default, stored data is compressed as a .gzip file. Compressed files have a reduced file size, which can optimize the cost of data storage.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder storageCompressionFormat(java.lang.String storageCompressionFormat) {
                this.storageCompressionFormat = storageCompressionFormat;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3ConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3ConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3ConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3ConfigProperty {
            private final java.lang.String bucketArn;
            private final java.lang.String dataFormat;
            private final java.lang.String prefix;
            private final java.lang.String storageCompressionFormat;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucketArn = software.amazon.jsii.Kernel.get(this, "bucketArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dataFormat = software.amazon.jsii.Kernel.get(this, "dataFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.prefix = software.amazon.jsii.Kernel.get(this, "prefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.storageCompressionFormat = software.amazon.jsii.Kernel.get(this, "storageCompressionFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucketArn = java.util.Objects.requireNonNull(builder.bucketArn, "bucketArn is required");
                this.dataFormat = builder.dataFormat;
                this.prefix = builder.prefix;
                this.storageCompressionFormat = builder.storageCompressionFormat;
            }

            @Override
            public final java.lang.String getBucketArn() {
                return this.bucketArn;
            }

            @Override
            public final java.lang.String getDataFormat() {
                return this.dataFormat;
            }

            @Override
            public final java.lang.String getPrefix() {
                return this.prefix;
            }

            @Override
            public final java.lang.String getStorageCompressionFormat() {
                return this.storageCompressionFormat;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucketArn", om.valueToTree(this.getBucketArn()));
                if (this.getDataFormat() != null) {
                    data.set("dataFormat", om.valueToTree(this.getDataFormat()));
                }
                if (this.getPrefix() != null) {
                    data.set("prefix", om.valueToTree(this.getPrefix()));
                }
                if (this.getStorageCompressionFormat() != null) {
                    data.set("storageCompressionFormat", om.valueToTree(this.getStorageCompressionFormat()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotfleetwise.CfnCampaign.S3ConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3ConfigProperty.Jsii$Proxy that = (S3ConfigProperty.Jsii$Proxy) o;

                if (!bucketArn.equals(that.bucketArn)) return false;
                if (this.dataFormat != null ? !this.dataFormat.equals(that.dataFormat) : that.dataFormat != null) return false;
                if (this.prefix != null ? !this.prefix.equals(that.prefix) : that.prefix != null) return false;
                return this.storageCompressionFormat != null ? this.storageCompressionFormat.equals(that.storageCompressionFormat) : that.storageCompressionFormat == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucketArn.hashCode();
                result = 31 * result + (this.dataFormat != null ? this.dataFormat.hashCode() : 0);
                result = 31 * result + (this.prefix != null ? this.prefix.hashCode() : 0);
                result = 31 * result + (this.storageCompressionFormat != null ? this.storageCompressionFormat.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about a signal.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotfleetwise.*;
     * SignalInformationProperty signalInformationProperty = SignalInformationProperty.builder()
     *         .name("name")
     *         // the properties below are optional
     *         .maxSampleCount(123)
     *         .minimumSamplingIntervalMs(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-campaign-signalinformation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-campaign-signalinformation.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotfleetwise.CfnCampaign.SignalInformationProperty")
    @software.amazon.jsii.Jsii.Proxy(SignalInformationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SignalInformationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the signal.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-campaign-signalinformation.html#cfn-iotfleetwise-campaign-signalinformation-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-campaign-signalinformation.html#cfn-iotfleetwise-campaign-signalinformation-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * (Optional) The maximum number of samples to collect.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-campaign-signalinformation.html#cfn-iotfleetwise-campaign-signalinformation-maxsamplecount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-campaign-signalinformation.html#cfn-iotfleetwise-campaign-signalinformation-maxsamplecount</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxSampleCount() {
            return null;
        }

        /**
         * (Optional) The minimum duration of time (in milliseconds) between two triggering events to collect data.
         * <p>
         * <blockquote>
         * <p>
         * If a signal changes often, you might want to collect data at a slower rate.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-campaign-signalinformation.html#cfn-iotfleetwise-campaign-signalinformation-minimumsamplingintervalms">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-campaign-signalinformation.html#cfn-iotfleetwise-campaign-signalinformation-minimumsamplingintervalms</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMinimumSamplingIntervalMs() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SignalInformationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SignalInformationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SignalInformationProperty> {
            java.lang.String name;
            java.lang.Number maxSampleCount;
            java.lang.Number minimumSamplingIntervalMs;

            /**
             * Sets the value of {@link SignalInformationProperty#getName}
             * @param name The name of the signal. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link SignalInformationProperty#getMaxSampleCount}
             * @param maxSampleCount (Optional) The maximum number of samples to collect.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxSampleCount(java.lang.Number maxSampleCount) {
                this.maxSampleCount = maxSampleCount;
                return this;
            }

            /**
             * Sets the value of {@link SignalInformationProperty#getMinimumSamplingIntervalMs}
             * @param minimumSamplingIntervalMs (Optional) The minimum duration of time (in milliseconds) between two triggering events to collect data.
             *                                  <blockquote>
             *                                  <p>
             *                                  If a signal changes often, you might want to collect data at a slower rate.
             *                                  <p>
             *                                  </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minimumSamplingIntervalMs(java.lang.Number minimumSamplingIntervalMs) {
                this.minimumSamplingIntervalMs = minimumSamplingIntervalMs;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SignalInformationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SignalInformationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SignalInformationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SignalInformationProperty {
            private final java.lang.String name;
            private final java.lang.Number maxSampleCount;
            private final java.lang.Number minimumSamplingIntervalMs;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.maxSampleCount = software.amazon.jsii.Kernel.get(this, "maxSampleCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.minimumSamplingIntervalMs = software.amazon.jsii.Kernel.get(this, "minimumSamplingIntervalMs", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.maxSampleCount = builder.maxSampleCount;
                this.minimumSamplingIntervalMs = builder.minimumSamplingIntervalMs;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Number getMaxSampleCount() {
                return this.maxSampleCount;
            }

            @Override
            public final java.lang.Number getMinimumSamplingIntervalMs() {
                return this.minimumSamplingIntervalMs;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                if (this.getMaxSampleCount() != null) {
                    data.set("maxSampleCount", om.valueToTree(this.getMaxSampleCount()));
                }
                if (this.getMinimumSamplingIntervalMs() != null) {
                    data.set("minimumSamplingIntervalMs", om.valueToTree(this.getMinimumSamplingIntervalMs()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotfleetwise.CfnCampaign.SignalInformationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SignalInformationProperty.Jsii$Proxy that = (SignalInformationProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                if (this.maxSampleCount != null ? !this.maxSampleCount.equals(that.maxSampleCount) : that.maxSampleCount != null) return false;
                return this.minimumSamplingIntervalMs != null ? this.minimumSamplingIntervalMs.equals(that.minimumSamplingIntervalMs) : that.minimumSamplingIntervalMs == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.maxSampleCount != null ? this.maxSampleCount.hashCode() : 0);
                result = 31 * result + (this.minimumSamplingIntervalMs != null ? this.minimumSamplingIntervalMs.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about a collection scheme that uses a time period to decide how often to collect data.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotfleetwise.*;
     * TimeBasedCollectionSchemeProperty timeBasedCollectionSchemeProperty = TimeBasedCollectionSchemeProperty.builder()
     *         .periodMs(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-campaign-timebasedcollectionscheme.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-campaign-timebasedcollectionscheme.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotfleetwise.CfnCampaign.TimeBasedCollectionSchemeProperty")
    @software.amazon.jsii.Jsii.Proxy(TimeBasedCollectionSchemeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TimeBasedCollectionSchemeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The time period (in milliseconds) to decide how often to collect data.
         * <p>
         * For example, if the time period is <code>60000</code> , the Edge Agent software collects data once every minute.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-campaign-timebasedcollectionscheme.html#cfn-iotfleetwise-campaign-timebasedcollectionscheme-periodms">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-campaign-timebasedcollectionscheme.html#cfn-iotfleetwise-campaign-timebasedcollectionscheme-periodms</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getPeriodMs();

        /**
         * @return a {@link Builder} of {@link TimeBasedCollectionSchemeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TimeBasedCollectionSchemeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TimeBasedCollectionSchemeProperty> {
            java.lang.Number periodMs;

            /**
             * Sets the value of {@link TimeBasedCollectionSchemeProperty#getPeriodMs}
             * @param periodMs The time period (in milliseconds) to decide how often to collect data. This parameter is required.
             *                 For example, if the time period is <code>60000</code> , the Edge Agent software collects data once every minute.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder periodMs(java.lang.Number periodMs) {
                this.periodMs = periodMs;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TimeBasedCollectionSchemeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TimeBasedCollectionSchemeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TimeBasedCollectionSchemeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TimeBasedCollectionSchemeProperty {
            private final java.lang.Number periodMs;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.periodMs = software.amazon.jsii.Kernel.get(this, "periodMs", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.periodMs = java.util.Objects.requireNonNull(builder.periodMs, "periodMs is required");
            }

            @Override
            public final java.lang.Number getPeriodMs() {
                return this.periodMs;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("periodMs", om.valueToTree(this.getPeriodMs()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotfleetwise.CfnCampaign.TimeBasedCollectionSchemeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TimeBasedCollectionSchemeProperty.Jsii$Proxy that = (TimeBasedCollectionSchemeProperty.Jsii$Proxy) o;

                return this.periodMs.equals(that.periodMs);
            }

            @Override
            public final int hashCode() {
                int result = this.periodMs.hashCode();
                return result;
            }
        }
    }
    /**
     * The Amazon Timestream table where the AWS IoT FleetWise campaign sends data.
     * <p>
     * Timestream stores and organizes data to optimize query processing time and to reduce storage costs. For more information, see <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/data-modeling.html">Data modeling</a> in the <em>Amazon Timestream Developer Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotfleetwise.*;
     * TimestreamConfigProperty timestreamConfigProperty = TimestreamConfigProperty.builder()
     *         .executionRoleArn("executionRoleArn")
     *         .timestreamTableArn("timestreamTableArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-campaign-timestreamconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-campaign-timestreamconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotfleetwise.CfnCampaign.TimestreamConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(TimestreamConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TimestreamConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the task execution role that grants AWS IoT FleetWise permission to deliver data to the Amazon Timestream table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-campaign-timestreamconfig.html#cfn-iotfleetwise-campaign-timestreamconfig-executionrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-campaign-timestreamconfig.html#cfn-iotfleetwise-campaign-timestreamconfig-executionrolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getExecutionRoleArn();

        /**
         * The Amazon Resource Name (ARN) of the Amazon Timestream table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-campaign-timestreamconfig.html#cfn-iotfleetwise-campaign-timestreamconfig-timestreamtablearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-campaign-timestreamconfig.html#cfn-iotfleetwise-campaign-timestreamconfig-timestreamtablearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTimestreamTableArn();

        /**
         * @return a {@link Builder} of {@link TimestreamConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TimestreamConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TimestreamConfigProperty> {
            java.lang.String executionRoleArn;
            java.lang.String timestreamTableArn;

            /**
             * Sets the value of {@link TimestreamConfigProperty#getExecutionRoleArn}
             * @param executionRoleArn The Amazon Resource Name (ARN) of the task execution role that grants AWS IoT FleetWise permission to deliver data to the Amazon Timestream table. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder executionRoleArn(java.lang.String executionRoleArn) {
                this.executionRoleArn = executionRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link TimestreamConfigProperty#getTimestreamTableArn}
             * @param timestreamTableArn The Amazon Resource Name (ARN) of the Amazon Timestream table. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timestreamTableArn(java.lang.String timestreamTableArn) {
                this.timestreamTableArn = timestreamTableArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TimestreamConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TimestreamConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TimestreamConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TimestreamConfigProperty {
            private final java.lang.String executionRoleArn;
            private final java.lang.String timestreamTableArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.executionRoleArn = software.amazon.jsii.Kernel.get(this, "executionRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.timestreamTableArn = software.amazon.jsii.Kernel.get(this, "timestreamTableArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.executionRoleArn = java.util.Objects.requireNonNull(builder.executionRoleArn, "executionRoleArn is required");
                this.timestreamTableArn = java.util.Objects.requireNonNull(builder.timestreamTableArn, "timestreamTableArn is required");
            }

            @Override
            public final java.lang.String getExecutionRoleArn() {
                return this.executionRoleArn;
            }

            @Override
            public final java.lang.String getTimestreamTableArn() {
                return this.timestreamTableArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("executionRoleArn", om.valueToTree(this.getExecutionRoleArn()));
                data.set("timestreamTableArn", om.valueToTree(this.getTimestreamTableArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotfleetwise.CfnCampaign.TimestreamConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TimestreamConfigProperty.Jsii$Proxy that = (TimestreamConfigProperty.Jsii$Proxy) o;

                if (!executionRoleArn.equals(that.executionRoleArn)) return false;
                return this.timestreamTableArn.equals(that.timestreamTableArn);
            }

            @Override
            public final int hashCode() {
                int result = this.executionRoleArn.hashCode();
                result = 31 * result + (this.timestreamTableArn.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.iotfleetwise.CfnCampaign}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iotfleetwise.CfnCampaign> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.iotfleetwise.CfnCampaignProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.iotfleetwise.CfnCampaignProps.Builder();
        }

        /**
         * Specifies how to update a campaign. The action can be one of the following:.
         * <p>
         * <ul>
         * <li><code>APPROVE</code> - To approve delivering a data collection scheme to vehicles.</li>
         * <li><code>SUSPEND</code> - To suspend collecting signal data. The campaign is deleted from vehicles and all vehicles in the suspended campaign will stop sending data.</li>
         * <li><code>RESUME</code> - To reactivate the <code>SUSPEND</code> campaign. The campaign is redeployed to all vehicles and the vehicles will resume sending data.</li>
         * <li><code>UPDATE</code> - To update a campaign.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-action">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-action</a>
         * @param action Specifies how to update a campaign. The action can be one of the following:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder action(final java.lang.String action) {
            this.props.action(action);
            return this;
        }

        /**
         * The data collection scheme associated with the campaign.
         * <p>
         * You can specify a scheme that collects data based on time or an event.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-collectionscheme">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-collectionscheme</a>
         * @param collectionScheme The data collection scheme associated with the campaign. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder collectionScheme(final software.amazon.awscdk.IResolvable collectionScheme) {
            this.props.collectionScheme(collectionScheme);
            return this;
        }
        /**
         * The data collection scheme associated with the campaign.
         * <p>
         * You can specify a scheme that collects data based on time or an event.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-collectionscheme">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-collectionscheme</a>
         * @param collectionScheme The data collection scheme associated with the campaign. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder collectionScheme(final software.amazon.awscdk.services.iotfleetwise.CfnCampaign.CollectionSchemeProperty collectionScheme) {
            this.props.collectionScheme(collectionScheme);
            return this;
        }

        /**
         * The name of a campaign.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-name</a>
         * @param name The name of a campaign. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the signal catalog associated with the campaign.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-signalcatalogarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-signalcatalogarn</a>
         * @param signalCatalogArn The Amazon Resource Name (ARN) of the signal catalog associated with the campaign. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder signalCatalogArn(final java.lang.String signalCatalogArn) {
            this.props.signalCatalogArn(signalCatalogArn);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of a vehicle or fleet to which the campaign is deployed.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-targetarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-targetarn</a>
         * @param targetArn The Amazon Resource Name (ARN) of a vehicle or fleet to which the campaign is deployed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetArn(final java.lang.String targetArn) {
            this.props.targetArn(targetArn);
            return this;
        }

        /**
         * (Optional) Whether to compress signals before transmitting data to AWS IoT FleetWise .
         * <p>
         * If you don't want to compress the signals, use <code>OFF</code> . If it's not specified, <code>SNAPPY</code> is used.
         * <p>
         * Default: <code>SNAPPY</code>
         * <p>
         * Default: - "OFF"
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-compression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-compression</a>
         * @param compression (Optional) Whether to compress signals before transmitting data to AWS IoT FleetWise . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder compression(final java.lang.String compression) {
            this.props.compression(compression);
            return this;
        }

        /**
         * (Optional) The destination where the campaign sends data.
         * <p>
         * You can choose to send data to be stored in Amazon S3 or Amazon Timestream .
         * <p>
         * Amazon S3 optimizes the cost of data storage and provides additional mechanisms to use vehicle data, such as data lakes, centralized data storage, data processing pipelines, and analytics. AWS IoT FleetWise supports at-least-once file delivery to S3. Your vehicle data is stored on multiple AWS IoT FleetWise servers for redundancy and high availability.
         * <p>
         * You can use Amazon Timestream to access and analyze time series data, and Timestream to query vehicle data so that you can identify trends and patterns.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-datadestinationconfigs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-datadestinationconfigs</a>
         * @param dataDestinationConfigs (Optional) The destination where the campaign sends data. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataDestinationConfigs(final software.amazon.awscdk.IResolvable dataDestinationConfigs) {
            this.props.dataDestinationConfigs(dataDestinationConfigs);
            return this;
        }
        /**
         * (Optional) The destination where the campaign sends data.
         * <p>
         * You can choose to send data to be stored in Amazon S3 or Amazon Timestream .
         * <p>
         * Amazon S3 optimizes the cost of data storage and provides additional mechanisms to use vehicle data, such as data lakes, centralized data storage, data processing pipelines, and analytics. AWS IoT FleetWise supports at-least-once file delivery to S3. Your vehicle data is stored on multiple AWS IoT FleetWise servers for redundancy and high availability.
         * <p>
         * You can use Amazon Timestream to access and analyze time series data, and Timestream to query vehicle data so that you can identify trends and patterns.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-datadestinationconfigs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-datadestinationconfigs</a>
         * @param dataDestinationConfigs (Optional) The destination where the campaign sends data. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataDestinationConfigs(final java.util.List<? extends java.lang.Object> dataDestinationConfigs) {
            this.props.dataDestinationConfigs(dataDestinationConfigs);
            return this;
        }

        /**
         * (Optional) A list of vehicle attributes to associate with a campaign.
         * <p>
         * Enrich the data with specified vehicle attributes. For example, add <code>make</code> and <code>model</code> to the campaign, and AWS IoT FleetWise will associate the data with those attributes as dimensions in Amazon Timestream . You can then query the data against <code>make</code> and <code>model</code> .
         * <p>
         * Default: An empty array
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-dataextradimensions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-dataextradimensions</a>
         * @param dataExtraDimensions (Optional) A list of vehicle attributes to associate with a campaign. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataExtraDimensions(final java.util.List<java.lang.String> dataExtraDimensions) {
            this.props.dataExtraDimensions(dataExtraDimensions);
            return this;
        }

        /**
         * (Optional) The description of the campaign.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-description</a>
         * @param description (Optional) The description of the campaign. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * (Optional) Option for a vehicle to send diagnostic trouble codes to AWS IoT FleetWise .
         * <p>
         * If you want to send diagnostic trouble codes, use <code>SEND_ACTIVE_DTCS</code> . If it's not specified, <code>OFF</code> is used.
         * <p>
         * Default: <code>OFF</code>
         * <p>
         * Default: - "OFF"
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-diagnosticsmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-diagnosticsmode</a>
         * @param diagnosticsMode (Optional) Option for a vehicle to send diagnostic trouble codes to AWS IoT FleetWise . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder diagnosticsMode(final java.lang.String diagnosticsMode) {
            this.props.diagnosticsMode(diagnosticsMode);
            return this;
        }

        /**
         * (Optional) The time the campaign expires, in seconds since epoch (January 1, 1970 at midnight UTC time).
         * <p>
         * Vehicle data isn't collected after the campaign expires.
         * <p>
         * Default: 253402214400 (December 31, 9999, 00:00:00 UTC)
         * <p>
         * Default: - "253402214400"
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-expirytime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-expirytime</a>
         * @param expiryTime (Optional) The time the campaign expires, in seconds since epoch (January 1, 1970 at midnight UTC time). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder expiryTime(final java.lang.String expiryTime) {
            this.props.expiryTime(expiryTime);
            return this;
        }

        /**
         * (Optional) How long (in milliseconds) to collect raw data after a triggering event initiates the collection.
         * <p>
         * If it's not specified, <code>0</code> is used.
         * <p>
         * Default: <code>0</code>
         * <p>
         * Default: - 0
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-posttriggercollectionduration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-posttriggercollectionduration</a>
         * @param postTriggerCollectionDuration (Optional) How long (in milliseconds) to collect raw data after a triggering event initiates the collection. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder postTriggerCollectionDuration(final java.lang.Number postTriggerCollectionDuration) {
            this.props.postTriggerCollectionDuration(postTriggerCollectionDuration);
            return this;
        }

        /**
         * (Optional) A number indicating the priority of one campaign over another campaign for a certain vehicle or fleet.
         * <p>
         * A campaign with the lowest value is deployed to vehicles before any other campaigns. If it's not specified, <code>0</code> is used.
         * <p>
         * Default: <code>0</code>
         * <p>
         * Default: - 0
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-priority">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-priority</a>
         * @param priority (Optional) A number indicating the priority of one campaign over another campaign for a certain vehicle or fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder priority(final java.lang.Number priority) {
            this.props.priority(priority);
            return this;
        }

        /**
         * (Optional) A list of information about signals to collect.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-signalstocollect">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-signalstocollect</a>
         * @param signalsToCollect (Optional) A list of information about signals to collect. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder signalsToCollect(final software.amazon.awscdk.IResolvable signalsToCollect) {
            this.props.signalsToCollect(signalsToCollect);
            return this;
        }
        /**
         * (Optional) A list of information about signals to collect.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-signalstocollect">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-signalstocollect</a>
         * @param signalsToCollect (Optional) A list of information about signals to collect. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder signalsToCollect(final java.util.List<? extends java.lang.Object> signalsToCollect) {
            this.props.signalsToCollect(signalsToCollect);
            return this;
        }

        /**
         * (Optional) Whether to store collected data after a vehicle lost a connection with the cloud.
         * <p>
         * After a connection is re-established, the data is automatically forwarded to AWS IoT FleetWise . If you want to store collected data when a vehicle loses connection with the cloud, use <code>TO_DISK</code> . If it's not specified, <code>OFF</code> is used.
         * <p>
         * Default: <code>OFF</code>
         * <p>
         * Default: - "OFF"
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-spoolingmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-spoolingmode</a>
         * @param spoolingMode (Optional) Whether to store collected data after a vehicle lost a connection with the cloud. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spoolingMode(final java.lang.String spoolingMode) {
            this.props.spoolingMode(spoolingMode);
            return this;
        }

        /**
         * (Optional) The time, in milliseconds, to deliver a campaign after it was approved.
         * <p>
         * If it's not specified, <code>0</code> is used.
         * <p>
         * Default: <code>0</code>
         * <p>
         * Default: - "0"
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-starttime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-starttime</a>
         * @param startTime (Optional) The time, in milliseconds, to deliver a campaign after it was approved. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder startTime(final java.lang.String startTime) {
            this.props.startTime(startTime);
            return this;
        }

        /**
         * (Optional) Metadata that can be used to manage the campaign.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-tags</a>
         * @param tags (Optional) Metadata that can be used to manage the campaign. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.iotfleetwise.CfnCampaign}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.iotfleetwise.CfnCampaign build() {
            return new software.amazon.awscdk.services.iotfleetwise.CfnCampaign(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
