package software.amazon.awscdk.services.iotwireless;

/**
 * Properties for defining a <code>CfnTaskDefinition</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iotwireless.*;
 * CfnTaskDefinitionProps cfnTaskDefinitionProps = CfnTaskDefinitionProps.builder()
 *         .autoCreateTasks(false)
 *         // the properties below are optional
 *         .loRaWanUpdateGatewayTaskEntry(LoRaWANUpdateGatewayTaskEntryProperty.builder()
 *                 .currentVersion(LoRaWANGatewayVersionProperty.builder()
 *                         .model("model")
 *                         .packageVersion("packageVersion")
 *                         .station("station")
 *                         .build())
 *                 .updateVersion(LoRaWANGatewayVersionProperty.builder()
 *                         .model("model")
 *                         .packageVersion("packageVersion")
 *                         .station("station")
 *                         .build())
 *                 .build())
 *         .name("name")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .taskDefinitionType("taskDefinitionType")
 *         .update(UpdateWirelessGatewayTaskCreateProperty.builder()
 *                 .loRaWan(LoRaWANUpdateGatewayTaskCreateProperty.builder()
 *                         .currentVersion(LoRaWANGatewayVersionProperty.builder()
 *                                 .model("model")
 *                                 .packageVersion("packageVersion")
 *                                 .station("station")
 *                                 .build())
 *                         .sigKeyCrc(123)
 *                         .updateSignature("updateSignature")
 *                         .updateVersion(LoRaWANGatewayVersionProperty.builder()
 *                                 .model("model")
 *                                 .packageVersion("packageVersion")
 *                                 .station("station")
 *                                 .build())
 *                         .build())
 *                 .updateDataRole("updateDataRole")
 *                 .updateDataSource("updateDataSource")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-taskdefinition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-taskdefinition.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-22T22:42:53.212Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotwireless.CfnTaskDefinitionProps")
@software.amazon.jsii.Jsii.Proxy(CfnTaskDefinitionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnTaskDefinitionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Whether to automatically create tasks using this task definition for all gateways with the specified current version.
     * <p>
     * If <code>false</code> , the task must be created by calling <code>CreateWirelessGatewayTask</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-taskdefinition.html#cfn-iotwireless-taskdefinition-autocreatetasks">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-taskdefinition.html#cfn-iotwireless-taskdefinition-autocreatetasks</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getAutoCreateTasks();

    /**
     * LoRaWANUpdateGatewayTaskEntry object.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-taskdefinition.html#cfn-iotwireless-taskdefinition-lorawanupdategatewaytaskentry">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-taskdefinition.html#cfn-iotwireless-taskdefinition-lorawanupdategatewaytaskentry</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLoRaWanUpdateGatewayTaskEntry() {
        return null;
    }

    /**
     * The name of the new resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-taskdefinition.html#cfn-iotwireless-taskdefinition-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-taskdefinition.html#cfn-iotwireless-taskdefinition-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * The tags are an array of key-value pairs to attach to the specified resource.
     * <p>
     * Tags can have a minimum of 0 and a maximum of 50 items.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-taskdefinition.html#cfn-iotwireless-taskdefinition-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-taskdefinition.html#cfn-iotwireless-taskdefinition-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * A filter to list only the wireless gateway task definitions that use this task definition type.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-taskdefinition.html#cfn-iotwireless-taskdefinition-taskdefinitiontype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-taskdefinition.html#cfn-iotwireless-taskdefinition-taskdefinitiontype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTaskDefinitionType() {
        return null;
    }

    /**
     * Information about the gateways to update.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-taskdefinition.html#cfn-iotwireless-taskdefinition-update">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-taskdefinition.html#cfn-iotwireless-taskdefinition-update</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getUpdate() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnTaskDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnTaskDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnTaskDefinitionProps> {
        java.lang.Object autoCreateTasks;
        java.lang.Object loRaWanUpdateGatewayTaskEntry;
        java.lang.String name;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String taskDefinitionType;
        java.lang.Object update;

        /**
         * Sets the value of {@link CfnTaskDefinitionProps#getAutoCreateTasks}
         * @param autoCreateTasks Whether to automatically create tasks using this task definition for all gateways with the specified current version. This parameter is required.
         *                        If <code>false</code> , the task must be created by calling <code>CreateWirelessGatewayTask</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoCreateTasks(java.lang.Boolean autoCreateTasks) {
            this.autoCreateTasks = autoCreateTasks;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskDefinitionProps#getAutoCreateTasks}
         * @param autoCreateTasks Whether to automatically create tasks using this task definition for all gateways with the specified current version. This parameter is required.
         *                        If <code>false</code> , the task must be created by calling <code>CreateWirelessGatewayTask</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoCreateTasks(software.amazon.awscdk.IResolvable autoCreateTasks) {
            this.autoCreateTasks = autoCreateTasks;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskDefinitionProps#getLoRaWanUpdateGatewayTaskEntry}
         * @param loRaWanUpdateGatewayTaskEntry LoRaWANUpdateGatewayTaskEntry object.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loRaWanUpdateGatewayTaskEntry(software.amazon.awscdk.IResolvable loRaWanUpdateGatewayTaskEntry) {
            this.loRaWanUpdateGatewayTaskEntry = loRaWanUpdateGatewayTaskEntry;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskDefinitionProps#getLoRaWanUpdateGatewayTaskEntry}
         * @param loRaWanUpdateGatewayTaskEntry LoRaWANUpdateGatewayTaskEntry object.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loRaWanUpdateGatewayTaskEntry(software.amazon.awscdk.services.iotwireless.CfnTaskDefinition.LoRaWANUpdateGatewayTaskEntryProperty loRaWanUpdateGatewayTaskEntry) {
            this.loRaWanUpdateGatewayTaskEntry = loRaWanUpdateGatewayTaskEntry;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskDefinitionProps#getName}
         * @param name The name of the new resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskDefinitionProps#getTags}
         * @param tags The tags are an array of key-value pairs to attach to the specified resource.
         *             Tags can have a minimum of 0 and a maximum of 50 items.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskDefinitionProps#getTaskDefinitionType}
         * @param taskDefinitionType A filter to list only the wireless gateway task definitions that use this task definition type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskDefinitionType(java.lang.String taskDefinitionType) {
            this.taskDefinitionType = taskDefinitionType;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskDefinitionProps#getUpdate}
         * @param update Information about the gateways to update.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder update(software.amazon.awscdk.IResolvable update) {
            this.update = update;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskDefinitionProps#getUpdate}
         * @param update Information about the gateways to update.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder update(software.amazon.awscdk.services.iotwireless.CfnTaskDefinition.UpdateWirelessGatewayTaskCreateProperty update) {
            this.update = update;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnTaskDefinitionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnTaskDefinitionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnTaskDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnTaskDefinitionProps {
        private final java.lang.Object autoCreateTasks;
        private final java.lang.Object loRaWanUpdateGatewayTaskEntry;
        private final java.lang.String name;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String taskDefinitionType;
        private final java.lang.Object update;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.autoCreateTasks = software.amazon.jsii.Kernel.get(this, "autoCreateTasks", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.loRaWanUpdateGatewayTaskEntry = software.amazon.jsii.Kernel.get(this, "loRaWanUpdateGatewayTaskEntry", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.taskDefinitionType = software.amazon.jsii.Kernel.get(this, "taskDefinitionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.update = software.amazon.jsii.Kernel.get(this, "update", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.autoCreateTasks = java.util.Objects.requireNonNull(builder.autoCreateTasks, "autoCreateTasks is required");
            this.loRaWanUpdateGatewayTaskEntry = builder.loRaWanUpdateGatewayTaskEntry;
            this.name = builder.name;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.taskDefinitionType = builder.taskDefinitionType;
            this.update = builder.update;
        }

        @Override
        public final java.lang.Object getAutoCreateTasks() {
            return this.autoCreateTasks;
        }

        @Override
        public final java.lang.Object getLoRaWanUpdateGatewayTaskEntry() {
            return this.loRaWanUpdateGatewayTaskEntry;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getTaskDefinitionType() {
            return this.taskDefinitionType;
        }

        @Override
        public final java.lang.Object getUpdate() {
            return this.update;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("autoCreateTasks", om.valueToTree(this.getAutoCreateTasks()));
            if (this.getLoRaWanUpdateGatewayTaskEntry() != null) {
                data.set("loRaWanUpdateGatewayTaskEntry", om.valueToTree(this.getLoRaWanUpdateGatewayTaskEntry()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTaskDefinitionType() != null) {
                data.set("taskDefinitionType", om.valueToTree(this.getTaskDefinitionType()));
            }
            if (this.getUpdate() != null) {
                data.set("update", om.valueToTree(this.getUpdate()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotwireless.CfnTaskDefinitionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnTaskDefinitionProps.Jsii$Proxy that = (CfnTaskDefinitionProps.Jsii$Proxy) o;

            if (!autoCreateTasks.equals(that.autoCreateTasks)) return false;
            if (this.loRaWanUpdateGatewayTaskEntry != null ? !this.loRaWanUpdateGatewayTaskEntry.equals(that.loRaWanUpdateGatewayTaskEntry) : that.loRaWanUpdateGatewayTaskEntry != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.taskDefinitionType != null ? !this.taskDefinitionType.equals(that.taskDefinitionType) : that.taskDefinitionType != null) return false;
            return this.update != null ? this.update.equals(that.update) : that.update == null;
        }

        @Override
        public final int hashCode() {
            int result = this.autoCreateTasks.hashCode();
            result = 31 * result + (this.loRaWanUpdateGatewayTaskEntry != null ? this.loRaWanUpdateGatewayTaskEntry.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.taskDefinitionType != null ? this.taskDefinitionType.hashCode() : 0);
            result = 31 * result + (this.update != null ? this.update.hashCode() : 0);
            return result;
        }
    }
}
