package software.amazon.awscdk.services.lambda.eventsources;

/**
 * An S3 dead letter bucket destination configuration for a Lambda event source.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.lambda.eventsources.ManagedKafkaEventSource;
 * import software.amazon.awscdk.services.lambda.eventsources.S3OnFailureDestination;
 * import software.amazon.awscdk.services.s3.IBucket;
 * IBucket bucket;
 * Function myFunction;
 * // Your MSK cluster arn
 * String clusterArn = "arn:aws:kafka:us-east-1:0123456789019:cluster/SalesCluster/abcd1234-abcd-cafe-abab-9876543210ab-4";
 * // The Kafka topic you want to subscribe to
 * String topic = "some-cool-topic";
 * S3OnFailureDestination s3OnFailureDestination = new S3OnFailureDestination(bucket);
 * myFunction.addEventSource(ManagedKafkaEventSource.Builder.create()
 *         .clusterArn(clusterArn)
 *         .topic(topic)
 *         .startingPosition(StartingPosition.TRIM_HORIZON)
 *         .onFailure(s3OnFailureDestination)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-22T22:42:53.855Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda_event_sources.S3OnFailureDestination")
public class S3OnFailureDestination extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.lambda.IEventSourceDlq {

    protected S3OnFailureDestination(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected S3OnFailureDestination(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param bucket This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public S3OnFailureDestination(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket bucket) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(bucket, "bucket is required") });
    }

    /**
     * Returns a destination configuration for the DLQ.
     * <p>
     * @param _target This parameter is required.
     * @param targetHandler This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.DlqDestinationConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IEventSourceMapping _target, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction targetHandler) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.DlqDestinationConfig.class), new Object[] { java.util.Objects.requireNonNull(_target, "_target is required"), java.util.Objects.requireNonNull(targetHandler, "targetHandler is required") });
    }
}
