package software.amazon.awscdk.services.logs;

/**
 * Creates a data protection policy for CloudWatch Logs log groups.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.kinesisfirehose.alpha.*;
 * import software.amazon.awscdk.services.kinesisfirehose.destinations.alpha.*;
 * LogGroup logGroupDestination = LogGroup.Builder.create(this, "LogGroupLambdaAudit")
 *         .logGroupName("auditDestinationForCDK")
 *         .build();
 * Bucket bucket = new Bucket(this, "audit-bucket");
 * S3Bucket s3Destination = new S3Bucket(bucket);
 * DeliveryStream deliveryStream = DeliveryStream.Builder.create(this, "Delivery Stream")
 *         .destinations(List.of(s3Destination))
 *         .build();
 * DataProtectionPolicy dataProtectionPolicy = DataProtectionPolicy.Builder.create()
 *         .name("data protection policy")
 *         .description("policy description")
 *         .identifiers(List.of(DataIdentifier.DRIVERSLICENSE_US,  // managed data identifier
 *             new DataIdentifier("EmailAddress"),  // forward compatibility for new managed data identifiers
 *             new CustomDataIdentifier("EmployeeId", "EmployeeId-\\d{9}"))) // custom data identifier
 *         .logGroupAuditDestination(logGroupDestination)
 *         .s3BucketAuditDestination(bucket)
 *         .deliveryStreamNameAuditDestination(deliveryStream.getDeliveryStreamName())
 *         .build();
 * LogGroup.Builder.create(this, "LogGroupLambda")
 *         .logGroupName("cdkIntegLogGroup")
 *         .dataProtectionPolicy(dataProtectionPolicy)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-22T22:42:54.096Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.DataProtectionPolicy")
public class DataProtectionPolicy extends software.amazon.jsii.JsiiObject {

    protected DataProtectionPolicy(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DataProtectionPolicy(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public DataProtectionPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.DataProtectionPolicyProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.logs.DataProtectionPolicy}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.logs.DataProtectionPolicy> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.logs.DataProtectionPolicyProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.logs.DataProtectionPolicyProps.Builder();
        }

        /**
         * List of data protection identifiers.
         * <p>
         * Managed data identifiers must be in the following list: https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL-managed-data-identifiers.html
         * Custom data identifiers must have a valid regex defined: https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL-custom-data-identifiers.html#custom-data-identifiers-constraints
         * <p>
         * @return {@code this}
         * @param identifiers List of data protection identifiers. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identifiers(final java.util.List<? extends software.amazon.awscdk.services.logs.DataIdentifier> identifiers) {
            this.props.identifiers(identifiers);
            return this;
        }

        /**
         * Amazon Kinesis Data Firehose delivery stream to send audit findings to.
         * <p>
         * The delivery stream must already exist.
         * <p>
         * Default: - no firehose delivery stream audit destination
         * <p>
         * @return {@code this}
         * @param deliveryStreamNameAuditDestination Amazon Kinesis Data Firehose delivery stream to send audit findings to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deliveryStreamNameAuditDestination(final java.lang.String deliveryStreamNameAuditDestination) {
            this.props.deliveryStreamNameAuditDestination(deliveryStreamNameAuditDestination);
            return this;
        }

        /**
         * Description of the data protection policy.
         * <p>
         * Default: - 'cdk generated data protection policy'
         * <p>
         * @return {@code this}
         * @param description Description of the data protection policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * CloudWatch Logs log group to send audit findings to.
         * <p>
         * The log group must already exist prior to creating the data protection policy.
         * <p>
         * Default: - no CloudWatch Logs audit destination
         * <p>
         * @return {@code this}
         * @param logGroupAuditDestination CloudWatch Logs log group to send audit findings to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logGroupAuditDestination(final software.amazon.awscdk.services.logs.ILogGroup logGroupAuditDestination) {
            this.props.logGroupAuditDestination(logGroupAuditDestination);
            return this;
        }

        /**
         * Name of the data protection policy.
         * <p>
         * Default: - 'data-protection-policy-cdk'
         * <p>
         * @return {@code this}
         * @param name Name of the data protection policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * S3 bucket to send audit findings to.
         * <p>
         * The bucket must already exist.
         * <p>
         * Default: - no S3 bucket audit destination
         * <p>
         * @return {@code this}
         * @param s3BucketAuditDestination S3 bucket to send audit findings to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3BucketAuditDestination(final software.amazon.awscdk.services.s3.IBucket s3BucketAuditDestination) {
            this.props.s3BucketAuditDestination(s3BucketAuditDestination);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.logs.DataProtectionPolicy}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.logs.DataProtectionPolicy build() {
            return new software.amazon.awscdk.services.logs.DataProtectionPolicy(
                this.props.build()
            );
        }
    }
}
