package software.amazon.awscdk.services.logs.destinations;

/**
 * Options that may be provided to LambdaDestination.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.logs.destinations.*;
 * LambdaDestinationOptions lambdaDestinationOptions = LambdaDestinationOptions.builder()
 *         .addPermissions(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-22T22:42:54.125Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs_destinations.LambdaDestinationOptions")
@software.amazon.jsii.Jsii.Proxy(LambdaDestinationOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LambdaDestinationOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Whether or not to add Lambda Permissions.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAddPermissions() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LambdaDestinationOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LambdaDestinationOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LambdaDestinationOptions> {
        java.lang.Boolean addPermissions;

        /**
         * Sets the value of {@link LambdaDestinationOptions#getAddPermissions}
         * @param addPermissions Whether or not to add Lambda Permissions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder addPermissions(java.lang.Boolean addPermissions) {
            this.addPermissions = addPermissions;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LambdaDestinationOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LambdaDestinationOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LambdaDestinationOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LambdaDestinationOptions {
        private final java.lang.Boolean addPermissions;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.addPermissions = software.amazon.jsii.Kernel.get(this, "addPermissions", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.addPermissions = builder.addPermissions;
        }

        @Override
        public final java.lang.Boolean getAddPermissions() {
            return this.addPermissions;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAddPermissions() != null) {
                data.set("addPermissions", om.valueToTree(this.getAddPermissions()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs_destinations.LambdaDestinationOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LambdaDestinationOptions.Jsii$Proxy that = (LambdaDestinationOptions.Jsii$Proxy) o;

            return this.addPermissions != null ? this.addPermissions.equals(that.addPermissions) : that.addPermissions == null;
        }

        @Override
        public final int hashCode() {
            int result = this.addPermissions != null ? this.addPermissions.hashCode() : 0;
            return result;
        }
    }
}
