package software.amazon.awscdk.services.medialive;

/**
 * The multiplex object.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.medialive.*;
 * CfnMultiplex cfnMultiplex = CfnMultiplex.Builder.create(this, "MyCfnMultiplex")
 *         .availabilityZones(List.of("availabilityZones"))
 *         .multiplexSettings(MultiplexSettingsProperty.builder()
 *                 .transportStreamBitrate(123)
 *                 .transportStreamId(123)
 *                 // the properties below are optional
 *                 .maximumVideoBufferDelayMilliseconds(123)
 *                 .transportStreamReservedBitrate(123)
 *                 .build())
 *         .name("name")
 *         // the properties below are optional
 *         .destinations(List.of(MultiplexOutputDestinationProperty.builder()
 *                 .multiplexMediaConnectOutputDestinationSettings(MultiplexMediaConnectOutputDestinationSettingsProperty.builder()
 *                         .entitlementArn("entitlementArn")
 *                         .build())
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-multiplex.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-multiplex.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-22T22:42:54.400Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnMultiplex")
public class CfnMultiplex extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnMultiplex(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnMultiplex(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.medialive.CfnMultiplex.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnMultiplex(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.medialive.CfnMultiplexProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The unique arn of the multiplex.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique id of the multiplex.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The number of currently healthy pipelines.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrPipelinesRunningCount() {
        return software.amazon.jsii.Kernel.get(this, "attrPipelinesRunningCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The number of programs in the multiplex.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrProgramCount() {
        return software.amazon.jsii.Kernel.get(this, "attrProgramCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The current state of the multiplex.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrState() {
        return software.amazon.jsii.Kernel.get(this, "attrState", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A list of availability zones for the multiplex.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAvailabilityZones() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "availabilityZones", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * A list of availability zones for the multiplex.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAvailabilityZones(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "availabilityZones", java.util.Objects.requireNonNull(value, "availabilityZones is required"));
    }

    /**
     * Configuration for a multiplex event.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getMultiplexSettings() {
        return software.amazon.jsii.Kernel.get(this, "multiplexSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Configuration for a multiplex event.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMultiplexSettings(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "multiplexSettings", java.util.Objects.requireNonNull(value, "multiplexSettings is required"));
    }

    /**
     * Configuration for a multiplex event.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMultiplexSettings(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.medialive.CfnMultiplex.MultiplexSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "multiplexSettings", java.util.Objects.requireNonNull(value, "multiplexSettings is required"));
    }

    /**
     * The name of the multiplex.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the multiplex.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * A list of the multiplex output destinations.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDestinations() {
        return software.amazon.jsii.Kernel.get(this, "destinations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of the multiplex output destinations.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDestinations(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "destinations", value);
    }

    /**
     * A list of the multiplex output destinations.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDestinations(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.medialive.CfnMultiplex.MultiplexOutputDestinationProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.medialive.CfnMultiplex.MultiplexOutputDestinationProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "destinations", value);
    }

    /**
     * A collection of key-value pairs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A collection of key-value pairs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * Multiplex MediaConnect output destination settings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * MultiplexMediaConnectOutputDestinationSettingsProperty multiplexMediaConnectOutputDestinationSettingsProperty = MultiplexMediaConnectOutputDestinationSettingsProperty.builder()
     *         .entitlementArn("entitlementArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplex-multiplexmediaconnectoutputdestinationsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplex-multiplexmediaconnectoutputdestinationsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnMultiplex.MultiplexMediaConnectOutputDestinationSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(MultiplexMediaConnectOutputDestinationSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MultiplexMediaConnectOutputDestinationSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The MediaConnect entitlement ARN available as a Flow source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplex-multiplexmediaconnectoutputdestinationsettings.html#cfn-medialive-multiplex-multiplexmediaconnectoutputdestinationsettings-entitlementarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplex-multiplexmediaconnectoutputdestinationsettings.html#cfn-medialive-multiplex-multiplexmediaconnectoutputdestinationsettings-entitlementarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEntitlementArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MultiplexMediaConnectOutputDestinationSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MultiplexMediaConnectOutputDestinationSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MultiplexMediaConnectOutputDestinationSettingsProperty> {
            java.lang.String entitlementArn;

            /**
             * Sets the value of {@link MultiplexMediaConnectOutputDestinationSettingsProperty#getEntitlementArn}
             * @param entitlementArn The MediaConnect entitlement ARN available as a Flow source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder entitlementArn(java.lang.String entitlementArn) {
                this.entitlementArn = entitlementArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MultiplexMediaConnectOutputDestinationSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MultiplexMediaConnectOutputDestinationSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MultiplexMediaConnectOutputDestinationSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MultiplexMediaConnectOutputDestinationSettingsProperty {
            private final java.lang.String entitlementArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.entitlementArn = software.amazon.jsii.Kernel.get(this, "entitlementArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.entitlementArn = builder.entitlementArn;
            }

            @Override
            public final java.lang.String getEntitlementArn() {
                return this.entitlementArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEntitlementArn() != null) {
                    data.set("entitlementArn", om.valueToTree(this.getEntitlementArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnMultiplex.MultiplexMediaConnectOutputDestinationSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MultiplexMediaConnectOutputDestinationSettingsProperty.Jsii$Proxy that = (MultiplexMediaConnectOutputDestinationSettingsProperty.Jsii$Proxy) o;

                return this.entitlementArn != null ? this.entitlementArn.equals(that.entitlementArn) : that.entitlementArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.entitlementArn != null ? this.entitlementArn.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Multiplex output destination settings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * MultiplexOutputDestinationProperty multiplexOutputDestinationProperty = MultiplexOutputDestinationProperty.builder()
     *         .multiplexMediaConnectOutputDestinationSettings(MultiplexMediaConnectOutputDestinationSettingsProperty.builder()
     *                 .entitlementArn("entitlementArn")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplex-multiplexoutputdestination.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplex-multiplexoutputdestination.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnMultiplex.MultiplexOutputDestinationProperty")
    @software.amazon.jsii.Jsii.Proxy(MultiplexOutputDestinationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MultiplexOutputDestinationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Multiplex MediaConnect output destination settings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplex-multiplexoutputdestination.html#cfn-medialive-multiplex-multiplexoutputdestination-multiplexmediaconnectoutputdestinationsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplex-multiplexoutputdestination.html#cfn-medialive-multiplex-multiplexoutputdestination-multiplexmediaconnectoutputdestinationsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMultiplexMediaConnectOutputDestinationSettings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MultiplexOutputDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MultiplexOutputDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MultiplexOutputDestinationProperty> {
            java.lang.Object multiplexMediaConnectOutputDestinationSettings;

            /**
             * Sets the value of {@link MultiplexOutputDestinationProperty#getMultiplexMediaConnectOutputDestinationSettings}
             * @param multiplexMediaConnectOutputDestinationSettings Multiplex MediaConnect output destination settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder multiplexMediaConnectOutputDestinationSettings(software.amazon.awscdk.IResolvable multiplexMediaConnectOutputDestinationSettings) {
                this.multiplexMediaConnectOutputDestinationSettings = multiplexMediaConnectOutputDestinationSettings;
                return this;
            }

            /**
             * Sets the value of {@link MultiplexOutputDestinationProperty#getMultiplexMediaConnectOutputDestinationSettings}
             * @param multiplexMediaConnectOutputDestinationSettings Multiplex MediaConnect output destination settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder multiplexMediaConnectOutputDestinationSettings(software.amazon.awscdk.services.medialive.CfnMultiplex.MultiplexMediaConnectOutputDestinationSettingsProperty multiplexMediaConnectOutputDestinationSettings) {
                this.multiplexMediaConnectOutputDestinationSettings = multiplexMediaConnectOutputDestinationSettings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MultiplexOutputDestinationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MultiplexOutputDestinationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MultiplexOutputDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MultiplexOutputDestinationProperty {
            private final java.lang.Object multiplexMediaConnectOutputDestinationSettings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.multiplexMediaConnectOutputDestinationSettings = software.amazon.jsii.Kernel.get(this, "multiplexMediaConnectOutputDestinationSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.multiplexMediaConnectOutputDestinationSettings = builder.multiplexMediaConnectOutputDestinationSettings;
            }

            @Override
            public final java.lang.Object getMultiplexMediaConnectOutputDestinationSettings() {
                return this.multiplexMediaConnectOutputDestinationSettings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMultiplexMediaConnectOutputDestinationSettings() != null) {
                    data.set("multiplexMediaConnectOutputDestinationSettings", om.valueToTree(this.getMultiplexMediaConnectOutputDestinationSettings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnMultiplex.MultiplexOutputDestinationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MultiplexOutputDestinationProperty.Jsii$Proxy that = (MultiplexOutputDestinationProperty.Jsii$Proxy) o;

                return this.multiplexMediaConnectOutputDestinationSettings != null ? this.multiplexMediaConnectOutputDestinationSettings.equals(that.multiplexMediaConnectOutputDestinationSettings) : that.multiplexMediaConnectOutputDestinationSettings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.multiplexMediaConnectOutputDestinationSettings != null ? this.multiplexMediaConnectOutputDestinationSettings.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Contains configuration for a Multiplex event.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * MultiplexSettingsProperty multiplexSettingsProperty = MultiplexSettingsProperty.builder()
     *         .transportStreamBitrate(123)
     *         .transportStreamId(123)
     *         // the properties below are optional
     *         .maximumVideoBufferDelayMilliseconds(123)
     *         .transportStreamReservedBitrate(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplex-multiplexsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplex-multiplexsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnMultiplex.MultiplexSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(MultiplexSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MultiplexSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Transport stream bit rate.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplex-multiplexsettings.html#cfn-medialive-multiplex-multiplexsettings-transportstreambitrate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplex-multiplexsettings.html#cfn-medialive-multiplex-multiplexsettings-transportstreambitrate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getTransportStreamBitrate();

        /**
         * Transport stream ID.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplex-multiplexsettings.html#cfn-medialive-multiplex-multiplexsettings-transportstreamid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplex-multiplexsettings.html#cfn-medialive-multiplex-multiplexsettings-transportstreamid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getTransportStreamId();

        /**
         * Maximum video buffer delay in milliseconds.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplex-multiplexsettings.html#cfn-medialive-multiplex-multiplexsettings-maximumvideobufferdelaymilliseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplex-multiplexsettings.html#cfn-medialive-multiplex-multiplexsettings-maximumvideobufferdelaymilliseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumVideoBufferDelayMilliseconds() {
            return null;
        }

        /**
         * Transport stream reserved bit rate.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplex-multiplexsettings.html#cfn-medialive-multiplex-multiplexsettings-transportstreamreservedbitrate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplex-multiplexsettings.html#cfn-medialive-multiplex-multiplexsettings-transportstreamreservedbitrate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTransportStreamReservedBitrate() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MultiplexSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MultiplexSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MultiplexSettingsProperty> {
            java.lang.Number transportStreamBitrate;
            java.lang.Number transportStreamId;
            java.lang.Number maximumVideoBufferDelayMilliseconds;
            java.lang.Number transportStreamReservedBitrate;

            /**
             * Sets the value of {@link MultiplexSettingsProperty#getTransportStreamBitrate}
             * @param transportStreamBitrate Transport stream bit rate. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transportStreamBitrate(java.lang.Number transportStreamBitrate) {
                this.transportStreamBitrate = transportStreamBitrate;
                return this;
            }

            /**
             * Sets the value of {@link MultiplexSettingsProperty#getTransportStreamId}
             * @param transportStreamId Transport stream ID. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transportStreamId(java.lang.Number transportStreamId) {
                this.transportStreamId = transportStreamId;
                return this;
            }

            /**
             * Sets the value of {@link MultiplexSettingsProperty#getMaximumVideoBufferDelayMilliseconds}
             * @param maximumVideoBufferDelayMilliseconds Maximum video buffer delay in milliseconds.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumVideoBufferDelayMilliseconds(java.lang.Number maximumVideoBufferDelayMilliseconds) {
                this.maximumVideoBufferDelayMilliseconds = maximumVideoBufferDelayMilliseconds;
                return this;
            }

            /**
             * Sets the value of {@link MultiplexSettingsProperty#getTransportStreamReservedBitrate}
             * @param transportStreamReservedBitrate Transport stream reserved bit rate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transportStreamReservedBitrate(java.lang.Number transportStreamReservedBitrate) {
                this.transportStreamReservedBitrate = transportStreamReservedBitrate;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MultiplexSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MultiplexSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MultiplexSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MultiplexSettingsProperty {
            private final java.lang.Number transportStreamBitrate;
            private final java.lang.Number transportStreamId;
            private final java.lang.Number maximumVideoBufferDelayMilliseconds;
            private final java.lang.Number transportStreamReservedBitrate;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.transportStreamBitrate = software.amazon.jsii.Kernel.get(this, "transportStreamBitrate", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.transportStreamId = software.amazon.jsii.Kernel.get(this, "transportStreamId", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maximumVideoBufferDelayMilliseconds = software.amazon.jsii.Kernel.get(this, "maximumVideoBufferDelayMilliseconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.transportStreamReservedBitrate = software.amazon.jsii.Kernel.get(this, "transportStreamReservedBitrate", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.transportStreamBitrate = java.util.Objects.requireNonNull(builder.transportStreamBitrate, "transportStreamBitrate is required");
                this.transportStreamId = java.util.Objects.requireNonNull(builder.transportStreamId, "transportStreamId is required");
                this.maximumVideoBufferDelayMilliseconds = builder.maximumVideoBufferDelayMilliseconds;
                this.transportStreamReservedBitrate = builder.transportStreamReservedBitrate;
            }

            @Override
            public final java.lang.Number getTransportStreamBitrate() {
                return this.transportStreamBitrate;
            }

            @Override
            public final java.lang.Number getTransportStreamId() {
                return this.transportStreamId;
            }

            @Override
            public final java.lang.Number getMaximumVideoBufferDelayMilliseconds() {
                return this.maximumVideoBufferDelayMilliseconds;
            }

            @Override
            public final java.lang.Number getTransportStreamReservedBitrate() {
                return this.transportStreamReservedBitrate;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("transportStreamBitrate", om.valueToTree(this.getTransportStreamBitrate()));
                data.set("transportStreamId", om.valueToTree(this.getTransportStreamId()));
                if (this.getMaximumVideoBufferDelayMilliseconds() != null) {
                    data.set("maximumVideoBufferDelayMilliseconds", om.valueToTree(this.getMaximumVideoBufferDelayMilliseconds()));
                }
                if (this.getTransportStreamReservedBitrate() != null) {
                    data.set("transportStreamReservedBitrate", om.valueToTree(this.getTransportStreamReservedBitrate()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnMultiplex.MultiplexSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MultiplexSettingsProperty.Jsii$Proxy that = (MultiplexSettingsProperty.Jsii$Proxy) o;

                if (!transportStreamBitrate.equals(that.transportStreamBitrate)) return false;
                if (!transportStreamId.equals(that.transportStreamId)) return false;
                if (this.maximumVideoBufferDelayMilliseconds != null ? !this.maximumVideoBufferDelayMilliseconds.equals(that.maximumVideoBufferDelayMilliseconds) : that.maximumVideoBufferDelayMilliseconds != null) return false;
                return this.transportStreamReservedBitrate != null ? this.transportStreamReservedBitrate.equals(that.transportStreamReservedBitrate) : that.transportStreamReservedBitrate == null;
            }

            @Override
            public final int hashCode() {
                int result = this.transportStreamBitrate.hashCode();
                result = 31 * result + (this.transportStreamId.hashCode());
                result = 31 * result + (this.maximumVideoBufferDelayMilliseconds != null ? this.maximumVideoBufferDelayMilliseconds.hashCode() : 0);
                result = 31 * result + (this.transportStreamReservedBitrate != null ? this.transportStreamReservedBitrate.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.medialive.CfnMultiplex}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.medialive.CfnMultiplex> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.medialive.CfnMultiplexProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.medialive.CfnMultiplexProps.Builder();
        }

        /**
         * A list of availability zones for the multiplex.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-multiplex.html#cfn-medialive-multiplex-availabilityzones">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-multiplex.html#cfn-medialive-multiplex-availabilityzones</a>
         * @param availabilityZones A list of availability zones for the multiplex. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZones(final java.util.List<java.lang.String> availabilityZones) {
            this.props.availabilityZones(availabilityZones);
            return this;
        }

        /**
         * Configuration for a multiplex event.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-multiplex.html#cfn-medialive-multiplex-multiplexsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-multiplex.html#cfn-medialive-multiplex-multiplexsettings</a>
         * @param multiplexSettings Configuration for a multiplex event. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multiplexSettings(final software.amazon.awscdk.IResolvable multiplexSettings) {
            this.props.multiplexSettings(multiplexSettings);
            return this;
        }
        /**
         * Configuration for a multiplex event.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-multiplex.html#cfn-medialive-multiplex-multiplexsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-multiplex.html#cfn-medialive-multiplex-multiplexsettings</a>
         * @param multiplexSettings Configuration for a multiplex event. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multiplexSettings(final software.amazon.awscdk.services.medialive.CfnMultiplex.MultiplexSettingsProperty multiplexSettings) {
            this.props.multiplexSettings(multiplexSettings);
            return this;
        }

        /**
         * The name of the multiplex.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-multiplex.html#cfn-medialive-multiplex-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-multiplex.html#cfn-medialive-multiplex-name</a>
         * @param name The name of the multiplex. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * A list of the multiplex output destinations.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-multiplex.html#cfn-medialive-multiplex-destinations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-multiplex.html#cfn-medialive-multiplex-destinations</a>
         * @param destinations A list of the multiplex output destinations. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinations(final software.amazon.awscdk.IResolvable destinations) {
            this.props.destinations(destinations);
            return this;
        }
        /**
         * A list of the multiplex output destinations.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-multiplex.html#cfn-medialive-multiplex-destinations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-multiplex.html#cfn-medialive-multiplex-destinations</a>
         * @param destinations A list of the multiplex output destinations. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinations(final java.util.List<? extends java.lang.Object> destinations) {
            this.props.destinations(destinations);
            return this;
        }

        /**
         * A collection of key-value pairs.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-multiplex.html#cfn-medialive-multiplex-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-multiplex.html#cfn-medialive-multiplex-tags</a>
         * @param tags A collection of key-value pairs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.medialive.CfnMultiplex}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.medialive.CfnMultiplex build() {
            return new software.amazon.awscdk.services.medialive.CfnMultiplex(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
