package software.amazon.awscdk.services.quicksight;

/**
 * Creates an analysis in Amazon QuickSight.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-22T22:42:55.196Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis")
public class CfnAnalysis extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnAnalysis(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnAnalysis(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.quicksight.CfnAnalysis.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnAnalysis(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.quicksight.CfnAnalysisProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the analysis.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The time that the analysis was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedTime() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARNs of the datasets of the analysis.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAttrDataSetArns() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "attrDataSetArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrErrors() {
        return software.amazon.jsii.Kernel.get(this, "attrErrors", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The time that the analysis was last updated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLastUpdatedTime() {
        return software.amazon.jsii.Kernel.get(this, "attrLastUpdatedTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrSheets() {
        return software.amazon.jsii.Kernel.get(this, "attrSheets", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The ID for the analysis that you're creating.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAnalysisId() {
        return software.amazon.jsii.Kernel.get(this, "analysisId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID for the analysis that you're creating.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAnalysisId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "analysisId", java.util.Objects.requireNonNull(value, "analysisId is required"));
    }

    /**
     * The ID of the AWS account where you are creating an analysis.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAwsAccountId() {
        return software.amazon.jsii.Kernel.get(this, "awsAccountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the AWS account where you are creating an analysis.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAwsAccountId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "awsAccountId", java.util.Objects.requireNonNull(value, "awsAccountId is required"));
    }

    /**
     * A descriptive name for the analysis that you're creating.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A descriptive name for the analysis that you're creating.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDefinition() {
        return software.amazon.jsii.Kernel.get(this, "definition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefinition(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "definition", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefinition(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.quicksight.CfnAnalysis.AnalysisDefinitionProperty value) {
        software.amazon.jsii.Kernel.set(this, "definition", value);
    }

    /**
     * Errors associated with the analysis.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getErrors() {
        return software.amazon.jsii.Kernel.get(this, "errors", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Errors associated with the analysis.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setErrors(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "errors", value);
    }

    /**
     * Errors associated with the analysis.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setErrors(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.quicksight.CfnAnalysis.AnalysisErrorProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.quicksight.CfnAnalysis.AnalysisErrorProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "errors", value);
    }

    /**
     * The parameter names and override values that you want to use.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getParameters() {
        return software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The parameter names and override values that you want to use.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setParameters(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "parameters", value);
    }

    /**
     * The parameter names and override values that you want to use.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setParameters(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.quicksight.CfnAnalysis.ParametersProperty value) {
        software.amazon.jsii.Kernel.set(this, "parameters", value);
    }

    /**
     * A structure that describes the principals and the resource-level permissions on an analysis.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPermissions() {
        return software.amazon.jsii.Kernel.get(this, "permissions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A structure that describes the principals and the resource-level permissions on an analysis.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPermissions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "permissions", value);
    }

    /**
     * A structure that describes the principals and the resource-level permissions on an analysis.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPermissions(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.quicksight.CfnAnalysis.ResourcePermissionProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.quicksight.CfnAnalysis.ResourcePermissionProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "permissions", value);
    }

    /**
     * A list of the associated sheets with the unique identifier and name of each sheet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSheets() {
        return software.amazon.jsii.Kernel.get(this, "sheets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of the associated sheets with the unique identifier and name of each sheet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSheets(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "sheets", value);
    }

    /**
     * A list of the associated sheets with the unique identifier and name of each sheet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSheets(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.quicksight.CfnAnalysis.SheetProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.quicksight.CfnAnalysis.SheetProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "sheets", value);
    }

    /**
     * A source entity to use for the analysis that you're creating.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSourceEntity() {
        return software.amazon.jsii.Kernel.get(this, "sourceEntity", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A source entity to use for the analysis that you're creating.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceEntity(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "sourceEntity", value);
    }

    /**
     * A source entity to use for the analysis that you're creating.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceEntity(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.quicksight.CfnAnalysis.AnalysisSourceEntityProperty value) {
        software.amazon.jsii.Kernel.set(this, "sourceEntity", value);
    }

    /**
     * Status associated with the analysis.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getStatus() {
        return software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Status associated with the analysis.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStatus(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "status", value);
    }

    /**
     * Contains a map of the key-value pairs for the resource tag or tags assigned to the analysis.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Contains a map of the key-value pairs for the resource tag or tags assigned to the analysis.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }

    /**
     * The ARN for the theme to apply to the analysis that you're creating.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getThemeArn() {
        return software.amazon.jsii.Kernel.get(this, "themeArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN for the theme to apply to the analysis that you're creating.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setThemeArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "themeArn", value);
    }

    /**
     * The option to relax the validation that is required to create and update analyses, dashboards, and templates with definition objects.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getValidationStrategy() {
        return software.amazon.jsii.Kernel.get(this, "validationStrategy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The option to relax the validation that is required to create and update analyses, dashboards, and templates with definition objects.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setValidationStrategy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "validationStrategy", value);
    }

    /**
     * The option to relax the validation that is required to create and update analyses, dashboards, and templates with definition objects.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setValidationStrategy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.quicksight.CfnAnalysis.ValidationStrategyProperty value) {
        software.amazon.jsii.Kernel.set(this, "validationStrategy", value);
    }
    /**
     * An aggregation function aggregates values from a dimension or measure.
     * <p>
     * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * AggregationFunctionProperty aggregationFunctionProperty = AggregationFunctionProperty.builder()
     *         .attributeAggregationFunction(AttributeAggregationFunctionProperty.builder()
     *                 .simpleAttributeAggregation("simpleAttributeAggregation")
     *                 .valueForMultipleValues("valueForMultipleValues")
     *                 .build())
     *         .categoricalAggregationFunction("categoricalAggregationFunction")
     *         .dateAggregationFunction("dateAggregationFunction")
     *         .numericalAggregationFunction(NumericalAggregationFunctionProperty.builder()
     *                 .percentileAggregation(PercentileAggregationProperty.builder()
     *                         .percentileValue(123)
     *                         .build())
     *                 .simpleNumericalAggregation("simpleNumericalAggregation")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-aggregationfunction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-aggregationfunction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.AggregationFunctionProperty")
    @software.amazon.jsii.Jsii.Proxy(AggregationFunctionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AggregationFunctionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Aggregation for attributes.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-aggregationfunction.html#cfn-quicksight-analysis-aggregationfunction-attributeaggregationfunction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-aggregationfunction.html#cfn-quicksight-analysis-aggregationfunction-attributeaggregationfunction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAttributeAggregationFunction() {
            return null;
        }

        /**
         * Aggregation for categorical values.
         * <p>
         * <ul>
         * <li><code>COUNT</code> : Aggregate by the total number of values, including duplicates.</li>
         * <li><code>DISTINCT_COUNT</code> : Aggregate by the total number of distinct values.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-aggregationfunction.html#cfn-quicksight-analysis-aggregationfunction-categoricalaggregationfunction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-aggregationfunction.html#cfn-quicksight-analysis-aggregationfunction-categoricalaggregationfunction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCategoricalAggregationFunction() {
            return null;
        }

        /**
         * Aggregation for date values.
         * <p>
         * <ul>
         * <li><code>COUNT</code> : Aggregate by the total number of values, including duplicates.</li>
         * <li><code>DISTINCT_COUNT</code> : Aggregate by the total number of distinct values.</li>
         * <li><code>MIN</code> : Select the smallest date value.</li>
         * <li><code>MAX</code> : Select the largest date value.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-aggregationfunction.html#cfn-quicksight-analysis-aggregationfunction-dateaggregationfunction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-aggregationfunction.html#cfn-quicksight-analysis-aggregationfunction-dateaggregationfunction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDateAggregationFunction() {
            return null;
        }

        /**
         * Aggregation for numerical values.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-aggregationfunction.html#cfn-quicksight-analysis-aggregationfunction-numericalaggregationfunction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-aggregationfunction.html#cfn-quicksight-analysis-aggregationfunction-numericalaggregationfunction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNumericalAggregationFunction() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AggregationFunctionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AggregationFunctionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AggregationFunctionProperty> {
            java.lang.Object attributeAggregationFunction;
            java.lang.String categoricalAggregationFunction;
            java.lang.String dateAggregationFunction;
            java.lang.Object numericalAggregationFunction;

            /**
             * Sets the value of {@link AggregationFunctionProperty#getAttributeAggregationFunction}
             * @param attributeAggregationFunction Aggregation for attributes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attributeAggregationFunction(software.amazon.awscdk.IResolvable attributeAggregationFunction) {
                this.attributeAggregationFunction = attributeAggregationFunction;
                return this;
            }

            /**
             * Sets the value of {@link AggregationFunctionProperty#getAttributeAggregationFunction}
             * @param attributeAggregationFunction Aggregation for attributes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attributeAggregationFunction(software.amazon.awscdk.services.quicksight.CfnAnalysis.AttributeAggregationFunctionProperty attributeAggregationFunction) {
                this.attributeAggregationFunction = attributeAggregationFunction;
                return this;
            }

            /**
             * Sets the value of {@link AggregationFunctionProperty#getCategoricalAggregationFunction}
             * @param categoricalAggregationFunction Aggregation for categorical values.
             *                                       <ul>
             *                                       <li><code>COUNT</code> : Aggregate by the total number of values, including duplicates.</li>
             *                                       <li><code>DISTINCT_COUNT</code> : Aggregate by the total number of distinct values.</li>
             *                                       </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder categoricalAggregationFunction(java.lang.String categoricalAggregationFunction) {
                this.categoricalAggregationFunction = categoricalAggregationFunction;
                return this;
            }

            /**
             * Sets the value of {@link AggregationFunctionProperty#getDateAggregationFunction}
             * @param dateAggregationFunction Aggregation for date values.
             *                                <ul>
             *                                <li><code>COUNT</code> : Aggregate by the total number of values, including duplicates.</li>
             *                                <li><code>DISTINCT_COUNT</code> : Aggregate by the total number of distinct values.</li>
             *                                <li><code>MIN</code> : Select the smallest date value.</li>
             *                                <li><code>MAX</code> : Select the largest date value.</li>
             *                                </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dateAggregationFunction(java.lang.String dateAggregationFunction) {
                this.dateAggregationFunction = dateAggregationFunction;
                return this;
            }

            /**
             * Sets the value of {@link AggregationFunctionProperty#getNumericalAggregationFunction}
             * @param numericalAggregationFunction Aggregation for numerical values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder numericalAggregationFunction(software.amazon.awscdk.IResolvable numericalAggregationFunction) {
                this.numericalAggregationFunction = numericalAggregationFunction;
                return this;
            }

            /**
             * Sets the value of {@link AggregationFunctionProperty#getNumericalAggregationFunction}
             * @param numericalAggregationFunction Aggregation for numerical values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder numericalAggregationFunction(software.amazon.awscdk.services.quicksight.CfnAnalysis.NumericalAggregationFunctionProperty numericalAggregationFunction) {
                this.numericalAggregationFunction = numericalAggregationFunction;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AggregationFunctionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AggregationFunctionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AggregationFunctionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AggregationFunctionProperty {
            private final java.lang.Object attributeAggregationFunction;
            private final java.lang.String categoricalAggregationFunction;
            private final java.lang.String dateAggregationFunction;
            private final java.lang.Object numericalAggregationFunction;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.attributeAggregationFunction = software.amazon.jsii.Kernel.get(this, "attributeAggregationFunction", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.categoricalAggregationFunction = software.amazon.jsii.Kernel.get(this, "categoricalAggregationFunction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dateAggregationFunction = software.amazon.jsii.Kernel.get(this, "dateAggregationFunction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.numericalAggregationFunction = software.amazon.jsii.Kernel.get(this, "numericalAggregationFunction", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.attributeAggregationFunction = builder.attributeAggregationFunction;
                this.categoricalAggregationFunction = builder.categoricalAggregationFunction;
                this.dateAggregationFunction = builder.dateAggregationFunction;
                this.numericalAggregationFunction = builder.numericalAggregationFunction;
            }

            @Override
            public final java.lang.Object getAttributeAggregationFunction() {
                return this.attributeAggregationFunction;
            }

            @Override
            public final java.lang.String getCategoricalAggregationFunction() {
                return this.categoricalAggregationFunction;
            }

            @Override
            public final java.lang.String getDateAggregationFunction() {
                return this.dateAggregationFunction;
            }

            @Override
            public final java.lang.Object getNumericalAggregationFunction() {
                return this.numericalAggregationFunction;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAttributeAggregationFunction() != null) {
                    data.set("attributeAggregationFunction", om.valueToTree(this.getAttributeAggregationFunction()));
                }
                if (this.getCategoricalAggregationFunction() != null) {
                    data.set("categoricalAggregationFunction", om.valueToTree(this.getCategoricalAggregationFunction()));
                }
                if (this.getDateAggregationFunction() != null) {
                    data.set("dateAggregationFunction", om.valueToTree(this.getDateAggregationFunction()));
                }
                if (this.getNumericalAggregationFunction() != null) {
                    data.set("numericalAggregationFunction", om.valueToTree(this.getNumericalAggregationFunction()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.AggregationFunctionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AggregationFunctionProperty.Jsii$Proxy that = (AggregationFunctionProperty.Jsii$Proxy) o;

                if (this.attributeAggregationFunction != null ? !this.attributeAggregationFunction.equals(that.attributeAggregationFunction) : that.attributeAggregationFunction != null) return false;
                if (this.categoricalAggregationFunction != null ? !this.categoricalAggregationFunction.equals(that.categoricalAggregationFunction) : that.categoricalAggregationFunction != null) return false;
                if (this.dateAggregationFunction != null ? !this.dateAggregationFunction.equals(that.dateAggregationFunction) : that.dateAggregationFunction != null) return false;
                return this.numericalAggregationFunction != null ? this.numericalAggregationFunction.equals(that.numericalAggregationFunction) : that.numericalAggregationFunction == null;
            }

            @Override
            public final int hashCode() {
                int result = this.attributeAggregationFunction != null ? this.attributeAggregationFunction.hashCode() : 0;
                result = 31 * result + (this.categoricalAggregationFunction != null ? this.categoricalAggregationFunction.hashCode() : 0);
                result = 31 * result + (this.dateAggregationFunction != null ? this.dateAggregationFunction.hashCode() : 0);
                result = 31 * result + (this.numericalAggregationFunction != null ? this.numericalAggregationFunction.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration options to sort aggregated values.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * AggregationSortConfigurationProperty aggregationSortConfigurationProperty = AggregationSortConfigurationProperty.builder()
     *         .column(ColumnIdentifierProperty.builder()
     *                 .columnName("columnName")
     *                 .dataSetIdentifier("dataSetIdentifier")
     *                 .build())
     *         .sortDirection("sortDirection")
     *         // the properties below are optional
     *         .aggregationFunction(AggregationFunctionProperty.builder()
     *                 .attributeAggregationFunction(AttributeAggregationFunctionProperty.builder()
     *                         .simpleAttributeAggregation("simpleAttributeAggregation")
     *                         .valueForMultipleValues("valueForMultipleValues")
     *                         .build())
     *                 .categoricalAggregationFunction("categoricalAggregationFunction")
     *                 .dateAggregationFunction("dateAggregationFunction")
     *                 .numericalAggregationFunction(NumericalAggregationFunctionProperty.builder()
     *                         .percentileAggregation(PercentileAggregationProperty.builder()
     *                                 .percentileValue(123)
     *                                 .build())
     *                         .simpleNumericalAggregation("simpleNumericalAggregation")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-aggregationsortconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-aggregationsortconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.AggregationSortConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(AggregationSortConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AggregationSortConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The column that determines the sort order of aggregated values.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-aggregationsortconfiguration.html#cfn-quicksight-analysis-aggregationsortconfiguration-column">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-aggregationsortconfiguration.html#cfn-quicksight-analysis-aggregationsortconfiguration-column</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getColumn();

        /**
         * The sort direction of values.
         * <p>
         * <ul>
         * <li><code>ASC</code> : Sort in ascending order.</li>
         * <li><code>DESC</code> : Sort in descending order.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-aggregationsortconfiguration.html#cfn-quicksight-analysis-aggregationsortconfiguration-sortdirection">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-aggregationsortconfiguration.html#cfn-quicksight-analysis-aggregationsortconfiguration-sortdirection</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSortDirection();

        /**
         * The function that aggregates the values in <code>Column</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-aggregationsortconfiguration.html#cfn-quicksight-analysis-aggregationsortconfiguration-aggregationfunction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-aggregationsortconfiguration.html#cfn-quicksight-analysis-aggregationsortconfiguration-aggregationfunction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAggregationFunction() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AggregationSortConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AggregationSortConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AggregationSortConfigurationProperty> {
            java.lang.Object column;
            java.lang.String sortDirection;
            java.lang.Object aggregationFunction;

            /**
             * Sets the value of {@link AggregationSortConfigurationProperty#getColumn}
             * @param column The column that determines the sort order of aggregated values. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder column(software.amazon.awscdk.IResolvable column) {
                this.column = column;
                return this;
            }

            /**
             * Sets the value of {@link AggregationSortConfigurationProperty#getColumn}
             * @param column The column that determines the sort order of aggregated values. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder column(software.amazon.awscdk.services.quicksight.CfnAnalysis.ColumnIdentifierProperty column) {
                this.column = column;
                return this;
            }

            /**
             * Sets the value of {@link AggregationSortConfigurationProperty#getSortDirection}
             * @param sortDirection The sort direction of values. This parameter is required.
             *                      <ul>
             *                      <li><code>ASC</code> : Sort in ascending order.</li>
             *                      <li><code>DESC</code> : Sort in descending order.</li>
             *                      </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sortDirection(java.lang.String sortDirection) {
                this.sortDirection = sortDirection;
                return this;
            }

            /**
             * Sets the value of {@link AggregationSortConfigurationProperty#getAggregationFunction}
             * @param aggregationFunction The function that aggregates the values in <code>Column</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aggregationFunction(software.amazon.awscdk.IResolvable aggregationFunction) {
                this.aggregationFunction = aggregationFunction;
                return this;
            }

            /**
             * Sets the value of {@link AggregationSortConfigurationProperty#getAggregationFunction}
             * @param aggregationFunction The function that aggregates the values in <code>Column</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aggregationFunction(software.amazon.awscdk.services.quicksight.CfnAnalysis.AggregationFunctionProperty aggregationFunction) {
                this.aggregationFunction = aggregationFunction;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AggregationSortConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AggregationSortConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AggregationSortConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AggregationSortConfigurationProperty {
            private final java.lang.Object column;
            private final java.lang.String sortDirection;
            private final java.lang.Object aggregationFunction;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.column = software.amazon.jsii.Kernel.get(this, "column", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sortDirection = software.amazon.jsii.Kernel.get(this, "sortDirection", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.aggregationFunction = software.amazon.jsii.Kernel.get(this, "aggregationFunction", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.column = java.util.Objects.requireNonNull(builder.column, "column is required");
                this.sortDirection = java.util.Objects.requireNonNull(builder.sortDirection, "sortDirection is required");
                this.aggregationFunction = builder.aggregationFunction;
            }

            @Override
            public final java.lang.Object getColumn() {
                return this.column;
            }

            @Override
            public final java.lang.String getSortDirection() {
                return this.sortDirection;
            }

            @Override
            public final java.lang.Object getAggregationFunction() {
                return this.aggregationFunction;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("column", om.valueToTree(this.getColumn()));
                data.set("sortDirection", om.valueToTree(this.getSortDirection()));
                if (this.getAggregationFunction() != null) {
                    data.set("aggregationFunction", om.valueToTree(this.getAggregationFunction()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.AggregationSortConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AggregationSortConfigurationProperty.Jsii$Proxy that = (AggregationSortConfigurationProperty.Jsii$Proxy) o;

                if (!column.equals(that.column)) return false;
                if (!sortDirection.equals(that.sortDirection)) return false;
                return this.aggregationFunction != null ? this.aggregationFunction.equals(that.aggregationFunction) : that.aggregationFunction == null;
            }

            @Override
            public final int hashCode() {
                int result = this.column.hashCode();
                result = 31 * result + (this.sortDirection.hashCode());
                result = 31 * result + (this.aggregationFunction != null ? this.aggregationFunction.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration for default analysis settings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * AnalysisDefaultsProperty analysisDefaultsProperty = AnalysisDefaultsProperty.builder()
     *         .defaultNewSheetConfiguration(DefaultNewSheetConfigurationProperty.builder()
     *                 .interactiveLayoutConfiguration(DefaultInteractiveLayoutConfigurationProperty.builder()
     *                         .freeForm(DefaultFreeFormLayoutConfigurationProperty.builder()
     *                                 .canvasSizeOptions(FreeFormLayoutCanvasSizeOptionsProperty.builder()
     *                                         .screenCanvasSizeOptions(FreeFormLayoutScreenCanvasSizeOptionsProperty.builder()
     *                                                 .optimizedViewPortWidth("optimizedViewPortWidth")
     *                                                 .build())
     *                                         .build())
     *                                 .build())
     *                         .grid(DefaultGridLayoutConfigurationProperty.builder()
     *                                 .canvasSizeOptions(GridLayoutCanvasSizeOptionsProperty.builder()
     *                                         .screenCanvasSizeOptions(GridLayoutScreenCanvasSizeOptionsProperty.builder()
     *                                                 .resizeOption("resizeOption")
     *                                                 // the properties below are optional
     *                                                 .optimizedViewPortWidth("optimizedViewPortWidth")
     *                                                 .build())
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 .paginatedLayoutConfiguration(DefaultPaginatedLayoutConfigurationProperty.builder()
     *                         .sectionBased(DefaultSectionBasedLayoutConfigurationProperty.builder()
     *                                 .canvasSizeOptions(SectionBasedLayoutCanvasSizeOptionsProperty.builder()
     *                                         .paperCanvasSizeOptions(SectionBasedLayoutPaperCanvasSizeOptionsProperty.builder()
     *                                                 .paperMargin(SpacingProperty.builder()
     *                                                         .bottom("bottom")
     *                                                         .left("left")
     *                                                         .right("right")
     *                                                         .top("top")
     *                                                         .build())
     *                                                 .paperOrientation("paperOrientation")
     *                                                 .paperSize("paperSize")
     *                                                 .build())
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 .sheetContentType("sheetContentType")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysisdefaults.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysisdefaults.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.AnalysisDefaultsProperty")
    @software.amazon.jsii.Jsii.Proxy(AnalysisDefaultsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AnalysisDefaultsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The configuration for default new sheet settings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysisdefaults.html#cfn-quicksight-analysis-analysisdefaults-defaultnewsheetconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysisdefaults.html#cfn-quicksight-analysis-analysisdefaults-defaultnewsheetconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDefaultNewSheetConfiguration();

        /**
         * @return a {@link Builder} of {@link AnalysisDefaultsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AnalysisDefaultsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AnalysisDefaultsProperty> {
            java.lang.Object defaultNewSheetConfiguration;

            /**
             * Sets the value of {@link AnalysisDefaultsProperty#getDefaultNewSheetConfiguration}
             * @param defaultNewSheetConfiguration The configuration for default new sheet settings. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultNewSheetConfiguration(software.amazon.awscdk.IResolvable defaultNewSheetConfiguration) {
                this.defaultNewSheetConfiguration = defaultNewSheetConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisDefaultsProperty#getDefaultNewSheetConfiguration}
             * @param defaultNewSheetConfiguration The configuration for default new sheet settings. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultNewSheetConfiguration(software.amazon.awscdk.services.quicksight.CfnAnalysis.DefaultNewSheetConfigurationProperty defaultNewSheetConfiguration) {
                this.defaultNewSheetConfiguration = defaultNewSheetConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AnalysisDefaultsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AnalysisDefaultsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AnalysisDefaultsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AnalysisDefaultsProperty {
            private final java.lang.Object defaultNewSheetConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.defaultNewSheetConfiguration = software.amazon.jsii.Kernel.get(this, "defaultNewSheetConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.defaultNewSheetConfiguration = java.util.Objects.requireNonNull(builder.defaultNewSheetConfiguration, "defaultNewSheetConfiguration is required");
            }

            @Override
            public final java.lang.Object getDefaultNewSheetConfiguration() {
                return this.defaultNewSheetConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("defaultNewSheetConfiguration", om.valueToTree(this.getDefaultNewSheetConfiguration()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.AnalysisDefaultsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AnalysisDefaultsProperty.Jsii$Proxy that = (AnalysisDefaultsProperty.Jsii$Proxy) o;

                return this.defaultNewSheetConfiguration.equals(that.defaultNewSheetConfiguration);
            }

            @Override
            public final int hashCode() {
                int result = this.defaultNewSheetConfiguration.hashCode();
                return result;
            }
        }
    }
    /**
     * The definition of an analysis.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysisdefinition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysisdefinition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.AnalysisDefinitionProperty")
    @software.amazon.jsii.Jsii.Proxy(AnalysisDefinitionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AnalysisDefinitionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An array of dataset identifier declarations.
         * <p>
         * This mapping allows the usage of dataset identifiers instead of dataset ARNs throughout analysis sub-structures.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysisdefinition.html#cfn-quicksight-analysis-analysisdefinition-datasetidentifierdeclarations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysisdefinition.html#cfn-quicksight-analysis-analysisdefinition-datasetidentifierdeclarations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDataSetIdentifierDeclarations();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysisdefinition.html#cfn-quicksight-analysis-analysisdefinition-analysisdefaults">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysisdefinition.html#cfn-quicksight-analysis-analysisdefinition-analysisdefaults</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAnalysisDefaults() {
            return null;
        }

        /**
         * An array of calculated field definitions for the analysis.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysisdefinition.html#cfn-quicksight-analysis-analysisdefinition-calculatedfields">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysisdefinition.html#cfn-quicksight-analysis-analysisdefinition-calculatedfields</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCalculatedFields() {
            return null;
        }

        /**
         * An array of analysis-level column configurations.
         * <p>
         * Column configurations can be used to set default formatting for a column to be used throughout an analysis.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysisdefinition.html#cfn-quicksight-analysis-analysisdefinition-columnconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysisdefinition.html#cfn-quicksight-analysis-analysisdefinition-columnconfigurations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getColumnConfigurations() {
            return null;
        }

        /**
         * Filter definitions for an analysis.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/adding-a-filter.html">Filtering Data in Amazon QuickSight</a> in the <em>Amazon QuickSight User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysisdefinition.html#cfn-quicksight-analysis-analysisdefinition-filtergroups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysisdefinition.html#cfn-quicksight-analysis-analysisdefinition-filtergroups</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFilterGroups() {
            return null;
        }

        /**
         * An array of option definitions for an analysis.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysisdefinition.html#cfn-quicksight-analysis-analysisdefinition-options">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysisdefinition.html#cfn-quicksight-analysis-analysisdefinition-options</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOptions() {
            return null;
        }

        /**
         * An array of parameter declarations for an analysis.
         * <p>
         * Parameters are named variables that can transfer a value for use by an action or an object.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/parameters-in-quicksight.html">Parameters in Amazon QuickSight</a> in the <em>Amazon QuickSight User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysisdefinition.html#cfn-quicksight-analysis-analysisdefinition-parameterdeclarations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysisdefinition.html#cfn-quicksight-analysis-analysisdefinition-parameterdeclarations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getParameterDeclarations() {
            return null;
        }

        /**
         * An array of sheet definitions for an analysis.
         * <p>
         * Each <code>SheetDefinition</code> provides detailed information about a sheet within this analysis.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysisdefinition.html#cfn-quicksight-analysis-analysisdefinition-sheets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysisdefinition.html#cfn-quicksight-analysis-analysisdefinition-sheets</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSheets() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AnalysisDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AnalysisDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AnalysisDefinitionProperty> {
            java.lang.Object dataSetIdentifierDeclarations;
            java.lang.Object analysisDefaults;
            java.lang.Object calculatedFields;
            java.lang.Object columnConfigurations;
            java.lang.Object filterGroups;
            java.lang.Object options;
            java.lang.Object parameterDeclarations;
            java.lang.Object sheets;

            /**
             * Sets the value of {@link AnalysisDefinitionProperty#getDataSetIdentifierDeclarations}
             * @param dataSetIdentifierDeclarations An array of dataset identifier declarations. This parameter is required.
             *                                      This mapping allows the usage of dataset identifiers instead of dataset ARNs throughout analysis sub-structures.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataSetIdentifierDeclarations(software.amazon.awscdk.IResolvable dataSetIdentifierDeclarations) {
                this.dataSetIdentifierDeclarations = dataSetIdentifierDeclarations;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisDefinitionProperty#getDataSetIdentifierDeclarations}
             * @param dataSetIdentifierDeclarations An array of dataset identifier declarations. This parameter is required.
             *                                      This mapping allows the usage of dataset identifiers instead of dataset ARNs throughout analysis sub-structures.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataSetIdentifierDeclarations(java.util.List<? extends java.lang.Object> dataSetIdentifierDeclarations) {
                this.dataSetIdentifierDeclarations = dataSetIdentifierDeclarations;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisDefinitionProperty#getAnalysisDefaults}
             * @param analysisDefaults the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder analysisDefaults(software.amazon.awscdk.IResolvable analysisDefaults) {
                this.analysisDefaults = analysisDefaults;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisDefinitionProperty#getAnalysisDefaults}
             * @param analysisDefaults the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder analysisDefaults(software.amazon.awscdk.services.quicksight.CfnAnalysis.AnalysisDefaultsProperty analysisDefaults) {
                this.analysisDefaults = analysisDefaults;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisDefinitionProperty#getCalculatedFields}
             * @param calculatedFields An array of calculated field definitions for the analysis.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder calculatedFields(software.amazon.awscdk.IResolvable calculatedFields) {
                this.calculatedFields = calculatedFields;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisDefinitionProperty#getCalculatedFields}
             * @param calculatedFields An array of calculated field definitions for the analysis.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder calculatedFields(java.util.List<? extends java.lang.Object> calculatedFields) {
                this.calculatedFields = calculatedFields;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisDefinitionProperty#getColumnConfigurations}
             * @param columnConfigurations An array of analysis-level column configurations.
             *                             Column configurations can be used to set default formatting for a column to be used throughout an analysis.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnConfigurations(software.amazon.awscdk.IResolvable columnConfigurations) {
                this.columnConfigurations = columnConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisDefinitionProperty#getColumnConfigurations}
             * @param columnConfigurations An array of analysis-level column configurations.
             *                             Column configurations can be used to set default formatting for a column to be used throughout an analysis.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnConfigurations(java.util.List<? extends java.lang.Object> columnConfigurations) {
                this.columnConfigurations = columnConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisDefinitionProperty#getFilterGroups}
             * @param filterGroups Filter definitions for an analysis.
             *                     For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/adding-a-filter.html">Filtering Data in Amazon QuickSight</a> in the <em>Amazon QuickSight User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filterGroups(software.amazon.awscdk.IResolvable filterGroups) {
                this.filterGroups = filterGroups;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisDefinitionProperty#getFilterGroups}
             * @param filterGroups Filter definitions for an analysis.
             *                     For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/adding-a-filter.html">Filtering Data in Amazon QuickSight</a> in the <em>Amazon QuickSight User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filterGroups(java.util.List<? extends java.lang.Object> filterGroups) {
                this.filterGroups = filterGroups;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisDefinitionProperty#getOptions}
             * @param options An array of option definitions for an analysis.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder options(software.amazon.awscdk.IResolvable options) {
                this.options = options;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisDefinitionProperty#getOptions}
             * @param options An array of option definitions for an analysis.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder options(software.amazon.awscdk.services.quicksight.CfnAnalysis.AssetOptionsProperty options) {
                this.options = options;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisDefinitionProperty#getParameterDeclarations}
             * @param parameterDeclarations An array of parameter declarations for an analysis.
             *                              Parameters are named variables that can transfer a value for use by an action or an object.
             *                              <p>
             *                              For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/parameters-in-quicksight.html">Parameters in Amazon QuickSight</a> in the <em>Amazon QuickSight User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameterDeclarations(software.amazon.awscdk.IResolvable parameterDeclarations) {
                this.parameterDeclarations = parameterDeclarations;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisDefinitionProperty#getParameterDeclarations}
             * @param parameterDeclarations An array of parameter declarations for an analysis.
             *                              Parameters are named variables that can transfer a value for use by an action or an object.
             *                              <p>
             *                              For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/parameters-in-quicksight.html">Parameters in Amazon QuickSight</a> in the <em>Amazon QuickSight User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameterDeclarations(java.util.List<? extends java.lang.Object> parameterDeclarations) {
                this.parameterDeclarations = parameterDeclarations;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisDefinitionProperty#getSheets}
             * @param sheets An array of sheet definitions for an analysis.
             *               Each <code>SheetDefinition</code> provides detailed information about a sheet within this analysis.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sheets(software.amazon.awscdk.IResolvable sheets) {
                this.sheets = sheets;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisDefinitionProperty#getSheets}
             * @param sheets An array of sheet definitions for an analysis.
             *               Each <code>SheetDefinition</code> provides detailed information about a sheet within this analysis.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sheets(java.util.List<? extends java.lang.Object> sheets) {
                this.sheets = sheets;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AnalysisDefinitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AnalysisDefinitionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AnalysisDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AnalysisDefinitionProperty {
            private final java.lang.Object dataSetIdentifierDeclarations;
            private final java.lang.Object analysisDefaults;
            private final java.lang.Object calculatedFields;
            private final java.lang.Object columnConfigurations;
            private final java.lang.Object filterGroups;
            private final java.lang.Object options;
            private final java.lang.Object parameterDeclarations;
            private final java.lang.Object sheets;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dataSetIdentifierDeclarations = software.amazon.jsii.Kernel.get(this, "dataSetIdentifierDeclarations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.analysisDefaults = software.amazon.jsii.Kernel.get(this, "analysisDefaults", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.calculatedFields = software.amazon.jsii.Kernel.get(this, "calculatedFields", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.columnConfigurations = software.amazon.jsii.Kernel.get(this, "columnConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.filterGroups = software.amazon.jsii.Kernel.get(this, "filterGroups", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.options = software.amazon.jsii.Kernel.get(this, "options", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.parameterDeclarations = software.amazon.jsii.Kernel.get(this, "parameterDeclarations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sheets = software.amazon.jsii.Kernel.get(this, "sheets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dataSetIdentifierDeclarations = java.util.Objects.requireNonNull(builder.dataSetIdentifierDeclarations, "dataSetIdentifierDeclarations is required");
                this.analysisDefaults = builder.analysisDefaults;
                this.calculatedFields = builder.calculatedFields;
                this.columnConfigurations = builder.columnConfigurations;
                this.filterGroups = builder.filterGroups;
                this.options = builder.options;
                this.parameterDeclarations = builder.parameterDeclarations;
                this.sheets = builder.sheets;
            }

            @Override
            public final java.lang.Object getDataSetIdentifierDeclarations() {
                return this.dataSetIdentifierDeclarations;
            }

            @Override
            public final java.lang.Object getAnalysisDefaults() {
                return this.analysisDefaults;
            }

            @Override
            public final java.lang.Object getCalculatedFields() {
                return this.calculatedFields;
            }

            @Override
            public final java.lang.Object getColumnConfigurations() {
                return this.columnConfigurations;
            }

            @Override
            public final java.lang.Object getFilterGroups() {
                return this.filterGroups;
            }

            @Override
            public final java.lang.Object getOptions() {
                return this.options;
            }

            @Override
            public final java.lang.Object getParameterDeclarations() {
                return this.parameterDeclarations;
            }

            @Override
            public final java.lang.Object getSheets() {
                return this.sheets;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("dataSetIdentifierDeclarations", om.valueToTree(this.getDataSetIdentifierDeclarations()));
                if (this.getAnalysisDefaults() != null) {
                    data.set("analysisDefaults", om.valueToTree(this.getAnalysisDefaults()));
                }
                if (this.getCalculatedFields() != null) {
                    data.set("calculatedFields", om.valueToTree(this.getCalculatedFields()));
                }
                if (this.getColumnConfigurations() != null) {
                    data.set("columnConfigurations", om.valueToTree(this.getColumnConfigurations()));
                }
                if (this.getFilterGroups() != null) {
                    data.set("filterGroups", om.valueToTree(this.getFilterGroups()));
                }
                if (this.getOptions() != null) {
                    data.set("options", om.valueToTree(this.getOptions()));
                }
                if (this.getParameterDeclarations() != null) {
                    data.set("parameterDeclarations", om.valueToTree(this.getParameterDeclarations()));
                }
                if (this.getSheets() != null) {
                    data.set("sheets", om.valueToTree(this.getSheets()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.AnalysisDefinitionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AnalysisDefinitionProperty.Jsii$Proxy that = (AnalysisDefinitionProperty.Jsii$Proxy) o;

                if (!dataSetIdentifierDeclarations.equals(that.dataSetIdentifierDeclarations)) return false;
                if (this.analysisDefaults != null ? !this.analysisDefaults.equals(that.analysisDefaults) : that.analysisDefaults != null) return false;
                if (this.calculatedFields != null ? !this.calculatedFields.equals(that.calculatedFields) : that.calculatedFields != null) return false;
                if (this.columnConfigurations != null ? !this.columnConfigurations.equals(that.columnConfigurations) : that.columnConfigurations != null) return false;
                if (this.filterGroups != null ? !this.filterGroups.equals(that.filterGroups) : that.filterGroups != null) return false;
                if (this.options != null ? !this.options.equals(that.options) : that.options != null) return false;
                if (this.parameterDeclarations != null ? !this.parameterDeclarations.equals(that.parameterDeclarations) : that.parameterDeclarations != null) return false;
                return this.sheets != null ? this.sheets.equals(that.sheets) : that.sheets == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dataSetIdentifierDeclarations.hashCode();
                result = 31 * result + (this.analysisDefaults != null ? this.analysisDefaults.hashCode() : 0);
                result = 31 * result + (this.calculatedFields != null ? this.calculatedFields.hashCode() : 0);
                result = 31 * result + (this.columnConfigurations != null ? this.columnConfigurations.hashCode() : 0);
                result = 31 * result + (this.filterGroups != null ? this.filterGroups.hashCode() : 0);
                result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
                result = 31 * result + (this.parameterDeclarations != null ? this.parameterDeclarations.hashCode() : 0);
                result = 31 * result + (this.sheets != null ? this.sheets.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Analysis error.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * AnalysisErrorProperty analysisErrorProperty = AnalysisErrorProperty.builder()
     *         .message("message")
     *         .type("type")
     *         .violatedEntities(List.of(EntityProperty.builder()
     *                 .path("path")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysiserror.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysiserror.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.AnalysisErrorProperty")
    @software.amazon.jsii.Jsii.Proxy(AnalysisErrorProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AnalysisErrorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The message associated with the analysis error.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysiserror.html#cfn-quicksight-analysis-analysiserror-message">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysiserror.html#cfn-quicksight-analysis-analysiserror-message</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMessage() {
            return null;
        }

        /**
         * The type of the analysis error.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysiserror.html#cfn-quicksight-analysis-analysiserror-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysiserror.html#cfn-quicksight-analysis-analysiserror-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * Lists the violated entities that caused the analysis error.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysiserror.html#cfn-quicksight-analysis-analysiserror-violatedentities">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysiserror.html#cfn-quicksight-analysis-analysiserror-violatedentities</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getViolatedEntities() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AnalysisErrorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AnalysisErrorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AnalysisErrorProperty> {
            java.lang.String message;
            java.lang.String type;
            java.lang.Object violatedEntities;

            /**
             * Sets the value of {@link AnalysisErrorProperty#getMessage}
             * @param message The message associated with the analysis error.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder message(java.lang.String message) {
                this.message = message;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisErrorProperty#getType}
             * @param type The type of the analysis error.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisErrorProperty#getViolatedEntities}
             * @param violatedEntities Lists the violated entities that caused the analysis error.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder violatedEntities(software.amazon.awscdk.IResolvable violatedEntities) {
                this.violatedEntities = violatedEntities;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisErrorProperty#getViolatedEntities}
             * @param violatedEntities Lists the violated entities that caused the analysis error.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder violatedEntities(java.util.List<? extends java.lang.Object> violatedEntities) {
                this.violatedEntities = violatedEntities;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AnalysisErrorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AnalysisErrorProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AnalysisErrorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AnalysisErrorProperty {
            private final java.lang.String message;
            private final java.lang.String type;
            private final java.lang.Object violatedEntities;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.message = software.amazon.jsii.Kernel.get(this, "message", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.violatedEntities = software.amazon.jsii.Kernel.get(this, "violatedEntities", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.message = builder.message;
                this.type = builder.type;
                this.violatedEntities = builder.violatedEntities;
            }

            @Override
            public final java.lang.String getMessage() {
                return this.message;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.Object getViolatedEntities() {
                return this.violatedEntities;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMessage() != null) {
                    data.set("message", om.valueToTree(this.getMessage()));
                }
                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }
                if (this.getViolatedEntities() != null) {
                    data.set("violatedEntities", om.valueToTree(this.getViolatedEntities()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.AnalysisErrorProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AnalysisErrorProperty.Jsii$Proxy that = (AnalysisErrorProperty.Jsii$Proxy) o;

                if (this.message != null ? !this.message.equals(that.message) : that.message != null) return false;
                if (this.type != null ? !this.type.equals(that.type) : that.type != null) return false;
                return this.violatedEntities != null ? this.violatedEntities.equals(that.violatedEntities) : that.violatedEntities == null;
            }

            @Override
            public final int hashCode() {
                int result = this.message != null ? this.message.hashCode() : 0;
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                result = 31 * result + (this.violatedEntities != null ? this.violatedEntities.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The source entity of an analysis.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * AnalysisSourceEntityProperty analysisSourceEntityProperty = AnalysisSourceEntityProperty.builder()
     *         .sourceTemplate(AnalysisSourceTemplateProperty.builder()
     *                 .arn("arn")
     *                 .dataSetReferences(List.of(DataSetReferenceProperty.builder()
     *                         .dataSetArn("dataSetArn")
     *                         .dataSetPlaceholder("dataSetPlaceholder")
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysissourceentity.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysissourceentity.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.AnalysisSourceEntityProperty")
    @software.amazon.jsii.Jsii.Proxy(AnalysisSourceEntityProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AnalysisSourceEntityProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The source template for the source entity of the analysis.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysissourceentity.html#cfn-quicksight-analysis-analysissourceentity-sourcetemplate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysissourceentity.html#cfn-quicksight-analysis-analysissourceentity-sourcetemplate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSourceTemplate() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AnalysisSourceEntityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AnalysisSourceEntityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AnalysisSourceEntityProperty> {
            java.lang.Object sourceTemplate;

            /**
             * Sets the value of {@link AnalysisSourceEntityProperty#getSourceTemplate}
             * @param sourceTemplate The source template for the source entity of the analysis.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceTemplate(software.amazon.awscdk.IResolvable sourceTemplate) {
                this.sourceTemplate = sourceTemplate;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisSourceEntityProperty#getSourceTemplate}
             * @param sourceTemplate The source template for the source entity of the analysis.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceTemplate(software.amazon.awscdk.services.quicksight.CfnAnalysis.AnalysisSourceTemplateProperty sourceTemplate) {
                this.sourceTemplate = sourceTemplate;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AnalysisSourceEntityProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AnalysisSourceEntityProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AnalysisSourceEntityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AnalysisSourceEntityProperty {
            private final java.lang.Object sourceTemplate;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.sourceTemplate = software.amazon.jsii.Kernel.get(this, "sourceTemplate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sourceTemplate = builder.sourceTemplate;
            }

            @Override
            public final java.lang.Object getSourceTemplate() {
                return this.sourceTemplate;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSourceTemplate() != null) {
                    data.set("sourceTemplate", om.valueToTree(this.getSourceTemplate()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.AnalysisSourceEntityProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AnalysisSourceEntityProperty.Jsii$Proxy that = (AnalysisSourceEntityProperty.Jsii$Proxy) o;

                return this.sourceTemplate != null ? this.sourceTemplate.equals(that.sourceTemplate) : that.sourceTemplate == null;
            }

            @Override
            public final int hashCode() {
                int result = this.sourceTemplate != null ? this.sourceTemplate.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The source template of an analysis.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * AnalysisSourceTemplateProperty analysisSourceTemplateProperty = AnalysisSourceTemplateProperty.builder()
     *         .arn("arn")
     *         .dataSetReferences(List.of(DataSetReferenceProperty.builder()
     *                 .dataSetArn("dataSetArn")
     *                 .dataSetPlaceholder("dataSetPlaceholder")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysissourcetemplate.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysissourcetemplate.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.AnalysisSourceTemplateProperty")
    @software.amazon.jsii.Jsii.Proxy(AnalysisSourceTemplateProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AnalysisSourceTemplateProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the source template of an analysis.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysissourcetemplate.html#cfn-quicksight-analysis-analysissourcetemplate-arn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysissourcetemplate.html#cfn-quicksight-analysis-analysissourcetemplate-arn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getArn();

        /**
         * The dataset references of the source template of an analysis.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysissourcetemplate.html#cfn-quicksight-analysis-analysissourcetemplate-datasetreferences">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysissourcetemplate.html#cfn-quicksight-analysis-analysissourcetemplate-datasetreferences</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDataSetReferences();

        /**
         * @return a {@link Builder} of {@link AnalysisSourceTemplateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AnalysisSourceTemplateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AnalysisSourceTemplateProperty> {
            java.lang.String arn;
            java.lang.Object dataSetReferences;

            /**
             * Sets the value of {@link AnalysisSourceTemplateProperty#getArn}
             * @param arn The Amazon Resource Name (ARN) of the source template of an analysis. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder arn(java.lang.String arn) {
                this.arn = arn;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisSourceTemplateProperty#getDataSetReferences}
             * @param dataSetReferences The dataset references of the source template of an analysis. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataSetReferences(software.amazon.awscdk.IResolvable dataSetReferences) {
                this.dataSetReferences = dataSetReferences;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisSourceTemplateProperty#getDataSetReferences}
             * @param dataSetReferences The dataset references of the source template of an analysis. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataSetReferences(java.util.List<? extends java.lang.Object> dataSetReferences) {
                this.dataSetReferences = dataSetReferences;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AnalysisSourceTemplateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AnalysisSourceTemplateProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AnalysisSourceTemplateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AnalysisSourceTemplateProperty {
            private final java.lang.String arn;
            private final java.lang.Object dataSetReferences;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.arn = software.amazon.jsii.Kernel.get(this, "arn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dataSetReferences = software.amazon.jsii.Kernel.get(this, "dataSetReferences", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.arn = java.util.Objects.requireNonNull(builder.arn, "arn is required");
                this.dataSetReferences = java.util.Objects.requireNonNull(builder.dataSetReferences, "dataSetReferences is required");
            }

            @Override
            public final java.lang.String getArn() {
                return this.arn;
            }

            @Override
            public final java.lang.Object getDataSetReferences() {
                return this.dataSetReferences;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("arn", om.valueToTree(this.getArn()));
                data.set("dataSetReferences", om.valueToTree(this.getDataSetReferences()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.AnalysisSourceTemplateProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AnalysisSourceTemplateProperty.Jsii$Proxy that = (AnalysisSourceTemplateProperty.Jsii$Proxy) o;

                if (!arn.equals(that.arn)) return false;
                return this.dataSetReferences.equals(that.dataSetReferences);
            }

            @Override
            public final int hashCode() {
                int result = this.arn.hashCode();
                result = 31 * result + (this.dataSetReferences.hashCode());
                return result;
            }
        }
    }
    /**
     * The date configuration of the filter.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * AnchorDateConfigurationProperty anchorDateConfigurationProperty = AnchorDateConfigurationProperty.builder()
     *         .anchorOption("anchorOption")
     *         .parameterName("parameterName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-anchordateconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-anchordateconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.AnchorDateConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(AnchorDateConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AnchorDateConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The options for the date configuration. Choose one of the options below:.
         * <p>
         * <ul>
         * <li><code>NOW</code></li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-anchordateconfiguration.html#cfn-quicksight-analysis-anchordateconfiguration-anchoroption">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-anchordateconfiguration.html#cfn-quicksight-analysis-anchordateconfiguration-anchoroption</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAnchorOption() {
            return null;
        }

        /**
         * The name of the parameter that is used for the anchor date configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-anchordateconfiguration.html#cfn-quicksight-analysis-anchordateconfiguration-parametername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-anchordateconfiguration.html#cfn-quicksight-analysis-anchordateconfiguration-parametername</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getParameterName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AnchorDateConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AnchorDateConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AnchorDateConfigurationProperty> {
            java.lang.String anchorOption;
            java.lang.String parameterName;

            /**
             * Sets the value of {@link AnchorDateConfigurationProperty#getAnchorOption}
             * @param anchorOption The options for the date configuration. Choose one of the options below:.
             *                     <ul>
             *                     <li><code>NOW</code></li>
             *                     </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder anchorOption(java.lang.String anchorOption) {
                this.anchorOption = anchorOption;
                return this;
            }

            /**
             * Sets the value of {@link AnchorDateConfigurationProperty#getParameterName}
             * @param parameterName The name of the parameter that is used for the anchor date configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameterName(java.lang.String parameterName) {
                this.parameterName = parameterName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AnchorDateConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AnchorDateConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AnchorDateConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AnchorDateConfigurationProperty {
            private final java.lang.String anchorOption;
            private final java.lang.String parameterName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.anchorOption = software.amazon.jsii.Kernel.get(this, "anchorOption", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.parameterName = software.amazon.jsii.Kernel.get(this, "parameterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.anchorOption = builder.anchorOption;
                this.parameterName = builder.parameterName;
            }

            @Override
            public final java.lang.String getAnchorOption() {
                return this.anchorOption;
            }

            @Override
            public final java.lang.String getParameterName() {
                return this.parameterName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAnchorOption() != null) {
                    data.set("anchorOption", om.valueToTree(this.getAnchorOption()));
                }
                if (this.getParameterName() != null) {
                    data.set("parameterName", om.valueToTree(this.getParameterName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.AnchorDateConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AnchorDateConfigurationProperty.Jsii$Proxy that = (AnchorDateConfigurationProperty.Jsii$Proxy) o;

                if (this.anchorOption != null ? !this.anchorOption.equals(that.anchorOption) : that.anchorOption != null) return false;
                return this.parameterName != null ? this.parameterName.equals(that.parameterName) : that.parameterName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.anchorOption != null ? this.anchorOption.hashCode() : 0;
                result = 31 * result + (this.parameterName != null ? this.parameterName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The arc axis configuration of a <code>GaugeChartVisual</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * ArcAxisConfigurationProperty arcAxisConfigurationProperty = ArcAxisConfigurationProperty.builder()
     *         .range(ArcAxisDisplayRangeProperty.builder()
     *                 .max(123)
     *                 .min(123)
     *                 .build())
     *         .reserveRange(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-arcaxisconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-arcaxisconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.ArcAxisConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ArcAxisConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ArcAxisConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The arc axis range of a <code>GaugeChartVisual</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-arcaxisconfiguration.html#cfn-quicksight-analysis-arcaxisconfiguration-range">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-arcaxisconfiguration.html#cfn-quicksight-analysis-arcaxisconfiguration-range</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRange() {
            return null;
        }

        /**
         * The reserved range of the arc axis.
         * <p>
         * Default: - 0
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-arcaxisconfiguration.html#cfn-quicksight-analysis-arcaxisconfiguration-reserverange">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-arcaxisconfiguration.html#cfn-quicksight-analysis-arcaxisconfiguration-reserverange</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getReserveRange() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ArcAxisConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ArcAxisConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ArcAxisConfigurationProperty> {
            java.lang.Object range;
            java.lang.Number reserveRange;

            /**
             * Sets the value of {@link ArcAxisConfigurationProperty#getRange}
             * @param range The arc axis range of a <code>GaugeChartVisual</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder range(software.amazon.awscdk.IResolvable range) {
                this.range = range;
                return this;
            }

            /**
             * Sets the value of {@link ArcAxisConfigurationProperty#getRange}
             * @param range The arc axis range of a <code>GaugeChartVisual</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder range(software.amazon.awscdk.services.quicksight.CfnAnalysis.ArcAxisDisplayRangeProperty range) {
                this.range = range;
                return this;
            }

            /**
             * Sets the value of {@link ArcAxisConfigurationProperty#getReserveRange}
             * @param reserveRange The reserved range of the arc axis.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder reserveRange(java.lang.Number reserveRange) {
                this.reserveRange = reserveRange;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ArcAxisConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ArcAxisConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ArcAxisConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ArcAxisConfigurationProperty {
            private final java.lang.Object range;
            private final java.lang.Number reserveRange;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.range = software.amazon.jsii.Kernel.get(this, "range", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.reserveRange = software.amazon.jsii.Kernel.get(this, "reserveRange", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.range = builder.range;
                this.reserveRange = builder.reserveRange;
            }

            @Override
            public final java.lang.Object getRange() {
                return this.range;
            }

            @Override
            public final java.lang.Number getReserveRange() {
                return this.reserveRange;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getRange() != null) {
                    data.set("range", om.valueToTree(this.getRange()));
                }
                if (this.getReserveRange() != null) {
                    data.set("reserveRange", om.valueToTree(this.getReserveRange()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.ArcAxisConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ArcAxisConfigurationProperty.Jsii$Proxy that = (ArcAxisConfigurationProperty.Jsii$Proxy) o;

                if (this.range != null ? !this.range.equals(that.range) : that.range != null) return false;
                return this.reserveRange != null ? this.reserveRange.equals(that.reserveRange) : that.reserveRange == null;
            }

            @Override
            public final int hashCode() {
                int result = this.range != null ? this.range.hashCode() : 0;
                result = 31 * result + (this.reserveRange != null ? this.reserveRange.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The arc axis range of a <code>GaugeChartVisual</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * ArcAxisDisplayRangeProperty arcAxisDisplayRangeProperty = ArcAxisDisplayRangeProperty.builder()
     *         .max(123)
     *         .min(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-arcaxisdisplayrange.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-arcaxisdisplayrange.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.ArcAxisDisplayRangeProperty")
    @software.amazon.jsii.Jsii.Proxy(ArcAxisDisplayRangeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ArcAxisDisplayRangeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum value of the arc axis range.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-arcaxisdisplayrange.html#cfn-quicksight-analysis-arcaxisdisplayrange-max">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-arcaxisdisplayrange.html#cfn-quicksight-analysis-arcaxisdisplayrange-max</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMax() {
            return null;
        }

        /**
         * The minimum value of the arc axis range.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-arcaxisdisplayrange.html#cfn-quicksight-analysis-arcaxisdisplayrange-min">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-arcaxisdisplayrange.html#cfn-quicksight-analysis-arcaxisdisplayrange-min</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMin() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ArcAxisDisplayRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ArcAxisDisplayRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ArcAxisDisplayRangeProperty> {
            java.lang.Number max;
            java.lang.Number min;

            /**
             * Sets the value of {@link ArcAxisDisplayRangeProperty#getMax}
             * @param max The maximum value of the arc axis range.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder max(java.lang.Number max) {
                this.max = max;
                return this;
            }

            /**
             * Sets the value of {@link ArcAxisDisplayRangeProperty#getMin}
             * @param min The minimum value of the arc axis range.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder min(java.lang.Number min) {
                this.min = min;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ArcAxisDisplayRangeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ArcAxisDisplayRangeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ArcAxisDisplayRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ArcAxisDisplayRangeProperty {
            private final java.lang.Number max;
            private final java.lang.Number min;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.max = software.amazon.jsii.Kernel.get(this, "max", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.min = software.amazon.jsii.Kernel.get(this, "min", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.max = builder.max;
                this.min = builder.min;
            }

            @Override
            public final java.lang.Number getMax() {
                return this.max;
            }

            @Override
            public final java.lang.Number getMin() {
                return this.min;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMax() != null) {
                    data.set("max", om.valueToTree(this.getMax()));
                }
                if (this.getMin() != null) {
                    data.set("min", om.valueToTree(this.getMin()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.ArcAxisDisplayRangeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ArcAxisDisplayRangeProperty.Jsii$Proxy that = (ArcAxisDisplayRangeProperty.Jsii$Proxy) o;

                if (this.max != null ? !this.max.equals(that.max) : that.max != null) return false;
                return this.min != null ? this.min.equals(that.min) : that.min == null;
            }

            @Override
            public final int hashCode() {
                int result = this.max != null ? this.max.hashCode() : 0;
                result = 31 * result + (this.min != null ? this.min.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The arc configuration of a <code>GaugeChartVisual</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * ArcConfigurationProperty arcConfigurationProperty = ArcConfigurationProperty.builder()
     *         .arcAngle(123)
     *         .arcThickness("arcThickness")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-arcconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-arcconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.ArcConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ArcConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ArcConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The option that determines the arc angle of a <code>GaugeChartVisual</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-arcconfiguration.html#cfn-quicksight-analysis-arcconfiguration-arcangle">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-arcconfiguration.html#cfn-quicksight-analysis-arcconfiguration-arcangle</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getArcAngle() {
            return null;
        }

        /**
         * The options that determine the arc thickness of a <code>GaugeChartVisual</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-arcconfiguration.html#cfn-quicksight-analysis-arcconfiguration-arcthickness">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-arcconfiguration.html#cfn-quicksight-analysis-arcconfiguration-arcthickness</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getArcThickness() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ArcConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ArcConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ArcConfigurationProperty> {
            java.lang.Number arcAngle;
            java.lang.String arcThickness;

            /**
             * Sets the value of {@link ArcConfigurationProperty#getArcAngle}
             * @param arcAngle The option that determines the arc angle of a <code>GaugeChartVisual</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder arcAngle(java.lang.Number arcAngle) {
                this.arcAngle = arcAngle;
                return this;
            }

            /**
             * Sets the value of {@link ArcConfigurationProperty#getArcThickness}
             * @param arcThickness The options that determine the arc thickness of a <code>GaugeChartVisual</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder arcThickness(java.lang.String arcThickness) {
                this.arcThickness = arcThickness;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ArcConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ArcConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ArcConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ArcConfigurationProperty {
            private final java.lang.Number arcAngle;
            private final java.lang.String arcThickness;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.arcAngle = software.amazon.jsii.Kernel.get(this, "arcAngle", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.arcThickness = software.amazon.jsii.Kernel.get(this, "arcThickness", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.arcAngle = builder.arcAngle;
                this.arcThickness = builder.arcThickness;
            }

            @Override
            public final java.lang.Number getArcAngle() {
                return this.arcAngle;
            }

            @Override
            public final java.lang.String getArcThickness() {
                return this.arcThickness;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getArcAngle() != null) {
                    data.set("arcAngle", om.valueToTree(this.getArcAngle()));
                }
                if (this.getArcThickness() != null) {
                    data.set("arcThickness", om.valueToTree(this.getArcThickness()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.ArcConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ArcConfigurationProperty.Jsii$Proxy that = (ArcConfigurationProperty.Jsii$Proxy) o;

                if (this.arcAngle != null ? !this.arcAngle.equals(that.arcAngle) : that.arcAngle != null) return false;
                return this.arcThickness != null ? this.arcThickness.equals(that.arcThickness) : that.arcThickness == null;
            }

            @Override
            public final int hashCode() {
                int result = this.arcAngle != null ? this.arcAngle.hashCode() : 0;
                result = 31 * result + (this.arcThickness != null ? this.arcThickness.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The options that determine the arc thickness of a <code>GaugeChartVisual</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * ArcOptionsProperty arcOptionsProperty = ArcOptionsProperty.builder()
     *         .arcThickness("arcThickness")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-arcoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-arcoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.ArcOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(ArcOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ArcOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The arc thickness of a <code>GaugeChartVisual</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-arcoptions.html#cfn-quicksight-analysis-arcoptions-arcthickness">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-arcoptions.html#cfn-quicksight-analysis-arcoptions-arcthickness</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getArcThickness() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ArcOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ArcOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ArcOptionsProperty> {
            java.lang.String arcThickness;

            /**
             * Sets the value of {@link ArcOptionsProperty#getArcThickness}
             * @param arcThickness The arc thickness of a <code>GaugeChartVisual</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder arcThickness(java.lang.String arcThickness) {
                this.arcThickness = arcThickness;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ArcOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ArcOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ArcOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ArcOptionsProperty {
            private final java.lang.String arcThickness;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.arcThickness = software.amazon.jsii.Kernel.get(this, "arcThickness", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.arcThickness = builder.arcThickness;
            }

            @Override
            public final java.lang.String getArcThickness() {
                return this.arcThickness;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getArcThickness() != null) {
                    data.set("arcThickness", om.valueToTree(this.getArcThickness()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.ArcOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ArcOptionsProperty.Jsii$Proxy that = (ArcOptionsProperty.Jsii$Proxy) o;

                return this.arcThickness != null ? this.arcThickness.equals(that.arcThickness) : that.arcThickness == null;
            }

            @Override
            public final int hashCode() {
                int result = this.arcThickness != null ? this.arcThickness.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * An array of analysis level configurations.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * AssetOptionsProperty assetOptionsProperty = AssetOptionsProperty.builder()
     *         .timezone("timezone")
     *         .weekStart("weekStart")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-assetoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-assetoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.AssetOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(AssetOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AssetOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Determines the timezone for the analysis.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-assetoptions.html#cfn-quicksight-analysis-assetoptions-timezone">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-assetoptions.html#cfn-quicksight-analysis-assetoptions-timezone</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTimezone() {
            return null;
        }

        /**
         * Determines the week start day for an analysis.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-assetoptions.html#cfn-quicksight-analysis-assetoptions-weekstart">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-assetoptions.html#cfn-quicksight-analysis-assetoptions-weekstart</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getWeekStart() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AssetOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AssetOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AssetOptionsProperty> {
            java.lang.String timezone;
            java.lang.String weekStart;

            /**
             * Sets the value of {@link AssetOptionsProperty#getTimezone}
             * @param timezone Determines the timezone for the analysis.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timezone(java.lang.String timezone) {
                this.timezone = timezone;
                return this;
            }

            /**
             * Sets the value of {@link AssetOptionsProperty#getWeekStart}
             * @param weekStart Determines the week start day for an analysis.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder weekStart(java.lang.String weekStart) {
                this.weekStart = weekStart;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AssetOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AssetOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AssetOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AssetOptionsProperty {
            private final java.lang.String timezone;
            private final java.lang.String weekStart;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.timezone = software.amazon.jsii.Kernel.get(this, "timezone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.weekStart = software.amazon.jsii.Kernel.get(this, "weekStart", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.timezone = builder.timezone;
                this.weekStart = builder.weekStart;
            }

            @Override
            public final java.lang.String getTimezone() {
                return this.timezone;
            }

            @Override
            public final java.lang.String getWeekStart() {
                return this.weekStart;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getTimezone() != null) {
                    data.set("timezone", om.valueToTree(this.getTimezone()));
                }
                if (this.getWeekStart() != null) {
                    data.set("weekStart", om.valueToTree(this.getWeekStart()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.AssetOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AssetOptionsProperty.Jsii$Proxy that = (AssetOptionsProperty.Jsii$Proxy) o;

                if (this.timezone != null ? !this.timezone.equals(that.timezone) : that.timezone != null) return false;
                return this.weekStart != null ? this.weekStart.equals(that.weekStart) : that.weekStart == null;
            }

            @Override
            public final int hashCode() {
                int result = this.timezone != null ? this.timezone.hashCode() : 0;
                result = 31 * result + (this.weekStart != null ? this.weekStart.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Aggregation for attributes.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * AttributeAggregationFunctionProperty attributeAggregationFunctionProperty = AttributeAggregationFunctionProperty.builder()
     *         .simpleAttributeAggregation("simpleAttributeAggregation")
     *         .valueForMultipleValues("valueForMultipleValues")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-attributeaggregationfunction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-attributeaggregationfunction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.AttributeAggregationFunctionProperty")
    @software.amazon.jsii.Jsii.Proxy(AttributeAggregationFunctionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AttributeAggregationFunctionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The built-in aggregation functions for attributes.
         * <p>
         * <ul>
         * <li><code>UNIQUE_VALUE</code> : Returns the unique value for a field, aggregated by the dimension fields.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-attributeaggregationfunction.html#cfn-quicksight-analysis-attributeaggregationfunction-simpleattributeaggregation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-attributeaggregationfunction.html#cfn-quicksight-analysis-attributeaggregationfunction-simpleattributeaggregation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSimpleAttributeAggregation() {
            return null;
        }

        /**
         * Used by the <code>UNIQUE_VALUE</code> aggregation function.
         * <p>
         * If there are multiple values for the field used by the aggregation, the value for this property will be returned instead. Defaults to '*'.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-attributeaggregationfunction.html#cfn-quicksight-analysis-attributeaggregationfunction-valueformultiplevalues">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-attributeaggregationfunction.html#cfn-quicksight-analysis-attributeaggregationfunction-valueformultiplevalues</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValueForMultipleValues() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AttributeAggregationFunctionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AttributeAggregationFunctionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AttributeAggregationFunctionProperty> {
            java.lang.String simpleAttributeAggregation;
            java.lang.String valueForMultipleValues;

            /**
             * Sets the value of {@link AttributeAggregationFunctionProperty#getSimpleAttributeAggregation}
             * @param simpleAttributeAggregation The built-in aggregation functions for attributes.
             *                                   <ul>
             *                                   <li><code>UNIQUE_VALUE</code> : Returns the unique value for a field, aggregated by the dimension fields.</li>
             *                                   </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder simpleAttributeAggregation(java.lang.String simpleAttributeAggregation) {
                this.simpleAttributeAggregation = simpleAttributeAggregation;
                return this;
            }

            /**
             * Sets the value of {@link AttributeAggregationFunctionProperty#getValueForMultipleValues}
             * @param valueForMultipleValues Used by the <code>UNIQUE_VALUE</code> aggregation function.
             *                               If there are multiple values for the field used by the aggregation, the value for this property will be returned instead. Defaults to '*'.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder valueForMultipleValues(java.lang.String valueForMultipleValues) {
                this.valueForMultipleValues = valueForMultipleValues;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AttributeAggregationFunctionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AttributeAggregationFunctionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AttributeAggregationFunctionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AttributeAggregationFunctionProperty {
            private final java.lang.String simpleAttributeAggregation;
            private final java.lang.String valueForMultipleValues;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.simpleAttributeAggregation = software.amazon.jsii.Kernel.get(this, "simpleAttributeAggregation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.valueForMultipleValues = software.amazon.jsii.Kernel.get(this, "valueForMultipleValues", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.simpleAttributeAggregation = builder.simpleAttributeAggregation;
                this.valueForMultipleValues = builder.valueForMultipleValues;
            }

            @Override
            public final java.lang.String getSimpleAttributeAggregation() {
                return this.simpleAttributeAggregation;
            }

            @Override
            public final java.lang.String getValueForMultipleValues() {
                return this.valueForMultipleValues;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSimpleAttributeAggregation() != null) {
                    data.set("simpleAttributeAggregation", om.valueToTree(this.getSimpleAttributeAggregation()));
                }
                if (this.getValueForMultipleValues() != null) {
                    data.set("valueForMultipleValues", om.valueToTree(this.getValueForMultipleValues()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.AttributeAggregationFunctionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AttributeAggregationFunctionProperty.Jsii$Proxy that = (AttributeAggregationFunctionProperty.Jsii$Proxy) o;

                if (this.simpleAttributeAggregation != null ? !this.simpleAttributeAggregation.equals(that.simpleAttributeAggregation) : that.simpleAttributeAggregation != null) return false;
                return this.valueForMultipleValues != null ? this.valueForMultipleValues.equals(that.valueForMultipleValues) : that.valueForMultipleValues == null;
            }

            @Override
            public final int hashCode() {
                int result = this.simpleAttributeAggregation != null ? this.simpleAttributeAggregation.hashCode() : 0;
                result = 31 * result + (this.valueForMultipleValues != null ? this.valueForMultipleValues.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The data options for an axis.
     * <p>
     * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * Object dataDriven;
     * AxisDataOptionsProperty axisDataOptionsProperty = AxisDataOptionsProperty.builder()
     *         .dateAxisOptions(DateAxisOptionsProperty.builder()
     *                 .missingDateVisibility("missingDateVisibility")
     *                 .build())
     *         .numericAxisOptions(NumericAxisOptionsProperty.builder()
     *                 .range(AxisDisplayRangeProperty.builder()
     *                         .dataDriven(dataDriven)
     *                         .minMax(AxisDisplayMinMaxRangeProperty.builder()
     *                                 .maximum(123)
     *                                 .minimum(123)
     *                                 .build())
     *                         .build())
     *                 .scale(AxisScaleProperty.builder()
     *                         .linear(AxisLinearScaleProperty.builder()
     *                                 .stepCount(123)
     *                                 .stepSize(123)
     *                                 .build())
     *                         .logarithmic(AxisLogarithmicScaleProperty.builder()
     *                                 .base(123)
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdataoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdataoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.AxisDataOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(AxisDataOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AxisDataOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The options for an axis with a date field.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdataoptions.html#cfn-quicksight-analysis-axisdataoptions-dateaxisoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdataoptions.html#cfn-quicksight-analysis-axisdataoptions-dateaxisoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDateAxisOptions() {
            return null;
        }

        /**
         * The options for an axis with a numeric field.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdataoptions.html#cfn-quicksight-analysis-axisdataoptions-numericaxisoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdataoptions.html#cfn-quicksight-analysis-axisdataoptions-numericaxisoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNumericAxisOptions() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AxisDataOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AxisDataOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AxisDataOptionsProperty> {
            java.lang.Object dateAxisOptions;
            java.lang.Object numericAxisOptions;

            /**
             * Sets the value of {@link AxisDataOptionsProperty#getDateAxisOptions}
             * @param dateAxisOptions The options for an axis with a date field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dateAxisOptions(software.amazon.awscdk.IResolvable dateAxisOptions) {
                this.dateAxisOptions = dateAxisOptions;
                return this;
            }

            /**
             * Sets the value of {@link AxisDataOptionsProperty#getDateAxisOptions}
             * @param dateAxisOptions The options for an axis with a date field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dateAxisOptions(software.amazon.awscdk.services.quicksight.CfnAnalysis.DateAxisOptionsProperty dateAxisOptions) {
                this.dateAxisOptions = dateAxisOptions;
                return this;
            }

            /**
             * Sets the value of {@link AxisDataOptionsProperty#getNumericAxisOptions}
             * @param numericAxisOptions The options for an axis with a numeric field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder numericAxisOptions(software.amazon.awscdk.IResolvable numericAxisOptions) {
                this.numericAxisOptions = numericAxisOptions;
                return this;
            }

            /**
             * Sets the value of {@link AxisDataOptionsProperty#getNumericAxisOptions}
             * @param numericAxisOptions The options for an axis with a numeric field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder numericAxisOptions(software.amazon.awscdk.services.quicksight.CfnAnalysis.NumericAxisOptionsProperty numericAxisOptions) {
                this.numericAxisOptions = numericAxisOptions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AxisDataOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AxisDataOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AxisDataOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AxisDataOptionsProperty {
            private final java.lang.Object dateAxisOptions;
            private final java.lang.Object numericAxisOptions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dateAxisOptions = software.amazon.jsii.Kernel.get(this, "dateAxisOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.numericAxisOptions = software.amazon.jsii.Kernel.get(this, "numericAxisOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dateAxisOptions = builder.dateAxisOptions;
                this.numericAxisOptions = builder.numericAxisOptions;
            }

            @Override
            public final java.lang.Object getDateAxisOptions() {
                return this.dateAxisOptions;
            }

            @Override
            public final java.lang.Object getNumericAxisOptions() {
                return this.numericAxisOptions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDateAxisOptions() != null) {
                    data.set("dateAxisOptions", om.valueToTree(this.getDateAxisOptions()));
                }
                if (this.getNumericAxisOptions() != null) {
                    data.set("numericAxisOptions", om.valueToTree(this.getNumericAxisOptions()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.AxisDataOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AxisDataOptionsProperty.Jsii$Proxy that = (AxisDataOptionsProperty.Jsii$Proxy) o;

                if (this.dateAxisOptions != null ? !this.dateAxisOptions.equals(that.dateAxisOptions) : that.dateAxisOptions != null) return false;
                return this.numericAxisOptions != null ? this.numericAxisOptions.equals(that.numericAxisOptions) : that.numericAxisOptions == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dateAxisOptions != null ? this.dateAxisOptions.hashCode() : 0;
                result = 31 * result + (this.numericAxisOptions != null ? this.numericAxisOptions.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The minimum and maximum setup for an axis display range.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * AxisDisplayMinMaxRangeProperty axisDisplayMinMaxRangeProperty = AxisDisplayMinMaxRangeProperty.builder()
     *         .maximum(123)
     *         .minimum(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdisplayminmaxrange.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdisplayminmaxrange.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.AxisDisplayMinMaxRangeProperty")
    @software.amazon.jsii.Jsii.Proxy(AxisDisplayMinMaxRangeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AxisDisplayMinMaxRangeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum setup for an axis display range.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdisplayminmaxrange.html#cfn-quicksight-analysis-axisdisplayminmaxrange-maximum">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdisplayminmaxrange.html#cfn-quicksight-analysis-axisdisplayminmaxrange-maximum</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaximum() {
            return null;
        }

        /**
         * The minimum setup for an axis display range.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdisplayminmaxrange.html#cfn-quicksight-analysis-axisdisplayminmaxrange-minimum">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdisplayminmaxrange.html#cfn-quicksight-analysis-axisdisplayminmaxrange-minimum</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMinimum() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AxisDisplayMinMaxRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AxisDisplayMinMaxRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AxisDisplayMinMaxRangeProperty> {
            java.lang.Number maximum;
            java.lang.Number minimum;

            /**
             * Sets the value of {@link AxisDisplayMinMaxRangeProperty#getMaximum}
             * @param maximum The maximum setup for an axis display range.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximum(java.lang.Number maximum) {
                this.maximum = maximum;
                return this;
            }

            /**
             * Sets the value of {@link AxisDisplayMinMaxRangeProperty#getMinimum}
             * @param minimum The minimum setup for an axis display range.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minimum(java.lang.Number minimum) {
                this.minimum = minimum;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AxisDisplayMinMaxRangeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AxisDisplayMinMaxRangeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AxisDisplayMinMaxRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AxisDisplayMinMaxRangeProperty {
            private final java.lang.Number maximum;
            private final java.lang.Number minimum;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maximum = software.amazon.jsii.Kernel.get(this, "maximum", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.minimum = software.amazon.jsii.Kernel.get(this, "minimum", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maximum = builder.maximum;
                this.minimum = builder.minimum;
            }

            @Override
            public final java.lang.Number getMaximum() {
                return this.maximum;
            }

            @Override
            public final java.lang.Number getMinimum() {
                return this.minimum;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMaximum() != null) {
                    data.set("maximum", om.valueToTree(this.getMaximum()));
                }
                if (this.getMinimum() != null) {
                    data.set("minimum", om.valueToTree(this.getMinimum()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.AxisDisplayMinMaxRangeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AxisDisplayMinMaxRangeProperty.Jsii$Proxy that = (AxisDisplayMinMaxRangeProperty.Jsii$Proxy) o;

                if (this.maximum != null ? !this.maximum.equals(that.maximum) : that.maximum != null) return false;
                return this.minimum != null ? this.minimum.equals(that.minimum) : that.minimum == null;
            }

            @Override
            public final int hashCode() {
                int result = this.maximum != null ? this.maximum.hashCode() : 0;
                result = 31 * result + (this.minimum != null ? this.minimum.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The display options for the axis label.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * Object dataDriven;
     * AxisDisplayOptionsProperty axisDisplayOptionsProperty = AxisDisplayOptionsProperty.builder()
     *         .axisLineVisibility("axisLineVisibility")
     *         .axisOffset("axisOffset")
     *         .dataOptions(AxisDataOptionsProperty.builder()
     *                 .dateAxisOptions(DateAxisOptionsProperty.builder()
     *                         .missingDateVisibility("missingDateVisibility")
     *                         .build())
     *                 .numericAxisOptions(NumericAxisOptionsProperty.builder()
     *                         .range(AxisDisplayRangeProperty.builder()
     *                                 .dataDriven(dataDriven)
     *                                 .minMax(AxisDisplayMinMaxRangeProperty.builder()
     *                                         .maximum(123)
     *                                         .minimum(123)
     *                                         .build())
     *                                 .build())
     *                         .scale(AxisScaleProperty.builder()
     *                                 .linear(AxisLinearScaleProperty.builder()
     *                                         .stepCount(123)
     *                                         .stepSize(123)
     *                                         .build())
     *                                 .logarithmic(AxisLogarithmicScaleProperty.builder()
     *                                         .base(123)
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .gridLineVisibility("gridLineVisibility")
     *         .scrollbarOptions(ScrollBarOptionsProperty.builder()
     *                 .visibility("visibility")
     *                 .visibleRange(VisibleRangeOptionsProperty.builder()
     *                         .percentRange(PercentVisibleRangeProperty.builder()
     *                                 .from(123)
     *                                 .to(123)
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .tickLabelOptions(AxisTickLabelOptionsProperty.builder()
     *                 .labelOptions(LabelOptionsProperty.builder()
     *                         .customLabel("customLabel")
     *                         .fontConfiguration(FontConfigurationProperty.builder()
     *                                 .fontColor("fontColor")
     *                                 .fontDecoration("fontDecoration")
     *                                 .fontSize(FontSizeProperty.builder()
     *                                         .relative("relative")
     *                                         .build())
     *                                 .fontStyle("fontStyle")
     *                                 .fontWeight(FontWeightProperty.builder()
     *                                         .name("name")
     *                                         .build())
     *                                 .build())
     *                         .visibility("visibility")
     *                         .build())
     *                 .rotationAngle(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdisplayoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdisplayoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.AxisDisplayOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(AxisDisplayOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AxisDisplayOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Determines whether or not the axis line is visible.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdisplayoptions.html#cfn-quicksight-analysis-axisdisplayoptions-axislinevisibility">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdisplayoptions.html#cfn-quicksight-analysis-axisdisplayoptions-axislinevisibility</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAxisLineVisibility() {
            return null;
        }

        /**
         * The offset value that determines the starting placement of the axis within a visual's bounds.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdisplayoptions.html#cfn-quicksight-analysis-axisdisplayoptions-axisoffset">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdisplayoptions.html#cfn-quicksight-analysis-axisdisplayoptions-axisoffset</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAxisOffset() {
            return null;
        }

        /**
         * The data options for an axis.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdisplayoptions.html#cfn-quicksight-analysis-axisdisplayoptions-dataoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdisplayoptions.html#cfn-quicksight-analysis-axisdisplayoptions-dataoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDataOptions() {
            return null;
        }

        /**
         * Determines whether or not the grid line is visible.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdisplayoptions.html#cfn-quicksight-analysis-axisdisplayoptions-gridlinevisibility">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdisplayoptions.html#cfn-quicksight-analysis-axisdisplayoptions-gridlinevisibility</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getGridLineVisibility() {
            return null;
        }

        /**
         * The scroll bar options for an axis.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdisplayoptions.html#cfn-quicksight-analysis-axisdisplayoptions-scrollbaroptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdisplayoptions.html#cfn-quicksight-analysis-axisdisplayoptions-scrollbaroptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getScrollbarOptions() {
            return null;
        }

        /**
         * The tick label options of an axis.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdisplayoptions.html#cfn-quicksight-analysis-axisdisplayoptions-ticklabeloptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdisplayoptions.html#cfn-quicksight-analysis-axisdisplayoptions-ticklabeloptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTickLabelOptions() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AxisDisplayOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AxisDisplayOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AxisDisplayOptionsProperty> {
            java.lang.String axisLineVisibility;
            java.lang.String axisOffset;
            java.lang.Object dataOptions;
            java.lang.String gridLineVisibility;
            java.lang.Object scrollbarOptions;
            java.lang.Object tickLabelOptions;

            /**
             * Sets the value of {@link AxisDisplayOptionsProperty#getAxisLineVisibility}
             * @param axisLineVisibility Determines whether or not the axis line is visible.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder axisLineVisibility(java.lang.String axisLineVisibility) {
                this.axisLineVisibility = axisLineVisibility;
                return this;
            }

            /**
             * Sets the value of {@link AxisDisplayOptionsProperty#getAxisOffset}
             * @param axisOffset The offset value that determines the starting placement of the axis within a visual's bounds.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder axisOffset(java.lang.String axisOffset) {
                this.axisOffset = axisOffset;
                return this;
            }

            /**
             * Sets the value of {@link AxisDisplayOptionsProperty#getDataOptions}
             * @param dataOptions The data options for an axis.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataOptions(software.amazon.awscdk.IResolvable dataOptions) {
                this.dataOptions = dataOptions;
                return this;
            }

            /**
             * Sets the value of {@link AxisDisplayOptionsProperty#getDataOptions}
             * @param dataOptions The data options for an axis.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataOptions(software.amazon.awscdk.services.quicksight.CfnAnalysis.AxisDataOptionsProperty dataOptions) {
                this.dataOptions = dataOptions;
                return this;
            }

            /**
             * Sets the value of {@link AxisDisplayOptionsProperty#getGridLineVisibility}
             * @param gridLineVisibility Determines whether or not the grid line is visible.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder gridLineVisibility(java.lang.String gridLineVisibility) {
                this.gridLineVisibility = gridLineVisibility;
                return this;
            }

            /**
             * Sets the value of {@link AxisDisplayOptionsProperty#getScrollbarOptions}
             * @param scrollbarOptions The scroll bar options for an axis.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scrollbarOptions(software.amazon.awscdk.IResolvable scrollbarOptions) {
                this.scrollbarOptions = scrollbarOptions;
                return this;
            }

            /**
             * Sets the value of {@link AxisDisplayOptionsProperty#getScrollbarOptions}
             * @param scrollbarOptions The scroll bar options for an axis.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scrollbarOptions(software.amazon.awscdk.services.quicksight.CfnAnalysis.ScrollBarOptionsProperty scrollbarOptions) {
                this.scrollbarOptions = scrollbarOptions;
                return this;
            }

            /**
             * Sets the value of {@link AxisDisplayOptionsProperty#getTickLabelOptions}
             * @param tickLabelOptions The tick label options of an axis.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tickLabelOptions(software.amazon.awscdk.IResolvable tickLabelOptions) {
                this.tickLabelOptions = tickLabelOptions;
                return this;
            }

            /**
             * Sets the value of {@link AxisDisplayOptionsProperty#getTickLabelOptions}
             * @param tickLabelOptions The tick label options of an axis.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tickLabelOptions(software.amazon.awscdk.services.quicksight.CfnAnalysis.AxisTickLabelOptionsProperty tickLabelOptions) {
                this.tickLabelOptions = tickLabelOptions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AxisDisplayOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AxisDisplayOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AxisDisplayOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AxisDisplayOptionsProperty {
            private final java.lang.String axisLineVisibility;
            private final java.lang.String axisOffset;
            private final java.lang.Object dataOptions;
            private final java.lang.String gridLineVisibility;
            private final java.lang.Object scrollbarOptions;
            private final java.lang.Object tickLabelOptions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.axisLineVisibility = software.amazon.jsii.Kernel.get(this, "axisLineVisibility", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.axisOffset = software.amazon.jsii.Kernel.get(this, "axisOffset", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dataOptions = software.amazon.jsii.Kernel.get(this, "dataOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.gridLineVisibility = software.amazon.jsii.Kernel.get(this, "gridLineVisibility", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.scrollbarOptions = software.amazon.jsii.Kernel.get(this, "scrollbarOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.tickLabelOptions = software.amazon.jsii.Kernel.get(this, "tickLabelOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.axisLineVisibility = builder.axisLineVisibility;
                this.axisOffset = builder.axisOffset;
                this.dataOptions = builder.dataOptions;
                this.gridLineVisibility = builder.gridLineVisibility;
                this.scrollbarOptions = builder.scrollbarOptions;
                this.tickLabelOptions = builder.tickLabelOptions;
            }

            @Override
            public final java.lang.String getAxisLineVisibility() {
                return this.axisLineVisibility;
            }

            @Override
            public final java.lang.String getAxisOffset() {
                return this.axisOffset;
            }

            @Override
            public final java.lang.Object getDataOptions() {
                return this.dataOptions;
            }

            @Override
            public final java.lang.String getGridLineVisibility() {
                return this.gridLineVisibility;
            }

            @Override
            public final java.lang.Object getScrollbarOptions() {
                return this.scrollbarOptions;
            }

            @Override
            public final java.lang.Object getTickLabelOptions() {
                return this.tickLabelOptions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAxisLineVisibility() != null) {
                    data.set("axisLineVisibility", om.valueToTree(this.getAxisLineVisibility()));
                }
                if (this.getAxisOffset() != null) {
                    data.set("axisOffset", om.valueToTree(this.getAxisOffset()));
                }
                if (this.getDataOptions() != null) {
                    data.set("dataOptions", om.valueToTree(this.getDataOptions()));
                }
                if (this.getGridLineVisibility() != null) {
                    data.set("gridLineVisibility", om.valueToTree(this.getGridLineVisibility()));
                }
                if (this.getScrollbarOptions() != null) {
                    data.set("scrollbarOptions", om.valueToTree(this.getScrollbarOptions()));
                }
                if (this.getTickLabelOptions() != null) {
                    data.set("tickLabelOptions", om.valueToTree(this.getTickLabelOptions()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.AxisDisplayOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AxisDisplayOptionsProperty.Jsii$Proxy that = (AxisDisplayOptionsProperty.Jsii$Proxy) o;

                if (this.axisLineVisibility != null ? !this.axisLineVisibility.equals(that.axisLineVisibility) : that.axisLineVisibility != null) return false;
                if (this.axisOffset != null ? !this.axisOffset.equals(that.axisOffset) : that.axisOffset != null) return false;
                if (this.dataOptions != null ? !this.dataOptions.equals(that.dataOptions) : that.dataOptions != null) return false;
                if (this.gridLineVisibility != null ? !this.gridLineVisibility.equals(that.gridLineVisibility) : that.gridLineVisibility != null) return false;
                if (this.scrollbarOptions != null ? !this.scrollbarOptions.equals(that.scrollbarOptions) : that.scrollbarOptions != null) return false;
                return this.tickLabelOptions != null ? this.tickLabelOptions.equals(that.tickLabelOptions) : that.tickLabelOptions == null;
            }

            @Override
            public final int hashCode() {
                int result = this.axisLineVisibility != null ? this.axisLineVisibility.hashCode() : 0;
                result = 31 * result + (this.axisOffset != null ? this.axisOffset.hashCode() : 0);
                result = 31 * result + (this.dataOptions != null ? this.dataOptions.hashCode() : 0);
                result = 31 * result + (this.gridLineVisibility != null ? this.gridLineVisibility.hashCode() : 0);
                result = 31 * result + (this.scrollbarOptions != null ? this.scrollbarOptions.hashCode() : 0);
                result = 31 * result + (this.tickLabelOptions != null ? this.tickLabelOptions.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The range setup of a numeric axis display range.
     * <p>
     * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * Object dataDriven;
     * AxisDisplayRangeProperty axisDisplayRangeProperty = AxisDisplayRangeProperty.builder()
     *         .dataDriven(dataDriven)
     *         .minMax(AxisDisplayMinMaxRangeProperty.builder()
     *                 .maximum(123)
     *                 .minimum(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdisplayrange.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdisplayrange.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.AxisDisplayRangeProperty")
    @software.amazon.jsii.Jsii.Proxy(AxisDisplayRangeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AxisDisplayRangeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The data-driven setup of an axis display range.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdisplayrange.html#cfn-quicksight-analysis-axisdisplayrange-datadriven">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdisplayrange.html#cfn-quicksight-analysis-axisdisplayrange-datadriven</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDataDriven() {
            return null;
        }

        /**
         * The minimum and maximum setup of an axis display range.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdisplayrange.html#cfn-quicksight-analysis-axisdisplayrange-minmax">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdisplayrange.html#cfn-quicksight-analysis-axisdisplayrange-minmax</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMinMax() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AxisDisplayRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AxisDisplayRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AxisDisplayRangeProperty> {
            java.lang.Object dataDriven;
            java.lang.Object minMax;

            /**
             * Sets the value of {@link AxisDisplayRangeProperty#getDataDriven}
             * @param dataDriven The data-driven setup of an axis display range.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataDriven(java.lang.Object dataDriven) {
                this.dataDriven = dataDriven;
                return this;
            }

            /**
             * Sets the value of {@link AxisDisplayRangeProperty#getMinMax}
             * @param minMax The minimum and maximum setup of an axis display range.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minMax(software.amazon.awscdk.IResolvable minMax) {
                this.minMax = minMax;
                return this;
            }

            /**
             * Sets the value of {@link AxisDisplayRangeProperty#getMinMax}
             * @param minMax The minimum and maximum setup of an axis display range.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minMax(software.amazon.awscdk.services.quicksight.CfnAnalysis.AxisDisplayMinMaxRangeProperty minMax) {
                this.minMax = minMax;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AxisDisplayRangeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AxisDisplayRangeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AxisDisplayRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AxisDisplayRangeProperty {
            private final java.lang.Object dataDriven;
            private final java.lang.Object minMax;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dataDriven = software.amazon.jsii.Kernel.get(this, "dataDriven", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.minMax = software.amazon.jsii.Kernel.get(this, "minMax", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dataDriven = builder.dataDriven;
                this.minMax = builder.minMax;
            }

            @Override
            public final java.lang.Object getDataDriven() {
                return this.dataDriven;
            }

            @Override
            public final java.lang.Object getMinMax() {
                return this.minMax;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDataDriven() != null) {
                    data.set("dataDriven", om.valueToTree(this.getDataDriven()));
                }
                if (this.getMinMax() != null) {
                    data.set("minMax", om.valueToTree(this.getMinMax()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.AxisDisplayRangeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AxisDisplayRangeProperty.Jsii$Proxy that = (AxisDisplayRangeProperty.Jsii$Proxy) o;

                if (this.dataDriven != null ? !this.dataDriven.equals(that.dataDriven) : that.dataDriven != null) return false;
                return this.minMax != null ? this.minMax.equals(that.minMax) : that.minMax == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dataDriven != null ? this.dataDriven.hashCode() : 0;
                result = 31 * result + (this.minMax != null ? this.minMax.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The label options for a chart axis.
     * <p>
     * You must specify the field that the label is targeted to.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * AxisLabelOptionsProperty axisLabelOptionsProperty = AxisLabelOptionsProperty.builder()
     *         .applyTo(AxisLabelReferenceOptionsProperty.builder()
     *                 .column(ColumnIdentifierProperty.builder()
     *                         .columnName("columnName")
     *                         .dataSetIdentifier("dataSetIdentifier")
     *                         .build())
     *                 .fieldId("fieldId")
     *                 .build())
     *         .customLabel("customLabel")
     *         .fontConfiguration(FontConfigurationProperty.builder()
     *                 .fontColor("fontColor")
     *                 .fontDecoration("fontDecoration")
     *                 .fontSize(FontSizeProperty.builder()
     *                         .relative("relative")
     *                         .build())
     *                 .fontStyle("fontStyle")
     *                 .fontWeight(FontWeightProperty.builder()
     *                         .name("name")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axislabeloptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axislabeloptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.AxisLabelOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(AxisLabelOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AxisLabelOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The options that indicate which field the label belongs to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axislabeloptions.html#cfn-quicksight-analysis-axislabeloptions-applyto">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axislabeloptions.html#cfn-quicksight-analysis-axislabeloptions-applyto</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getApplyTo() {
            return null;
        }

        /**
         * The text for the axis label.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axislabeloptions.html#cfn-quicksight-analysis-axislabeloptions-customlabel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axislabeloptions.html#cfn-quicksight-analysis-axislabeloptions-customlabel</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCustomLabel() {
            return null;
        }

        /**
         * The font configuration of the axis label.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axislabeloptions.html#cfn-quicksight-analysis-axislabeloptions-fontconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axislabeloptions.html#cfn-quicksight-analysis-axislabeloptions-fontconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFontConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AxisLabelOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AxisLabelOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AxisLabelOptionsProperty> {
            java.lang.Object applyTo;
            java.lang.String customLabel;
            java.lang.Object fontConfiguration;

            /**
             * Sets the value of {@link AxisLabelOptionsProperty#getApplyTo}
             * @param applyTo The options that indicate which field the label belongs to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder applyTo(software.amazon.awscdk.IResolvable applyTo) {
                this.applyTo = applyTo;
                return this;
            }

            /**
             * Sets the value of {@link AxisLabelOptionsProperty#getApplyTo}
             * @param applyTo The options that indicate which field the label belongs to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder applyTo(software.amazon.awscdk.services.quicksight.CfnAnalysis.AxisLabelReferenceOptionsProperty applyTo) {
                this.applyTo = applyTo;
                return this;
            }

            /**
             * Sets the value of {@link AxisLabelOptionsProperty#getCustomLabel}
             * @param customLabel The text for the axis label.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customLabel(java.lang.String customLabel) {
                this.customLabel = customLabel;
                return this;
            }

            /**
             * Sets the value of {@link AxisLabelOptionsProperty#getFontConfiguration}
             * @param fontConfiguration The font configuration of the axis label.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fontConfiguration(software.amazon.awscdk.IResolvable fontConfiguration) {
                this.fontConfiguration = fontConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link AxisLabelOptionsProperty#getFontConfiguration}
             * @param fontConfiguration The font configuration of the axis label.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fontConfiguration(software.amazon.awscdk.services.quicksight.CfnAnalysis.FontConfigurationProperty fontConfiguration) {
                this.fontConfiguration = fontConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AxisLabelOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AxisLabelOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AxisLabelOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AxisLabelOptionsProperty {
            private final java.lang.Object applyTo;
            private final java.lang.String customLabel;
            private final java.lang.Object fontConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.applyTo = software.amazon.jsii.Kernel.get(this, "applyTo", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.customLabel = software.amazon.jsii.Kernel.get(this, "customLabel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.fontConfiguration = software.amazon.jsii.Kernel.get(this, "fontConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.applyTo = builder.applyTo;
                this.customLabel = builder.customLabel;
                this.fontConfiguration = builder.fontConfiguration;
            }

            @Override
            public final java.lang.Object getApplyTo() {
                return this.applyTo;
            }

            @Override
            public final java.lang.String getCustomLabel() {
                return this.customLabel;
            }

            @Override
            public final java.lang.Object getFontConfiguration() {
                return this.fontConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getApplyTo() != null) {
                    data.set("applyTo", om.valueToTree(this.getApplyTo()));
                }
                if (this.getCustomLabel() != null) {
                    data.set("customLabel", om.valueToTree(this.getCustomLabel()));
                }
                if (this.getFontConfiguration() != null) {
                    data.set("fontConfiguration", om.valueToTree(this.getFontConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.AxisLabelOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AxisLabelOptionsProperty.Jsii$Proxy that = (AxisLabelOptionsProperty.Jsii$Proxy) o;

                if (this.applyTo != null ? !this.applyTo.equals(that.applyTo) : that.applyTo != null) return false;
                if (this.customLabel != null ? !this.customLabel.equals(that.customLabel) : that.customLabel != null) return false;
                return this.fontConfiguration != null ? this.fontConfiguration.equals(that.fontConfiguration) : that.fontConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.applyTo != null ? this.applyTo.hashCode() : 0;
                result = 31 * result + (this.customLabel != null ? this.customLabel.hashCode() : 0);
                result = 31 * result + (this.fontConfiguration != null ? this.fontConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The reference that specifies where the axis label is applied to.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * AxisLabelReferenceOptionsProperty axisLabelReferenceOptionsProperty = AxisLabelReferenceOptionsProperty.builder()
     *         .column(ColumnIdentifierProperty.builder()
     *                 .columnName("columnName")
     *                 .dataSetIdentifier("dataSetIdentifier")
     *                 .build())
     *         .fieldId("fieldId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axislabelreferenceoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axislabelreferenceoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.AxisLabelReferenceOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(AxisLabelReferenceOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AxisLabelReferenceOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The column that the axis label is targeted to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axislabelreferenceoptions.html#cfn-quicksight-analysis-axislabelreferenceoptions-column">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axislabelreferenceoptions.html#cfn-quicksight-analysis-axislabelreferenceoptions-column</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getColumn();

        /**
         * The field that the axis label is targeted to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axislabelreferenceoptions.html#cfn-quicksight-analysis-axislabelreferenceoptions-fieldid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axislabelreferenceoptions.html#cfn-quicksight-analysis-axislabelreferenceoptions-fieldid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFieldId();

        /**
         * @return a {@link Builder} of {@link AxisLabelReferenceOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AxisLabelReferenceOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AxisLabelReferenceOptionsProperty> {
            java.lang.Object column;
            java.lang.String fieldId;

            /**
             * Sets the value of {@link AxisLabelReferenceOptionsProperty#getColumn}
             * @param column The column that the axis label is targeted to. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder column(software.amazon.awscdk.IResolvable column) {
                this.column = column;
                return this;
            }

            /**
             * Sets the value of {@link AxisLabelReferenceOptionsProperty#getColumn}
             * @param column The column that the axis label is targeted to. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder column(software.amazon.awscdk.services.quicksight.CfnAnalysis.ColumnIdentifierProperty column) {
                this.column = column;
                return this;
            }

            /**
             * Sets the value of {@link AxisLabelReferenceOptionsProperty#getFieldId}
             * @param fieldId The field that the axis label is targeted to. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldId(java.lang.String fieldId) {
                this.fieldId = fieldId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AxisLabelReferenceOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AxisLabelReferenceOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AxisLabelReferenceOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AxisLabelReferenceOptionsProperty {
            private final java.lang.Object column;
            private final java.lang.String fieldId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.column = software.amazon.jsii.Kernel.get(this, "column", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.fieldId = software.amazon.jsii.Kernel.get(this, "fieldId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.column = java.util.Objects.requireNonNull(builder.column, "column is required");
                this.fieldId = java.util.Objects.requireNonNull(builder.fieldId, "fieldId is required");
            }

            @Override
            public final java.lang.Object getColumn() {
                return this.column;
            }

            @Override
            public final java.lang.String getFieldId() {
                return this.fieldId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("column", om.valueToTree(this.getColumn()));
                data.set("fieldId", om.valueToTree(this.getFieldId()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.AxisLabelReferenceOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AxisLabelReferenceOptionsProperty.Jsii$Proxy that = (AxisLabelReferenceOptionsProperty.Jsii$Proxy) o;

                if (!column.equals(that.column)) return false;
                return this.fieldId.equals(that.fieldId);
            }

            @Override
            public final int hashCode() {
                int result = this.column.hashCode();
                result = 31 * result + (this.fieldId.hashCode());
                return result;
            }
        }
    }
    /**
     * The liner axis scale setup.
     * <p>
     * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * AxisLinearScaleProperty axisLinearScaleProperty = AxisLinearScaleProperty.builder()
     *         .stepCount(123)
     *         .stepSize(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axislinearscale.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axislinearscale.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.AxisLinearScaleProperty")
    @software.amazon.jsii.Jsii.Proxy(AxisLinearScaleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AxisLinearScaleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The step count setup of a linear axis.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axislinearscale.html#cfn-quicksight-analysis-axislinearscale-stepcount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axislinearscale.html#cfn-quicksight-analysis-axislinearscale-stepcount</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getStepCount() {
            return null;
        }

        /**
         * The step size setup of a linear axis.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axislinearscale.html#cfn-quicksight-analysis-axislinearscale-stepsize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axislinearscale.html#cfn-quicksight-analysis-axislinearscale-stepsize</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getStepSize() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AxisLinearScaleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AxisLinearScaleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AxisLinearScaleProperty> {
            java.lang.Number stepCount;
            java.lang.Number stepSize;

            /**
             * Sets the value of {@link AxisLinearScaleProperty#getStepCount}
             * @param stepCount The step count setup of a linear axis.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stepCount(java.lang.Number stepCount) {
                this.stepCount = stepCount;
                return this;
            }

            /**
             * Sets the value of {@link AxisLinearScaleProperty#getStepSize}
             * @param stepSize The step size setup of a linear axis.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stepSize(java.lang.Number stepSize) {
                this.stepSize = stepSize;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AxisLinearScaleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AxisLinearScaleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AxisLinearScaleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AxisLinearScaleProperty {
            private final java.lang.Number stepCount;
            private final java.lang.Number stepSize;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.stepCount = software.amazon.jsii.Kernel.get(this, "stepCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.stepSize = software.amazon.jsii.Kernel.get(this, "stepSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.stepCount = builder.stepCount;
                this.stepSize = builder.stepSize;
            }

            @Override
            public final java.lang.Number getStepCount() {
                return this.stepCount;
            }

            @Override
            public final java.lang.Number getStepSize() {
                return this.stepSize;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getStepCount() != null) {
                    data.set("stepCount", om.valueToTree(this.getStepCount()));
                }
                if (this.getStepSize() != null) {
                    data.set("stepSize", om.valueToTree(this.getStepSize()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.AxisLinearScaleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AxisLinearScaleProperty.Jsii$Proxy that = (AxisLinearScaleProperty.Jsii$Proxy) o;

                if (this.stepCount != null ? !this.stepCount.equals(that.stepCount) : that.stepCount != null) return false;
                return this.stepSize != null ? this.stepSize.equals(that.stepSize) : that.stepSize == null;
            }

            @Override
            public final int hashCode() {
                int result = this.stepCount != null ? this.stepCount.hashCode() : 0;
                result = 31 * result + (this.stepSize != null ? this.stepSize.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The logarithmic axis scale setup.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * AxisLogarithmicScaleProperty axisLogarithmicScaleProperty = AxisLogarithmicScaleProperty.builder()
     *         .base(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axislogarithmicscale.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axislogarithmicscale.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.AxisLogarithmicScaleProperty")
    @software.amazon.jsii.Jsii.Proxy(AxisLogarithmicScaleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AxisLogarithmicScaleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The base setup of a logarithmic axis scale.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axislogarithmicscale.html#cfn-quicksight-analysis-axislogarithmicscale-base">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axislogarithmicscale.html#cfn-quicksight-analysis-axislogarithmicscale-base</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBase() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AxisLogarithmicScaleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AxisLogarithmicScaleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AxisLogarithmicScaleProperty> {
            java.lang.Number base;

            /**
             * Sets the value of {@link AxisLogarithmicScaleProperty#getBase}
             * @param base The base setup of a logarithmic axis scale.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder base(java.lang.Number base) {
                this.base = base;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AxisLogarithmicScaleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AxisLogarithmicScaleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AxisLogarithmicScaleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AxisLogarithmicScaleProperty {
            private final java.lang.Number base;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.base = software.amazon.jsii.Kernel.get(this, "base", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.base = builder.base;
            }

            @Override
            public final java.lang.Number getBase() {
                return this.base;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBase() != null) {
                    data.set("base", om.valueToTree(this.getBase()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.AxisLogarithmicScaleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AxisLogarithmicScaleProperty.Jsii$Proxy that = (AxisLogarithmicScaleProperty.Jsii$Proxy) o;

                return this.base != null ? this.base.equals(that.base) : that.base == null;
            }

            @Override
            public final int hashCode() {
                int result = this.base != null ? this.base.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The scale setup options for a numeric axis display.
     * <p>
     * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * AxisScaleProperty axisScaleProperty = AxisScaleProperty.builder()
     *         .linear(AxisLinearScaleProperty.builder()
     *                 .stepCount(123)
     *                 .stepSize(123)
     *                 .build())
     *         .logarithmic(AxisLogarithmicScaleProperty.builder()
     *                 .base(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisscale.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisscale.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.AxisScaleProperty")
    @software.amazon.jsii.Jsii.Proxy(AxisScaleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AxisScaleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The linear axis scale setup.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisscale.html#cfn-quicksight-analysis-axisscale-linear">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisscale.html#cfn-quicksight-analysis-axisscale-linear</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLinear() {
            return null;
        }

        /**
         * The logarithmic axis scale setup.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisscale.html#cfn-quicksight-analysis-axisscale-logarithmic">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisscale.html#cfn-quicksight-analysis-axisscale-logarithmic</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLogarithmic() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AxisScaleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AxisScaleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AxisScaleProperty> {
            java.lang.Object linear;
            java.lang.Object logarithmic;

            /**
             * Sets the value of {@link AxisScaleProperty#getLinear}
             * @param linear The linear axis scale setup.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder linear(software.amazon.awscdk.IResolvable linear) {
                this.linear = linear;
                return this;
            }

            /**
             * Sets the value of {@link AxisScaleProperty#getLinear}
             * @param linear The linear axis scale setup.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder linear(software.amazon.awscdk.services.quicksight.CfnAnalysis.AxisLinearScaleProperty linear) {
                this.linear = linear;
                return this;
            }

            /**
             * Sets the value of {@link AxisScaleProperty#getLogarithmic}
             * @param logarithmic The logarithmic axis scale setup.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logarithmic(software.amazon.awscdk.IResolvable logarithmic) {
                this.logarithmic = logarithmic;
                return this;
            }

            /**
             * Sets the value of {@link AxisScaleProperty#getLogarithmic}
             * @param logarithmic The logarithmic axis scale setup.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logarithmic(software.amazon.awscdk.services.quicksight.CfnAnalysis.AxisLogarithmicScaleProperty logarithmic) {
                this.logarithmic = logarithmic;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AxisScaleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AxisScaleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AxisScaleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AxisScaleProperty {
            private final java.lang.Object linear;
            private final java.lang.Object logarithmic;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.linear = software.amazon.jsii.Kernel.get(this, "linear", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.logarithmic = software.amazon.jsii.Kernel.get(this, "logarithmic", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.linear = builder.linear;
                this.logarithmic = builder.logarithmic;
            }

            @Override
            public final java.lang.Object getLinear() {
                return this.linear;
            }

            @Override
            public final java.lang.Object getLogarithmic() {
                return this.logarithmic;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getLinear() != null) {
                    data.set("linear", om.valueToTree(this.getLinear()));
                }
                if (this.getLogarithmic() != null) {
                    data.set("logarithmic", om.valueToTree(this.getLogarithmic()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.AxisScaleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AxisScaleProperty.Jsii$Proxy that = (AxisScaleProperty.Jsii$Proxy) o;

                if (this.linear != null ? !this.linear.equals(that.linear) : that.linear != null) return false;
                return this.logarithmic != null ? this.logarithmic.equals(that.logarithmic) : that.logarithmic == null;
            }

            @Override
            public final int hashCode() {
                int result = this.linear != null ? this.linear.hashCode() : 0;
                result = 31 * result + (this.logarithmic != null ? this.logarithmic.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The tick label options of an axis.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * AxisTickLabelOptionsProperty axisTickLabelOptionsProperty = AxisTickLabelOptionsProperty.builder()
     *         .labelOptions(LabelOptionsProperty.builder()
     *                 .customLabel("customLabel")
     *                 .fontConfiguration(FontConfigurationProperty.builder()
     *                         .fontColor("fontColor")
     *                         .fontDecoration("fontDecoration")
     *                         .fontSize(FontSizeProperty.builder()
     *                                 .relative("relative")
     *                                 .build())
     *                         .fontStyle("fontStyle")
     *                         .fontWeight(FontWeightProperty.builder()
     *                                 .name("name")
     *                                 .build())
     *                         .build())
     *                 .visibility("visibility")
     *                 .build())
     *         .rotationAngle(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisticklabeloptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisticklabeloptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.AxisTickLabelOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(AxisTickLabelOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AxisTickLabelOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Determines whether or not the axis ticks are visible.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisticklabeloptions.html#cfn-quicksight-analysis-axisticklabeloptions-labeloptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisticklabeloptions.html#cfn-quicksight-analysis-axisticklabeloptions-labeloptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLabelOptions() {
            return null;
        }

        /**
         * The rotation angle of the axis tick labels.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisticklabeloptions.html#cfn-quicksight-analysis-axisticklabeloptions-rotationangle">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisticklabeloptions.html#cfn-quicksight-analysis-axisticklabeloptions-rotationangle</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getRotationAngle() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AxisTickLabelOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AxisTickLabelOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AxisTickLabelOptionsProperty> {
            java.lang.Object labelOptions;
            java.lang.Number rotationAngle;

            /**
             * Sets the value of {@link AxisTickLabelOptionsProperty#getLabelOptions}
             * @param labelOptions Determines whether or not the axis ticks are visible.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder labelOptions(software.amazon.awscdk.IResolvable labelOptions) {
                this.labelOptions = labelOptions;
                return this;
            }

            /**
             * Sets the value of {@link AxisTickLabelOptionsProperty#getLabelOptions}
             * @param labelOptions Determines whether or not the axis ticks are visible.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder labelOptions(software.amazon.awscdk.services.quicksight.CfnAnalysis.LabelOptionsProperty labelOptions) {
                this.labelOptions = labelOptions;
                return this;
            }

            /**
             * Sets the value of {@link AxisTickLabelOptionsProperty#getRotationAngle}
             * @param rotationAngle The rotation angle of the axis tick labels.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rotationAngle(java.lang.Number rotationAngle) {
                this.rotationAngle = rotationAngle;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AxisTickLabelOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AxisTickLabelOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AxisTickLabelOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AxisTickLabelOptionsProperty {
            private final java.lang.Object labelOptions;
            private final java.lang.Number rotationAngle;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.labelOptions = software.amazon.jsii.Kernel.get(this, "labelOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rotationAngle = software.amazon.jsii.Kernel.get(this, "rotationAngle", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.labelOptions = builder.labelOptions;
                this.rotationAngle = builder.rotationAngle;
            }

            @Override
            public final java.lang.Object getLabelOptions() {
                return this.labelOptions;
            }

            @Override
            public final java.lang.Number getRotationAngle() {
                return this.rotationAngle;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getLabelOptions() != null) {
                    data.set("labelOptions", om.valueToTree(this.getLabelOptions()));
                }
                if (this.getRotationAngle() != null) {
                    data.set("rotationAngle", om.valueToTree(this.getRotationAngle()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.AxisTickLabelOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AxisTickLabelOptionsProperty.Jsii$Proxy that = (AxisTickLabelOptionsProperty.Jsii$Proxy) o;

                if (this.labelOptions != null ? !this.labelOptions.equals(that.labelOptions) : that.labelOptions != null) return false;
                return this.rotationAngle != null ? this.rotationAngle.equals(that.rotationAngle) : that.rotationAngle == null;
            }

            @Override
            public final int hashCode() {
                int result = this.labelOptions != null ? this.labelOptions.hashCode() : 0;
                result = 31 * result + (this.rotationAngle != null ? this.rotationAngle.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The aggregated field wells of a bar chart.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartaggregatedfieldwells.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartaggregatedfieldwells.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.BarChartAggregatedFieldWellsProperty")
    @software.amazon.jsii.Jsii.Proxy(BarChartAggregatedFieldWellsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BarChartAggregatedFieldWellsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The category (y-axis) field well of a bar chart.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartaggregatedfieldwells.html#cfn-quicksight-analysis-barchartaggregatedfieldwells-category">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartaggregatedfieldwells.html#cfn-quicksight-analysis-barchartaggregatedfieldwells-category</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCategory() {
            return null;
        }

        /**
         * The color (group/color) field well of a bar chart.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartaggregatedfieldwells.html#cfn-quicksight-analysis-barchartaggregatedfieldwells-colors">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartaggregatedfieldwells.html#cfn-quicksight-analysis-barchartaggregatedfieldwells-colors</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getColors() {
            return null;
        }

        /**
         * The small multiples field well of a bar chart.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartaggregatedfieldwells.html#cfn-quicksight-analysis-barchartaggregatedfieldwells-smallmultiples">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartaggregatedfieldwells.html#cfn-quicksight-analysis-barchartaggregatedfieldwells-smallmultiples</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSmallMultiples() {
            return null;
        }

        /**
         * The value field wells of a bar chart.
         * <p>
         * Values are aggregated by category.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartaggregatedfieldwells.html#cfn-quicksight-analysis-barchartaggregatedfieldwells-values">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartaggregatedfieldwells.html#cfn-quicksight-analysis-barchartaggregatedfieldwells-values</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getValues() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BarChartAggregatedFieldWellsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BarChartAggregatedFieldWellsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BarChartAggregatedFieldWellsProperty> {
            java.lang.Object category;
            java.lang.Object colors;
            java.lang.Object smallMultiples;
            java.lang.Object values;

            /**
             * Sets the value of {@link BarChartAggregatedFieldWellsProperty#getCategory}
             * @param category The category (y-axis) field well of a bar chart.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder category(software.amazon.awscdk.IResolvable category) {
                this.category = category;
                return this;
            }

            /**
             * Sets the value of {@link BarChartAggregatedFieldWellsProperty#getCategory}
             * @param category The category (y-axis) field well of a bar chart.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder category(java.util.List<? extends java.lang.Object> category) {
                this.category = category;
                return this;
            }

            /**
             * Sets the value of {@link BarChartAggregatedFieldWellsProperty#getColors}
             * @param colors The color (group/color) field well of a bar chart.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder colors(software.amazon.awscdk.IResolvable colors) {
                this.colors = colors;
                return this;
            }

            /**
             * Sets the value of {@link BarChartAggregatedFieldWellsProperty#getColors}
             * @param colors The color (group/color) field well of a bar chart.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder colors(java.util.List<? extends java.lang.Object> colors) {
                this.colors = colors;
                return this;
            }

            /**
             * Sets the value of {@link BarChartAggregatedFieldWellsProperty#getSmallMultiples}
             * @param smallMultiples The small multiples field well of a bar chart.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder smallMultiples(software.amazon.awscdk.IResolvable smallMultiples) {
                this.smallMultiples = smallMultiples;
                return this;
            }

            /**
             * Sets the value of {@link BarChartAggregatedFieldWellsProperty#getSmallMultiples}
             * @param smallMultiples The small multiples field well of a bar chart.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder smallMultiples(java.util.List<? extends java.lang.Object> smallMultiples) {
                this.smallMultiples = smallMultiples;
                return this;
            }

            /**
             * Sets the value of {@link BarChartAggregatedFieldWellsProperty#getValues}
             * @param values The value field wells of a bar chart.
             *               Values are aggregated by category.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder values(software.amazon.awscdk.IResolvable values) {
                this.values = values;
                return this;
            }

            /**
             * Sets the value of {@link BarChartAggregatedFieldWellsProperty#getValues}
             * @param values The value field wells of a bar chart.
             *               Values are aggregated by category.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder values(java.util.List<? extends java.lang.Object> values) {
                this.values = values;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BarChartAggregatedFieldWellsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BarChartAggregatedFieldWellsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BarChartAggregatedFieldWellsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BarChartAggregatedFieldWellsProperty {
            private final java.lang.Object category;
            private final java.lang.Object colors;
            private final java.lang.Object smallMultiples;
            private final java.lang.Object values;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.category = software.amazon.jsii.Kernel.get(this, "category", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.colors = software.amazon.jsii.Kernel.get(this, "colors", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.smallMultiples = software.amazon.jsii.Kernel.get(this, "smallMultiples", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.values = software.amazon.jsii.Kernel.get(this, "values", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.category = builder.category;
                this.colors = builder.colors;
                this.smallMultiples = builder.smallMultiples;
                this.values = builder.values;
            }

            @Override
            public final java.lang.Object getCategory() {
                return this.category;
            }

            @Override
            public final java.lang.Object getColors() {
                return this.colors;
            }

            @Override
            public final java.lang.Object getSmallMultiples() {
                return this.smallMultiples;
            }

            @Override
            public final java.lang.Object getValues() {
                return this.values;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCategory() != null) {
                    data.set("category", om.valueToTree(this.getCategory()));
                }
                if (this.getColors() != null) {
                    data.set("colors", om.valueToTree(this.getColors()));
                }
                if (this.getSmallMultiples() != null) {
                    data.set("smallMultiples", om.valueToTree(this.getSmallMultiples()));
                }
                if (this.getValues() != null) {
                    data.set("values", om.valueToTree(this.getValues()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.BarChartAggregatedFieldWellsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BarChartAggregatedFieldWellsProperty.Jsii$Proxy that = (BarChartAggregatedFieldWellsProperty.Jsii$Proxy) o;

                if (this.category != null ? !this.category.equals(that.category) : that.category != null) return false;
                if (this.colors != null ? !this.colors.equals(that.colors) : that.colors != null) return false;
                if (this.smallMultiples != null ? !this.smallMultiples.equals(that.smallMultiples) : that.smallMultiples != null) return false;
                return this.values != null ? this.values.equals(that.values) : that.values == null;
            }

            @Override
            public final int hashCode() {
                int result = this.category != null ? this.category.hashCode() : 0;
                result = 31 * result + (this.colors != null ? this.colors.hashCode() : 0);
                result = 31 * result + (this.smallMultiples != null ? this.smallMultiples.hashCode() : 0);
                result = 31 * result + (this.values != null ? this.values.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration of a <code>BarChartVisual</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.BarChartConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(BarChartConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BarChartConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Determines the arrangement of the bars.
         * <p>
         * The orientation and arrangement of bars determine the type of bar that is used in the visual.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html#cfn-quicksight-analysis-barchartconfiguration-barsarrangement">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html#cfn-quicksight-analysis-barchartconfiguration-barsarrangement</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBarsArrangement() {
            return null;
        }

        /**
         * The label display options (grid line, range, scale, axis step) for bar chart category.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html#cfn-quicksight-analysis-barchartconfiguration-categoryaxis">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html#cfn-quicksight-analysis-barchartconfiguration-categoryaxis</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCategoryAxis() {
            return null;
        }

        /**
         * The label options (label text, label visibility and sort icon visibility) for a bar chart.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html#cfn-quicksight-analysis-barchartconfiguration-categorylabeloptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html#cfn-quicksight-analysis-barchartconfiguration-categorylabeloptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCategoryLabelOptions() {
            return null;
        }

        /**
         * The label options (label text, label visibility and sort icon visibility) for a color that is used in a bar chart.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html#cfn-quicksight-analysis-barchartconfiguration-colorlabeloptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html#cfn-quicksight-analysis-barchartconfiguration-colorlabeloptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getColorLabelOptions() {
            return null;
        }

        /**
         * The contribution analysis (anomaly configuration) setup of the visual.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html#cfn-quicksight-analysis-barchartconfiguration-contributionanalysisdefaults">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html#cfn-quicksight-analysis-barchartconfiguration-contributionanalysisdefaults</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getContributionAnalysisDefaults() {
            return null;
        }

        /**
         * The options that determine if visual data labels are displayed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html#cfn-quicksight-analysis-barchartconfiguration-datalabels">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html#cfn-quicksight-analysis-barchartconfiguration-datalabels</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDataLabels() {
            return null;
        }

        /**
         * The field wells of the visual.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html#cfn-quicksight-analysis-barchartconfiguration-fieldwells">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html#cfn-quicksight-analysis-barchartconfiguration-fieldwells</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFieldWells() {
            return null;
        }

        /**
         * The legend display setup of the visual.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html#cfn-quicksight-analysis-barchartconfiguration-legend">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html#cfn-quicksight-analysis-barchartconfiguration-legend</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLegend() {
            return null;
        }

        /**
         * The orientation of the bars in a bar chart visual. There are two valid values in this structure:.
         * <p>
         * <ul>
         * <li><code>HORIZONTAL</code> : Used for charts that have horizontal bars. Visuals that use this value are horizontal bar charts, horizontal stacked bar charts, and horizontal stacked 100% bar charts.</li>
         * <li><code>VERTICAL</code> : Used for charts that have vertical bars. Visuals that use this value are vertical bar charts, vertical stacked bar charts, and vertical stacked 100% bar charts.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html#cfn-quicksight-analysis-barchartconfiguration-orientation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html#cfn-quicksight-analysis-barchartconfiguration-orientation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOrientation() {
            return null;
        }

        /**
         * The reference line setup of the visual.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html#cfn-quicksight-analysis-barchartconfiguration-referencelines">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html#cfn-quicksight-analysis-barchartconfiguration-referencelines</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getReferenceLines() {
            return null;
        }

        /**
         * The small multiples setup for the visual.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html#cfn-quicksight-analysis-barchartconfiguration-smallmultiplesoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html#cfn-quicksight-analysis-barchartconfiguration-smallmultiplesoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSmallMultiplesOptions() {
            return null;
        }

        /**
         * The sort configuration of a <code>BarChartVisual</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html#cfn-quicksight-analysis-barchartconfiguration-sortconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html#cfn-quicksight-analysis-barchartconfiguration-sortconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSortConfiguration() {
            return null;
        }

        /**
         * The tooltip display setup of the visual.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html#cfn-quicksight-analysis-barchartconfiguration-tooltip">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html#cfn-quicksight-analysis-barchartconfiguration-tooltip</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTooltip() {
            return null;
        }

        /**
         * The label display options (grid line, range, scale, axis step) for a bar chart value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html#cfn-quicksight-analysis-barchartconfiguration-valueaxis">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html#cfn-quicksight-analysis-barchartconfiguration-valueaxis</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getValueAxis() {
            return null;
        }

        /**
         * The label options (label text, label visibility and sort icon visibility) for a bar chart value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html#cfn-quicksight-analysis-barchartconfiguration-valuelabeloptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html#cfn-quicksight-analysis-barchartconfiguration-valuelabeloptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getValueLabelOptions() {
            return null;
        }

        /**
         * The palette (chart color) display setup of the visual.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html#cfn-quicksight-analysis-barchartconfiguration-visualpalette">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html#cfn-quicksight-analysis-barchartconfiguration-visualpalette</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVisualPalette() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BarChartConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BarChartConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BarChartConfigurationProperty> {
            java.lang.String barsArrangement;
            java.lang.Object categoryAxis;
            java.lang.Object categoryLabelOptions;
            java.lang.Object colorLabelOptions;
            java.lang.Object contributionAnalysisDefaults;
            java.lang.Object dataLabels;
            java.lang.Object fieldWells;
            java.lang.Object legend;
            java.lang.String orientation;
            java.lang.Object referenceLines;
            java.lang.Object smallMultiplesOptions;
            java.lang.Object sortConfiguration;
            java.lang.Object tooltip;
            java.lang.Object valueAxis;
            java.lang.Object valueLabelOptions;
            java.lang.Object visualPalette;

            /**
             * Sets the value of {@link BarChartConfigurationProperty#getBarsArrangement}
             * @param barsArrangement Determines the arrangement of the bars.
             *                        The orientation and arrangement of bars determine the type of bar that is used in the visual.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder barsArrangement(java.lang.String barsArrangement) {
                this.barsArrangement = barsArrangement;
                return this;
            }

            /**
             * Sets the value of {@link BarChartConfigurationProperty#getCategoryAxis}
             * @param categoryAxis The label display options (grid line, range, scale, axis step) for bar chart category.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder categoryAxis(software.amazon.awscdk.IResolvable categoryAxis) {
                this.categoryAxis = categoryAxis;
                return this;
            }

            /**
             * Sets the value of {@link BarChartConfigurationProperty#getCategoryAxis}
             * @param categoryAxis The label display options (grid line, range, scale, axis step) for bar chart category.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder categoryAxis(software.amazon.awscdk.services.quicksight.CfnAnalysis.AxisDisplayOptionsProperty categoryAxis) {
                this.categoryAxis = categoryAxis;
                return this;
            }

            /**
             * Sets the value of {@link BarChartConfigurationProperty#getCategoryLabelOptions}
             * @param categoryLabelOptions The label options (label text, label visibility and sort icon visibility) for a bar chart.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder categoryLabelOptions(software.amazon.awscdk.IResolvable categoryLabelOptions) {
                this.categoryLabelOptions = categoryLabelOptions;
                return this;
            }

            /**
             * Sets the value of {@link BarChartConfigurationProperty#getCategoryLabelOptions}
             * @param categoryLabelOptions The label options (label text, label visibility and sort icon visibility) for a bar chart.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder categoryLabelOptions(software.amazon.awscdk.services.quicksight.CfnAnalysis.ChartAxisLabelOptionsProperty categoryLabelOptions) {
                this.categoryLabelOptions = categoryLabelOptions;
                return this;
            }

            /**
             * Sets the value of {@link BarChartConfigurationProperty#getColorLabelOptions}
             * @param colorLabelOptions The label options (label text, label visibility and sort icon visibility) for a color that is used in a bar chart.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder colorLabelOptions(software.amazon.awscdk.IResolvable colorLabelOptions) {
                this.colorLabelOptions = colorLabelOptions;
                return this;
            }

            /**
             * Sets the value of {@link BarChartConfigurationProperty#getColorLabelOptions}
             * @param colorLabelOptions The label options (label text, label visibility and sort icon visibility) for a color that is used in a bar chart.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder colorLabelOptions(software.amazon.awscdk.services.quicksight.CfnAnalysis.ChartAxisLabelOptionsProperty colorLabelOptions) {
                this.colorLabelOptions = colorLabelOptions;
                return this;
            }

            /**
             * Sets the value of {@link BarChartConfigurationProperty#getContributionAnalysisDefaults}
             * @param contributionAnalysisDefaults The contribution analysis (anomaly configuration) setup of the visual.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder contributionAnalysisDefaults(software.amazon.awscdk.IResolvable contributionAnalysisDefaults) {
                this.contributionAnalysisDefaults = contributionAnalysisDefaults;
                return this;
            }

            /**
             * Sets the value of {@link BarChartConfigurationProperty#getContributionAnalysisDefaults}
             * @param contributionAnalysisDefaults The contribution analysis (anomaly configuration) setup of the visual.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder contributionAnalysisDefaults(java.util.List<? extends java.lang.Object> contributionAnalysisDefaults) {
                this.contributionAnalysisDefaults = contributionAnalysisDefaults;
                return this;
            }

            /**
             * Sets the value of {@link BarChartConfigurationProperty#getDataLabels}
             * @param dataLabels The options that determine if visual data labels are displayed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataLabels(software.amazon.awscdk.IResolvable dataLabels) {
                this.dataLabels = dataLabels;
                return this;
            }

            /**
             * Sets the value of {@link BarChartConfigurationProperty#getDataLabels}
             * @param dataLabels The options that determine if visual data labels are displayed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataLabels(software.amazon.awscdk.services.quicksight.CfnAnalysis.DataLabelOptionsProperty dataLabels) {
                this.dataLabels = dataLabels;
                return this;
            }

            /**
             * Sets the value of {@link BarChartConfigurationProperty#getFieldWells}
             * @param fieldWells The field wells of the visual.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldWells(software.amazon.awscdk.IResolvable fieldWells) {
                this.fieldWells = fieldWells;
                return this;
            }

            /**
             * Sets the value of {@link BarChartConfigurationProperty#getFieldWells}
             * @param fieldWells The field wells of the visual.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldWells(software.amazon.awscdk.services.quicksight.CfnAnalysis.BarChartFieldWellsProperty fieldWells) {
                this.fieldWells = fieldWells;
                return this;
            }

            /**
             * Sets the value of {@link BarChartConfigurationProperty#getLegend}
             * @param legend The legend display setup of the visual.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder legend(software.amazon.awscdk.IResolvable legend) {
                this.legend = legend;
                return this;
            }

            /**
             * Sets the value of {@link BarChartConfigurationProperty#getLegend}
             * @param legend The legend display setup of the visual.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder legend(software.amazon.awscdk.services.quicksight.CfnAnalysis.LegendOptionsProperty legend) {
                this.legend = legend;
                return this;
            }

            /**
             * Sets the value of {@link BarChartConfigurationProperty#getOrientation}
             * @param orientation The orientation of the bars in a bar chart visual. There are two valid values in this structure:.
             *                    <ul>
             *                    <li><code>HORIZONTAL</code> : Used for charts that have horizontal bars. Visuals that use this value are horizontal bar charts, horizontal stacked bar charts, and horizontal stacked 100% bar charts.</li>
             *                    <li><code>VERTICAL</code> : Used for charts that have vertical bars. Visuals that use this value are vertical bar charts, vertical stacked bar charts, and vertical stacked 100% bar charts.</li>
             *                    </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder orientation(java.lang.String orientation) {
                this.orientation = orientation;
                return this;
            }

            /**
             * Sets the value of {@link BarChartConfigurationProperty#getReferenceLines}
             * @param referenceLines The reference line setup of the visual.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder referenceLines(software.amazon.awscdk.IResolvable referenceLines) {
                this.referenceLines = referenceLines;
                return this;
            }

            /**
             * Sets the value of {@link BarChartConfigurationProperty#getReferenceLines}
             * @param referenceLines The reference line setup of the visual.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder referenceLines(java.util.List<? extends java.lang.Object> referenceLines) {
                this.referenceLines = referenceLines;
                return this;
            }

            /**
             * Sets the value of {@link BarChartConfigurationProperty#getSmallMultiplesOptions}
             * @param smallMultiplesOptions The small multiples setup for the visual.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder smallMultiplesOptions(software.amazon.awscdk.IResolvable smallMultiplesOptions) {
                this.smallMultiplesOptions = smallMultiplesOptions;
                return this;
            }

            /**
             * Sets the value of {@link BarChartConfigurationProperty#getSmallMultiplesOptions}
             * @param smallMultiplesOptions The small multiples setup for the visual.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder smallMultiplesOptions(software.amazon.awscdk.services.quicksight.CfnAnalysis.SmallMultiplesOptionsProperty smallMultiplesOptions) {
                this.smallMultiplesOptions = smallMultiplesOptions;
                return this;
            }

            /**
             * Sets the value of {@link BarChartConfigurationProperty#getSortConfiguration}
             * @param sortConfiguration The sort configuration of a <code>BarChartVisual</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sortConfiguration(software.amazon.awscdk.IResolvable sortConfiguration) {
                this.sortConfiguration = sortConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link BarChartConfigurationProperty#getSortConfiguration}
             * @param sortConfiguration The sort configuration of a <code>BarChartVisual</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sortConfiguration(software.amazon.awscdk.services.quicksight.CfnAnalysis.BarChartSortConfigurationProperty sortConfiguration) {
                this.sortConfiguration = sortConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link BarChartConfigurationProperty#getTooltip}
             * @param tooltip The tooltip display setup of the visual.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tooltip(software.amazon.awscdk.IResolvable tooltip) {
                this.tooltip = tooltip;
                return this;
            }

            /**
             * Sets the value of {@link BarChartConfigurationProperty#getTooltip}
             * @param tooltip The tooltip display setup of the visual.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tooltip(software.amazon.awscdk.services.quicksight.CfnAnalysis.TooltipOptionsProperty tooltip) {
                this.tooltip = tooltip;
                return this;
            }

            /**
             * Sets the value of {@link BarChartConfigurationProperty#getValueAxis}
             * @param valueAxis The label display options (grid line, range, scale, axis step) for a bar chart value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder valueAxis(software.amazon.awscdk.IResolvable valueAxis) {
                this.valueAxis = valueAxis;
                return this;
            }

            /**
             * Sets the value of {@link BarChartConfigurationProperty#getValueAxis}
             * @param valueAxis The label display options (grid line, range, scale, axis step) for a bar chart value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder valueAxis(software.amazon.awscdk.services.quicksight.CfnAnalysis.AxisDisplayOptionsProperty valueAxis) {
                this.valueAxis = valueAxis;
                return this;
            }

            /**
             * Sets the value of {@link BarChartConfigurationProperty#getValueLabelOptions}
             * @param valueLabelOptions The label options (label text, label visibility and sort icon visibility) for a bar chart value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder valueLabelOptions(software.amazon.awscdk.IResolvable valueLabelOptions) {
                this.valueLabelOptions = valueLabelOptions;
                return this;
            }

            /**
             * Sets the value of {@link BarChartConfigurationProperty#getValueLabelOptions}
             * @param valueLabelOptions The label options (label text, label visibility and sort icon visibility) for a bar chart value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder valueLabelOptions(software.amazon.awscdk.services.quicksight.CfnAnalysis.ChartAxisLabelOptionsProperty valueLabelOptions) {
                this.valueLabelOptions = valueLabelOptions;
                return this;
            }

            /**
             * Sets the value of {@link BarChartConfigurationProperty#getVisualPalette}
             * @param visualPalette The palette (chart color) display setup of the visual.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder visualPalette(software.amazon.awscdk.IResolvable visualPalette) {
                this.visualPalette = visualPalette;
                return this;
            }

            /**
             * Sets the value of {@link BarChartConfigurationProperty#getVisualPalette}
             * @param visualPalette The palette (chart color) display setup of the visual.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder visualPalette(software.amazon.awscdk.services.quicksight.CfnAnalysis.VisualPaletteProperty visualPalette) {
                this.visualPalette = visualPalette;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BarChartConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BarChartConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BarChartConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BarChartConfigurationProperty {
            private final java.lang.String barsArrangement;
            private final java.lang.Object categoryAxis;
            private final java.lang.Object categoryLabelOptions;
            private final java.lang.Object colorLabelOptions;
            private final java.lang.Object contributionAnalysisDefaults;
            private final java.lang.Object dataLabels;
            private final java.lang.Object fieldWells;
            private final java.lang.Object legend;
            private final java.lang.String orientation;
            private final java.lang.Object referenceLines;
            private final java.lang.Object smallMultiplesOptions;
            private final java.lang.Object sortConfiguration;
            private final java.lang.Object tooltip;
            private final java.lang.Object valueAxis;
            private final java.lang.Object valueLabelOptions;
            private final java.lang.Object visualPalette;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.barsArrangement = software.amazon.jsii.Kernel.get(this, "barsArrangement", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.categoryAxis = software.amazon.jsii.Kernel.get(this, "categoryAxis", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.categoryLabelOptions = software.amazon.jsii.Kernel.get(this, "categoryLabelOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.colorLabelOptions = software.amazon.jsii.Kernel.get(this, "colorLabelOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.contributionAnalysisDefaults = software.amazon.jsii.Kernel.get(this, "contributionAnalysisDefaults", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dataLabels = software.amazon.jsii.Kernel.get(this, "dataLabels", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.fieldWells = software.amazon.jsii.Kernel.get(this, "fieldWells", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.legend = software.amazon.jsii.Kernel.get(this, "legend", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.orientation = software.amazon.jsii.Kernel.get(this, "orientation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.referenceLines = software.amazon.jsii.Kernel.get(this, "referenceLines", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.smallMultiplesOptions = software.amazon.jsii.Kernel.get(this, "smallMultiplesOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sortConfiguration = software.amazon.jsii.Kernel.get(this, "sortConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.tooltip = software.amazon.jsii.Kernel.get(this, "tooltip", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.valueAxis = software.amazon.jsii.Kernel.get(this, "valueAxis", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.valueLabelOptions = software.amazon.jsii.Kernel.get(this, "valueLabelOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.visualPalette = software.amazon.jsii.Kernel.get(this, "visualPalette", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.barsArrangement = builder.barsArrangement;
                this.categoryAxis = builder.categoryAxis;
                this.categoryLabelOptions = builder.categoryLabelOptions;
                this.colorLabelOptions = builder.colorLabelOptions;
                this.contributionAnalysisDefaults = builder.contributionAnalysisDefaults;
                this.dataLabels = builder.dataLabels;
                this.fieldWells = builder.fieldWells;
                this.legend = builder.legend;
                this.orientation = builder.orientation;
                this.referenceLines = builder.referenceLines;
                this.smallMultiplesOptions = builder.smallMultiplesOptions;
                this.sortConfiguration = builder.sortConfiguration;
                this.tooltip = builder.tooltip;
                this.valueAxis = builder.valueAxis;
                this.valueLabelOptions = builder.valueLabelOptions;
                this.visualPalette = builder.visualPalette;
            }

            @Override
            public final java.lang.String getBarsArrangement() {
                return this.barsArrangement;
            }

            @Override
            public final java.lang.Object getCategoryAxis() {
                return this.categoryAxis;
            }

            @Override
            public final java.lang.Object getCategoryLabelOptions() {
                return this.categoryLabelOptions;
            }

            @Override
            public final java.lang.Object getColorLabelOptions() {
                return this.colorLabelOptions;
            }

            @Override
            public final java.lang.Object getContributionAnalysisDefaults() {
                return this.contributionAnalysisDefaults;
            }

            @Override
            public final java.lang.Object getDataLabels() {
                return this.dataLabels;
            }

            @Override
            public final java.lang.Object getFieldWells() {
                return this.fieldWells;
            }

            @Override
            public final java.lang.Object getLegend() {
                return this.legend;
            }

            @Override
            public final java.lang.String getOrientation() {
                return this.orientation;
            }

            @Override
            public final java.lang.Object getReferenceLines() {
                return this.referenceLines;
            }

            @Override
            public final java.lang.Object getSmallMultiplesOptions() {
                return this.smallMultiplesOptions;
            }

            @Override
            public final java.lang.Object getSortConfiguration() {
                return this.sortConfiguration;
            }

            @Override
            public final java.lang.Object getTooltip() {
                return this.tooltip;
            }

            @Override
            public final java.lang.Object getValueAxis() {
                return this.valueAxis;
            }

            @Override
            public final java.lang.Object getValueLabelOptions() {
                return this.valueLabelOptions;
            }

            @Override
            public final java.lang.Object getVisualPalette() {
                return this.visualPalette;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBarsArrangement() != null) {
                    data.set("barsArrangement", om.valueToTree(this.getBarsArrangement()));
                }
                if (this.getCategoryAxis() != null) {
                    data.set("categoryAxis", om.valueToTree(this.getCategoryAxis()));
                }
                if (this.getCategoryLabelOptions() != null) {
                    data.set("categoryLabelOptions", om.valueToTree(this.getCategoryLabelOptions()));
                }
                if (this.getColorLabelOptions() != null) {
                    data.set("colorLabelOptions", om.valueToTree(this.getColorLabelOptions()));
                }
                if (this.getContributionAnalysisDefaults() != null) {
                    data.set("contributionAnalysisDefaults", om.valueToTree(this.getContributionAnalysisDefaults()));
                }
                if (this.getDataLabels() != null) {
                    data.set("dataLabels", om.valueToTree(this.getDataLabels()));
                }
                if (this.getFieldWells() != null) {
                    data.set("fieldWells", om.valueToTree(this.getFieldWells()));
                }
                if (this.getLegend() != null) {
                    data.set("legend", om.valueToTree(this.getLegend()));
                }
                if (this.getOrientation() != null) {
                    data.set("orientation", om.valueToTree(this.getOrientation()));
                }
                if (this.getReferenceLines() != null) {
                    data.set("referenceLines", om.valueToTree(this.getReferenceLines()));
                }
                if (this.getSmallMultiplesOptions() != null) {
                    data.set("smallMultiplesOptions", om.valueToTree(this.getSmallMultiplesOptions()));
                }
                if (this.getSortConfiguration() != null) {
                    data.set("sortConfiguration", om.valueToTree(this.getSortConfiguration()));
                }
                if (this.getTooltip() != null) {
                    data.set("tooltip", om.valueToTree(this.getTooltip()));
                }
                if (this.getValueAxis() != null) {
                    data.set("valueAxis", om.valueToTree(this.getValueAxis()));
                }
                if (this.getValueLabelOptions() != null) {
                    data.set("valueLabelOptions", om.valueToTree(this.getValueLabelOptions()));
                }
                if (this.getVisualPalette() != null) {
                    data.set("visualPalette", om.valueToTree(this.getVisualPalette()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.BarChartConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BarChartConfigurationProperty.Jsii$Proxy that = (BarChartConfigurationProperty.Jsii$Proxy) o;

                if (this.barsArrangement != null ? !this.barsArrangement.equals(that.barsArrangement) : that.barsArrangement != null) return false;
                if (this.categoryAxis != null ? !this.categoryAxis.equals(that.categoryAxis) : that.categoryAxis != null) return false;
                if (this.categoryLabelOptions != null ? !this.categoryLabelOptions.equals(that.categoryLabelOptions) : that.categoryLabelOptions != null) return false;
                if (this.colorLabelOptions != null ? !this.colorLabelOptions.equals(that.colorLabelOptions) : that.colorLabelOptions != null) return false;
                if (this.contributionAnalysisDefaults != null ? !this.contributionAnalysisDefaults.equals(that.contributionAnalysisDefaults) : that.contributionAnalysisDefaults != null) return false;
                if (this.dataLabels != null ? !this.dataLabels.equals(that.dataLabels) : that.dataLabels != null) return false;
                if (this.fieldWells != null ? !this.fieldWells.equals(that.fieldWells) : that.fieldWells != null) return false;
                if (this.legend != null ? !this.legend.equals(that.legend) : that.legend != null) return false;
                if (this.orientation != null ? !this.orientation.equals(that.orientation) : that.orientation != null) return false;
                if (this.referenceLines != null ? !this.referenceLines.equals(that.referenceLines) : that.referenceLines != null) return false;
                if (this.smallMultiplesOptions != null ? !this.smallMultiplesOptions.equals(that.smallMultiplesOptions) : that.smallMultiplesOptions != null) return false;
                if (this.sortConfiguration != null ? !this.sortConfiguration.equals(that.sortConfiguration) : that.sortConfiguration != null) return false;
                if (this.tooltip != null ? !this.tooltip.equals(that.tooltip) : that.tooltip != null) return false;
                if (this.valueAxis != null ? !this.valueAxis.equals(that.valueAxis) : that.valueAxis != null) return false;
                if (this.valueLabelOptions != null ? !this.valueLabelOptions.equals(that.valueLabelOptions) : that.valueLabelOptions != null) return false;
                return this.visualPalette != null ? this.visualPalette.equals(that.visualPalette) : that.visualPalette == null;
            }

            @Override
            public final int hashCode() {
                int result = this.barsArrangement != null ? this.barsArrangement.hashCode() : 0;
                result = 31 * result + (this.categoryAxis != null ? this.categoryAxis.hashCode() : 0);
                result = 31 * result + (this.categoryLabelOptions != null ? this.categoryLabelOptions.hashCode() : 0);
                result = 31 * result + (this.colorLabelOptions != null ? this.colorLabelOptions.hashCode() : 0);
                result = 31 * result + (this.contributionAnalysisDefaults != null ? this.contributionAnalysisDefaults.hashCode() : 0);
                result = 31 * result + (this.dataLabels != null ? this.dataLabels.hashCode() : 0);
                result = 31 * result + (this.fieldWells != null ? this.fieldWells.hashCode() : 0);
                result = 31 * result + (this.legend != null ? this.legend.hashCode() : 0);
                result = 31 * result + (this.orientation != null ? this.orientation.hashCode() : 0);
                result = 31 * result + (this.referenceLines != null ? this.referenceLines.hashCode() : 0);
                result = 31 * result + (this.smallMultiplesOptions != null ? this.smallMultiplesOptions.hashCode() : 0);
                result = 31 * result + (this.sortConfiguration != null ? this.sortConfiguration.hashCode() : 0);
                result = 31 * result + (this.tooltip != null ? this.tooltip.hashCode() : 0);
                result = 31 * result + (this.valueAxis != null ? this.valueAxis.hashCode() : 0);
                result = 31 * result + (this.valueLabelOptions != null ? this.valueLabelOptions.hashCode() : 0);
                result = 31 * result + (this.visualPalette != null ? this.visualPalette.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The field wells of a <code>BarChartVisual</code> .
     * <p>
     * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartfieldwells.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartfieldwells.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.BarChartFieldWellsProperty")
    @software.amazon.jsii.Jsii.Proxy(BarChartFieldWellsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BarChartFieldWellsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The aggregated field wells of a bar chart.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartfieldwells.html#cfn-quicksight-analysis-barchartfieldwells-barchartaggregatedfieldwells">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartfieldwells.html#cfn-quicksight-analysis-barchartfieldwells-barchartaggregatedfieldwells</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBarChartAggregatedFieldWells() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BarChartFieldWellsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BarChartFieldWellsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BarChartFieldWellsProperty> {
            java.lang.Object barChartAggregatedFieldWells;

            /**
             * Sets the value of {@link BarChartFieldWellsProperty#getBarChartAggregatedFieldWells}
             * @param barChartAggregatedFieldWells The aggregated field wells of a bar chart.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder barChartAggregatedFieldWells(software.amazon.awscdk.IResolvable barChartAggregatedFieldWells) {
                this.barChartAggregatedFieldWells = barChartAggregatedFieldWells;
                return this;
            }

            /**
             * Sets the value of {@link BarChartFieldWellsProperty#getBarChartAggregatedFieldWells}
             * @param barChartAggregatedFieldWells The aggregated field wells of a bar chart.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder barChartAggregatedFieldWells(software.amazon.awscdk.services.quicksight.CfnAnalysis.BarChartAggregatedFieldWellsProperty barChartAggregatedFieldWells) {
                this.barChartAggregatedFieldWells = barChartAggregatedFieldWells;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BarChartFieldWellsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BarChartFieldWellsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BarChartFieldWellsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BarChartFieldWellsProperty {
            private final java.lang.Object barChartAggregatedFieldWells;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.barChartAggregatedFieldWells = software.amazon.jsii.Kernel.get(this, "barChartAggregatedFieldWells", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.barChartAggregatedFieldWells = builder.barChartAggregatedFieldWells;
            }

            @Override
            public final java.lang.Object getBarChartAggregatedFieldWells() {
                return this.barChartAggregatedFieldWells;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBarChartAggregatedFieldWells() != null) {
                    data.set("barChartAggregatedFieldWells", om.valueToTree(this.getBarChartAggregatedFieldWells()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.BarChartFieldWellsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BarChartFieldWellsProperty.Jsii$Proxy that = (BarChartFieldWellsProperty.Jsii$Proxy) o;

                return this.barChartAggregatedFieldWells != null ? this.barChartAggregatedFieldWells.equals(that.barChartAggregatedFieldWells) : that.barChartAggregatedFieldWells == null;
            }

            @Override
            public final int hashCode() {
                int result = this.barChartAggregatedFieldWells != null ? this.barChartAggregatedFieldWells.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * sort-configuration-description.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * BarChartSortConfigurationProperty barChartSortConfigurationProperty = BarChartSortConfigurationProperty.builder()
     *         .categoryItemsLimit(ItemsLimitConfigurationProperty.builder()
     *                 .itemsLimit(123)
     *                 .otherCategories("otherCategories")
     *                 .build())
     *         .categorySort(List.of(FieldSortOptionsProperty.builder()
     *                 .columnSort(ColumnSortProperty.builder()
     *                         .direction("direction")
     *                         .sortBy(ColumnIdentifierProperty.builder()
     *                                 .columnName("columnName")
     *                                 .dataSetIdentifier("dataSetIdentifier")
     *                                 .build())
     *                         // the properties below are optional
     *                         .aggregationFunction(AggregationFunctionProperty.builder()
     *                                 .attributeAggregationFunction(AttributeAggregationFunctionProperty.builder()
     *                                         .simpleAttributeAggregation("simpleAttributeAggregation")
     *                                         .valueForMultipleValues("valueForMultipleValues")
     *                                         .build())
     *                                 .categoricalAggregationFunction("categoricalAggregationFunction")
     *                                 .dateAggregationFunction("dateAggregationFunction")
     *                                 .numericalAggregationFunction(NumericalAggregationFunctionProperty.builder()
     *                                         .percentileAggregation(PercentileAggregationProperty.builder()
     *                                                 .percentileValue(123)
     *                                                 .build())
     *                                         .simpleNumericalAggregation("simpleNumericalAggregation")
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 .fieldSort(FieldSortProperty.builder()
     *                         .direction("direction")
     *                         .fieldId("fieldId")
     *                         .build())
     *                 .build()))
     *         .colorItemsLimit(ItemsLimitConfigurationProperty.builder()
     *                 .itemsLimit(123)
     *                 .otherCategories("otherCategories")
     *                 .build())
     *         .colorSort(List.of(FieldSortOptionsProperty.builder()
     *                 .columnSort(ColumnSortProperty.builder()
     *                         .direction("direction")
     *                         .sortBy(ColumnIdentifierProperty.builder()
     *                                 .columnName("columnName")
     *                                 .dataSetIdentifier("dataSetIdentifier")
     *                                 .build())
     *                         // the properties below are optional
     *                         .aggregationFunction(AggregationFunctionProperty.builder()
     *                                 .attributeAggregationFunction(AttributeAggregationFunctionProperty.builder()
     *                                         .simpleAttributeAggregation("simpleAttributeAggregation")
     *                                         .valueForMultipleValues("valueForMultipleValues")
     *                                         .build())
     *                                 .categoricalAggregationFunction("categoricalAggregationFunction")
     *                                 .dateAggregationFunction("dateAggregationFunction")
     *                                 .numericalAggregationFunction(NumericalAggregationFunctionProperty.builder()
     *                                         .percentileAggregation(PercentileAggregationProperty.builder()
     *                                                 .percentileValue(123)
     *                                                 .build())
     *                                         .simpleNumericalAggregation("simpleNumericalAggregation")
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 .fieldSort(FieldSortProperty.builder()
     *                         .direction("direction")
     *                         .fieldId("fieldId")
     *                         .build())
     *                 .build()))
     *         .smallMultiplesLimitConfiguration(ItemsLimitConfigurationProperty.builder()
     *                 .itemsLimit(123)
     *                 .otherCategories("otherCategories")
     *                 .build())
     *         .smallMultiplesSort(List.of(FieldSortOptionsProperty.builder()
     *                 .columnSort(ColumnSortProperty.builder()
     *                         .direction("direction")
     *                         .sortBy(ColumnIdentifierProperty.builder()
     *                                 .columnName("columnName")
     *                                 .dataSetIdentifier("dataSetIdentifier")
     *                                 .build())
     *                         // the properties below are optional
     *                         .aggregationFunction(AggregationFunctionProperty.builder()
     *                                 .attributeAggregationFunction(AttributeAggregationFunctionProperty.builder()
     *                                         .simpleAttributeAggregation("simpleAttributeAggregation")
     *                                         .valueForMultipleValues("valueForMultipleValues")
     *                                         .build())
     *                                 .categoricalAggregationFunction("categoricalAggregationFunction")
     *                                 .dateAggregationFunction("dateAggregationFunction")
     *                                 .numericalAggregationFunction(NumericalAggregationFunctionProperty.builder()
     *                                         .percentileAggregation(PercentileAggregationProperty.builder()
     *                                                 .percentileValue(123)
     *                                                 .build())
     *                                         .simpleNumericalAggregation("simpleNumericalAggregation")
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 .fieldSort(FieldSortProperty.builder()
     *                         .direction("direction")
     *                         .fieldId("fieldId")
     *                         .build())
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartsortconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartsortconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.BarChartSortConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(BarChartSortConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BarChartSortConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The limit on the number of categories displayed in a bar chart.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartsortconfiguration.html#cfn-quicksight-analysis-barchartsortconfiguration-categoryitemslimit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartsortconfiguration.html#cfn-quicksight-analysis-barchartsortconfiguration-categoryitemslimit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCategoryItemsLimit() {
            return null;
        }

        /**
         * The sort configuration of category fields.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartsortconfiguration.html#cfn-quicksight-analysis-barchartsortconfiguration-categorysort">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartsortconfiguration.html#cfn-quicksight-analysis-barchartsortconfiguration-categorysort</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCategorySort() {
            return null;
        }

        /**
         * The limit on the number of values displayed in a bar chart.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartsortconfiguration.html#cfn-quicksight-analysis-barchartsortconfiguration-coloritemslimit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartsortconfiguration.html#cfn-quicksight-analysis-barchartsortconfiguration-coloritemslimit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getColorItemsLimit() {
            return null;
        }

        /**
         * The sort configuration of color fields in a bar chart.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartsortconfiguration.html#cfn-quicksight-analysis-barchartsortconfiguration-colorsort">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartsortconfiguration.html#cfn-quicksight-analysis-barchartsortconfiguration-colorsort</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getColorSort() {
            return null;
        }

        /**
         * The limit on the number of small multiples panels that are displayed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartsortconfiguration.html#cfn-quicksight-analysis-barchartsortconfiguration-smallmultipleslimitconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartsortconfiguration.html#cfn-quicksight-analysis-barchartsortconfiguration-smallmultipleslimitconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSmallMultiplesLimitConfiguration() {
            return null;
        }

        /**
         * The sort configuration of the small multiples field.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartsortconfiguration.html#cfn-quicksight-analysis-barchartsortconfiguration-smallmultiplessort">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartsortconfiguration.html#cfn-quicksight-analysis-barchartsortconfiguration-smallmultiplessort</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSmallMultiplesSort() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BarChartSortConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BarChartSortConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BarChartSortConfigurationProperty> {
            java.lang.Object categoryItemsLimit;
            java.lang.Object categorySort;
            java.lang.Object colorItemsLimit;
            java.lang.Object colorSort;
            java.lang.Object smallMultiplesLimitConfiguration;
            java.lang.Object smallMultiplesSort;

            /**
             * Sets the value of {@link BarChartSortConfigurationProperty#getCategoryItemsLimit}
             * @param categoryItemsLimit The limit on the number of categories displayed in a bar chart.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder categoryItemsLimit(software.amazon.awscdk.IResolvable categoryItemsLimit) {
                this.categoryItemsLimit = categoryItemsLimit;
                return this;
            }

            /**
             * Sets the value of {@link BarChartSortConfigurationProperty#getCategoryItemsLimit}
             * @param categoryItemsLimit The limit on the number of categories displayed in a bar chart.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder categoryItemsLimit(software.amazon.awscdk.services.quicksight.CfnAnalysis.ItemsLimitConfigurationProperty categoryItemsLimit) {
                this.categoryItemsLimit = categoryItemsLimit;
                return this;
            }

            /**
             * Sets the value of {@link BarChartSortConfigurationProperty#getCategorySort}
             * @param categorySort The sort configuration of category fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder categorySort(software.amazon.awscdk.IResolvable categorySort) {
                this.categorySort = categorySort;
                return this;
            }

            /**
             * Sets the value of {@link BarChartSortConfigurationProperty#getCategorySort}
             * @param categorySort The sort configuration of category fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder categorySort(java.util.List<? extends java.lang.Object> categorySort) {
                this.categorySort = categorySort;
                return this;
            }

            /**
             * Sets the value of {@link BarChartSortConfigurationProperty#getColorItemsLimit}
             * @param colorItemsLimit The limit on the number of values displayed in a bar chart.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder colorItemsLimit(software.amazon.awscdk.IResolvable colorItemsLimit) {
                this.colorItemsLimit = colorItemsLimit;
                return this;
            }

            /**
             * Sets the value of {@link BarChartSortConfigurationProperty#getColorItemsLimit}
             * @param colorItemsLimit The limit on the number of values displayed in a bar chart.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder colorItemsLimit(software.amazon.awscdk.services.quicksight.CfnAnalysis.ItemsLimitConfigurationProperty colorItemsLimit) {
                this.colorItemsLimit = colorItemsLimit;
                return this;
            }

            /**
             * Sets the value of {@link BarChartSortConfigurationProperty#getColorSort}
             * @param colorSort The sort configuration of color fields in a bar chart.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder colorSort(software.amazon.awscdk.IResolvable colorSort) {
                this.colorSort = colorSort;
                return this;
            }

            /**
             * Sets the value of {@link BarChartSortConfigurationProperty#getColorSort}
             * @param colorSort The sort configuration of color fields in a bar chart.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder colorSort(java.util.List<? extends java.lang.Object> colorSort) {
                this.colorSort = colorSort;
                return this;
            }

            /**
             * Sets the value of {@link BarChartSortConfigurationProperty#getSmallMultiplesLimitConfiguration}
             * @param smallMultiplesLimitConfiguration The limit on the number of small multiples panels that are displayed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder smallMultiplesLimitConfiguration(software.amazon.awscdk.IResolvable smallMultiplesLimitConfiguration) {
                this.smallMultiplesLimitConfiguration = smallMultiplesLimitConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link BarChartSortConfigurationProperty#getSmallMultiplesLimitConfiguration}
             * @param smallMultiplesLimitConfiguration The limit on the number of small multiples panels that are displayed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder smallMultiplesLimitConfiguration(software.amazon.awscdk.services.quicksight.CfnAnalysis.ItemsLimitConfigurationProperty smallMultiplesLimitConfiguration) {
                this.smallMultiplesLimitConfiguration = smallMultiplesLimitConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link BarChartSortConfigurationProperty#getSmallMultiplesSort}
             * @param smallMultiplesSort The sort configuration of the small multiples field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder smallMultiplesSort(software.amazon.awscdk.IResolvable smallMultiplesSort) {
                this.smallMultiplesSort = smallMultiplesSort;
                return this;
            }

            /**
             * Sets the value of {@link BarChartSortConfigurationProperty#getSmallMultiplesSort}
             * @param smallMultiplesSort The sort configuration of the small multiples field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder smallMultiplesSort(java.util.List<? extends java.lang.Object> smallMultiplesSort) {
                this.smallMultiplesSort = smallMultiplesSort;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BarChartSortConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BarChartSortConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BarChartSortConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BarChartSortConfigurationProperty {
            private final java.lang.Object categoryItemsLimit;
            private final java.lang.Object categorySort;
            private final java.lang.Object colorItemsLimit;
            private final java.lang.Object colorSort;
            private final java.lang.Object smallMultiplesLimitConfiguration;
            private final java.lang.Object smallMultiplesSort;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.categoryItemsLimit = software.amazon.jsii.Kernel.get(this, "categoryItemsLimit", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.categorySort = software.amazon.jsii.Kernel.get(this, "categorySort", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.colorItemsLimit = software.amazon.jsii.Kernel.get(this, "colorItemsLimit", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.colorSort = software.amazon.jsii.Kernel.get(this, "colorSort", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.smallMultiplesLimitConfiguration = software.amazon.jsii.Kernel.get(this, "smallMultiplesLimitConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.smallMultiplesSort = software.amazon.jsii.Kernel.get(this, "smallMultiplesSort", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.categoryItemsLimit = builder.categoryItemsLimit;
                this.categorySort = builder.categorySort;
                this.colorItemsLimit = builder.colorItemsLimit;
                this.colorSort = builder.colorSort;
                this.smallMultiplesLimitConfiguration = builder.smallMultiplesLimitConfiguration;
                this.smallMultiplesSort = builder.smallMultiplesSort;
            }

            @Override
            public final java.lang.Object getCategoryItemsLimit() {
                return this.categoryItemsLimit;
            }

            @Override
            public final java.lang.Object getCategorySort() {
                return this.categorySort;
            }

            @Override
            public final java.lang.Object getColorItemsLimit() {
                return this.colorItemsLimit;
            }

            @Override
            public final java.lang.Object getColorSort() {
                return this.colorSort;
            }

            @Override
            public final java.lang.Object getSmallMultiplesLimitConfiguration() {
                return this.smallMultiplesLimitConfiguration;
            }

            @Override
            public final java.lang.Object getSmallMultiplesSort() {
                return this.smallMultiplesSort;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCategoryItemsLimit() != null) {
                    data.set("categoryItemsLimit", om.valueToTree(this.getCategoryItemsLimit()));
                }
                if (this.getCategorySort() != null) {
                    data.set("categorySort", om.valueToTree(this.getCategorySort()));
                }
                if (this.getColorItemsLimit() != null) {
                    data.set("colorItemsLimit", om.valueToTree(this.getColorItemsLimit()));
                }
                if (this.getColorSort() != null) {
                    data.set("colorSort", om.valueToTree(this.getColorSort()));
                }
                if (this.getSmallMultiplesLimitConfiguration() != null) {
                    data.set("smallMultiplesLimitConfiguration", om.valueToTree(this.getSmallMultiplesLimitConfiguration()));
                }
                if (this.getSmallMultiplesSort() != null) {
                    data.set("smallMultiplesSort", om.valueToTree(this.getSmallMultiplesSort()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.BarChartSortConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BarChartSortConfigurationProperty.Jsii$Proxy that = (BarChartSortConfigurationProperty.Jsii$Proxy) o;

                if (this.categoryItemsLimit != null ? !this.categoryItemsLimit.equals(that.categoryItemsLimit) : that.categoryItemsLimit != null) return false;
                if (this.categorySort != null ? !this.categorySort.equals(that.categorySort) : that.categorySort != null) return false;
                if (this.colorItemsLimit != null ? !this.colorItemsLimit.equals(that.colorItemsLimit) : that.colorItemsLimit != null) return false;
                if (this.colorSort != null ? !this.colorSort.equals(that.colorSort) : that.colorSort != null) return false;
                if (this.smallMultiplesLimitConfiguration != null ? !this.smallMultiplesLimitConfiguration.equals(that.smallMultiplesLimitConfiguration) : that.smallMultiplesLimitConfiguration != null) return false;
                return this.smallMultiplesSort != null ? this.smallMultiplesSort.equals(that.smallMultiplesSort) : that.smallMultiplesSort == null;
            }

            @Override
            public final int hashCode() {
                int result = this.categoryItemsLimit != null ? this.categoryItemsLimit.hashCode() : 0;
                result = 31 * result + (this.categorySort != null ? this.categorySort.hashCode() : 0);
                result = 31 * result + (this.colorItemsLimit != null ? this.colorItemsLimit.hashCode() : 0);
                result = 31 * result + (this.colorSort != null ? this.colorSort.hashCode() : 0);
                result = 31 * result + (this.smallMultiplesLimitConfiguration != null ? this.smallMultiplesLimitConfiguration.hashCode() : 0);
                result = 31 * result + (this.smallMultiplesSort != null ? this.smallMultiplesSort.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A bar chart.
     * <p>
     * The <code>BarChartVisual</code> structure describes a visual that is a member of the bar chart family. The following charts can be described using this structure:
     * <p>
     * <ul>
     * <li>Horizontal bar chart</li>
     * <li>Vertical bar chart</li>
     * <li>Horizontal stacked bar chart</li>
     * <li>Vertical stacked bar chart</li>
     * <li>Horizontal stacked 100% bar chart</li>
     * <li>Vertical stacked 100% bar chart</li>
     * </ul>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/bar-charts.html">Using bar charts</a> in the <em>Amazon QuickSight User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartvisual.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartvisual.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.BarChartVisualProperty")
    @software.amazon.jsii.Jsii.Proxy(BarChartVisualProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BarChartVisualProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The unique identifier of a visual.
         * <p>
         * This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartvisual.html#cfn-quicksight-analysis-barchartvisual-visualid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartvisual.html#cfn-quicksight-analysis-barchartvisual-visualid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getVisualId();

        /**
         * The list of custom actions that are configured for a visual.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartvisual.html#cfn-quicksight-analysis-barchartvisual-actions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartvisual.html#cfn-quicksight-analysis-barchartvisual-actions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getActions() {
            return null;
        }

        /**
         * The configuration settings of the visual.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartvisual.html#cfn-quicksight-analysis-barchartvisual-chartconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartvisual.html#cfn-quicksight-analysis-barchartvisual-chartconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getChartConfiguration() {
            return null;
        }

        /**
         * The column hierarchy that is used during drill-downs and drill-ups.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartvisual.html#cfn-quicksight-analysis-barchartvisual-columnhierarchies">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartvisual.html#cfn-quicksight-analysis-barchartvisual-columnhierarchies</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getColumnHierarchies() {
            return null;
        }

        /**
         * The subtitle that is displayed on the visual.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartvisual.html#cfn-quicksight-analysis-barchartvisual-subtitle">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartvisual.html#cfn-quicksight-analysis-barchartvisual-subtitle</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSubtitle() {
            return null;
        }

        /**
         * The title that is displayed on the visual.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartvisual.html#cfn-quicksight-analysis-barchartvisual-title">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartvisual.html#cfn-quicksight-analysis-barchartvisual-title</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTitle() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BarChartVisualProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BarChartVisualProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BarChartVisualProperty> {
            java.lang.String visualId;
            java.lang.Object actions;
            java.lang.Object chartConfiguration;
            java.lang.Object columnHierarchies;
            java.lang.Object subtitle;
            java.lang.Object title;

            /**
             * Sets the value of {@link BarChartVisualProperty#getVisualId}
             * @param visualId The unique identifier of a visual. This parameter is required.
             *                 This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder visualId(java.lang.String visualId) {
                this.visualId = visualId;
                return this;
            }

            /**
             * Sets the value of {@link BarChartVisualProperty#getActions}
             * @param actions The list of custom actions that are configured for a visual.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actions(software.amazon.awscdk.IResolvable actions) {
                this.actions = actions;
                return this;
            }

            /**
             * Sets the value of {@link BarChartVisualProperty#getActions}
             * @param actions The list of custom actions that are configured for a visual.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actions(java.util.List<? extends java.lang.Object> actions) {
                this.actions = actions;
                return this;
            }

            /**
             * Sets the value of {@link BarChartVisualProperty#getChartConfiguration}
             * @param chartConfiguration The configuration settings of the visual.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder chartConfiguration(software.amazon.awscdk.IResolvable chartConfiguration) {
                this.chartConfiguration = chartConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link BarChartVisualProperty#getChartConfiguration}
             * @param chartConfiguration The configuration settings of the visual.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder chartConfiguration(software.amazon.awscdk.services.quicksight.CfnAnalysis.BarChartConfigurationProperty chartConfiguration) {
                this.chartConfiguration = chartConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link BarChartVisualProperty#getColumnHierarchies}
             * @param columnHierarchies The column hierarchy that is used during drill-downs and drill-ups.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnHierarchies(software.amazon.awscdk.IResolvable columnHierarchies) {
                this.columnHierarchies = columnHierarchies;
                return this;
            }

            /**
             * Sets the value of {@link BarChartVisualProperty#getColumnHierarchies}
             * @param columnHierarchies The column hierarchy that is used during drill-downs and drill-ups.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnHierarchies(java.util.List<? extends java.lang.Object> columnHierarchies) {
                this.columnHierarchies = columnHierarchies;
                return this;
            }

            /**
             * Sets the value of {@link BarChartVisualProperty#getSubtitle}
             * @param subtitle The subtitle that is displayed on the visual.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subtitle(software.amazon.awscdk.IResolvable subtitle) {
                this.subtitle = subtitle;
                return this;
            }

            /**
             * Sets the value of {@link BarChartVisualProperty#getSubtitle}
             * @param subtitle The subtitle that is displayed on the visual.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subtitle(software.amazon.awscdk.services.quicksight.CfnAnalysis.VisualSubtitleLabelOptionsProperty subtitle) {
                this.subtitle = subtitle;
                return this;
            }

            /**
             * Sets the value of {@link BarChartVisualProperty#getTitle}
             * @param title The title that is displayed on the visual.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder title(software.amazon.awscdk.IResolvable title) {
                this.title = title;
                return this;
            }

            /**
             * Sets the value of {@link BarChartVisualProperty#getTitle}
             * @param title The title that is displayed on the visual.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder title(software.amazon.awscdk.services.quicksight.CfnAnalysis.VisualTitleLabelOptionsProperty title) {
                this.title = title;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BarChartVisualProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BarChartVisualProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BarChartVisualProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BarChartVisualProperty {
            private final java.lang.String visualId;
            private final java.lang.Object actions;
            private final java.lang.Object chartConfiguration;
            private final java.lang.Object columnHierarchies;
            private final java.lang.Object subtitle;
            private final java.lang.Object title;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.visualId = software.amazon.jsii.Kernel.get(this, "visualId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.actions = software.amazon.jsii.Kernel.get(this, "actions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.chartConfiguration = software.amazon.jsii.Kernel.get(this, "chartConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.columnHierarchies = software.amazon.jsii.Kernel.get(this, "columnHierarchies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.subtitle = software.amazon.jsii.Kernel.get(this, "subtitle", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.title = software.amazon.jsii.Kernel.get(this, "title", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.visualId = java.util.Objects.requireNonNull(builder.visualId, "visualId is required");
                this.actions = builder.actions;
                this.chartConfiguration = builder.chartConfiguration;
                this.columnHierarchies = builder.columnHierarchies;
                this.subtitle = builder.subtitle;
                this.title = builder.title;
            }

            @Override
            public final java.lang.String getVisualId() {
                return this.visualId;
            }

            @Override
            public final java.lang.Object getActions() {
                return this.actions;
            }

            @Override
            public final java.lang.Object getChartConfiguration() {
                return this.chartConfiguration;
            }

            @Override
            public final java.lang.Object getColumnHierarchies() {
                return this.columnHierarchies;
            }

            @Override
            public final java.lang.Object getSubtitle() {
                return this.subtitle;
            }

            @Override
            public final java.lang.Object getTitle() {
                return this.title;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("visualId", om.valueToTree(this.getVisualId()));
                if (this.getActions() != null) {
                    data.set("actions", om.valueToTree(this.getActions()));
                }
                if (this.getChartConfiguration() != null) {
                    data.set("chartConfiguration", om.valueToTree(this.getChartConfiguration()));
                }
                if (this.getColumnHierarchies() != null) {
                    data.set("columnHierarchies", om.valueToTree(this.getColumnHierarchies()));
                }
                if (this.getSubtitle() != null) {
                    data.set("subtitle", om.valueToTree(this.getSubtitle()));
                }
                if (this.getTitle() != null) {
                    data.set("title", om.valueToTree(this.getTitle()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.BarChartVisualProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BarChartVisualProperty.Jsii$Proxy that = (BarChartVisualProperty.Jsii$Proxy) o;

                if (!visualId.equals(that.visualId)) return false;
                if (this.actions != null ? !this.actions.equals(that.actions) : that.actions != null) return false;
                if (this.chartConfiguration != null ? !this.chartConfiguration.equals(that.chartConfiguration) : that.chartConfiguration != null) return false;
                if (this.columnHierarchies != null ? !this.columnHierarchies.equals(that.columnHierarchies) : that.columnHierarchies != null) return false;
                if (this.subtitle != null ? !this.subtitle.equals(that.subtitle) : that.subtitle != null) return false;
                return this.title != null ? this.title.equals(that.title) : that.title == null;
            }

            @Override
            public final int hashCode() {
                int result = this.visualId.hashCode();
                result = 31 * result + (this.actions != null ? this.actions.hashCode() : 0);
                result = 31 * result + (this.chartConfiguration != null ? this.chartConfiguration.hashCode() : 0);
                result = 31 * result + (this.columnHierarchies != null ? this.columnHierarchies.hashCode() : 0);
                result = 31 * result + (this.subtitle != null ? this.subtitle.hashCode() : 0);
                result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The options that determine the bin count of a histogram.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * BinCountOptionsProperty binCountOptionsProperty = BinCountOptionsProperty.builder()
     *         .value(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bincountoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bincountoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.BinCountOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(BinCountOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BinCountOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The options that determine the bin count value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bincountoptions.html#cfn-quicksight-analysis-bincountoptions-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bincountoptions.html#cfn-quicksight-analysis-bincountoptions-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BinCountOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BinCountOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BinCountOptionsProperty> {
            java.lang.Number value;

            /**
             * Sets the value of {@link BinCountOptionsProperty#getValue}
             * @param value The options that determine the bin count value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.Number value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BinCountOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BinCountOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BinCountOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BinCountOptionsProperty {
            private final java.lang.Number value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.value = builder.value;
            }

            @Override
            public final java.lang.Number getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.BinCountOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BinCountOptionsProperty.Jsii$Proxy that = (BinCountOptionsProperty.Jsii$Proxy) o;

                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.value != null ? this.value.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The options that determine the bin width of a histogram.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * BinWidthOptionsProperty binWidthOptionsProperty = BinWidthOptionsProperty.builder()
     *         .binCountLimit(123)
     *         .value(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-binwidthoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-binwidthoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.BinWidthOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(BinWidthOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BinWidthOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The options that determine the bin count limit.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-binwidthoptions.html#cfn-quicksight-analysis-binwidthoptions-bincountlimit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-binwidthoptions.html#cfn-quicksight-analysis-binwidthoptions-bincountlimit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBinCountLimit() {
            return null;
        }

        /**
         * The options that determine the bin width value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-binwidthoptions.html#cfn-quicksight-analysis-binwidthoptions-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-binwidthoptions.html#cfn-quicksight-analysis-binwidthoptions-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BinWidthOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BinWidthOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BinWidthOptionsProperty> {
            java.lang.Number binCountLimit;
            java.lang.Number value;

            /**
             * Sets the value of {@link BinWidthOptionsProperty#getBinCountLimit}
             * @param binCountLimit The options that determine the bin count limit.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder binCountLimit(java.lang.Number binCountLimit) {
                this.binCountLimit = binCountLimit;
                return this;
            }

            /**
             * Sets the value of {@link BinWidthOptionsProperty#getValue}
             * @param value The options that determine the bin width value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.Number value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BinWidthOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BinWidthOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BinWidthOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BinWidthOptionsProperty {
            private final java.lang.Number binCountLimit;
            private final java.lang.Number value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.binCountLimit = software.amazon.jsii.Kernel.get(this, "binCountLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.binCountLimit = builder.binCountLimit;
                this.value = builder.value;
            }

            @Override
            public final java.lang.Number getBinCountLimit() {
                return this.binCountLimit;
            }

            @Override
            public final java.lang.Number getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBinCountLimit() != null) {
                    data.set("binCountLimit", om.valueToTree(this.getBinCountLimit()));
                }
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.BinWidthOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BinWidthOptionsProperty.Jsii$Proxy that = (BinWidthOptionsProperty.Jsii$Proxy) o;

                if (this.binCountLimit != null ? !this.binCountLimit.equals(that.binCountLimit) : that.binCountLimit != null) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.binCountLimit != null ? this.binCountLimit.hashCode() : 0;
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration of a body section.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * BodySectionConfigurationProperty bodySectionConfigurationProperty = BodySectionConfigurationProperty.builder()
     *         .content(BodySectionContentProperty.builder()
     *                 .layout(SectionLayoutConfigurationProperty.builder()
     *                         .freeFormLayout(FreeFormSectionLayoutConfigurationProperty.builder()
     *                                 .elements(List.of(FreeFormLayoutElementProperty.builder()
     *                                         .elementId("elementId")
     *                                         .elementType("elementType")
     *                                         .height("height")
     *                                         .width("width")
     *                                         .xAxisLocation("xAxisLocation")
     *                                         .yAxisLocation("yAxisLocation")
     *                                         // the properties below are optional
     *                                         .backgroundStyle(FreeFormLayoutElementBackgroundStyleProperty.builder()
     *                                                 .color("color")
     *                                                 .visibility("visibility")
     *                                                 .build())
     *                                         .borderStyle(FreeFormLayoutElementBorderStyleProperty.builder()
     *                                                 .color("color")
     *                                                 .visibility("visibility")
     *                                                 .build())
     *                                         .loadingAnimation(LoadingAnimationProperty.builder()
     *                                                 .visibility("visibility")
     *                                                 .build())
     *                                         .renderingRules(List.of(SheetElementRenderingRuleProperty.builder()
     *                                                 .configurationOverrides(SheetElementConfigurationOverridesProperty.builder()
     *                                                         .visibility("visibility")
     *                                                         .build())
     *                                                 .expression("expression")
     *                                                 .build()))
     *                                         .selectedBorderStyle(FreeFormLayoutElementBorderStyleProperty.builder()
     *                                                 .color("color")
     *                                                 .visibility("visibility")
     *                                                 .build())
     *                                         .visibility("visibility")
     *                                         .build()))
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .sectionId("sectionId")
     *         // the properties below are optional
     *         .pageBreakConfiguration(SectionPageBreakConfigurationProperty.builder()
     *                 .after(SectionAfterPageBreakProperty.builder()
     *                         .status("status")
     *                         .build())
     *                 .build())
     *         .style(SectionStyleProperty.builder()
     *                 .height("height")
     *                 .padding(SpacingProperty.builder()
     *                         .bottom("bottom")
     *                         .left("left")
     *                         .right("right")
     *                         .top("top")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bodysectionconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bodysectionconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.BodySectionConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(BodySectionConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BodySectionConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The configuration of content in a body section.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bodysectionconfiguration.html#cfn-quicksight-analysis-bodysectionconfiguration-content">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bodysectionconfiguration.html#cfn-quicksight-analysis-bodysectionconfiguration-content</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getContent();

        /**
         * The unique identifier of a body section.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bodysectionconfiguration.html#cfn-quicksight-analysis-bodysectionconfiguration-sectionid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bodysectionconfiguration.html#cfn-quicksight-analysis-bodysectionconfiguration-sectionid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSectionId();

        /**
         * The configuration of a page break for a section.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bodysectionconfiguration.html#cfn-quicksight-analysis-bodysectionconfiguration-pagebreakconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bodysectionconfiguration.html#cfn-quicksight-analysis-bodysectionconfiguration-pagebreakconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPageBreakConfiguration() {
            return null;
        }

        /**
         * The style options of a body section.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bodysectionconfiguration.html#cfn-quicksight-analysis-bodysectionconfiguration-style">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bodysectionconfiguration.html#cfn-quicksight-analysis-bodysectionconfiguration-style</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStyle() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BodySectionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BodySectionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BodySectionConfigurationProperty> {
            java.lang.Object content;
            java.lang.String sectionId;
            java.lang.Object pageBreakConfiguration;
            java.lang.Object style;

            /**
             * Sets the value of {@link BodySectionConfigurationProperty#getContent}
             * @param content The configuration of content in a body section. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder content(software.amazon.awscdk.IResolvable content) {
                this.content = content;
                return this;
            }

            /**
             * Sets the value of {@link BodySectionConfigurationProperty#getContent}
             * @param content The configuration of content in a body section. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder content(software.amazon.awscdk.services.quicksight.CfnAnalysis.BodySectionContentProperty content) {
                this.content = content;
                return this;
            }

            /**
             * Sets the value of {@link BodySectionConfigurationProperty#getSectionId}
             * @param sectionId The unique identifier of a body section. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sectionId(java.lang.String sectionId) {
                this.sectionId = sectionId;
                return this;
            }

            /**
             * Sets the value of {@link BodySectionConfigurationProperty#getPageBreakConfiguration}
             * @param pageBreakConfiguration The configuration of a page break for a section.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pageBreakConfiguration(software.amazon.awscdk.IResolvable pageBreakConfiguration) {
                this.pageBreakConfiguration = pageBreakConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link BodySectionConfigurationProperty#getPageBreakConfiguration}
             * @param pageBreakConfiguration The configuration of a page break for a section.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pageBreakConfiguration(software.amazon.awscdk.services.quicksight.CfnAnalysis.SectionPageBreakConfigurationProperty pageBreakConfiguration) {
                this.pageBreakConfiguration = pageBreakConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link BodySectionConfigurationProperty#getStyle}
             * @param style The style options of a body section.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder style(software.amazon.awscdk.IResolvable style) {
                this.style = style;
                return this;
            }

            /**
             * Sets the value of {@link BodySectionConfigurationProperty#getStyle}
             * @param style The style options of a body section.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder style(software.amazon.awscdk.services.quicksight.CfnAnalysis.SectionStyleProperty style) {
                this.style = style;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BodySectionConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BodySectionConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BodySectionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BodySectionConfigurationProperty {
            private final java.lang.Object content;
            private final java.lang.String sectionId;
            private final java.lang.Object pageBreakConfiguration;
            private final java.lang.Object style;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.content = software.amazon.jsii.Kernel.get(this, "content", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sectionId = software.amazon.jsii.Kernel.get(this, "sectionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.pageBreakConfiguration = software.amazon.jsii.Kernel.get(this, "pageBreakConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.style = software.amazon.jsii.Kernel.get(this, "style", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.content = java.util.Objects.requireNonNull(builder.content, "content is required");
                this.sectionId = java.util.Objects.requireNonNull(builder.sectionId, "sectionId is required");
                this.pageBreakConfiguration = builder.pageBreakConfiguration;
                this.style = builder.style;
            }

            @Override
            public final java.lang.Object getContent() {
                return this.content;
            }

            @Override
            public final java.lang.String getSectionId() {
                return this.sectionId;
            }

            @Override
            public final java.lang.Object getPageBreakConfiguration() {
                return this.pageBreakConfiguration;
            }

            @Override
            public final java.lang.Object getStyle() {
                return this.style;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("content", om.valueToTree(this.getContent()));
                data.set("sectionId", om.valueToTree(this.getSectionId()));
                if (this.getPageBreakConfiguration() != null) {
                    data.set("pageBreakConfiguration", om.valueToTree(this.getPageBreakConfiguration()));
                }
                if (this.getStyle() != null) {
                    data.set("style", om.valueToTree(this.getStyle()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.BodySectionConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BodySectionConfigurationProperty.Jsii$Proxy that = (BodySectionConfigurationProperty.Jsii$Proxy) o;

                if (!content.equals(that.content)) return false;
                if (!sectionId.equals(that.sectionId)) return false;
                if (this.pageBreakConfiguration != null ? !this.pageBreakConfiguration.equals(that.pageBreakConfiguration) : that.pageBreakConfiguration != null) return false;
                return this.style != null ? this.style.equals(that.style) : that.style == null;
            }

            @Override
            public final int hashCode() {
                int result = this.content.hashCode();
                result = 31 * result + (this.sectionId.hashCode());
                result = 31 * result + (this.pageBreakConfiguration != null ? this.pageBreakConfiguration.hashCode() : 0);
                result = 31 * result + (this.style != null ? this.style.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration of content in a body section.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * BodySectionContentProperty bodySectionContentProperty = BodySectionContentProperty.builder()
     *         .layout(SectionLayoutConfigurationProperty.builder()
     *                 .freeFormLayout(FreeFormSectionLayoutConfigurationProperty.builder()
     *                         .elements(List.of(FreeFormLayoutElementProperty.builder()
     *                                 .elementId("elementId")
     *                                 .elementType("elementType")
     *                                 .height("height")
     *                                 .width("width")
     *                                 .xAxisLocation("xAxisLocation")
     *                                 .yAxisLocation("yAxisLocation")
     *                                 // the properties below are optional
     *                                 .backgroundStyle(FreeFormLayoutElementBackgroundStyleProperty.builder()
     *                                         .color("color")
     *                                         .visibility("visibility")
     *                                         .build())
     *                                 .borderStyle(FreeFormLayoutElementBorderStyleProperty.builder()
     *                                         .color("color")
     *                                         .visibility("visibility")
     *                                         .build())
     *                                 .loadingAnimation(LoadingAnimationProperty.builder()
     *                                         .visibility("visibility")
     *                                         .build())
     *                                 .renderingRules(List.of(SheetElementRenderingRuleProperty.builder()
     *                                         .configurationOverrides(SheetElementConfigurationOverridesProperty.builder()
     *                                                 .visibility("visibility")
     *                                                 .build())
     *                                         .expression("expression")
     *                                         .build()))
     *                                 .selectedBorderStyle(FreeFormLayoutElementBorderStyleProperty.builder()
     *                                         .color("color")
     *                                         .visibility("visibility")
     *                                         .build())
     *                                 .visibility("visibility")
     *                                 .build()))
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bodysectioncontent.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bodysectioncontent.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.BodySectionContentProperty")
    @software.amazon.jsii.Jsii.Proxy(BodySectionContentProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BodySectionContentProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The layout configuration of a body section.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bodysectioncontent.html#cfn-quicksight-analysis-bodysectioncontent-layout">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bodysectioncontent.html#cfn-quicksight-analysis-bodysectioncontent-layout</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLayout() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BodySectionContentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BodySectionContentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BodySectionContentProperty> {
            java.lang.Object layout;

            /**
             * Sets the value of {@link BodySectionContentProperty#getLayout}
             * @param layout The layout configuration of a body section.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder layout(software.amazon.awscdk.IResolvable layout) {
                this.layout = layout;
                return this;
            }

            /**
             * Sets the value of {@link BodySectionContentProperty#getLayout}
             * @param layout The layout configuration of a body section.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder layout(software.amazon.awscdk.services.quicksight.CfnAnalysis.SectionLayoutConfigurationProperty layout) {
                this.layout = layout;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BodySectionContentProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BodySectionContentProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BodySectionContentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BodySectionContentProperty {
            private final java.lang.Object layout;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.layout = software.amazon.jsii.Kernel.get(this, "layout", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.layout = builder.layout;
            }

            @Override
            public final java.lang.Object getLayout() {
                return this.layout;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getLayout() != null) {
                    data.set("layout", om.valueToTree(this.getLayout()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.BodySectionContentProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BodySectionContentProperty.Jsii$Proxy that = (BodySectionContentProperty.Jsii$Proxy) o;

                return this.layout != null ? this.layout.equals(that.layout) : that.layout == null;
            }

            @Override
            public final int hashCode() {
                int result = this.layout != null ? this.layout.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The aggregated field well for a box plot.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * BoxPlotAggregatedFieldWellsProperty boxPlotAggregatedFieldWellsProperty = BoxPlotAggregatedFieldWellsProperty.builder()
     *         .groupBy(List.of(DimensionFieldProperty.builder()
     *                 .categoricalDimensionField(CategoricalDimensionFieldProperty.builder()
     *                         .column(ColumnIdentifierProperty.builder()
     *                                 .columnName("columnName")
     *                                 .dataSetIdentifier("dataSetIdentifier")
     *                                 .build())
     *                         .fieldId("fieldId")
     *                         // the properties below are optional
     *                         .formatConfiguration(StringFormatConfigurationProperty.builder()
     *                                 .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
     *                                         .nullString("nullString")
     *                                         .build())
     *                                 .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
     *                                         .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
     *                                                 .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
     *                                                         .decimalPlaces(123)
     *                                                         .build())
     *                                                 .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
     *                                                         .displayMode("displayMode")
     *                                                         .build())
     *                                                 .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
     *                                                         .nullString("nullString")
     *                                                         .build())
     *                                                 .numberScale("numberScale")
     *                                                 .prefix("prefix")
     *                                                 .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
     *                                                         .decimalSeparator("decimalSeparator")
     *                                                         .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
     *                                                                 .symbol("symbol")
     *                                                                 .visibility("visibility")
     *                                                                 .build())
     *                                                         .build())
     *                                                 .suffix("suffix")
     *                                                 .symbol("symbol")
     *                                                 .build())
     *                                         .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
     *                                                 .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
     *                                                         .decimalPlaces(123)
     *                                                         .build())
     *                                                 .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
     *                                                         .displayMode("displayMode")
     *                                                         .build())
     *                                                 .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
     *                                                         .nullString("nullString")
     *                                                         .build())
     *                                                 .numberScale("numberScale")
     *                                                 .prefix("prefix")
     *                                                 .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
     *                                                         .decimalSeparator("decimalSeparator")
     *                                                         .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
     *                                                                 .symbol("symbol")
     *                                                                 .visibility("visibility")
     *                                                                 .build())
     *                                                         .build())
     *                                                 .suffix("suffix")
     *                                                 .build())
     *                                         .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
     *                                                 .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
     *                                                         .decimalPlaces(123)
     *                                                         .build())
     *                                                 .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
     *                                                         .displayMode("displayMode")
     *                                                         .build())
     *                                                 .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
     *                                                         .nullString("nullString")
     *                                                         .build())
     *                                                 .prefix("prefix")
     *                                                 .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
     *                                                         .decimalSeparator("decimalSeparator")
     *                                                         .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
     *                                                                 .symbol("symbol")
     *                                                                 .visibility("visibility")
     *                                                                 .build())
     *                                                         .build())
     *                                                 .suffix("suffix")
     *                                                 .build())
     *                                         .build())
     *                                 .build())
     *                         .hierarchyId("hierarchyId")
     *                         .build())
     *                 .dateDimensionField(DateDimensionFieldProperty.builder()
     *                         .column(ColumnIdentifierProperty.builder()
     *                                 .columnName("columnName")
     *                                 .dataSetIdentifier("dataSetIdentifier")
     *                                 .build())
     *                         .fieldId("fieldId")
     *                         // the properties below are optional
     *                         .dateGranularity("dateGranularity")
     *                         .formatConfiguration(DateTimeFormatConfigurationProperty.builder()
     *                                 .dateTimeFormat("dateTimeFormat")
     *                                 .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
     *                                         .nullString("nullString")
     *                                         .build())
     *                                 .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
     *                                         .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
     *                                                 .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
     *                                                         .decimalPlaces(123)
     *                                                         .build())
     *                                                 .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
     *                                                         .displayMode("displayMode")
     *                                                         .build())
     *                                                 .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
     *                                                         .nullString("nullString")
     *                                                         .build())
     *                                                 .numberScale("numberScale")
     *                                                 .prefix("prefix")
     *                                                 .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
     *                                                         .decimalSeparator("decimalSeparator")
     *                                                         .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
     *                                                                 .symbol("symbol")
     *                                                                 .visibility("visibility")
     *                                                                 .build())
     *                                                         .build())
     *                                                 .suffix("suffix")
     *                                                 .symbol("symbol")
     *                                                 .build())
     *                                         .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
     *                                                 .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
     *                                                         .decimalPlaces(123)
     *                                                         .build())
     *                                                 .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
     *                                                         .displayMode("displayMode")
     *                                                         .build())
     *                                                 .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
     *                                                         .nullString("nullString")
     *                                                         .build())
     *                                                 .numberScale("numberScale")
     *                                                 .prefix("prefix")
     *                                                 .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
     *                                                         .decimalSeparator("decimalSeparator")
     *                                                         .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
     *                                                                 .symbol("symbol")
     *                                                                 .visibility("visibility")
     *                                                                 .build())
     *                                                         .build())
     *                                                 .suffix("suffix")
     *                                                 .build())
     *                                         .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
     *                                                 .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
     *                                                         .decimalPlaces(123)
     *                                                         .build())
     *                                                 .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
     *                                                         .displayMode("displayMode")
     *                                                         .build())
     *                                                 .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
     *                                                         .nullString("nullString")
     *                                                         .build())
     *                                                 .prefix("prefix")
     *                                                 .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
     *                                                         .decimalSeparator("decimalSeparator")
     *                                                         .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
     *                                                                 .symbol("symbol")
     *                                                                 .visibility("visibility")
     *                                                                 .build())
     *                                                         .build())
     *                                                 .suffix("suffix")
     *                                                 .build())
     *                                         .build())
     *                                 .build())
     *                         .hierarchyId("hierarchyId")
     *                         .build())
     *                 .numericalDimensionField(NumericalDimensionFieldProperty.builder()
     *                         .column(ColumnIdentifierProperty.builder()
     *                                 .columnName("columnName")
     *                                 .dataSetIdentifier("dataSetIdentifier")
     *                                 .build())
     *                         .fieldId("fieldId")
     *                         // the properties below are optional
     *                         .formatConfiguration(NumberFormatConfigurationProperty.builder()
     *                                 .formatConfiguration(NumericFormatConfigurationProperty.builder()
     *                                         .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
     *                                                 .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
     *                                                         .decimalPlaces(123)
     *                                                         .build())
     *                                                 .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
     *                                                         .displayMode("displayMode")
     *                                                         .build())
     *                                                 .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
     *                                                         .nullString("nullString")
     *                                                         .build())
     *                                                 .numberScale("numberScale")
     *                                                 .prefix("prefix")
     *                                                 .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
     *                                                         .decimalSeparator("decimalSeparator")
     *                                                         .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
     *                                                                 .symbol("symbol")
     *                                                                 .visibility("visibility")
     *                                                                 .build())
     *                                                         .build())
     *                                                 .suffix("suffix")
     *                                                 .symbol("symbol")
     *                                                 .build())
     *                                         .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
     *                                                 .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
     *                                                         .decimalPlaces(123)
     *                                                         .build())
     *                                                 .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
     *                                                         .displayMode("displayMode")
     *                                                         .build())
     *                                                 .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
     *                                                         .nullString("nullString")
     *                                                         .build())
     *                                                 .numberScale("numberScale")
     *                                                 .prefix("prefix")
     *                                                 .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
     *                                                         .decimalSeparator("decimalSeparator")
     *                                                         .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
     *                                                                 .symbol("symbol")
     *                                                                 .visibility("visibility")
     *                                                                 .build())
     *                                                         .build())
     *                                                 .suffix("suffix")
     *                                                 .build())
     *                                         .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
     *                                                 .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
     *                                                         .decimalPlaces(123)
     *                                                         .build())
     *                                                 .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
     *                                                         .displayMode("displayMode")
     *                                                         .build())
     *                                                 .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
     *                                                         .nullString("nullString")
     *                                                         .build())
     *                                                 .prefix("prefix")
     *                                                 .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
     *                                                         .decimalSeparator("decimalSeparator")
     *                                                         .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
     *                                                                 .symbol("symbol")
     *                                                                 .visibility("visibility")
     *                                                                 .build())
     *                                                         .build())
     *                                                 .suffix("suffix")
     *                                                 .build())
     *                                         .build())
     *                                 .build())
     *                         .hierarchyId("hierarchyId")
     *                         .build())
     *                 .build()))
     *         .values(List.of(MeasureFieldProperty.builder()
     *                 .calculatedMeasureField(CalculatedMeasureFieldProperty.builder()
     *                         .expression("expression")
     *                         .fieldId("fieldId")
     *                         .build())
     *                 .categoricalMeasureField(CategoricalMeasureFieldProperty.builder()
     *                         .column(ColumnIdentifierProperty.builder()
     *                                 .columnName("columnName")
     *                                 .dataSetIdentifier("dataSetIdentifier")
     *                                 .build())
     *                         .fieldId("fieldId")
     *                         // the properties below are optional
     *                         .aggregationFunction("aggregationFunction")
     *                         .formatConfiguration(StringFormatConfigurationProperty.builder()
     *                                 .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
     *                                         .nullString("nullString")
     *                                         .build())
     *                                 .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
     *                                         .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
     *                                                 .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
     *                                                         .decimalPlaces(123)
     *                                                         .build())
     *                                                 .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
     *                                                         .displayMode("displayMode")
     *                                                         .build())
     *                                                 .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
     *                                                         .nullString("nullString")
     *                                                         .build())
     *                                                 .numberScale("numberScale")
     *                                                 .prefix("prefix")
     *                                                 .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
     *                                                         .decimalSeparator("decimalSeparator")
     *                                                         .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
     *                                                                 .symbol("symbol")
     *                                                                 .visibility("visibility")
     *                                                                 .build())
     *                                                         .build())
     *                                                 .suffix("suffix")
     *                                                 .symbol("symbol")
     *                                                 .build())
     *                                         .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
     *                                                 .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
     *                                                         .decimalPlaces(123)
     *                                                         .build())
     *                                                 .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
     *                                                         .displayMode("displayMode")
     *                                                         .build())
     *                                                 .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
     *                                                         .nullString("nullString")
     *                                                         .build())
     *                                                 .numberScale("numberScale")
     *                                                 .prefix("prefix")
     *                                                 .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
     *                                                         .decimalSeparator("decimalSeparator")
     *                                                         .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
     *                                                                 .symbol("symbol")
     *                                                                 .visibility("visibility")
     *                                                                 .build())
     *                                                         .build())
     *                                                 .suffix("suffix")
     *                                                 .build())
     *                                         .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
     *                                                 .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
     *                                                         .decimalPlaces(123)
     *                                                         .build())
     *                                                 .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
     *                                                         .displayMode("displayMode")
     *                                                         .build())
     *                                                 .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
     *                                                         .nullString("nullString")
     *                                                         .build())
     *                                                 .prefix("prefix")
     *                                                 .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
     *                                                         .decimalSeparator("decimalSeparator")
     *                                                         .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
     *                                                                 .symbol("symbol")
     *                                                                 .visibility("visibility")
     *                                                                 .build())
     *                                                         .build())
     *                                                 .suffix("suffix")
     *                                                 .build())
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 .dateMeasureField(DateMeasureFieldProperty.builder()
     *                         .column(ColumnIdentifierProperty.builder()
     *                                 .columnName("columnName")
     *                                 .dataSetIdentifier("dataSetIdentifier")
     *                                 .build())
     *                         .fieldId("fieldId")
     *                         // the properties below are optional
     *                         .aggregationFunction("aggregationFunction")
     *                         .formatConfiguration(DateTimeFormatConfigurationProperty.builder()
     *                                 .dateTimeFormat("dateTimeFormat")
     *                                 .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
     *                                         .nullString("nullString")
     *                                         .build())
     *                                 .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
     *                                         .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
     *                                                 .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
     *                                                         .decimalPlaces(123)
     *                                                         .build())
     *                                                 .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
     *                                                         .displayMode("displayMode")
     *                                                         .build())
     *                                                 .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
     *                                                         .nullString("nullString")
     *                                                         .build())
     *                                                 .numberScale("numberScale")
     *                                                 .prefix("prefix")
     *                                                 .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
     *                                                         .decimalSeparator("decimalSeparator")
     *                                                         .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
     *                                                                 .symbol("symbol")
     *                                                                 .visibility("visibility")
     *                                                                 .build())
     *                                                         .build())
     *                                                 .suffix("suffix")
     *                                                 .symbol("symbol")
     *                                                 .build())
     *                                         .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
     *                                                 .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
     *                                                         .decimalPlaces(123)
     *                                                         .build())
     *                                                 .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
     *                                                         .displayMode("displayMode")
     *                                                         .build())
     *                                                 .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
     *                                                         .nullString("nullString")
     *                                                         .build())
     *                                                 .numberScale("numberScale")
     *                                                 .prefix("prefix")
     *                                                 .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
     *                                                         .decimalSeparator("decimalSeparator")
     *                                                         .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
     *                                                                 .symbol("symbol")
     *                                                                 .visibility("visibility")
     *                                                                 .build())
     *                                                         .build())
     *                                                 .suffix("suffix")
     *                                                 .build())
     *                                         .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
     *                                                 .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
     *                                                         .decimalPlaces(123)
     *                                                         .build())
     *                                                 .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
     *                                                         .displayMode("displayMode")
     *                                                         .build())
     *                                                 .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
     *                                                         .nullString("nullString")
     *                                                         .build())
     *                                                 .prefix("prefix")
     *                                                 .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
     *                                                         .decimalSeparator("decimalSeparator")
     *                                                         .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
     *                                                                 .symbol("symbol")
     *                                                                 .visibility("visibility")
     *                                                                 .build())
     *                                                         .build())
     *                                                 .suffix("suffix")
     *                                                 .build())
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 .numericalMeasureField(NumericalMeasureFieldProperty.builder()
     *                         .column(ColumnIdentifierProperty.builder()
     *                                 .columnName("columnName")
     *                                 .dataSetIdentifier("dataSetIdentifier")
     *                                 .build())
     *                         .fieldId("fieldId")
     *                         // the properties below are optional
     *                         .aggregationFunction(NumericalAggregationFunctionProperty.builder()
     *                                 .percentileAggregation(PercentileAggregationProperty.builder()
     *                                         .percentileValue(123)
     *                                         .build())
     *                                 .simpleNumericalAggregation("simpleNumericalAggregation")
     *                                 .build())
     *                         .formatConfiguration(NumberFormatConfigurationProperty.builder()
     *                                 .formatConfiguration(NumericFormatConfigurationProperty.builder()
     *                                         .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
     *                                                 .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
     *                                                         .decimalPlaces(123)
     *                                                         .build())
     *                                                 .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
     *                                                         .displayMode("displayMode")
     *                                                         .build())
     *                                                 .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
     *                                                         .nullString("nullString")
     *                                                         .build())
     *                                                 .numberScale("numberScale")
     *                                                 .prefix("prefix")
     *                                                 .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
     *                                                         .decimalSeparator("decimalSeparator")
     *                                                         .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
     *                                                                 .symbol("symbol")
     *                                                                 .visibility("visibility")
     *                                                                 .build())
     *                                                         .build())
     *                                                 .suffix("suffix")
     *                                                 .symbol("symbol")
     *                                                 .build())
     *                                         .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
     *                                                 .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
     *                                                         .decimalPlaces(123)
     *                                                         .build())
     *                                                 .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
     *                                                         .displayMode("displayMode")
     *                                                         .build())
     *                                                 .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
     *                                                         .nullString("nullString")
     *                                                         .build())
     *                                                 .numberScale("numberScale")
     *                                                 .prefix("prefix")
     *                                                 .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
     *                                                         .decimalSeparator("decimalSeparator")
     *                                                         .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
     *                                                                 .symbol("symbol")
     *                                                                 .visibility("visibility")
     *                                                                 .build())
     *                                                         .build())
     *                                                 .suffix("suffix")
     *                                                 .build())
     *                                         .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
     *                                                 .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
     *                                                         .decimalPlaces(123)
     *                                                         .build())
     *                                                 .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
     *                                                         .displayMode("displayMode")
     *                                                         .build())
     *                                                 .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
     *                                                         .nullString("nullString")
     *                                                         .build())
     *                                                 .prefix("prefix")
     *                                                 .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
     *                                                         .decimalSeparator("decimalSeparator")
     *                                                         .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
     *                                                                 .symbol("symbol")
     *                                                                 .visibility("visibility")
     *                                                                 .build())
     *                                                         .build())
     *                                                 .suffix("suffix")
     *                                                 .build())
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotaggregatedfieldwells.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotaggregatedfieldwells.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.BoxPlotAggregatedFieldWellsProperty")
    @software.amazon.jsii.Jsii.Proxy(BoxPlotAggregatedFieldWellsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BoxPlotAggregatedFieldWellsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The group by field well of a box plot chart.
         * <p>
         * Values are grouped based on group by fields.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotaggregatedfieldwells.html#cfn-quicksight-analysis-boxplotaggregatedfieldwells-groupby">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotaggregatedfieldwells.html#cfn-quicksight-analysis-boxplotaggregatedfieldwells-groupby</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGroupBy() {
            return null;
        }

        /**
         * The value field well of a box plot chart.
         * <p>
         * Values are aggregated based on group by fields.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotaggregatedfieldwells.html#cfn-quicksight-analysis-boxplotaggregatedfieldwells-values">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotaggregatedfieldwells.html#cfn-quicksight-analysis-boxplotaggregatedfieldwells-values</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getValues() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BoxPlotAggregatedFieldWellsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BoxPlotAggregatedFieldWellsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BoxPlotAggregatedFieldWellsProperty> {
            java.lang.Object groupBy;
            java.lang.Object values;

            /**
             * Sets the value of {@link BoxPlotAggregatedFieldWellsProperty#getGroupBy}
             * @param groupBy The group by field well of a box plot chart.
             *                Values are grouped based on group by fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groupBy(software.amazon.awscdk.IResolvable groupBy) {
                this.groupBy = groupBy;
                return this;
            }

            /**
             * Sets the value of {@link BoxPlotAggregatedFieldWellsProperty#getGroupBy}
             * @param groupBy The group by field well of a box plot chart.
             *                Values are grouped based on group by fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groupBy(java.util.List<? extends java.lang.Object> groupBy) {
                this.groupBy = groupBy;
                return this;
            }

            /**
             * Sets the value of {@link BoxPlotAggregatedFieldWellsProperty#getValues}
             * @param values The value field well of a box plot chart.
             *               Values are aggregated based on group by fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder values(software.amazon.awscdk.IResolvable values) {
                this.values = values;
                return this;
            }

            /**
             * Sets the value of {@link BoxPlotAggregatedFieldWellsProperty#getValues}
             * @param values The value field well of a box plot chart.
             *               Values are aggregated based on group by fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder values(java.util.List<? extends java.lang.Object> values) {
                this.values = values;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BoxPlotAggregatedFieldWellsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BoxPlotAggregatedFieldWellsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BoxPlotAggregatedFieldWellsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BoxPlotAggregatedFieldWellsProperty {
            private final java.lang.Object groupBy;
            private final java.lang.Object values;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.groupBy = software.amazon.jsii.Kernel.get(this, "groupBy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.values = software.amazon.jsii.Kernel.get(this, "values", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.groupBy = builder.groupBy;
                this.values = builder.values;
            }

            @Override
            public final java.lang.Object getGroupBy() {
                return this.groupBy;
            }

            @Override
            public final java.lang.Object getValues() {
                return this.values;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getGroupBy() != null) {
                    data.set("groupBy", om.valueToTree(this.getGroupBy()));
                }
                if (this.getValues() != null) {
                    data.set("values", om.valueToTree(this.getValues()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.BoxPlotAggregatedFieldWellsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BoxPlotAggregatedFieldWellsProperty.Jsii$Proxy that = (BoxPlotAggregatedFieldWellsProperty.Jsii$Proxy) o;

                if (this.groupBy != null ? !this.groupBy.equals(that.groupBy) : that.groupBy != null) return false;
                return this.values != null ? this.values.equals(that.values) : that.values == null;
            }

            @Override
            public final int hashCode() {
                int result = this.groupBy != null ? this.groupBy.hashCode() : 0;
                result = 31 * result + (this.values != null ? this.values.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration of a <code>BoxPlotVisual</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotchartconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotchartconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.BoxPlotChartConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(BoxPlotChartConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BoxPlotChartConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The box plot chart options for a box plot visual.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotchartconfiguration.html#cfn-quicksight-analysis-boxplotchartconfiguration-boxplotoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotchartconfiguration.html#cfn-quicksight-analysis-boxplotchartconfiguration-boxplotoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBoxPlotOptions() {
            return null;
        }

        /**
         * The label display options (grid line, range, scale, axis step) of a box plot category.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotchartconfiguration.html#cfn-quicksight-analysis-boxplotchartconfiguration-categoryaxis">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotchartconfiguration.html#cfn-quicksight-analysis-boxplotchartconfiguration-categoryaxis</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCategoryAxis() {
            return null;
        }

        /**
         * The label options (label text, label visibility and sort Icon visibility) of a box plot category.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotchartconfiguration.html#cfn-quicksight-analysis-boxplotchartconfiguration-categorylabeloptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotchartconfiguration.html#cfn-quicksight-analysis-boxplotchartconfiguration-categorylabeloptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCategoryLabelOptions() {
            return null;
        }

        /**
         * The field wells of the visual.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotchartconfiguration.html#cfn-quicksight-analysis-boxplotchartconfiguration-fieldwells">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotchartconfiguration.html#cfn-quicksight-analysis-boxplotchartconfiguration-fieldwells</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFieldWells() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotchartconfiguration.html#cfn-quicksight-analysis-boxplotchartconfiguration-legend">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotchartconfiguration.html#cfn-quicksight-analysis-boxplotchartconfiguration-legend</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLegend() {
            return null;
        }

        /**
         * The label display options (grid line, range, scale, axis step) of a box plot category.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotchartconfiguration.html#cfn-quicksight-analysis-boxplotchartconfiguration-primaryyaxisdisplayoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotchartconfiguration.html#cfn-quicksight-analysis-boxplotchartconfiguration-primaryyaxisdisplayoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPrimaryYAxisDisplayOptions() {
            return null;
        }

        /**
         * The label options (label text, label visibility and sort icon visibility) of a box plot value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotchartconfiguration.html#cfn-quicksight-analysis-boxplotchartconfiguration-primaryyaxislabeloptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotchartconfiguration.html#cfn-quicksight-analysis-boxplotchartconfiguration-primaryyaxislabeloptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPrimaryYAxisLabelOptions() {
            return null;
        }

        /**
         * The reference line setup of the visual.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotchartconfiguration.html#cfn-quicksight-analysis-boxplotchartconfiguration-referencelines">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotchartconfiguration.html#cfn-quicksight-analysis-boxplotchartconfiguration-referencelines</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getReferenceLines() {
            return null;
        }

        /**
         * The sort configuration of a <code>BoxPlotVisual</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotchartconfiguration.html#cfn-quicksight-analysis-boxplotchartconfiguration-sortconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotchartconfiguration.html#cfn-quicksight-analysis-boxplotchartconfiguration-sortconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSortConfiguration() {
            return null;
        }

        /**
         * The tooltip display setup of the visual.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotchartconfiguration.html#cfn-quicksight-analysis-boxplotchartconfiguration-tooltip">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotchartconfiguration.html#cfn-quicksight-analysis-boxplotchartconfiguration-tooltip</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTooltip() {
            return null;
        }

        /**
         * The palette (chart color) display setup of the visual.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotchartconfiguration.html#cfn-quicksight-analysis-boxplotchartconfiguration-visualpalette">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotchartconfiguration.html#cfn-quicksight-analysis-boxplotchartconfiguration-visualpalette</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVisualPalette() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BoxPlotChartConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BoxPlotChartConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BoxPlotChartConfigurationProperty> {
            java.lang.Object boxPlotOptions;
            java.lang.Object categoryAxis;
            java.lang.Object categoryLabelOptions;
            java.lang.Object fieldWells;
            java.lang.Object legend;
            java.lang.Object primaryYAxisDisplayOptions;
            java.lang.Object primaryYAxisLabelOptions;
            java.lang.Object referenceLines;
            java.lang.Object sortConfiguration;
            java.lang.Object tooltip;
            java.lang.Object visualPalette;

            /**
             * Sets the value of {@link BoxPlotChartConfigurationProperty#getBoxPlotOptions}
             * @param boxPlotOptions The box plot chart options for a box plot visual.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder boxPlotOptions(software.amazon.awscdk.IResolvable boxPlotOptions) {
                this.boxPlotOptions = boxPlotOptions;
                return this;
            }

            /**
             * Sets the value of {@link BoxPlotChartConfigurationProperty#getBoxPlotOptions}
             * @param boxPlotOptions The box plot chart options for a box plot visual.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder boxPlotOptions(software.amazon.awscdk.services.quicksight.CfnAnalysis.BoxPlotOptionsProperty boxPlotOptions) {
                this.boxPlotOptions = boxPlotOptions;
                return this;
            }

            /**
             * Sets the value of {@link BoxPlotChartConfigurationProperty#getCategoryAxis}
             * @param categoryAxis The label display options (grid line, range, scale, axis step) of a box plot category.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder categoryAxis(software.amazon.awscdk.IResolvable categoryAxis) {
                this.categoryAxis = categoryAxis;
                return this;
            }

            /**
             * Sets the value of {@link BoxPlotChartConfigurationProperty#getCategoryAxis}
             * @param categoryAxis The label display options (grid line, range, scale, axis step) of a box plot category.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder categoryAxis(software.amazon.awscdk.services.quicksight.CfnAnalysis.AxisDisplayOptionsProperty categoryAxis) {
                this.categoryAxis = categoryAxis;
                return this;
            }

            /**
             * Sets the value of {@link BoxPlotChartConfigurationProperty#getCategoryLabelOptions}
             * @param categoryLabelOptions The label options (label text, label visibility and sort Icon visibility) of a box plot category.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder categoryLabelOptions(software.amazon.awscdk.IResolvable categoryLabelOptions) {
                this.categoryLabelOptions = categoryLabelOptions;
                return this;
            }

            /**
             * Sets the value of {@link BoxPlotChartConfigurationProperty#getCategoryLabelOptions}
             * @param categoryLabelOptions The label options (label text, label visibility and sort Icon visibility) of a box plot category.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder categoryLabelOptions(software.amazon.awscdk.services.quicksight.CfnAnalysis.ChartAxisLabelOptionsProperty categoryLabelOptions) {
                this.categoryLabelOptions = categoryLabelOptions;
                return this;
            }

            /**
             * Sets the value of {@link BoxPlotChartConfigurationProperty#getFieldWells}
             * @param fieldWells The field wells of the visual.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldWells(software.amazon.awscdk.IResolvable fieldWells) {
                this.fieldWells = fieldWells;
                return this;
            }

            /**
             * Sets the value of {@link BoxPlotChartConfigurationProperty#getFieldWells}
             * @param fieldWells The field wells of the visual.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldWells(software.amazon.awscdk.services.quicksight.CfnAnalysis.BoxPlotFieldWellsProperty fieldWells) {
                this.fieldWells = fieldWells;
                return this;
            }

            /**
             * Sets the value of {@link BoxPlotChartConfigurationProperty#getLegend}
             * @param legend the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder legend(software.amazon.awscdk.IResolvable legend) {
                this.legend = legend;
                return this;
            }

            /**
             * Sets the value of {@link BoxPlotChartConfigurationProperty#getLegend}
             * @param legend the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder legend(software.amazon.awscdk.services.quicksight.CfnAnalysis.LegendOptionsProperty legend) {
                this.legend = legend;
                return this;
            }

            /**
             * Sets the value of {@link BoxPlotChartConfigurationProperty#getPrimaryYAxisDisplayOptions}
             * @param primaryYAxisDisplayOptions The label display options (grid line, range, scale, axis step) of a box plot category.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder primaryYAxisDisplayOptions(software.amazon.awscdk.IResolvable primaryYAxisDisplayOptions) {
                this.primaryYAxisDisplayOptions = primaryYAxisDisplayOptions;
                return this;
            }

            /**
             * Sets the value of {@link BoxPlotChartConfigurationProperty#getPrimaryYAxisDisplayOptions}
             * @param primaryYAxisDisplayOptions The label display options (grid line, range, scale, axis step) of a box plot category.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder primaryYAxisDisplayOptions(software.amazon.awscdk.services.quicksight.CfnAnalysis.AxisDisplayOptionsProperty primaryYAxisDisplayOptions) {
                this.primaryYAxisDisplayOptions = primaryYAxisDisplayOptions;
                return this;
            }

            /**
             * Sets the value of {@link BoxPlotChartConfigurationProperty#getPrimaryYAxisLabelOptions}
             * @param primaryYAxisLabelOptions The label options (label text, label visibility and sort icon visibility) of a box plot value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder primaryYAxisLabelOptions(software.amazon.awscdk.IResolvable primaryYAxisLabelOptions) {
                this.primaryYAxisLabelOptions = primaryYAxisLabelOptions;
                return this;
            }

            /**
             * Sets the value of {@link BoxPlotChartConfigurationProperty#getPrimaryYAxisLabelOptions}
             * @param primaryYAxisLabelOptions The label options (label text, label visibility and sort icon visibility) of a box plot value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder primaryYAxisLabelOptions(software.amazon.awscdk.services.quicksight.CfnAnalysis.ChartAxisLabelOptionsProperty primaryYAxisLabelOptions) {
                this.primaryYAxisLabelOptions = primaryYAxisLabelOptions;
                return this;
            }

            /**
             * Sets the value of {@link BoxPlotChartConfigurationProperty#getReferenceLines}
             * @param referenceLines The reference line setup of the visual.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder referenceLines(software.amazon.awscdk.IResolvable referenceLines) {
                this.referenceLines = referenceLines;
                return this;
            }

            /**
             * Sets the value of {@link BoxPlotChartConfigurationProperty#getReferenceLines}
             * @param referenceLines The reference line setup of the visual.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder referenceLines(java.util.List<? extends java.lang.Object> referenceLines) {
                this.referenceLines = referenceLines;
                return this;
            }

            /**
             * Sets the value of {@link BoxPlotChartConfigurationProperty#getSortConfiguration}
             * @param sortConfiguration The sort configuration of a <code>BoxPlotVisual</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sortConfiguration(software.amazon.awscdk.IResolvable sortConfiguration) {
                this.sortConfiguration = sortConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link BoxPlotChartConfigurationProperty#getSortConfiguration}
             * @param sortConfiguration The sort configuration of a <code>BoxPlotVisual</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sortConfiguration(software.amazon.awscdk.services.quicksight.CfnAnalysis.BoxPlotSortConfigurationProperty sortConfiguration) {
                this.sortConfiguration = sortConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link BoxPlotChartConfigurationProperty#getTooltip}
             * @param tooltip The tooltip display setup of the visual.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tooltip(software.amazon.awscdk.IResolvable tooltip) {
                this.tooltip = tooltip;
                return this;
            }

            /**
             * Sets the value of {@link BoxPlotChartConfigurationProperty#getTooltip}
             * @param tooltip The tooltip display setup of the visual.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tooltip(software.amazon.awscdk.services.quicksight.CfnAnalysis.TooltipOptionsProperty tooltip) {
                this.tooltip = tooltip;
                return this;
            }

            /**
             * Sets the value of {@link BoxPlotChartConfigurationProperty#getVisualPalette}
             * @param visualPalette The palette (chart color) display setup of the visual.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder visualPalette(software.amazon.awscdk.IResolvable visualPalette) {
                this.visualPalette = visualPalette;
                return this;
            }

            /**
             * Sets the value of {@link BoxPlotChartConfigurationProperty#getVisualPalette}
             * @param visualPalette The palette (chart color) display setup of the visual.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder visualPalette(software.amazon.awscdk.services.quicksight.CfnAnalysis.VisualPaletteProperty visualPalette) {
                this.visualPalette = visualPalette;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BoxPlotChartConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BoxPlotChartConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BoxPlotChartConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BoxPlotChartConfigurationProperty {
            private final java.lang.Object boxPlotOptions;
            private final java.lang.Object categoryAxis;
            private final java.lang.Object categoryLabelOptions;
            private final java.lang.Object fieldWells;
            private final java.lang.Object legend;
            private final java.lang.Object primaryYAxisDisplayOptions;
            private final java.lang.Object primaryYAxisLabelOptions;
            private final java.lang.Object referenceLines;
            private final java.lang.Object sortConfiguration;
            private final java.lang.Object tooltip;
            private final java.lang.Object visualPalette;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.boxPlotOptions = software.amazon.jsii.Kernel.get(this, "boxPlotOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.categoryAxis = software.amazon.jsii.Kernel.get(this, "categoryAxis", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.categoryLabelOptions = software.amazon.jsii.Kernel.get(this, "categoryLabelOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.fieldWells = software.amazon.jsii.Kernel.get(this, "fieldWells", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.legend = software.amazon.jsii.Kernel.get(this, "legend", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.primaryYAxisDisplayOptions = software.amazon.jsii.Kernel.get(this, "primaryYAxisDisplayOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.primaryYAxisLabelOptions = software.amazon.jsii.Kernel.get(this, "primaryYAxisLabelOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.referenceLines = software.amazon.jsii.Kernel.get(this, "referenceLines", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sortConfiguration = software.amazon.jsii.Kernel.get(this, "sortConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.tooltip = software.amazon.jsii.Kernel.get(this, "tooltip", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.visualPalette = software.amazon.jsii.Kernel.get(this, "visualPalette", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.boxPlotOptions = builder.boxPlotOptions;
                this.categoryAxis = builder.categoryAxis;
                this.categoryLabelOptions = builder.categoryLabelOptions;
                this.fieldWells = builder.fieldWells;
                this.legend = builder.legend;
                this.primaryYAxisDisplayOptions = builder.primaryYAxisDisplayOptions;
                this.primaryYAxisLabelOptions = builder.primaryYAxisLabelOptions;
                this.referenceLines = builder.referenceLines;
                this.sortConfiguration = builder.sortConfiguration;
                this.tooltip = builder.tooltip;
                this.visualPalette = builder.visualPalette;
            }

            @Override
            public final java.lang.Object getBoxPlotOptions() {
                return this.boxPlotOptions;
            }

            @Override
            public final java.lang.Object getCategoryAxis() {
                return this.categoryAxis;
            }

            @Override
            public final java.lang.Object getCategoryLabelOptions() {
                return this.categoryLabelOptions;
            }

            @Override
            public final java.lang.Object getFieldWells() {
                return this.fieldWells;
            }

            @Override
            public final java.lang.Object getLegend() {
                return this.legend;
            }

            @Override
            public final java.lang.Object getPrimaryYAxisDisplayOptions() {
                return this.primaryYAxisDisplayOptions;
            }

            @Override
            public final java.lang.Object getPrimaryYAxisLabelOptions() {
                return this.primaryYAxisLabelOptions;
            }

            @Override
            public final java.lang.Object getReferenceLines() {
                return this.referenceLines;
            }

            @Override
            public final java.lang.Object getSortConfiguration() {
                return this.sortConfiguration;
            }

            @Override
            public final java.lang.Object getTooltip() {
                return this.tooltip;
            }

            @Override
            public final java.lang.Object getVisualPalette() {
                return this.visualPalette;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBoxPlotOptions() != null) {
                    data.set("boxPlotOptions", om.valueToTree(this.getBoxPlotOptions()));
                }
                if (this.getCategoryAxis() != null) {
                    data.set("categoryAxis", om.valueToTree(this.getCategoryAxis()));
                }
                if (this.getCategoryLabelOptions() != null) {
                    data.set("categoryLabelOptions", om.valueToTree(this.getCategoryLabelOptions()));
                }
                if (this.getFieldWells() != null) {
                    data.set("fieldWells", om.valueToTree(this.getFieldWells()));
                }
                if (this.getLegend() != null) {
                    data.set("legend", om.valueToTree(this.getLegend()));
                }
                if (this.getPrimaryYAxisDisplayOptions() != null) {
                    data.set("primaryYAxisDisplayOptions", om.valueToTree(this.getPrimaryYAxisDisplayOptions()));
                }
                if (this.getPrimaryYAxisLabelOptions() != null) {
                    data.set("primaryYAxisLabelOptions", om.valueToTree(this.getPrimaryYAxisLabelOptions()));
                }
                if (this.getReferenceLines() != null) {
                    data.set("referenceLines", om.valueToTree(this.getReferenceLines()));
                }
                if (this.getSortConfiguration() != null) {
                    data.set("sortConfiguration", om.valueToTree(this.getSortConfiguration()));
                }
                if (this.getTooltip() != null) {
                    data.set("tooltip", om.valueToTree(this.getTooltip()));
                }
                if (this.getVisualPalette() != null) {
                    data.set("visualPalette", om.valueToTree(this.getVisualPalette()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.BoxPlotChartConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BoxPlotChartConfigurationProperty.Jsii$Proxy that = (BoxPlotChartConfigurationProperty.Jsii$Proxy) o;

                if (this.boxPlotOptions != null ? !this.boxPlotOptions.equals(that.boxPlotOptions) : that.boxPlotOptions != null) return false;
                if (this.categoryAxis != null ? !this.categoryAxis.equals(that.categoryAxis) : that.categoryAxis != null) return false;
                if (this.categoryLabelOptions != null ? !this.categoryLabelOptions.equals(that.categoryLabelOptions) : that.categoryLabelOptions != null) return false;
                if (this.fieldWells != null ? !this.fieldWells.equals(that.fieldWells) : that.fieldWells != null) return false;
                if (this.legend != null ? !this.legend.equals(that.legend) : that.legend != null) return false;
                if (this.primaryYAxisDisplayOptions != null ? !this.primaryYAxisDisplayOptions.equals(that.primaryYAxisDisplayOptions) : that.primaryYAxisDisplayOptions != null) return false;
                if (this.primaryYAxisLabelOptions != null ? !this.primaryYAxisLabelOptions.equals(that.primaryYAxisLabelOptions) : that.primaryYAxisLabelOptions != null) return false;
                if (this.referenceLines != null ? !this.referenceLines.equals(that.referenceLines) : that.referenceLines != null) return false;
                if (this.sortConfiguration != null ? !this.sortConfiguration.equals(that.sortConfiguration) : that.sortConfiguration != null) return false;
                if (this.tooltip != null ? !this.tooltip.equals(that.tooltip) : that.tooltip != null) return false;
                return this.visualPalette != null ? this.visualPalette.equals(that.visualPalette) : that.visualPalette == null;
            }

            @Override
            public final int hashCode() {
                int result = this.boxPlotOptions != null ? this.boxPlotOptions.hashCode() : 0;
                result = 31 * result + (this.categoryAxis != null ? this.categoryAxis.hashCode() : 0);
                result = 31 * result + (this.categoryLabelOptions != null ? this.categoryLabelOptions.hashCode() : 0);
                result = 31 * result + (this.fieldWells != null ? this.fieldWells.hashCode() : 0);
                result = 31 * result + (this.legend != null ? this.legend.hashCode() : 0);
                result = 31 * result + (this.primaryYAxisDisplayOptions != null ? this.primaryYAxisDisplayOptions.hashCode() : 0);
                result = 31 * result + (this.primaryYAxisLabelOptions != null ? this.primaryYAxisLabelOptions.hashCode() : 0);
                result = 31 * result + (this.referenceLines != null ? this.referenceLines.hashCode() : 0);
                result = 31 * result + (this.sortConfiguration != null ? this.sortConfiguration.hashCode() : 0);
                result = 31 * result + (this.tooltip != null ? this.tooltip.hashCode() : 0);
                result = 31 * result + (this.visualPalette != null ? this.visualPalette.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The field wells of a <code>BoxPlotVisual</code> .
     * <p>
     * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * BoxPlotFieldWellsProperty boxPlotFieldWellsProperty = BoxPlotFieldWellsProperty.builder()
     *         .boxPlotAggregatedFieldWells(BoxPlotAggregatedFieldWellsProperty.builder()
     *                 .groupBy(List.of(DimensionFieldProperty.builder()
     *                         .categoricalDimensionField(CategoricalDimensionFieldProperty.builder()
     *                                 .column(ColumnIdentifierProperty.builder()
     *                                         .columnName("columnName")
     *                                         .dataSetIdentifier("dataSetIdentifier")
     *                                         .build())
     *                                 .fieldId("fieldId")
     *                                 // the properties below are optional
     *                                 .formatConfiguration(StringFormatConfigurationProperty.builder()
     *                                         .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
     *                                                 .nullString("nullString")
     *                                                 .build())
     *                                         .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
     *                                                 .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
     *                                                         .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
     *                                                                 .decimalPlaces(123)
     *                                                                 .build())
     *                                                         .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
     *                                                                 .displayMode("displayMode")
     *                                                                 .build())
     *                                                         .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
     *                                                                 .nullString("nullString")
     *                                                                 .build())
     *                                                         .numberScale("numberScale")
     *                                                         .prefix("prefix")
     *                                                         .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
     *                                                                 .decimalSeparator("decimalSeparator")
     *                                                                 .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
     *                                                                         .symbol("symbol")
     *                                                                         .visibility("visibility")
     *                                                                         .build())
     *                                                                 .build())
     *                                                         .suffix("suffix")
     *                                                         .symbol("symbol")
     *                                                         .build())
     *                                                 .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
     *                                                         .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
     *                                                                 .decimalPlaces(123)
     *                                                                 .build())
     *                                                         .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
     *                                                                 .displayMode("displayMode")
     *                                                                 .build())
     *                                                         .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
     *                                                                 .nullString("nullString")
     *                                                                 .build())
     *                                                         .numberScale("numberScale")
     *                                                         .prefix("prefix")
     *                                                         .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
     *                                                                 .decimalSeparator("decimalSeparator")
     *                                                                 .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
     *                                                                         .symbol("symbol")
     *                                                                         .visibility("visibility")
     *                                                                         .build())
     *                                                                 .build())
     *                                                         .suffix("suffix")
     *                                                         .build())
     *                                                 .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
     *                                                         .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
     *                                                                 .decimalPlaces(123)
     *                                                                 .build())
     *                                                         .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
     *                                                                 .displayMode("displayMode")
     *                                                                 .build())
     *                                                         .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
     *                                                                 .nullString("nullString")
     *                                                                 .build())
     *                                                         .prefix("prefix")
     *                                                         .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
     *                                                                 .decimalSeparator("decimalSeparator")
     *                                                                 .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
     *                                                                         .symbol("symbol")
     *                                                                         .visibility("visibility")
     *                                                                         .build())
     *                                                                 .build())
     *                                                         .suffix("suffix")
     *                                                         .build())
     *                                                 .build())
     *                                         .build())
     *                                 .hierarchyId("hierarchyId")
     *                                 .build())
     *                         .dateDimensionField(DateDimensionFieldProperty.builder()
     *                                 .column(ColumnIdentifierProperty.builder()
     *                                         .columnName("columnName")
     *                                         .dataSetIdentifier("dataSetIdentifier")
     *                                         .build())
     *                                 .fieldId("fieldId")
     *                                 // the properties below are optional
     *                                 .dateGranularity("dateGranularity")
     *                                 .formatConfiguration(DateTimeFormatConfigurationProperty.builder()
     *                                         .dateTimeFormat("dateTimeFormat")
     *                                         .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
     *                                                 .nullString("nullString")
     *                                                 .build())
     *                                         .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
     *                                                 .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
     *                                                         .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
     *                                                                 .decimalPlaces(123)
     *                                                                 .build())
     *                                                         .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
     *                                                                 .displayMode("displayMode")
     *                                                                 .build())
     *                                                         .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
     *                                                                 .nullString("nullString")
     *                                                                 .build())
     *                                                         .numberScale("numberScale")
     *                                                         .prefix("prefix")
     *                                                         .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
     *                                                                 .decimalSeparator("decimalSeparator")
     *                                                                 .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
     *                                                                         .symbol("symbol")
     *                                                                         .visibility("visibility")
     *                                                                         .build())
     *                                                                 .build())
     *                                                         .suffix("suffix")
     *                                                         .symbol("symbol")
     *                                                         .build())
     *                                                 .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
     *                                                         .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
     *                                                                 .decimalPlaces(123)
     *                                                                 .build())
     *                                                         .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
     *                                                                 .displayMode("displayMode")
     *                                                                 .build())
     *                                                         .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
     *                                                                 .nullString("nullString")
     *                                                                 .build())
     *                                                         .numberScale("numberScale")
     *                                                         .prefix("prefix")
     *                                                         .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
     *                                                                 .decimalSeparator("decimalSeparator")
     *                                                                 .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
     *                                                                         .symbol("symbol")
     *                                                                         .visibility("visibility")
     *                                                                         .build())
     *                                                                 .build())
     *                                                         .suffix("suffix")
     *                                                         .build())
     *                                                 .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
     *                                                         .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
     *                                                                 .decimalPlaces(123)
     *                                                                 .build())
     *                                                         .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
     *                                                                 .displayMode("displayMode")
     *                                                                 .build())
     *                                                         .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
     *                                                                 .nullString("nullString")
     *                                                                 .build())
     *                                                         .prefix("prefix")
     *                                                         .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
     *                                                                 .decimalSeparator("decimalSeparator")
     *                                                                 .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
     *                                                                         .symbol("symbol")
     *                                                                         .visibility("visibility")
     *                                                                         .build())
     *                                                                 .build())
     *                                                         .suffix("suffix")
     *                                                         .build())
     *                                                 .build())
     *                                         .build())
     *                                 .hierarchyId("hierarchyId")
     *                                 .build())
     *                         .numericalDimensionField(NumericalDimensionFieldProperty.builder()
     *                                 .column(ColumnIdentifierProperty.builder()
     *                                         .columnName("columnName")
     *                                         .dataSetIdentifier("dataSetIdentifier")
     *                                         .build())
     *                                 .fieldId("fieldId")
     *                                 // the properties below are optional
     *                                 .formatConfiguration(NumberFormatConfigurationProperty.builder()
     *                                         .formatConfiguration(NumericFormatConfigurationProperty.builder()
     *                                                 .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
     *                                                         .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
     *                                                                 .decimalPlaces(123)
     *                                                                 .build())
     *                                                         .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
     *                                                                 .displayMode("displayMode")
     *                                                                 .build())
     *                                                         .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
     *                                                                 .nullString("nullString")
     *                                                                 .build())
     *                                                         .numberScale("numberScale")
     *                                                         .prefix("prefix")
     *                                                         .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
     *                                                                 .decimalSeparator("decimalSeparator")
     *                                                                 .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
     *                                                                         .symbol("symbol")
     *                                                                         .visibility("visibility")
     *                                                                         .build())
     *                                                                 .build())
     *                                                         .suffix("suffix")
     *                                                         .symbol("symbol")
     *                                                         .build())
     *                                                 .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
     *                                                         .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
     *                                                                 .decimalPlaces(123)
     *                                                                 .build())
     *                                                         .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
     *                                                                 .displayMode("displayMode")
     *                                                                 .build())
     *                                                         .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
     *                                                                 .nullString("nullString")
     *                                                                 .build())
     *                                                         .numberScale("numberScale")
     *                                                         .prefix("prefix")
     *                                                         .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
     *                                                                 .decimalSeparator("decimalSeparator")
     *                                                                 .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
     *                                                                         .symbol("symbol")
     *                                                                         .visibility("visibility")
     *                                                                         .build())
     *                                                                 .build())
     *                                                         .suffix("suffix")
     *                                                         .build())
     *                                                 .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
     *                                                         .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
     *                                                                 .decimalPlaces(123)
     *                                                                 .build())
     *                                                         .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
     *                                                                 .displayMode("displayMode")
     *                                                                 .build())
     *                                                         .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
     *                                                                 .nullString("nullString")
     *                                                                 .build())
     *                                                         .prefix("prefix")
     *                                                         .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
     *                                                                 .decimalSeparator("decimalSeparator")
     *                                                                 .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
     *                                                                         .symbol("symbol")
     *                                                                         .visibility("visibility")
     *                                                                         .build())
     *                                                                 .build())
     *                                                         .suffix("suffix")
     *                                                         .build())
     *                                                 .build())
     *                                         .build())
     *                                 .hierarchyId("hierarchyId")
     *                                 .build())
     *                         .build()))
     *                 .values(List.of(MeasureFieldProperty.builder()
     *                         .calculatedMeasureField(CalculatedMeasureFieldProperty.builder()
     *                                 .expression("expression")
     *                                 .fieldId("fieldId")
     *                                 .build())
     *                         .categoricalMeasureField(CategoricalMeasureFieldProperty.builder()
     *                                 .column(ColumnIdentifierProperty.builder()
     *                                         .columnName("columnName")
     *                                         .dataSetIdentifier("dataSetIdentifier")
     *                                         .build())
     *                                 .fieldId("fieldId")
     *                                 // the properties below are optional
     *                                 .aggregationFunction("aggregationFunction")
     *                                 .formatConfiguration(StringFormatConfigurationProperty.builder()
     *                                         .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
     *                                                 .nullString("nullString")
     *                                                 .build())
     *                                         .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
     *                                                 .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
     *                                                         .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
     *                                                                 .decimalPlaces(123)
     *                                                                 .build())
     *                                                         .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
     *                                                                 .displayMode("displayMode")
     *                                                                 .build())
     *                                                         .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
     *                                                                 .nullString("nullString")
     *                                                                 .build())
     *                                                         .numberScale("numberScale")
     *                                                         .prefix("prefix")
     *                                                         .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
     *                                                                 .decimalSeparator("decimalSeparator")
     *                                                                 .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
     *                                                                         .symbol("symbol")
     *                                                                         .visibility("visibility")
     *                                                                         .build())
     *                                                                 .build())
     *                                                         .suffix("suffix")
     *                                                         .symbol("symbol")
     *                                                         .build())
     *                                                 .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
     *                                                         .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
     *                                                                 .decimalPlaces(123)
     *                                                                 .build())
     *                                                         .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
     *                                                                 .displayMode("displayMode")
     *                                                                 .build())
     *                                                         .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
     *                                                                 .nullString("nullString")
     *                                                                 .build())
     *                                                         .numberScale("numberScale")
     *                                                         .prefix("prefix")
     *                                                         .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
     *                                                                 .decimalSeparator("decimalSeparator")
     *                                                                 .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
     *                                                                         .symbol("symbol")
     *                                                                         .visibility("visibility")
     *                                                                         .build())
     *                                                                 .build())
     *                                                         .suffix("suffix")
     *                                                         .build())
     *                                                 .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
     *                                                         .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
     *                                                                 .decimalPlaces(123)
     *                                                                 .build())
     *                                                         .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
     *                                                                 .displayMode("displayMode")
     *                                                                 .build())
     *                                                         .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
     *                                                                 .nullString("nullString")
     *                                                                 .build())
     *                                                         .prefix("prefix")
     *                                                         .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
     *                                                                 .decimalSeparator("decimalSeparator")
     *                                                                 .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
     *                                                                         .symbol("symbol")
     *                                                                         .visibility("visibility")
     *                                                                         .build())
     *                                                                 .build())
     *                                                         .suffix("suffix")
     *                                                         .build())
     *                                                 .build())
     *                                         .build())
     *                                 .build())
     *                         .dateMeasureField(DateMeasureFieldProperty.builder()
     *                                 .column(ColumnIdentifierProperty.builder()
     *                                         .columnName("columnName")
     *                                         .dataSetIdentifier("dataSetIdentifier")
     *                                         .build())
     *                                 .fieldId("fieldId")
     *                                 // the properties below are optional
     *                                 .aggregationFunction("aggregationFunction")
     *                                 .formatConfiguration(DateTimeFormatConfigurationProperty.builder()
     *                                         .dateTimeFormat("dateTimeFormat")
     *                                         .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
     *                                                 .nullString("nullString")
     *                                                 .build())
     *                                         .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
     *                                                 .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
     *                                                         .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
     *                                                                 .decimalPlaces(123)
     *                                                                 .build())
     *                                                         .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
     *                                                                 .displayMode("displayMode")
     *                                                                 .build())
     *                                                         .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
     *                                                                 .nullString("nullString")
     *                                                                 .build())
     *                                                         .numberScale("numberScale")
     *                                                         .prefix("prefix")
     *                                                         .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
     *                                                                 .decimalSeparator("decimalSeparator")
     *                                                                 .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
     *                                                                         .symbol("symbol")
     *                                                                         .visibility("visibility")
     *                                                                         .build())
     *                                                                 .build())
     *                                                         .suffix("suffix")
     *                                                         .symbol("symbol")
     *                                                         .build())
     *                                                 .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
     *                                                         .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
     *                                                                 .decimalPlaces(123)
     *                                                                 .build())
     *                                                         .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
     *                                                                 .displayMode("displayMode")
     *                                                                 .build())
     *                                                         .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
     *                                                                 .nullString("nullString")
     *                                                                 .build())
     *                                                         .numberScale("numberScale")
     *                                                         .prefix("prefix")
     *                                                         .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
     *                                                                 .decimalSeparator("decimalSeparator")
     *                                                                 .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
     *                                                                         .symbol("symbol")
     *                                                                         .visibility("visibility")
     *                                                                         .build())
     *                                                                 .build())
     *                                                         .suffix("suffix")
     *                                                         .build())
     *                                                 .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
     *                                                         .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
     *                                                                 .decimalPlaces(123)
     *                                                                 .build())
     *                                                         .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
     *                                                                 .displayMode("displayMode")
     *                                                                 .build())
     *                                                         .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
     *                                                                 .nullString("nullString")
     *                                                                 .build())
     *                                                         .prefix("prefix")
     *                                                         .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
     *                                                                 .decimalSeparator("decimalSeparator")
     *                                                                 .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
     *                                                                         .symbol("symbol")
     *                                                                         .visibility("visibility")
     *                                                                         .build())
     *                                                                 .build())
     *                                                         .suffix("suffix")
     *                                                         .build())
     *                                                 .build())
     *                                         .build())
     *                                 .build())
     *                         .numericalMeasureField(NumericalMeasureFieldProperty.builder()
     *                                 .column(ColumnIdentifierProperty.builder()
     *                                         .columnName("columnName")
     *                                         .dataSetIdentifier("dataSetIdentifier")
     *                                         .build())
     *                                 .fieldId("fieldId")
     *                                 // the properties below are optional
     *                                 .aggregationFunction(NumericalAggregationFunctionProperty.builder()
     *                                         .percentileAggregation(PercentileAggregationProperty.builder()
     *                                                 .percentileValue(123)
     *                                                 .build())
     *                                         .simpleNumericalAggregation("simpleNumericalAggregation")
     *                                         .build())
     *                                 .formatConfiguration(NumberFormatConfigurationProperty.builder()
     *                                         .formatConfiguration(NumericFormatConfigurationProperty.builder()
     *                                                 .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
     *                                                         .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
     *                                                                 .decimalPlaces(123)
     *                                                                 .build())
     *                                                         .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
     *                                                                 .displayMode("displayMode")
     *                                                                 .build())
     *                                                         .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
     *                                                                 .nullString("nullString")
     *                                                                 .build())
     *                                                         .numberScale("numberScale")
     *                                                         .prefix("prefix")
     *                                                         .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
     *                                                                 .decimalSeparator("decimalSeparator")
     *                                                                 .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
     *                                                                         .symbol("symbol")
     *                                                                         .visibility("visibility")
     *                                                                         .build())
     *                                                                 .build())
     *                                                         .suffix("suffix")
     *                                                         .symbol("symbol")
     *                                                         .build())
     *                                                 .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
     *                                                         .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
     *                                                                 .decimalPlaces(123)
     *                                                                 .build())
     *                                                         .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
     *                                                                 .displayMode("displayMode")
     *                                                                 .build())
     *                                                         .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
     *                                                                 .nullString("nullString")
     *                                                                 .build())
     *                                                         .numberScale("numberScale")
     *                                                         .prefix("prefix")
     *                                                         .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
     *                                                                 .decimalSeparator("decimalSeparator")
     *                                                                 .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
     *                                                                         .symbol("symbol")
     *                                                                         .visibility("visibility")
     *                                                                         .build())
     *                                                                 .build())
     *                                                         .suffix("suffix")
     *                                                         .build())
     *                                                 .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
     *                                                         .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
     *                                                                 .decimalPlaces(123)
     *                                                                 .build())
     *                                                         .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
     *                                                                 .displayMode("displayMode")
     *                                                                 .build())
     *                                                         .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
     *                                                                 .nullString("nullString")
     *                                                                 .build())
     *                                                         .prefix("prefix")
     *                                                         .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
     *                                                                 .decimalSeparator("decimalSeparator")
     *                                                                 .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
     *                                                                         .symbol("symbol")
     *                                                                         .visibility("visibility")
     *                                                                         .build())
     *                                                                 .build())
     *                                                         .suffix("suffix")
     *                                                         .build())
     *                                                 .build())
     *                                         .build())
     *                                 .build())
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotfieldwells.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotfieldwells.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.BoxPlotFieldWellsProperty")
    @software.amazon.jsii.Jsii.Proxy(BoxPlotFieldWellsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BoxPlotFieldWellsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The aggregated field wells of a box plot.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotfieldwells.html#cfn-quicksight-analysis-boxplotfieldwells-boxplotaggregatedfieldwells">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotfieldwells.html#cfn-quicksight-analysis-boxplotfieldwells-boxplotaggregatedfieldwells</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBoxPlotAggregatedFieldWells() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BoxPlotFieldWellsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BoxPlotFieldWellsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BoxPlotFieldWellsProperty> {
            java.lang.Object boxPlotAggregatedFieldWells;

            /**
             * Sets the value of {@link BoxPlotFieldWellsProperty#getBoxPlotAggregatedFieldWells}
             * @param boxPlotAggregatedFieldWells The aggregated field wells of a box plot.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder boxPlotAggregatedFieldWells(software.amazon.awscdk.IResolvable boxPlotAggregatedFieldWells) {
                this.boxPlotAggregatedFieldWells = boxPlotAggregatedFieldWells;
                return this;
            }

            /**
             * Sets the value of {@link BoxPlotFieldWellsProperty#getBoxPlotAggregatedFieldWells}
             * @param boxPlotAggregatedFieldWells The aggregated field wells of a box plot.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder boxPlotAggregatedFieldWells(software.amazon.awscdk.services.quicksight.CfnAnalysis.BoxPlotAggregatedFieldWellsProperty boxPlotAggregatedFieldWells) {
                this.boxPlotAggregatedFieldWells = boxPlotAggregatedFieldWells;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BoxPlotFieldWellsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BoxPlotFieldWellsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BoxPlotFieldWellsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BoxPlotFieldWellsProperty {
            private final java.lang.Object boxPlotAggregatedFieldWells;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.boxPlotAggregatedFieldWells = software.amazon.jsii.Kernel.get(this, "boxPlotAggregatedFieldWells", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.boxPlotAggregatedFieldWells = builder.boxPlotAggregatedFieldWells;
            }

            @Override
            public final java.lang.Object getBoxPlotAggregatedFieldWells() {
                return this.boxPlotAggregatedFieldWells;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBoxPlotAggregatedFieldWells() != null) {
                    data.set("boxPlotAggregatedFieldWells", om.valueToTree(this.getBoxPlotAggregatedFieldWells()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.BoxPlotFieldWellsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BoxPlotFieldWellsProperty.Jsii$Proxy that = (BoxPlotFieldWellsProperty.Jsii$Proxy) o;

                return this.boxPlotAggregatedFieldWells != null ? this.boxPlotAggregatedFieldWells.equals(that.boxPlotAggregatedFieldWells) : that.boxPlotAggregatedFieldWells == null;
            }

            @Override
            public final int hashCode() {
                int result = this.boxPlotAggregatedFieldWells != null ? this.boxPlotAggregatedFieldWells.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The options of a box plot visual.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * BoxPlotOptionsProperty boxPlotOptionsProperty = BoxPlotOptionsProperty.builder()
     *         .allDataPointsVisibility("allDataPointsVisibility")
     *         .outlierVisibility("outlierVisibility")
     *         .styleOptions(BoxPlotStyleOptionsProperty.builder()
     *                 .fillStyle("fillStyle")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.BoxPlotOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(BoxPlotOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BoxPlotOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Determines the visibility of all data points of the box plot.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotoptions.html#cfn-quicksight-analysis-boxplotoptions-alldatapointsvisibility">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotoptions.html#cfn-quicksight-analysis-boxplotoptions-alldatapointsvisibility</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAllDataPointsVisibility() {
            return null;
        }

        /**
         * Determines the visibility of the outlier in a box plot.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotoptions.html#cfn-quicksight-analysis-boxplotoptions-outliervisibility">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotoptions.html#cfn-quicksight-analysis-boxplotoptions-outliervisibility</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOutlierVisibility() {
            return null;
        }

        /**
         * The style options of the box plot.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotoptions.html#cfn-quicksight-analysis-boxplotoptions-styleoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotoptions.html#cfn-quicksight-analysis-boxplotoptions-styleoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStyleOptions() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BoxPlotOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BoxPlotOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BoxPlotOptionsProperty> {
            java.lang.String allDataPointsVisibility;
            java.lang.String outlierVisibility;
            java.lang.Object styleOptions;

            /**
             * Sets the value of {@link BoxPlotOptionsProperty#getAllDataPointsVisibility}
             * @param allDataPointsVisibility Determines the visibility of all data points of the box plot.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allDataPointsVisibility(java.lang.String allDataPointsVisibility) {
                this.allDataPointsVisibility = allDataPointsVisibility;
                return this;
            }

            /**
             * Sets the value of {@link BoxPlotOptionsProperty#getOutlierVisibility}
             * @param outlierVisibility Determines the visibility of the outlier in a box plot.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outlierVisibility(java.lang.String outlierVisibility) {
                this.outlierVisibility = outlierVisibility;
                return this;
            }

            /**
             * Sets the value of {@link BoxPlotOptionsProperty#getStyleOptions}
             * @param styleOptions The style options of the box plot.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder styleOptions(software.amazon.awscdk.IResolvable styleOptions) {
                this.styleOptions = styleOptions;
                return this;
            }

            /**
             * Sets the value of {@link BoxPlotOptionsProperty#getStyleOptions}
             * @param styleOptions The style options of the box plot.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder styleOptions(software.amazon.awscdk.services.quicksight.CfnAnalysis.BoxPlotStyleOptionsProperty styleOptions) {
                this.styleOptions = styleOptions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BoxPlotOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BoxPlotOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BoxPlotOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BoxPlotOptionsProperty {
            private final java.lang.String allDataPointsVisibility;
            private final java.lang.String outlierVisibility;
            private final java.lang.Object styleOptions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.allDataPointsVisibility = software.amazon.jsii.Kernel.get(this, "allDataPointsVisibility", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.outlierVisibility = software.amazon.jsii.Kernel.get(this, "outlierVisibility", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.styleOptions = software.amazon.jsii.Kernel.get(this, "styleOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.allDataPointsVisibility = builder.allDataPointsVisibility;
                this.outlierVisibility = builder.outlierVisibility;
                this.styleOptions = builder.styleOptions;
            }

            @Override
            public final java.lang.String getAllDataPointsVisibility() {
                return this.allDataPointsVisibility;
            }

            @Override
            public final java.lang.String getOutlierVisibility() {
                return this.outlierVisibility;
            }

            @Override
            public final java.lang.Object getStyleOptions() {
                return this.styleOptions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAllDataPointsVisibility() != null) {
                    data.set("allDataPointsVisibility", om.valueToTree(this.getAllDataPointsVisibility()));
                }
                if (this.getOutlierVisibility() != null) {
                    data.set("outlierVisibility", om.valueToTree(this.getOutlierVisibility()));
                }
                if (this.getStyleOptions() != null) {
                    data.set("styleOptions", om.valueToTree(this.getStyleOptions()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.BoxPlotOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BoxPlotOptionsProperty.Jsii$Proxy that = (BoxPlotOptionsProperty.Jsii$Proxy) o;

                if (this.allDataPointsVisibility != null ? !this.allDataPointsVisibility.equals(that.allDataPointsVisibility) : that.allDataPointsVisibility != null) return false;
                if (this.outlierVisibility != null ? !this.outlierVisibility.equals(that.outlierVisibility) : that.outlierVisibility != null) return false;
                return this.styleOptions != null ? this.styleOptions.equals(that.styleOptions) : that.styleOptions == null;
            }

            @Override
            public final int hashCode() {
                int result = this.allDataPointsVisibility != null ? this.allDataPointsVisibility.hashCode() : 0;
                result = 31 * result + (this.outlierVisibility != null ? this.outlierVisibility.hashCode() : 0);
                result = 31 * result + (this.styleOptions != null ? this.styleOptions.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The sort configuration of a <code>BoxPlotVisual</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * BoxPlotSortConfigurationProperty boxPlotSortConfigurationProperty = BoxPlotSortConfigurationProperty.builder()
     *         .categorySort(List.of(FieldSortOptionsProperty.builder()
     *                 .columnSort(ColumnSortProperty.builder()
     *                         .direction("direction")
     *                         .sortBy(ColumnIdentifierProperty.builder()
     *                                 .columnName("columnName")
     *                                 .dataSetIdentifier("dataSetIdentifier")
     *                                 .build())
     *                         // the properties below are optional
     *                         .aggregationFunction(AggregationFunctionProperty.builder()
     *                                 .attributeAggregationFunction(AttributeAggregationFunctionProperty.builder()
     *                                         .simpleAttributeAggregation("simpleAttributeAggregation")
     *                                         .valueForMultipleValues("valueForMultipleValues")
     *                                         .build())
     *                                 .categoricalAggregationFunction("categoricalAggregationFunction")
     *                                 .dateAggregationFunction("dateAggregationFunction")
     *                                 .numericalAggregationFunction(NumericalAggregationFunctionProperty.builder()
     *                                         .percentileAggregation(PercentileAggregationProperty.builder()
     *                                                 .percentileValue(123)
     *                                                 .build())
     *                                         .simpleNumericalAggregation("simpleNumericalAggregation")
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 .fieldSort(FieldSortProperty.builder()
     *                         .direction("direction")
     *                         .fieldId("fieldId")
     *                         .build())
     *                 .build()))
     *         .paginationConfiguration(PaginationConfigurationProperty.builder()
     *                 .pageNumber(123)
     *                 .pageSize(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotsortconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotsortconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.BoxPlotSortConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(BoxPlotSortConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BoxPlotSortConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The sort configuration of a group by fields.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotsortconfiguration.html#cfn-quicksight-analysis-boxplotsortconfiguration-categorysort">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotsortconfiguration.html#cfn-quicksight-analysis-boxplotsortconfiguration-categorysort</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCategorySort() {
            return null;
        }

        /**
         * The pagination configuration of a table visual or box plot.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotsortconfiguration.html#cfn-quicksight-analysis-boxplotsortconfiguration-paginationconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotsortconfiguration.html#cfn-quicksight-analysis-boxplotsortconfiguration-paginationconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPaginationConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BoxPlotSortConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BoxPlotSortConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BoxPlotSortConfigurationProperty> {
            java.lang.Object categorySort;
            java.lang.Object paginationConfiguration;

            /**
             * Sets the value of {@link BoxPlotSortConfigurationProperty#getCategorySort}
             * @param categorySort The sort configuration of a group by fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder categorySort(software.amazon.awscdk.IResolvable categorySort) {
                this.categorySort = categorySort;
                return this;
            }

            /**
             * Sets the value of {@link BoxPlotSortConfigurationProperty#getCategorySort}
             * @param categorySort The sort configuration of a group by fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder categorySort(java.util.List<? extends java.lang.Object> categorySort) {
                this.categorySort = categorySort;
                return this;
            }

            /**
             * Sets the value of {@link BoxPlotSortConfigurationProperty#getPaginationConfiguration}
             * @param paginationConfiguration The pagination configuration of a table visual or box plot.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder paginationConfiguration(software.amazon.awscdk.IResolvable paginationConfiguration) {
                this.paginationConfiguration = paginationConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link BoxPlotSortConfigurationProperty#getPaginationConfiguration}
             * @param paginationConfiguration The pagination configuration of a table visual or box plot.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder paginationConfiguration(software.amazon.awscdk.services.quicksight.CfnAnalysis.PaginationConfigurationProperty paginationConfiguration) {
                this.paginationConfiguration = paginationConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BoxPlotSortConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BoxPlotSortConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BoxPlotSortConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BoxPlotSortConfigurationProperty {
            private final java.lang.Object categorySort;
            private final java.lang.Object paginationConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.categorySort = software.amazon.jsii.Kernel.get(this, "categorySort", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.paginationConfiguration = software.amazon.jsii.Kernel.get(this, "paginationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.categorySort = builder.categorySort;
                this.paginationConfiguration = builder.paginationConfiguration;
            }

            @Override
            public final java.lang.Object getCategorySort() {
                return this.categorySort;
            }

            @Override
            public final java.lang.Object getPaginationConfiguration() {
                return this.paginationConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCategorySort() != null) {
                    data.set("categorySort", om.valueToTree(this.getCategorySort()));
                }
                if (this.getPaginationConfiguration() != null) {
                    data.set("paginationConfiguration", om.valueToTree(this.getPaginationConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.BoxPlotSortConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BoxPlotSortConfigurationProperty.Jsii$Proxy that = (BoxPlotSortConfigurationProperty.Jsii$Proxy) o;

                if (this.categorySort != null ? !this.categorySort.equals(that.categorySort) : that.categorySort != null) return false;
                return this.paginationConfiguration != null ? this.paginationConfiguration.equals(that.paginationConfiguration) : that.paginationConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.categorySort != null ? this.categorySort.hashCode() : 0;
                result = 31 * result + (this.paginationConfiguration != null ? this.paginationConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The style options of the box plot.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * BoxPlotStyleOptionsProperty boxPlotStyleOptionsProperty = BoxPlotStyleOptionsProperty.builder()
     *         .fillStyle("fillStyle")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotstyleoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotstyleoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.BoxPlotStyleOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(BoxPlotStyleOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BoxPlotStyleOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The fill styles (solid, transparent) of the box plot.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotstyleoptions.html#cfn-quicksight-analysis-boxplotstyleoptions-fillstyle">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotstyleoptions.html#cfn-quicksight-analysis-boxplotstyleoptions-fillstyle</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFillStyle() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BoxPlotStyleOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BoxPlotStyleOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BoxPlotStyleOptionsProperty> {
            java.lang.String fillStyle;

            /**
             * Sets the value of {@link BoxPlotStyleOptionsProperty#getFillStyle}
             * @param fillStyle The fill styles (solid, transparent) of the box plot.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fillStyle(java.lang.String fillStyle) {
                this.fillStyle = fillStyle;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BoxPlotStyleOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BoxPlotStyleOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BoxPlotStyleOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BoxPlotStyleOptionsProperty {
            private final java.lang.String fillStyle;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.fillStyle = software.amazon.jsii.Kernel.get(this, "fillStyle", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.fillStyle = builder.fillStyle;
            }

            @Override
            public final java.lang.String getFillStyle() {
                return this.fillStyle;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getFillStyle() != null) {
                    data.set("fillStyle", om.valueToTree(this.getFillStyle()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.BoxPlotStyleOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BoxPlotStyleOptionsProperty.Jsii$Proxy that = (BoxPlotStyleOptionsProperty.Jsii$Proxy) o;

                return this.fillStyle != null ? this.fillStyle.equals(that.fillStyle) : that.fillStyle == null;
            }

            @Override
            public final int hashCode() {
                int result = this.fillStyle != null ? this.fillStyle.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * A box plot.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/box-plots.html">Using box plots</a> in the <em>Amazon QuickSight User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotvisual.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotvisual.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.BoxPlotVisualProperty")
    @software.amazon.jsii.Jsii.Proxy(BoxPlotVisualProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BoxPlotVisualProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The unique identifier of a visual.
         * <p>
         * This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers..
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotvisual.html#cfn-quicksight-analysis-boxplotvisual-visualid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotvisual.html#cfn-quicksight-analysis-boxplotvisual-visualid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getVisualId();

        /**
         * The list of custom actions that are configured for a visual.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotvisual.html#cfn-quicksight-analysis-boxplotvisual-actions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotvisual.html#cfn-quicksight-analysis-boxplotvisual-actions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getActions() {
            return null;
        }

        /**
         * The configuration settings of the visual.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotvisual.html#cfn-quicksight-analysis-boxplotvisual-chartconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotvisual.html#cfn-quicksight-analysis-boxplotvisual-chartconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getChartConfiguration() {
            return null;
        }

        /**
         * The column hierarchy that is used during drill-downs and drill-ups.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotvisual.html#cfn-quicksight-analysis-boxplotvisual-columnhierarchies">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotvisual.html#cfn-quicksight-analysis-boxplotvisual-columnhierarchies</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getColumnHierarchies() {
            return null;
        }

        /**
         * The subtitle that is displayed on the visual.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotvisual.html#cfn-quicksight-analysis-boxplotvisual-subtitle">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotvisual.html#cfn-quicksight-analysis-boxplotvisual-subtitle</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSubtitle() {
            return null;
        }

        /**
         * The title that is displayed on the visual.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotvisual.html#cfn-quicksight-analysis-boxplotvisual-title">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotvisual.html#cfn-quicksight-analysis-boxplotvisual-title</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTitle() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BoxPlotVisualProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BoxPlotVisualProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BoxPlotVisualProperty> {
            java.lang.String visualId;
            java.lang.Object actions;
            java.lang.Object chartConfiguration;
            java.lang.Object columnHierarchies;
            java.lang.Object subtitle;
            java.lang.Object title;

            /**
             * Sets the value of {@link BoxPlotVisualProperty#getVisualId}
             * @param visualId The unique identifier of a visual. This parameter is required.
             *                 This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers..
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder visualId(java.lang.String visualId) {
                this.visualId = visualId;
                return this;
            }

            /**
             * Sets the value of {@link BoxPlotVisualProperty#getActions}
             * @param actions The list of custom actions that are configured for a visual.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actions(software.amazon.awscdk.IResolvable actions) {
                this.actions = actions;
                return this;
            }

            /**
             * Sets the value of {@link BoxPlotVisualProperty#getActions}
             * @param actions The list of custom actions that are configured for a visual.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actions(java.util.List<? extends java.lang.Object> actions) {
                this.actions = actions;
                return this;
            }

            /**
             * Sets the value of {@link BoxPlotVisualProperty#getChartConfiguration}
             * @param chartConfiguration The configuration settings of the visual.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder chartConfiguration(software.amazon.awscdk.IResolvable chartConfiguration) {
                this.chartConfiguration = chartConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link BoxPlotVisualProperty#getChartConfiguration}
             * @param chartConfiguration The configuration settings of the visual.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder chartConfiguration(software.amazon.awscdk.services.quicksight.CfnAnalysis.BoxPlotChartConfigurationProperty chartConfiguration) {
                this.chartConfiguration = chartConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link BoxPlotVisualProperty#getColumnHierarchies}
             * @param columnHierarchies The column hierarchy that is used during drill-downs and drill-ups.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnHierarchies(software.amazon.awscdk.IResolvable columnHierarchies) {
                this.columnHierarchies = columnHierarchies;
                return this;
            }

            /**
             * Sets the value of {@link BoxPlotVisualProperty#getColumnHierarchies}
             * @param columnHierarchies The column hierarchy that is used during drill-downs and drill-ups.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnHierarchies(java.util.List<? extends java.lang.Object> columnHierarchies) {
                this.columnHierarchies = columnHierarchies;
                return this;
            }

            /**
             * Sets the value of {@link BoxPlotVisualProperty#getSubtitle}
             * @param subtitle The subtitle that is displayed on the visual.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subtitle(software.amazon.awscdk.IResolvable subtitle) {
                this.subtitle = subtitle;
                return this;
            }

            /**
             * Sets the value of {@link BoxPlotVisualProperty#getSubtitle}
             * @param subtitle The subtitle that is displayed on the visual.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subtitle(software.amazon.awscdk.services.quicksight.CfnAnalysis.VisualSubtitleLabelOptionsProperty subtitle) {
                this.subtitle = subtitle;
                return this;
            }

            /**
             * Sets the value of {@link BoxPlotVisualProperty#getTitle}
             * @param title The title that is displayed on the visual.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder title(software.amazon.awscdk.IResolvable title) {
                this.title = title;
                return this;
            }

            /**
             * Sets the value of {@link BoxPlotVisualProperty#getTitle}
             * @param title The title that is displayed on the visual.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder title(software.amazon.awscdk.services.quicksight.CfnAnalysis.VisualTitleLabelOptionsProperty title) {
                this.title = title;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BoxPlotVisualProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BoxPlotVisualProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BoxPlotVisualProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BoxPlotVisualProperty {
            private final java.lang.String visualId;
            private final java.lang.Object actions;
            private final java.lang.Object chartConfiguration;
            private final java.lang.Object columnHierarchies;
            private final java.lang.Object subtitle;
            private final java.lang.Object title;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.visualId = software.amazon.jsii.Kernel.get(this, "visualId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.actions = software.amazon.jsii.Kernel.get(this, "actions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.chartConfiguration = software.amazon.jsii.Kernel.get(this, "chartConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.columnHierarchies = software.amazon.jsii.Kernel.get(this, "columnHierarchies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.subtitle = software.amazon.jsii.Kernel.get(this, "subtitle", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.title = software.amazon.jsii.Kernel.get(this, "title", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.visualId = java.util.Objects.requireNonNull(builder.visualId, "visualId is required");
                this.actions = builder.actions;
                this.chartConfiguration = builder.chartConfiguration;
                this.columnHierarchies = builder.columnHierarchies;
                this.subtitle = builder.subtitle;
                this.title = builder.title;
            }

            @Override
            public final java.lang.String getVisualId() {
                return this.visualId;
            }

            @Override
            public final java.lang.Object getActions() {
                return this.actions;
            }

            @Override
            public final java.lang.Object getChartConfiguration() {
                return this.chartConfiguration;
            }

            @Override
            public final java.lang.Object getColumnHierarchies() {
                return this.columnHierarchies;
            }

            @Override
            public final java.lang.Object getSubtitle() {
                return this.subtitle;
            }

            @Override
            public final java.lang.Object getTitle() {
                return this.title;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("visualId", om.valueToTree(this.getVisualId()));
                if (this.getActions() != null) {
                    data.set("actions", om.valueToTree(this.getActions()));
                }
                if (this.getChartConfiguration() != null) {
                    data.set("chartConfiguration", om.valueToTree(this.getChartConfiguration()));
                }
                if (this.getColumnHierarchies() != null) {
                    data.set("columnHierarchies", om.valueToTree(this.getColumnHierarchies()));
                }
                if (this.getSubtitle() != null) {
                    data.set("subtitle", om.valueToTree(this.getSubtitle()));
                }
                if (this.getTitle() != null) {
                    data.set("title", om.valueToTree(this.getTitle()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.BoxPlotVisualProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BoxPlotVisualProperty.Jsii$Proxy that = (BoxPlotVisualProperty.Jsii$Proxy) o;

                if (!visualId.equals(that.visualId)) return false;
                if (this.actions != null ? !this.actions.equals(that.actions) : that.actions != null) return false;
                if (this.chartConfiguration != null ? !this.chartConfiguration.equals(that.chartConfiguration) : that.chartConfiguration != null) return false;
                if (this.columnHierarchies != null ? !this.columnHierarchies.equals(that.columnHierarchies) : that.columnHierarchies != null) return false;
                if (this.subtitle != null ? !this.subtitle.equals(that.subtitle) : that.subtitle != null) return false;
                return this.title != null ? this.title.equals(that.title) : that.title == null;
            }

            @Override
            public final int hashCode() {
                int result = this.visualId.hashCode();
                result = 31 * result + (this.actions != null ? this.actions.hashCode() : 0);
                result = 31 * result + (this.chartConfiguration != null ? this.chartConfiguration.hashCode() : 0);
                result = 31 * result + (this.columnHierarchies != null ? this.columnHierarchies.hashCode() : 0);
                result = 31 * result + (this.subtitle != null ? this.subtitle.hashCode() : 0);
                result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The calculated field of an analysis.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * CalculatedFieldProperty calculatedFieldProperty = CalculatedFieldProperty.builder()
     *         .dataSetIdentifier("dataSetIdentifier")
     *         .expression("expression")
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-calculatedfield.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-calculatedfield.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.CalculatedFieldProperty")
    @software.amazon.jsii.Jsii.Proxy(CalculatedFieldProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CalculatedFieldProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The data set that is used in this calculated field.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-calculatedfield.html#cfn-quicksight-analysis-calculatedfield-datasetidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-calculatedfield.html#cfn-quicksight-analysis-calculatedfield-datasetidentifier</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDataSetIdentifier();

        /**
         * The expression of the calculated field.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-calculatedfield.html#cfn-quicksight-analysis-calculatedfield-expression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-calculatedfield.html#cfn-quicksight-analysis-calculatedfield-expression</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getExpression();

        /**
         * The name of the calculated field.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-calculatedfield.html#cfn-quicksight-analysis-calculatedfield-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-calculatedfield.html#cfn-quicksight-analysis-calculatedfield-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * @return a {@link Builder} of {@link CalculatedFieldProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CalculatedFieldProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CalculatedFieldProperty> {
            java.lang.String dataSetIdentifier;
            java.lang.String expression;
            java.lang.String name;

            /**
             * Sets the value of {@link CalculatedFieldProperty#getDataSetIdentifier}
             * @param dataSetIdentifier The data set that is used in this calculated field. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataSetIdentifier(java.lang.String dataSetIdentifier) {
                this.dataSetIdentifier = dataSetIdentifier;
                return this;
            }

            /**
             * Sets the value of {@link CalculatedFieldProperty#getExpression}
             * @param expression The expression of the calculated field. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder expression(java.lang.String expression) {
                this.expression = expression;
                return this;
            }

            /**
             * Sets the value of {@link CalculatedFieldProperty#getName}
             * @param name The name of the calculated field. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CalculatedFieldProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CalculatedFieldProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CalculatedFieldProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CalculatedFieldProperty {
            private final java.lang.String dataSetIdentifier;
            private final java.lang.String expression;
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dataSetIdentifier = software.amazon.jsii.Kernel.get(this, "dataSetIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.expression = software.amazon.jsii.Kernel.get(this, "expression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dataSetIdentifier = java.util.Objects.requireNonNull(builder.dataSetIdentifier, "dataSetIdentifier is required");
                this.expression = java.util.Objects.requireNonNull(builder.expression, "expression is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            }

            @Override
            public final java.lang.String getDataSetIdentifier() {
                return this.dataSetIdentifier;
            }

            @Override
            public final java.lang.String getExpression() {
                return this.expression;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("dataSetIdentifier", om.valueToTree(this.getDataSetIdentifier()));
                data.set("expression", om.valueToTree(this.getExpression()));
                data.set("name", om.valueToTree(this.getName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.CalculatedFieldProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CalculatedFieldProperty.Jsii$Proxy that = (CalculatedFieldProperty.Jsii$Proxy) o;

                if (!dataSetIdentifier.equals(that.dataSetIdentifier)) return false;
                if (!expression.equals(that.expression)) return false;
                return this.name.equals(that.name);
            }

            @Override
            public final int hashCode() {
                int result = this.dataSetIdentifier.hashCode();
                result = 31 * result + (this.expression.hashCode());
                result = 31 * result + (this.name.hashCode());
                return result;
            }
        }
    }
    /**
     * The table calculation measure field for pivot tables.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * CalculatedMeasureFieldProperty calculatedMeasureFieldProperty = CalculatedMeasureFieldProperty.builder()
     *         .expression("expression")
     *         .fieldId("fieldId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-calculatedmeasurefield.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-calculatedmeasurefield.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.CalculatedMeasureFieldProperty")
    @software.amazon.jsii.Jsii.Proxy(CalculatedMeasureFieldProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CalculatedMeasureFieldProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The expression in the table calculation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-calculatedmeasurefield.html#cfn-quicksight-analysis-calculatedmeasurefield-expression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-calculatedmeasurefield.html#cfn-quicksight-analysis-calculatedmeasurefield-expression</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getExpression();

        /**
         * The custom field ID.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-calculatedmeasurefield.html#cfn-quicksight-analysis-calculatedmeasurefield-fieldid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-calculatedmeasurefield.html#cfn-quicksight-analysis-calculatedmeasurefield-fieldid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFieldId();

        /**
         * @return a {@link Builder} of {@link CalculatedMeasureFieldProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CalculatedMeasureFieldProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CalculatedMeasureFieldProperty> {
            java.lang.String expression;
            java.lang.String fieldId;

            /**
             * Sets the value of {@link CalculatedMeasureFieldProperty#getExpression}
             * @param expression The expression in the table calculation. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder expression(java.lang.String expression) {
                this.expression = expression;
                return this;
            }

            /**
             * Sets the value of {@link CalculatedMeasureFieldProperty#getFieldId}
             * @param fieldId The custom field ID. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldId(java.lang.String fieldId) {
                this.fieldId = fieldId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CalculatedMeasureFieldProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CalculatedMeasureFieldProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CalculatedMeasureFieldProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CalculatedMeasureFieldProperty {
            private final java.lang.String expression;
            private final java.lang.String fieldId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.expression = software.amazon.jsii.Kernel.get(this, "expression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.fieldId = software.amazon.jsii.Kernel.get(this, "fieldId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.expression = java.util.Objects.requireNonNull(builder.expression, "expression is required");
                this.fieldId = java.util.Objects.requireNonNull(builder.fieldId, "fieldId is required");
            }

            @Override
            public final java.lang.String getExpression() {
                return this.expression;
            }

            @Override
            public final java.lang.String getFieldId() {
                return this.fieldId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("expression", om.valueToTree(this.getExpression()));
                data.set("fieldId", om.valueToTree(this.getFieldId()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.CalculatedMeasureFieldProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CalculatedMeasureFieldProperty.Jsii$Proxy that = (CalculatedMeasureFieldProperty.Jsii$Proxy) o;

                if (!expression.equals(that.expression)) return false;
                return this.fieldId.equals(that.fieldId);
            }

            @Override
            public final int hashCode() {
                int result = this.expression.hashCode();
                result = 31 * result + (this.fieldId.hashCode());
                return result;
            }
        }
    }
    /**
     * The values that are displayed in a control can be configured to only show values that are valid based on what's selected in other controls.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * CascadingControlConfigurationProperty cascadingControlConfigurationProperty = CascadingControlConfigurationProperty.builder()
     *         .sourceControls(List.of(CascadingControlSourceProperty.builder()
     *                 .columnToMatch(ColumnIdentifierProperty.builder()
     *                         .columnName("columnName")
     *                         .dataSetIdentifier("dataSetIdentifier")
     *                         .build())
     *                 .sourceSheetControlId("sourceSheetControlId")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-cascadingcontrolconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-cascadingcontrolconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.CascadingControlConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(CascadingControlConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CascadingControlConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of source controls that determine the values that are used in the current control.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-cascadingcontrolconfiguration.html#cfn-quicksight-analysis-cascadingcontrolconfiguration-sourcecontrols">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-cascadingcontrolconfiguration.html#cfn-quicksight-analysis-cascadingcontrolconfiguration-sourcecontrols</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSourceControls() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CascadingControlConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CascadingControlConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CascadingControlConfigurationProperty> {
            java.lang.Object sourceControls;

            /**
             * Sets the value of {@link CascadingControlConfigurationProperty#getSourceControls}
             * @param sourceControls A list of source controls that determine the values that are used in the current control.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceControls(software.amazon.awscdk.IResolvable sourceControls) {
                this.sourceControls = sourceControls;
                return this;
            }

            /**
             * Sets the value of {@link CascadingControlConfigurationProperty#getSourceControls}
             * @param sourceControls A list of source controls that determine the values that are used in the current control.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceControls(java.util.List<? extends java.lang.Object> sourceControls) {
                this.sourceControls = sourceControls;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CascadingControlConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CascadingControlConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CascadingControlConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CascadingControlConfigurationProperty {
            private final java.lang.Object sourceControls;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.sourceControls = software.amazon.jsii.Kernel.get(this, "sourceControls", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sourceControls = builder.sourceControls;
            }

            @Override
            public final java.lang.Object getSourceControls() {
                return this.sourceControls;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSourceControls() != null) {
                    data.set("sourceControls", om.valueToTree(this.getSourceControls()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.CascadingControlConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CascadingControlConfigurationProperty.Jsii$Proxy that = (CascadingControlConfigurationProperty.Jsii$Proxy) o;

                return this.sourceControls != null ? this.sourceControls.equals(that.sourceControls) : that.sourceControls == null;
            }

            @Override
            public final int hashCode() {
                int result = this.sourceControls != null ? this.sourceControls.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The source controls that are used in a <code>CascadingControlConfiguration</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * CascadingControlSourceProperty cascadingControlSourceProperty = CascadingControlSourceProperty.builder()
     *         .columnToMatch(ColumnIdentifierProperty.builder()
     *                 .columnName("columnName")
     *                 .dataSetIdentifier("dataSetIdentifier")
     *                 .build())
     *         .sourceSheetControlId("sourceSheetControlId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-cascadingcontrolsource.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-cascadingcontrolsource.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.CascadingControlSourceProperty")
    @software.amazon.jsii.Jsii.Proxy(CascadingControlSourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CascadingControlSourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The column identifier that determines which column to look up for the source sheet control.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-cascadingcontrolsource.html#cfn-quicksight-analysis-cascadingcontrolsource-columntomatch">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-cascadingcontrolsource.html#cfn-quicksight-analysis-cascadingcontrolsource-columntomatch</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getColumnToMatch() {
            return null;
        }

        /**
         * The source sheet control ID of a <code>CascadingControlSource</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-cascadingcontrolsource.html#cfn-quicksight-analysis-cascadingcontrolsource-sourcesheetcontrolid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-cascadingcontrolsource.html#cfn-quicksight-analysis-cascadingcontrolsource-sourcesheetcontrolid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSourceSheetControlId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CascadingControlSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CascadingControlSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CascadingControlSourceProperty> {
            java.lang.Object columnToMatch;
            java.lang.String sourceSheetControlId;

            /**
             * Sets the value of {@link CascadingControlSourceProperty#getColumnToMatch}
             * @param columnToMatch The column identifier that determines which column to look up for the source sheet control.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnToMatch(software.amazon.awscdk.IResolvable columnToMatch) {
                this.columnToMatch = columnToMatch;
                return this;
            }

            /**
             * Sets the value of {@link CascadingControlSourceProperty#getColumnToMatch}
             * @param columnToMatch The column identifier that determines which column to look up for the source sheet control.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnToMatch(software.amazon.awscdk.services.quicksight.CfnAnalysis.ColumnIdentifierProperty columnToMatch) {
                this.columnToMatch = columnToMatch;
                return this;
            }

            /**
             * Sets the value of {@link CascadingControlSourceProperty#getSourceSheetControlId}
             * @param sourceSheetControlId The source sheet control ID of a <code>CascadingControlSource</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceSheetControlId(java.lang.String sourceSheetControlId) {
                this.sourceSheetControlId = sourceSheetControlId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CascadingControlSourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CascadingControlSourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CascadingControlSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CascadingControlSourceProperty {
            private final java.lang.Object columnToMatch;
            private final java.lang.String sourceSheetControlId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.columnToMatch = software.amazon.jsii.Kernel.get(this, "columnToMatch", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sourceSheetControlId = software.amazon.jsii.Kernel.get(this, "sourceSheetControlId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.columnToMatch = builder.columnToMatch;
                this.sourceSheetControlId = builder.sourceSheetControlId;
            }

            @Override
            public final java.lang.Object getColumnToMatch() {
                return this.columnToMatch;
            }

            @Override
            public final java.lang.String getSourceSheetControlId() {
                return this.sourceSheetControlId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getColumnToMatch() != null) {
                    data.set("columnToMatch", om.valueToTree(this.getColumnToMatch()));
                }
                if (this.getSourceSheetControlId() != null) {
                    data.set("sourceSheetControlId", om.valueToTree(this.getSourceSheetControlId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.CascadingControlSourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CascadingControlSourceProperty.Jsii$Proxy that = (CascadingControlSourceProperty.Jsii$Proxy) o;

                if (this.columnToMatch != null ? !this.columnToMatch.equals(that.columnToMatch) : that.columnToMatch != null) return false;
                return this.sourceSheetControlId != null ? this.sourceSheetControlId.equals(that.sourceSheetControlId) : that.sourceSheetControlId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.columnToMatch != null ? this.columnToMatch.hashCode() : 0;
                result = 31 * result + (this.sourceSheetControlId != null ? this.sourceSheetControlId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The dimension type field with categorical type columns..
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * CategoricalDimensionFieldProperty categoricalDimensionFieldProperty = CategoricalDimensionFieldProperty.builder()
     *         .column(ColumnIdentifierProperty.builder()
     *                 .columnName("columnName")
     *                 .dataSetIdentifier("dataSetIdentifier")
     *                 .build())
     *         .fieldId("fieldId")
     *         // the properties below are optional
     *         .formatConfiguration(StringFormatConfigurationProperty.builder()
     *                 .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
     *                         .nullString("nullString")
     *                         .build())
     *                 .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
     *                         .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
     *                                 .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
     *                                         .decimalPlaces(123)
     *                                         .build())
     *                                 .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
     *                                         .displayMode("displayMode")
     *                                         .build())
     *                                 .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
     *                                         .nullString("nullString")
     *                                         .build())
     *                                 .numberScale("numberScale")
     *                                 .prefix("prefix")
     *                                 .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
     *                                         .decimalSeparator("decimalSeparator")
     *                                         .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
     *                                                 .symbol("symbol")
     *                                                 .visibility("visibility")
     *                                                 .build())
     *                                         .build())
     *                                 .suffix("suffix")
     *                                 .symbol("symbol")
     *                                 .build())
     *                         .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
     *                                 .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
     *                                         .decimalPlaces(123)
     *                                         .build())
     *                                 .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
     *                                         .displayMode("displayMode")
     *                                         .build())
     *                                 .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
     *                                         .nullString("nullString")
     *                                         .build())
     *                                 .numberScale("numberScale")
     *                                 .prefix("prefix")
     *                                 .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
     *                                         .decimalSeparator("decimalSeparator")
     *                                         .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
     *                                                 .symbol("symbol")
     *                                                 .visibility("visibility")
     *                                                 .build())
     *                                         .build())
     *                                 .suffix("suffix")
     *                                 .build())
     *                         .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
     *                                 .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
     *                                         .decimalPlaces(123)
     *                                         .build())
     *                                 .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
     *                                         .displayMode("displayMode")
     *                                         .build())
     *                                 .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
     *                                         .nullString("nullString")
     *                                         .build())
     *                                 .prefix("prefix")
     *                                 .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
     *                                         .decimalSeparator("decimalSeparator")
     *                                         .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
     *                                                 .symbol("symbol")
     *                                                 .visibility("visibility")
     *                                                 .build())
     *                                         .build())
     *                                 .suffix("suffix")
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .hierarchyId("hierarchyId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoricaldimensionfield.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoricaldimensionfield.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.CategoricalDimensionFieldProperty")
    @software.amazon.jsii.Jsii.Proxy(CategoricalDimensionFieldProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CategoricalDimensionFieldProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The column that is used in the <code>CategoricalDimensionField</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoricaldimensionfield.html#cfn-quicksight-analysis-categoricaldimensionfield-column">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoricaldimensionfield.html#cfn-quicksight-analysis-categoricaldimensionfield-column</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getColumn();

        /**
         * The custom field ID.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoricaldimensionfield.html#cfn-quicksight-analysis-categoricaldimensionfield-fieldid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoricaldimensionfield.html#cfn-quicksight-analysis-categoricaldimensionfield-fieldid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFieldId();

        /**
         * The format configuration of the field.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoricaldimensionfield.html#cfn-quicksight-analysis-categoricaldimensionfield-formatconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoricaldimensionfield.html#cfn-quicksight-analysis-categoricaldimensionfield-formatconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFormatConfiguration() {
            return null;
        }

        /**
         * The custom hierarchy ID.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoricaldimensionfield.html#cfn-quicksight-analysis-categoricaldimensionfield-hierarchyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoricaldimensionfield.html#cfn-quicksight-analysis-categoricaldimensionfield-hierarchyid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHierarchyId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CategoricalDimensionFieldProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CategoricalDimensionFieldProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CategoricalDimensionFieldProperty> {
            java.lang.Object column;
            java.lang.String fieldId;
            java.lang.Object formatConfiguration;
            java.lang.String hierarchyId;

            /**
             * Sets the value of {@link CategoricalDimensionFieldProperty#getColumn}
             * @param column The column that is used in the <code>CategoricalDimensionField</code> . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder column(software.amazon.awscdk.IResolvable column) {
                this.column = column;
                return this;
            }

            /**
             * Sets the value of {@link CategoricalDimensionFieldProperty#getColumn}
             * @param column The column that is used in the <code>CategoricalDimensionField</code> . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder column(software.amazon.awscdk.services.quicksight.CfnAnalysis.ColumnIdentifierProperty column) {
                this.column = column;
                return this;
            }

            /**
             * Sets the value of {@link CategoricalDimensionFieldProperty#getFieldId}
             * @param fieldId The custom field ID. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldId(java.lang.String fieldId) {
                this.fieldId = fieldId;
                return this;
            }

            /**
             * Sets the value of {@link CategoricalDimensionFieldProperty#getFormatConfiguration}
             * @param formatConfiguration The format configuration of the field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder formatConfiguration(software.amazon.awscdk.IResolvable formatConfiguration) {
                this.formatConfiguration = formatConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link CategoricalDimensionFieldProperty#getFormatConfiguration}
             * @param formatConfiguration The format configuration of the field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder formatConfiguration(software.amazon.awscdk.services.quicksight.CfnAnalysis.StringFormatConfigurationProperty formatConfiguration) {
                this.formatConfiguration = formatConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link CategoricalDimensionFieldProperty#getHierarchyId}
             * @param hierarchyId The custom hierarchy ID.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hierarchyId(java.lang.String hierarchyId) {
                this.hierarchyId = hierarchyId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CategoricalDimensionFieldProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CategoricalDimensionFieldProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CategoricalDimensionFieldProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CategoricalDimensionFieldProperty {
            private final java.lang.Object column;
            private final java.lang.String fieldId;
            private final java.lang.Object formatConfiguration;
            private final java.lang.String hierarchyId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.column = software.amazon.jsii.Kernel.get(this, "column", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.fieldId = software.amazon.jsii.Kernel.get(this, "fieldId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.formatConfiguration = software.amazon.jsii.Kernel.get(this, "formatConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.hierarchyId = software.amazon.jsii.Kernel.get(this, "hierarchyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.column = java.util.Objects.requireNonNull(builder.column, "column is required");
                this.fieldId = java.util.Objects.requireNonNull(builder.fieldId, "fieldId is required");
                this.formatConfiguration = builder.formatConfiguration;
                this.hierarchyId = builder.hierarchyId;
            }

            @Override
            public final java.lang.Object getColumn() {
                return this.column;
            }

            @Override
            public final java.lang.String getFieldId() {
                return this.fieldId;
            }

            @Override
            public final java.lang.Object getFormatConfiguration() {
                return this.formatConfiguration;
            }

            @Override
            public final java.lang.String getHierarchyId() {
                return this.hierarchyId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("column", om.valueToTree(this.getColumn()));
                data.set("fieldId", om.valueToTree(this.getFieldId()));
                if (this.getFormatConfiguration() != null) {
                    data.set("formatConfiguration", om.valueToTree(this.getFormatConfiguration()));
                }
                if (this.getHierarchyId() != null) {
                    data.set("hierarchyId", om.valueToTree(this.getHierarchyId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.CategoricalDimensionFieldProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CategoricalDimensionFieldProperty.Jsii$Proxy that = (CategoricalDimensionFieldProperty.Jsii$Proxy) o;

                if (!column.equals(that.column)) return false;
                if (!fieldId.equals(that.fieldId)) return false;
                if (this.formatConfiguration != null ? !this.formatConfiguration.equals(that.formatConfiguration) : that.formatConfiguration != null) return false;
                return this.hierarchyId != null ? this.hierarchyId.equals(that.hierarchyId) : that.hierarchyId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.column.hashCode();
                result = 31 * result + (this.fieldId.hashCode());
                result = 31 * result + (this.formatConfiguration != null ? this.formatConfiguration.hashCode() : 0);
                result = 31 * result + (this.hierarchyId != null ? this.hierarchyId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The measure type field with categorical type columns.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * CategoricalMeasureFieldProperty categoricalMeasureFieldProperty = CategoricalMeasureFieldProperty.builder()
     *         .column(ColumnIdentifierProperty.builder()
     *                 .columnName("columnName")
     *                 .dataSetIdentifier("dataSetIdentifier")
     *                 .build())
     *         .fieldId("fieldId")
     *         // the properties below are optional
     *         .aggregationFunction("aggregationFunction")
     *         .formatConfiguration(StringFormatConfigurationProperty.builder()
     *                 .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
     *                         .nullString("nullString")
     *                         .build())
     *                 .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
     *                         .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
     *                                 .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
     *                                         .decimalPlaces(123)
     *                                         .build())
     *                                 .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
     *                                         .displayMode("displayMode")
     *                                         .build())
     *                                 .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
     *                                         .nullString("nullString")
     *                                         .build())
     *                                 .numberScale("numberScale")
     *                                 .prefix("prefix")
     *                                 .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
     *                                         .decimalSeparator("decimalSeparator")
     *                                         .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
     *                                                 .symbol("symbol")
     *                                                 .visibility("visibility")
     *                                                 .build())
     *                                         .build())
     *                                 .suffix("suffix")
     *                                 .symbol("symbol")
     *                                 .build())
     *                         .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
     *                                 .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
     *                                         .decimalPlaces(123)
     *                                         .build())
     *                                 .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
     *                                         .displayMode("displayMode")
     *                                         .build())
     *                                 .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
     *                                         .nullString("nullString")
     *                                         .build())
     *                                 .numberScale("numberScale")
     *                                 .prefix("prefix")
     *                                 .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
     *                                         .decimalSeparator("decimalSeparator")
     *                                         .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
     *                                                 .symbol("symbol")
     *                                                 .visibility("visibility")
     *                                                 .build())
     *                                         .build())
     *                                 .suffix("suffix")
     *                                 .build())
     *                         .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
     *                                 .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
     *                                         .decimalPlaces(123)
     *                                         .build())
     *                                 .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
     *                                         .displayMode("displayMode")
     *                                         .build())
     *                                 .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
     *                                         .nullString("nullString")
     *                                         .build())
     *                                 .prefix("prefix")
     *                                 .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
     *                                         .decimalSeparator("decimalSeparator")
     *                                         .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
     *                                                 .symbol("symbol")
     *                                                 .visibility("visibility")
     *                                                 .build())
     *                                         .build())
     *                                 .suffix("suffix")
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoricalmeasurefield.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoricalmeasurefield.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.CategoricalMeasureFieldProperty")
    @software.amazon.jsii.Jsii.Proxy(CategoricalMeasureFieldProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CategoricalMeasureFieldProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The column that is used in the <code>CategoricalMeasureField</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoricalmeasurefield.html#cfn-quicksight-analysis-categoricalmeasurefield-column">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoricalmeasurefield.html#cfn-quicksight-analysis-categoricalmeasurefield-column</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getColumn();

        /**
         * The custom field ID.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoricalmeasurefield.html#cfn-quicksight-analysis-categoricalmeasurefield-fieldid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoricalmeasurefield.html#cfn-quicksight-analysis-categoricalmeasurefield-fieldid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFieldId();

        /**
         * The aggregation function of the measure field.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoricalmeasurefield.html#cfn-quicksight-analysis-categoricalmeasurefield-aggregationfunction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoricalmeasurefield.html#cfn-quicksight-analysis-categoricalmeasurefield-aggregationfunction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAggregationFunction() {
            return null;
        }

        /**
         * The format configuration of the field.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoricalmeasurefield.html#cfn-quicksight-analysis-categoricalmeasurefield-formatconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoricalmeasurefield.html#cfn-quicksight-analysis-categoricalmeasurefield-formatconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFormatConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CategoricalMeasureFieldProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CategoricalMeasureFieldProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CategoricalMeasureFieldProperty> {
            java.lang.Object column;
            java.lang.String fieldId;
            java.lang.String aggregationFunction;
            java.lang.Object formatConfiguration;

            /**
             * Sets the value of {@link CategoricalMeasureFieldProperty#getColumn}
             * @param column The column that is used in the <code>CategoricalMeasureField</code> . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder column(software.amazon.awscdk.IResolvable column) {
                this.column = column;
                return this;
            }

            /**
             * Sets the value of {@link CategoricalMeasureFieldProperty#getColumn}
             * @param column The column that is used in the <code>CategoricalMeasureField</code> . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder column(software.amazon.awscdk.services.quicksight.CfnAnalysis.ColumnIdentifierProperty column) {
                this.column = column;
                return this;
            }

            /**
             * Sets the value of {@link CategoricalMeasureFieldProperty#getFieldId}
             * @param fieldId The custom field ID. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldId(java.lang.String fieldId) {
                this.fieldId = fieldId;
                return this;
            }

            /**
             * Sets the value of {@link CategoricalMeasureFieldProperty#getAggregationFunction}
             * @param aggregationFunction The aggregation function of the measure field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aggregationFunction(java.lang.String aggregationFunction) {
                this.aggregationFunction = aggregationFunction;
                return this;
            }

            /**
             * Sets the value of {@link CategoricalMeasureFieldProperty#getFormatConfiguration}
             * @param formatConfiguration The format configuration of the field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder formatConfiguration(software.amazon.awscdk.IResolvable formatConfiguration) {
                this.formatConfiguration = formatConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link CategoricalMeasureFieldProperty#getFormatConfiguration}
             * @param formatConfiguration The format configuration of the field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder formatConfiguration(software.amazon.awscdk.services.quicksight.CfnAnalysis.StringFormatConfigurationProperty formatConfiguration) {
                this.formatConfiguration = formatConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CategoricalMeasureFieldProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CategoricalMeasureFieldProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CategoricalMeasureFieldProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CategoricalMeasureFieldProperty {
            private final java.lang.Object column;
            private final java.lang.String fieldId;
            private final java.lang.String aggregationFunction;
            private final java.lang.Object formatConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.column = software.amazon.jsii.Kernel.get(this, "column", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.fieldId = software.amazon.jsii.Kernel.get(this, "fieldId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.aggregationFunction = software.amazon.jsii.Kernel.get(this, "aggregationFunction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.formatConfiguration = software.amazon.jsii.Kernel.get(this, "formatConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.column = java.util.Objects.requireNonNull(builder.column, "column is required");
                this.fieldId = java.util.Objects.requireNonNull(builder.fieldId, "fieldId is required");
                this.aggregationFunction = builder.aggregationFunction;
                this.formatConfiguration = builder.formatConfiguration;
            }

            @Override
            public final java.lang.Object getColumn() {
                return this.column;
            }

            @Override
            public final java.lang.String getFieldId() {
                return this.fieldId;
            }

            @Override
            public final java.lang.String getAggregationFunction() {
                return this.aggregationFunction;
            }

            @Override
            public final java.lang.Object getFormatConfiguration() {
                return this.formatConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("column", om.valueToTree(this.getColumn()));
                data.set("fieldId", om.valueToTree(this.getFieldId()));
                if (this.getAggregationFunction() != null) {
                    data.set("aggregationFunction", om.valueToTree(this.getAggregationFunction()));
                }
                if (this.getFormatConfiguration() != null) {
                    data.set("formatConfiguration", om.valueToTree(this.getFormatConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.CategoricalMeasureFieldProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CategoricalMeasureFieldProperty.Jsii$Proxy that = (CategoricalMeasureFieldProperty.Jsii$Proxy) o;

                if (!column.equals(that.column)) return false;
                if (!fieldId.equals(that.fieldId)) return false;
                if (this.aggregationFunction != null ? !this.aggregationFunction.equals(that.aggregationFunction) : that.aggregationFunction != null) return false;
                return this.formatConfiguration != null ? this.formatConfiguration.equals(that.formatConfiguration) : that.formatConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.column.hashCode();
                result = 31 * result + (this.fieldId.hashCode());
                result = 31 * result + (this.aggregationFunction != null ? this.aggregationFunction.hashCode() : 0);
                result = 31 * result + (this.formatConfiguration != null ? this.formatConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The category drill down filter.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * CategoryDrillDownFilterProperty categoryDrillDownFilterProperty = CategoryDrillDownFilterProperty.builder()
     *         .categoryValues(List.of("categoryValues"))
     *         .column(ColumnIdentifierProperty.builder()
     *                 .columnName("columnName")
     *                 .dataSetIdentifier("dataSetIdentifier")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categorydrilldownfilter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categorydrilldownfilter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.CategoryDrillDownFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(CategoryDrillDownFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CategoryDrillDownFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of the string inputs that are the values of the category drill down filter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categorydrilldownfilter.html#cfn-quicksight-analysis-categorydrilldownfilter-categoryvalues">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categorydrilldownfilter.html#cfn-quicksight-analysis-categorydrilldownfilter-categoryvalues</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getCategoryValues();

        /**
         * The column that the filter is applied to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categorydrilldownfilter.html#cfn-quicksight-analysis-categorydrilldownfilter-column">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categorydrilldownfilter.html#cfn-quicksight-analysis-categorydrilldownfilter-column</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getColumn();

        /**
         * @return a {@link Builder} of {@link CategoryDrillDownFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CategoryDrillDownFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CategoryDrillDownFilterProperty> {
            java.util.List<java.lang.String> categoryValues;
            java.lang.Object column;

            /**
             * Sets the value of {@link CategoryDrillDownFilterProperty#getCategoryValues}
             * @param categoryValues A list of the string inputs that are the values of the category drill down filter. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder categoryValues(java.util.List<java.lang.String> categoryValues) {
                this.categoryValues = categoryValues;
                return this;
            }

            /**
             * Sets the value of {@link CategoryDrillDownFilterProperty#getColumn}
             * @param column The column that the filter is applied to. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder column(software.amazon.awscdk.IResolvable column) {
                this.column = column;
                return this;
            }

            /**
             * Sets the value of {@link CategoryDrillDownFilterProperty#getColumn}
             * @param column The column that the filter is applied to. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder column(software.amazon.awscdk.services.quicksight.CfnAnalysis.ColumnIdentifierProperty column) {
                this.column = column;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CategoryDrillDownFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CategoryDrillDownFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CategoryDrillDownFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CategoryDrillDownFilterProperty {
            private final java.util.List<java.lang.String> categoryValues;
            private final java.lang.Object column;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.categoryValues = software.amazon.jsii.Kernel.get(this, "categoryValues", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.column = software.amazon.jsii.Kernel.get(this, "column", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.categoryValues = java.util.Objects.requireNonNull(builder.categoryValues, "categoryValues is required");
                this.column = java.util.Objects.requireNonNull(builder.column, "column is required");
            }

            @Override
            public final java.util.List<java.lang.String> getCategoryValues() {
                return this.categoryValues;
            }

            @Override
            public final java.lang.Object getColumn() {
                return this.column;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("categoryValues", om.valueToTree(this.getCategoryValues()));
                data.set("column", om.valueToTree(this.getColumn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.CategoryDrillDownFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CategoryDrillDownFilterProperty.Jsii$Proxy that = (CategoryDrillDownFilterProperty.Jsii$Proxy) o;

                if (!categoryValues.equals(that.categoryValues)) return false;
                return this.column.equals(that.column);
            }

            @Override
            public final int hashCode() {
                int result = this.categoryValues.hashCode();
                result = 31 * result + (this.column.hashCode());
                return result;
            }
        }
    }
    /**
     * The configuration for a <code>CategoryFilter</code> .
     * <p>
     * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * CategoryFilterConfigurationProperty categoryFilterConfigurationProperty = CategoryFilterConfigurationProperty.builder()
     *         .customFilterConfiguration(CustomFilterConfigurationProperty.builder()
     *                 .matchOperator("matchOperator")
     *                 .nullOption("nullOption")
     *                 // the properties below are optional
     *                 .categoryValue("categoryValue")
     *                 .parameterName("parameterName")
     *                 .selectAllOptions("selectAllOptions")
     *                 .build())
     *         .customFilterListConfiguration(CustomFilterListConfigurationProperty.builder()
     *                 .matchOperator("matchOperator")
     *                 .nullOption("nullOption")
     *                 // the properties below are optional
     *                 .categoryValues(List.of("categoryValues"))
     *                 .selectAllOptions("selectAllOptions")
     *                 .build())
     *         .filterListConfiguration(FilterListConfigurationProperty.builder()
     *                 .matchOperator("matchOperator")
     *                 // the properties below are optional
     *                 .categoryValues(List.of("categoryValues"))
     *                 .nullOption("nullOption")
     *                 .selectAllOptions("selectAllOptions")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoryfilterconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoryfilterconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.CategoryFilterConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(CategoryFilterConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CategoryFilterConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A custom filter that filters based on a single value.
         * <p>
         * This filter can be partially matched.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoryfilterconfiguration.html#cfn-quicksight-analysis-categoryfilterconfiguration-customfilterconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoryfilterconfiguration.html#cfn-quicksight-analysis-categoryfilterconfiguration-customfilterconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomFilterConfiguration() {
            return null;
        }

        /**
         * A list of custom filter values.
         * <p>
         * In the Amazon QuickSight console, this filter type is called a custom filter list.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoryfilterconfiguration.html#cfn-quicksight-analysis-categoryfilterconfiguration-customfilterlistconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoryfilterconfiguration.html#cfn-quicksight-analysis-categoryfilterconfiguration-customfilterlistconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomFilterListConfiguration() {
            return null;
        }

        /**
         * A list of filter configurations.
         * <p>
         * In the Amazon QuickSight console, this filter type is called a filter list.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoryfilterconfiguration.html#cfn-quicksight-analysis-categoryfilterconfiguration-filterlistconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoryfilterconfiguration.html#cfn-quicksight-analysis-categoryfilterconfiguration-filterlistconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFilterListConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CategoryFilterConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CategoryFilterConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CategoryFilterConfigurationProperty> {
            java.lang.Object customFilterConfiguration;
            java.lang.Object customFilterListConfiguration;
            java.lang.Object filterListConfiguration;

            /**
             * Sets the value of {@link CategoryFilterConfigurationProperty#getCustomFilterConfiguration}
             * @param customFilterConfiguration A custom filter that filters based on a single value.
             *                                  This filter can be partially matched.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customFilterConfiguration(software.amazon.awscdk.IResolvable customFilterConfiguration) {
                this.customFilterConfiguration = customFilterConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link CategoryFilterConfigurationProperty#getCustomFilterConfiguration}
             * @param customFilterConfiguration A custom filter that filters based on a single value.
             *                                  This filter can be partially matched.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customFilterConfiguration(software.amazon.awscdk.services.quicksight.CfnAnalysis.CustomFilterConfigurationProperty customFilterConfiguration) {
                this.customFilterConfiguration = customFilterConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link CategoryFilterConfigurationProperty#getCustomFilterListConfiguration}
             * @param customFilterListConfiguration A list of custom filter values.
             *                                      In the Amazon QuickSight console, this filter type is called a custom filter list.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customFilterListConfiguration(software.amazon.awscdk.IResolvable customFilterListConfiguration) {
                this.customFilterListConfiguration = customFilterListConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link CategoryFilterConfigurationProperty#getCustomFilterListConfiguration}
             * @param customFilterListConfiguration A list of custom filter values.
             *                                      In the Amazon QuickSight console, this filter type is called a custom filter list.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customFilterListConfiguration(software.amazon.awscdk.services.quicksight.CfnAnalysis.CustomFilterListConfigurationProperty customFilterListConfiguration) {
                this.customFilterListConfiguration = customFilterListConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link CategoryFilterConfigurationProperty#getFilterListConfiguration}
             * @param filterListConfiguration A list of filter configurations.
             *                                In the Amazon QuickSight console, this filter type is called a filter list.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filterListConfiguration(software.amazon.awscdk.IResolvable filterListConfiguration) {
                this.filterListConfiguration = filterListConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link CategoryFilterConfigurationProperty#getFilterListConfiguration}
             * @param filterListConfiguration A list of filter configurations.
             *                                In the Amazon QuickSight console, this filter type is called a filter list.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filterListConfiguration(software.amazon.awscdk.services.quicksight.CfnAnalysis.FilterListConfigurationProperty filterListConfiguration) {
                this.filterListConfiguration = filterListConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CategoryFilterConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CategoryFilterConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CategoryFilterConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CategoryFilterConfigurationProperty {
            private final java.lang.Object customFilterConfiguration;
            private final java.lang.Object customFilterListConfiguration;
            private final java.lang.Object filterListConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.customFilterConfiguration = software.amazon.jsii.Kernel.get(this, "customFilterConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.customFilterListConfiguration = software.amazon.jsii.Kernel.get(this, "customFilterListConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.filterListConfiguration = software.amazon.jsii.Kernel.get(this, "filterListConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.customFilterConfiguration = builder.customFilterConfiguration;
                this.customFilterListConfiguration = builder.customFilterListConfiguration;
                this.filterListConfiguration = builder.filterListConfiguration;
            }

            @Override
            public final java.lang.Object getCustomFilterConfiguration() {
                return this.customFilterConfiguration;
            }

            @Override
            public final java.lang.Object getCustomFilterListConfiguration() {
                return this.customFilterListConfiguration;
            }

            @Override
            public final java.lang.Object getFilterListConfiguration() {
                return this.filterListConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCustomFilterConfiguration() != null) {
                    data.set("customFilterConfiguration", om.valueToTree(this.getCustomFilterConfiguration()));
                }
                if (this.getCustomFilterListConfiguration() != null) {
                    data.set("customFilterListConfiguration", om.valueToTree(this.getCustomFilterListConfiguration()));
                }
                if (this.getFilterListConfiguration() != null) {
                    data.set("filterListConfiguration", om.valueToTree(this.getFilterListConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.CategoryFilterConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CategoryFilterConfigurationProperty.Jsii$Proxy that = (CategoryFilterConfigurationProperty.Jsii$Proxy) o;

                if (this.customFilterConfiguration != null ? !this.customFilterConfiguration.equals(that.customFilterConfiguration) : that.customFilterConfiguration != null) return false;
                if (this.customFilterListConfiguration != null ? !this.customFilterListConfiguration.equals(that.customFilterListConfiguration) : that.customFilterListConfiguration != null) return false;
                return this.filterListConfiguration != null ? this.filterListConfiguration.equals(that.filterListConfiguration) : that.filterListConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.customFilterConfiguration != null ? this.customFilterConfiguration.hashCode() : 0;
                result = 31 * result + (this.customFilterListConfiguration != null ? this.customFilterListConfiguration.hashCode() : 0);
                result = 31 * result + (this.filterListConfiguration != null ? this.filterListConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A <code>CategoryFilter</code> filters text values.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/add-a-text-filter-data-prep.html">Adding text filters</a> in the <em>Amazon QuickSight User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * CategoryFilterProperty categoryFilterProperty = CategoryFilterProperty.builder()
     *         .column(ColumnIdentifierProperty.builder()
     *                 .columnName("columnName")
     *                 .dataSetIdentifier("dataSetIdentifier")
     *                 .build())
     *         .configuration(CategoryFilterConfigurationProperty.builder()
     *                 .customFilterConfiguration(CustomFilterConfigurationProperty.builder()
     *                         .matchOperator("matchOperator")
     *                         .nullOption("nullOption")
     *                         // the properties below are optional
     *                         .categoryValue("categoryValue")
     *                         .parameterName("parameterName")
     *                         .selectAllOptions("selectAllOptions")
     *                         .build())
     *                 .customFilterListConfiguration(CustomFilterListConfigurationProperty.builder()
     *                         .matchOperator("matchOperator")
     *                         .nullOption("nullOption")
     *                         // the properties below are optional
     *                         .categoryValues(List.of("categoryValues"))
     *                         .selectAllOptions("selectAllOptions")
     *                         .build())
     *                 .filterListConfiguration(FilterListConfigurationProperty.builder()
     *                         .matchOperator("matchOperator")
     *                         // the properties below are optional
     *                         .categoryValues(List.of("categoryValues"))
     *                         .nullOption("nullOption")
     *                         .selectAllOptions("selectAllOptions")
     *                         .build())
     *                 .build())
     *         .filterId("filterId")
     *         // the properties below are optional
     *         .defaultFilterControlConfiguration(DefaultFilterControlConfigurationProperty.builder()
     *                 .controlOptions(DefaultFilterControlOptionsProperty.builder()
     *                         .defaultDateTimePickerOptions(DefaultDateTimePickerControlOptionsProperty.builder()
     *                                 .displayOptions(DateTimePickerControlDisplayOptionsProperty.builder()
     *                                         .dateTimeFormat("dateTimeFormat")
     *                                         .infoIconLabelOptions(SheetControlInfoIconLabelOptionsProperty.builder()
     *                                                 .infoIconText("infoIconText")
     *                                                 .visibility("visibility")
     *                                                 .build())
     *                                         .titleOptions(LabelOptionsProperty.builder()
     *                                                 .customLabel("customLabel")
     *                                                 .fontConfiguration(FontConfigurationProperty.builder()
     *                                                         .fontColor("fontColor")
     *                                                         .fontDecoration("fontDecoration")
     *                                                         .fontSize(FontSizeProperty.builder()
     *                                                                 .relative("relative")
     *                                                                 .build())
     *                                                         .fontStyle("fontStyle")
     *                                                         .fontWeight(FontWeightProperty.builder()
     *                                                                 .name("name")
     *                                                                 .build())
     *                                                         .build())
     *                                                 .visibility("visibility")
     *                                                 .build())
     *                                         .build())
     *                                 .type("type")
     *                                 .build())
     *                         .defaultDropdownOptions(DefaultFilterDropDownControlOptionsProperty.builder()
     *                                 .displayOptions(DropDownControlDisplayOptionsProperty.builder()
     *                                         .infoIconLabelOptions(SheetControlInfoIconLabelOptionsProperty.builder()
     *                                                 .infoIconText("infoIconText")
     *                                                 .visibility("visibility")
     *                                                 .build())
     *                                         .selectAllOptions(ListControlSelectAllOptionsProperty.builder()
     *                                                 .visibility("visibility")
     *                                                 .build())
     *                                         .titleOptions(LabelOptionsProperty.builder()
     *                                                 .customLabel("customLabel")
     *                                                 .fontConfiguration(FontConfigurationProperty.builder()
     *                                                         .fontColor("fontColor")
     *                                                         .fontDecoration("fontDecoration")
     *                                                         .fontSize(FontSizeProperty.builder()
     *                                                                 .relative("relative")
     *                                                                 .build())
     *                                                         .fontStyle("fontStyle")
     *                                                         .fontWeight(FontWeightProperty.builder()
     *                                                                 .name("name")
     *                                                                 .build())
     *                                                         .build())
     *                                                 .visibility("visibility")
     *                                                 .build())
     *                                         .build())
     *                                 .selectableValues(FilterSelectableValuesProperty.builder()
     *                                         .values(List.of("values"))
     *                                         .build())
     *                                 .type("type")
     *                                 .build())
     *                         .defaultListOptions(DefaultFilterListControlOptionsProperty.builder()
     *                                 .displayOptions(ListControlDisplayOptionsProperty.builder()
     *                                         .infoIconLabelOptions(SheetControlInfoIconLabelOptionsProperty.builder()
     *                                                 .infoIconText("infoIconText")
     *                                                 .visibility("visibility")
     *                                                 .build())
     *                                         .searchOptions(ListControlSearchOptionsProperty.builder()
     *                                                 .visibility("visibility")
     *                                                 .build())
     *                                         .selectAllOptions(ListControlSelectAllOptionsProperty.builder()
     *                                                 .visibility("visibility")
     *                                                 .build())
     *                                         .titleOptions(LabelOptionsProperty.builder()
     *                                                 .customLabel("customLabel")
     *                                                 .fontConfiguration(FontConfigurationProperty.builder()
     *                                                         .fontColor("fontColor")
     *                                                         .fontDecoration("fontDecoration")
     *                                                         .fontSize(FontSizeProperty.builder()
     *                                                                 .relative("relative")
     *                                                                 .build())
     *                                                         .fontStyle("fontStyle")
     *                                                         .fontWeight(FontWeightProperty.builder()
     *                                                                 .name("name")
     *                                                                 .build())
     *                                                         .build())
     *                                                 .visibility("visibility")
     *                                                 .build())
     *                                         .build())
     *                                 .selectableValues(FilterSelectableValuesProperty.builder()
     *                                         .values(List.of("values"))
     *                                         .build())
     *                                 .type("type")
     *                                 .build())
     *                         .defaultRelativeDateTimeOptions(DefaultRelativeDateTimeControlOptionsProperty.builder()
     *                                 .displayOptions(RelativeDateTimeControlDisplayOptionsProperty.builder()
     *                                         .dateTimeFormat("dateTimeFormat")
     *                                         .infoIconLabelOptions(SheetControlInfoIconLabelOptionsProperty.builder()
     *                                                 .infoIconText("infoIconText")
     *                                                 .visibility("visibility")
     *                                                 .build())
     *                                         .titleOptions(LabelOptionsProperty.builder()
     *                                                 .customLabel("customLabel")
     *                                                 .fontConfiguration(FontConfigurationProperty.builder()
     *                                                         .fontColor("fontColor")
     *                                                         .fontDecoration("fontDecoration")
     *                                                         .fontSize(FontSizeProperty.builder()
     *                                                                 .relative("relative")
     *                                                                 .build())
     *                                                         .fontStyle("fontStyle")
     *                                                         .fontWeight(FontWeightProperty.builder()
     *                                                                 .name("name")
     *                                                                 .build())
     *                                                         .build())
     *                                                 .visibility("visibility")
     *                                                 .build())
     *                                         .build())
     *                                 .build())
     *                         .defaultSliderOptions(DefaultSliderControlOptionsProperty.builder()
     *                                 .maximumValue(123)
     *                                 .minimumValue(123)
     *                                 .stepSize(123)
     *                                 // the properties below are optional
     *                                 .displayOptions(SliderControlDisplayOptionsProperty.builder()
     *                                         .infoIconLabelOptions(SheetControlInfoIconLabelOptionsProperty.builder()
     *                                                 .infoIconText("infoIconText")
     *                                                 .visibility("visibility")
     *                                                 .build())
     *                                         .titleOptions(LabelOptionsProperty.builder()
     *                                                 .customLabel("customLabel")
     *                                                 .fontConfiguration(FontConfigurationProperty.builder()
     *                                                         .fontColor("fontColor")
     *                                                         .fontDecoration("fontDecoration")
     *                                                         .fontSize(FontSizeProperty.builder()
     *                                                                 .relative("relative")
     *                                                                 .build())
     *                                                         .fontStyle("fontStyle")
     *                                                         .fontWeight(FontWeightProperty.builder()
     *                                                                 .name("name")
     *                                                                 .build())
     *                                                         .build())
     *                                                 .visibility("visibility")
     *                                                 .build())
     *                                         .build())
     *                                 .type("type")
     *                                 .build())
     *                         .defaultTextAreaOptions(DefaultTextAreaControlOptionsProperty.builder()
     *                                 .delimiter("delimiter")
     *                                 .displayOptions(TextAreaControlDisplayOptionsProperty.builder()
     *                                         .infoIconLabelOptions(SheetControlInfoIconLabelOptionsProperty.builder()
     *                                                 .infoIconText("infoIconText")
     *                                                 .visibility("visibility")
     *                                                 .build())
     *                                         .placeholderOptions(TextControlPlaceholderOptionsProperty.builder()
     *                                                 .visibility("visibility")
     *                                                 .build())
     *                                         .titleOptions(LabelOptionsProperty.builder()
     *                                                 .customLabel("customLabel")
     *                                                 .fontConfiguration(FontConfigurationProperty.builder()
     *                                                         .fontColor("fontColor")
     *                                                         .fontDecoration("fontDecoration")
     *                                                         .fontSize(FontSizeProperty.builder()
     *                                                                 .relative("relative")
     *                                                                 .build())
     *                                                         .fontStyle("fontStyle")
     *                                                         .fontWeight(FontWeightProperty.builder()
     *                                                                 .name("name")
     *                                                                 .build())
     *                                                         .build())
     *                                                 .visibility("visibility")
     *                                                 .build())
     *                                         .build())
     *                                 .build())
     *                         .defaultTextFieldOptions(DefaultTextFieldControlOptionsProperty.builder()
     *                                 .displayOptions(TextFieldControlDisplayOptionsProperty.builder()
     *                                         .infoIconLabelOptions(SheetControlInfoIconLabelOptionsProperty.builder()
     *                                                 .infoIconText("infoIconText")
     *                                                 .visibility("visibility")
     *                                                 .build())
     *                                         .placeholderOptions(TextControlPlaceholderOptionsProperty.builder()
     *                                                 .visibility("visibility")
     *                                                 .build())
     *                                         .titleOptions(LabelOptionsProperty.builder()
     *                                                 .customLabel("customLabel")
     *                                                 .fontConfiguration(FontConfigurationProperty.builder()
     *                                                         .fontColor("fontColor")
     *                                                         .fontDecoration("fontDecoration")
     *                                                         .fontSize(FontSizeProperty.builder()
     *                                                                 .relative("relative")
     *                                                                 .build())
     *                                                         .fontStyle("fontStyle")
     *                                                         .fontWeight(FontWeightProperty.builder()
     *                                                                 .name("name")
     *                                                                 .build())
     *                                                         .build())
     *                                                 .visibility("visibility")
     *                                                 .build())
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 .title("title")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoryfilter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoryfilter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.CategoryFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(CategoryFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CategoryFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The column that the filter is applied to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoryfilter.html#cfn-quicksight-analysis-categoryfilter-column">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoryfilter.html#cfn-quicksight-analysis-categoryfilter-column</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getColumn();

        /**
         * The configuration for a <code>CategoryFilter</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoryfilter.html#cfn-quicksight-analysis-categoryfilter-configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoryfilter.html#cfn-quicksight-analysis-categoryfilter-configuration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getConfiguration();

        /**
         * An identifier that uniquely identifies a filter within a dashboard, analysis, or template.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoryfilter.html#cfn-quicksight-analysis-categoryfilter-filterid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoryfilter.html#cfn-quicksight-analysis-categoryfilter-filterid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFilterId();

        /**
         * The default configurations for the associated controls.
         * <p>
         * This applies only for filters that are scoped to multiple sheets.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoryfilter.html#cfn-quicksight-analysis-categoryfilter-defaultfiltercontrolconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoryfilter.html#cfn-quicksight-analysis-categoryfilter-defaultfiltercontrolconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDefaultFilterControlConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CategoryFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CategoryFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CategoryFilterProperty> {
            java.lang.Object column;
            java.lang.Object configuration;
            java.lang.String filterId;
            java.lang.Object defaultFilterControlConfiguration;

            /**
             * Sets the value of {@link CategoryFilterProperty#getColumn}
             * @param column The column that the filter is applied to. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder column(software.amazon.awscdk.IResolvable column) {
                this.column = column;
                return this;
            }

            /**
             * Sets the value of {@link CategoryFilterProperty#getColumn}
             * @param column The column that the filter is applied to. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder column(software.amazon.awscdk.services.quicksight.CfnAnalysis.ColumnIdentifierProperty column) {
                this.column = column;
                return this;
            }

            /**
             * Sets the value of {@link CategoryFilterProperty#getConfiguration}
             * @param configuration The configuration for a <code>CategoryFilter</code> . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configuration(software.amazon.awscdk.IResolvable configuration) {
                this.configuration = configuration;
                return this;
            }

            /**
             * Sets the value of {@link CategoryFilterProperty#getConfiguration}
             * @param configuration The configuration for a <code>CategoryFilter</code> . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configuration(software.amazon.awscdk.services.quicksight.CfnAnalysis.CategoryFilterConfigurationProperty configuration) {
                this.configuration = configuration;
                return this;
            }

            /**
             * Sets the value of {@link CategoryFilterProperty#getFilterId}
             * @param filterId An identifier that uniquely identifies a filter within a dashboard, analysis, or template. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filterId(java.lang.String filterId) {
                this.filterId = filterId;
                return this;
            }

            /**
             * Sets the value of {@link CategoryFilterProperty#getDefaultFilterControlConfiguration}
             * @param defaultFilterControlConfiguration The default configurations for the associated controls.
             *                                          This applies only for filters that are scoped to multiple sheets.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultFilterControlConfiguration(software.amazon.awscdk.IResolvable defaultFilterControlConfiguration) {
                this.defaultFilterControlConfiguration = defaultFilterControlConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link CategoryFilterProperty#getDefaultFilterControlConfiguration}
             * @param defaultFilterControlConfiguration The default configurations for the associated controls.
             *                                          This applies only for filters that are scoped to multiple sheets.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultFilterControlConfiguration(software.amazon.awscdk.services.quicksight.CfnAnalysis.DefaultFilterControlConfigurationProperty defaultFilterControlConfiguration) {
                this.defaultFilterControlConfiguration = defaultFilterControlConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CategoryFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CategoryFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CategoryFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CategoryFilterProperty {
            private final java.lang.Object column;
            private final java.lang.Object configuration;
            private final java.lang.String filterId;
            private final java.lang.Object defaultFilterControlConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.column = software.amazon.jsii.Kernel.get(this, "column", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.configuration = software.amazon.jsii.Kernel.get(this, "configuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.filterId = software.amazon.jsii.Kernel.get(this, "filterId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.defaultFilterControlConfiguration = software.amazon.jsii.Kernel.get(this, "defaultFilterControlConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.column = java.util.Objects.requireNonNull(builder.column, "column is required");
                this.configuration = java.util.Objects.requireNonNull(builder.configuration, "configuration is required");
                this.filterId = java.util.Objects.requireNonNull(builder.filterId, "filterId is required");
                this.defaultFilterControlConfiguration = builder.defaultFilterControlConfiguration;
            }

            @Override
            public final java.lang.Object getColumn() {
                return this.column;
            }

            @Override
            public final java.lang.Object getConfiguration() {
                return this.configuration;
            }

            @Override
            public final java.lang.String getFilterId() {
                return this.filterId;
            }

            @Override
            public final java.lang.Object getDefaultFilterControlConfiguration() {
                return this.defaultFilterControlConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("column", om.valueToTree(this.getColumn()));
                data.set("configuration", om.valueToTree(this.getConfiguration()));
                data.set("filterId", om.valueToTree(this.getFilterId()));
                if (this.getDefaultFilterControlConfiguration() != null) {
                    data.set("defaultFilterControlConfiguration", om.valueToTree(this.getDefaultFilterControlConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.CategoryFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CategoryFilterProperty.Jsii$Proxy that = (CategoryFilterProperty.Jsii$Proxy) o;

                if (!column.equals(that.column)) return false;
                if (!configuration.equals(that.configuration)) return false;
                if (!filterId.equals(that.filterId)) return false;
                return this.defaultFilterControlConfiguration != null ? this.defaultFilterControlConfiguration.equals(that.defaultFilterControlConfiguration) : that.defaultFilterControlConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.column.hashCode();
                result = 31 * result + (this.configuration.hashCode());
                result = 31 * result + (this.filterId.hashCode());
                result = 31 * result + (this.defaultFilterControlConfiguration != null ? this.defaultFilterControlConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The label options for an axis on a chart.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * ChartAxisLabelOptionsProperty chartAxisLabelOptionsProperty = ChartAxisLabelOptionsProperty.builder()
     *         .axisLabelOptions(List.of(AxisLabelOptionsProperty.builder()
     *                 .applyTo(AxisLabelReferenceOptionsProperty.builder()
     *                         .column(ColumnIdentifierProperty.builder()
     *                                 .columnName("columnName")
     *                                 .dataSetIdentifier("dataSetIdentifier")
     *                                 .build())
     *                         .fieldId("fieldId")
     *                         .build())
     *                 .customLabel("customLabel")
     *                 .fontConfiguration(FontConfigurationProperty.builder()
     *                         .fontColor("fontColor")
     *                         .fontDecoration("fontDecoration")
     *                         .fontSize(FontSizeProperty.builder()
     *                                 .relative("relative")
     *                                 .build())
     *                         .fontStyle("fontStyle")
     *                         .fontWeight(FontWeightProperty.builder()
     *                                 .name("name")
     *                                 .build())
     *                         .build())
     *                 .build()))
     *         .sortIconVisibility("sortIconVisibility")
     *         .visibility("visibility")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-chartaxislabeloptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-chartaxislabeloptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.ChartAxisLabelOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(ChartAxisLabelOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ChartAxisLabelOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The label options for a chart axis.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-chartaxislabeloptions.html#cfn-quicksight-analysis-chartaxislabeloptions-axislabeloptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-chartaxislabeloptions.html#cfn-quicksight-analysis-chartaxislabeloptions-axislabeloptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAxisLabelOptions() {
            return null;
        }

        /**
         * The visibility configuration of the sort icon on a chart's axis label.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-chartaxislabeloptions.html#cfn-quicksight-analysis-chartaxislabeloptions-sorticonvisibility">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-chartaxislabeloptions.html#cfn-quicksight-analysis-chartaxislabeloptions-sorticonvisibility</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSortIconVisibility() {
            return null;
        }

        /**
         * The visibility of an axis label on a chart. Choose one of the following options:.
         * <p>
         * <ul>
         * <li><code>VISIBLE</code> : Shows the axis.</li>
         * <li><code>HIDDEN</code> : Hides the axis.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-chartaxislabeloptions.html#cfn-quicksight-analysis-chartaxislabeloptions-visibility">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-chartaxislabeloptions.html#cfn-quicksight-analysis-chartaxislabeloptions-visibility</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVisibility() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ChartAxisLabelOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ChartAxisLabelOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ChartAxisLabelOptionsProperty> {
            java.lang.Object axisLabelOptions;
            java.lang.String sortIconVisibility;
            java.lang.String visibility;

            /**
             * Sets the value of {@link ChartAxisLabelOptionsProperty#getAxisLabelOptions}
             * @param axisLabelOptions The label options for a chart axis.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder axisLabelOptions(software.amazon.awscdk.IResolvable axisLabelOptions) {
                this.axisLabelOptions = axisLabelOptions;
                return this;
            }

            /**
             * Sets the value of {@link ChartAxisLabelOptionsProperty#getAxisLabelOptions}
             * @param axisLabelOptions The label options for a chart axis.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder axisLabelOptions(java.util.List<? extends java.lang.Object> axisLabelOptions) {
                this.axisLabelOptions = axisLabelOptions;
                return this;
            }

            /**
             * Sets the value of {@link ChartAxisLabelOptionsProperty#getSortIconVisibility}
             * @param sortIconVisibility The visibility configuration of the sort icon on a chart's axis label.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sortIconVisibility(java.lang.String sortIconVisibility) {
                this.sortIconVisibility = sortIconVisibility;
                return this;
            }

            /**
             * Sets the value of {@link ChartAxisLabelOptionsProperty#getVisibility}
             * @param visibility The visibility of an axis label on a chart. Choose one of the following options:.
             *                   <ul>
             *                   <li><code>VISIBLE</code> : Shows the axis.</li>
             *                   <li><code>HIDDEN</code> : Hides the axis.</li>
             *                   </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder visibility(java.lang.String visibility) {
                this.visibility = visibility;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ChartAxisLabelOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ChartAxisLabelOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ChartAxisLabelOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ChartAxisLabelOptionsProperty {
            private final java.lang.Object axisLabelOptions;
            private final java.lang.String sortIconVisibility;
            private final java.lang.String visibility;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.axisLabelOptions = software.amazon.jsii.Kernel.get(this, "axisLabelOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sortIconVisibility = software.amazon.jsii.Kernel.get(this, "sortIconVisibility", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.visibility = software.amazon.jsii.Kernel.get(this, "visibility", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.axisLabelOptions = builder.axisLabelOptions;
                this.sortIconVisibility = builder.sortIconVisibility;
                this.visibility = builder.visibility;
            }

            @Override
            public final java.lang.Object getAxisLabelOptions() {
                return this.axisLabelOptions;
            }

            @Override
            public final java.lang.String getSortIconVisibility() {
                return this.sortIconVisibility;
            }

            @Override
            public final java.lang.String getVisibility() {
                return this.visibility;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAxisLabelOptions() != null) {
                    data.set("axisLabelOptions", om.valueToTree(this.getAxisLabelOptions()));
                }
                if (this.getSortIconVisibility() != null) {
                    data.set("sortIconVisibility", om.valueToTree(this.getSortIconVisibility()));
                }
                if (this.getVisibility() != null) {
                    data.set("visibility", om.valueToTree(this.getVisibility()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.ChartAxisLabelOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ChartAxisLabelOptionsProperty.Jsii$Proxy that = (ChartAxisLabelOptionsProperty.Jsii$Proxy) o;

                if (this.axisLabelOptions != null ? !this.axisLabelOptions.equals(that.axisLabelOptions) : that.axisLabelOptions != null) return false;
                if (this.sortIconVisibility != null ? !this.sortIconVisibility.equals(that.sortIconVisibility) : that.sortIconVisibility != null) return false;
                return this.visibility != null ? this.visibility.equals(that.visibility) : that.visibility == null;
            }

            @Override
            public final int hashCode() {
                int result = this.axisLabelOptions != null ? this.axisLabelOptions.hashCode() : 0;
                result = 31 * result + (this.sortIconVisibility != null ? this.sortIconVisibility.hashCode() : 0);
                result = 31 * result + (this.visibility != null ? this.visibility.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The cluster marker configuration of the geospatial map selected point style.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * ClusterMarkerConfigurationProperty clusterMarkerConfigurationProperty = ClusterMarkerConfigurationProperty.builder()
     *         .clusterMarker(ClusterMarkerProperty.builder()
     *                 .simpleClusterMarker(SimpleClusterMarkerProperty.builder()
     *                         .color("color")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-clustermarkerconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-clustermarkerconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.ClusterMarkerConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ClusterMarkerConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ClusterMarkerConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The cluster marker that is a part of the cluster marker configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-clustermarkerconfiguration.html#cfn-quicksight-analysis-clustermarkerconfiguration-clustermarker">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-clustermarkerconfiguration.html#cfn-quicksight-analysis-clustermarkerconfiguration-clustermarker</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getClusterMarker() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ClusterMarkerConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ClusterMarkerConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ClusterMarkerConfigurationProperty> {
            java.lang.Object clusterMarker;

            /**
             * Sets the value of {@link ClusterMarkerConfigurationProperty#getClusterMarker}
             * @param clusterMarker The cluster marker that is a part of the cluster marker configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clusterMarker(software.amazon.awscdk.IResolvable clusterMarker) {
                this.clusterMarker = clusterMarker;
                return this;
            }

            /**
             * Sets the value of {@link ClusterMarkerConfigurationProperty#getClusterMarker}
             * @param clusterMarker The cluster marker that is a part of the cluster marker configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clusterMarker(software.amazon.awscdk.services.quicksight.CfnAnalysis.ClusterMarkerProperty clusterMarker) {
                this.clusterMarker = clusterMarker;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ClusterMarkerConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ClusterMarkerConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ClusterMarkerConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClusterMarkerConfigurationProperty {
            private final java.lang.Object clusterMarker;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.clusterMarker = software.amazon.jsii.Kernel.get(this, "clusterMarker", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.clusterMarker = builder.clusterMarker;
            }

            @Override
            public final java.lang.Object getClusterMarker() {
                return this.clusterMarker;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getClusterMarker() != null) {
                    data.set("clusterMarker", om.valueToTree(this.getClusterMarker()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.ClusterMarkerConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ClusterMarkerConfigurationProperty.Jsii$Proxy that = (ClusterMarkerConfigurationProperty.Jsii$Proxy) o;

                return this.clusterMarker != null ? this.clusterMarker.equals(that.clusterMarker) : that.clusterMarker == null;
            }

            @Override
            public final int hashCode() {
                int result = this.clusterMarker != null ? this.clusterMarker.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The cluster marker that is a part of the cluster marker configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * ClusterMarkerProperty clusterMarkerProperty = ClusterMarkerProperty.builder()
     *         .simpleClusterMarker(SimpleClusterMarkerProperty.builder()
     *                 .color("color")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-clustermarker.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-clustermarker.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.ClusterMarkerProperty")
    @software.amazon.jsii.Jsii.Proxy(ClusterMarkerProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ClusterMarkerProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The simple cluster marker of the cluster marker.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-clustermarker.html#cfn-quicksight-analysis-clustermarker-simpleclustermarker">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-clustermarker.html#cfn-quicksight-analysis-clustermarker-simpleclustermarker</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSimpleClusterMarker() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ClusterMarkerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ClusterMarkerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ClusterMarkerProperty> {
            java.lang.Object simpleClusterMarker;

            /**
             * Sets the value of {@link ClusterMarkerProperty#getSimpleClusterMarker}
             * @param simpleClusterMarker The simple cluster marker of the cluster marker.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder simpleClusterMarker(software.amazon.awscdk.IResolvable simpleClusterMarker) {
                this.simpleClusterMarker = simpleClusterMarker;
                return this;
            }

            /**
             * Sets the value of {@link ClusterMarkerProperty#getSimpleClusterMarker}
             * @param simpleClusterMarker The simple cluster marker of the cluster marker.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder simpleClusterMarker(software.amazon.awscdk.services.quicksight.CfnAnalysis.SimpleClusterMarkerProperty simpleClusterMarker) {
                this.simpleClusterMarker = simpleClusterMarker;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ClusterMarkerProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ClusterMarkerProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ClusterMarkerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClusterMarkerProperty {
            private final java.lang.Object simpleClusterMarker;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.simpleClusterMarker = software.amazon.jsii.Kernel.get(this, "simpleClusterMarker", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.simpleClusterMarker = builder.simpleClusterMarker;
            }

            @Override
            public final java.lang.Object getSimpleClusterMarker() {
                return this.simpleClusterMarker;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSimpleClusterMarker() != null) {
                    data.set("simpleClusterMarker", om.valueToTree(this.getSimpleClusterMarker()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.ClusterMarkerProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ClusterMarkerProperty.Jsii$Proxy that = (ClusterMarkerProperty.Jsii$Proxy) o;

                return this.simpleClusterMarker != null ? this.simpleClusterMarker.equals(that.simpleClusterMarker) : that.simpleClusterMarker == null;
            }

            @Override
            public final int hashCode() {
                int result = this.simpleClusterMarker != null ? this.simpleClusterMarker.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Determines the color scale that is applied to the visual.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * ColorScaleProperty colorScaleProperty = ColorScaleProperty.builder()
     *         .colorFillType("colorFillType")
     *         .colors(List.of(DataColorProperty.builder()
     *                 .color("color")
     *                 .dataValue(123)
     *                 .build()))
     *         // the properties below are optional
     *         .nullValueColor(DataColorProperty.builder()
     *                 .color("color")
     *                 .dataValue(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-colorscale.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-colorscale.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.ColorScaleProperty")
    @software.amazon.jsii.Jsii.Proxy(ColorScaleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ColorScaleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Determines the color fill type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-colorscale.html#cfn-quicksight-analysis-colorscale-colorfilltype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-colorscale.html#cfn-quicksight-analysis-colorscale-colorfilltype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getColorFillType();

        /**
         * Determines the list of colors that are applied to the visual.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-colorscale.html#cfn-quicksight-analysis-colorscale-colors">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-colorscale.html#cfn-quicksight-analysis-colorscale-colors</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getColors();

        /**
         * Determines the color that is applied to null values.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-colorscale.html#cfn-quicksight-analysis-colorscale-nullvaluecolor">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-colorscale.html#cfn-quicksight-analysis-colorscale-nullvaluecolor</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNullValueColor() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ColorScaleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ColorScaleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ColorScaleProperty> {
            java.lang.String colorFillType;
            java.lang.Object colors;
            java.lang.Object nullValueColor;

            /**
             * Sets the value of {@link ColorScaleProperty#getColorFillType}
             * @param colorFillType Determines the color fill type. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder colorFillType(java.lang.String colorFillType) {
                this.colorFillType = colorFillType;
                return this;
            }

            /**
             * Sets the value of {@link ColorScaleProperty#getColors}
             * @param colors Determines the list of colors that are applied to the visual. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder colors(software.amazon.awscdk.IResolvable colors) {
                this.colors = colors;
                return this;
            }

            /**
             * Sets the value of {@link ColorScaleProperty#getColors}
             * @param colors Determines the list of colors that are applied to the visual. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder colors(java.util.List<? extends java.lang.Object> colors) {
                this.colors = colors;
                return this;
            }

            /**
             * Sets the value of {@link ColorScaleProperty#getNullValueColor}
             * @param nullValueColor Determines the color that is applied to null values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nullValueColor(software.amazon.awscdk.IResolvable nullValueColor) {
                this.nullValueColor = nullValueColor;
                return this;
            }

            /**
             * Sets the value of {@link ColorScaleProperty#getNullValueColor}
             * @param nullValueColor Determines the color that is applied to null values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nullValueColor(software.amazon.awscdk.services.quicksight.CfnAnalysis.DataColorProperty nullValueColor) {
                this.nullValueColor = nullValueColor;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ColorScaleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ColorScaleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ColorScaleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ColorScaleProperty {
            private final java.lang.String colorFillType;
            private final java.lang.Object colors;
            private final java.lang.Object nullValueColor;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.colorFillType = software.amazon.jsii.Kernel.get(this, "colorFillType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.colors = software.amazon.jsii.Kernel.get(this, "colors", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.nullValueColor = software.amazon.jsii.Kernel.get(this, "nullValueColor", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.colorFillType = java.util.Objects.requireNonNull(builder.colorFillType, "colorFillType is required");
                this.colors = java.util.Objects.requireNonNull(builder.colors, "colors is required");
                this.nullValueColor = builder.nullValueColor;
            }

            @Override
            public final java.lang.String getColorFillType() {
                return this.colorFillType;
            }

            @Override
            public final java.lang.Object getColors() {
                return this.colors;
            }

            @Override
            public final java.lang.Object getNullValueColor() {
                return this.nullValueColor;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("colorFillType", om.valueToTree(this.getColorFillType()));
                data.set("colors", om.valueToTree(this.getColors()));
                if (this.getNullValueColor() != null) {
                    data.set("nullValueColor", om.valueToTree(this.getNullValueColor()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.ColorScaleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ColorScaleProperty.Jsii$Proxy that = (ColorScaleProperty.Jsii$Proxy) o;

                if (!colorFillType.equals(that.colorFillType)) return false;
                if (!colors.equals(that.colors)) return false;
                return this.nullValueColor != null ? this.nullValueColor.equals(that.nullValueColor) : that.nullValueColor == null;
            }

            @Override
            public final int hashCode() {
                int result = this.colorFillType.hashCode();
                result = 31 * result + (this.colors.hashCode());
                result = 31 * result + (this.nullValueColor != null ? this.nullValueColor.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The color configurations for a column.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * ColorsConfigurationProperty colorsConfigurationProperty = ColorsConfigurationProperty.builder()
     *         .customColors(List.of(CustomColorProperty.builder()
     *                 .color("color")
     *                 // the properties below are optional
     *                 .fieldValue("fieldValue")
     *                 .specialValue("specialValue")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-colorsconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-colorsconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.ColorsConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ColorsConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ColorsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of up to 50 custom colors.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-colorsconfiguration.html#cfn-quicksight-analysis-colorsconfiguration-customcolors">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-colorsconfiguration.html#cfn-quicksight-analysis-colorsconfiguration-customcolors</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomColors() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ColorsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ColorsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ColorsConfigurationProperty> {
            java.lang.Object customColors;

            /**
             * Sets the value of {@link ColorsConfigurationProperty#getCustomColors}
             * @param customColors A list of up to 50 custom colors.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customColors(software.amazon.awscdk.IResolvable customColors) {
                this.customColors = customColors;
                return this;
            }

            /**
             * Sets the value of {@link ColorsConfigurationProperty#getCustomColors}
             * @param customColors A list of up to 50 custom colors.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customColors(java.util.List<? extends java.lang.Object> customColors) {
                this.customColors = customColors;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ColorsConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ColorsConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ColorsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ColorsConfigurationProperty {
            private final java.lang.Object customColors;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.customColors = software.amazon.jsii.Kernel.get(this, "customColors", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.customColors = builder.customColors;
            }

            @Override
            public final java.lang.Object getCustomColors() {
                return this.customColors;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCustomColors() != null) {
                    data.set("customColors", om.valueToTree(this.getCustomColors()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.ColorsConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ColorsConfigurationProperty.Jsii$Proxy that = (ColorsConfigurationProperty.Jsii$Proxy) o;

                return this.customColors != null ? this.customColors.equals(that.customColors) : that.customColors == null;
            }

            @Override
            public final int hashCode() {
                int result = this.customColors != null ? this.customColors.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The general configuration of a column.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * ColumnConfigurationProperty columnConfigurationProperty = ColumnConfigurationProperty.builder()
     *         .column(ColumnIdentifierProperty.builder()
     *                 .columnName("columnName")
     *                 .dataSetIdentifier("dataSetIdentifier")
     *                 .build())
     *         // the properties below are optional
     *         .colorsConfiguration(ColorsConfigurationProperty.builder()
     *                 .customColors(List.of(CustomColorProperty.builder()
     *                         .color("color")
     *                         // the properties below are optional
     *                         .fieldValue("fieldValue")
     *                         .specialValue("specialValue")
     *                         .build()))
     *                 .build())
     *         .formatConfiguration(FormatConfigurationProperty.builder()
     *                 .dateTimeFormatConfiguration(DateTimeFormatConfigurationProperty.builder()
     *                         .dateTimeFormat("dateTimeFormat")
     *                         .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
     *                                 .nullString("nullString")
     *                                 .build())
     *                         .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
     *                                 .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
     *                                         .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
     *                                                 .decimalPlaces(123)
     *                                                 .build())
     *                                         .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
     *                                                 .displayMode("displayMode")
     *                                                 .build())
     *                                         .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
     *                                                 .nullString("nullString")
     *                                                 .build())
     *                                         .numberScale("numberScale")
     *                                         .prefix("prefix")
     *                                         .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
     *                                                 .decimalSeparator("decimalSeparator")
     *                                                 .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
     *                                                         .symbol("symbol")
     *                                                         .visibility("visibility")
     *                                                         .build())
     *                                                 .build())
     *                                         .suffix("suffix")
     *                                         .symbol("symbol")
     *                                         .build())
     *                                 .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
     *                                         .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
     *                                                 .decimalPlaces(123)
     *                                                 .build())
     *                                         .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
     *                                                 .displayMode("displayMode")
     *                                                 .build())
     *                                         .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
     *                                                 .nullString("nullString")
     *                                                 .build())
     *                                         .numberScale("numberScale")
     *                                         .prefix("prefix")
     *                                         .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
     *                                                 .decimalSeparator("decimalSeparator")
     *                                                 .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
     *                                                         .symbol("symbol")
     *                                                         .visibility("visibility")
     *                                                         .build())
     *                                                 .build())
     *                                         .suffix("suffix")
     *                                         .build())
     *                                 .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
     *                                         .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
     *                                                 .decimalPlaces(123)
     *                                                 .build())
     *                                         .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
     *                                                 .displayMode("displayMode")
     *                                                 .build())
     *                                         .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
     *                                                 .nullString("nullString")
     *                                                 .build())
     *                                         .prefix("prefix")
     *                                         .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
     *                                                 .decimalSeparator("decimalSeparator")
     *                                                 .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
     *                                                         .symbol("symbol")
     *                                                         .visibility("visibility")
     *                                                         .build())
     *                                                 .build())
     *                                         .suffix("suffix")
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 .numberFormatConfiguration(NumberFormatConfigurationProperty.builder()
     *                         .formatConfiguration(NumericFormatConfigurationProperty.builder()
     *                                 .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
     *                                         .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
     *                                                 .decimalPlaces(123)
     *                                                 .build())
     *                                         .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
     *                                                 .displayMode("displayMode")
     *                                                 .build())
     *                                         .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
     *                                                 .nullString("nullString")
     *                                                 .build())
     *                                         .numberScale("numberScale")
     *                                         .prefix("prefix")
     *                                         .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
     *                                                 .decimalSeparator("decimalSeparator")
     *                                                 .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
     *                                                         .symbol("symbol")
     *                                                         .visibility("visibility")
     *                                                         .build())
     *                                                 .build())
     *                                         .suffix("suffix")
     *                                         .symbol("symbol")
     *                                         .build())
     *                                 .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
     *                                         .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
     *                                                 .decimalPlaces(123)
     *                                                 .build())
     *                                         .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
     *                                                 .displayMode("displayMode")
     *                                                 .build())
     *                                         .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
     *                                                 .nullString("nullString")
     *                                                 .build())
     *                                         .numberScale("numberScale")
     *                                         .prefix("prefix")
     *                                         .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
     *                                                 .decimalSeparator("decimalSeparator")
     *                                                 .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
     *                                                         .symbol("symbol")
     *                                                         .visibility("visibility")
     *                                                         .build())
     *                                                 .build())
     *                                         .suffix("suffix")
     *                                         .build())
     *                                 .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
     *                                         .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
     *                                                 .decimalPlaces(123)
     *                                                 .build())
     *                                         .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
     *                                                 .displayMode("displayMode")
     *                                                 .build())
     *                                         .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
     *                                                 .nullString("nullString")
     *                                                 .build())
     *                                         .prefix("prefix")
     *                                         .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
     *                                                 .decimalSeparator("decimalSeparator")
     *                                                 .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
     *                                                         .symbol("symbol")
     *                                                         .visibility("visibility")
     *                                                         .build())
     *                                                 .build())
     *                                         .suffix("suffix")
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 .stringFormatConfiguration(StringFormatConfigurationProperty.builder()
     *                         .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
     *                                 .nullString("nullString")
     *                                 .build())
     *                         .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
     *                                 .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
     *                                         .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
     *                                                 .decimalPlaces(123)
     *                                                 .build())
     *                                         .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
     *                                                 .displayMode("displayMode")
     *                                                 .build())
     *                                         .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
     *                                                 .nullString("nullString")
     *                                                 .build())
     *                                         .numberScale("numberScale")
     *                                         .prefix("prefix")
     *                                         .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
     *                                                 .decimalSeparator("decimalSeparator")
     *                                                 .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
     *                                                         .symbol("symbol")
     *                                                         .visibility("visibility")
     *                                                         .build())
     *                                                 .build())
     *                                         .suffix("suffix")
     *                                         .symbol("symbol")
     *                                         .build())
     *                                 .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
     *                                         .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
     *                                                 .decimalPlaces(123)
     *                                                 .build())
     *                                         .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
     *                                                 .displayMode("displayMode")
     *                                                 .build())
     *                                         .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
     *                                                 .nullString("nullString")
     *                                                 .build())
     *                                         .numberScale("numberScale")
     *                                         .prefix("prefix")
     *                                         .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
     *                                                 .decimalSeparator("decimalSeparator")
     *                                                 .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
     *                                                         .symbol("symbol")
     *                                                         .visibility("visibility")
     *                                                         .build())
     *                                                 .build())
     *                                         .suffix("suffix")
     *                                         .build())
     *                                 .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
     *                                         .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
     *                                                 .decimalPlaces(123)
     *                                                 .build())
     *                                         .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
     *                                                 .displayMode("displayMode")
     *                                                 .build())
     *                                         .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
     *                                                 .nullString("nullString")
     *                                                 .build())
     *                                         .prefix("prefix")
     *                                         .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
     *                                                 .decimalSeparator("decimalSeparator")
     *                                                 .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
     *                                                         .symbol("symbol")
     *                                                         .visibility("visibility")
     *                                                         .build())
     *                                                 .build())
     *                                         .suffix("suffix")
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .role("role")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.ColumnConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ColumnConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ColumnConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The column.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnconfiguration.html#cfn-quicksight-analysis-columnconfiguration-column">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnconfiguration.html#cfn-quicksight-analysis-columnconfiguration-column</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getColumn();

        /**
         * The color configurations of the column.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnconfiguration.html#cfn-quicksight-analysis-columnconfiguration-colorsconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnconfiguration.html#cfn-quicksight-analysis-columnconfiguration-colorsconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getColorsConfiguration() {
            return null;
        }

        /**
         * The format configuration of a column.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnconfiguration.html#cfn-quicksight-analysis-columnconfiguration-formatconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnconfiguration.html#cfn-quicksight-analysis-columnconfiguration-formatconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFormatConfiguration() {
            return null;
        }

        /**
         * The role of the column.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnconfiguration.html#cfn-quicksight-analysis-columnconfiguration-role">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnconfiguration.html#cfn-quicksight-analysis-columnconfiguration-role</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRole() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ColumnConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ColumnConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ColumnConfigurationProperty> {
            java.lang.Object column;
            java.lang.Object colorsConfiguration;
            java.lang.Object formatConfiguration;
            java.lang.String role;

            /**
             * Sets the value of {@link ColumnConfigurationProperty#getColumn}
             * @param column The column. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder column(software.amazon.awscdk.IResolvable column) {
                this.column = column;
                return this;
            }

            /**
             * Sets the value of {@link ColumnConfigurationProperty#getColumn}
             * @param column The column. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder column(software.amazon.awscdk.services.quicksight.CfnAnalysis.ColumnIdentifierProperty column) {
                this.column = column;
                return this;
            }

            /**
             * Sets the value of {@link ColumnConfigurationProperty#getColorsConfiguration}
             * @param colorsConfiguration The color configurations of the column.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder colorsConfiguration(software.amazon.awscdk.IResolvable colorsConfiguration) {
                this.colorsConfiguration = colorsConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ColumnConfigurationProperty#getColorsConfiguration}
             * @param colorsConfiguration The color configurations of the column.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder colorsConfiguration(software.amazon.awscdk.services.quicksight.CfnAnalysis.ColorsConfigurationProperty colorsConfiguration) {
                this.colorsConfiguration = colorsConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ColumnConfigurationProperty#getFormatConfiguration}
             * @param formatConfiguration The format configuration of a column.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder formatConfiguration(software.amazon.awscdk.IResolvable formatConfiguration) {
                this.formatConfiguration = formatConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ColumnConfigurationProperty#getFormatConfiguration}
             * @param formatConfiguration The format configuration of a column.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder formatConfiguration(software.amazon.awscdk.services.quicksight.CfnAnalysis.FormatConfigurationProperty formatConfiguration) {
                this.formatConfiguration = formatConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ColumnConfigurationProperty#getRole}
             * @param role The role of the column.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder role(java.lang.String role) {
                this.role = role;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ColumnConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ColumnConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ColumnConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ColumnConfigurationProperty {
            private final java.lang.Object column;
            private final java.lang.Object colorsConfiguration;
            private final java.lang.Object formatConfiguration;
            private final java.lang.String role;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.column = software.amazon.jsii.Kernel.get(this, "column", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.colorsConfiguration = software.amazon.jsii.Kernel.get(this, "colorsConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.formatConfiguration = software.amazon.jsii.Kernel.get(this, "formatConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.column = java.util.Objects.requireNonNull(builder.column, "column is required");
                this.colorsConfiguration = builder.colorsConfiguration;
                this.formatConfiguration = builder.formatConfiguration;
                this.role = builder.role;
            }

            @Override
            public final java.lang.Object getColumn() {
                return this.column;
            }

            @Override
            public final java.lang.Object getColorsConfiguration() {
                return this.colorsConfiguration;
            }

            @Override
            public final java.lang.Object getFormatConfiguration() {
                return this.formatConfiguration;
            }

            @Override
            public final java.lang.String getRole() {
                return this.role;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("column", om.valueToTree(this.getColumn()));
                if (this.getColorsConfiguration() != null) {
                    data.set("colorsConfiguration", om.valueToTree(this.getColorsConfiguration()));
                }
                if (this.getFormatConfiguration() != null) {
                    data.set("formatConfiguration", om.valueToTree(this.getFormatConfiguration()));
                }
                if (this.getRole() != null) {
                    data.set("role", om.valueToTree(this.getRole()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.ColumnConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ColumnConfigurationProperty.Jsii$Proxy that = (ColumnConfigurationProperty.Jsii$Proxy) o;

                if (!column.equals(that.column)) return false;
                if (this.colorsConfiguration != null ? !this.colorsConfiguration.equals(that.colorsConfiguration) : that.colorsConfiguration != null) return false;
                if (this.formatConfiguration != null ? !this.formatConfiguration.equals(that.formatConfiguration) : that.formatConfiguration != null) return false;
                return this.role != null ? this.role.equals(that.role) : that.role == null;
            }

            @Override
            public final int hashCode() {
                int result = this.column.hashCode();
                result = 31 * result + (this.colorsConfiguration != null ? this.colorsConfiguration.hashCode() : 0);
                result = 31 * result + (this.formatConfiguration != null ? this.formatConfiguration.hashCode() : 0);
                result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The option that determines the hierarchy of the fields for a visual element.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * ColumnHierarchyProperty columnHierarchyProperty = ColumnHierarchyProperty.builder()
     *         .dateTimeHierarchy(DateTimeHierarchyProperty.builder()
     *                 .hierarchyId("hierarchyId")
     *                 // the properties below are optional
     *                 .drillDownFilters(List.of(DrillDownFilterProperty.builder()
     *                         .categoryFilter(CategoryDrillDownFilterProperty.builder()
     *                                 .categoryValues(List.of("categoryValues"))
     *                                 .column(ColumnIdentifierProperty.builder()
     *                                         .columnName("columnName")
     *                                         .dataSetIdentifier("dataSetIdentifier")
     *                                         .build())
     *                                 .build())
     *                         .numericEqualityFilter(NumericEqualityDrillDownFilterProperty.builder()
     *                                 .column(ColumnIdentifierProperty.builder()
     *                                         .columnName("columnName")
     *                                         .dataSetIdentifier("dataSetIdentifier")
     *                                         .build())
     *                                 .value(123)
     *                                 .build())
     *                         .timeRangeFilter(TimeRangeDrillDownFilterProperty.builder()
     *                                 .column(ColumnIdentifierProperty.builder()
     *                                         .columnName("columnName")
     *                                         .dataSetIdentifier("dataSetIdentifier")
     *                                         .build())
     *                                 .rangeMaximum("rangeMaximum")
     *                                 .rangeMinimum("rangeMinimum")
     *                                 .timeGranularity("timeGranularity")
     *                                 .build())
     *                         .build()))
     *                 .build())
     *         .explicitHierarchy(ExplicitHierarchyProperty.builder()
     *                 .columns(List.of(ColumnIdentifierProperty.builder()
     *                         .columnName("columnName")
     *                         .dataSetIdentifier("dataSetIdentifier")
     *                         .build()))
     *                 .hierarchyId("hierarchyId")
     *                 // the properties below are optional
     *                 .drillDownFilters(List.of(DrillDownFilterProperty.builder()
     *                         .categoryFilter(CategoryDrillDownFilterProperty.builder()
     *                                 .categoryValues(List.of("categoryValues"))
     *                                 .column(ColumnIdentifierProperty.builder()
     *                                         .columnName("columnName")
     *                                         .dataSetIdentifier("dataSetIdentifier")
     *                                         .build())
     *                                 .build())
     *                         .numericEqualityFilter(NumericEqualityDrillDownFilterProperty.builder()
     *                                 .column(ColumnIdentifierProperty.builder()
     *                                         .columnName("columnName")
     *                                         .dataSetIdentifier("dataSetIdentifier")
     *                                         .build())
     *                                 .value(123)
     *                                 .build())
     *                         .timeRangeFilter(TimeRangeDrillDownFilterProperty.builder()
     *                                 .column(ColumnIdentifierProperty.builder()
     *                                         .columnName("columnName")
     *                                         .dataSetIdentifier("dataSetIdentifier")
     *                                         .build())
     *                                 .rangeMaximum("rangeMaximum")
     *                                 .rangeMinimum("rangeMinimum")
     *                                 .timeGranularity("timeGranularity")
     *                                 .build())
     *                         .build()))
     *                 .build())
     *         .predefinedHierarchy(PredefinedHierarchyProperty.builder()
     *                 .columns(List.of(ColumnIdentifierProperty.builder()
     *                         .columnName("columnName")
     *                         .dataSetIdentifier("dataSetIdentifier")
     *                         .build()))
     *                 .hierarchyId("hierarchyId")
     *                 // the properties below are optional
     *                 .drillDownFilters(List.of(DrillDownFilterProperty.builder()
     *                         .categoryFilter(CategoryDrillDownFilterProperty.builder()
     *                                 .categoryValues(List.of("categoryValues"))
     *                                 .column(ColumnIdentifierProperty.builder()
     *                                         .columnName("columnName")
     *                                         .dataSetIdentifier("dataSetIdentifier")
     *                                         .build())
     *                                 .build())
     *                         .numericEqualityFilter(NumericEqualityDrillDownFilterProperty.builder()
     *                                 .column(ColumnIdentifierProperty.builder()
     *                                         .columnName("columnName")
     *                                         .dataSetIdentifier("dataSetIdentifier")
     *                                         .build())
     *                                 .value(123)
     *                                 .build())
     *                         .timeRangeFilter(TimeRangeDrillDownFilterProperty.builder()
     *                                 .column(ColumnIdentifierProperty.builder()
     *                                         .columnName("columnName")
     *                                         .dataSetIdentifier("dataSetIdentifier")
     *                                         .build())
     *                                 .rangeMaximum("rangeMaximum")
     *                                 .rangeMinimum("rangeMinimum")
     *                                 .timeGranularity("timeGranularity")
     *                                 .build())
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnhierarchy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnhierarchy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.ColumnHierarchyProperty")
    @software.amazon.jsii.Jsii.Proxy(ColumnHierarchyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ColumnHierarchyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The option that determines the hierarchy of any <code>DateTime</code> fields.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnhierarchy.html#cfn-quicksight-analysis-columnhierarchy-datetimehierarchy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnhierarchy.html#cfn-quicksight-analysis-columnhierarchy-datetimehierarchy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDateTimeHierarchy() {
            return null;
        }

        /**
         * The option that determines the hierarchy of the fields that are built within a visual's field wells.
         * <p>
         * These fields can't be duplicated to other visuals.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnhierarchy.html#cfn-quicksight-analysis-columnhierarchy-explicithierarchy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnhierarchy.html#cfn-quicksight-analysis-columnhierarchy-explicithierarchy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExplicitHierarchy() {
            return null;
        }

        /**
         * The option that determines the hierarchy of the fields that are defined during data preparation.
         * <p>
         * These fields are available to use in any analysis that uses the data source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnhierarchy.html#cfn-quicksight-analysis-columnhierarchy-predefinedhierarchy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnhierarchy.html#cfn-quicksight-analysis-columnhierarchy-predefinedhierarchy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPredefinedHierarchy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ColumnHierarchyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ColumnHierarchyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ColumnHierarchyProperty> {
            java.lang.Object dateTimeHierarchy;
            java.lang.Object explicitHierarchy;
            java.lang.Object predefinedHierarchy;

            /**
             * Sets the value of {@link ColumnHierarchyProperty#getDateTimeHierarchy}
             * @param dateTimeHierarchy The option that determines the hierarchy of any <code>DateTime</code> fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dateTimeHierarchy(software.amazon.awscdk.IResolvable dateTimeHierarchy) {
                this.dateTimeHierarchy = dateTimeHierarchy;
                return this;
            }

            /**
             * Sets the value of {@link ColumnHierarchyProperty#getDateTimeHierarchy}
             * @param dateTimeHierarchy The option that determines the hierarchy of any <code>DateTime</code> fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dateTimeHierarchy(software.amazon.awscdk.services.quicksight.CfnAnalysis.DateTimeHierarchyProperty dateTimeHierarchy) {
                this.dateTimeHierarchy = dateTimeHierarchy;
                return this;
            }

            /**
             * Sets the value of {@link ColumnHierarchyProperty#getExplicitHierarchy}
             * @param explicitHierarchy The option that determines the hierarchy of the fields that are built within a visual's field wells.
             *                          These fields can't be duplicated to other visuals.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder explicitHierarchy(software.amazon.awscdk.IResolvable explicitHierarchy) {
                this.explicitHierarchy = explicitHierarchy;
                return this;
            }

            /**
             * Sets the value of {@link ColumnHierarchyProperty#getExplicitHierarchy}
             * @param explicitHierarchy The option that determines the hierarchy of the fields that are built within a visual's field wells.
             *                          These fields can't be duplicated to other visuals.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder explicitHierarchy(software.amazon.awscdk.services.quicksight.CfnAnalysis.ExplicitHierarchyProperty explicitHierarchy) {
                this.explicitHierarchy = explicitHierarchy;
                return this;
            }

            /**
             * Sets the value of {@link ColumnHierarchyProperty#getPredefinedHierarchy}
             * @param predefinedHierarchy The option that determines the hierarchy of the fields that are defined during data preparation.
             *                            These fields are available to use in any analysis that uses the data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder predefinedHierarchy(software.amazon.awscdk.IResolvable predefinedHierarchy) {
                this.predefinedHierarchy = predefinedHierarchy;
                return this;
            }

            /**
             * Sets the value of {@link ColumnHierarchyProperty#getPredefinedHierarchy}
             * @param predefinedHierarchy The option that determines the hierarchy of the fields that are defined during data preparation.
             *                            These fields are available to use in any analysis that uses the data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder predefinedHierarchy(software.amazon.awscdk.services.quicksight.CfnAnalysis.PredefinedHierarchyProperty predefinedHierarchy) {
                this.predefinedHierarchy = predefinedHierarchy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ColumnHierarchyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ColumnHierarchyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ColumnHierarchyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ColumnHierarchyProperty {
            private final java.lang.Object dateTimeHierarchy;
            private final java.lang.Object explicitHierarchy;
            private final java.lang.Object predefinedHierarchy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dateTimeHierarchy = software.amazon.jsii.Kernel.get(this, "dateTimeHierarchy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.explicitHierarchy = software.amazon.jsii.Kernel.get(this, "explicitHierarchy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.predefinedHierarchy = software.amazon.jsii.Kernel.get(this, "predefinedHierarchy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dateTimeHierarchy = builder.dateTimeHierarchy;
                this.explicitHierarchy = builder.explicitHierarchy;
                this.predefinedHierarchy = builder.predefinedHierarchy;
            }

            @Override
            public final java.lang.Object getDateTimeHierarchy() {
                return this.dateTimeHierarchy;
            }

            @Override
            public final java.lang.Object getExplicitHierarchy() {
                return this.explicitHierarchy;
            }

            @Override
            public final java.lang.Object getPredefinedHierarchy() {
                return this.predefinedHierarchy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDateTimeHierarchy() != null) {
                    data.set("dateTimeHierarchy", om.valueToTree(this.getDateTimeHierarchy()));
                }
                if (this.getExplicitHierarchy() != null) {
                    data.set("explicitHierarchy", om.valueToTree(this.getExplicitHierarchy()));
                }
                if (this.getPredefinedHierarchy() != null) {
                    data.set("predefinedHierarchy", om.valueToTree(this.getPredefinedHierarchy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.ColumnHierarchyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ColumnHierarchyProperty.Jsii$Proxy that = (ColumnHierarchyProperty.Jsii$Proxy) o;

                if (this.dateTimeHierarchy != null ? !this.dateTimeHierarchy.equals(that.dateTimeHierarchy) : that.dateTimeHierarchy != null) return false;
                if (this.explicitHierarchy != null ? !this.explicitHierarchy.equals(that.explicitHierarchy) : that.explicitHierarchy != null) return false;
                return this.predefinedHierarchy != null ? this.predefinedHierarchy.equals(that.predefinedHierarchy) : that.predefinedHierarchy == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dateTimeHierarchy != null ? this.dateTimeHierarchy.hashCode() : 0;
                result = 31 * result + (this.explicitHierarchy != null ? this.explicitHierarchy.hashCode() : 0);
                result = 31 * result + (this.predefinedHierarchy != null ? this.predefinedHierarchy.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A column of a data set.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * ColumnIdentifierProperty columnIdentifierProperty = ColumnIdentifierProperty.builder()
     *         .columnName("columnName")
     *         .dataSetIdentifier("dataSetIdentifier")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnidentifier.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnidentifier.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.ColumnIdentifierProperty")
    @software.amazon.jsii.Jsii.Proxy(ColumnIdentifierProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ColumnIdentifierProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the column.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnidentifier.html#cfn-quicksight-analysis-columnidentifier-columnname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnidentifier.html#cfn-quicksight-analysis-columnidentifier-columnname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getColumnName();

        /**
         * The data set that the column belongs to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnidentifier.html#cfn-quicksight-analysis-columnidentifier-datasetidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnidentifier.html#cfn-quicksight-analysis-columnidentifier-datasetidentifier</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDataSetIdentifier();

        /**
         * @return a {@link Builder} of {@link ColumnIdentifierProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ColumnIdentifierProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ColumnIdentifierProperty> {
            java.lang.String columnName;
            java.lang.String dataSetIdentifier;

            /**
             * Sets the value of {@link ColumnIdentifierProperty#getColumnName}
             * @param columnName The name of the column. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnName(java.lang.String columnName) {
                this.columnName = columnName;
                return this;
            }

            /**
             * Sets the value of {@link ColumnIdentifierProperty#getDataSetIdentifier}
             * @param dataSetIdentifier The data set that the column belongs to. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataSetIdentifier(java.lang.String dataSetIdentifier) {
                this.dataSetIdentifier = dataSetIdentifier;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ColumnIdentifierProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ColumnIdentifierProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ColumnIdentifierProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ColumnIdentifierProperty {
            private final java.lang.String columnName;
            private final java.lang.String dataSetIdentifier;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.columnName = software.amazon.jsii.Kernel.get(this, "columnName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dataSetIdentifier = software.amazon.jsii.Kernel.get(this, "dataSetIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.columnName = java.util.Objects.requireNonNull(builder.columnName, "columnName is required");
                this.dataSetIdentifier = java.util.Objects.requireNonNull(builder.dataSetIdentifier, "dataSetIdentifier is required");
            }

            @Override
            public final java.lang.String getColumnName() {
                return this.columnName;
            }

            @Override
            public final java.lang.String getDataSetIdentifier() {
                return this.dataSetIdentifier;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("columnName", om.valueToTree(this.getColumnName()));
                data.set("dataSetIdentifier", om.valueToTree(this.getDataSetIdentifier()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.ColumnIdentifierProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ColumnIdentifierProperty.Jsii$Proxy that = (ColumnIdentifierProperty.Jsii$Proxy) o;

                if (!columnName.equals(that.columnName)) return false;
                return this.dataSetIdentifier.equals(that.dataSetIdentifier);
            }

            @Override
            public final int hashCode() {
                int result = this.columnName.hashCode();
                result = 31 * result + (this.dataSetIdentifier.hashCode());
                return result;
            }
        }
    }
    /**
     * The sort configuration for a column that is not used in a field well.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * ColumnSortProperty columnSortProperty = ColumnSortProperty.builder()
     *         .direction("direction")
     *         .sortBy(ColumnIdentifierProperty.builder()
     *                 .columnName("columnName")
     *                 .dataSetIdentifier("dataSetIdentifier")
     *                 .build())
     *         // the properties below are optional
     *         .aggregationFunction(AggregationFunctionProperty.builder()
     *                 .attributeAggregationFunction(AttributeAggregationFunctionProperty.builder()
     *                         .simpleAttributeAggregation("simpleAttributeAggregation")
     *                         .valueForMultipleValues("valueForMultipleValues")
     *                         .build())
     *                 .categoricalAggregationFunction("categoricalAggregationFunction")
     *                 .dateAggregationFunction("dateAggregationFunction")
     *                 .numericalAggregationFunction(NumericalAggregationFunctionProperty.builder()
     *                         .percentileAggregation(PercentileAggregationProperty.builder()
     *                                 .percentileValue(123)
     *                                 .build())
     *                         .simpleNumericalAggregation("simpleNumericalAggregation")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnsort.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnsort.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.ColumnSortProperty")
    @software.amazon.jsii.Jsii.Proxy(ColumnSortProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ColumnSortProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The sort direction.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnsort.html#cfn-quicksight-analysis-columnsort-direction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnsort.html#cfn-quicksight-analysis-columnsort-direction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDirection();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnsort.html#cfn-quicksight-analysis-columnsort-sortby">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnsort.html#cfn-quicksight-analysis-columnsort-sortby</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getSortBy();

        /**
         * The aggregation function that is defined in the column sort.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnsort.html#cfn-quicksight-analysis-columnsort-aggregationfunction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnsort.html#cfn-quicksight-analysis-columnsort-aggregationfunction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAggregationFunction() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ColumnSortProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ColumnSortProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ColumnSortProperty> {
            java.lang.String direction;
            java.lang.Object sortBy;
            java.lang.Object aggregationFunction;

            /**
             * Sets the value of {@link ColumnSortProperty#getDirection}
             * @param direction The sort direction. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder direction(java.lang.String direction) {
                this.direction = direction;
                return this;
            }

            /**
             * Sets the value of {@link ColumnSortProperty#getSortBy}
             * @param sortBy the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sortBy(software.amazon.awscdk.IResolvable sortBy) {
                this.sortBy = sortBy;
                return this;
            }

            /**
             * Sets the value of {@link ColumnSortProperty#getSortBy}
             * @param sortBy the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sortBy(software.amazon.awscdk.services.quicksight.CfnAnalysis.ColumnIdentifierProperty sortBy) {
                this.sortBy = sortBy;
                return this;
            }

            /**
             * Sets the value of {@link ColumnSortProperty#getAggregationFunction}
             * @param aggregationFunction The aggregation function that is defined in the column sort.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aggregationFunction(software.amazon.awscdk.IResolvable aggregationFunction) {
                this.aggregationFunction = aggregationFunction;
                return this;
            }

            /**
             * Sets the value of {@link ColumnSortProperty#getAggregationFunction}
             * @param aggregationFunction The aggregation function that is defined in the column sort.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aggregationFunction(software.amazon.awscdk.services.quicksight.CfnAnalysis.AggregationFunctionProperty aggregationFunction) {
                this.aggregationFunction = aggregationFunction;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ColumnSortProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ColumnSortProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ColumnSortProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ColumnSortProperty {
            private final java.lang.String direction;
            private final java.lang.Object sortBy;
            private final java.lang.Object aggregationFunction;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.direction = software.amazon.jsii.Kernel.get(this, "direction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sortBy = software.amazon.jsii.Kernel.get(this, "sortBy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.aggregationFunction = software.amazon.jsii.Kernel.get(this, "aggregationFunction", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.direction = java.util.Objects.requireNonNull(builder.direction, "direction is required");
                this.sortBy = java.util.Objects.requireNonNull(builder.sortBy, "sortBy is required");
                this.aggregationFunction = builder.aggregationFunction;
            }

            @Override
            public final java.lang.String getDirection() {
                return this.direction;
            }

            @Override
            public final java.lang.Object getSortBy() {
                return this.sortBy;
            }

            @Override
            public final java.lang.Object getAggregationFunction() {
                return this.aggregationFunction;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("direction", om.valueToTree(this.getDirection()));
                data.set("sortBy", om.valueToTree(this.getSortBy()));
                if (this.getAggregationFunction() != null) {
                    data.set("aggregationFunction", om.valueToTree(this.getAggregationFunction()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.ColumnSortProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ColumnSortProperty.Jsii$Proxy that = (ColumnSortProperty.Jsii$Proxy) o;

                if (!direction.equals(that.direction)) return false;
                if (!sortBy.equals(that.sortBy)) return false;
                return this.aggregationFunction != null ? this.aggregationFunction.equals(that.aggregationFunction) : that.aggregationFunction == null;
            }

            @Override
            public final int hashCode() {
                int result = this.direction.hashCode();
                result = 31 * result + (this.sortBy.hashCode());
                result = 31 * result + (this.aggregationFunction != null ? this.aggregationFunction.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The tooltip item for the columns that are not part of a field well.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * ColumnTooltipItemProperty columnTooltipItemProperty = ColumnTooltipItemProperty.builder()
     *         .column(ColumnIdentifierProperty.builder()
     *                 .columnName("columnName")
     *                 .dataSetIdentifier("dataSetIdentifier")
     *                 .build())
     *         // the properties below are optional
     *         .aggregation(AggregationFunctionProperty.builder()
     *                 .attributeAggregationFunction(AttributeAggregationFunctionProperty.builder()
     *                         .simpleAttributeAggregation("simpleAttributeAggregation")
     *                         .valueForMultipleValues("valueForMultipleValues")
     *                         .build())
     *                 .categoricalAggregationFunction("categoricalAggregationFunction")
     *                 .dateAggregationFunction("dateAggregationFunction")
     *                 .numericalAggregationFunction(NumericalAggregationFunctionProperty.builder()
     *                         .percentileAggregation(PercentileAggregationProperty.builder()
     *                                 .percentileValue(123)
     *                                 .build())
     *                         .simpleNumericalAggregation("simpleNumericalAggregation")
     *                         .build())
     *                 .build())
     *         .label("label")
     *         .visibility("visibility")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columntooltipitem.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columntooltipitem.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.ColumnTooltipItemProperty")
    @software.amazon.jsii.Jsii.Proxy(ColumnTooltipItemProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ColumnTooltipItemProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The target column of the tooltip item.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columntooltipitem.html#cfn-quicksight-analysis-columntooltipitem-column">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columntooltipitem.html#cfn-quicksight-analysis-columntooltipitem-column</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getColumn();

        /**
         * The aggregation function of the column tooltip item.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columntooltipitem.html#cfn-quicksight-analysis-columntooltipitem-aggregation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columntooltipitem.html#cfn-quicksight-analysis-columntooltipitem-aggregation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAggregation() {
            return null;
        }

        /**
         * The label of the tooltip item.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columntooltipitem.html#cfn-quicksight-analysis-columntooltipitem-label">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columntooltipitem.html#cfn-quicksight-analysis-columntooltipitem-label</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLabel() {
            return null;
        }

        /**
         * The visibility of the tooltip item.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columntooltipitem.html#cfn-quicksight-analysis-columntooltipitem-visibility">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columntooltipitem.html#cfn-quicksight-analysis-columntooltipitem-visibility</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVisibility() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ColumnTooltipItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ColumnTooltipItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ColumnTooltipItemProperty> {
            java.lang.Object column;
            java.lang.Object aggregation;
            java.lang.String label;
            java.lang.String visibility;

            /**
             * Sets the value of {@link ColumnTooltipItemProperty#getColumn}
             * @param column The target column of the tooltip item. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder column(software.amazon.awscdk.IResolvable column) {
                this.column = column;
                return this;
            }

            /**
             * Sets the value of {@link ColumnTooltipItemProperty#getColumn}
             * @param column The target column of the tooltip item. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder column(software.amazon.awscdk.services.quicksight.CfnAnalysis.ColumnIdentifierProperty column) {
                this.column = column;
                return this;
            }

            /**
             * Sets the value of {@link ColumnTooltipItemProperty#getAggregation}
             * @param aggregation The aggregation function of the column tooltip item.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aggregation(software.amazon.awscdk.IResolvable aggregation) {
                this.aggregation = aggregation;
                return this;
            }

            /**
             * Sets the value of {@link ColumnTooltipItemProperty#getAggregation}
             * @param aggregation The aggregation function of the column tooltip item.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aggregation(software.amazon.awscdk.services.quicksight.CfnAnalysis.AggregationFunctionProperty aggregation) {
                this.aggregation = aggregation;
                return this;
            }

            /**
             * Sets the value of {@link ColumnTooltipItemProperty#getLabel}
             * @param label The label of the tooltip item.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder label(java.lang.String label) {
                this.label = label;
                return this;
            }

            /**
             * Sets the value of {@link ColumnTooltipItemProperty#getVisibility}
             * @param visibility The visibility of the tooltip item.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder visibility(java.lang.String visibility) {
                this.visibility = visibility;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ColumnTooltipItemProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ColumnTooltipItemProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ColumnTooltipItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ColumnTooltipItemProperty {
            private final java.lang.Object column;
            private final java.lang.Object aggregation;
            private final java.lang.String label;
            private final java.lang.String visibility;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.column = software.amazon.jsii.Kernel.get(this, "column", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.aggregation = software.amazon.jsii.Kernel.get(this, "aggregation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.label = software.amazon.jsii.Kernel.get(this, "label", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.visibility = software.amazon.jsii.Kernel.get(this, "visibility", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.column = java.util.Objects.requireNonNull(builder.column, "column is required");
                this.aggregation = builder.aggregation;
                this.label = builder.label;
                this.visibility = builder.visibility;
            }

            @Override
            public final java.lang.Object getColumn() {
                return this.column;
            }

            @Override
            public final java.lang.Object getAggregation() {
                return this.aggregation;
            }

            @Override
            public final java.lang.String getLabel() {
                return this.label;
            }

            @Override
            public final java.lang.String getVisibility() {
                return this.visibility;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("column", om.valueToTree(this.getColumn()));
                if (this.getAggregation() != null) {
                    data.set("aggregation", om.valueToTree(this.getAggregation()));
                }
                if (this.getLabel() != null) {
                    data.set("label", om.valueToTree(this.getLabel()));
                }
                if (this.getVisibility() != null) {
                    data.set("visibility", om.valueToTree(this.getVisibility()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.ColumnTooltipItemProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ColumnTooltipItemProperty.Jsii$Proxy that = (ColumnTooltipItemProperty.Jsii$Proxy) o;

                if (!column.equals(that.column)) return false;
                if (this.aggregation != null ? !this.aggregation.equals(that.aggregation) : that.aggregation != null) return false;
                if (this.label != null ? !this.label.equals(that.label) : that.label != null) return false;
                return this.visibility != null ? this.visibility.equals(that.visibility) : that.visibility == null;
            }

            @Override
            public final int hashCode() {
                int result = this.column.hashCode();
                result = 31 * result + (this.aggregation != null ? this.aggregation.hashCode() : 0);
                result = 31 * result + (this.label != null ? this.label.hashCode() : 0);
                result = 31 * result + (this.visibility != null ? this.visibility.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The aggregated field wells of a combo chart.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartaggregatedfieldwells.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartaggregatedfieldwells.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.ComboChartAggregatedFieldWellsProperty")
    @software.amazon.jsii.Jsii.Proxy(ComboChartAggregatedFieldWellsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ComboChartAggregatedFieldWellsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The aggregated <code>BarValues</code> field well of a combo chart.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartaggregatedfieldwells.html#cfn-quicksight-analysis-combochartaggregatedfieldwells-barvalues">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartaggregatedfieldwells.html#cfn-quicksight-analysis-combochartaggregatedfieldwells-barvalues</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBarValues() {
            return null;
        }

        /**
         * The aggregated category field wells of a combo chart.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartaggregatedfieldwells.html#cfn-quicksight-analysis-combochartaggregatedfieldwells-category">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartaggregatedfieldwells.html#cfn-quicksight-analysis-combochartaggregatedfieldwells-category</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCategory() {
            return null;
        }

        /**
         * The aggregated colors field well of a combo chart.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartaggregatedfieldwells.html#cfn-quicksight-analysis-combochartaggregatedfieldwells-colors">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartaggregatedfieldwells.html#cfn-quicksight-analysis-combochartaggregatedfieldwells-colors</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getColors() {
            return null;
        }

        /**
         * The aggregated <code>LineValues</code> field well of a combo chart.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartaggregatedfieldwells.html#cfn-quicksight-analysis-combochartaggregatedfieldwells-linevalues">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartaggregatedfieldwells.html#cfn-quicksight-analysis-combochartaggregatedfieldwells-linevalues</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLineValues() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ComboChartAggregatedFieldWellsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ComboChartAggregatedFieldWellsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ComboChartAggregatedFieldWellsProperty> {
            java.lang.Object barValues;
            java.lang.Object category;
            java.lang.Object colors;
            java.lang.Object lineValues;

            /**
             * Sets the value of {@link ComboChartAggregatedFieldWellsProperty#getBarValues}
             * @param barValues The aggregated <code>BarValues</code> field well of a combo chart.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder barValues(software.amazon.awscdk.IResolvable barValues) {
                this.barValues = barValues;
                return this;
            }

            /**
             * Sets the value of {@link ComboChartAggregatedFieldWellsProperty#getBarValues}
             * @param barValues The aggregated <code>BarValues</code> field well of a combo chart.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder barValues(java.util.List<? extends java.lang.Object> barValues) {
                this.barValues = barValues;
                return this;
            }

            /**
             * Sets the value of {@link ComboChartAggregatedFieldWellsProperty#getCategory}
             * @param category The aggregated category field wells of a combo chart.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder category(software.amazon.awscdk.IResolvable category) {
                this.category = category;
                return this;
            }

            /**
             * Sets the value of {@link ComboChartAggregatedFieldWellsProperty#getCategory}
             * @param category The aggregated category field wells of a combo chart.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder category(java.util.List<? extends java.lang.Object> category) {
                this.category = category;
                return this;
            }

            /**
             * Sets the value of {@link ComboChartAggregatedFieldWellsProperty#getColors}
             * @param colors The aggregated colors field well of a combo chart.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder colors(software.amazon.awscdk.IResolvable colors) {
                this.colors = colors;
                return this;
            }

            /**
             * Sets the value of {@link ComboChartAggregatedFieldWellsProperty#getColors}
             * @param colors The aggregated colors field well of a combo chart.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder colors(java.util.List<? extends java.lang.Object> colors) {
                this.colors = colors;
                return this;
            }

            /**
             * Sets the value of {@link ComboChartAggregatedFieldWellsProperty#getLineValues}
             * @param lineValues The aggregated <code>LineValues</code> field well of a combo chart.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lineValues(software.amazon.awscdk.IResolvable lineValues) {
                this.lineValues = lineValues;
                return this;
            }

            /**
             * Sets the value of {@link ComboChartAggregatedFieldWellsProperty#getLineValues}
             * @param lineValues The aggregated <code>LineValues</code> field well of a combo chart.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lineValues(java.util.List<? extends java.lang.Object> lineValues) {
                this.lineValues = lineValues;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ComboChartAggregatedFieldWellsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ComboChartAggregatedFieldWellsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ComboChartAggregatedFieldWellsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ComboChartAggregatedFieldWellsProperty {
            private final java.lang.Object barValues;
            private final java.lang.Object category;
            private final java.lang.Object colors;
            private final java.lang.Object lineValues;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.barValues = software.amazon.jsii.Kernel.get(this, "barValues", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.category = software.amazon.jsii.Kernel.get(this, "category", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.colors = software.amazon.jsii.Kernel.get(this, "colors", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.lineValues = software.amazon.jsii.Kernel.get(this, "lineValues", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.barValues = builder.barValues;
                this.category = builder.category;
                this.colors = builder.colors;
                this.lineValues = builder.lineValues;
            }

            @Override
            public final java.lang.Object getBarValues() {
                return this.barValues;
            }

            @Override
            public final java.lang.Object getCategory() {
                return this.category;
            }

            @Override
            public final java.lang.Object getColors() {
                return this.colors;
            }

            @Override
            public final java.lang.Object getLineValues() {
                return this.lineValues;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBarValues() != null) {
                    data.set("barValues", om.valueToTree(this.getBarValues()));
                }
                if (this.getCategory() != null) {
                    data.set("category", om.valueToTree(this.getCategory()));
                }
                if (this.getColors() != null) {
                    data.set("colors", om.valueToTree(this.getColors()));
                }
                if (this.getLineValues() != null) {
                    data.set("lineValues", om.valueToTree(this.getLineValues()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.ComboChartAggregatedFieldWellsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ComboChartAggregatedFieldWellsProperty.Jsii$Proxy that = (ComboChartAggregatedFieldWellsProperty.Jsii$Proxy) o;

                if (this.barValues != null ? !this.barValues.equals(that.barValues) : that.barValues != null) return false;
                if (this.category != null ? !this.category.equals(that.category) : that.category != null) return false;
                if (this.colors != null ? !this.colors.equals(that.colors) : that.colors != null) return false;
                return this.lineValues != null ? this.lineValues.equals(that.lineValues) : that.lineValues == null;
            }

            @Override
            public final int hashCode() {
                int result = this.barValues != null ? this.barValues.hashCode() : 0;
                result = 31 * result + (this.category != null ? this.category.hashCode() : 0);
                result = 31 * result + (this.colors != null ? this.colors.hashCode() : 0);
                result = 31 * result + (this.lineValues != null ? this.lineValues.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration of a <code>ComboChartVisual</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.ComboChartConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ComboChartConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ComboChartConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The options that determine if visual data labels are displayed.
         * <p>
         * The data label options for a bar in a combo chart.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-bardatalabels">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-bardatalabels</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBarDataLabels() {
            return null;
        }

        /**
         * Determines the bar arrangement in a combo chart. The following are valid values in this structure:.
         * <p>
         * <ul>
         * <li><code>CLUSTERED</code> : For clustered bar combo charts.</li>
         * <li><code>STACKED</code> : For stacked bar combo charts.</li>
         * <li><code>STACKED_PERCENT</code> : Do not use. If you use this value, the operation returns a validation error.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-barsarrangement">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-barsarrangement</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBarsArrangement() {
            return null;
        }

        /**
         * The category axis of a combo chart.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-categoryaxis">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-categoryaxis</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCategoryAxis() {
            return null;
        }

        /**
         * The label options (label text, label visibility, and sort icon visibility) of a combo chart category (group/color) field well.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-categorylabeloptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-categorylabeloptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCategoryLabelOptions() {
            return null;
        }

        /**
         * The label options (label text, label visibility, and sort icon visibility) of a combo chart's color field well.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-colorlabeloptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-colorlabeloptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getColorLabelOptions() {
            return null;
        }

        /**
         * The field wells of the visual.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-fieldwells">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-fieldwells</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFieldWells() {
            return null;
        }

        /**
         * The legend display setup of the visual.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-legend">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-legend</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLegend() {
            return null;
        }

        /**
         * The options that determine if visual data labels are displayed.
         * <p>
         * The data label options for a line in a combo chart.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-linedatalabels">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-linedatalabels</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLineDataLabels() {
            return null;
        }

        /**
         * The label display options (grid line, range, scale, and axis step) of a combo chart's primary y-axis (bar) field well.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-primaryyaxisdisplayoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-primaryyaxisdisplayoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPrimaryYAxisDisplayOptions() {
            return null;
        }

        /**
         * The label options (label text, label visibility, and sort icon visibility) of a combo chart's primary y-axis (bar) field well.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-primaryyaxislabeloptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-primaryyaxislabeloptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPrimaryYAxisLabelOptions() {
            return null;
        }

        /**
         * The reference line setup of the visual.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-referencelines">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-referencelines</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getReferenceLines() {
            return null;
        }

        /**
         * The label display options (grid line, range, scale, axis step) of a combo chart's secondary y-axis (line) field well.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-secondaryyaxisdisplayoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-secondaryyaxisdisplayoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSecondaryYAxisDisplayOptions() {
            return null;
        }

        /**
         * The label options (label text, label visibility, and sort icon visibility) of a combo chart's secondary y-axis(line) field well.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-secondaryyaxislabeloptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-secondaryyaxislabeloptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSecondaryYAxisLabelOptions() {
            return null;
        }

        /**
         * The sort configuration of a <code>ComboChartVisual</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-sortconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-sortconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSortConfiguration() {
            return null;
        }

        /**
         * The legend display setup of the visual.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-tooltip">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-tooltip</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTooltip() {
            return null;
        }

        /**
         * The palette (chart color) display setup of the visual.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-visualpalette">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-visualpalette</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVisualPalette() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ComboChartConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ComboChartConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ComboChartConfigurationProperty> {
            java.lang.Object barDataLabels;
            java.lang.String barsArrangement;
            java.lang.Object categoryAxis;
            java.lang.Object categoryLabelOptions;
            java.lang.Object colorLabelOptions;
            java.lang.Object fieldWells;
            java.lang.Object legend;
            java.lang.Object lineDataLabels;
            java.lang.Object primaryYAxisDisplayOptions;
            java.lang.Object primaryYAxisLabelOptions;
            java.lang.Object referenceLines;
            java.lang.Object secondaryYAxisDisplayOptions;
            java.lang.Object secondaryYAxisLabelOptions;
            java.lang.Object sortConfiguration;
            java.lang.Object tooltip;
            java.lang.Object visualPalette;

            /**
             * Sets the value of {@link ComboChartConfigurationProperty#getBarDataLabels}
             * @param barDataLabels The options that determine if visual data labels are displayed.
             *                      The data label options for a bar in a combo chart.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder barDataLabels(software.amazon.awscdk.IResolvable barDataLabels) {
                this.barDataLabels = barDataLabels;
                return this;
            }

            /**
             * Sets the value of {@link ComboChartConfigurationProperty#getBarDataLabels}
             * @param barDataLabels The options that determine if visual data labels are displayed.
             *                      The data label options for a bar in a combo chart.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder barDataLabels(software.amazon.awscdk.services.quicksight.CfnAnalysis.DataLabelOptionsProperty barDataLabels) {
                this.barDataLabels = barDataLabels;
                return this;
            }

            /**
             * Sets the value of {@link ComboChartConfigurationProperty#getBarsArrangement}
             * @param barsArrangement Determines the bar arrangement in a combo chart. The following are valid values in this structure:.
             *                        <ul>
             *                        <li><code>CLUSTERED</code> : For clustered bar combo charts.</li>
             *                        <li><code>STACKED</code> : For stacked bar combo charts.</li>
             *                        <li><code>STACKED_PERCENT</code> : Do not use. If you use this value, the operation returns a validation error.</li>
             *                        </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder barsArrangement(java.lang.String barsArrangement) {
                this.barsArrangement = barsArrangement;
                return this;
            }

            /**
             * Sets the value of {@link ComboChartConfigurationProperty#getCategoryAxis}
             * @param categoryAxis The category axis of a combo chart.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder categoryAxis(software.amazon.awscdk.IResolvable categoryAxis) {
                this.categoryAxis = categoryAxis;
                return this;
            }

            /**
             * Sets the value of {@link ComboChartConfigurationProperty#getCategoryAxis}
             * @param categoryAxis The category axis of a combo chart.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder categoryAxis(software.amazon.awscdk.services.quicksight.CfnAnalysis.AxisDisplayOptionsProperty categoryAxis) {
                this.categoryAxis = categoryAxis;
                return this;
            }

            /**
             * Sets the value of {@link ComboChartConfigurationProperty#getCategoryLabelOptions}
             * @param categoryLabelOptions The label options (label text, label visibility, and sort icon visibility) of a combo chart category (group/color) field well.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder categoryLabelOptions(software.amazon.awscdk.IResolvable categoryLabelOptions) {
                this.categoryLabelOptions = categoryLabelOptions;
                return this;
            }

            /**
             * Sets the value of {@link ComboChartConfigurationProperty#getCategoryLabelOptions}
             * @param categoryLabelOptions The label options (label text, label visibility, and sort icon visibility) of a combo chart category (group/color) field well.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder categoryLabelOptions(software.amazon.awscdk.services.quicksight.CfnAnalysis.ChartAxisLabelOptionsProperty categoryLabelOptions) {
                this.categoryLabelOptions = categoryLabelOptions;
                return this;
            }

            /**
             * Sets the value of {@link ComboChartConfigurationProperty#getColorLabelOptions}
             * @param colorLabelOptions The label options (label text, label visibility, and sort icon visibility) of a combo chart's color field well.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder colorLabelOptions(software.amazon.awscdk.IResolvable colorLabelOptions) {
                this.colorLabelOptions = colorLabelOptions;
                return this;
            }

            /**
             * Sets the value of {@link ComboChartConfigurationProperty#getColorLabelOptions}
             * @param colorLabelOptions The label options (label text, label visibility, and sort icon visibility) of a combo chart's color field well.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder colorLabelOptions(software.amazon.awscdk.services.quicksight.CfnAnalysis.ChartAxisLabelOptionsProperty colorLabelOptions) {
                this.colorLabelOptions = colorLabelOptions;
                return this;
            }

            /**
             * Sets the value of {@link ComboChartConfigurationProperty#getFieldWells}
             * @param fieldWells The field wells of the visual.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldWells(software.amazon.awscdk.IResolvable fieldWells) {
                this.fieldWells = fieldWells;
                return this;
            }

            /**
             * Sets the value of {@link ComboChartConfigurationProperty#getFieldWells}
             * @param fieldWells The field wells of the visual.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldWells(software.amazon.awscdk.services.quicksight.CfnAnalysis.ComboChartFieldWellsProperty fieldWells) {
                this.fieldWells = fieldWells;
                return this;
            }

            /**
             * Sets the value of {@link ComboChartConfigurationProperty#getLegend}
             * @param legend The legend display setup of the visual.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder legend(software.amazon.awscdk.IResolvable legend) {
                this.legend = legend;
                return this;
            }

            /**
             * Sets the value of {@link ComboChartConfigurationProperty#getLegend}
             * @param legend The legend display setup of the visual.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder legend(software.amazon.awscdk.services.quicksight.CfnAnalysis.LegendOptionsProperty legend) {
                this.legend = legend;
                return this;
            }

            /**
             * Sets the value of {@link ComboChartConfigurationProperty#getLineDataLabels}
             * @param lineDataLabels The options that determine if visual data labels are displayed.
             *                       The data label options for a line in a combo chart.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lineDataLabels(software.amazon.awscdk.IResolvable lineDataLabels) {
                this.lineDataLabels = lineDataLabels;
                return this;
            }

            /**
             * Sets the value of {@link ComboChartConfigurationProperty#getLineDataLabels}
             * @param lineDataLabels The options that determine if visual data labels are displayed.
             *                       The data label options for a line in a combo chart.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lineDataLabels(software.amazon.awscdk.services.quicksight.CfnAnalysis.DataLabelOptionsProperty lineDataLabels) {
                this.lineDataLabels = lineDataLabels;
                return this;
            }

            /**
             * Sets the value of {@link ComboChartConfigurationProperty#getPrimaryYAxisDisplayOptions}
             * @param primaryYAxisDisplayOptions The label display options (grid line, range, scale, and axis step) of a combo chart's primary y-axis (bar) field well.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder primaryYAxisDisplayOptions(software.amazon.awscdk.IResolvable primaryYAxisDisplayOptions) {
                this.primaryYAxisDisplayOptions = primaryYAxisDisplayOptions;
                return this;
            }

            /**
             * Sets the value of {@link ComboChartConfigurationProperty#getPrimaryYAxisDisplayOptions}
             * @param primaryYAxisDisplayOptions The label display options (grid line, range, scale, and axis step) of a combo chart's primary y-axis (bar) field well.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder primaryYAxisDisplayOptions(software.amazon.awscdk.services.quicksight.CfnAnalysis.AxisDisplayOptionsProperty primaryYAxisDisplayOptions) {
                this.primaryYAxisDisplayOptions = primaryYAxisDisplayOptions;
                return this;
            }

            /**
             * Sets the value of {@link ComboChartConfigurationProperty#getPrimaryYAxisLabelOptions}
             * @param primaryYAxisLabelOptions The label options (label text, label visibility, and sort icon visibility) of a combo chart's primary y-axis (bar) field well.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder primaryYAxisLabelOptions(software.amazon.awscdk.IResolvable primaryYAxisLabelOptions) {
                this.primaryYAxisLabelOptions = primaryYAxisLabelOptions;
                return this;
            }

            /**
             * Sets the value of {@link ComboChartConfigurationProperty#getPrimaryYAxisLabelOptions}
             * @param primaryYAxisLabelOptions The label options (label text, label visibility, and sort icon visibility) of a combo chart's primary y-axis (bar) field well.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder primaryYAxisLabelOptions(software.amazon.awscdk.services.quicksight.CfnAnalysis.ChartAxisLabelOptionsProperty primaryYAxisLabelOptions) {
                this.primaryYAxisLabelOptions = primaryYAxisLabelOptions;
                return this;
            }

            /**
             * Sets the value of {@link ComboChartConfigurationProperty#getReferenceLines}
             * @param referenceLines The reference line setup of the visual.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder referenceLines(software.amazon.awscdk.IResolvable referenceLines) {
                this.referenceLines = referenceLines;
                return this;
            }

            /**
             * Sets the value of {@link ComboChartConfigurationProperty#getReferenceLines}
             * @param referenceLines The reference line setup of the visual.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder referenceLines(java.util.List<? extends java.lang.Object> referenceLines) {
                this.referenceLines = referenceLines;
                return this;
            }

            /**
             * Sets the value of {@link ComboChartConfigurationProperty#getSecondaryYAxisDisplayOptions}
             * @param secondaryYAxisDisplayOptions The label display options (grid line, range, scale, axis step) of a combo chart's secondary y-axis (line) field well.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secondaryYAxisDisplayOptions(software.amazon.awscdk.IResolvable secondaryYAxisDisplayOptions) {
                this.secondaryYAxisDisplayOptions = secondaryYAxisDisplayOptions;
                return this;
            }

            /**
             * Sets the value of {@link ComboChartConfigurationProperty#getSecondaryYAxisDisplayOptions}
             * @param secondaryYAxisDisplayOptions The label display options (grid line, range, scale, axis step) of a combo chart's secondary y-axis (line) field well.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secondaryYAxisDisplayOptions(software.amazon.awscdk.services.quicksight.CfnAnalysis.AxisDisplayOptionsProperty secondaryYAxisDisplayOptions) {
                this.secondaryYAxisDisplayOptions = secondaryYAxisDisplayOptions;
                return this;
            }

            /**
             * Sets the value of {@link ComboChartConfigurationProperty#getSecondaryYAxisLabelOptions}
             * @param secondaryYAxisLabelOptions The label options (label text, label visibility, and sort icon visibility) of a combo chart's secondary y-axis(line) field well.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secondaryYAxisLabelOptions(software.amazon.awscdk.IResolvable secondaryYAxisLabelOptions) {
                this.secondaryYAxisLabelOptions = secondaryYAxisLabelOptions;
                return this;
            }

            /**
             * Sets the value of {@link ComboChartConfigurationProperty#getSecondaryYAxisLabelOptions}
             * @param secondaryYAxisLabelOptions The label options (label text, label visibility, and sort icon visibility) of a combo chart's secondary y-axis(line) field well.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secondaryYAxisLabelOptions(software.amazon.awscdk.services.quicksight.CfnAnalysis.ChartAxisLabelOptionsProperty secondaryYAxisLabelOptions) {
                this.secondaryYAxisLabelOptions = secondaryYAxisLabelOptions;
                return this;
            }

            /**
             * Sets the value of {@link ComboChartConfigurationProperty#getSortConfiguration}
             * @param sortConfiguration The sort configuration of a <code>ComboChartVisual</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sortConfiguration(software.amazon.awscdk.IResolvable sortConfiguration) {
                this.sortConfiguration = sortConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ComboChartConfigurationProperty#getSortConfiguration}
             * @param sortConfiguration The sort configuration of a <code>ComboChartVisual</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sortConfiguration(software.amazon.awscdk.services.quicksight.CfnAnalysis.ComboChartSortConfigurationProperty sortConfiguration) {
                this.sortConfiguration = sortConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ComboChartConfigurationProperty#getTooltip}
             * @param tooltip The legend display setup of the visual.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tooltip(software.amazon.awscdk.IResolvable tooltip) {
                this.tooltip = tooltip;
                return this;
            }

            /**
             * Sets the value of {@link ComboChartConfigurationProperty#getTooltip}
             * @param tooltip The legend display setup of the visual.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tooltip(software.amazon.awscdk.services.quicksight.CfnAnalysis.TooltipOptionsProperty tooltip) {
                this.tooltip = tooltip;
                return this;
            }

            /**
             * Sets the value of {@link ComboChartConfigurationProperty#getVisualPalette}
             * @param visualPalette The palette (chart color) display setup of the visual.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder visualPalette(software.amazon.awscdk.IResolvable visualPalette) {
                this.visualPalette = visualPalette;
                return this;
            }

            /**
             * Sets the value of {@link ComboChartConfigurationProperty#getVisualPalette}
             * @param visualPalette The palette (chart color) display setup of the visual.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder visualPalette(software.amazon.awscdk.services.quicksight.CfnAnalysis.VisualPaletteProperty visualPalette) {
                this.visualPalette = visualPalette;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ComboChartConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ComboChartConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ComboChartConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ComboChartConfigurationProperty {
            private final java.lang.Object barDataLabels;
            private final java.lang.String barsArrangement;
            private final java.lang.Object categoryAxis;
            private final java.lang.Object categoryLabelOptions;
            private final java.lang.Object colorLabelOptions;
            private final java.lang.Object fieldWells;
            private final java.lang.Object legend;
            private final java.lang.Object lineDataLabels;
            private final java.lang.Object primaryYAxisDisplayOptions;
            private final java.lang.Object primaryYAxisLabelOptions;
            private final java.lang.Object referenceLines;
            private final java.lang.Object secondaryYAxisDisplayOptions;
            private final java.lang.Object secondaryYAxisLabelOptions;
            private final java.lang.Object sortConfiguration;
            private final java.lang.Object tooltip;
            private final java.lang.Object visualPalette;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.barDataLabels = software.amazon.jsii.Kernel.get(this, "barDataLabels", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.barsArrangement = software.amazon.jsii.Kernel.get(this, "barsArrangement", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.categoryAxis = software.amazon.jsii.Kernel.get(this, "categoryAxis", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.categoryLabelOptions = software.amazon.jsii.Kernel.get(this, "categoryLabelOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.colorLabelOptions = software.amazon.jsii.Kernel.get(this, "colorLabelOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.fieldWells = software.amazon.jsii.Kernel.get(this, "fieldWells", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.legend = software.amazon.jsii.Kernel.get(this, "legend", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.lineDataLabels = software.amazon.jsii.Kernel.get(this, "lineDataLabels", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.primaryYAxisDisplayOptions = software.amazon.jsii.Kernel.get(this, "primaryYAxisDisplayOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.primaryYAxisLabelOptions = software.amazon.jsii.Kernel.get(this, "primaryYAxisLabelOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.referenceLines = software.amazon.jsii.Kernel.get(this, "referenceLines", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.secondaryYAxisDisplayOptions = software.amazon.jsii.Kernel.get(this, "secondaryYAxisDisplayOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.secondaryYAxisLabelOptions = software.amazon.jsii.Kernel.get(this, "secondaryYAxisLabelOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sortConfiguration = software.amazon.jsii.Kernel.get(this, "sortConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.tooltip = software.amazon.jsii.Kernel.get(this, "tooltip", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.visualPalette = software.amazon.jsii.Kernel.get(this, "visualPalette", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.barDataLabels = builder.barDataLabels;
                this.barsArrangement = builder.barsArrangement;
                this.categoryAxis = builder.categoryAxis;
                this.categoryLabelOptions = builder.categoryLabelOptions;
                this.colorLabelOptions = builder.colorLabelOptions;
                this.fieldWells = builder.fieldWells;
                this.legend = builder.legend;
                this.lineDataLabels = builder.lineDataLabels;
                this.primaryYAxisDisplayOptions = builder.primaryYAxisDisplayOptions;
                this.primaryYAxisLabelOptions = builder.primaryYAxisLabelOptions;
                this.referenceLines = builder.referenceLines;
                this.secondaryYAxisDisplayOptions = builder.secondaryYAxisDisplayOptions;
                this.secondaryYAxisLabelOptions = builder.secondaryYAxisLabelOptions;
                this.sortConfiguration = builder.sortConfiguration;
                this.tooltip = builder.tooltip;
                this.visualPalette = builder.visualPalette;
            }

            @Override
            public final java.lang.Object getBarDataLabels() {
                return this.barDataLabels;
            }

            @Override
            public final java.lang.String getBarsArrangement() {
                return this.barsArrangement;
            }

            @Override
            public final java.lang.Object getCategoryAxis() {
                return this.categoryAxis;
            }

            @Override
            public final java.lang.Object getCategoryLabelOptions() {
                return this.categoryLabelOptions;
            }

            @Override
            public final java.lang.Object getColorLabelOptions() {
                return this.colorLabelOptions;
            }

            @Override
            public final java.lang.Object getFieldWells() {
                return this.fieldWells;
            }

            @Override
            public final java.lang.Object getLegend() {
                return this.legend;
            }

            @Override
            public final java.lang.Object getLineDataLabels() {
                return this.lineDataLabels;
            }

            @Override
            public final java.lang.Object getPrimaryYAxisDisplayOptions() {
                return this.primaryYAxisDisplayOptions;
            }

            @Override
            public final java.lang.Object getPrimaryYAxisLabelOptions() {
                return this.primaryYAxisLabelOptions;
            }

            @Override
            public final java.lang.Object getReferenceLines() {
                return this.referenceLines;
            }

            @Override
            public final java.lang.Object getSecondaryYAxisDisplayOptions() {
                return this.secondaryYAxisDisplayOptions;
            }

            @Override
            public final java.lang.Object getSecondaryYAxisLabelOptions() {
                return this.secondaryYAxisLabelOptions;
            }

            @Override
            public final java.lang.Object getSortConfiguration() {
                return this.sortConfiguration;
            }

            @Override
            public final java.lang.Object getTooltip() {
                return this.tooltip;
            }

            @Override
            public final java.lang.Object getVisualPalette() {
                return this.visualPalette;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBarDataLabels() != null) {
                    data.set("barDataLabels", om.valueToTree(this.getBarDataLabels()));
                }
                if (this.getBarsArrangement() != null) {
                    data.set("barsArrangement", om.valueToTree(this.getBarsArrangement()));
                }
                if (this.getCategoryAxis() != null) {
                    data.set("categoryAxis", om.valueToTree(this.getCategoryAxis()));
                }
                if (this.getCategoryLabelOptions() != null) {
                    data.set("categoryLabelOptions", om.valueToTree(this.getCategoryLabelOptions()));
                }
                if (this.getColorLabelOptions() != null) {
                    data.set("colorLabelOptions", om.valueToTree(this.getColorLabelOptions()));
                }
                if (this.getFieldWells() != null) {
                    data.set("fieldWells", om.valueToTree(this.getFieldWells()));
                }
                if (this.getLegend() != null) {
                    data.set("legend", om.valueToTree(this.getLegend()));
                }
                if (this.getLineDataLabels() != null) {
                    data.set("lineDataLabels", om.valueToTree(this.getLineDataLabels()));
                }
                if (this.getPrimaryYAxisDisplayOptions() != null) {
                    data.set("primaryYAxisDisplayOptions", om.valueToTree(this.getPrimaryYAxisDisplayOptions()));
                }
                if (this.getPrimaryYAxisLabelOptions() != null) {
                    data.set("primaryYAxisLabelOptions", om.valueToTree(this.getPrimaryYAxisLabelOptions()));
                }
                if (this.getReferenceLines() != null) {
                    data.set("referenceLines", om.valueToTree(this.getReferenceLines()));
                }
                if (this.getSecondaryYAxisDisplayOptions() != null) {
                    data.set("secondaryYAxisDisplayOptions", om.valueToTree(this.getSecondaryYAxisDisplayOptions()));
                }
                if (this.getSecondaryYAxisLabelOptions() != null) {
                    data.set("secondaryYAxisLabelOptions", om.valueToTree(this.getSecondaryYAxisLabelOptions()));
                }
                if (this.getSortConfiguration() != null) {
                    data.set("sortConfiguration", om.valueToTree(this.getSortConfiguration()));
                }
                if (this.getTooltip() != null) {
                    data.set("tooltip", om.valueToTree(this.getTooltip()));
                }
                if (this.getVisualPalette() != null) {
                    data.set("visualPalette", om.valueToTree(this.getVisualPalette()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.ComboChartConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ComboChartConfigurationProperty.Jsii$Proxy that = (ComboChartConfigurationProperty.Jsii$Proxy) o;

                if (this.barDataLabels != null ? !this.barDataLabels.equals(that.barDataLabels) : that.barDataLabels != null) return false;
                if (this.barsArrangement != null ? !this.barsArrangement.equals(that.barsArrangement) : that.barsArrangement != null) return false;
                if (this.categoryAxis != null ? !this.categoryAxis.equals(that.categoryAxis) : that.categoryAxis != null) return false;
                if (this.categoryLabelOptions != null ? !this.categoryLabelOptions.equals(that.categoryLabelOptions) : that.categoryLabelOptions != null) return false;
                if (this.colorLabelOptions != null ? !this.colorLabelOptions.equals(that.colorLabelOptions) : that.colorLabelOptions != null) return false;
                if (this.fieldWells != null ? !this.fieldWells.equals(that.fieldWells) : that.fieldWells != null) return false;
                if (this.legend != null ? !this.legend.equals(that.legend) : that.legend != null) return false;
                if (this.lineDataLabels != null ? !this.lineDataLabels.equals(that.lineDataLabels) : that.lineDataLabels != null) return false;
                if (this.primaryYAxisDisplayOptions != null ? !this.primaryYAxisDisplayOptions.equals(that.primaryYAxisDisplayOptions) : that.primaryYAxisDisplayOptions != null) return false;
                if (this.primaryYAxisLabelOptions != null ? !this.primaryYAxisLabelOptions.equals(that.primaryYAxisLabelOptions) : that.primaryYAxisLabelOptions != null) return false;
                if (this.referenceLines != null ? !this.referenceLines.equals(that.referenceLines) : that.referenceLines != null) return false;
                if (this.secondaryYAxisDisplayOptions != null ? !this.secondaryYAxisDisplayOptions.equals(that.secondaryYAxisDisplayOptions) : that.secondaryYAxisDisplayOptions != null) return false;
                if (this.secondaryYAxisLabelOptions != null ? !this.secondaryYAxisLabelOptions.equals(that.secondaryYAxisLabelOptions) : that.secondaryYAxisLabelOptions != null) return false;
                if (this.sortConfiguration != null ? !this.sortConfiguration.equals(that.sortConfiguration) : that.sortConfiguration != null) return false;
                if (this.tooltip != null ? !this.tooltip.equals(that.tooltip) : that.tooltip != null) return false;
                return this.visualPalette != null ? this.visualPalette.equals(that.visualPalette) : that.visualPalette == null;
            }

            @Override
            public final int hashCode() {
                int result = this.barDataLabels != null ? this.barDataLabels.hashCode() : 0;
                result = 31 * result + (this.barsArrangement != null ? this.barsArrangement.hashCode() : 0);
                result = 31 * result + (this.categoryAxis != null ? this.categoryAxis.hashCode() : 0);
                result = 31 * result + (this.categoryLabelOptions != null ? this.categoryLabelOptions.hashCode() : 0);
                result = 31 * result + (this.colorLabelOptions != null ? this.colorLabelOptions.hashCode() : 0);
                result = 31 * result + (this.fieldWells != null ? this.fieldWells.hashCode() : 0);
                result = 31 * result + (this.legend != null ? this.legend.hashCode() : 0);
                result = 31 * result + (this.lineDataLabels != null ? this.lineDataLabels.hashCode() : 0);
                result = 31 * result + (this.primaryYAxisDisplayOptions != null ? this.primaryYAxisDisplayOptions.hashCode() : 0);
                result = 31 * result + (this.primaryYAxisLabelOptions != null ? this.primaryYAxisLabelOptions.hashCode() : 0);
                result = 31 * result + (this.referenceLines != null ? this.referenceLines.hashCode() : 0);
                result = 31 * result + (this.secondaryYAxisDisplayOptions != null ? this.secondaryYAxisDisplayOptions.hashCode() : 0);
                result = 31 * result + (this.secondaryYAxisLabelOptions != null ? this.secondaryYAxisLabelOptions.hashCode() : 0);
                result = 31 * result + (this.sortConfiguration != null ? this.sortConfiguration.hashCode() : 0);
                result = 31 * result + (this.tooltip != null ? this.tooltip.hashCode() : 0);
                result = 31 * result + (this.visualPalette != null ? this.visualPalette.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The field wells of the visual.
     * <p>
     * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartfieldwells.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartfieldwells.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.ComboChartFieldWellsProperty")
    @software.amazon.jsii.Jsii.Proxy(ComboChartFieldWellsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ComboChartFieldWellsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The aggregated field wells of a combo chart.
         * <p>
         * Combo charts only have aggregated field wells. Columns in a combo chart are aggregated by category.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartfieldwells.html#cfn-quicksight-analysis-combochartfieldwells-combochartaggregatedfieldwells">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartfieldwells.html#cfn-quicksight-analysis-combochartfieldwells-combochartaggregatedfieldwells</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getComboChartAggregatedFieldWells() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ComboChartFieldWellsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ComboChartFieldWellsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ComboChartFieldWellsProperty> {
            java.lang.Object comboChartAggregatedFieldWells;

            /**
             * Sets the value of {@link ComboChartFieldWellsProperty#getComboChartAggregatedFieldWells}
             * @param comboChartAggregatedFieldWells The aggregated field wells of a combo chart.
             *                                       Combo charts only have aggregated field wells. Columns in a combo chart are aggregated by category.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder comboChartAggregatedFieldWells(software.amazon.awscdk.IResolvable comboChartAggregatedFieldWells) {
                this.comboChartAggregatedFieldWells = comboChartAggregatedFieldWells;
                return this;
            }

            /**
             * Sets the value of {@link ComboChartFieldWellsProperty#getComboChartAggregatedFieldWells}
             * @param comboChartAggregatedFieldWells The aggregated field wells of a combo chart.
             *                                       Combo charts only have aggregated field wells. Columns in a combo chart are aggregated by category.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder comboChartAggregatedFieldWells(software.amazon.awscdk.services.quicksight.CfnAnalysis.ComboChartAggregatedFieldWellsProperty comboChartAggregatedFieldWells) {
                this.comboChartAggregatedFieldWells = comboChartAggregatedFieldWells;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ComboChartFieldWellsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ComboChartFieldWellsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ComboChartFieldWellsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ComboChartFieldWellsProperty {
            private final java.lang.Object comboChartAggregatedFieldWells;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.comboChartAggregatedFieldWells = software.amazon.jsii.Kernel.get(this, "comboChartAggregatedFieldWells", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.comboChartAggregatedFieldWells = builder.comboChartAggregatedFieldWells;
            }

            @Override
            public final java.lang.Object getComboChartAggregatedFieldWells() {
                return this.comboChartAggregatedFieldWells;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getComboChartAggregatedFieldWells() != null) {
                    data.set("comboChartAggregatedFieldWells", om.valueToTree(this.getComboChartAggregatedFieldWells()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnAnalysis.ComboChartFieldWellsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ComboChartFieldWellsProperty.Jsii$Proxy that = (ComboChartFieldWellsProperty.Jsii$Proxy) o;

                return this.comboChartAggregatedFieldWells != null ? this.comboChartAggregatedFieldWells.equals(that.comboChartAggregatedFieldWells) : that.comboChartAggregatedFieldWells == null;
            }

            @Override
            public final int hashCode() {
                int result = this.comboChartAggregatedFieldWells != null ? this.comboChartAggregatedFieldWells.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The sort configuration of a <code>ComboChartVisual</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * ComboChartSortConfigurationProperty comboChartSortConfigurationProperty = ComboChartSortConfigurationProperty.builder()
     *         .categoryItemsLimit(ItemsLimitConfigurationProperty.builder()
     *                 .itemsLimit(123)
     *                 .otherCategories("otherCategories")
     *                 .build())
     *         .categorySort(List.of(FieldSortOptionsProperty.builder()
     *                 .columnSort(ColumnSortProperty.builder()
     *                         .direction("direction")
     *                         .sortBy(ColumnIdentifierProperty.builder()
     *                                 .columnName("columnName")
     *                                 .dataSetIdentifier("dataSetIdentifier")
     *                                 .build())
     *                         // the properties below are optional
     *                         .aggregationFunction(AggregationFunctionProperty.builder()
     *                                 .attributeAggregationFunction(AttributeAggregationFunctionProperty.builder()
     *                                         .simpleAttributeAggregation("simpleAttributeAggregation")
     *                                         .valueForMultipleValues("valueForMultipleValues")
     *                                         .build())
     *                                 .categoricalAggregationFunction("categoricalAggregationFunction")
     *                                 .dateAggregationFunction("dateAggregationFunction")
     *                                 .numericalAggregationFunction(NumericalAggregationFunctionProperty.builder()
     *                                         .percentileAggregation(PercentileAggregationProperty.builder()
     *                                                 .percentileValue(123)
     *                                                 .build())
     *                                         .simpleNumericalAggregation("simpleNumericalAggregation")
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 .fieldSort(FieldSortProperty.builder()
     *                         .direction("direction")
     *                         .fieldId("fieldId")
     *                         .build())
     *                 .build()))
     *         .colorItemsLimit(ItemsLimitConfigurationProperty.builder()
     *                 .itemsLimit(123)
     *                 .otherCategories("otherCategories")
     *                 .build())
     *         .colorSort(List.of(FieldSortOptionsProperty.builder()
     *                 .columnSort(ColumnSortProperty.builder()
     *                         .direction("direction")
     *                         .sortBy(ColumnIdentifierProperty.builder()
     *                                 .columnName("columnName")
     *                                 .dataSetIdentifier("dataSetIdentifier")
     *                                 .build())
     *                         // the properties below are optional
     *                         .aggregationFunction(AggregationFunctionProperty.builder()
     *                                 .attributeAggregationFunction(AttributeAggregationFunctionProperty.builder()
     *                                         .simpleAttributeAggregation("simpleAttributeAggregation")
     *                                         .valueForMultipleValues("valueForMultipleValues")
     *                                         .build())
     *                                 .categoricalAggregationFunction("categoricalAggregationFunction")
     *                                 .dateAggregationFunction("dateAggregationFunction")
     *                                 .numericalAggregationFunction(NumericalAggregationFunctionProperty.builder()
     *                                         .percentileAggregation(PercentileAggregationProperty.builder()
     *                                                 .percentileValue(123)
     *                                                 .build())
     *                                         .simpleNumericalAggregation("simpleNumericalAggregation")
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 .fieldSort(FieldSortProperty.builder()
     *                         .direction("direction")
     *                         .fieldId("fieldId")
     *                         .build())
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartsortconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartsortconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnAnalysis.ComboChartSortConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ComboChartSortConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ComboChartSortConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The item limit configuration for the category field well of a combo chart.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartsortconfiguration.html#cfn-quicksight-analysis-combochartsortconfiguration-categoryitemslimit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartsortconfiguration.html#cfn-quicksight-analysis-combochartsortconfiguration-categoryitemslimit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCategoryItemsLimit() {
            return null;
        }

        /**
         * The sort configuration of the category field well in a combo chart.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartsortconfiguration.html#cfn-quicksight-analysis-combochartsortconfiguration-categorysort">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartsortconfiguration.html#cfn-quicksight-analysis-combochartsortconfiguration-categorysort</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCategorySort() {
            return null;
        }

        /**
         * The item limit configuration of the color field well in a combo chart.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartsortconfiguration.html#cfn-quicksight-analysis-combochartsortconfiguration-coloritemslimit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartsortconfiguration.html#cfn-quicksight-analysis-combochartsortconfiguration-coloritemslimit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getColorItemsLimit() {
            return null;
        }

        /**
         * The sort configuration of the color field well in a combo chart.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartsortconfiguration.html#cfn-quicksight-analysis-combochartsortconfiguration-colorsort">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartsortconfiguration.html#cfn-quicksight-analysis-combochartsortconfiguration-colorsort</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getColorSort() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ComboChartSortConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ComboChartSortConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ComboChartSortConfigurationProperty> {
            java.lang.Object categoryItemsLimit;
            java.lang.Object categorySort;
            java.lang.Object colorItemsLimit;
            java.lang.Object colorSort;

            /**
             * Sets the value of {@link ComboChartSortConfigurationProperty#getCategoryItemsLimit}
             * @param categoryItemsLimit The item limit configuration for the category field well of a combo chart.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder categoryItemsLimit(software.amazon.awscdk.IResolvable categoryItemsLim