package software.amazon.awscdk.services.resiliencehub;

/**
 * Properties for defining a <code>CfnApp</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.resiliencehub.*;
 * CfnAppProps cfnAppProps = CfnAppProps.builder()
 *         .appTemplateBody("appTemplateBody")
 *         .name("name")
 *         .resourceMappings(List.of(ResourceMappingProperty.builder()
 *                 .mappingType("mappingType")
 *                 .physicalResourceId(PhysicalResourceIdProperty.builder()
 *                         .identifier("identifier")
 *                         .type("type")
 *                         // the properties below are optional
 *                         .awsAccountId("awsAccountId")
 *                         .awsRegion("awsRegion")
 *                         .build())
 *                 // the properties below are optional
 *                 .eksSourceName("eksSourceName")
 *                 .logicalStackName("logicalStackName")
 *                 .resourceName("resourceName")
 *                 .terraformSourceName("terraformSourceName")
 *                 .build()))
 *         // the properties below are optional
 *         .appAssessmentSchedule("appAssessmentSchedule")
 *         .description("description")
 *         .eventSubscriptions(List.of(EventSubscriptionProperty.builder()
 *                 .eventType("eventType")
 *                 .name("name")
 *                 // the properties below are optional
 *                 .snsTopicArn("snsTopicArn")
 *                 .build()))
 *         .permissionModel(PermissionModelProperty.builder()
 *                 .type("type")
 *                 // the properties below are optional
 *                 .crossAccountRoleArns(List.of("crossAccountRoleArns"))
 *                 .invokerRoleName("invokerRoleName")
 *                 .build())
 *         .resiliencyPolicyArn("resiliencyPolicyArn")
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-22T22:42:57.299Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_resiliencehub.CfnAppProps")
@software.amazon.jsii.Jsii.Proxy(CfnAppProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnAppProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A JSON string that provides information about your application structure.
     * <p>
     * To learn more about the <code>appTemplateBody</code> template, see the sample template in <a href="https://docs.aws.amazon.com//resilience-hub/latest/APIReference/API_PutDraftAppVersionTemplate.html#API_PutDraftAppVersionTemplate_Examples">Sample appTemplateBody template</a> .
     * <p>
     * The <code>appTemplateBody</code> JSON string has the following structure:
     * <p>
     * <ul>
     * <li><em><code>resources</code></em></li>
     * </ul>
     * <p>
     * The list of logical resources that needs to be included in the AWS Resilience Hub application.
     * <p>
     * Type: Array
     * <p>
     * <blockquote>
     * <p>
     * Don't add the resources that you want to exclude.
     * <p>
     * </blockquote>
     * <p>
     * Each <code>resources</code> array item includes the following fields:
     * <p>
     * <ul>
     * <li><em><code>logicalResourceId</code></em></li>
     * </ul>
     * <p>
     * The logical identifier of the resource.
     * <p>
     * Type: Object
     * <p>
     * Each <code>logicalResourceId</code> object includes the following fields:
     * <p>
     * <ul>
     * <li><code>identifier</code></li>
     * </ul>
     * <p>
     * Identifier of the resource.
     * <p>
     * Type: String
     * <p>
     * <ul>
     * <li><code>logicalStackName</code></li>
     * </ul>
     * <p>
     * Name of the AWS CloudFormation stack this resource belongs to.
     * <p>
     * Type: String
     * <p>
     * <ul>
     * <li><code>resourceGroupName</code></li>
     * </ul>
     * <p>
     * Name of the resource group this resource belongs to.
     * <p>
     * Type: String
     * <p>
     * <ul>
     * <li><code>terraformSourceName</code></li>
     * </ul>
     * <p>
     * Name of the Terraform S3 state file this resource belongs to.
     * <p>
     * Type: String
     * <p>
     * <ul>
     * <li><code>eksSourceName</code></li>
     * </ul>
     * <p>
     * Name of the Amazon Elastic Kubernetes Service cluster and namespace this resource belongs to.
     * <p>
     * <blockquote>
     * <p>
     * This parameter accepts values in "eks-cluster/namespace" format.
     * <p>
     * </blockquote>
     * <p>
     * Type: String
     * <p>
     * <ul>
     * <li><em><code>type</code></em></li>
     * </ul>
     * <p>
     * The type of resource.
     * <p>
     * Type: string
     * <p>
     * <ul>
     * <li><em><code>name</code></em></li>
     * </ul>
     * <p>
     * Name of the resource.
     * <p>
     * Type: String
     * <p>
     * <ul>
     * <li><code>additionalInfo</code></li>
     * </ul>
     * <p>
     * Additional configuration parameters for an AWS Resilience Hub application. If you want to implement <code>additionalInfo</code> through the AWS Resilience Hub console rather than using an API call, see <a href="https://docs.aws.amazon.com//resilience-hub/latest/userguide/app-config-param.html">Configure the application configuration parameters</a> .
     * <p>
     * <blockquote>
     * <p>
     * Currently, this parameter accepts a key-value mapping (in a string format) of only one failover region and one associated account.
     * <p>
     * Key: <code>"failover-regions"</code>
     * <p>
     * Value: <code>"[{"region":"&lt;REGION&gt;", "accounts":[{"id":"&lt;ACCOUNT_ID&gt;"}]}]"</code>
     * <p>
     * </blockquote>
     * <p>
     * <ul>
     * <li><em><code>appComponents</code></em></li>
     * </ul>
     * <p>
     * The list of Application Components (AppComponent) that this resource belongs to. If an AppComponent is not part of the AWS Resilience Hub application, it will be added.
     * <p>
     * Type: Array
     * <p>
     * Each <code>appComponents</code> array item includes the following fields:
     * <p>
     * <ul>
     * <li><code>name</code></li>
     * </ul>
     * <p>
     * Name of the AppComponent.
     * <p>
     * Type: String
     * <p>
     * <ul>
     * <li><code>type</code></li>
     * </ul>
     * <p>
     * The type of AppComponent. For more information about the types of AppComponent, see <a href="https://docs.aws.amazon.com/resilience-hub/latest/userguide/AppComponent.grouping.html">Grouping resources in an AppComponent</a> .
     * <p>
     * Type: String
     * <p>
     * <ul>
     * <li><code>resourceNames</code></li>
     * </ul>
     * <p>
     * The list of included resources that are assigned to the AppComponent.
     * <p>
     * Type: Array of strings
     * <p>
     * <ul>
     * <li><code>additionalInfo</code></li>
     * </ul>
     * <p>
     * Additional configuration parameters for an AWS Resilience Hub application. If you want to implement <code>additionalInfo</code> through the AWS Resilience Hub console rather than using an API call, see <a href="https://docs.aws.amazon.com//resilience-hub/latest/userguide/app-config-param.html">Configure the application configuration parameters</a> .
     * <p>
     * <blockquote>
     * <p>
     * Currently, this parameter accepts a key-value mapping (in a string format) of only one failover region and one associated account.
     * <p>
     * Key: <code>"failover-regions"</code>
     * <p>
     * Value: <code>"[{"region":"&lt;REGION&gt;", "accounts":[{"id":"&lt;ACCOUNT_ID&gt;"}]}]"</code>
     * <p>
     * </blockquote>
     * <p>
     * <ul>
     * <li><em><code>excludedResources</code></em></li>
     * </ul>
     * <p>
     * The list of logical resource identifiers to be excluded from the application.
     * <p>
     * Type: Array
     * <p>
     * <blockquote>
     * <p>
     * Don't add the resources that you want to include.
     * <p>
     * </blockquote>
     * <p>
     * Each <code>excludedResources</code> array item includes the following fields:
     * <p>
     * <ul>
     * <li><em><code>logicalResourceIds</code></em></li>
     * </ul>
     * <p>
     * The logical identifier of the resource.
     * <p>
     * Type: Object
     * <p>
     * <blockquote>
     * <p>
     * You can configure only one of the following fields:
     * <p>
     * <ul>
     * <li><code>logicalStackName</code></li>
     * <li><code>resourceGroupName</code></li>
     * <li><code>terraformSourceName</code></li>
     * <li><code>eksSourceName</code></li>
     * </ul>
     * <p>
     * </blockquote>
     * <p>
     * Each <code>logicalResourceIds</code> object includes the following fields:
     * <p>
     * <ul>
     * <li><code>identifier</code></li>
     * </ul>
     * <p>
     * The identifier of the resource.
     * <p>
     * Type: String
     * <p>
     * <ul>
     * <li><code>logicalStackName</code></li>
     * </ul>
     * <p>
     * Name of the AWS CloudFormation stack this resource belongs to.
     * <p>
     * Type: String
     * <p>
     * <ul>
     * <li><code>resourceGroupName</code></li>
     * </ul>
     * <p>
     * Name of the resource group this resource belongs to.
     * <p>
     * Type: String
     * <p>
     * <ul>
     * <li><code>terraformSourceName</code></li>
     * </ul>
     * <p>
     * Name of the Terraform S3 state file this resource belongs to.
     * <p>
     * Type: String
     * <p>
     * <ul>
     * <li><code>eksSourceName</code></li>
     * </ul>
     * <p>
     * Name of the Amazon Elastic Kubernetes Service cluster and namespace this resource belongs to.
     * <p>
     * <blockquote>
     * <p>
     * This parameter accepts values in "eks-cluster/namespace" format.
     * <p>
     * </blockquote>
     * <p>
     * Type: String
     * <p>
     * <ul>
     * <li><em><code>version</code></em></li>
     * </ul>
     * <p>
     * The AWS Resilience Hub application version.
     * <p>
     * <ul>
     * <li><code>additionalInfo</code></li>
     * </ul>
     * <p>
     * Additional configuration parameters for an AWS Resilience Hub application. If you want to implement <code>additionalInfo</code> through the AWS Resilience Hub console rather than using an API call, see <a href="https://docs.aws.amazon.com//resilience-hub/latest/userguide/app-config-param.html">Configure the application configuration parameters</a> .
     * <p>
     * <blockquote>
     * <p>
     * Currently, this parameter accepts a key-value mapping (in a string format) of only one failover region and one associated account.
     * <p>
     * Key: <code>"failover-regions"</code>
     * <p>
     * Value: <code>"[{"region":"&lt;REGION&gt;", "accounts":[{"id":"&lt;ACCOUNT_ID&gt;"}]}]"</code>
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-apptemplatebody">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-apptemplatebody</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAppTemplateBody();

    /**
     * Name for the application.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * An array of <code>ResourceMapping</code> objects.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-resourcemappings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-resourcemappings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getResourceMappings();

    /**
     * Assessment execution schedule with 'Daily' or 'Disabled' values.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-appassessmentschedule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-appassessmentschedule</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAppAssessmentSchedule() {
        return null;
    }

    /**
     * Optional description for an application.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The list of events you would like to subscribe and get notification for.
     * <p>
     * Currently, AWS Resilience Hub supports notifications only for <em>Drift detected</em> and <em>Scheduled assessment failure</em> events.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-eventsubscriptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-eventsubscriptions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEventSubscriptions() {
        return null;
    }

    /**
     * Defines the roles and credentials that AWS Resilience Hub would use while creating the application, importing its resources, and running an assessment.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-permissionmodel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-permissionmodel</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPermissionModel() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the resiliency policy.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-resiliencypolicyarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-resiliencypolicyarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getResiliencyPolicyArn() {
        return null;
    }

    /**
     * Tags assigned to the resource.
     * <p>
     * A tag is a label that you assign to an AWS resource. Each tag consists of a key/value pair.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnAppProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnAppProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnAppProps> {
        java.lang.String appTemplateBody;
        java.lang.String name;
        java.lang.Object resourceMappings;
        java.lang.String appAssessmentSchedule;
        java.lang.String description;
        java.lang.Object eventSubscriptions;
        java.lang.Object permissionModel;
        java.lang.String resiliencyPolicyArn;
        java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Sets the value of {@link CfnAppProps#getAppTemplateBody}
         * @param appTemplateBody A JSON string that provides information about your application structure. This parameter is required.
         *                        To learn more about the <code>appTemplateBody</code> template, see the sample template in <a href="https://docs.aws.amazon.com//resilience-hub/latest/APIReference/API_PutDraftAppVersionTemplate.html#API_PutDraftAppVersionTemplate_Examples">Sample appTemplateBody template</a> .
         *                        <p>
         *                        The <code>appTemplateBody</code> JSON string has the following structure:
         *                        <p>
         *                        <ul>
         *                        <li><em><code>resources</code></em></li>
         *                        </ul>
         *                        <p>
         *                        The list of logical resources that needs to be included in the AWS Resilience Hub application.
         *                        <p>
         *                        Type: Array
         *                        <p>
         *                        <blockquote>
         *                        <p>
         *                        Don't add the resources that you want to exclude.
         *                        <p>
         *                        </blockquote>
         *                        <p>
         *                        Each <code>resources</code> array item includes the following fields:
         *                        <p>
         *                        <ul>
         *                        <li><em><code>logicalResourceId</code></em></li>
         *                        </ul>
         *                        <p>
         *                        The logical identifier of the resource.
         *                        <p>
         *                        Type: Object
         *                        <p>
         *                        Each <code>logicalResourceId</code> object includes the following fields:
         *                        <p>
         *                        <ul>
         *                        <li><code>identifier</code></li>
         *                        </ul>
         *                        <p>
         *                        Identifier of the resource.
         *                        <p>
         *                        Type: String
         *                        <p>
         *                        <ul>
         *                        <li><code>logicalStackName</code></li>
         *                        </ul>
         *                        <p>
         *                        Name of the AWS CloudFormation stack this resource belongs to.
         *                        <p>
         *                        Type: String
         *                        <p>
         *                        <ul>
         *                        <li><code>resourceGroupName</code></li>
         *                        </ul>
         *                        <p>
         *                        Name of the resource group this resource belongs to.
         *                        <p>
         *                        Type: String
         *                        <p>
         *                        <ul>
         *                        <li><code>terraformSourceName</code></li>
         *                        </ul>
         *                        <p>
         *                        Name of the Terraform S3 state file this resource belongs to.
         *                        <p>
         *                        Type: String
         *                        <p>
         *                        <ul>
         *                        <li><code>eksSourceName</code></li>
         *                        </ul>
         *                        <p>
         *                        Name of the Amazon Elastic Kubernetes Service cluster and namespace this resource belongs to.
         *                        <p>
         *                        <blockquote>
         *                        <p>
         *                        This parameter accepts values in "eks-cluster/namespace" format.
         *                        <p>
         *                        </blockquote>
         *                        <p>
         *                        Type: String
         *                        <p>
         *                        <ul>
         *                        <li><em><code>type</code></em></li>
         *                        </ul>
         *                        <p>
         *                        The type of resource.
         *                        <p>
         *                        Type: string
         *                        <p>
         *                        <ul>
         *                        <li><em><code>name</code></em></li>
         *                        </ul>
         *                        <p>
         *                        Name of the resource.
         *                        <p>
         *                        Type: String
         *                        <p>
         *                        <ul>
         *                        <li><code>additionalInfo</code></li>
         *                        </ul>
         *                        <p>
         *                        Additional configuration parameters for an AWS Resilience Hub application. If you want to implement <code>additionalInfo</code> through the AWS Resilience Hub console rather than using an API call, see <a href="https://docs.aws.amazon.com//resilience-hub/latest/userguide/app-config-param.html">Configure the application configuration parameters</a> .
         *                        <p>
         *                        <blockquote>
         *                        <p>
         *                        Currently, this parameter accepts a key-value mapping (in a string format) of only one failover region and one associated account.
         *                        <p>
         *                        Key: <code>"failover-regions"</code>
         *                        <p>
         *                        Value: <code>"[{"region":"&lt;REGION&gt;", "accounts":[{"id":"&lt;ACCOUNT_ID&gt;"}]}]"</code>
         *                        <p>
         *                        </blockquote>
         *                        <p>
         *                        <ul>
         *                        <li><em><code>appComponents</code></em></li>
         *                        </ul>
         *                        <p>
         *                        The list of Application Components (AppComponent) that this resource belongs to. If an AppComponent is not part of the AWS Resilience Hub application, it will be added.
         *                        <p>
         *                        Type: Array
         *                        <p>
         *                        Each <code>appComponents</code> array item includes the following fields:
         *                        <p>
         *                        <ul>
         *                        <li><code>name</code></li>
         *                        </ul>
         *                        <p>
         *                        Name of the AppComponent.
         *                        <p>
         *                        Type: String
         *                        <p>
         *                        <ul>
         *                        <li><code>type</code></li>
         *                        </ul>
         *                        <p>
         *                        The type of AppComponent. For more information about the types of AppComponent, see <a href="https://docs.aws.amazon.com/resilience-hub/latest/userguide/AppComponent.grouping.html">Grouping resources in an AppComponent</a> .
         *                        <p>
         *                        Type: String
         *                        <p>
         *                        <ul>
         *                        <li><code>resourceNames</code></li>
         *                        </ul>
         *                        <p>
         *                        The list of included resources that are assigned to the AppComponent.
         *                        <p>
         *                        Type: Array of strings
         *                        <p>
         *                        <ul>
         *                        <li><code>additionalInfo</code></li>
         *                        </ul>
         *                        <p>
         *                        Additional configuration parameters for an AWS Resilience Hub application. If you want to implement <code>additionalInfo</code> through the AWS Resilience Hub console rather than using an API call, see <a href="https://docs.aws.amazon.com//resilience-hub/latest/userguide/app-config-param.html">Configure the application configuration parameters</a> .
         *                        <p>
         *                        <blockquote>
         *                        <p>
         *                        Currently, this parameter accepts a key-value mapping (in a string format) of only one failover region and one associated account.
         *                        <p>
         *                        Key: <code>"failover-regions"</code>
         *                        <p>
         *                        Value: <code>"[{"region":"&lt;REGION&gt;", "accounts":[{"id":"&lt;ACCOUNT_ID&gt;"}]}]"</code>
         *                        <p>
         *                        </blockquote>
         *                        <p>
         *                        <ul>
         *                        <li><em><code>excludedResources</code></em></li>
         *                        </ul>
         *                        <p>
         *                        The list of logical resource identifiers to be excluded from the application.
         *                        <p>
         *                        Type: Array
         *                        <p>
         *                        <blockquote>
         *                        <p>
         *                        Don't add the resources that you want to include.
         *                        <p>
         *                        </blockquote>
         *                        <p>
         *                        Each <code>excludedResources</code> array item includes the following fields:
         *                        <p>
         *                        <ul>
         *                        <li><em><code>logicalResourceIds</code></em></li>
         *                        </ul>
         *                        <p>
         *                        The logical identifier of the resource.
         *                        <p>
         *                        Type: Object
         *                        <p>
         *                        <blockquote>
         *                        <p>
         *                        You can configure only one of the following fields:
         *                        <p>
         *                        <ul>
         *                        <li><code>logicalStackName</code></li>
         *                        <li><code>resourceGroupName</code></li>
         *                        <li><code>terraformSourceName</code></li>
         *                        <li><code>eksSourceName</code></li>
         *                        </ul>
         *                        <p>
         *                        </blockquote>
         *                        <p>
         *                        Each <code>logicalResourceIds</code> object includes the following fields:
         *                        <p>
         *                        <ul>
         *                        <li><code>identifier</code></li>
         *                        </ul>
         *                        <p>
         *                        The identifier of the resource.
         *                        <p>
         *                        Type: String
         *                        <p>
         *                        <ul>
         *                        <li><code>logicalStackName</code></li>
         *                        </ul>
         *                        <p>
         *                        Name of the AWS CloudFormation stack this resource belongs to.
         *                        <p>
         *                        Type: String
         *                        <p>
         *                        <ul>
         *                        <li><code>resourceGroupName</code></li>
         *                        </ul>
         *                        <p>
         *                        Name of the resource group this resource belongs to.
         *                        <p>
         *                        Type: String
         *                        <p>
         *                        <ul>
         *                        <li><code>terraformSourceName</code></li>
         *                        </ul>
         *                        <p>
         *                        Name of the Terraform S3 state file this resource belongs to.
         *                        <p>
         *                        Type: String
         *                        <p>
         *                        <ul>
         *                        <li><code>eksSourceName</code></li>
         *                        </ul>
         *                        <p>
         *                        Name of the Amazon Elastic Kubernetes Service cluster and namespace this resource belongs to.
         *                        <p>
         *                        <blockquote>
         *                        <p>
         *                        This parameter accepts values in "eks-cluster/namespace" format.
         *                        <p>
         *                        </blockquote>
         *                        <p>
         *                        Type: String
         *                        <p>
         *                        <ul>
         *                        <li><em><code>version</code></em></li>
         *                        </ul>
         *                        <p>
         *                        The AWS Resilience Hub application version.
         *                        <p>
         *                        <ul>
         *                        <li><code>additionalInfo</code></li>
         *                        </ul>
         *                        <p>
         *                        Additional configuration parameters for an AWS Resilience Hub application. If you want to implement <code>additionalInfo</code> through the AWS Resilience Hub console rather than using an API call, see <a href="https://docs.aws.amazon.com//resilience-hub/latest/userguide/app-config-param.html">Configure the application configuration parameters</a> .
         *                        <p>
         *                        <blockquote>
         *                        <p>
         *                        Currently, this parameter accepts a key-value mapping (in a string format) of only one failover region and one associated account.
         *                        <p>
         *                        Key: <code>"failover-regions"</code>
         *                        <p>
         *                        Value: <code>"[{"region":"&lt;REGION&gt;", "accounts":[{"id":"&lt;ACCOUNT_ID&gt;"}]}]"</code>
         *                        <p>
         *                        </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder appTemplateBody(java.lang.String appTemplateBody) {
            this.appTemplateBody = appTemplateBody;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppProps#getName}
         * @param name Name for the application. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppProps#getResourceMappings}
         * @param resourceMappings An array of <code>ResourceMapping</code> objects. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceMappings(software.amazon.awscdk.IResolvable resourceMappings) {
            this.resourceMappings = resourceMappings;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppProps#getResourceMappings}
         * @param resourceMappings An array of <code>ResourceMapping</code> objects. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceMappings(java.util.List<? extends java.lang.Object> resourceMappings) {
            this.resourceMappings = resourceMappings;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppProps#getAppAssessmentSchedule}
         * @param appAssessmentSchedule Assessment execution schedule with 'Daily' or 'Disabled' values.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder appAssessmentSchedule(java.lang.String appAssessmentSchedule) {
            this.appAssessmentSchedule = appAssessmentSchedule;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppProps#getDescription}
         * @param description Optional description for an application.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppProps#getEventSubscriptions}
         * @param eventSubscriptions The list of events you would like to subscribe and get notification for.
         *                           Currently, AWS Resilience Hub supports notifications only for <em>Drift detected</em> and <em>Scheduled assessment failure</em> events.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventSubscriptions(software.amazon.awscdk.IResolvable eventSubscriptions) {
            this.eventSubscriptions = eventSubscriptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppProps#getEventSubscriptions}
         * @param eventSubscriptions The list of events you would like to subscribe and get notification for.
         *                           Currently, AWS Resilience Hub supports notifications only for <em>Drift detected</em> and <em>Scheduled assessment failure</em> events.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventSubscriptions(java.util.List<? extends java.lang.Object> eventSubscriptions) {
            this.eventSubscriptions = eventSubscriptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppProps#getPermissionModel}
         * @param permissionModel Defines the roles and credentials that AWS Resilience Hub would use while creating the application, importing its resources, and running an assessment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder permissionModel(software.amazon.awscdk.IResolvable permissionModel) {
            this.permissionModel = permissionModel;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppProps#getPermissionModel}
         * @param permissionModel Defines the roles and credentials that AWS Resilience Hub would use while creating the application, importing its resources, and running an assessment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder permissionModel(software.amazon.awscdk.services.resiliencehub.CfnApp.PermissionModelProperty permissionModel) {
            this.permissionModel = permissionModel;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppProps#getResiliencyPolicyArn}
         * @param resiliencyPolicyArn The Amazon Resource Name (ARN) of the resiliency policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resiliencyPolicyArn(java.lang.String resiliencyPolicyArn) {
            this.resiliencyPolicyArn = resiliencyPolicyArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppProps#getTags}
         * @param tags Tags assigned to the resource.
         *             A tag is a label that you assign to an AWS resource. Each tag consists of a key/value pair.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnAppProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnAppProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnAppProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnAppProps {
        private final java.lang.String appTemplateBody;
        private final java.lang.String name;
        private final java.lang.Object resourceMappings;
        private final java.lang.String appAssessmentSchedule;
        private final java.lang.String description;
        private final java.lang.Object eventSubscriptions;
        private final java.lang.Object permissionModel;
        private final java.lang.String resiliencyPolicyArn;
        private final java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.appTemplateBody = software.amazon.jsii.Kernel.get(this, "appTemplateBody", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resourceMappings = software.amazon.jsii.Kernel.get(this, "resourceMappings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.appAssessmentSchedule = software.amazon.jsii.Kernel.get(this, "appAssessmentSchedule", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.eventSubscriptions = software.amazon.jsii.Kernel.get(this, "eventSubscriptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.permissionModel = software.amazon.jsii.Kernel.get(this, "permissionModel", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.resiliencyPolicyArn = software.amazon.jsii.Kernel.get(this, "resiliencyPolicyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.appTemplateBody = java.util.Objects.requireNonNull(builder.appTemplateBody, "appTemplateBody is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.resourceMappings = java.util.Objects.requireNonNull(builder.resourceMappings, "resourceMappings is required");
            this.appAssessmentSchedule = builder.appAssessmentSchedule;
            this.description = builder.description;
            this.eventSubscriptions = builder.eventSubscriptions;
            this.permissionModel = builder.permissionModel;
            this.resiliencyPolicyArn = builder.resiliencyPolicyArn;
            this.tags = builder.tags;
        }

        @Override
        public final java.lang.String getAppTemplateBody() {
            return this.appTemplateBody;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getResourceMappings() {
            return this.resourceMappings;
        }

        @Override
        public final java.lang.String getAppAssessmentSchedule() {
            return this.appAssessmentSchedule;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getEventSubscriptions() {
            return this.eventSubscriptions;
        }

        @Override
        public final java.lang.Object getPermissionModel() {
            return this.permissionModel;
        }

        @Override
        public final java.lang.String getResiliencyPolicyArn() {
            return this.resiliencyPolicyArn;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("appTemplateBody", om.valueToTree(this.getAppTemplateBody()));
            data.set("name", om.valueToTree(this.getName()));
            data.set("resourceMappings", om.valueToTree(this.getResourceMappings()));
            if (this.getAppAssessmentSchedule() != null) {
                data.set("appAssessmentSchedule", om.valueToTree(this.getAppAssessmentSchedule()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEventSubscriptions() != null) {
                data.set("eventSubscriptions", om.valueToTree(this.getEventSubscriptions()));
            }
            if (this.getPermissionModel() != null) {
                data.set("permissionModel", om.valueToTree(this.getPermissionModel()));
            }
            if (this.getResiliencyPolicyArn() != null) {
                data.set("resiliencyPolicyArn", om.valueToTree(this.getResiliencyPolicyArn()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_resiliencehub.CfnAppProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnAppProps.Jsii$Proxy that = (CfnAppProps.Jsii$Proxy) o;

            if (!appTemplateBody.equals(that.appTemplateBody)) return false;
            if (!name.equals(that.name)) return false;
            if (!resourceMappings.equals(that.resourceMappings)) return false;
            if (this.appAssessmentSchedule != null ? !this.appAssessmentSchedule.equals(that.appAssessmentSchedule) : that.appAssessmentSchedule != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.eventSubscriptions != null ? !this.eventSubscriptions.equals(that.eventSubscriptions) : that.eventSubscriptions != null) return false;
            if (this.permissionModel != null ? !this.permissionModel.equals(that.permissionModel) : that.permissionModel != null) return false;
            if (this.resiliencyPolicyArn != null ? !this.resiliencyPolicyArn.equals(that.resiliencyPolicyArn) : that.resiliencyPolicyArn != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.appTemplateBody.hashCode();
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.resourceMappings.hashCode());
            result = 31 * result + (this.appAssessmentSchedule != null ? this.appAssessmentSchedule.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.eventSubscriptions != null ? this.eventSubscriptions.hashCode() : 0);
            result = 31 * result + (this.permissionModel != null ? this.permissionModel.hashCode() : 0);
            result = 31 * result + (this.resiliencyPolicyArn != null ? this.resiliencyPolicyArn.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
