package software.amazon.awscdk.services.route53;

/**
 * Properties for defining a <code>CfnRecordSet</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.route53.*;
 * CfnRecordSetProps cfnRecordSetProps = CfnRecordSetProps.builder()
 *         .name("name")
 *         .type("type")
 *         // the properties below are optional
 *         .aliasTarget(AliasTargetProperty.builder()
 *                 .dnsName("dnsName")
 *                 .hostedZoneId("hostedZoneId")
 *                 // the properties below are optional
 *                 .evaluateTargetHealth(false)
 *                 .build())
 *         .cidrRoutingConfig(CidrRoutingConfigProperty.builder()
 *                 .collectionId("collectionId")
 *                 .locationName("locationName")
 *                 .build())
 *         .comment("comment")
 *         .failover("failover")
 *         .geoLocation(GeoLocationProperty.builder()
 *                 .continentCode("continentCode")
 *                 .countryCode("countryCode")
 *                 .subdivisionCode("subdivisionCode")
 *                 .build())
 *         .geoProximityLocation(GeoProximityLocationProperty.builder()
 *                 .awsRegion("awsRegion")
 *                 .bias(123)
 *                 .coordinates(CoordinatesProperty.builder()
 *                         .latitude("latitude")
 *                         .longitude("longitude")
 *                         .build())
 *                 .localZoneGroup("localZoneGroup")
 *                 .build())
 *         .healthCheckId("healthCheckId")
 *         .hostedZoneId("hostedZoneId")
 *         .hostedZoneName("hostedZoneName")
 *         .multiValueAnswer(false)
 *         .region("region")
 *         .resourceRecords(List.of("resourceRecords"))
 *         .setIdentifier("setIdentifier")
 *         .ttl("ttl")
 *         .weight(123)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordset.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordset.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-22T22:42:57.428Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53.CfnRecordSetProps")
@software.amazon.jsii.Jsii.Proxy(CfnRecordSetProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnRecordSetProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * For <code>ChangeResourceRecordSets</code> requests, the name of the record that you want to create, update, or delete.
     * <p>
     * For <code>ListResourceRecordSets</code> responses, the name of a record in the specified hosted zone.
     * <p>
     * <em>ChangeResourceRecordSets Only</em>
     * <p>
     * Enter a fully qualified domain name, for example, <code>www.example.com</code> . You can optionally include a trailing dot. If you omit the trailing dot, Amazon Route 53 assumes that the domain name that you specify is fully qualified. This means that Route 53 treats <code>www.example.com</code> (without a trailing dot) and <code>www.example.com.</code> (with a trailing dot) as identical.
     * <p>
     * For information about how to specify characters other than <code>a-z</code> , <code>0-9</code> , and <code>-</code> (hyphen) and how to specify internationalized domain names, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html">DNS Domain Name Format</a> in the <em>Amazon Route 53 Developer Guide</em> .
     * <p>
     * You can use the asterisk (*) wildcard to replace the leftmost label in a domain name, for example, <code>*.example.com</code> . Note the following:
     * <p>
     * <ul>
     * <li>The * must replace the entire label. For example, you can't specify <code>*prod.example.com</code> or <code>prod*.example.com</code> .</li>
     * <li>The * can't replace any of the middle labels, for example, marketing.*.example.com.</li>
     * <li>If you include * in any position other than the leftmost label in a domain name, DNS treats it as an * character (ASCII 42), not as a wildcard.</li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * You can't use the * wildcard for resource records sets that have a type of NS.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordset.html#cfn-route53-recordset-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordset.html#cfn-route53-recordset-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The DNS record type.
     * <p>
     * For information about different record types and how data is encoded for them, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html">Supported DNS Resource Record Types</a> in the <em>Amazon Route 53 Developer Guide</em> .
     * <p>
     * Valid values for basic resource record sets: <code>A</code> | <code>AAAA</code> | <code>CAA</code> | <code>CNAME</code> | <code>DS</code> | <code>MX</code> | <code>NAPTR</code> | <code>NS</code> | <code>PTR</code> | <code>SOA</code> | <code>SPF</code> | <code>SRV</code> | <code>TXT</code>
     * <p>
     * Values for weighted, latency, geolocation, and failover resource record sets: <code>A</code> | <code>AAAA</code> | <code>CAA</code> | <code>CNAME</code> | <code>MX</code> | <code>NAPTR</code> | <code>PTR</code> | <code>SPF</code> | <code>SRV</code> | <code>TXT</code> . When creating a group of weighted, latency, geolocation, or failover resource record sets, specify the same value for all of the resource record sets in the group.
     * <p>
     * Valid values for multivalue answer resource record sets: <code>A</code> | <code>AAAA</code> | <code>MX</code> | <code>NAPTR</code> | <code>PTR</code> | <code>SPF</code> | <code>SRV</code> | <code>TXT</code> | <code>CAA</code>
     * <p>
     * <blockquote>
     * <p>
     * SPF records were formerly used to verify the identity of the sender of email messages. However, we no longer recommend that you create resource record sets for which the value of <code>Type</code> is <code>SPF</code> . RFC 7208, <em>Sender Policy Framework (SPF) for Authorizing Use of Domains in Email, Version 1</em> , has been updated to say, "...[I]ts existence and mechanism defined in [RFC4408] have led to some interoperability issues. Accordingly, its use is no longer appropriate for SPF version 1; implementations are not to use it." In RFC 7208, see section 14.1, <a href="https://docs.aws.amazon.com/http://tools.ietf.org/html/rfc7208#section-14.1">The SPF DNS Record Type</a> .
     * <p>
     * </blockquote>
     * <p>
     * Values for alias resource record sets:
     * <p>
     * <ul>
     * <li><em>Amazon API Gateway custom regional APIs and edge-optimized APIs:</em> <code>A</code></li>
     * <li><em>CloudFront distributions:</em> <code>A</code></li>
     * </ul>
     * <p>
     * If IPv6 is enabled for the distribution, create two resource record sets to route traffic to your distribution, one with a value of <code>A</code> and one with a value of <code>AAAA</code> .
     * <p>
     * <ul>
     * <li><em>Amazon API Gateway environment that has a regionalized subdomain</em> : <code>A</code></li>
     * <li><em>ELB load balancers:</em> <code>A</code> | <code>AAAA</code></li>
     * <li><em>Amazon S3 buckets:</em> <code>A</code></li>
     * <li><em>Amazon Virtual Private Cloud interface VPC endpoints</em> <code>A</code></li>
     * <li><em>Another resource record set in this hosted zone:</em> Specify the type of the resource record set that you're creating the alias for. All values are supported except <code>NS</code> and <code>SOA</code> .</li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * If you're creating an alias record that has the same name as the hosted zone (known as the zone apex), you can't route traffic to a record for which the value of <code>Type</code> is <code>CNAME</code> . This is because the alias record must have the same type as the record you're routing traffic to, and creating a CNAME record for the zone apex isn't supported even for an alias record.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordset.html#cfn-route53-recordset-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordset.html#cfn-route53-recordset-type</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getType();

    /**
     * <em>Alias resource record sets only:</em> Information about the AWS resource, such as a CloudFront distribution or an Amazon S3 bucket, that you want to route traffic to.
     * <p>
     * If you're creating resource records sets for a private hosted zone, note the following:
     * <p>
     * <ul>
     * <li>You can't create an alias resource record set in a private hosted zone to route traffic to a CloudFront distribution.</li>
     * <li>For information about creating failover resource record sets in a private hosted zone, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-private-hosted-zones.html">Configuring Failover in a Private Hosted Zone</a> in the <em>Amazon Route 53 Developer Guide</em> .</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordset.html#cfn-route53-recordset-aliastarget">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordset.html#cfn-route53-recordset-aliastarget</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAliasTarget() {
        return null;
    }

    /**
     * The object that is specified in resource record set object when you are linking a resource record set to a CIDR location.
     * <p>
     * A <code>LocationName</code> with an asterisk “*” can be used to create a default CIDR record. <code>CollectionId</code> is still required for default record.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordset.html#cfn-route53-recordset-cidrroutingconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordset.html#cfn-route53-recordset-cidrroutingconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCidrRoutingConfig() {
        return null;
    }

    /**
     * <em>Optional:</em> Any comments you want to include about a change batch request.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordset.html#cfn-route53-recordset-comment">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordset.html#cfn-route53-recordset-comment</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getComment() {
        return null;
    }

    /**
     * <em>Failover resource record sets only:</em> To configure failover, you add the <code>Failover</code> element to two resource record sets.
     * <p>
     * For one resource record set, you specify <code>PRIMARY</code> as the value for <code>Failover</code> ; for the other resource record set, you specify <code>SECONDARY</code> . In addition, you include the <code>HealthCheckId</code> element and specify the health check that you want Amazon Route 53 to perform for each resource record set.
     * <p>
     * Except where noted, the following failover behaviors assume that you have included the <code>HealthCheckId</code> element in both resource record sets:
     * <p>
     * <ul>
     * <li>When the primary resource record set is healthy, Route 53 responds to DNS queries with the applicable value from the primary resource record set regardless of the health of the secondary resource record set.</li>
     * <li>When the primary resource record set is unhealthy and the secondary resource record set is healthy, Route 53 responds to DNS queries with the applicable value from the secondary resource record set.</li>
     * <li>When the secondary resource record set is unhealthy, Route 53 responds to DNS queries with the applicable value from the primary resource record set regardless of the health of the primary resource record set.</li>
     * <li>If you omit the <code>HealthCheckId</code> element for the secondary resource record set, and if the primary resource record set is unhealthy, Route 53 always responds to DNS queries with the applicable value from the secondary resource record set. This is true regardless of the health of the associated endpoint.</li>
     * </ul>
     * <p>
     * You can't create non-failover resource record sets that have the same values for the <code>Name</code> and <code>Type</code> elements as failover resource record sets.
     * <p>
     * For failover alias resource record sets, you must also include the <code>EvaluateTargetHealth</code> element and set the value to true.
     * <p>
     * For more information about configuring failover for Route 53, see the following topics in the <em>Amazon Route 53 Developer Guide</em> :
     * <p>
     * <ul>
     * <li><a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover.html">Route 53 Health Checks and DNS Failover</a></li>
     * <li><a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-private-hosted-zones.html">Configuring Failover in a Private Hosted Zone</a></li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordset.html#cfn-route53-recordset-failover">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordset.html#cfn-route53-recordset-failover</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFailover() {
        return null;
    }

    /**
     * <em>Geolocation resource record sets only:</em> A complex type that lets you control how Amazon Route 53 responds to DNS queries based on the geographic origin of the query.
     * <p>
     * For example, if you want all queries from Africa to be routed to a web server with an IP address of <code>192.0.2.111</code> , create a resource record set with a <code>Type</code> of <code>A</code> and a <code>ContinentCode</code> of <code>AF</code> .
     * <p>
     * If you create separate resource record sets for overlapping geographic regions (for example, one resource record set for a continent and one for a country on the same continent), priority goes to the smallest geographic region. This allows you to route most queries for a continent to one resource and to route queries for a country on that continent to a different resource.
     * <p>
     * You can't create two geolocation resource record sets that specify the same geographic location.
     * <p>
     * The value <code>*</code> in the <code>CountryCode</code> element matches all geographic locations that aren't specified in other geolocation resource record sets that have the same values for the <code>Name</code> and <code>Type</code> elements.
     * <p>
     * <blockquote>
     * <p>
     * Geolocation works by mapping IP addresses to locations. However, some IP addresses aren't mapped to geographic locations, so even if you create geolocation resource record sets that cover all seven continents, Route 53 will receive some DNS queries from locations that it can't identify. We recommend that you create a resource record set for which the value of <code>CountryCode</code> is <code>*</code> . Two groups of queries are routed to the resource that you specify in this record: queries that come from locations for which you haven't created geolocation resource record sets and queries from IP addresses that aren't mapped to a location. If you don't create a <code>*</code> resource record set, Route 53 returns a "no answer" response for queries from those locations.
     * <p>
     * </blockquote>
     * <p>
     * You can't create non-geolocation resource record sets that have the same values for the <code>Name</code> and <code>Type</code> elements as geolocation resource record sets.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordset.html#cfn-route53-recordset-geolocation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordset.html#cfn-route53-recordset-geolocation</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getGeoLocation() {
        return null;
    }

    /**
     * <em>GeoproximityLocation resource record sets only:</em> A complex type that lets you control how Route 53 responds to DNS queries based on the geographic origin of the query and your resources.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordset.html#cfn-route53-recordset-geoproximitylocation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordset.html#cfn-route53-recordset-geoproximitylocation</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getGeoProximityLocation() {
        return null;
    }

    /**
     * If you want Amazon Route 53 to return this resource record set in response to a DNS query only when the status of a health check is healthy, include the <code>HealthCheckId</code> element and specify the ID of the applicable health check.
     * <p>
     * Route 53 determines whether a resource record set is healthy based on one of the following:
     * <p>
     * <ul>
     * <li>By periodically sending a request to the endpoint that is specified in the health check</li>
     * <li>By aggregating the status of a specified group of health checks (calculated health checks)</li>
     * <li>By determining the current state of a CloudWatch alarm (CloudWatch metric health checks)</li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * Route 53 doesn't check the health of the endpoint that is specified in the resource record set, for example, the endpoint specified by the IP address in the <code>Value</code> element. When you add a <code>HealthCheckId</code> element to a resource record set, Route 53 checks the health of the endpoint that you specified in the health check.
     * <p>
     * </blockquote>
     * <p>
     * For more information, see the following topics in the <em>Amazon Route 53 Developer Guide</em> :
     * <p>
     * <ul>
     * <li><a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html">How Amazon Route 53 Determines Whether an Endpoint Is Healthy</a></li>
     * <li><a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover.html">Route 53 Health Checks and DNS Failover</a></li>
     * <li><a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-private-hosted-zones.html">Configuring Failover in a Private Hosted Zone</a></li>
     * </ul>
     * <p>
     * <em>When to Specify HealthCheckId</em>
     * <p>
     * Specifying a value for <code>HealthCheckId</code> is useful only when Route 53 is choosing between two or more resource record sets to respond to a DNS query, and you want Route 53 to base the choice in part on the status of a health check. Configuring health checks makes sense only in the following configurations:
     * <p>
     * <ul>
     * <li><em>Non-alias resource record sets</em> : You're checking the health of a group of non-alias resource record sets that have the same routing policy, name, and type (such as multiple weighted records named www.example.com with a type of A) and you specify health check IDs for all the resource record sets.</li>
     * </ul>
     * <p>
     * If the health check status for a resource record set is healthy, Route 53 includes the record among the records that it responds to DNS queries with.
     * <p>
     * If the health check status for a resource record set is unhealthy, Route 53 stops responding to DNS queries using the value for that resource record set.
     * <p>
     * If the health check status for all resource record sets in the group is unhealthy, Route 53 considers all resource record sets in the group healthy and responds to DNS queries accordingly.
     * <p>
     * <ul>
     * <li><em>Alias resource record sets</em> : You specify the following settings:</li>
     * <li>You set <code>EvaluateTargetHealth</code> to true for an alias resource record set in a group of resource record sets that have the same routing policy, name, and type (such as multiple weighted records named www.example.com with a type of A).</li>
     * <li>You configure the alias resource record set to route traffic to a non-alias resource record set in the same hosted zone.</li>
     * <li>You specify a health check ID for the non-alias resource record set.</li>
     * </ul>
     * <p>
     * If the health check status is healthy, Route 53 considers the alias resource record set to be healthy and includes the alias record among the records that it responds to DNS queries with.
     * <p>
     * If the health check status is unhealthy, Route 53 stops responding to DNS queries using the alias resource record set.
     * <p>
     * <blockquote>
     * <p>
     * The alias resource record set can also route traffic to a <em>group</em> of non-alias resource record sets that have the same routing policy, name, and type. In that configuration, associate health checks with all of the resource record sets in the group of non-alias resource record sets.
     * <p>
     * </blockquote>
     * <p>
     * <em>Geolocation Routing</em>
     * <p>
     * For geolocation resource record sets, if an endpoint is unhealthy, Route 53 looks for a resource record set for the larger, associated geographic region. For example, suppose you have resource record sets for a state in the United States, for the entire United States, for North America, and a resource record set that has <code>*</code> for <code>CountryCode</code> is <code>*</code> , which applies to all locations. If the endpoint for the state resource record set is unhealthy, Route 53 checks for healthy resource record sets in the following order until it finds a resource record set for which the endpoint is healthy:
     * <p>
     * <ul>
     * <li>The United States</li>
     * <li>North America</li>
     * <li>The default resource record set</li>
     * </ul>
     * <p>
     * <em>Specifying the Health Check Endpoint by Domain Name</em>
     * <p>
     * If your health checks specify the endpoint only by domain name, we recommend that you create a separate health check for each endpoint. For example, create a health check for each <code>HTTP</code> server that is serving content for <code>www.example.com</code> . For the value of <code>FullyQualifiedDomainName</code> , specify the domain name of the server (such as <code>us-east-2-www.example.com</code> ), not the name of the resource record sets ( <code>www.example.com</code> ).
     * <p>
     * <blockquote>
     * <p>
     * Health check results will be unpredictable if you do the following:
     * <p>
     * <ul>
     * <li>Create a health check that has the same value for <code>FullyQualifiedDomainName</code> as the name of a resource record set.</li>
     * <li>Associate that health check with the resource record set.</li>
     * </ul>
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordset.html#cfn-route53-recordset-healthcheckid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordset.html#cfn-route53-recordset-healthcheckid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getHealthCheckId() {
        return null;
    }

    /**
     * The ID of the hosted zone that you want to create records in.
     * <p>
     * Specify either <code>HostedZoneName</code> or <code>HostedZoneId</code> , but not both. If you have multiple hosted zones with the same domain name, you must specify the hosted zone using <code>HostedZoneId</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordset.html#cfn-route53-recordset-hostedzoneid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordset.html#cfn-route53-recordset-hostedzoneid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getHostedZoneId() {
        return null;
    }

    /**
     * The name of the hosted zone that you want to create records in.
     * <p>
     * You must include a trailing dot (for example, <code>www.example.com.</code> ) as part of the <code>HostedZoneName</code> .
     * <p>
     * When you create a stack using an AWS::Route53::RecordSet that specifies <code>HostedZoneName</code> , AWS CloudFormation attempts to find a hosted zone whose name matches the HostedZoneName. If AWS CloudFormation cannot find a hosted zone with a matching domain name, or if there is more than one hosted zone with the specified domain name, AWS CloudFormation will not create the stack.
     * <p>
     * Specify either <code>HostedZoneName</code> or <code>HostedZoneId</code> , but not both. If you have multiple hosted zones with the same domain name, you must specify the hosted zone using <code>HostedZoneId</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordset.html#cfn-route53-recordset-hostedzonename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordset.html#cfn-route53-recordset-hostedzonename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getHostedZoneName() {
        return null;
    }

    /**
     * <em>Multivalue answer resource record sets only</em> : To route traffic approximately randomly to multiple resources, such as web servers, create one multivalue answer record for each resource and specify <code>true</code> for <code>MultiValueAnswer</code> .
     * <p>
     * Note the following:
     * <p>
     * <ul>
     * <li>If you associate a health check with a multivalue answer resource record set, Amazon Route 53 responds to DNS queries with the corresponding IP address only when the health check is healthy.</li>
     * <li>If you don't associate a health check with a multivalue answer record, Route 53 always considers the record to be healthy.</li>
     * <li>Route 53 responds to DNS queries with up to eight healthy records; if you have eight or fewer healthy records, Route 53 responds to all DNS queries with all the healthy records.</li>
     * <li>If you have more than eight healthy records, Route 53 responds to different DNS resolvers with different combinations of healthy records.</li>
     * <li>When all records are unhealthy, Route 53 responds to DNS queries with up to eight unhealthy records.</li>
     * <li>If a resource becomes unavailable after a resolver caches a response, client software typically tries another of the IP addresses in the response.</li>
     * </ul>
     * <p>
     * You can't create multivalue answer alias records.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordset.html#cfn-route53-recordset-multivalueanswer">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordset.html#cfn-route53-recordset-multivalueanswer</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMultiValueAnswer() {
        return null;
    }

    /**
     * <em>Latency-based resource record sets only:</em> The Amazon EC2 Region where you created the resource that this resource record set refers to.
     * <p>
     * The resource typically is an AWS resource, such as an EC2 instance or an ELB load balancer, and is referred to by an IP address or a DNS domain name, depending on the record type.
     * <p>
     * When Amazon Route 53 receives a DNS query for a domain name and type for which you have created latency resource record sets, Route 53 selects the latency resource record set that has the lowest latency between the end user and the associated Amazon EC2 Region. Route 53 then returns the value that is associated with the selected resource record set.
     * <p>
     * Note the following:
     * <p>
     * <ul>
     * <li>You can only specify one <code>ResourceRecord</code> per latency resource record set.</li>
     * <li>You can only create one latency resource record set for each Amazon EC2 Region.</li>
     * <li>You aren't required to create latency resource record sets for all Amazon EC2 Regions. Route 53 will choose the region with the best latency from among the regions that you create latency resource record sets for.</li>
     * <li>You can't create non-latency resource record sets that have the same values for the <code>Name</code> and <code>Type</code> elements as latency resource record sets.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordset.html#cfn-route53-recordset-region">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordset.html#cfn-route53-recordset-region</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRegion() {
        return null;
    }

    /**
     * One or more values that correspond with the value that you specified for the <code>Type</code> property.
     * <p>
     * For example, if you specified <code>A</code> for <code>Type</code> , you specify one or more IP addresses in IPv4 format for <code>ResourceRecords</code> . For information about the format of values for each record type, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html">Supported DNS Resource Record Types</a> in the <em>Amazon Route 53 Developer Guide</em> .
     * <p>
     * Note the following:
     * <p>
     * <ul>
     * <li>You can specify more than one value for all record types except CNAME and SOA.</li>
     * <li>The maximum length of a value is 4000 characters.</li>
     * <li>If you're creating an alias record, omit <code>ResourceRecords</code> .</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordset.html#cfn-route53-recordset-resourcerecords">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordset.html#cfn-route53-recordset-resourcerecords</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getResourceRecords() {
        return null;
    }

    /**
     * <em>Resource record sets that have a routing policy other than simple:</em> An identifier that differentiates among multiple resource record sets that have the same combination of name and type, such as multiple weighted resource record sets named acme.example.com that have a type of A. In a group of resource record sets that have the same name and type, the value of <code>SetIdentifier</code> must be unique for each resource record set.
     * <p>
     * For information about routing policies, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy.html">Choosing a Routing Policy</a> in the <em>Amazon Route 53 Developer Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordset.html#cfn-route53-recordset-setidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordset.html#cfn-route53-recordset-setidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSetIdentifier() {
        return null;
    }

    /**
     * The resource record cache time to live (TTL), in seconds. Note the following:.
     * <p>
     * <ul>
     * <li>If you're creating or updating an alias resource record set, omit <code>TTL</code> . Amazon Route 53 uses the value of <code>TTL</code> for the alias target.</li>
     * <li>If you're associating this resource record set with a health check (if you're adding a <code>HealthCheckId</code> element), we recommend that you specify a <code>TTL</code> of 60 seconds or less so clients respond quickly to changes in health status.</li>
     * <li>All of the resource record sets in a group of weighted resource record sets must have the same value for <code>TTL</code> .</li>
     * <li>If a group of weighted resource record sets includes one or more weighted alias resource record sets for which the alias target is an ELB load balancer, we recommend that you specify a <code>TTL</code> of 60 seconds for all of the non-alias weighted resource record sets that have the same name and type. Values other than 60 seconds (the TTL for load balancers) will change the effect of the values that you specify for <code>Weight</code> .</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordset.html#cfn-route53-recordset-ttl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordset.html#cfn-route53-recordset-ttl</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTtl() {
        return null;
    }

    /**
     * <em>Weighted resource record sets only:</em> Among resource record sets that have the same combination of DNS name and type, a value that determines the proportion of DNS queries that Amazon Route 53 responds to using the current resource record set.
     * <p>
     * Route 53 calculates the sum of the weights for the resource record sets that have the same combination of DNS name and type. Route 53 then responds to queries based on the ratio of a resource's weight to the total. Note the following:
     * <p>
     * <ul>
     * <li>You must specify a value for the <code>Weight</code> element for every weighted resource record set.</li>
     * <li>You can only specify one <code>ResourceRecord</code> per weighted resource record set.</li>
     * <li>You can't create latency, failover, or geolocation resource record sets that have the same values for the <code>Name</code> and <code>Type</code> elements as weighted resource record sets.</li>
     * <li>You can create a maximum of 100 weighted resource record sets that have the same values for the <code>Name</code> and <code>Type</code> elements.</li>
     * <li>For weighted (but not weighted alias) resource record sets, if you set <code>Weight</code> to <code>0</code> for a resource record set, Route 53 never responds to queries with the applicable value for that resource record set. However, if you set <code>Weight</code> to <code>0</code> for all resource record sets that have the same combination of DNS name and type, traffic is routed to all resources with equal probability.</li>
     * </ul>
     * <p>
     * The effect of setting <code>Weight</code> to <code>0</code> is different when you associate health checks with weighted resource record sets. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-configuring-options.html">Options for Configuring Route 53 Active-Active and Active-Passive Failover</a> in the <em>Amazon Route 53 Developer Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordset.html#cfn-route53-recordset-weight">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordset.html#cfn-route53-recordset-weight</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getWeight() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnRecordSetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnRecordSetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnRecordSetProps> {
        java.lang.String name;
        java.lang.String type;
        java.lang.Object aliasTarget;
        java.lang.Object cidrRoutingConfig;
        java.lang.String comment;
        java.lang.String failover;
        java.lang.Object geoLocation;
        java.lang.Object geoProximityLocation;
        java.lang.String healthCheckId;
        java.lang.String hostedZoneId;
        java.lang.String hostedZoneName;
        java.lang.Object multiValueAnswer;
        java.lang.String region;
        java.util.List<java.lang.String> resourceRecords;
        java.lang.String setIdentifier;
        java.lang.String ttl;
        java.lang.Number weight;

        /**
         * Sets the value of {@link CfnRecordSetProps#getName}
         * @param name For <code>ChangeResourceRecordSets</code> requests, the name of the record that you want to create, update, or delete. This parameter is required.
         *             For <code>ListResourceRecordSets</code> responses, the name of a record in the specified hosted zone.
         *             <p>
         *             <em>ChangeResourceRecordSets Only</em>
         *             <p>
         *             Enter a fully qualified domain name, for example, <code>www.example.com</code> . You can optionally include a trailing dot. If you omit the trailing dot, Amazon Route 53 assumes that the domain name that you specify is fully qualified. This means that Route 53 treats <code>www.example.com</code> (without a trailing dot) and <code>www.example.com.</code> (with a trailing dot) as identical.
         *             <p>
         *             For information about how to specify characters other than <code>a-z</code> , <code>0-9</code> , and <code>-</code> (hyphen) and how to specify internationalized domain names, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html">DNS Domain Name Format</a> in the <em>Amazon Route 53 Developer Guide</em> .
         *             <p>
         *             You can use the asterisk (*) wildcard to replace the leftmost label in a domain name, for example, <code>*.example.com</code> . Note the following:
         *             <p>
         *             <ul>
         *             <li>The * must replace the entire label. For example, you can't specify <code>*prod.example.com</code> or <code>prod*.example.com</code> .</li>
         *             <li>The * can't replace any of the middle labels, for example, marketing.*.example.com.</li>
         *             <li>If you include * in any position other than the leftmost label in a domain name, DNS treats it as an * character (ASCII 42), not as a wildcard.</li>
         *             </ul>
         *             <p>
         *             <blockquote>
         *             <p>
         *             You can't use the * wildcard for resource records sets that have a type of NS.
         *             <p>
         *             </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnRecordSetProps#getType}
         * @param type The DNS record type. This parameter is required.
         *             For information about different record types and how data is encoded for them, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html">Supported DNS Resource Record Types</a> in the <em>Amazon Route 53 Developer Guide</em> .
         *             <p>
         *             Valid values for basic resource record sets: <code>A</code> | <code>AAAA</code> | <code>CAA</code> | <code>CNAME</code> | <code>DS</code> | <code>MX</code> | <code>NAPTR</code> | <code>NS</code> | <code>PTR</code> | <code>SOA</code> | <code>SPF</code> | <code>SRV</code> | <code>TXT</code>
         *             <p>
         *             Values for weighted, latency, geolocation, and failover resource record sets: <code>A</code> | <code>AAAA</code> | <code>CAA</code> | <code>CNAME</code> | <code>MX</code> | <code>NAPTR</code> | <code>PTR</code> | <code>SPF</code> | <code>SRV</code> | <code>TXT</code> . When creating a group of weighted, latency, geolocation, or failover resource record sets, specify the same value for all of the resource record sets in the group.
         *             <p>
         *             Valid values for multivalue answer resource record sets: <code>A</code> | <code>AAAA</code> | <code>MX</code> | <code>NAPTR</code> | <code>PTR</code> | <code>SPF</code> | <code>SRV</code> | <code>TXT</code> | <code>CAA</code>
         *             <p>
         *             <blockquote>
         *             <p>
         *             SPF records were formerly used to verify the identity of the sender of email messages. However, we no longer recommend that you create resource record sets for which the value of <code>Type</code> is <code>SPF</code> . RFC 7208, <em>Sender Policy Framework (SPF) for Authorizing Use of Domains in Email, Version 1</em> , has been updated to say, "...[I]ts existence and mechanism defined in [RFC4408] have led to some interoperability issues. Accordingly, its use is no longer appropriate for SPF version 1; implementations are not to use it." In RFC 7208, see section 14.1, <a href="https://docs.aws.amazon.com/http://tools.ietf.org/html/rfc7208#section-14.1">The SPF DNS Record Type</a> .
         *             <p>
         *             </blockquote>
         *             <p>
         *             Values for alias resource record sets:
         *             <p>
         *             <ul>
         *             <li><em>Amazon API Gateway custom regional APIs and edge-optimized APIs:</em> <code>A</code></li>
         *             <li><em>CloudFront distributions:</em> <code>A</code></li>
         *             </ul>
         *             <p>
         *             If IPv6 is enabled for the distribution, create two resource record sets to route traffic to your distribution, one with a value of <code>A</code> and one with a value of <code>AAAA</code> .
         *             <p>
         *             <ul>
         *             <li><em>Amazon API Gateway environment that has a regionalized subdomain</em> : <code>A</code></li>
         *             <li><em>ELB load balancers:</em> <code>A</code> | <code>AAAA</code></li>
         *             <li><em>Amazon S3 buckets:</em> <code>A</code></li>
         *             <li><em>Amazon Virtual Private Cloud interface VPC endpoints</em> <code>A</code></li>
         *             <li><em>Another resource record set in this hosted zone:</em> Specify the type of the resource record set that you're creating the alias for. All values are supported except <code>NS</code> and <code>SOA</code> .</li>
         *             </ul>
         *             <p>
         *             <blockquote>
         *             <p>
         *             If you're creating an alias record that has the same name as the hosted zone (known as the zone apex), you can't route traffic to a record for which the value of <code>Type</code> is <code>CNAME</code> . This is because the alias record must have the same type as the record you're routing traffic to, and creating a CNAME record for the zone apex isn't supported even for an alias record.
         *             <p>
         *             </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(java.lang.String type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link CfnRecordSetProps#getAliasTarget}
         * @param aliasTarget <em>Alias resource record sets only:</em> Information about the AWS resource, such as a CloudFront distribution or an Amazon S3 bucket, that you want to route traffic to.
         *                    If you're creating resource records sets for a private hosted zone, note the following:
         *                    <p>
         *                    <ul>
         *                    <li>You can't create an alias resource record set in a private hosted zone to route traffic to a CloudFront distribution.</li>
         *                    <li>For information about creating failover resource record sets in a private hosted zone, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-private-hosted-zones.html">Configuring Failover in a Private Hosted Zone</a> in the <em>Amazon Route 53 Developer Guide</em> .</li>
         *                    </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder aliasTarget(software.amazon.awscdk.IResolvable aliasTarget) {
            this.aliasTarget = aliasTarget;
            return this;
        }

        /**
         * Sets the value of {@link CfnRecordSetProps#getAliasTarget}
         * @param aliasTarget <em>Alias resource record sets only:</em> Information about the AWS resource, such as a CloudFront distribution or an Amazon S3 bucket, that you want to route traffic to.
         *                    If you're creating resource records sets for a private hosted zone, note the following:
         *                    <p>
         *                    <ul>
         *                    <li>You can't create an alias resource record set in a private hosted zone to route traffic to a CloudFront distribution.</li>
         *                    <li>For information about creating failover resource record sets in a private hosted zone, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-private-hosted-zones.html">Configuring Failover in a Private Hosted Zone</a> in the <em>Amazon Route 53 Developer Guide</em> .</li>
         *                    </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder aliasTarget(software.amazon.awscdk.services.route53.CfnRecordSet.AliasTargetProperty aliasTarget) {
            this.aliasTarget = aliasTarget;
            return this;
        }

        /**
         * Sets the value of {@link CfnRecordSetProps#getCidrRoutingConfig}
         * @param cidrRoutingConfig The object that is specified in resource record set object when you are linking a resource record set to a CIDR location.
         *                          A <code>LocationName</code> with an asterisk “*” can be used to create a default CIDR record. <code>CollectionId</code> is still required for default record.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cidrRoutingConfig(software.amazon.awscdk.IResolvable cidrRoutingConfig) {
            this.cidrRoutingConfig = cidrRoutingConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnRecordSetProps#getCidrRoutingConfig}
         * @param cidrRoutingConfig The object that is specified in resource record set object when you are linking a resource record set to a CIDR location.
         *                          A <code>LocationName</code> with an asterisk “*” can be used to create a default CIDR record. <code>CollectionId</code> is still required for default record.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cidrRoutingConfig(software.amazon.awscdk.services.route53.CfnRecordSet.CidrRoutingConfigProperty cidrRoutingConfig) {
            this.cidrRoutingConfig = cidrRoutingConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnRecordSetProps#getComment}
         * @param comment <em>Optional:</em> Any comments you want to include about a change batch request.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(java.lang.String comment) {
            this.comment = comment;
            return this;
        }

        /**
         * Sets the value of {@link CfnRecordSetProps#getFailover}
         * @param failover <em>Failover resource record sets only:</em> To configure failover, you add the <code>Failover</code> element to two resource record sets.
         *                 For one resource record set, you specify <code>PRIMARY</code> as the value for <code>Failover</code> ; for the other resource record set, you specify <code>SECONDARY</code> . In addition, you include the <code>HealthCheckId</code> element and specify the health check that you want Amazon Route 53 to perform for each resource record set.
         *                 <p>
         *                 Except where noted, the following failover behaviors assume that you have included the <code>HealthCheckId</code> element in both resource record sets:
         *                 <p>
         *                 <ul>
         *                 <li>When the primary resource record set is healthy, Route 53 responds to DNS queries with the applicable value from the primary resource record set regardless of the health of the secondary resource record set.</li>
         *                 <li>When the primary resource record set is unhealthy and the secondary resource record set is healthy, Route 53 responds to DNS queries with the applicable value from the secondary resource record set.</li>
         *                 <li>When the secondary resource record set is unhealthy, Route 53 responds to DNS queries with the applicable value from the primary resource record set regardless of the health of the primary resource record set.</li>
         *                 <li>If you omit the <code>HealthCheckId</code> element for the secondary resource record set, and if the primary resource record set is unhealthy, Route 53 always responds to DNS queries with the applicable value from the secondary resource record set. This is true regardless of the health of the associated endpoint.</li>
         *                 </ul>
         *                 <p>
         *                 You can't create non-failover resource record sets that have the same values for the <code>Name</code> and <code>Type</code> elements as failover resource record sets.
         *                 <p>
         *                 For failover alias resource record sets, you must also include the <code>EvaluateTargetHealth</code> element and set the value to true.
         *                 <p>
         *                 For more information about configuring failover for Route 53, see the following topics in the <em>Amazon Route 53 Developer Guide</em> :
         *                 <p>
         *                 <ul>
         *                 <li><a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover.html">Route 53 Health Checks and DNS Failover</a></li>
         *                 <li><a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-private-hosted-zones.html">Configuring Failover in a Private Hosted Zone</a></li>
         *                 </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder failover(java.lang.String failover) {
            this.failover = failover;
            return this;
        }

        /**
         * Sets the value of {@link CfnRecordSetProps#getGeoLocation}
         * @param geoLocation <em>Geolocation resource record sets only:</em> A complex type that lets you control how Amazon Route 53 responds to DNS queries based on the geographic origin of the query.
         *                    For example, if you want all queries from Africa to be routed to a web server with an IP address of <code>192.0.2.111</code> , create a resource record set with a <code>Type</code> of <code>A</code> and a <code>ContinentCode</code> of <code>AF</code> .
         *                    <p>
         *                    If you create separate resource record sets for overlapping geographic regions (for example, one resource record set for a continent and one for a country on the same continent), priority goes to the smallest geographic region. This allows you to route most queries for a continent to one resource and to route queries for a country on that continent to a different resource.
         *                    <p>
         *                    You can't create two geolocation resource record sets that specify the same geographic location.
         *                    <p>
         *                    The value <code>*</code> in the <code>CountryCode</code> element matches all geographic locations that aren't specified in other geolocation resource record sets that have the same values for the <code>Name</code> and <code>Type</code> elements.
         *                    <p>
         *                    <blockquote>
         *                    <p>
         *                    Geolocation works by mapping IP addresses to locations. However, some IP addresses aren't mapped to geographic locations, so even if you create geolocation resource record sets that cover all seven continents, Route 53 will receive some DNS queries from locations that it can't identify. We recommend that you create a resource record set for which the value of <code>CountryCode</code> is <code>*</code> . Two groups of queries are routed to the resource that you specify in this record: queries that come from locations for which you haven't created geolocation resource record sets and queries from IP addresses that aren't mapped to a location. If you don't create a <code>*</code> resource record set, Route 53 returns a "no answer" response for queries from those locations.
         *                    <p>
         *                    </blockquote>
         *                    <p>
         *                    You can't create non-geolocation resource record sets that have the same values for the <code>Name</code> and <code>Type</code> elements as geolocation resource record sets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder geoLocation(software.amazon.awscdk.IResolvable geoLocation) {
            this.geoLocation = geoLocation;
            return this;
        }

        /**
         * Sets the value of {@link CfnRecordSetProps#getGeoLocation}
         * @param geoLocation <em>Geolocation resource record sets only:</em> A complex type that lets you control how Amazon Route 53 responds to DNS queries based on the geographic origin of the query.
         *                    For example, if you want all queries from Africa to be routed to a web server with an IP address of <code>192.0.2.111</code> , create a resource record set with a <code>Type</code> of <code>A</code> and a <code>ContinentCode</code> of <code>AF</code> .
         *                    <p>
         *                    If you create separate resource record sets for overlapping geographic regions (for example, one resource record set for a continent and one for a country on the same continent), priority goes to the smallest geographic region. This allows you to route most queries for a continent to one resource and to route queries for a country on that continent to a different resource.
         *                    <p>
         *                    You can't create two geolocation resource record sets that specify the same geographic location.
         *                    <p>
         *                    The value <code>*</code> in the <code>CountryCode</code> element matches all geographic locations that aren't specified in other geolocation resource record sets that have the same values for the <code>Name</code> and <code>Type</code> elements.
         *                    <p>
         *                    <blockquote>
         *                    <p>
         *                    Geolocation works by mapping IP addresses to locations. However, some IP addresses aren't mapped to geographic locations, so even if you create geolocation resource record sets that cover all seven continents, Route 53 will receive some DNS queries from locations that it can't identify. We recommend that you create a resource record set for which the value of <code>CountryCode</code> is <code>*</code> . Two groups of queries are routed to the resource that you specify in this record: queries that come from locations for which you haven't created geolocation resource record sets and queries from IP addresses that aren't mapped to a location. If you don't create a <code>*</code> resource record set, Route 53 returns a "no answer" response for queries from those locations.
         *                    <p>
         *                    </blockquote>
         *                    <p>
         *                    You can't create non-geolocation resource record sets that have the same values for the <code>Name</code> and <code>Type</code> elements as geolocation resource record sets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder geoLocation(software.amazon.awscdk.services.route53.CfnRecordSet.GeoLocationProperty geoLocation) {
            this.geoLocation = geoLocation;
            return this;
        }

        /**
         * Sets the value of {@link CfnRecordSetProps#getGeoProximityLocation}
         * @param geoProximityLocation <em>GeoproximityLocation resource record sets only:</em> A complex type that lets you control how Route 53 responds to DNS queries based on the geographic origin of the query and your resources.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder geoProximityLocation(software.amazon.awscdk.IResolvable geoProximityLocation) {
            this.geoProximityLocation = geoProximityLocation;
            return this;
        }

        /**
         * Sets the value of {@link CfnRecordSetProps#getGeoProximityLocation}
         * @param geoProximityLocation <em>GeoproximityLocation resource record sets only:</em> A complex type that lets you control how Route 53 responds to DNS queries based on the geographic origin of the query and your resources.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder geoProximityLocation(software.amazon.awscdk.services.route53.CfnRecordSet.GeoProximityLocationProperty geoProximityLocation) {
            this.geoProximityLocation = geoProximityLocation;
            return this;
        }

        /**
         * Sets the value of {@link CfnRecordSetProps#getHealthCheckId}
         * @param healthCheckId If you want Amazon Route 53 to return this resource record set in response to a DNS query only when the status of a health check is healthy, include the <code>HealthCheckId</code> element and specify the ID of the applicable health check.
         *                      Route 53 determines whether a resource record set is healthy based on one of the following:
         *                      <p>
         *                      <ul>
         *                      <li>By periodically sending a request to the endpoint that is specified in the health check</li>
         *                      <li>By aggregating the status of a specified group of health checks (calculated health checks)</li>
         *                      <li>By determining the current state of a CloudWatch alarm (CloudWatch metric health checks)</li>
         *                      </ul>
         *                      <p>
         *                      <blockquote>
         *                      <p>
         *                      Route 53 doesn't check the health of the endpoint that is specified in the resource record set, for example, the endpoint specified by the IP address in the <code>Value</code> element. When you add a <code>HealthCheckId</code> element to a resource record set, Route 53 checks the health of the endpoint that you specified in the health check.
         *                      <p>
         *                      </blockquote>
         *                      <p>
         *                      For more information, see the following topics in the <em>Amazon Route 53 Developer Guide</em> :
         *                      <p>
         *                      <ul>
         *                      <li><a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html">How Amazon Route 53 Determines Whether an Endpoint Is Healthy</a></li>
         *                      <li><a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover.html">Route 53 Health Checks and DNS Failover</a></li>
         *                      <li><a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-private-hosted-zones.html">Configuring Failover in a Private Hosted Zone</a></li>
         *                      </ul>
         *                      <p>
         *                      <em>When to Specify HealthCheckId</em>
         *                      <p>
         *                      Specifying a value for <code>HealthCheckId</code> is useful only when Route 53 is choosing between two or more resource record sets to respond to a DNS query, and you want Route 53 to base the choice in part on the status of a health check. Configuring health checks makes sense only in the following configurations:
         *                      <p>
         *                      <ul>
         *                      <li><em>Non-alias resource record sets</em> : You're checking the health of a group of non-alias resource record sets that have the same routing policy, name, and type (such as multiple weighted records named www.example.com with a type of A) and you specify health check IDs for all the resource record sets.</li>
         *                      </ul>
         *                      <p>
         *                      If the health check status for a resource record set is healthy, Route 53 includes the record among the records that it responds to DNS queries with.
         *                      <p>
         *                      If the health check status for a resource record set is unhealthy, Route 53 stops responding to DNS queries using the value for that resource record set.
         *                      <p>
         *                      If the health check status for all resource record sets in the group is unhealthy, Route 53 considers all resource record sets in the group healthy and responds to DNS queries accordingly.
         *                      <p>
         *                      <ul>
         *                      <li><em>Alias resource record sets</em> : You specify the following settings:</li>
         *                      <li>You set <code>EvaluateTargetHealth</code> to true for an alias resource record set in a group of resource record sets that have the same routing policy, name, and type (such as multiple weighted records named www.example.com with a type of A).</li>
         *                      <li>You configure the alias resource record set to route traffic to a non-alias resource record set in the same hosted zone.</li>
         *                      <li>You specify a health check ID for the non-alias resource record set.</li>
         *                      </ul>
         *                      <p>
         *                      If the health check status is healthy, Route 53 considers the alias resource record set to be healthy and includes the alias record among the records that it responds to DNS queries with.
         *                      <p>
         *                      If the health check status is unhealthy, Route 53 stops responding to DNS queries using the alias resource record set.
         *                      <p>
         *                      <blockquote>
         *                      <p>
         *                      The alias resource record set can also route traffic to a <em>group</em> of non-alias resource record sets that have the same routing policy, name, and type. In that configuration, associate health checks with all of the resource record sets in the group of non-alias resource record sets.
         *                      <p>
         *                      </blockquote>
         *                      <p>
         *                      <em>Geolocation Routing</em>
         *                      <p>
         *                      For geolocation resource record sets, if an endpoint is unhealthy, Route 53 looks for a resource record set for the larger, associated geographic region. For example, suppose you have resource record sets for a state in the United States, for the entire United States, for North America, and a resource record set that has <code>*</code> for <code>CountryCode</code> is <code>*</code> , which applies to all locations. If the endpoint for the state resource record set is unhealthy, Route 53 checks for healthy resource record sets in the following order until it finds a resource record set for which the endpoint is healthy:
         *                      <p>
         *                      <ul>
         *                      <li>The United States</li>
         *                      <li>North America</li>
         *                      <li>The default resource record set</li>
         *                      </ul>
         *                      <p>
         *                      <em>Specifying the Health Check Endpoint by Domain Name</em>
         *                      <p>
         *                      If your health checks specify the endpoint only by domain name, we recommend that you create a separate health check for each endpoint. For example, create a health check for each <code>HTTP</code> server that is serving content for <code>www.example.com</code> . For the value of <code>FullyQualifiedDomainName</code> , specify the domain name of the server (such as <code>us-east-2-www.example.com</code> ), not the name of the resource record sets ( <code>www.example.com</code> ).
         *                      <p>
         *                      <blockquote>
         *                      <p>
         *                      Health check results will be unpredictable if you do the following:
         *                      <p>
         *                      <ul>
         *                      <li>Create a health check that has the same value for <code>FullyQualifiedDomainName</code> as the name of a resource record set.</li>
         *                      <li>Associate that health check with the resource record set.</li>
         *                      </ul>
         *                      <p>
         *                      </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheckId(java.lang.String healthCheckId) {
            this.healthCheckId = healthCheckId;
            return this;
        }

        /**
         * Sets the value of {@link CfnRecordSetProps#getHostedZoneId}
         * @param hostedZoneId The ID of the hosted zone that you want to create records in.
         *                     Specify either <code>HostedZoneName</code> or <code>HostedZoneId</code> , but not both. If you have multiple hosted zones with the same domain name, you must specify the hosted zone using <code>HostedZoneId</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostedZoneId(java.lang.String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        /**
         * Sets the value of {@link CfnRecordSetProps#getHostedZoneName}
         * @param hostedZoneName The name of the hosted zone that you want to create records in.
         *                       You must include a trailing dot (for example, <code>www.example.com.</code> ) as part of the <code>HostedZoneName</code> .
         *                       <p>
         *                       When you create a stack using an AWS::Route53::RecordSet that specifies <code>HostedZoneName</code> , AWS CloudFormation attempts to find a hosted zone whose name matches the HostedZoneName. If AWS CloudFormation cannot find a hosted zone with a matching domain name, or if there is more than one hosted zone with the specified domain name, AWS CloudFormation will not create the stack.
         *                       <p>
         *                       Specify either <code>HostedZoneName</code> or <code>HostedZoneId</code> , but not both. If you have multiple hosted zones with the same domain name, you must specify the hosted zone using <code>HostedZoneId</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostedZoneName(java.lang.String hostedZoneName) {
            this.hostedZoneName = hostedZoneName;
            return this;
        }

        /**
         * Sets the value of {@link CfnRecordSetProps#getMultiValueAnswer}
         * @param multiValueAnswer <em>Multivalue answer resource record sets only</em> : To route traffic approximately randomly to multiple resources, such as web servers, create one multivalue answer record for each resource and specify <code>true</code> for <code>MultiValueAnswer</code> .
         *                         Note the following:
         *                         <p>
         *                         <ul>
         *                         <li>If you associate a health check with a multivalue answer resource record set, Amazon Route 53 responds to DNS queries with the corresponding IP address only when the health check is healthy.</li>
         *                         <li>If you don't associate a health check with a multivalue answer record, Route 53 always considers the record to be healthy.</li>
         *                         <li>Route 53 responds to DNS queries with up to eight healthy records; if you have eight or fewer healthy records, Route 53 responds to all DNS queries with all the healthy records.</li>
         *                         <li>If you have more than eight healthy records, Route 53 responds to different DNS resolvers with different combinations of healthy records.</li>
         *                         <li>When all records are unhealthy, Route 53 responds to DNS queries with up to eight unhealthy records.</li>
         *                         <li>If a resource becomes unavailable after a resolver caches a response, client software typically tries another of the IP addresses in the response.</li>
         *                         </ul>
         *                         <p>
         *                         You can't create multivalue answer alias records.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multiValueAnswer(java.lang.Boolean multiValueAnswer) {
            this.multiValueAnswer = multiValueAnswer;
            return this;
        }

        /**
         * Sets the value of {@link CfnRecordSetProps#getMultiValueAnswer}
         * @param multiValueAnswer <em>Multivalue answer resource record sets only</em> : To route traffic approximately randomly to multiple resources, such as web servers, create one multivalue answer record for each resource and specify <code>true</code> for <code>MultiValueAnswer</code> .
         *                         Note the following:
         *                         <p>
         *                         <ul>
         *                         <li>If you associate a health check with a multivalue answer resource record set, Amazon Route 53 responds to DNS queries with the corresponding IP address only when the health check is healthy.</li>
         *                         <li>If you don't associate a health check with a multivalue answer record, Route 53 always considers the record to be healthy.</li>
         *                         <li>Route 53 responds to DNS queries with up to eight healthy records; if you have eight or fewer healthy records, Route 53 responds to all DNS queries with all the healthy records.</li>
         *                         <li>If you have more than eight healthy records, Route 53 responds to different DNS resolvers with different combinations of healthy records.</li>
         *                         <li>When all records are unhealthy, Route 53 responds to DNS queries with up to eight unhealthy records.</li>
         *                         <li>If a resource becomes unavailable after a resolver caches a response, client software typically tries another of the IP addresses in the response.</li>
         *                         </ul>
         *                         <p>
         *                         You can't create multivalue answer alias records.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multiValueAnswer(software.amazon.awscdk.IResolvable multiValueAnswer) {
            this.multiValueAnswer = multiValueAnswer;
            return this;
        }

        /**
         * Sets the value of {@link CfnRecordSetProps#getRegion}
         * @param region <em>Latency-based resource record sets only:</em> The Amazon EC2 Region where you created the resource that this resource record set refers to.
         *               The resource typically is an AWS resource, such as an EC2 instance or an ELB load balancer, and is referred to by an IP address or a DNS domain name, depending on the record type.
         *               <p>
         *               When Amazon Route 53 receives a DNS query for a domain name and type for which you have created latency resource record sets, Route 53 selects the latency resource record set that has the lowest latency between the end user and the associated Amazon EC2 Region. Route 53 then returns the value that is associated with the selected resource record set.
         *               <p>
         *               Note the following:
         *               <p>
         *               <ul>
         *               <li>You can only specify one <code>ResourceRecord</code> per latency resource record set.</li>
         *               <li>You can only create one latency resource record set for each Amazon EC2 Region.</li>
         *               <li>You aren't required to create latency resource record sets for all Amazon EC2 Regions. Route 53 will choose the region with the best latency from among the regions that you create latency resource record sets for.</li>
         *               <li>You can't create non-latency resource record sets that have the same values for the <code>Name</code> and <code>Type</code> elements as latency resource record sets.</li>
         *               </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(java.lang.String region) {
            this.region = region;
            return this;
        }

        /**
         * Sets the value of {@link CfnRecordSetProps#getResourceRecords}
         * @param resourceRecords One or more values that correspond with the value that you specified for the <code>Type</code> property.
         *                        For example, if you specified <code>A</code> for <code>Type</code> , you specify one or more IP addresses in IPv4 format for <code>ResourceRecords</code> . For information about the format of values for each record type, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html">Supported DNS Resource Record Types</a> in the <em>Amazon Route 53 Developer Guide</em> .
         *                        <p>
         *                        Note the following:
         *                        <p>
         *                        <ul>
         *                        <li>You can specify more than one value for all record types except CNAME and SOA.</li>
         *                        <li>The maximum length of a value is 4000 characters.</li>
         *                        <li>If you're creating an alias record, omit <code>ResourceRecords</code> .</li>
         *                        </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceRecords(java.util.List<java.lang.String> resourceRecords) {
            this.resourceRecords = resourceRecords;
            return this;
        }

        /**
         * Sets the value of {@link CfnRecordSetProps#getSetIdentifier}
         * @param setIdentifier <em>Resource record sets that have a routing policy other than simple:</em> An identifier that differentiates among multiple resource record sets that have the same combination of name and type, such as multiple weighted resource record sets named acme.example.com that have a type of A. In a group of resource record sets that have the same name and type, the value of <code>SetIdentifier</code> must be unique for each resource record set.
         *                      For information about routing policies, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy.html">Choosing a Routing Policy</a> in the <em>Amazon Route 53 Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder setIdentifier(java.lang.String setIdentifier) {
            this.setIdentifier = setIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnRecordSetProps#getTtl}
         * @param ttl The resource record cache time to live (TTL), in seconds. Note the following:.
         *            <ul>
         *            <li>If you're creating or updating an alias resource record set, omit <code>TTL</code> . Amazon Route 53 uses the value of <code>TTL</code> for the alias target.</li>
         *            <li>If you're associating this resource record set with a health check (if you're adding a <code>HealthCheckId</code> element), we recommend that you specify a <code>TTL</code> of 60 seconds or less so clients respond quickly to changes in health status.</li>
         *            <li>All of the resource record sets in a group of weighted resource record sets must have the same value for <code>TTL</code> .</li>
         *            <li>If a group of weighted resource record sets includes one or more weighted alias resource record sets for which the alias target is an ELB load balancer, we recommend that you specify a <code>TTL</code> of 60 seconds for all of the non-alias weighted resource record sets that have the same name and type. Values other than 60 seconds (the TTL for load balancers) will change the effect of the values that you specify for <code>Weight</code> .</li>
         *            </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ttl(java.lang.String ttl) {
            this.ttl = ttl;
            return this;
        }

        /**
         * Sets the value of {@link CfnRecordSetProps#getWeight}
         * @param weight <em>Weighted resource record sets only:</em> Among resource record sets that have the same combination of DNS name and type, a value that determines the proportion of DNS queries that Amazon Route 53 responds to using the current resource record set.
         *               Route 53 calculates the sum of the weights for the resource record sets that have the same combination of DNS name and type. Route 53 then responds to queries based on the ratio of a resource's weight to the total. Note the following:
         *               <p>
         *               <ul>
         *               <li>You must specify a value for the <code>Weight</code> element for every weighted resource record set.</li>
         *               <li>You can only specify one <code>ResourceRecord</code> per weighted resource record set.</li>
         *               <li>You can't create latency, failover, or geolocation resource record sets that have the same values for the <code>Name</code> and <code>Type</code> elements as weighted resource record sets.</li>
         *               <li>You can create a maximum of 100 weighted resource record sets that have the same values for the <code>Name</code> and <code>Type</code> elements.</li>
         *               <li>For weighted (but not weighted alias) resource record sets, if you set <code>Weight</code> to <code>0</code> for a resource record set, Route 53 never responds to queries with the applicable value for that resource record set. However, if you set <code>Weight</code> to <code>0</code> for all resource record sets that have the same combination of DNS name and type, traffic is routed to all resources with equal probability.</li>
         *               </ul>
         *               <p>
         *               The effect of setting <code>Weight</code> to <code>0</code> is different when you associate health checks with weighted resource record sets. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-configuring-options.html">Options for Configuring Route 53 Active-Active and Active-Passive Failover</a> in the <em>Amazon Route 53 Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder weight(java.lang.Number weight) {
            this.weight = weight;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnRecordSetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnRecordSetProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnRecordSetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnRecordSetProps {
        private final java.lang.String name;
        private final java.lang.String type;
        private final java.lang.Object aliasTarget;
        private final java.lang.Object cidrRoutingConfig;
        private final java.lang.String comment;
        private final java.lang.String failover;
        private final java.lang.Object geoLocation;
        private final java.lang.Object geoProximityLocation;
        private final java.lang.String healthCheckId;
        private final java.lang.String hostedZoneId;
        private final java.lang.String hostedZoneName;
        private final java.lang.Object multiValueAnswer;
        private final java.lang.String region;
        private final java.util.List<java.lang.String> resourceRecords;
        private final java.lang.String setIdentifier;
        private final java.lang.String ttl;
        private final java.lang.Number weight;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.aliasTarget = software.amazon.jsii.Kernel.get(this, "aliasTarget", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.cidrRoutingConfig = software.amazon.jsii.Kernel.get(this, "cidrRoutingConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.comment = software.amazon.jsii.Kernel.get(this, "comment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.failover = software.amazon.jsii.Kernel.get(this, "failover", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.geoLocation = software.amazon.jsii.Kernel.get(this, "geoLocation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.geoProximityLocation = software.amazon.jsii.Kernel.get(this, "geoProximityLocation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.healthCheckId = software.amazon.jsii.Kernel.get(this, "healthCheckId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.hostedZoneId = software.amazon.jsii.Kernel.get(this, "hostedZoneId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.hostedZoneName = software.amazon.jsii.Kernel.get(this, "hostedZoneName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.multiValueAnswer = software.amazon.jsii.Kernel.get(this, "multiValueAnswer", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resourceRecords = software.amazon.jsii.Kernel.get(this, "resourceRecords", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.setIdentifier = software.amazon.jsii.Kernel.get(this, "setIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ttl = software.amazon.jsii.Kernel.get(this, "ttl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.weight = software.amazon.jsii.Kernel.get(this, "weight", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            this.aliasTarget = builder.aliasTarget;
            this.cidrRoutingConfig = builder.cidrRoutingConfig;
            this.comment = builder.comment;
            this.failover = builder.failover;
            this.geoLocation = builder.geoLocation;
            this.geoProximityLocation = builder.geoProximityLocation;
            this.healthCheckId = builder.healthCheckId;
            this.hostedZoneId = builder.hostedZoneId;
            this.hostedZoneName = builder.hostedZoneName;
            this.multiValueAnswer = builder.multiValueAnswer;
            this.region = builder.region;
            this.resourceRecords = builder.resourceRecords;
            this.setIdentifier = builder.setIdentifier;
            this.ttl = builder.ttl;
            this.weight = builder.weight;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getType() {
            return this.type;
        }

        @Override
        public final java.lang.Object getAliasTarget() {
            return this.aliasTarget;
        }

        @Override
        public final java.lang.Object getCidrRoutingConfig() {
            return this.cidrRoutingConfig;
        }

        @Override
        public final java.lang.String getComment() {
            return this.comment;
        }

        @Override
        public final java.lang.String getFailover() {
            return this.failover;
        }

        @Override
        public final java.lang.Object getGeoLocation() {
            return this.geoLocation;
        }

        @Override
        public final java.lang.Object getGeoProximityLocation() {
            return this.geoProximityLocation;
        }

        @Override
        public final java.lang.String getHealthCheckId() {
            return this.healthCheckId;
        }

        @Override
        public final java.lang.String getHostedZoneId() {
            return this.hostedZoneId;
        }

        @Override
        public final java.lang.String getHostedZoneName() {
            return this.hostedZoneName;
        }

        @Override
        public final java.lang.Object getMultiValueAnswer() {
            return this.multiValueAnswer;
        }

        @Override
        public final java.lang.String getRegion() {
            return this.region;
        }

        @Override
        public final java.util.List<java.lang.String> getResourceRecords() {
            return this.resourceRecords;
        }

        @Override
        public final java.lang.String getSetIdentifier() {
            return this.setIdentifier;
        }

        @Override
        public final java.lang.String getTtl() {
            return this.ttl;
        }

        @Override
        public final java.lang.Number getWeight() {
            return this.weight;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            data.set("type", om.valueToTree(this.getType()));
            if (this.getAliasTarget() != null) {
                data.set("aliasTarget", om.valueToTree(this.getAliasTarget()));
            }
            if (this.getCidrRoutingConfig() != null) {
                data.set("cidrRoutingConfig", om.valueToTree(this.getCidrRoutingConfig()));
            }
            if (this.getComment() != null) {
                data.set("comment", om.valueToTree(this.getComment()));
            }
            if (this.getFailover() != null) {
                data.set("failover", om.valueToTree(this.getFailover()));
            }
            if (this.getGeoLocation() != null) {
                data.set("geoLocation", om.valueToTree(this.getGeoLocation()));
            }
            if (this.getGeoProximityLocation() != null) {
                data.set("geoProximityLocation", om.valueToTree(this.getGeoProximityLocation()));
            }
            if (this.getHealthCheckId() != null) {
                data.set("healthCheckId", om.valueToTree(this.getHealthCheckId()));
            }
            if (this.getHostedZoneId() != null) {
                data.set("hostedZoneId", om.valueToTree(this.getHostedZoneId()));
            }
            if (this.getHostedZoneName() != null) {
                data.set("hostedZoneName", om.valueToTree(this.getHostedZoneName()));
            }
            if (this.getMultiValueAnswer() != null) {
                data.set("multiValueAnswer", om.valueToTree(this.getMultiValueAnswer()));
            }
            if (this.getRegion() != null) {
                data.set("region", om.valueToTree(this.getRegion()));
            }
            if (this.getResourceRecords() != null) {
                data.set("resourceRecords", om.valueToTree(this.getResourceRecords()));
            }
            if (this.getSetIdentifier() != null) {
                data.set("setIdentifier", om.valueToTree(this.getSetIdentifier()));
            }
            if (this.getTtl() != null) {
                data.set("ttl", om.valueToTree(this.getTtl()));
            }
            if (this.getWeight() != null) {
                data.set("weight", om.valueToTree(this.getWeight()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_route53.CfnRecordSetProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnRecordSetProps.Jsii$Proxy that = (CfnRecordSetProps.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (!type.equals(that.type)) return false;
            if (this.aliasTarget != null ? !this.aliasTarget.equals(that.aliasTarget) : that.aliasTarget != null) return false;
            if (this.cidrRoutingConfig != null ? !this.cidrRoutingConfig.equals(that.cidrRoutingConfig) : that.cidrRoutingConfig != null) return false;
            if (this.comment != null ? !this.comment.equals(that.comment) : that.comment != null) return false;
            if (this.failover != null ? !this.failover.equals(that.failover) : that.failover != null) return false;
            if (this.geoLocation != null ? !this.geoLocation.equals(that.geoLocation) : that.geoLocation != null) return false;
            if (this.geoProximityLocation != null ? !this.geoProximityLocation.equals(that.geoProximityLocation) : that.geoProximityLocation != null) return false;
            if (this.healthCheckId != null ? !this.healthCheckId.equals(that.healthCheckId) : that.healthCheckId != null) return false;
            if (this.hostedZoneId != null ? !this.hostedZoneId.equals(that.hostedZoneId) : that.hostedZoneId != null) return false;
            if (this.hostedZoneName != null ? !this.hostedZoneName.equals(that.hostedZoneName) : that.hostedZoneName != null) return false;
            if (this.multiValueAnswer != null ? !this.multiValueAnswer.equals(that.multiValueAnswer) : that.multiValueAnswer != null) return false;
            if (this.region != null ? !this.region.equals(that.region) : that.region != null) return false;
            if (this.resourceRecords != null ? !this.resourceRecords.equals(that.resourceRecords) : that.resourceRecords != null) return false;
            if (this.setIdentifier != null ? !this.setIdentifier.equals(that.setIdentifier) : that.setIdentifier != null) return false;
            if (this.ttl != null ? !this.ttl.equals(that.ttl) : that.ttl != null) return false;
            return this.weight != null ? this.weight.equals(that.weight) : that.weight == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.type.hashCode());
            result = 31 * result + (this.aliasTarget != null ? this.aliasTarget.hashCode() : 0);
            result = 31 * result + (this.cidrRoutingConfig != null ? this.cidrRoutingConfig.hashCode() : 0);
            result = 31 * result + (this.comment != null ? this.comment.hashCode() : 0);
            result = 31 * result + (this.failover != null ? this.failover.hashCode() : 0);
            result = 31 * result + (this.geoLocation != null ? this.geoLocation.hashCode() : 0);
            result = 31 * result + (this.geoProximityLocation != null ? this.geoProximityLocation.hashCode() : 0);
            result = 31 * result + (this.healthCheckId != null ? this.healthCheckId.hashCode() : 0);
            result = 31 * result + (this.hostedZoneId != null ? this.hostedZoneId.hashCode() : 0);
            result = 31 * result + (this.hostedZoneName != null ? this.hostedZoneName.hashCode() : 0);
            result = 31 * result + (this.multiValueAnswer != null ? this.multiValueAnswer.hashCode() : 0);
            result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
            result = 31 * result + (this.resourceRecords != null ? this.resourceRecords.hashCode() : 0);
            result = 31 * result + (this.setIdentifier != null ? this.setIdentifier.hashCode() : 0);
            result = 31 * result + (this.ttl != null ? this.ttl.hashCode() : 0);
            result = 31 * result + (this.weight != null ? this.weight.hashCode() : 0);
            return result;
        }
    }
}
