package software.amazon.awscdk.services.s3;

/**
 * Default bucket access control types.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket websiteBucket = Bucket.Builder.create(this, "WebsiteBucket")
 *         .websiteIndexDocument("index.html")
 *         .publicReadAccess(true)
 *         .build();
 * BucketDeployment.Builder.create(this, "DeployWebsite")
 *         .sources(List.of(Source.asset("./website-dist")))
 *         .destinationBucket(websiteBucket)
 *         .destinationKeyPrefix("web/static") // optional prefix in destination bucket
 *         .metadata(Map.of("A", "1", "b", "2")) // user-defined metadata
 *         // system-defined metadata
 *         .contentType("text/html")
 *         .contentLanguage("en")
 *         .storageClass(StorageClass.INTELLIGENT_TIERING)
 *         .serverSideEncryption(ServerSideEncryption.AES_256)
 *         .cacheControl(List.of(CacheControl.setPublic(), CacheControl.maxAge(Duration.hours(1))))
 *         .accessControl(BucketAccessControl.BUCKET_OWNER_FULL_CONTROL)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html">https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-22T22:42:57.567Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3.BucketAccessControl")
public enum BucketAccessControl {
    /**
     * Owner gets FULL_CONTROL.
     * <p>
     * No one else has access rights.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PRIVATE,
    /**
     * Owner gets FULL_CONTROL.
     * <p>
     * The AllUsers group gets READ access.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PUBLIC_READ,
    /**
     * Owner gets FULL_CONTROL.
     * <p>
     * The AllUsers group gets READ and WRITE access.
     * Granting this on a bucket is generally not recommended.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PUBLIC_READ_WRITE,
    /**
     * Owner gets FULL_CONTROL.
     * <p>
     * The AuthenticatedUsers group gets READ access.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AUTHENTICATED_READ,
    /**
     * The LogDelivery group gets WRITE and READ_ACP permissions on the bucket.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerLogs.html">https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerLogs.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    LOG_DELIVERY_WRITE,
    /**
     * Object owner gets FULL_CONTROL.
     * <p>
     * Bucket owner gets READ access.
     * If you specify this canned ACL when creating a bucket, Amazon S3 ignores it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BUCKET_OWNER_READ,
    /**
     * Both the object owner and the bucket owner get FULL_CONTROL over the object.
     * <p>
     * If you specify this canned ACL when creating a bucket, Amazon S3 ignores it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BUCKET_OWNER_FULL_CONTROL,
    /**
     * Owner gets FULL_CONTROL.
     * <p>
     * Amazon EC2 gets READ access to GET an Amazon Machine Image (AMI) bundle from Amazon S3.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AWS_EXEC_READ,
}
