package software.amazon.awscdk.services.s3;

/**
 * Describes when noncurrent versions transition to a specified storage class.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.s3.*;
 * StorageClass storageClass;
 * NoncurrentVersionTransition noncurrentVersionTransition = NoncurrentVersionTransition.builder()
 *         .storageClass(storageClass)
 *         .transitionAfter(Duration.minutes(30))
 *         // the properties below are optional
 *         .noncurrentVersionsToRetain(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-22T22:42:57.697Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3.NoncurrentVersionTransition")
@software.amazon.jsii.Jsii.Proxy(NoncurrentVersionTransition.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface NoncurrentVersionTransition extends software.amazon.jsii.JsiiSerializable {

    /**
     * The storage class to which you want the object to transition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.StorageClass getStorageClass();

    /**
     * Indicates the number of days after creation when objects are transitioned to the specified storage class.
     * <p>
     * Default: - No transition count.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.Duration getTransitionAfter();

    /**
     * Indicates the number of noncurrent version objects to be retained.
     * <p>
     * Can be up to 100 noncurrent versions retained.
     * <p>
     * Default: - No noncurrent version retained.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getNoncurrentVersionsToRetain() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link NoncurrentVersionTransition}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link NoncurrentVersionTransition}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<NoncurrentVersionTransition> {
        software.amazon.awscdk.services.s3.StorageClass storageClass;
        software.amazon.awscdk.Duration transitionAfter;
        java.lang.Number noncurrentVersionsToRetain;

        /**
         * Sets the value of {@link NoncurrentVersionTransition#getStorageClass}
         * @param storageClass The storage class to which you want the object to transition. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageClass(software.amazon.awscdk.services.s3.StorageClass storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        /**
         * Sets the value of {@link NoncurrentVersionTransition#getTransitionAfter}
         * @param transitionAfter Indicates the number of days after creation when objects are transitioned to the specified storage class. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transitionAfter(software.amazon.awscdk.Duration transitionAfter) {
            this.transitionAfter = transitionAfter;
            return this;
        }

        /**
         * Sets the value of {@link NoncurrentVersionTransition#getNoncurrentVersionsToRetain}
         * @param noncurrentVersionsToRetain Indicates the number of noncurrent version objects to be retained.
         *                                   Can be up to 100 noncurrent versions retained.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder noncurrentVersionsToRetain(java.lang.Number noncurrentVersionsToRetain) {
            this.noncurrentVersionsToRetain = noncurrentVersionsToRetain;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link NoncurrentVersionTransition}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public NoncurrentVersionTransition build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link NoncurrentVersionTransition}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NoncurrentVersionTransition {
        private final software.amazon.awscdk.services.s3.StorageClass storageClass;
        private final software.amazon.awscdk.Duration transitionAfter;
        private final java.lang.Number noncurrentVersionsToRetain;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.storageClass = software.amazon.jsii.Kernel.get(this, "storageClass", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.StorageClass.class));
            this.transitionAfter = software.amazon.jsii.Kernel.get(this, "transitionAfter", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.noncurrentVersionsToRetain = software.amazon.jsii.Kernel.get(this, "noncurrentVersionsToRetain", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.storageClass = java.util.Objects.requireNonNull(builder.storageClass, "storageClass is required");
            this.transitionAfter = java.util.Objects.requireNonNull(builder.transitionAfter, "transitionAfter is required");
            this.noncurrentVersionsToRetain = builder.noncurrentVersionsToRetain;
        }

        @Override
        public final software.amazon.awscdk.services.s3.StorageClass getStorageClass() {
            return this.storageClass;
        }

        @Override
        public final software.amazon.awscdk.Duration getTransitionAfter() {
            return this.transitionAfter;
        }

        @Override
        public final java.lang.Number getNoncurrentVersionsToRetain() {
            return this.noncurrentVersionsToRetain;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("storageClass", om.valueToTree(this.getStorageClass()));
            data.set("transitionAfter", om.valueToTree(this.getTransitionAfter()));
            if (this.getNoncurrentVersionsToRetain() != null) {
                data.set("noncurrentVersionsToRetain", om.valueToTree(this.getNoncurrentVersionsToRetain()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_s3.NoncurrentVersionTransition"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            NoncurrentVersionTransition.Jsii$Proxy that = (NoncurrentVersionTransition.Jsii$Proxy) o;

            if (!storageClass.equals(that.storageClass)) return false;
            if (!transitionAfter.equals(that.transitionAfter)) return false;
            return this.noncurrentVersionsToRetain != null ? this.noncurrentVersionsToRetain.equals(that.noncurrentVersionsToRetain) : that.noncurrentVersionsToRetain == null;
        }

        @Override
        public final int hashCode() {
            int result = this.storageClass.hashCode();
            result = 31 * result + (this.transitionAfter.hashCode());
            result = 31 * result + (this.noncurrentVersionsToRetain != null ? this.noncurrentVersionsToRetain.hashCode() : 0);
            return result;
        }
    }
}
