package software.amazon.awscdk.services.sagemaker;

/**
 * Use the <code>AWS::SageMaker::Endpoint</code> resource to create an endpoint using the specified configuration in the request.
 * <p>
 * Amazon SageMaker uses the endpoint to provision resources and deploy models. You create the endpoint configuration with the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html">AWS::SageMaker::EndpointConfig</a> resource. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/how-it-works-hosting.html">Deploy a Model on Amazon SageMaker Hosting Services</a> in the <em>Amazon SageMaker Developer Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sagemaker.*;
 * CfnEndpoint cfnEndpoint = CfnEndpoint.Builder.create(this, "MyCfnEndpoint")
 *         .endpointConfigName("endpointConfigName")
 *         // the properties below are optional
 *         .deploymentConfig(DeploymentConfigProperty.builder()
 *                 .autoRollbackConfiguration(AutoRollbackConfigProperty.builder()
 *                         .alarms(List.of(AlarmProperty.builder()
 *                                 .alarmName("alarmName")
 *                                 .build()))
 *                         .build())
 *                 .blueGreenUpdatePolicy(BlueGreenUpdatePolicyProperty.builder()
 *                         .trafficRoutingConfiguration(TrafficRoutingConfigProperty.builder()
 *                                 .type("type")
 *                                 // the properties below are optional
 *                                 .canarySize(CapacitySizeProperty.builder()
 *                                         .type("type")
 *                                         .value(123)
 *                                         .build())
 *                                 .linearStepSize(CapacitySizeProperty.builder()
 *                                         .type("type")
 *                                         .value(123)
 *                                         .build())
 *                                 .waitIntervalInSeconds(123)
 *                                 .build())
 *                         // the properties below are optional
 *                         .maximumExecutionTimeoutInSeconds(123)
 *                         .terminationWaitInSeconds(123)
 *                         .build())
 *                 .rollingUpdatePolicy(RollingUpdatePolicyProperty.builder()
 *                         .maximumBatchSize(CapacitySizeProperty.builder()
 *                                 .type("type")
 *                                 .value(123)
 *                                 .build())
 *                         .waitIntervalInSeconds(123)
 *                         // the properties below are optional
 *                         .maximumExecutionTimeoutInSeconds(123)
 *                         .rollbackMaximumBatchSize(CapacitySizeProperty.builder()
 *                                 .type("type")
 *                                 .value(123)
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .endpointName("endpointName")
 *         .excludeRetainedVariantProperties(List.of(VariantPropertyProperty.builder()
 *                 .variantPropertyType("variantPropertyType")
 *                 .build()))
 *         .retainAllVariantProperties(false)
 *         .retainDeploymentConfig(false)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-22T22:42:57.813Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnEndpoint")
public class CfnEndpoint extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnEndpoint(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnEndpoint(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.sagemaker.CfnEndpoint.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnEndpoint(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sagemaker.CfnEndpointProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The name of the endpoint, such as <code>MyEndpoint</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrEndpointName() {
        return software.amazon.jsii.Kernel.get(this, "attrEndpointName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The name of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html">AWS::SageMaker::EndpointConfig</a> resource that specifies the configuration for the endpoint. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpointConfig.html">CreateEndpointConfig</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getEndpointConfigName() {
        return software.amazon.jsii.Kernel.get(this, "endpointConfigName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html">AWS::SageMaker::EndpointConfig</a> resource that specifies the configuration for the endpoint. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpointConfig.html">CreateEndpointConfig</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEndpointConfigName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "endpointConfigName", java.util.Objects.requireNonNull(value, "endpointConfigName is required"));
    }

    /**
     * The deployment configuration for an endpoint, which contains the desired deployment strategy and rollback configurations.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDeploymentConfig() {
        return software.amazon.jsii.Kernel.get(this, "deploymentConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The deployment configuration for an endpoint, which contains the desired deployment strategy and rollback configurations.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeploymentConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "deploymentConfig", value);
    }

    /**
     * The deployment configuration for an endpoint, which contains the desired deployment strategy and rollback configurations.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeploymentConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sagemaker.CfnEndpoint.DeploymentConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "deploymentConfig", value);
    }

    /**
     * The name of the endpoint.The name must be unique within an AWS Region in your AWS account. The name is case-insensitive in <code>CreateEndpoint</code> , but the case is preserved and must be matched in <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_runtime_InvokeEndpoint.html"></a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEndpointName() {
        return software.amazon.jsii.Kernel.get(this, "endpointName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the endpoint.The name must be unique within an AWS Region in your AWS account. The name is case-insensitive in <code>CreateEndpoint</code> , but the case is preserved and must be matched in <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_runtime_InvokeEndpoint.html"></a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEndpointName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "endpointName", value);
    }

    /**
     * When you are updating endpoint resources with <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/API_UpdateEndpoint.html#SageMaker-UpdateEndpoint-request-RetainAllVariantProperties">RetainAllVariantProperties</a> whose value is set to <code>true</code> , <code>ExcludeRetainedVariantProperties</code> specifies the list of type <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-variantproperty.html">VariantProperty</a> to override with the values provided by <code>EndpointConfig</code> . If you don't specify a value for <code>ExcludeAllVariantProperties</code> , no variant properties are overridden. Don't use this property when creating new endpoint resources or when <code>RetainAllVariantProperties</code> is set to <code>false</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getExcludeRetainedVariantProperties() {
        return software.amazon.jsii.Kernel.get(this, "excludeRetainedVariantProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * When you are updating endpoint resources with <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/API_UpdateEndpoint.html#SageMaker-UpdateEndpoint-request-RetainAllVariantProperties">RetainAllVariantProperties</a> whose value is set to <code>true</code> , <code>ExcludeRetainedVariantProperties</code> specifies the list of type <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-variantproperty.html">VariantProperty</a> to override with the values provided by <code>EndpointConfig</code> . If you don't specify a value for <code>ExcludeAllVariantProperties</code> , no variant properties are overridden. Don't use this property when creating new endpoint resources or when <code>RetainAllVariantProperties</code> is set to <code>false</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExcludeRetainedVariantProperties(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "excludeRetainedVariantProperties", value);
    }

    /**
     * When you are updating endpoint resources with <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/API_UpdateEndpoint.html#SageMaker-UpdateEndpoint-request-RetainAllVariantProperties">RetainAllVariantProperties</a> whose value is set to <code>true</code> , <code>ExcludeRetainedVariantProperties</code> specifies the list of type <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-variantproperty.html">VariantProperty</a> to override with the values provided by <code>EndpointConfig</code> . If you don't specify a value for <code>ExcludeAllVariantProperties</code> , no variant properties are overridden. Don't use this property when creating new endpoint resources or when <code>RetainAllVariantProperties</code> is set to <code>false</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExcludeRetainedVariantProperties(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.sagemaker.CfnEndpoint.VariantPropertyProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.sagemaker.CfnEndpoint.VariantPropertyProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "excludeRetainedVariantProperties", value);
    }

    /**
     * When updating endpoint resources, enables or disables the retention of variant properties, such as the instance count or the variant weight.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRetainAllVariantProperties() {
        return software.amazon.jsii.Kernel.get(this, "retainAllVariantProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * When updating endpoint resources, enables or disables the retention of variant properties, such as the instance count or the variant weight.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRetainAllVariantProperties(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "retainAllVariantProperties", value);
    }

    /**
     * When updating endpoint resources, enables or disables the retention of variant properties, such as the instance count or the variant weight.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRetainAllVariantProperties(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "retainAllVariantProperties", value);
    }

    /**
     * Specifies whether to reuse the last deployment configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRetainDeploymentConfig() {
        return software.amazon.jsii.Kernel.get(this, "retainDeploymentConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether to reuse the last deployment configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRetainDeploymentConfig(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "retainDeploymentConfig", value);
    }

    /**
     * Specifies whether to reuse the last deployment configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRetainDeploymentConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "retainDeploymentConfig", value);
    }

    /**
     * A list of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * An Amazon CloudWatch alarm configured to monitor metrics on an endpoint.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * AlarmProperty alarmProperty = AlarmProperty.builder()
     *         .alarmName("alarmName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-alarm.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-alarm.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnEndpoint.AlarmProperty")
    @software.amazon.jsii.Jsii.Proxy(AlarmProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AlarmProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of a CloudWatch alarm in your account.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-alarm.html#cfn-sagemaker-endpoint-alarm-alarmname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-alarm.html#cfn-sagemaker-endpoint-alarm-alarmname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAlarmName();

        /**
         * @return a {@link Builder} of {@link AlarmProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AlarmProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AlarmProperty> {
            java.lang.String alarmName;

            /**
             * Sets the value of {@link AlarmProperty#getAlarmName}
             * @param alarmName The name of a CloudWatch alarm in your account. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder alarmName(java.lang.String alarmName) {
                this.alarmName = alarmName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AlarmProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AlarmProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AlarmProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AlarmProperty {
            private final java.lang.String alarmName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.alarmName = software.amazon.jsii.Kernel.get(this, "alarmName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.alarmName = java.util.Objects.requireNonNull(builder.alarmName, "alarmName is required");
            }

            @Override
            public final java.lang.String getAlarmName() {
                return this.alarmName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("alarmName", om.valueToTree(this.getAlarmName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnEndpoint.AlarmProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AlarmProperty.Jsii$Proxy that = (AlarmProperty.Jsii$Proxy) o;

                return this.alarmName.equals(that.alarmName);
            }

            @Override
            public final int hashCode() {
                int result = this.alarmName.hashCode();
                return result;
            }
        }
    }
    /**
     * Automatic rollback configuration for handling endpoint deployment failures and recovery.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * AutoRollbackConfigProperty autoRollbackConfigProperty = AutoRollbackConfigProperty.builder()
     *         .alarms(List.of(AlarmProperty.builder()
     *                 .alarmName("alarmName")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-autorollbackconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-autorollbackconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnEndpoint.AutoRollbackConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(AutoRollbackConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AutoRollbackConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * List of CloudWatch alarms in your account that are configured to monitor metrics on an endpoint.
         * <p>
         * If any alarms are tripped during a deployment, SageMaker rolls back the deployment.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-autorollbackconfig.html#cfn-sagemaker-endpoint-autorollbackconfig-alarms">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-autorollbackconfig.html#cfn-sagemaker-endpoint-autorollbackconfig-alarms</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getAlarms();

        /**
         * @return a {@link Builder} of {@link AutoRollbackConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AutoRollbackConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AutoRollbackConfigProperty> {
            java.lang.Object alarms;

            /**
             * Sets the value of {@link AutoRollbackConfigProperty#getAlarms}
             * @param alarms List of CloudWatch alarms in your account that are configured to monitor metrics on an endpoint. This parameter is required.
             *               If any alarms are tripped during a deployment, SageMaker rolls back the deployment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder alarms(software.amazon.awscdk.IResolvable alarms) {
                this.alarms = alarms;
                return this;
            }

            /**
             * Sets the value of {@link AutoRollbackConfigProperty#getAlarms}
             * @param alarms List of CloudWatch alarms in your account that are configured to monitor metrics on an endpoint. This parameter is required.
             *               If any alarms are tripped during a deployment, SageMaker rolls back the deployment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder alarms(java.util.List<? extends java.lang.Object> alarms) {
                this.alarms = alarms;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AutoRollbackConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AutoRollbackConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AutoRollbackConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AutoRollbackConfigProperty {
            private final java.lang.Object alarms;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.alarms = software.amazon.jsii.Kernel.get(this, "alarms", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.alarms = java.util.Objects.requireNonNull(builder.alarms, "alarms is required");
            }

            @Override
            public final java.lang.Object getAlarms() {
                return this.alarms;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("alarms", om.valueToTree(this.getAlarms()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnEndpoint.AutoRollbackConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AutoRollbackConfigProperty.Jsii$Proxy that = (AutoRollbackConfigProperty.Jsii$Proxy) o;

                return this.alarms.equals(that.alarms);
            }

            @Override
            public final int hashCode() {
                int result = this.alarms.hashCode();
                return result;
            }
        }
    }
    /**
     * Update policy for a blue/green deployment.
     * <p>
     * If this update policy is specified, SageMaker creates a new fleet during the deployment while maintaining the old fleet. SageMaker flips traffic to the new fleet according to the specified traffic routing configuration. Only one update policy should be used in the deployment configuration. If no update policy is specified, SageMaker uses a blue/green deployment strategy with all at once traffic shifting by default.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * BlueGreenUpdatePolicyProperty blueGreenUpdatePolicyProperty = BlueGreenUpdatePolicyProperty.builder()
     *         .trafficRoutingConfiguration(TrafficRoutingConfigProperty.builder()
     *                 .type("type")
     *                 // the properties below are optional
     *                 .canarySize(CapacitySizeProperty.builder()
     *                         .type("type")
     *                         .value(123)
     *                         .build())
     *                 .linearStepSize(CapacitySizeProperty.builder()
     *                         .type("type")
     *                         .value(123)
     *                         .build())
     *                 .waitIntervalInSeconds(123)
     *                 .build())
     *         // the properties below are optional
     *         .maximumExecutionTimeoutInSeconds(123)
     *         .terminationWaitInSeconds(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-bluegreenupdatepolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-bluegreenupdatepolicy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnEndpoint.BlueGreenUpdatePolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(BlueGreenUpdatePolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BlueGreenUpdatePolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Defines the traffic routing strategy to shift traffic from the old fleet to the new fleet during an endpoint deployment.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-bluegreenupdatepolicy.html#cfn-sagemaker-endpoint-bluegreenupdatepolicy-trafficroutingconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-bluegreenupdatepolicy.html#cfn-sagemaker-endpoint-bluegreenupdatepolicy-trafficroutingconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getTrafficRoutingConfiguration();

        /**
         * Maximum execution timeout for the deployment.
         * <p>
         * Note that the timeout value should be larger than the total waiting time specified in <code>TerminationWaitInSeconds</code> and <code>WaitIntervalInSeconds</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-bluegreenupdatepolicy.html#cfn-sagemaker-endpoint-bluegreenupdatepolicy-maximumexecutiontimeoutinseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-bluegreenupdatepolicy.html#cfn-sagemaker-endpoint-bluegreenupdatepolicy-maximumexecutiontimeoutinseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumExecutionTimeoutInSeconds() {
            return null;
        }

        /**
         * Additional waiting time in seconds after the completion of an endpoint deployment before terminating the old endpoint fleet.
         * <p>
         * Default is 0.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-bluegreenupdatepolicy.html#cfn-sagemaker-endpoint-bluegreenupdatepolicy-terminationwaitinseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-bluegreenupdatepolicy.html#cfn-sagemaker-endpoint-bluegreenupdatepolicy-terminationwaitinseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTerminationWaitInSeconds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BlueGreenUpdatePolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BlueGreenUpdatePolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BlueGreenUpdatePolicyProperty> {
            java.lang.Object trafficRoutingConfiguration;
            java.lang.Number maximumExecutionTimeoutInSeconds;
            java.lang.Number terminationWaitInSeconds;

            /**
             * Sets the value of {@link BlueGreenUpdatePolicyProperty#getTrafficRoutingConfiguration}
             * @param trafficRoutingConfiguration Defines the traffic routing strategy to shift traffic from the old fleet to the new fleet during an endpoint deployment. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder trafficRoutingConfiguration(software.amazon.awscdk.IResolvable trafficRoutingConfiguration) {
                this.trafficRoutingConfiguration = trafficRoutingConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link BlueGreenUpdatePolicyProperty#getTrafficRoutingConfiguration}
             * @param trafficRoutingConfiguration Defines the traffic routing strategy to shift traffic from the old fleet to the new fleet during an endpoint deployment. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder trafficRoutingConfiguration(software.amazon.awscdk.services.sagemaker.CfnEndpoint.TrafficRoutingConfigProperty trafficRoutingConfiguration) {
                this.trafficRoutingConfiguration = trafficRoutingConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link BlueGreenUpdatePolicyProperty#getMaximumExecutionTimeoutInSeconds}
             * @param maximumExecutionTimeoutInSeconds Maximum execution timeout for the deployment.
             *                                         Note that the timeout value should be larger than the total waiting time specified in <code>TerminationWaitInSeconds</code> and <code>WaitIntervalInSeconds</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumExecutionTimeoutInSeconds(java.lang.Number maximumExecutionTimeoutInSeconds) {
                this.maximumExecutionTimeoutInSeconds = maximumExecutionTimeoutInSeconds;
                return this;
            }

            /**
             * Sets the value of {@link BlueGreenUpdatePolicyProperty#getTerminationWaitInSeconds}
             * @param terminationWaitInSeconds Additional waiting time in seconds after the completion of an endpoint deployment before terminating the old endpoint fleet.
             *                                 Default is 0.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder terminationWaitInSeconds(java.lang.Number terminationWaitInSeconds) {
                this.terminationWaitInSeconds = terminationWaitInSeconds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BlueGreenUpdatePolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BlueGreenUpdatePolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BlueGreenUpdatePolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BlueGreenUpdatePolicyProperty {
            private final java.lang.Object trafficRoutingConfiguration;
            private final java.lang.Number maximumExecutionTimeoutInSeconds;
            private final java.lang.Number terminationWaitInSeconds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.trafficRoutingConfiguration = software.amazon.jsii.Kernel.get(this, "trafficRoutingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.maximumExecutionTimeoutInSeconds = software.amazon.jsii.Kernel.get(this, "maximumExecutionTimeoutInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.terminationWaitInSeconds = software.amazon.jsii.Kernel.get(this, "terminationWaitInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.trafficRoutingConfiguration = java.util.Objects.requireNonNull(builder.trafficRoutingConfiguration, "trafficRoutingConfiguration is required");
                this.maximumExecutionTimeoutInSeconds = builder.maximumExecutionTimeoutInSeconds;
                this.terminationWaitInSeconds = builder.terminationWaitInSeconds;
            }

            @Override
            public final java.lang.Object getTrafficRoutingConfiguration() {
                return this.trafficRoutingConfiguration;
            }

            @Override
            public final java.lang.Number getMaximumExecutionTimeoutInSeconds() {
                return this.maximumExecutionTimeoutInSeconds;
            }

            @Override
            public final java.lang.Number getTerminationWaitInSeconds() {
                return this.terminationWaitInSeconds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("trafficRoutingConfiguration", om.valueToTree(this.getTrafficRoutingConfiguration()));
                if (this.getMaximumExecutionTimeoutInSeconds() != null) {
                    data.set("maximumExecutionTimeoutInSeconds", om.valueToTree(this.getMaximumExecutionTimeoutInSeconds()));
                }
                if (this.getTerminationWaitInSeconds() != null) {
                    data.set("terminationWaitInSeconds", om.valueToTree(this.getTerminationWaitInSeconds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnEndpoint.BlueGreenUpdatePolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BlueGreenUpdatePolicyProperty.Jsii$Proxy that = (BlueGreenUpdatePolicyProperty.Jsii$Proxy) o;

                if (!trafficRoutingConfiguration.equals(that.trafficRoutingConfiguration)) return false;
                if (this.maximumExecutionTimeoutInSeconds != null ? !this.maximumExecutionTimeoutInSeconds.equals(that.maximumExecutionTimeoutInSeconds) : that.maximumExecutionTimeoutInSeconds != null) return false;
                return this.terminationWaitInSeconds != null ? this.terminationWaitInSeconds.equals(that.terminationWaitInSeconds) : that.terminationWaitInSeconds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.trafficRoutingConfiguration.hashCode();
                result = 31 * result + (this.maximumExecutionTimeoutInSeconds != null ? this.maximumExecutionTimeoutInSeconds.hashCode() : 0);
                result = 31 * result + (this.terminationWaitInSeconds != null ? this.terminationWaitInSeconds.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the type and size of the endpoint capacity to activate for a blue/green deployment, a rolling deployment, or a rollback strategy.
     * <p>
     * You can specify your batches as either instance count or the overall percentage or your fleet.
     * <p>
     * For a rollback strategy, if you don't specify the fields in this object, or if you set the <code>Value</code> to 100%, then SageMaker uses a blue/green rollback strategy and rolls all traffic back to the blue fleet.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * CapacitySizeProperty capacitySizeProperty = CapacitySizeProperty.builder()
     *         .type("type")
     *         .value(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-capacitysize.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-capacitysize.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnEndpoint.CapacitySizeProperty")
    @software.amazon.jsii.Jsii.Proxy(CapacitySizeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CapacitySizeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the endpoint capacity type.
         * <p>
         * <ul>
         * <li><code>INSTANCE_COUNT</code> : The endpoint activates based on the number of instances.</li>
         * <li><code>CAPACITY_PERCENT</code> : The endpoint activates based on the specified percentage of capacity.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-capacitysize.html#cfn-sagemaker-endpoint-capacitysize-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-capacitysize.html#cfn-sagemaker-endpoint-capacitysize-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * Defines the capacity size, either as a number of instances or a capacity percentage.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-capacitysize.html#cfn-sagemaker-endpoint-capacitysize-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-capacitysize.html#cfn-sagemaker-endpoint-capacitysize-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getValue();

        /**
         * @return a {@link Builder} of {@link CapacitySizeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CapacitySizeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CapacitySizeProperty> {
            java.lang.String type;
            java.lang.Number value;

            /**
             * Sets the value of {@link CapacitySizeProperty#getType}
             * @param type Specifies the endpoint capacity type. This parameter is required.
             *             <ul>
             *             <li><code>INSTANCE_COUNT</code> : The endpoint activates based on the number of instances.</li>
             *             <li><code>CAPACITY_PERCENT</code> : The endpoint activates based on the specified percentage of capacity.</li>
             *             </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link CapacitySizeProperty#getValue}
             * @param value Defines the capacity size, either as a number of instances or a capacity percentage. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.Number value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CapacitySizeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CapacitySizeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CapacitySizeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CapacitySizeProperty {
            private final java.lang.String type;
            private final java.lang.Number value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.Number getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnEndpoint.CapacitySizeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CapacitySizeProperty.Jsii$Proxy that = (CapacitySizeProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * The deployment configuration for an endpoint, which contains the desired deployment strategy and rollback configurations.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * DeploymentConfigProperty deploymentConfigProperty = DeploymentConfigProperty.builder()
     *         .autoRollbackConfiguration(AutoRollbackConfigProperty.builder()
     *                 .alarms(List.of(AlarmProperty.builder()
     *                         .alarmName("alarmName")
     *                         .build()))
     *                 .build())
     *         .blueGreenUpdatePolicy(BlueGreenUpdatePolicyProperty.builder()
     *                 .trafficRoutingConfiguration(TrafficRoutingConfigProperty.builder()
     *                         .type("type")
     *                         // the properties below are optional
     *                         .canarySize(CapacitySizeProperty.builder()
     *                                 .type("type")
     *                                 .value(123)
     *                                 .build())
     *                         .linearStepSize(CapacitySizeProperty.builder()
     *                                 .type("type")
     *                                 .value(123)
     *                                 .build())
     *                         .waitIntervalInSeconds(123)
     *                         .build())
     *                 // the properties below are optional
     *                 .maximumExecutionTimeoutInSeconds(123)
     *                 .terminationWaitInSeconds(123)
     *                 .build())
     *         .rollingUpdatePolicy(RollingUpdatePolicyProperty.builder()
     *                 .maximumBatchSize(CapacitySizeProperty.builder()
     *                         .type("type")
     *                         .value(123)
     *                         .build())
     *                 .waitIntervalInSeconds(123)
     *                 // the properties below are optional
     *                 .maximumExecutionTimeoutInSeconds(123)
     *                 .rollbackMaximumBatchSize(CapacitySizeProperty.builder()
     *                         .type("type")
     *                         .value(123)
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-deploymentconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-deploymentconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnEndpoint.DeploymentConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(DeploymentConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DeploymentConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Automatic rollback configuration for handling endpoint deployment failures and recovery.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-deploymentconfig.html#cfn-sagemaker-endpoint-deploymentconfig-autorollbackconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-deploymentconfig.html#cfn-sagemaker-endpoint-deploymentconfig-autorollbackconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAutoRollbackConfiguration() {
            return null;
        }

        /**
         * Update policy for a blue/green deployment.
         * <p>
         * If this update policy is specified, SageMaker creates a new fleet during the deployment while maintaining the old fleet. SageMaker flips traffic to the new fleet according to the specified traffic routing configuration. Only one update policy should be used in the deployment configuration. If no update policy is specified, SageMaker uses a blue/green deployment strategy with all at once traffic shifting by default.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-deploymentconfig.html#cfn-sagemaker-endpoint-deploymentconfig-bluegreenupdatepolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-deploymentconfig.html#cfn-sagemaker-endpoint-deploymentconfig-bluegreenupdatepolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBlueGreenUpdatePolicy() {
            return null;
        }

        /**
         * Specifies a rolling deployment strategy for updating a SageMaker endpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-deploymentconfig.html#cfn-sagemaker-endpoint-deploymentconfig-rollingupdatepolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-deploymentconfig.html#cfn-sagemaker-endpoint-deploymentconfig-rollingupdatepolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRollingUpdatePolicy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DeploymentConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DeploymentConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DeploymentConfigProperty> {
            java.lang.Object autoRollbackConfiguration;
            java.lang.Object blueGreenUpdatePolicy;
            java.lang.Object rollingUpdatePolicy;

            /**
             * Sets the value of {@link DeploymentConfigProperty#getAutoRollbackConfiguration}
             * @param autoRollbackConfiguration Automatic rollback configuration for handling endpoint deployment failures and recovery.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoRollbackConfiguration(software.amazon.awscdk.IResolvable autoRollbackConfiguration) {
                this.autoRollbackConfiguration = autoRollbackConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentConfigProperty#getAutoRollbackConfiguration}
             * @param autoRollbackConfiguration Automatic rollback configuration for handling endpoint deployment failures and recovery.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoRollbackConfiguration(software.amazon.awscdk.services.sagemaker.CfnEndpoint.AutoRollbackConfigProperty autoRollbackConfiguration) {
                this.autoRollbackConfiguration = autoRollbackConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentConfigProperty#getBlueGreenUpdatePolicy}
             * @param blueGreenUpdatePolicy Update policy for a blue/green deployment.
             *                              If this update policy is specified, SageMaker creates a new fleet during the deployment while maintaining the old fleet. SageMaker flips traffic to the new fleet according to the specified traffic routing configuration. Only one update policy should be used in the deployment configuration. If no update policy is specified, SageMaker uses a blue/green deployment strategy with all at once traffic shifting by default.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blueGreenUpdatePolicy(software.amazon.awscdk.IResolvable blueGreenUpdatePolicy) {
                this.blueGreenUpdatePolicy = blueGreenUpdatePolicy;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentConfigProperty#getBlueGreenUpdatePolicy}
             * @param blueGreenUpdatePolicy Update policy for a blue/green deployment.
             *                              If this update policy is specified, SageMaker creates a new fleet during the deployment while maintaining the old fleet. SageMaker flips traffic to the new fleet according to the specified traffic routing configuration. Only one update policy should be used in the deployment configuration. If no update policy is specified, SageMaker uses a blue/green deployment strategy with all at once traffic shifting by default.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blueGreenUpdatePolicy(software.amazon.awscdk.services.sagemaker.CfnEndpoint.BlueGreenUpdatePolicyProperty blueGreenUpdatePolicy) {
                this.blueGreenUpdatePolicy = blueGreenUpdatePolicy;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentConfigProperty#getRollingUpdatePolicy}
             * @param rollingUpdatePolicy Specifies a rolling deployment strategy for updating a SageMaker endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rollingUpdatePolicy(software.amazon.awscdk.IResolvable rollingUpdatePolicy) {
                this.rollingUpdatePolicy = rollingUpdatePolicy;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentConfigProperty#getRollingUpdatePolicy}
             * @param rollingUpdatePolicy Specifies a rolling deployment strategy for updating a SageMaker endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rollingUpdatePolicy(software.amazon.awscdk.services.sagemaker.CfnEndpoint.RollingUpdatePolicyProperty rollingUpdatePolicy) {
                this.rollingUpdatePolicy = rollingUpdatePolicy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeploymentConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DeploymentConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DeploymentConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeploymentConfigProperty {
            private final java.lang.Object autoRollbackConfiguration;
            private final java.lang.Object blueGreenUpdatePolicy;
            private final java.lang.Object rollingUpdatePolicy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.autoRollbackConfiguration = software.amazon.jsii.Kernel.get(this, "autoRollbackConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.blueGreenUpdatePolicy = software.amazon.jsii.Kernel.get(this, "blueGreenUpdatePolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rollingUpdatePolicy = software.amazon.jsii.Kernel.get(this, "rollingUpdatePolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.autoRollbackConfiguration = builder.autoRollbackConfiguration;
                this.blueGreenUpdatePolicy = builder.blueGreenUpdatePolicy;
                this.rollingUpdatePolicy = builder.rollingUpdatePolicy;
            }

            @Override
            public final java.lang.Object getAutoRollbackConfiguration() {
                return this.autoRollbackConfiguration;
            }

            @Override
            public final java.lang.Object getBlueGreenUpdatePolicy() {
                return this.blueGreenUpdatePolicy;
            }

            @Override
            public final java.lang.Object getRollingUpdatePolicy() {
                return this.rollingUpdatePolicy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAutoRollbackConfiguration() != null) {
                    data.set("autoRollbackConfiguration", om.valueToTree(this.getAutoRollbackConfiguration()));
                }
                if (this.getBlueGreenUpdatePolicy() != null) {
                    data.set("blueGreenUpdatePolicy", om.valueToTree(this.getBlueGreenUpdatePolicy()));
                }
                if (this.getRollingUpdatePolicy() != null) {
                    data.set("rollingUpdatePolicy", om.valueToTree(this.getRollingUpdatePolicy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnEndpoint.DeploymentConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DeploymentConfigProperty.Jsii$Proxy that = (DeploymentConfigProperty.Jsii$Proxy) o;

                if (this.autoRollbackConfiguration != null ? !this.autoRollbackConfiguration.equals(that.autoRollbackConfiguration) : that.autoRollbackConfiguration != null) return false;
                if (this.blueGreenUpdatePolicy != null ? !this.blueGreenUpdatePolicy.equals(that.blueGreenUpdatePolicy) : that.blueGreenUpdatePolicy != null) return false;
                return this.rollingUpdatePolicy != null ? this.rollingUpdatePolicy.equals(that.rollingUpdatePolicy) : that.rollingUpdatePolicy == null;
            }

            @Override
            public final int hashCode() {
                int result = this.autoRollbackConfiguration != null ? this.autoRollbackConfiguration.hashCode() : 0;
                result = 31 * result + (this.blueGreenUpdatePolicy != null ? this.blueGreenUpdatePolicy.hashCode() : 0);
                result = 31 * result + (this.rollingUpdatePolicy != null ? this.rollingUpdatePolicy.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies a rolling deployment strategy for updating a SageMaker endpoint.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * RollingUpdatePolicyProperty rollingUpdatePolicyProperty = RollingUpdatePolicyProperty.builder()
     *         .maximumBatchSize(CapacitySizeProperty.builder()
     *                 .type("type")
     *                 .value(123)
     *                 .build())
     *         .waitIntervalInSeconds(123)
     *         // the properties below are optional
     *         .maximumExecutionTimeoutInSeconds(123)
     *         .rollbackMaximumBatchSize(CapacitySizeProperty.builder()
     *                 .type("type")
     *                 .value(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-rollingupdatepolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-rollingupdatepolicy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnEndpoint.RollingUpdatePolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(RollingUpdatePolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RollingUpdatePolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Batch size for each rolling step to provision capacity and turn on traffic on the new endpoint fleet, and terminate capacity on the old endpoint fleet.
         * <p>
         * Value must be between 5% to 50% of the variant's total instance count.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-rollingupdatepolicy.html#cfn-sagemaker-endpoint-rollingupdatepolicy-maximumbatchsize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-rollingupdatepolicy.html#cfn-sagemaker-endpoint-rollingupdatepolicy-maximumbatchsize</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getMaximumBatchSize();

        /**
         * The length of the baking period, during which SageMaker monitors alarms for each batch on the new fleet.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-rollingupdatepolicy.html#cfn-sagemaker-endpoint-rollingupdatepolicy-waitintervalinseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-rollingupdatepolicy.html#cfn-sagemaker-endpoint-rollingupdatepolicy-waitintervalinseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getWaitIntervalInSeconds();

        /**
         * The time limit for the total deployment.
         * <p>
         * Exceeding this limit causes a timeout.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-rollingupdatepolicy.html#cfn-sagemaker-endpoint-rollingupdatepolicy-maximumexecutiontimeoutinseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-rollingupdatepolicy.html#cfn-sagemaker-endpoint-rollingupdatepolicy-maximumexecutiontimeoutinseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumExecutionTimeoutInSeconds() {
            return null;
        }

        /**
         * Batch size for rollback to the old endpoint fleet.
         * <p>
         * Each rolling step to provision capacity and turn on traffic on the old endpoint fleet, and terminate capacity on the new endpoint fleet. If this field is absent, the default value will be set to 100% of total capacity which means to bring up the whole capacity of the old fleet at once during rollback.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-rollingupdatepolicy.html#cfn-sagemaker-endpoint-rollingupdatepolicy-rollbackmaximumbatchsize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-rollingupdatepolicy.html#cfn-sagemaker-endpoint-rollingupdatepolicy-rollbackmaximumbatchsize</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRollbackMaximumBatchSize() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RollingUpdatePolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RollingUpdatePolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RollingUpdatePolicyProperty> {
            java.lang.Object maximumBatchSize;
            java.lang.Number waitIntervalInSeconds;
            java.lang.Number maximumExecutionTimeoutInSeconds;
            java.lang.Object rollbackMaximumBatchSize;

            /**
             * Sets the value of {@link RollingUpdatePolicyProperty#getMaximumBatchSize}
             * @param maximumBatchSize Batch size for each rolling step to provision capacity and turn on traffic on the new endpoint fleet, and terminate capacity on the old endpoint fleet. This parameter is required.
             *                         Value must be between 5% to 50% of the variant's total instance count.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumBatchSize(software.amazon.awscdk.IResolvable maximumBatchSize) {
                this.maximumBatchSize = maximumBatchSize;
                return this;
            }

            /**
             * Sets the value of {@link RollingUpdatePolicyProperty#getMaximumBatchSize}
             * @param maximumBatchSize Batch size for each rolling step to provision capacity and turn on traffic on the new endpoint fleet, and terminate capacity on the old endpoint fleet. This parameter is required.
             *                         Value must be between 5% to 50% of the variant's total instance count.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumBatchSize(software.amazon.awscdk.services.sagemaker.CfnEndpoint.CapacitySizeProperty maximumBatchSize) {
                this.maximumBatchSize = maximumBatchSize;
                return this;
            }

            /**
             * Sets the value of {@link RollingUpdatePolicyProperty#getWaitIntervalInSeconds}
             * @param waitIntervalInSeconds The length of the baking period, during which SageMaker monitors alarms for each batch on the new fleet. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder waitIntervalInSeconds(java.lang.Number waitIntervalInSeconds) {
                this.waitIntervalInSeconds = waitIntervalInSeconds;
                return this;
            }

            /**
             * Sets the value of {@link RollingUpdatePolicyProperty#getMaximumExecutionTimeoutInSeconds}
             * @param maximumExecutionTimeoutInSeconds The time limit for the total deployment.
             *                                         Exceeding this limit causes a timeout.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumExecutionTimeoutInSeconds(java.lang.Number maximumExecutionTimeoutInSeconds) {
                this.maximumExecutionTimeoutInSeconds = maximumExecutionTimeoutInSeconds;
                return this;
            }

            /**
             * Sets the value of {@link RollingUpdatePolicyProperty#getRollbackMaximumBatchSize}
             * @param rollbackMaximumBatchSize Batch size for rollback to the old endpoint fleet.
             *                                 Each rolling step to provision capacity and turn on traffic on the old endpoint fleet, and terminate capacity on the new endpoint fleet. If this field is absent, the default value will be set to 100% of total capacity which means to bring up the whole capacity of the old fleet at once during rollback.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rollbackMaximumBatchSize(software.amazon.awscdk.IResolvable rollbackMaximumBatchSize) {
                this.rollbackMaximumBatchSize = rollbackMaximumBatchSize;
                return this;
            }

            /**
             * Sets the value of {@link RollingUpdatePolicyProperty#getRollbackMaximumBatchSize}
             * @param rollbackMaximumBatchSize Batch size for rollback to the old endpoint fleet.
             *                                 Each rolling step to provision capacity and turn on traffic on the old endpoint fleet, and terminate capacity on the new endpoint fleet. If this field is absent, the default value will be set to 100% of total capacity which means to bring up the whole capacity of the old fleet at once during rollback.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rollbackMaximumBatchSize(software.amazon.awscdk.services.sagemaker.CfnEndpoint.CapacitySizeProperty rollbackMaximumBatchSize) {
                this.rollbackMaximumBatchSize = rollbackMaximumBatchSize;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RollingUpdatePolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RollingUpdatePolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RollingUpdatePolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RollingUpdatePolicyProperty {
            private final java.lang.Object maximumBatchSize;
            private final java.lang.Number waitIntervalInSeconds;
            private final java.lang.Number maximumExecutionTimeoutInSeconds;
            private final java.lang.Object rollbackMaximumBatchSize;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maximumBatchSize = software.amazon.jsii.Kernel.get(this, "maximumBatchSize", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.waitIntervalInSeconds = software.amazon.jsii.Kernel.get(this, "waitIntervalInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maximumExecutionTimeoutInSeconds = software.amazon.jsii.Kernel.get(this, "maximumExecutionTimeoutInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.rollbackMaximumBatchSize = software.amazon.jsii.Kernel.get(this, "rollbackMaximumBatchSize", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maximumBatchSize = java.util.Objects.requireNonNull(builder.maximumBatchSize, "maximumBatchSize is required");
                this.waitIntervalInSeconds = java.util.Objects.requireNonNull(builder.waitIntervalInSeconds, "waitIntervalInSeconds is required");
                this.maximumExecutionTimeoutInSeconds = builder.maximumExecutionTimeoutInSeconds;
                this.rollbackMaximumBatchSize = builder.rollbackMaximumBatchSize;
            }

            @Override
            public final java.lang.Object getMaximumBatchSize() {
                return this.maximumBatchSize;
            }

            @Override
            public final java.lang.Number getWaitIntervalInSeconds() {
                return this.waitIntervalInSeconds;
            }

            @Override
            public final java.lang.Number getMaximumExecutionTimeoutInSeconds() {
                return this.maximumExecutionTimeoutInSeconds;
            }

            @Override
            public final java.lang.Object getRollbackMaximumBatchSize() {
                return this.rollbackMaximumBatchSize;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("maximumBatchSize", om.valueToTree(this.getMaximumBatchSize()));
                data.set("waitIntervalInSeconds", om.valueToTree(this.getWaitIntervalInSeconds()));
                if (this.getMaximumExecutionTimeoutInSeconds() != null) {
                    data.set("maximumExecutionTimeoutInSeconds", om.valueToTree(this.getMaximumExecutionTimeoutInSeconds()));
                }
                if (this.getRollbackMaximumBatchSize() != null) {
                    data.set("rollbackMaximumBatchSize", om.valueToTree(this.getRollbackMaximumBatchSize()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnEndpoint.RollingUpdatePolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RollingUpdatePolicyProperty.Jsii$Proxy that = (RollingUpdatePolicyProperty.Jsii$Proxy) o;

                if (!maximumBatchSize.equals(that.maximumBatchSize)) return false;
                if (!waitIntervalInSeconds.equals(that.waitIntervalInSeconds)) return false;
                if (this.maximumExecutionTimeoutInSeconds != null ? !this.maximumExecutionTimeoutInSeconds.equals(that.maximumExecutionTimeoutInSeconds) : that.maximumExecutionTimeoutInSeconds != null) return false;
                return this.rollbackMaximumBatchSize != null ? this.rollbackMaximumBatchSize.equals(that.rollbackMaximumBatchSize) : that.rollbackMaximumBatchSize == null;
            }

            @Override
            public final int hashCode() {
                int result = this.maximumBatchSize.hashCode();
                result = 31 * result + (this.waitIntervalInSeconds.hashCode());
                result = 31 * result + (this.maximumExecutionTimeoutInSeconds != null ? this.maximumExecutionTimeoutInSeconds.hashCode() : 0);
                result = 31 * result + (this.rollbackMaximumBatchSize != null ? this.rollbackMaximumBatchSize.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Defines the traffic routing strategy during an endpoint deployment to shift traffic from the old fleet to the new fleet.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * TrafficRoutingConfigProperty trafficRoutingConfigProperty = TrafficRoutingConfigProperty.builder()
     *         .type("type")
     *         // the properties below are optional
     *         .canarySize(CapacitySizeProperty.builder()
     *                 .type("type")
     *                 .value(123)
     *                 .build())
     *         .linearStepSize(CapacitySizeProperty.builder()
     *                 .type("type")
     *                 .value(123)
     *                 .build())
     *         .waitIntervalInSeconds(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-trafficroutingconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-trafficroutingconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnEndpoint.TrafficRoutingConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(TrafficRoutingConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TrafficRoutingConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Traffic routing strategy type.
         * <p>
         * <ul>
         * <li><code>ALL_AT_ONCE</code> : Endpoint traffic shifts to the new fleet in a single step.</li>
         * <li><code>CANARY</code> : Endpoint traffic shifts to the new fleet in two steps. The first step is the canary, which is a small portion of the traffic. The second step is the remainder of the traffic.</li>
         * <li><code>LINEAR</code> : Endpoint traffic shifts to the new fleet in n steps of a configurable size.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-trafficroutingconfig.html#cfn-sagemaker-endpoint-trafficroutingconfig-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-trafficroutingconfig.html#cfn-sagemaker-endpoint-trafficroutingconfig-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * Batch size for the first step to turn on traffic on the new endpoint fleet.
         * <p>
         * <code>Value</code> must be less than or equal to 50% of the variant's total instance count.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-trafficroutingconfig.html#cfn-sagemaker-endpoint-trafficroutingconfig-canarysize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-trafficroutingconfig.html#cfn-sagemaker-endpoint-trafficroutingconfig-canarysize</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCanarySize() {
            return null;
        }

        /**
         * Batch size for each step to turn on traffic on the new endpoint fleet.
         * <p>
         * <code>Value</code> must be 10-50% of the variant's total instance count.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-trafficroutingconfig.html#cfn-sagemaker-endpoint-trafficroutingconfig-linearstepsize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-trafficroutingconfig.html#cfn-sagemaker-endpoint-trafficroutingconfig-linearstepsize</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLinearStepSize() {
            return null;
        }

        /**
         * The waiting time (in seconds) between incremental steps to turn on traffic on the new endpoint fleet.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-trafficroutingconfig.html#cfn-sagemaker-endpoint-trafficroutingconfig-waitintervalinseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-trafficroutingconfig.html#cfn-sagemaker-endpoint-trafficroutingconfig-waitintervalinseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getWaitIntervalInSeconds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TrafficRoutingConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TrafficRoutingConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TrafficRoutingConfigProperty> {
            java.lang.String type;
            java.lang.Object canarySize;
            java.lang.Object linearStepSize;
            java.lang.Number waitIntervalInSeconds;

            /**
             * Sets the value of {@link TrafficRoutingConfigProperty#getType}
             * @param type Traffic routing strategy type. This parameter is required.
             *             <ul>
             *             <li><code>ALL_AT_ONCE</code> : Endpoint traffic shifts to the new fleet in a single step.</li>
             *             <li><code>CANARY</code> : Endpoint traffic shifts to the new fleet in two steps. The first step is the canary, which is a small portion of the traffic. The second step is the remainder of the traffic.</li>
             *             <li><code>LINEAR</code> : Endpoint traffic shifts to the new fleet in n steps of a configurable size.</li>
             *             </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link TrafficRoutingConfigProperty#getCanarySize}
             * @param canarySize Batch size for the first step to turn on traffic on the new endpoint fleet.
             *                   <code>Value</code> must be less than or equal to 50% of the variant's total instance count.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder canarySize(software.amazon.awscdk.IResolvable canarySize) {
                this.canarySize = canarySize;
                return this;
            }

            /**
             * Sets the value of {@link TrafficRoutingConfigProperty#getCanarySize}
             * @param canarySize Batch size for the first step to turn on traffic on the new endpoint fleet.
             *                   <code>Value</code> must be less than or equal to 50% of the variant's total instance count.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder canarySize(software.amazon.awscdk.services.sagemaker.CfnEndpoint.CapacitySizeProperty canarySize) {
                this.canarySize = canarySize;
                return this;
            }

            /**
             * Sets the value of {@link TrafficRoutingConfigProperty#getLinearStepSize}
             * @param linearStepSize Batch size for each step to turn on traffic on the new endpoint fleet.
             *                       <code>Value</code> must be 10-50% of the variant's total instance count.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder linearStepSize(software.amazon.awscdk.IResolvable linearStepSize) {
                this.linearStepSize = linearStepSize;
                return this;
            }

            /**
             * Sets the value of {@link TrafficRoutingConfigProperty#getLinearStepSize}
             * @param linearStepSize Batch size for each step to turn on traffic on the new endpoint fleet.
             *                       <code>Value</code> must be 10-50% of the variant's total instance count.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder linearStepSize(software.amazon.awscdk.services.sagemaker.CfnEndpoint.CapacitySizeProperty linearStepSize) {
                this.linearStepSize = linearStepSize;
                return this;
            }

            /**
             * Sets the value of {@link TrafficRoutingConfigProperty#getWaitIntervalInSeconds}
             * @param waitIntervalInSeconds The waiting time (in seconds) between incremental steps to turn on traffic on the new endpoint fleet.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder waitIntervalInSeconds(java.lang.Number waitIntervalInSeconds) {
                this.waitIntervalInSeconds = waitIntervalInSeconds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TrafficRoutingConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TrafficRoutingConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TrafficRoutingConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TrafficRoutingConfigProperty {
            private final java.lang.String type;
            private final java.lang.Object canarySize;
            private final java.lang.Object linearStepSize;
            private final java.lang.Number waitIntervalInSeconds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.canarySize = software.amazon.jsii.Kernel.get(this, "canarySize", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.linearStepSize = software.amazon.jsii.Kernel.get(this, "linearStepSize", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.waitIntervalInSeconds = software.amazon.jsii.Kernel.get(this, "waitIntervalInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.canarySize = builder.canarySize;
                this.linearStepSize = builder.linearStepSize;
                this.waitIntervalInSeconds = builder.waitIntervalInSeconds;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.Object getCanarySize() {
                return this.canarySize;
            }

            @Override
            public final java.lang.Object getLinearStepSize() {
                return this.linearStepSize;
            }

            @Override
            public final java.lang.Number getWaitIntervalInSeconds() {
                return this.waitIntervalInSeconds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                if (this.getCanarySize() != null) {
                    data.set("canarySize", om.valueToTree(this.getCanarySize()));
                }
                if (this.getLinearStepSize() != null) {
                    data.set("linearStepSize", om.valueToTree(this.getLinearStepSize()));
                }
                if (this.getWaitIntervalInSeconds() != null) {
                    data.set("waitIntervalInSeconds", om.valueToTree(this.getWaitIntervalInSeconds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnEndpoint.TrafficRoutingConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TrafficRoutingConfigProperty.Jsii$Proxy that = (TrafficRoutingConfigProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                if (this.canarySize != null ? !this.canarySize.equals(that.canarySize) : that.canarySize != null) return false;
                if (this.linearStepSize != null ? !this.linearStepSize.equals(that.linearStepSize) : that.linearStepSize != null) return false;
                return this.waitIntervalInSeconds != null ? this.waitIntervalInSeconds.equals(that.waitIntervalInSeconds) : that.waitIntervalInSeconds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.canarySize != null ? this.canarySize.hashCode() : 0);
                result = 31 * result + (this.linearStepSize != null ? this.linearStepSize.hashCode() : 0);
                result = 31 * result + (this.waitIntervalInSeconds != null ? this.waitIntervalInSeconds.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies a production variant property type for an Endpoint.
     * <p>
     * If you are updating an Endpoint with the <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/API_UpdateEndpoint.html#SageMaker-UpdateEndpoint-request-RetainAllVariantProperties">RetainAllVariantProperties</a> option set to <code>true</code> , the <code>VarientProperty</code> objects listed in <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/API_UpdateEndpoint.html#SageMaker-UpdateEndpoint-request-ExcludeRetainedVariantProperties">ExcludeRetainedVariantProperties</a> override the existing variant properties of the Endpoint.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * VariantPropertyProperty variantPropertyProperty = VariantPropertyProperty.builder()
     *         .variantPropertyType("variantPropertyType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-variantproperty.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-variantproperty.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnEndpoint.VariantPropertyProperty")
    @software.amazon.jsii.Jsii.Proxy(VariantPropertyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VariantPropertyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of variant property. The supported values are:.
         * <p>
         * <ul>
         * <li><code>DesiredInstanceCount</code> : Overrides the existing variant instance counts using the <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/API_ProductionVariant.html#SageMaker-Type-ProductionVariant-InitialInstanceCount">InitialInstanceCount</a> values in the <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpointConfig.html#SageMaker-CreateEndpointConfig-request-ProductionVariants">ProductionVariants</a> .</li>
         * <li><code>DesiredWeight</code> : Overrides the existing variant weights using the <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/API_ProductionVariant.html#SageMaker-Type-ProductionVariant-InitialVariantWeight">InitialVariantWeight</a> values in the <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpointConfig.html#SageMaker-CreateEndpointConfig-request-ProductionVariants">ProductionVariants</a> .</li>
         * <li><code>DataCaptureConfig</code> : (Not currently supported.)</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-variantproperty.html#cfn-sagemaker-endpoint-variantproperty-variantpropertytype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-variantproperty.html#cfn-sagemaker-endpoint-variantproperty-variantpropertytype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVariantPropertyType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VariantPropertyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VariantPropertyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VariantPropertyProperty> {
            java.lang.String variantPropertyType;

            /**
             * Sets the value of {@link VariantPropertyProperty#getVariantPropertyType}
             * @param variantPropertyType The type of variant property. The supported values are:.
             *                            <ul>
             *                            <li><code>DesiredInstanceCount</code> : Overrides the existing variant instance counts using the <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/API_ProductionVariant.html#SageMaker-Type-ProductionVariant-InitialInstanceCount">InitialInstanceCount</a> values in the <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpointConfig.html#SageMaker-CreateEndpointConfig-request-ProductionVariants">ProductionVariants</a> .</li>
             *                            <li><code>DesiredWeight</code> : Overrides the existing variant weights using the <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/API_ProductionVariant.html#SageMaker-Type-ProductionVariant-InitialVariantWeight">InitialVariantWeight</a> values in the <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpointConfig.html#SageMaker-CreateEndpointConfig-request-ProductionVariants">ProductionVariants</a> .</li>
             *                            <li><code>DataCaptureConfig</code> : (Not currently supported.)</li>
             *                            </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder variantPropertyType(java.lang.String variantPropertyType) {
                this.variantPropertyType = variantPropertyType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VariantPropertyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VariantPropertyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VariantPropertyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VariantPropertyProperty {
            private final java.lang.String variantPropertyType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.variantPropertyType = software.amazon.jsii.Kernel.get(this, "variantPropertyType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.variantPropertyType = builder.variantPropertyType;
            }

            @Override
            public final java.lang.String getVariantPropertyType() {
                return this.variantPropertyType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getVariantPropertyType() != null) {
                    data.set("variantPropertyType", om.valueToTree(this.getVariantPropertyType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnEndpoint.VariantPropertyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VariantPropertyProperty.Jsii$Proxy that = (VariantPropertyProperty.Jsii$Proxy) o;

                return this.variantPropertyType != null ? this.variantPropertyType.equals(that.variantPropertyType) : that.variantPropertyType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.variantPropertyType != null ? this.variantPropertyType.hashCode() : 0;
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.sagemaker.CfnEndpoint}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.sagemaker.CfnEndpoint> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.sagemaker.CfnEndpointProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.sagemaker.CfnEndpointProps.Builder();
        }

        /**
         * The name of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html">AWS::SageMaker::EndpointConfig</a> resource that specifies the configuration for the endpoint. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpointConfig.html">CreateEndpointConfig</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-endpointconfigname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-endpointconfigname</a>
         * @param endpointConfigName The name of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html">AWS::SageMaker::EndpointConfig</a> resource that specifies the configuration for the endpoint. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpointConfig.html">CreateEndpointConfig</a> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointConfigName(final java.lang.String endpointConfigName) {
            this.props.endpointConfigName(endpointConfigName);
            return this;
        }

        /**
         * The deployment configuration for an endpoint, which contains the desired deployment strategy and rollback configurations.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-deploymentconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-deploymentconfig</a>
         * @param deploymentConfig The deployment configuration for an endpoint, which contains the desired deployment strategy and rollback configurations. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentConfig(final software.amazon.awscdk.IResolvable deploymentConfig) {
            this.props.deploymentConfig(deploymentConfig);
            return this;
        }
        /**
         * The deployment configuration for an endpoint, which contains the desired deployment strategy and rollback configurations.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-deploymentconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-deploymentconfig</a>
         * @param deploymentConfig The deployment configuration for an endpoint, which contains the desired deployment strategy and rollback configurations. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentConfig(final software.amazon.awscdk.services.sagemaker.CfnEndpoint.DeploymentConfigProperty deploymentConfig) {
            this.props.deploymentConfig(deploymentConfig);
            return this;
        }

        /**
         * The name of the endpoint.The name must be unique within an AWS Region in your AWS account. The name is case-insensitive in <code>CreateEndpoint</code> , but the case is preserved and must be matched in <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_runtime_InvokeEndpoint.html"></a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-endpointname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-endpointname</a>
         * @param endpointName The name of the endpoint.The name must be unique within an AWS Region in your AWS account. The name is case-insensitive in <code>CreateEndpoint</code> , but the case is preserved and must be matched in <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_runtime_InvokeEndpoint.html"></a> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointName(final java.lang.String endpointName) {
            this.props.endpointName(endpointName);
            return this;
        }

        /**
         * When you are updating endpoint resources with <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/API_UpdateEndpoint.html#SageMaker-UpdateEndpoint-request-RetainAllVariantProperties">RetainAllVariantProperties</a> whose value is set to <code>true</code> , <code>ExcludeRetainedVariantProperties</code> specifies the list of type <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-variantproperty.html">VariantProperty</a> to override with the values provided by <code>EndpointConfig</code> . If you don't specify a value for <code>ExcludeAllVariantProperties</code> , no variant properties are overridden. Don't use this property when creating new endpoint resources or when <code>RetainAllVariantProperties</code> is set to <code>false</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-excluderetainedvariantproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-excluderetainedvariantproperties</a>
         * @param excludeRetainedVariantProperties When you are updating endpoint resources with <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/API_UpdateEndpoint.html#SageMaker-UpdateEndpoint-request-RetainAllVariantProperties">RetainAllVariantProperties</a> whose value is set to <code>true</code> , <code>ExcludeRetainedVariantProperties</code> specifies the list of type <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-variantproperty.html">VariantProperty</a> to override with the values provided by <code>EndpointConfig</code> . If you don't specify a value for <code>ExcludeAllVariantProperties</code> , no variant properties are overridden. Don't use this property when creating new endpoint resources or when <code>RetainAllVariantProperties</code> is set to <code>false</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder excludeRetainedVariantProperties(final software.amazon.awscdk.IResolvable excludeRetainedVariantProperties) {
            this.props.excludeRetainedVariantProperties(excludeRetainedVariantProperties);
            return this;
        }
        /**
         * When you are updating endpoint resources with <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/API_UpdateEndpoint.html#SageMaker-UpdateEndpoint-request-RetainAllVariantProperties">RetainAllVariantProperties</a> whose value is set to <code>true</code> , <code>ExcludeRetainedVariantProperties</code> specifies the list of type <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-variantproperty.html">VariantProperty</a> to override with the values provided by <code>EndpointConfig</code> . If you don't specify a value for <code>ExcludeAllVariantProperties</code> , no variant properties are overridden. Don't use this property when creating new endpoint resources or when <code>RetainAllVariantProperties</code> is set to <code>false</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-excluderetainedvariantproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-excluderetainedvariantproperties</a>
         * @param excludeRetainedVariantProperties When you are updating endpoint resources with <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/API_UpdateEndpoint.html#SageMaker-UpdateEndpoint-request-RetainAllVariantProperties">RetainAllVariantProperties</a> whose value is set to <code>true</code> , <code>ExcludeRetainedVariantProperties</code> specifies the list of type <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-variantproperty.html">VariantProperty</a> to override with the values provided by <code>EndpointConfig</code> . If you don't specify a value for <code>ExcludeAllVariantProperties</code> , no variant properties are overridden. Don't use this property when creating new endpoint resources or when <code>RetainAllVariantProperties</code> is set to <code>false</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder excludeRetainedVariantProperties(final java.util.List<? extends java.lang.Object> excludeRetainedVariantProperties) {
            this.props.excludeRetainedVariantProperties(excludeRetainedVariantProperties);
            return this;
        }

        /**
         * When updating endpoint resources, enables or disables the retention of variant properties, such as the instance count or the variant weight.
         * <p>
         * To retain the variant properties of an endpoint when updating it, set <code>RetainAllVariantProperties</code> to <code>true</code> . To use the variant properties specified in a new <code>EndpointConfig</code> call when updating an endpoint, set <code>RetainAllVariantProperties</code> to <code>false</code> . Use this property only when updating endpoint resources, not when creating new endpoint resources.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-retainallvariantproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-retainallvariantproperties</a>
         * @param retainAllVariantProperties When updating endpoint resources, enables or disables the retention of variant properties, such as the instance count or the variant weight. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retainAllVariantProperties(final java.lang.Boolean retainAllVariantProperties) {
            this.props.retainAllVariantProperties(retainAllVariantProperties);
            return this;
        }
        /**
         * When updating endpoint resources, enables or disables the retention of variant properties, such as the instance count or the variant weight.
         * <p>
         * To retain the variant properties of an endpoint when updating it, set <code>RetainAllVariantProperties</code> to <code>true</code> . To use the variant properties specified in a new <code>EndpointConfig</code> call when updating an endpoint, set <code>RetainAllVariantProperties</code> to <code>false</code> . Use this property only when updating endpoint resources, not when creating new endpoint resources.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-retainallvariantproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-retainallvariantproperties</a>
         * @param retainAllVariantProperties When updating endpoint resources, enables or disables the retention of variant properties, such as the instance count or the variant weight. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retainAllVariantProperties(final software.amazon.awscdk.IResolvable retainAllVariantProperties) {
            this.props.retainAllVariantProperties(retainAllVariantProperties);
            return this;
        }

        /**
         * Specifies whether to reuse the last deployment configuration.
         * <p>
         * The default value is false (the configuration is not reused).
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-retaindeploymentconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-retaindeploymentconfig</a>
         * @param retainDeploymentConfig Specifies whether to reuse the last deployment configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retainDeploymentConfig(final java.lang.Boolean retainDeploymentConfig) {
            this.props.retainDeploymentConfig(retainDeploymentConfig);
            return this;
        }
        /**
         * Specifies whether to reuse the last deployment configuration.
         * <p>
         * The default value is false (the configuration is not reused).
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-retaindeploymentconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-retaindeploymentconfig</a>
         * @param retainDeploymentConfig Specifies whether to reuse the last deployment configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retainDeploymentConfig(final software.amazon.awscdk.IResolvable retainDeploymentConfig) {
            this.props.retainDeploymentConfig(retainDeploymentConfig);
            return this;
        }

        /**
         * A list of key-value pairs to apply to this resource.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Resource Tag</a> and <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what">Using Cost Allocation Tags</a> in the <em>AWS Billing and Cost Management User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-tags</a>
         * @param tags A list of key-value pairs to apply to this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.sagemaker.CfnEndpoint}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.sagemaker.CfnEndpoint build() {
            return new software.amazon.awscdk.services.sagemaker.CfnEndpoint(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
