package software.amazon.awscdk.services.shield;

/**
 * Authorizes the Shield Response Team (SRT) to use email and phone to notify contacts about escalations to the SRT and to initiate proactive customer support.
 * <p>
 * To enable proactive engagement, you must be subscribed to the <a href="https://docs.aws.amazon.com/premiumsupport/business-support/">Business Support plan</a> or the <a href="https://docs.aws.amazon.com/premiumsupport/enterprise-support/">Enterprise Support plan</a> .
 * <p>
 * <em>Configure <code>AWS::Shield::ProactiveEngagement</code> for one account</em>
 * <p>
 * To configure this resource through AWS CloudFormation , you must be subscribed to AWS Shield Advanced . You can subscribe through the <a href="https://docs.aws.amazon.com/wafv2/shieldv2#/">Shield Advanced console</a> and through the APIs. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/enable-ddos-prem.html">Subscribe to AWS Shield Advanced</a> .
 * <p>
 * See example templates for Shield Advanced in AWS CloudFormation at <a href="https://docs.aws.amazon.com/https://github.com/aws-samples/aws-shield-advanced-examples">aws-samples/aws-shield-advanced-examples</a> .
 * <p>
 * <em>Configure Shield Advanced using AWS CloudFormation and AWS Firewall Manager</em>
 * <p>
 * You might be able to use Firewall Manager with AWS CloudFormation to configure Shield Advanced across multiple accounts and protected resources. To do this, your accounts must be part of an organization in AWS Organizations . You can use Firewall Manager to configure Shield Advanced protections for any resource types except for Amazon Route 53 or AWS Global Accelerator .
 * <p>
 * For an example of this, see the one-click configuration guidance published by the AWS technical community at <a href="https://docs.aws.amazon.com/https://youtu.be/LCA3FwMk_QE">One-click deployment of Shield Advanced</a> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.shield.*;
 * CfnProactiveEngagement cfnProactiveEngagement = CfnProactiveEngagement.Builder.create(this, "MyCfnProactiveEngagement")
 *         .emergencyContactList(List.of(EmergencyContactProperty.builder()
 *                 .emailAddress("emailAddress")
 *                 // the properties below are optional
 *                 .contactNotes("contactNotes")
 *                 .phoneNumber("phoneNumber")
 *                 .build()))
 *         .proactiveEngagementStatus("proactiveEngagementStatus")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-shield-proactiveengagement.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-shield-proactiveengagement.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-22T22:42:58.534Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_shield.CfnProactiveEngagement")
public class CfnProactiveEngagement extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnProactiveEngagement(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnProactiveEngagement(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.shield.CfnProactiveEngagement.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnProactiveEngagement(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.shield.CfnProactiveEngagementProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ID of the account that submitted the template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrAccountId() {
        return software.amazon.jsii.Kernel.get(this, "attrAccountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The list of email addresses and phone numbers that the Shield Response Team (SRT) can use to contact you for escalations to the SRT and to initiate proactive customer support, plus any relevant notes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getEmergencyContactList() {
        return software.amazon.jsii.Kernel.get(this, "emergencyContactList", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The list of email addresses and phone numbers that the Shield Response Team (SRT) can use to contact you for escalations to the SRT and to initiate proactive customer support, plus any relevant notes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEmergencyContactList(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "emergencyContactList", java.util.Objects.requireNonNull(value, "emergencyContactList is required"));
    }

    /**
     * The list of email addresses and phone numbers that the Shield Response Team (SRT) can use to contact you for escalations to the SRT and to initiate proactive customer support, plus any relevant notes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEmergencyContactList(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.shield.CfnProactiveEngagement.EmergencyContactProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.shield.CfnProactiveEngagement.EmergencyContactProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "emergencyContactList", java.util.Objects.requireNonNull(value, "emergencyContactList is required"));
    }

    /**
     * Specifies whether proactive engagement is enabled or disabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getProactiveEngagementStatus() {
        return software.amazon.jsii.Kernel.get(this, "proactiveEngagementStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies whether proactive engagement is enabled or disabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProactiveEngagementStatus(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "proactiveEngagementStatus", java.util.Objects.requireNonNull(value, "proactiveEngagementStatus is required"));
    }
    /**
     * Contact information that the SRT can use to contact you if you have proactive engagement enabled, for escalations to the SRT and to initiate proactive customer support.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.shield.*;
     * EmergencyContactProperty emergencyContactProperty = EmergencyContactProperty.builder()
     *         .emailAddress("emailAddress")
     *         // the properties below are optional
     *         .contactNotes("contactNotes")
     *         .phoneNumber("phoneNumber")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-shield-proactiveengagement-emergencycontact.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-shield-proactiveengagement-emergencycontact.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_shield.CfnProactiveEngagement.EmergencyContactProperty")
    @software.amazon.jsii.Jsii.Proxy(EmergencyContactProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EmergencyContactProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The email address for the contact.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-shield-proactiveengagement-emergencycontact.html#cfn-shield-proactiveengagement-emergencycontact-emailaddress">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-shield-proactiveengagement-emergencycontact.html#cfn-shield-proactiveengagement-emergencycontact-emailaddress</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEmailAddress();

        /**
         * Additional notes regarding the contact.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-shield-proactiveengagement-emergencycontact.html#cfn-shield-proactiveengagement-emergencycontact-contactnotes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-shield-proactiveengagement-emergencycontact.html#cfn-shield-proactiveengagement-emergencycontact-contactnotes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getContactNotes() {
            return null;
        }

        /**
         * The phone number for the contact.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-shield-proactiveengagement-emergencycontact.html#cfn-shield-proactiveengagement-emergencycontact-phonenumber">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-shield-proactiveengagement-emergencycontact.html#cfn-shield-proactiveengagement-emergencycontact-phonenumber</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPhoneNumber() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EmergencyContactProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EmergencyContactProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EmergencyContactProperty> {
            java.lang.String emailAddress;
            java.lang.String contactNotes;
            java.lang.String phoneNumber;

            /**
             * Sets the value of {@link EmergencyContactProperty#getEmailAddress}
             * @param emailAddress The email address for the contact. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder emailAddress(java.lang.String emailAddress) {
                this.emailAddress = emailAddress;
                return this;
            }

            /**
             * Sets the value of {@link EmergencyContactProperty#getContactNotes}
             * @param contactNotes Additional notes regarding the contact.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder contactNotes(java.lang.String contactNotes) {
                this.contactNotes = contactNotes;
                return this;
            }

            /**
             * Sets the value of {@link EmergencyContactProperty#getPhoneNumber}
             * @param phoneNumber The phone number for the contact.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder phoneNumber(java.lang.String phoneNumber) {
                this.phoneNumber = phoneNumber;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EmergencyContactProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EmergencyContactProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EmergencyContactProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EmergencyContactProperty {
            private final java.lang.String emailAddress;
            private final java.lang.String contactNotes;
            private final java.lang.String phoneNumber;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.emailAddress = software.amazon.jsii.Kernel.get(this, "emailAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.contactNotes = software.amazon.jsii.Kernel.get(this, "contactNotes", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.phoneNumber = software.amazon.jsii.Kernel.get(this, "phoneNumber", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.emailAddress = java.util.Objects.requireNonNull(builder.emailAddress, "emailAddress is required");
                this.contactNotes = builder.contactNotes;
                this.phoneNumber = builder.phoneNumber;
            }

            @Override
            public final java.lang.String getEmailAddress() {
                return this.emailAddress;
            }

            @Override
            public final java.lang.String getContactNotes() {
                return this.contactNotes;
            }

            @Override
            public final java.lang.String getPhoneNumber() {
                return this.phoneNumber;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("emailAddress", om.valueToTree(this.getEmailAddress()));
                if (this.getContactNotes() != null) {
                    data.set("contactNotes", om.valueToTree(this.getContactNotes()));
                }
                if (this.getPhoneNumber() != null) {
                    data.set("phoneNumber", om.valueToTree(this.getPhoneNumber()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_shield.CfnProactiveEngagement.EmergencyContactProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EmergencyContactProperty.Jsii$Proxy that = (EmergencyContactProperty.Jsii$Proxy) o;

                if (!emailAddress.equals(that.emailAddress)) return false;
                if (this.contactNotes != null ? !this.contactNotes.equals(that.contactNotes) : that.contactNotes != null) return false;
                return this.phoneNumber != null ? this.phoneNumber.equals(that.phoneNumber) : that.phoneNumber == null;
            }

            @Override
            public final int hashCode() {
                int result = this.emailAddress.hashCode();
                result = 31 * result + (this.contactNotes != null ? this.contactNotes.hashCode() : 0);
                result = 31 * result + (this.phoneNumber != null ? this.phoneNumber.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.shield.CfnProactiveEngagement}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.shield.CfnProactiveEngagement> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.shield.CfnProactiveEngagementProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.shield.CfnProactiveEngagementProps.Builder();
        }

        /**
         * The list of email addresses and phone numbers that the Shield Response Team (SRT) can use to contact you for escalations to the SRT and to initiate proactive customer support, plus any relevant notes.
         * <p>
         * To enable proactive engagement, the contact list must include at least one phone number.
         * <p>
         * If you provide more than one contact, in the notes, indicate the circumstances under which each contact should be used. Include primary and secondary contact designations, and provide the hours of availability and time zones for each contact.
         * <p>
         * Example contact notes:
         * <p>
         * <ul>
         * <li>This is a hotline that's staffed 24x7x365. Please work with the responding analyst and they will get the appropriate person on the call.</li>
         * <li>Please contact the secondary phone number if the hotline doesn't respond within 5 minutes.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-shield-proactiveengagement.html#cfn-shield-proactiveengagement-emergencycontactlist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-shield-proactiveengagement.html#cfn-shield-proactiveengagement-emergencycontactlist</a>
         * @param emergencyContactList The list of email addresses and phone numbers that the Shield Response Team (SRT) can use to contact you for escalations to the SRT and to initiate proactive customer support, plus any relevant notes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder emergencyContactList(final software.amazon.awscdk.IResolvable emergencyContactList) {
            this.props.emergencyContactList(emergencyContactList);
            return this;
        }
        /**
         * The list of email addresses and phone numbers that the Shield Response Team (SRT) can use to contact you for escalations to the SRT and to initiate proactive customer support, plus any relevant notes.
         * <p>
         * To enable proactive engagement, the contact list must include at least one phone number.
         * <p>
         * If you provide more than one contact, in the notes, indicate the circumstances under which each contact should be used. Include primary and secondary contact designations, and provide the hours of availability and time zones for each contact.
         * <p>
         * Example contact notes:
         * <p>
         * <ul>
         * <li>This is a hotline that's staffed 24x7x365. Please work with the responding analyst and they will get the appropriate person on the call.</li>
         * <li>Please contact the secondary phone number if the hotline doesn't respond within 5 minutes.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-shield-proactiveengagement.html#cfn-shield-proactiveengagement-emergencycontactlist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-shield-proactiveengagement.html#cfn-shield-proactiveengagement-emergencycontactlist</a>
         * @param emergencyContactList The list of email addresses and phone numbers that the Shield Response Team (SRT) can use to contact you for escalations to the SRT and to initiate proactive customer support, plus any relevant notes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder emergencyContactList(final java.util.List<? extends java.lang.Object> emergencyContactList) {
            this.props.emergencyContactList(emergencyContactList);
            return this;
        }

        /**
         * Specifies whether proactive engagement is enabled or disabled.
         * <p>
         * Valid values:
         * <p>
         * <code>ENABLED</code> - The Shield Response Team (SRT) will use email and phone to notify contacts about escalations to the SRT and to initiate proactive customer support.
         * <p>
         * <code>DISABLED</code> - The SRT will not proactively notify contacts about escalations or to initiate proactive customer support.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-shield-proactiveengagement.html#cfn-shield-proactiveengagement-proactiveengagementstatus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-shield-proactiveengagement.html#cfn-shield-proactiveengagement-proactiveengagementstatus</a>
         * @param proactiveEngagementStatus Specifies whether proactive engagement is enabled or disabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder proactiveEngagementStatus(final java.lang.String proactiveEngagementStatus) {
            this.props.proactiveEngagementStatus(proactiveEngagementStatus);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.shield.CfnProactiveEngagement}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.shield.CfnProactiveEngagement build() {
            return new software.amazon.awscdk.services.shield.CfnProactiveEngagement(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
