package software.amazon.awscdk.services.sqs;

/**
 * What kind of encryption to apply to this queue.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Use managed key
 * // Use managed key
 * Queue.Builder.create(this, "Queue")
 *         .encryption(QueueEncryption.KMS_MANAGED)
 *         .build();
 * // Use custom key
 * Key myKey = new Key(this, "Key");
 * Queue.Builder.create(this, "Queue")
 *         .encryption(QueueEncryption.KMS)
 *         .encryptionMasterKey(myKey)
 *         .build();
 * // Use SQS managed server side encryption (SSE-SQS)
 * // Use SQS managed server side encryption (SSE-SQS)
 * Queue.Builder.create(this, "Queue")
 *         .encryption(QueueEncryption.SQS_MANAGED)
 *         .build();
 * // Unencrypted queue
 * // Unencrypted queue
 * Queue.Builder.create(this, "Queue")
 *         .encryption(QueueEncryption.UNENCRYPTED)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-22T22:42:58.624Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sqs.QueueEncryption")
public enum QueueEncryption {
    /**
     * Messages in the queue are not encrypted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    UNENCRYPTED,
    /**
     * Server-side KMS encryption with a KMS key managed by SQS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    KMS_MANAGED,
    /**
     * Server-side encryption with a KMS key managed by the user.
     * <p>
     * If <code>encryptionKey</code> is specified, this key will be used, otherwise, one will be defined.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    KMS,
    /**
     * Server-side encryption key managed by SQS (SSE-SQS).
     * <p>
     * To learn more about SSE-SQS on Amazon SQS, please visit the
     * <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html">Amazon SQS documentation</a>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SQS_MANAGED,
}
