package software.amazon.awscdk.services.ssm;

/**
 * Creates a new String SSM Parameter.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * StringParameter ssmParameter = StringParameter.Builder.create(this, "mySsmParameter")
 *         .parameterName("mySsmParameter")
 *         .stringValue("mySsmParameterValue")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-22T22:42:58.691Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssm.StringParameter")
public class StringParameter extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.ssm.IStringParameter, software.amazon.awscdk.services.ssm.IParameter {

    protected StringParameter(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected StringParameter(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public StringParameter(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ssm.StringParameterProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Imports a secure string parameter from the SSM parameter store.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ssm.IStringParameter fromSecureStringParameterAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ssm.SecureStringParameterAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ssm.StringParameter.class, "fromSecureStringParameterAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ssm.IStringParameter.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Imports an external string parameter with name and optional version.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ssm.IStringParameter fromStringParameterAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ssm.StringParameterAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ssm.StringParameter.class, "fromStringParameterAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ssm.IStringParameter.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Imports an external string parameter by name.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param stringParameterName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ssm.IStringParameter fromStringParameterName(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String stringParameterName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ssm.StringParameter.class, "fromStringParameterName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ssm.IStringParameter.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(stringParameterName, "stringParameterName is required") });
    }

    /**
     * (deprecated) Returns a token that will resolve (during deployment).
     * <p>
     * @deprecated Use <code>SecretValue.ssmSecure()</code> instead, it will correctly type the imported value as a <code>SecretValue</code> and allow importing without version. <code>SecretValue</code> lives in the core <code>aws-cdk-lib</code> module.
     * @param scope Some scope within a stack. This parameter is required.
     * @param parameterName The name of the SSM parameter. This parameter is required.
     * @param version The parameter version (required for secure strings). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public static @org.jetbrains.annotations.NotNull java.lang.String valueForSecureStringParameter(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String parameterName, final @org.jetbrains.annotations.NotNull java.lang.Number version) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ssm.StringParameter.class, "valueForSecureStringParameter", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(parameterName, "parameterName is required"), java.util.Objects.requireNonNull(version, "version is required") });
    }

    /**
     * Returns a token that will resolve (during deployment) to the string value of an SSM string parameter.
     * <p>
     * @param scope Some scope within a stack. This parameter is required.
     * @param parameterName The name of the SSM parameter. This parameter is required.
     * @param version The parameter version (recommended in order to ensure that the value won't change during deployment).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String valueForStringParameter(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String parameterName, final @org.jetbrains.annotations.Nullable java.lang.Number version) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ssm.StringParameter.class, "valueForStringParameter", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(parameterName, "parameterName is required"), version });
    }

    /**
     * Returns a token that will resolve (during deployment) to the string value of an SSM string parameter.
     * <p>
     * @param scope Some scope within a stack. This parameter is required.
     * @param parameterName The name of the SSM parameter. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String valueForStringParameter(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String parameterName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ssm.StringParameter.class, "valueForStringParameter", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(parameterName, "parameterName is required") });
    }

    /**
     * (deprecated) Returns a token that will resolve (during deployment) to the string value of an SSM string parameter.
     * <p>
     * @deprecated <ul>
     * <li>use valueForTypedStringParameterV2 instead</li>
     * </ul>
     * @param scope Some scope within a stack. This parameter is required.
     * @param parameterName The name of the SSM parameter. This parameter is required.
     * @param type The type of the SSM parameter.
     * @param version The parameter version (recommended in order to ensure that the value won't change during deployment).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public static @org.jetbrains.annotations.NotNull java.lang.String valueForTypedStringParameter(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String parameterName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ssm.ParameterType type, final @org.jetbrains.annotations.Nullable java.lang.Number version) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ssm.StringParameter.class, "valueForTypedStringParameter", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(parameterName, "parameterName is required"), type, version });
    }

    /**
     * (deprecated) Returns a token that will resolve (during deployment) to the string value of an SSM string parameter.
     * <p>
     * @deprecated <ul>
     * <li>use valueForTypedStringParameterV2 instead</li>
     * </ul>
     * @param scope Some scope within a stack. This parameter is required.
     * @param parameterName The name of the SSM parameter. This parameter is required.
     * @param type The type of the SSM parameter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public static @org.jetbrains.annotations.NotNull java.lang.String valueForTypedStringParameter(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String parameterName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ssm.ParameterType type) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ssm.StringParameter.class, "valueForTypedStringParameter", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(parameterName, "parameterName is required"), type });
    }

    /**
     * (deprecated) Returns a token that will resolve (during deployment) to the string value of an SSM string parameter.
     * <p>
     * @deprecated <ul>
     * <li>use valueForTypedStringParameterV2 instead</li>
     * </ul>
     * @param scope Some scope within a stack. This parameter is required.
     * @param parameterName The name of the SSM parameter. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public static @org.jetbrains.annotations.NotNull java.lang.String valueForTypedStringParameter(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String parameterName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ssm.StringParameter.class, "valueForTypedStringParameter", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(parameterName, "parameterName is required") });
    }

    /**
     * Returns a token that will resolve (during deployment) to the string value of an SSM string parameter.
     * <p>
     * @param scope Some scope within a stack. This parameter is required.
     * @param parameterName The name of the SSM parameter. This parameter is required.
     * @param type The type of the SSM parameter.
     * @param version The parameter version (recommended in order to ensure that the value won't change during deployment).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String valueForTypedStringParameterV2(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String parameterName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ssm.ParameterValueType type, final @org.jetbrains.annotations.Nullable java.lang.Number version) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ssm.StringParameter.class, "valueForTypedStringParameterV2", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(parameterName, "parameterName is required"), type, version });
    }

    /**
     * Returns a token that will resolve (during deployment) to the string value of an SSM string parameter.
     * <p>
     * @param scope Some scope within a stack. This parameter is required.
     * @param parameterName The name of the SSM parameter. This parameter is required.
     * @param type The type of the SSM parameter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String valueForTypedStringParameterV2(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String parameterName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ssm.ParameterValueType type) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ssm.StringParameter.class, "valueForTypedStringParameterV2", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(parameterName, "parameterName is required"), type });
    }

    /**
     * Returns a token that will resolve (during deployment) to the string value of an SSM string parameter.
     * <p>
     * @param scope Some scope within a stack. This parameter is required.
     * @param parameterName The name of the SSM parameter. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String valueForTypedStringParameterV2(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String parameterName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ssm.StringParameter.class, "valueForTypedStringParameterV2", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(parameterName, "parameterName is required") });
    }

    /**
     * Reads the value of an SSM parameter during synthesis through an environmental context provider.
     * <p>
     * Requires that the stack this scope is defined in will have explicit
     * account/region information. Otherwise, it will fail during synthesis.
     * <p>
     * @param scope This parameter is required.
     * @param parameterName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String valueFromLookup(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String parameterName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ssm.StringParameter.class, "valueFromLookup", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(parameterName, "parameterName is required") });
    }

    /**
     * Grants read (DescribeParameter, GetParameters, GetParameter, GetParameterHistory) permissions on the SSM Parameter.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantRead(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantRead", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Grants write (PutParameter) permissions on the SSM Parameter.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantWrite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantWrite", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * The ARN of the SSM Parameter resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getParameterArn() {
        return software.amazon.jsii.Kernel.get(this, "parameterArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the SSM Parameter resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getParameterName() {
        return software.amazon.jsii.Kernel.get(this, "parameterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of the SSM Parameter resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getParameterType() {
        return software.amazon.jsii.Kernel.get(this, "parameterType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The parameter value.
     * <p>
     * Value must not nest another parameter. Do not use {{}} in the value.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getStringValue() {
        return software.amazon.jsii.Kernel.get(this, "stringValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The encryption key that is used to encrypt this parameter.
     * <p>
     * Default: - default master key
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
        return software.amazon.jsii.Kernel.get(this, "encryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ssm.StringParameter}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ssm.StringParameter> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ssm.StringParameterProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ssm.StringParameterProps.Builder();
        }

        /**
         * A regular expression used to validate the parameter value.
         * <p>
         * For example, for String types with values restricted to
         * numbers, you can specify the following: <code>^\d+$</code>
         * <p>
         * Default: no validation is performed
         * <p>
         * @return {@code this}
         * @param allowedPattern A regular expression used to validate the parameter value. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowedPattern(final java.lang.String allowedPattern) {
            this.props.allowedPattern(allowedPattern);
            return this;
        }

        /**
         * Information about the parameter that you want to add to the system.
         * <p>
         * Default: none
         * <p>
         * @return {@code this}
         * @param description Information about the parameter that you want to add to the system. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The name of the parameter.
         * <p>
         * Default: - a name will be generated by CloudFormation
         * <p>
         * @return {@code this}
         * @param parameterName The name of the parameter. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameterName(final java.lang.String parameterName) {
            this.props.parameterName(parameterName);
            return this;
        }

        /**
         * Indicates whether the parameter name is a simple name.
         * <p>
         * A parameter name
         * without any "/" is considered a simple name. If the parameter name includes
         * "/", setting simpleName to true might cause unintended issues such
         * as duplicate "/" in the resulting ARN.
         * <p>
         * This is required only if <code>parameterName</code> is a token, which means we
         * are unable to detect if the name is simple or "path-like" for the purpose
         * of rendering SSM parameter ARNs.
         * <p>
         * If <code>parameterName</code> is not specified, <code>simpleName</code> must be <code>true</code> (or
         * undefined) since the name generated by AWS CloudFormation is always a
         * simple name.
         * <p>
         * Default: - auto-detect based on `parameterName`
         * <p>
         * @return {@code this}
         * @param simpleName Indicates whether the parameter name is a simple name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder simpleName(final java.lang.Boolean simpleName) {
            this.props.simpleName(simpleName);
            return this;
        }

        /**
         * The tier of the string parameter.
         * <p>
         * Default: - undefined
         * <p>
         * @return {@code this}
         * @param tier The tier of the string parameter. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tier(final software.amazon.awscdk.services.ssm.ParameterTier tier) {
            this.props.tier(tier);
            return this;
        }

        /**
         * The value of the parameter.
         * <p>
         * It may not reference another parameter and <code>{{}}</code> cannot be used in the value.
         * <p>
         * @return {@code this}
         * @param stringValue The value of the parameter. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stringValue(final java.lang.String stringValue) {
            this.props.stringValue(stringValue);
            return this;
        }

        /**
         * The data type of the parameter, such as <code>text</code> or <code>aws:ec2:image</code>.
         * <p>
         * Default: ParameterDataType.TEXT
         * <p>
         * @return {@code this}
         * @param dataType The data type of the parameter, such as <code>text</code> or <code>aws:ec2:image</code>. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataType(final software.amazon.awscdk.services.ssm.ParameterDataType dataType) {
            this.props.dataType(dataType);
            return this;
        }

        /**
         * (deprecated) The type of the string parameter.
         * <p>
         * Default: ParameterType.STRING
         * <p>
         * @return {@code this}
         * @deprecated <ul>
         * <li>type will always be 'String'</li>
         * </ul>
         * @param type The type of the string parameter. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder type(final software.amazon.awscdk.services.ssm.ParameterType type) {
            this.props.type(type);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ssm.StringParameter}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ssm.StringParameter build() {
            return new software.amazon.awscdk.services.ssm.StringParameter(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
