package software.amazon.awscdk.services.stepfunctions;

/**
 * AWS Step Functions integrates with services directly in the Amazon States Language.
 * <p>
 * You can control these AWS services using service integration patterns:
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.codebuild.*;
 * Project project = Project.Builder.create(this, "Project")
 *         .projectName("MyTestProject")
 *         .buildSpec(BuildSpec.fromObjectToYaml(Map.of(
 *                 "version", 0.2,
 *                 "batch", Map.of(
 *                         "build-list", List.of(Map.of(
 *                                 "identifier", "id",
 *                                 "buildspec", "version: 0.2\nphases:\n  build:\n    commands:\n      - echo \"Hello, from small!\""))))))
 *         .build();
 * project.enableBatchBuilds();
 * CodeBuildStartBuildBatch task = CodeBuildStartBuildBatch.Builder.create(this, "buildBatchTask")
 *         .project(project)
 *         .integrationPattern(IntegrationPattern.REQUEST_RESPONSE)
 *         .environmentVariablesOverride(Map.of(
 *                 "test", BuildEnvironmentVariable.builder()
 *                         .type(BuildEnvironmentVariableType.PLAINTEXT)
 *                         .value("testValue")
 *                         .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html">https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-22T22:42:58.803Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.IntegrationPattern")
public enum IntegrationPattern {
    /**
     * Step Functions will wait for an HTTP response and then progress to the next state.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-default">https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-default</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    REQUEST_RESPONSE,
    /**
     * Step Functions can wait for a request to complete before progressing to the next state.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-sync">https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-sync</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    RUN_JOB,
    /**
     * Callback tasks provide a way to pause a workflow until a task token is returned.
     * <p>
     * You must set a task token when using the callback pattern
     * <p>
     * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token">https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    WAIT_FOR_TASK_TOKEN,
}
