package software.amazon.awscdk.services.stepfunctions;

/**
 * Item Reader configuration for iterating over objects in an S3 bucket.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.s3.*;
 * import software.amazon.awscdk.services.stepfunctions.*;
 * Bucket bucket;
 * S3ObjectsItemReader s3ObjectsItemReader = S3ObjectsItemReader.Builder.create()
 *         .bucket(bucket)
 *         // the properties below are optional
 *         .maxItems(123)
 *         .prefix("prefix")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-22T22:42:58.830Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.S3ObjectsItemReader")
public class S3ObjectsItemReader extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.stepfunctions.IItemReader {

    protected S3ObjectsItemReader(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected S3ObjectsItemReader(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public S3ObjectsItemReader(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.S3ObjectsItemReaderProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Compile policy statements to provide relevent permissions to the state machine.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> providePolicyStatements() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "providePolicyStatements", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyStatement.class))));
    }

    /**
     * Renders the ItemReader configuration as JSON object.
     * <p>
     * @return <ul>
     * <li>JSON object</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.Object render() {
        return software.amazon.jsii.Kernel.call(this, "render", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * S3 Bucket containing objects to iterate over.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket getBucket() {
        return software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class));
    }

    /**
     * ARN for the <code>listObjectsV2</code> method of the S3 API This API method is used to iterate all objects in the S3 bucket/prefix.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getResource() {
        return software.amazon.jsii.Kernel.get(this, "resource", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Limits the number of items passed to the Distributed Map state.
     * <p>
     * Default: - Distributed Map state will iterate over all items provided by the ItemReader
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getMaxItems() {
        return software.amazon.jsii.Kernel.get(this, "maxItems", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * S3 prefix used to limit objects to iterate over.
     * <p>
     * Default: - No prefix
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPrefix() {
        return software.amazon.jsii.Kernel.get(this, "prefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.stepfunctions.S3ObjectsItemReader}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.stepfunctions.S3ObjectsItemReader> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.stepfunctions.S3ObjectsItemReaderProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.stepfunctions.S3ObjectsItemReaderProps.Builder();
        }

        /**
         * S3 Bucket containing objects to iterate over or a file with a list to iterate over.
         * <p>
         * @return {@code this}
         * @param bucket S3 Bucket containing objects to iterate over or a file with a list to iterate over. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucket(final software.amazon.awscdk.services.s3.IBucket bucket) {
            this.props.bucket(bucket);
            return this;
        }

        /**
         * Limits the number of items passed to the Distributed Map state.
         * <p>
         * Default: - Distributed Map state will iterate over all items provided by the ItemReader
         * <p>
         * @return {@code this}
         * @param maxItems Limits the number of items passed to the Distributed Map state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxItems(final java.lang.Number maxItems) {
            this.props.maxItems(maxItems);
            return this;
        }

        /**
         * S3 prefix used to limit objects to iterate over.
         * <p>
         * Default: - No prefix
         * <p>
         * @return {@code this}
         * @param prefix S3 prefix used to limit objects to iterate over. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder prefix(final java.lang.String prefix) {
            this.props.prefix(prefix);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.stepfunctions.S3ObjectsItemReader}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.stepfunctions.S3ObjectsItemReader build() {
            return new software.amazon.awscdk.services.stepfunctions.S3ObjectsItemReader(
                this.props.build()
            );
        }
    }
}
