package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Location to retrieve the input data, prior to calling Bedrock InvokeModel.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.stepfunctions.tasks.*;
 * BedrockInvokeModelInputProps bedrockInvokeModelInputProps = BedrockInvokeModelInputProps.builder()
 *         .s3Location(Location.builder()
 *                 .bucketName("bucketName")
 *                 .objectKey("objectKey")
 *                 // the properties below are optional
 *                 .objectVersion("objectVersion")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-bedrock.html">https://docs.aws.amazon.com/step-functions/latest/dg/connect-bedrock.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-22T22:42:58.896Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.BedrockInvokeModelInputProps")
@software.amazon.jsii.Jsii.Proxy(BedrockInvokeModelInputProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BedrockInvokeModelInputProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * S3 object to retrieve the input data from.
     * <p>
     * If the S3 location is not set, then the Body must be set.
     * <p>
     * Default: - Input data is retrieved from the `body` field
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.Location getS3Location() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BedrockInvokeModelInputProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BedrockInvokeModelInputProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BedrockInvokeModelInputProps> {
        software.amazon.awscdk.services.s3.Location s3Location;

        /**
         * Sets the value of {@link BedrockInvokeModelInputProps#getS3Location}
         * @param s3Location S3 object to retrieve the input data from.
         *                   If the S3 location is not set, then the Body must be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3Location(software.amazon.awscdk.services.s3.Location s3Location) {
            this.s3Location = s3Location;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BedrockInvokeModelInputProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BedrockInvokeModelInputProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BedrockInvokeModelInputProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BedrockInvokeModelInputProps {
        private final software.amazon.awscdk.services.s3.Location s3Location;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.s3Location = software.amazon.jsii.Kernel.get(this, "s3Location", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.Location.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.s3Location = builder.s3Location;
        }

        @Override
        public final software.amazon.awscdk.services.s3.Location getS3Location() {
            return this.s3Location;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getS3Location() != null) {
                data.set("s3Location", om.valueToTree(this.getS3Location()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions_tasks.BedrockInvokeModelInputProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BedrockInvokeModelInputProps.Jsii$Proxy that = (BedrockInvokeModelInputProps.Jsii$Proxy) o;

            return this.s3Location != null ? this.s3Location.equals(that.s3Location) : that.s3Location == null;
        }

        @Override
        public final int hashCode() {
            int result = this.s3Location != null ? this.s3Location.hashCode() : 0;
            return result;
        }
    }
}
