package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Creates <code>IDockerImage</code> instances.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * SageMakerCreateModel.Builder.create(this, "Sagemaker")
 *         .modelName("MyModel")
 *         .primaryContainer(ContainerDefinition.Builder.create()
 *                 .image(DockerImage.fromJsonExpression(JsonPath.stringAt("$.Model.imageName")))
 *                 .mode(Mode.SINGLE_MODEL)
 *                 .modelS3Location(S3Location.fromJsonExpression("$.TrainingJob.ModelArtifacts.S3ModelArtifacts"))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-22T22:42:58.928Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.DockerImage")
public abstract class DockerImage extends software.amazon.jsii.JsiiObject {

    protected DockerImage(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DockerImage(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected DockerImage() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Reference a Docker image that is provided as an Asset in the current app.
     * <p>
     * @param scope the scope in which to create the Asset. This parameter is required.
     * @param id the ID for the asset in the construct tree. This parameter is required.
     * @param props the configuration props of the asset. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.DockerImage fromAsset(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecr.assets.DockerImageAssetProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.tasks.DockerImage.class, "fromAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.DockerImage.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Reference a Docker image stored in an ECR repository.
     * <p>
     * @param repository the ECR repository where the image is hosted. This parameter is required.
     * @param tagOrDigest an optional tag or digest (digests must start with <code>sha256:</code>).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.DockerImage fromEcrRepository(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecr.IRepository repository, final @org.jetbrains.annotations.Nullable java.lang.String tagOrDigest) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.tasks.DockerImage.class, "fromEcrRepository", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.DockerImage.class), new Object[] { java.util.Objects.requireNonNull(repository, "repository is required"), tagOrDigest });
    }

    /**
     * Reference a Docker image stored in an ECR repository.
     * <p>
     * @param repository the ECR repository where the image is hosted. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.DockerImage fromEcrRepository(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecr.IRepository repository) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.tasks.DockerImage.class, "fromEcrRepository", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.DockerImage.class), new Object[] { java.util.Objects.requireNonNull(repository, "repository is required") });
    }

    /**
     * Reference a Docker image which URI is obtained from the task's input.
     * <p>
     * @param expression the JSON path expression with the task input. This parameter is required.
     * @param allowAnyEcrImagePull whether ECR access should be permitted (set to <code>false</code> if the image will never be in ECR).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.DockerImage fromJsonExpression(final @org.jetbrains.annotations.NotNull java.lang.String expression, final @org.jetbrains.annotations.Nullable java.lang.Boolean allowAnyEcrImagePull) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.tasks.DockerImage.class, "fromJsonExpression", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.DockerImage.class), new Object[] { java.util.Objects.requireNonNull(expression, "expression is required"), allowAnyEcrImagePull });
    }

    /**
     * Reference a Docker image which URI is obtained from the task's input.
     * <p>
     * @param expression the JSON path expression with the task input. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.DockerImage fromJsonExpression(final @org.jetbrains.annotations.NotNull java.lang.String expression) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.tasks.DockerImage.class, "fromJsonExpression", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.DockerImage.class), new Object[] { java.util.Objects.requireNonNull(expression, "expression is required") });
    }

    /**
     * Reference a Docker image by it's URI.
     * <p>
     * When referencing ECR images, prefer using <code>inEcr</code>.
     * <p>
     * @param imageUri the URI to the docker image. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.DockerImage fromRegistry(final @org.jetbrains.annotations.NotNull java.lang.String imageUri) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.tasks.DockerImage.class, "fromRegistry", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.DockerImage.class), new Object[] { java.util.Objects.requireNonNull(imageUri, "imageUri is required") });
    }

    /**
     * Called when the image is used by a SageMaker task.
     * <p>
     * @param task This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.DockerImageConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.ISageMakerTask task);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.stepfunctions.tasks.DockerImage {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * Called when the image is used by a SageMaker task.
         * <p>
         * @param task This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.DockerImageConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.ISageMakerTask task) {
            return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.DockerImageConfig.class), new Object[] { java.util.Objects.requireNonNull(task, "task is required") });
        }
    }
}
