/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.dynamodb;

import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.RemovalPolicy;
import software.amazon.awscdk.services.dynamodb.Attribute;
import software.amazon.awscdk.services.dynamodb.BillingMode;
import software.amazon.awscdk.services.dynamodb.EnableScalingProps;
import software.amazon.awscdk.services.dynamodb.GlobalSecondaryIndexProps;
import software.amazon.awscdk.services.dynamodb.IScalableTableAttribute;
import software.amazon.awscdk.services.dynamodb.ITable;
import software.amazon.awscdk.services.dynamodb.ImportSourceSpecification;
import software.amazon.awscdk.services.dynamodb.LocalSecondaryIndexProps;
import software.amazon.awscdk.services.dynamodb.SchemaOptions;
import software.amazon.awscdk.services.dynamodb.StreamViewType;
import software.amazon.awscdk.services.dynamodb.TableAttributes;
import software.amazon.awscdk.services.dynamodb.TableBase;
import software.amazon.awscdk.services.dynamodb.TableClass;
import software.amazon.awscdk.services.dynamodb.TableEncryption;
import software.amazon.awscdk.services.dynamodb.TableProps;
import software.amazon.awscdk.services.iam.PolicyDocument;
import software.amazon.awscdk.services.kinesis.IStream;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_dynamodb.Table")
public class Table
extends TableBase {
    protected Table(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Table(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Table(@NotNull Construct scope, @NotNull String id, @NotNull TableProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static ITable fromTableArn(@NotNull Construct scope, @NotNull String id, @NotNull String tableArn) {
        return (ITable)JsiiObject.jsiiStaticCall(Table.class, (String)"fromTableArn", (NativeType)NativeType.forClass(ITable.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(tableArn, "tableArn is required")});
    }

    @NotNull
    public static ITable fromTableAttributes(@NotNull Construct scope, @NotNull String id, @NotNull TableAttributes attrs) {
        return (ITable)JsiiObject.jsiiStaticCall(Table.class, (String)"fromTableAttributes", (NativeType)NativeType.forClass(ITable.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @NotNull
    public static ITable fromTableName(@NotNull Construct scope, @NotNull String id, @NotNull String tableName) {
        return (ITable)JsiiObject.jsiiStaticCall(Table.class, (String)"fromTableName", (NativeType)NativeType.forClass(ITable.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(tableName, "tableName is required")});
    }

    public void addGlobalSecondaryIndex(@NotNull GlobalSecondaryIndexProps props) {
        Kernel.call((Object)this, (String)"addGlobalSecondaryIndex", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(props, "props is required")});
    }

    public void addLocalSecondaryIndex(@NotNull LocalSecondaryIndexProps props) {
        Kernel.call((Object)this, (String)"addLocalSecondaryIndex", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public IScalableTableAttribute autoScaleGlobalSecondaryIndexReadCapacity(@NotNull String indexName, @NotNull EnableScalingProps props) {
        return (IScalableTableAttribute)Kernel.call((Object)this, (String)"autoScaleGlobalSecondaryIndexReadCapacity", (NativeType)NativeType.forClass(IScalableTableAttribute.class), (Object[])new Object[]{Objects.requireNonNull(indexName, "indexName is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public IScalableTableAttribute autoScaleGlobalSecondaryIndexWriteCapacity(@NotNull String indexName, @NotNull EnableScalingProps props) {
        return (IScalableTableAttribute)Kernel.call((Object)this, (String)"autoScaleGlobalSecondaryIndexWriteCapacity", (NativeType)NativeType.forClass(IScalableTableAttribute.class), (Object[])new Object[]{Objects.requireNonNull(indexName, "indexName is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public IScalableTableAttribute autoScaleReadCapacity(@NotNull EnableScalingProps props) {
        return (IScalableTableAttribute)Kernel.call((Object)this, (String)"autoScaleReadCapacity", (NativeType)NativeType.forClass(IScalableTableAttribute.class), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public IScalableTableAttribute autoScaleWriteCapacity(@NotNull EnableScalingProps props) {
        return (IScalableTableAttribute)Kernel.call((Object)this, (String)"autoScaleWriteCapacity", (NativeType)NativeType.forClass(IScalableTableAttribute.class), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public SchemaOptions schema(@Nullable String indexName) {
        return (SchemaOptions)Kernel.call((Object)this, (String)"schema", (NativeType)NativeType.forClass(SchemaOptions.class), (Object[])new Object[]{indexName});
    }

    @NotNull
    public SchemaOptions schema() {
        return (SchemaOptions)Kernel.call((Object)this, (String)"schema", (NativeType)NativeType.forClass(SchemaOptions.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    protected Boolean getHasIndex() {
        return (Boolean)Kernel.get((Object)this, (String)"hasIndex", (NativeType)NativeType.forClass(Boolean.class));
    }

    @Override
    @NotNull
    public String getTableArn() {
        return (String)Kernel.get((Object)this, (String)"tableArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getTableName() {
        return (String)Kernel.get((Object)this, (String)"tableName", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @Nullable
    public IKey getEncryptionKey() {
        return (IKey)Kernel.get((Object)this, (String)"encryptionKey", (NativeType)NativeType.forClass(IKey.class));
    }

    @Override
    @Nullable
    public String getTableStreamArn() {
        return (String)Kernel.get((Object)this, (String)"tableStreamArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @Nullable
    public PolicyDocument getResourcePolicy() {
        return (PolicyDocument)Kernel.get((Object)this, (String)"resourcePolicy", (NativeType)NativeType.forClass(PolicyDocument.class));
    }

    @Override
    public void setResourcePolicy(@Nullable PolicyDocument value) {
        Kernel.set((Object)this, (String)"resourcePolicy", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Table> {
        private final Construct scope;
        private final String id;
        private final TableProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new TableProps.Builder();
        }

        public Builder partitionKey(Attribute partitionKey) {
            this.props.partitionKey(partitionKey);
            return this;
        }

        public Builder sortKey(Attribute sortKey) {
            this.props.sortKey(sortKey);
            return this;
        }

        public Builder billingMode(BillingMode billingMode) {
            this.props.billingMode(billingMode);
            return this;
        }

        public Builder contributorInsightsEnabled(Boolean contributorInsightsEnabled) {
            this.props.contributorInsightsEnabled(contributorInsightsEnabled);
            return this;
        }

        public Builder deletionProtection(Boolean deletionProtection) {
            this.props.deletionProtection(deletionProtection);
            return this;
        }

        public Builder encryption(TableEncryption encryption) {
            this.props.encryption(encryption);
            return this;
        }

        public Builder encryptionKey(IKey encryptionKey) {
            this.props.encryptionKey(encryptionKey);
            return this;
        }

        public Builder importSource(ImportSourceSpecification importSource) {
            this.props.importSource(importSource);
            return this;
        }

        public Builder pointInTimeRecovery(Boolean pointInTimeRecovery) {
            this.props.pointInTimeRecovery(pointInTimeRecovery);
            return this;
        }

        public Builder readCapacity(Number readCapacity) {
            this.props.readCapacity(readCapacity);
            return this;
        }

        public Builder removalPolicy(RemovalPolicy removalPolicy) {
            this.props.removalPolicy(removalPolicy);
            return this;
        }

        public Builder replicationRegions(List<String> replicationRegions) {
            this.props.replicationRegions(replicationRegions);
            return this;
        }

        public Builder replicationTimeout(Duration replicationTimeout) {
            this.props.replicationTimeout(replicationTimeout);
            return this;
        }

        public Builder resourcePolicy(PolicyDocument resourcePolicy) {
            this.props.resourcePolicy(resourcePolicy);
            return this;
        }

        public Builder stream(StreamViewType stream) {
            this.props.stream(stream);
            return this;
        }

        public Builder tableClass(TableClass tableClass) {
            this.props.tableClass(tableClass);
            return this;
        }

        public Builder timeToLiveAttribute(String timeToLiveAttribute) {
            this.props.timeToLiveAttribute(timeToLiveAttribute);
            return this;
        }

        public Builder waitForReplicationToFinish(Boolean waitForReplicationToFinish) {
            this.props.waitForReplicationToFinish(waitForReplicationToFinish);
            return this;
        }

        public Builder writeCapacity(Number writeCapacity) {
            this.props.writeCapacity(writeCapacity);
            return this;
        }

        public Builder kinesisStream(IStream kinesisStream) {
            this.props.kinesisStream(kinesisStream);
            return this;
        }

        public Builder tableName(String tableName) {
            this.props.tableName(tableName);
            return this;
        }

        public Table build() {
            return new Table(this.scope, this.id, this.props.build());
        }
    }
}

