/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.s3;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.ITaggableV2;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.s3.CfnAccessGrant;
import software.amazon.awscdk.services.s3.CfnAccessGrantProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_s3.CfnAccessGrant")
public class CfnAccessGrant
extends CfnResource
implements IInspectable,
ITaggableV2 {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnAccessGrant.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnAccessGrant(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnAccessGrant(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnAccessGrant(@NotNull Construct scope, @NotNull String id, @NotNull CfnAccessGrantProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrAccessGrantArn() {
        return (String)Kernel.get((Object)this, (String)"attrAccessGrantArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrAccessGrantId() {
        return (String)Kernel.get((Object)this, (String)"attrAccessGrantId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrGrantScope() {
        return (String)Kernel.get((Object)this, (String)"attrGrantScope", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public TagManager getCdkTagManager() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"cdkTagManager", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public String getAccessGrantsLocationId() {
        return (String)Kernel.get((Object)this, (String)"accessGrantsLocationId", (NativeType)NativeType.forClass(String.class));
    }

    public void setAccessGrantsLocationId(@NotNull String value) {
        Kernel.set((Object)this, (String)"accessGrantsLocationId", (Object)Objects.requireNonNull(value, "accessGrantsLocationId is required"));
    }

    @NotNull
    public Object getGrantee() {
        return Kernel.get((Object)this, (String)"grantee", (NativeType)NativeType.forClass(Object.class));
    }

    public void setGrantee(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"grantee", (Object)Objects.requireNonNull(value, "grantee is required"));
    }

    public void setGrantee(@NotNull GranteeProperty value) {
        Kernel.set((Object)this, (String)"grantee", (Object)Objects.requireNonNull(value, "grantee is required"));
    }

    @NotNull
    public String getPermission() {
        return (String)Kernel.get((Object)this, (String)"permission", (NativeType)NativeType.forClass(String.class));
    }

    public void setPermission(@NotNull String value) {
        Kernel.set((Object)this, (String)"permission", (Object)Objects.requireNonNull(value, "permission is required"));
    }

    @Nullable
    public Object getAccessGrantsLocationConfiguration() {
        return Kernel.get((Object)this, (String)"accessGrantsLocationConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setAccessGrantsLocationConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"accessGrantsLocationConfiguration", (Object)value);
    }

    public void setAccessGrantsLocationConfiguration(@Nullable AccessGrantsLocationConfigurationProperty value) {
        Kernel.set((Object)this, (String)"accessGrantsLocationConfiguration", (Object)value);
    }

    @Nullable
    public String getApplicationArn() {
        return (String)Kernel.get((Object)this, (String)"applicationArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setApplicationArn(@Nullable String value) {
        Kernel.set((Object)this, (String)"applicationArn", (Object)value);
    }

    @Nullable
    public String getS3PrefixType() {
        return (String)Kernel.get((Object)this, (String)"s3PrefixType", (NativeType)NativeType.forClass(String.class));
    }

    public void setS3PrefixType(@Nullable String value) {
        Kernel.set((Object)this, (String)"s3PrefixType", (Object)value);
    }

    @Nullable
    public List<CfnTag> getTags() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(CfnTag.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setTags(@Nullable List<CfnTag> value) {
        Kernel.set((Object)this, (String)"tags", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnAccessGrant> {
        private final Construct scope;
        private final String id;
        private final CfnAccessGrantProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnAccessGrantProps.Builder();
        }

        public Builder accessGrantsLocationId(String accessGrantsLocationId) {
            this.props.accessGrantsLocationId(accessGrantsLocationId);
            return this;
        }

        public Builder grantee(IResolvable grantee) {
            this.props.grantee(grantee);
            return this;
        }

        public Builder grantee(GranteeProperty grantee) {
            this.props.grantee(grantee);
            return this;
        }

        public Builder permission(String permission) {
            this.props.permission(permission);
            return this;
        }

        public Builder accessGrantsLocationConfiguration(IResolvable accessGrantsLocationConfiguration) {
            this.props.accessGrantsLocationConfiguration(accessGrantsLocationConfiguration);
            return this;
        }

        public Builder accessGrantsLocationConfiguration(AccessGrantsLocationConfigurationProperty accessGrantsLocationConfiguration) {
            this.props.accessGrantsLocationConfiguration(accessGrantsLocationConfiguration);
            return this;
        }

        public Builder applicationArn(String applicationArn) {
            this.props.applicationArn(applicationArn);
            return this;
        }

        public Builder s3PrefixType(String s3PrefixType) {
            this.props.s3PrefixType(s3PrefixType);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnAccessGrant build() {
            return new CfnAccessGrant(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_s3.CfnAccessGrant.GranteeProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface GranteeProperty
    extends JsiiSerializable {
        @NotNull
        public String getGranteeIdentifier();

        @NotNull
        public String getGranteeType();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<GranteeProperty> {
            String granteeIdentifier;
            String granteeType;

            public Builder granteeIdentifier(String granteeIdentifier) {
                this.granteeIdentifier = granteeIdentifier;
                return this;
            }

            public Builder granteeType(String granteeType) {
                this.granteeType = granteeType;
                return this;
            }

            public GranteeProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_s3.CfnAccessGrant.AccessGrantsLocationConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AccessGrantsLocationConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getS3SubPrefix();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AccessGrantsLocationConfigurationProperty> {
            String s3SubPrefix;

            public Builder s3SubPrefix(String s3SubPrefix) {
                this.s3SubPrefix = s3SubPrefix;
                return this;
            }

            public AccessGrantsLocationConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

