/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.sagemaker;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.ITaggable;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.sagemaker.CfnDomain;
import software.amazon.awscdk.services.sagemaker.CfnDomainProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnDomain")
public class CfnDomain
extends CfnResource
implements IInspectable,
ITaggable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnDomain.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnDomain(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDomain(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnDomain(@NotNull Construct scope, @NotNull String id, @NotNull CfnDomainProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrDomainArn() {
        return (String)Kernel.get((Object)this, (String)"attrDomainArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrDomainId() {
        return (String)Kernel.get((Object)this, (String)"attrDomainId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrHomeEfsFileSystemId() {
        return (String)Kernel.get((Object)this, (String)"attrHomeEfsFileSystemId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrSecurityGroupIdForDomainBoundary() {
        return (String)Kernel.get((Object)this, (String)"attrSecurityGroupIdForDomainBoundary", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrSingleSignOnApplicationArn() {
        return (String)Kernel.get((Object)this, (String)"attrSingleSignOnApplicationArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrSingleSignOnManagedApplicationInstanceId() {
        return (String)Kernel.get((Object)this, (String)"attrSingleSignOnManagedApplicationInstanceId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrUrl() {
        return (String)Kernel.get((Object)this, (String)"attrUrl", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @Override
    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public String getAuthMode() {
        return (String)Kernel.get((Object)this, (String)"authMode", (NativeType)NativeType.forClass(String.class));
    }

    public void setAuthMode(@NotNull String value) {
        Kernel.set((Object)this, (String)"authMode", (Object)Objects.requireNonNull(value, "authMode is required"));
    }

    @NotNull
    public Object getDefaultUserSettings() {
        return Kernel.get((Object)this, (String)"defaultUserSettings", (NativeType)NativeType.forClass(Object.class));
    }

    public void setDefaultUserSettings(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"defaultUserSettings", (Object)Objects.requireNonNull(value, "defaultUserSettings is required"));
    }

    public void setDefaultUserSettings(@NotNull UserSettingsProperty value) {
        Kernel.set((Object)this, (String)"defaultUserSettings", (Object)Objects.requireNonNull(value, "defaultUserSettings is required"));
    }

    @NotNull
    public String getDomainName() {
        return (String)Kernel.get((Object)this, (String)"domainName", (NativeType)NativeType.forClass(String.class));
    }

    public void setDomainName(@NotNull String value) {
        Kernel.set((Object)this, (String)"domainName", (Object)Objects.requireNonNull(value, "domainName is required"));
    }

    @NotNull
    public List<String> getSubnetIds() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"subnetIds", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class))));
    }

    public void setSubnetIds(@NotNull List<String> value) {
        Kernel.set((Object)this, (String)"subnetIds", Objects.requireNonNull(value, "subnetIds is required"));
    }

    @NotNull
    public String getVpcId() {
        return (String)Kernel.get((Object)this, (String)"vpcId", (NativeType)NativeType.forClass(String.class));
    }

    public void setVpcId(@NotNull String value) {
        Kernel.set((Object)this, (String)"vpcId", (Object)Objects.requireNonNull(value, "vpcId is required"));
    }

    @Nullable
    public String getAppNetworkAccessType() {
        return (String)Kernel.get((Object)this, (String)"appNetworkAccessType", (NativeType)NativeType.forClass(String.class));
    }

    public void setAppNetworkAccessType(@Nullable String value) {
        Kernel.set((Object)this, (String)"appNetworkAccessType", (Object)value);
    }

    @Nullable
    public String getAppSecurityGroupManagement() {
        return (String)Kernel.get((Object)this, (String)"appSecurityGroupManagement", (NativeType)NativeType.forClass(String.class));
    }

    public void setAppSecurityGroupManagement(@Nullable String value) {
        Kernel.set((Object)this, (String)"appSecurityGroupManagement", (Object)value);
    }

    @Nullable
    public Object getDefaultSpaceSettings() {
        return Kernel.get((Object)this, (String)"defaultSpaceSettings", (NativeType)NativeType.forClass(Object.class));
    }

    public void setDefaultSpaceSettings(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"defaultSpaceSettings", (Object)value);
    }

    public void setDefaultSpaceSettings(@Nullable DefaultSpaceSettingsProperty value) {
        Kernel.set((Object)this, (String)"defaultSpaceSettings", (Object)value);
    }

    @Nullable
    public Object getDomainSettings() {
        return Kernel.get((Object)this, (String)"domainSettings", (NativeType)NativeType.forClass(Object.class));
    }

    public void setDomainSettings(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"domainSettings", (Object)value);
    }

    public void setDomainSettings(@Nullable DomainSettingsProperty value) {
        Kernel.set((Object)this, (String)"domainSettings", (Object)value);
    }

    @Nullable
    public String getKmsKeyId() {
        return (String)Kernel.get((Object)this, (String)"kmsKeyId", (NativeType)NativeType.forClass(String.class));
    }

    public void setKmsKeyId(@Nullable String value) {
        Kernel.set((Object)this, (String)"kmsKeyId", (Object)value);
    }

    @Nullable
    public List<CfnTag> getTagsRaw() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"tagsRaw", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(CfnTag.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setTagsRaw(@Nullable List<CfnTag> value) {
        Kernel.set((Object)this, (String)"tagsRaw", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnDomain> {
        private final Construct scope;
        private final String id;
        private final CfnDomainProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnDomainProps.Builder();
        }

        public Builder authMode(String authMode) {
            this.props.authMode(authMode);
            return this;
        }

        public Builder defaultUserSettings(IResolvable defaultUserSettings) {
            this.props.defaultUserSettings(defaultUserSettings);
            return this;
        }

        public Builder defaultUserSettings(UserSettingsProperty defaultUserSettings) {
            this.props.defaultUserSettings(defaultUserSettings);
            return this;
        }

        public Builder domainName(String domainName) {
            this.props.domainName(domainName);
            return this;
        }

        public Builder subnetIds(List<String> subnetIds) {
            this.props.subnetIds(subnetIds);
            return this;
        }

        public Builder vpcId(String vpcId) {
            this.props.vpcId(vpcId);
            return this;
        }

        public Builder appNetworkAccessType(String appNetworkAccessType) {
            this.props.appNetworkAccessType(appNetworkAccessType);
            return this;
        }

        public Builder appSecurityGroupManagement(String appSecurityGroupManagement) {
            this.props.appSecurityGroupManagement(appSecurityGroupManagement);
            return this;
        }

        public Builder defaultSpaceSettings(IResolvable defaultSpaceSettings) {
            this.props.defaultSpaceSettings(defaultSpaceSettings);
            return this;
        }

        public Builder defaultSpaceSettings(DefaultSpaceSettingsProperty defaultSpaceSettings) {
            this.props.defaultSpaceSettings(defaultSpaceSettings);
            return this;
        }

        public Builder domainSettings(IResolvable domainSettings) {
            this.props.domainSettings(domainSettings);
            return this;
        }

        public Builder domainSettings(DomainSettingsProperty domainSettings) {
            this.props.domainSettings(domainSettings);
            return this;
        }

        public Builder kmsKeyId(String kmsKeyId) {
            this.props.kmsKeyId(kmsKeyId);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnDomain build() {
            return new CfnDomain(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnDomain.UserSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface UserSettingsProperty
    extends JsiiSerializable {
        @NotNull
        public String getExecutionRole();

        @Nullable
        default public Object getCodeEditorAppSettings() {
            return null;
        }

        @Nullable
        default public Object getCustomFileSystemConfigs() {
            return null;
        }

        @Nullable
        default public Object getCustomPosixUserConfig() {
            return null;
        }

        @Nullable
        default public String getDefaultLandingUri() {
            return null;
        }

        @Nullable
        default public Object getJupyterLabAppSettings() {
            return null;
        }

        @Nullable
        default public Object getJupyterServerAppSettings() {
            return null;
        }

        @Nullable
        default public Object getKernelGatewayAppSettings() {
            return null;
        }

        @Nullable
        default public Object getRSessionAppSettings() {
            return null;
        }

        @Nullable
        default public Object getRStudioServerProAppSettings() {
            return null;
        }

        @Nullable
        default public List<String> getSecurityGroups() {
            return null;
        }

        @Nullable
        default public Object getSharingSettings() {
            return null;
        }

        @Nullable
        default public Object getSpaceStorageSettings() {
            return null;
        }

        @Nullable
        default public String getStudioWebPortal() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<UserSettingsProperty> {
            String executionRole;
            Object codeEditorAppSettings;
            Object customFileSystemConfigs;
            Object customPosixUserConfig;
            String defaultLandingUri;
            Object jupyterLabAppSettings;
            Object jupyterServerAppSettings;
            Object kernelGatewayAppSettings;
            Object rSessionAppSettings;
            Object rStudioServerProAppSettings;
            List<String> securityGroups;
            Object sharingSettings;
            Object spaceStorageSettings;
            String studioWebPortal;

            public Builder executionRole(String executionRole) {
                this.executionRole = executionRole;
                return this;
            }

            public Builder codeEditorAppSettings(IResolvable codeEditorAppSettings) {
                this.codeEditorAppSettings = codeEditorAppSettings;
                return this;
            }

            public Builder codeEditorAppSettings(CodeEditorAppSettingsProperty codeEditorAppSettings) {
                this.codeEditorAppSettings = codeEditorAppSettings;
                return this;
            }

            public Builder customFileSystemConfigs(IResolvable customFileSystemConfigs) {
                this.customFileSystemConfigs = customFileSystemConfigs;
                return this;
            }

            public Builder customFileSystemConfigs(List<? extends Object> customFileSystemConfigs) {
                this.customFileSystemConfigs = customFileSystemConfigs;
                return this;
            }

            public Builder customPosixUserConfig(IResolvable customPosixUserConfig) {
                this.customPosixUserConfig = customPosixUserConfig;
                return this;
            }

            public Builder customPosixUserConfig(CustomPosixUserConfigProperty customPosixUserConfig) {
                this.customPosixUserConfig = customPosixUserConfig;
                return this;
            }

            public Builder defaultLandingUri(String defaultLandingUri) {
                this.defaultLandingUri = defaultLandingUri;
                return this;
            }

            public Builder jupyterLabAppSettings(IResolvable jupyterLabAppSettings) {
                this.jupyterLabAppSettings = jupyterLabAppSettings;
                return this;
            }

            public Builder jupyterLabAppSettings(JupyterLabAppSettingsProperty jupyterLabAppSettings) {
                this.jupyterLabAppSettings = jupyterLabAppSettings;
                return this;
            }

            public Builder jupyterServerAppSettings(IResolvable jupyterServerAppSettings) {
                this.jupyterServerAppSettings = jupyterServerAppSettings;
                return this;
            }

            public Builder jupyterServerAppSettings(JupyterServerAppSettingsProperty jupyterServerAppSettings) {
                this.jupyterServerAppSettings = jupyterServerAppSettings;
                return this;
            }

            public Builder kernelGatewayAppSettings(IResolvable kernelGatewayAppSettings) {
                this.kernelGatewayAppSettings = kernelGatewayAppSettings;
                return this;
            }

            public Builder kernelGatewayAppSettings(KernelGatewayAppSettingsProperty kernelGatewayAppSettings) {
                this.kernelGatewayAppSettings = kernelGatewayAppSettings;
                return this;
            }

            public Builder rSessionAppSettings(IResolvable rSessionAppSettings) {
                this.rSessionAppSettings = rSessionAppSettings;
                return this;
            }

            public Builder rSessionAppSettings(RSessionAppSettingsProperty rSessionAppSettings) {
                this.rSessionAppSettings = rSessionAppSettings;
                return this;
            }

            public Builder rStudioServerProAppSettings(IResolvable rStudioServerProAppSettings) {
                this.rStudioServerProAppSettings = rStudioServerProAppSettings;
                return this;
            }

            public Builder rStudioServerProAppSettings(RStudioServerProAppSettingsProperty rStudioServerProAppSettings) {
                this.rStudioServerProAppSettings = rStudioServerProAppSettings;
                return this;
            }

            public Builder securityGroups(List<String> securityGroups) {
                this.securityGroups = securityGroups;
                return this;
            }

            public Builder sharingSettings(IResolvable sharingSettings) {
                this.sharingSettings = sharingSettings;
                return this;
            }

            public Builder sharingSettings(SharingSettingsProperty sharingSettings) {
                this.sharingSettings = sharingSettings;
                return this;
            }

            public Builder spaceStorageSettings(IResolvable spaceStorageSettings) {
                this.spaceStorageSettings = spaceStorageSettings;
                return this;
            }

            public Builder spaceStorageSettings(DefaultSpaceStorageSettingsProperty spaceStorageSettings) {
                this.spaceStorageSettings = spaceStorageSettings;
                return this;
            }

            public Builder studioWebPortal(String studioWebPortal) {
                this.studioWebPortal = studioWebPortal;
                return this;
            }

            public UserSettingsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnDomain.SharingSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SharingSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getNotebookOutputOption() {
            return null;
        }

        @Nullable
        default public String getS3KmsKeyId() {
            return null;
        }

        @Nullable
        default public String getS3OutputPath() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SharingSettingsProperty> {
            String notebookOutputOption;
            String s3KmsKeyId;
            String s3OutputPath;

            public Builder notebookOutputOption(String notebookOutputOption) {
                this.notebookOutputOption = notebookOutputOption;
                return this;
            }

            public Builder s3KmsKeyId(String s3KmsKeyId) {
                this.s3KmsKeyId = s3KmsKeyId;
                return this;
            }

            public Builder s3OutputPath(String s3OutputPath) {
                this.s3OutputPath = s3OutputPath;
                return this;
            }

            public SharingSettingsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnDomain.ResourceSpecProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ResourceSpecProperty
    extends JsiiSerializable {
        @Nullable
        default public String getInstanceType() {
            return null;
        }

        @Nullable
        default public String getLifecycleConfigArn() {
            return null;
        }

        @Nullable
        default public String getSageMakerImageArn() {
            return null;
        }

        @Nullable
        default public String getSageMakerImageVersionArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ResourceSpecProperty> {
            String instanceType;
            String lifecycleConfigArn;
            String sageMakerImageArn;
            String sageMakerImageVersionArn;

            public Builder instanceType(String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            public Builder lifecycleConfigArn(String lifecycleConfigArn) {
                this.lifecycleConfigArn = lifecycleConfigArn;
                return this;
            }

            public Builder sageMakerImageArn(String sageMakerImageArn) {
                this.sageMakerImageArn = sageMakerImageArn;
                return this;
            }

            public Builder sageMakerImageVersionArn(String sageMakerImageVersionArn) {
                this.sageMakerImageVersionArn = sageMakerImageVersionArn;
                return this;
            }

            public ResourceSpecProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnDomain.RStudioServerProDomainSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RStudioServerProDomainSettingsProperty
    extends JsiiSerializable {
        @NotNull
        public String getDomainExecutionRoleArn();

        @Nullable
        default public Object getDefaultResourceSpec() {
            return null;
        }

        @Nullable
        default public String getRStudioConnectUrl() {
            return null;
        }

        @Nullable
        default public String getRStudioPackageManagerUrl() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RStudioServerProDomainSettingsProperty> {
            String domainExecutionRoleArn;
            Object defaultResourceSpec;
            String rStudioConnectUrl;
            String rStudioPackageManagerUrl;

            public Builder domainExecutionRoleArn(String domainExecutionRoleArn) {
                this.domainExecutionRoleArn = domainExecutionRoleArn;
                return this;
            }

            public Builder defaultResourceSpec(IResolvable defaultResourceSpec) {
                this.defaultResourceSpec = defaultResourceSpec;
                return this;
            }

            public Builder defaultResourceSpec(ResourceSpecProperty defaultResourceSpec) {
                this.defaultResourceSpec = defaultResourceSpec;
                return this;
            }

            public Builder rStudioConnectUrl(String rStudioConnectUrl) {
                this.rStudioConnectUrl = rStudioConnectUrl;
                return this;
            }

            public Builder rStudioPackageManagerUrl(String rStudioPackageManagerUrl) {
                this.rStudioPackageManagerUrl = rStudioPackageManagerUrl;
                return this;
            }

            public RStudioServerProDomainSettingsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnDomain.RStudioServerProAppSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RStudioServerProAppSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAccessStatus() {
            return null;
        }

        @Nullable
        default public String getUserGroup() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RStudioServerProAppSettingsProperty> {
            String accessStatus;
            String userGroup;

            public Builder accessStatus(String accessStatus) {
                this.accessStatus = accessStatus;
                return this;
            }

            public Builder userGroup(String userGroup) {
                this.userGroup = userGroup;
                return this;
            }

            public RStudioServerProAppSettingsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnDomain.RSessionAppSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RSessionAppSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCustomImages() {
            return null;
        }

        @Nullable
        default public Object getDefaultResourceSpec() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RSessionAppSettingsProperty> {
            Object customImages;
            Object defaultResourceSpec;

            public Builder customImages(IResolvable customImages) {
                this.customImages = customImages;
                return this;
            }

            public Builder customImages(List<? extends Object> customImages) {
                this.customImages = customImages;
                return this;
            }

            public Builder defaultResourceSpec(IResolvable defaultResourceSpec) {
                this.defaultResourceSpec = defaultResourceSpec;
                return this;
            }

            public Builder defaultResourceSpec(ResourceSpecProperty defaultResourceSpec) {
                this.defaultResourceSpec = defaultResourceSpec;
                return this;
            }

            public RSessionAppSettingsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnDomain.KernelGatewayAppSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface KernelGatewayAppSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCustomImages() {
            return null;
        }

        @Nullable
        default public Object getDefaultResourceSpec() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<KernelGatewayAppSettingsProperty> {
            Object customImages;
            Object defaultResourceSpec;

            public Builder customImages(IResolvable customImages) {
                this.customImages = customImages;
                return this;
            }

            public Builder customImages(List<? extends Object> customImages) {
                this.customImages = customImages;
                return this;
            }

            public Builder defaultResourceSpec(IResolvable defaultResourceSpec) {
                this.defaultResourceSpec = defaultResourceSpec;
                return this;
            }

            public Builder defaultResourceSpec(ResourceSpecProperty defaultResourceSpec) {
                this.defaultResourceSpec = defaultResourceSpec;
                return this;
            }

            public KernelGatewayAppSettingsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnDomain.JupyterServerAppSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface JupyterServerAppSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDefaultResourceSpec() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<JupyterServerAppSettingsProperty> {
            Object defaultResourceSpec;

            public Builder defaultResourceSpec(IResolvable defaultResourceSpec) {
                this.defaultResourceSpec = defaultResourceSpec;
                return this;
            }

            public Builder defaultResourceSpec(ResourceSpecProperty defaultResourceSpec) {
                this.defaultResourceSpec = defaultResourceSpec;
                return this;
            }

            public JupyterServerAppSettingsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnDomain.JupyterLabAppSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface JupyterLabAppSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCodeRepositories() {
            return null;
        }

        @Nullable
        default public Object getCustomImages() {
            return null;
        }

        @Nullable
        default public Object getDefaultResourceSpec() {
            return null;
        }

        @Nullable
        default public List<String> getLifecycleConfigArns() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<JupyterLabAppSettingsProperty> {
            Object codeRepositories;
            Object customImages;
            Object defaultResourceSpec;
            List<String> lifecycleConfigArns;

            public Builder codeRepositories(IResolvable codeRepositories) {
                this.codeRepositories = codeRepositories;
                return this;
            }

            public Builder codeRepositories(List<? extends Object> codeRepositories) {
                this.codeRepositories = codeRepositories;
                return this;
            }

            public Builder customImages(IResolvable customImages) {
                this.customImages = customImages;
                return this;
            }

            public Builder customImages(List<? extends Object> customImages) {
                this.customImages = customImages;
                return this;
            }

            public Builder defaultResourceSpec(IResolvable defaultResourceSpec) {
                this.defaultResourceSpec = defaultResourceSpec;
                return this;
            }

            public Builder defaultResourceSpec(ResourceSpecProperty defaultResourceSpec) {
                this.defaultResourceSpec = defaultResourceSpec;
                return this;
            }

            public Builder lifecycleConfigArns(List<String> lifecycleConfigArns) {
                this.lifecycleConfigArns = lifecycleConfigArns;
                return this;
            }

            public JupyterLabAppSettingsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnDomain.EFSFileSystemConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EFSFileSystemConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getFileSystemId();

        @Nullable
        default public String getFileSystemPath() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EFSFileSystemConfigProperty> {
            String fileSystemId;
            String fileSystemPath;

            public Builder fileSystemId(String fileSystemId) {
                this.fileSystemId = fileSystemId;
                return this;
            }

            public Builder fileSystemPath(String fileSystemPath) {
                this.fileSystemPath = fileSystemPath;
                return this;
            }

            public EFSFileSystemConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnDomain.DomainSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DomainSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDockerSettings() {
            return null;
        }

        @Nullable
        default public Object getRStudioServerProDomainSettings() {
            return null;
        }

        @Nullable
        default public List<String> getSecurityGroupIds() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DomainSettingsProperty> {
            Object dockerSettings;
            Object rStudioServerProDomainSettings;
            List<String> securityGroupIds;

            public Builder dockerSettings(IResolvable dockerSettings) {
                this.dockerSettings = dockerSettings;
                return this;
            }

            public Builder dockerSettings(DockerSettingsProperty dockerSettings) {
                this.dockerSettings = dockerSettings;
                return this;
            }

            public Builder rStudioServerProDomainSettings(IResolvable rStudioServerProDomainSettings) {
                this.rStudioServerProDomainSettings = rStudioServerProDomainSettings;
                return this;
            }

            public Builder rStudioServerProDomainSettings(RStudioServerProDomainSettingsProperty rStudioServerProDomainSettings) {
                this.rStudioServerProDomainSettings = rStudioServerProDomainSettings;
                return this;
            }

            public Builder securityGroupIds(List<String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            public DomainSettingsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnDomain.DockerSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DockerSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getEnableDockerAccess() {
            return null;
        }

        @Nullable
        default public List<String> getVpcOnlyTrustedAccounts() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DockerSettingsProperty> {
            String enableDockerAccess;
            List<String> vpcOnlyTrustedAccounts;

            public Builder enableDockerAccess(String enableDockerAccess) {
                this.enableDockerAccess = enableDockerAccess;
                return this;
            }

            public Builder vpcOnlyTrustedAccounts(List<String> vpcOnlyTrustedAccounts) {
                this.vpcOnlyTrustedAccounts = vpcOnlyTrustedAccounts;
                return this;
            }

            public DockerSettingsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnDomain.DefaultSpaceStorageSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DefaultSpaceStorageSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDefaultEbsStorageSettings() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DefaultSpaceStorageSettingsProperty> {
            Object defaultEbsStorageSettings;

            public Builder defaultEbsStorageSettings(IResolvable defaultEbsStorageSettings) {
                this.defaultEbsStorageSettings = defaultEbsStorageSettings;
                return this;
            }

            public Builder defaultEbsStorageSettings(DefaultEbsStorageSettingsProperty defaultEbsStorageSettings) {
                this.defaultEbsStorageSettings = defaultEbsStorageSettings;
                return this;
            }

            public DefaultSpaceStorageSettingsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnDomain.DefaultSpaceSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DefaultSpaceSettingsProperty
    extends JsiiSerializable {
        @NotNull
        public String getExecutionRole();

        @Nullable
        default public Object getCustomFileSystemConfigs() {
            return null;
        }

        @Nullable
        default public Object getCustomPosixUserConfig() {
            return null;
        }

        @Nullable
        default public Object getJupyterLabAppSettings() {
            return null;
        }

        @Nullable
        default public Object getJupyterServerAppSettings() {
            return null;
        }

        @Nullable
        default public Object getKernelGatewayAppSettings() {
            return null;
        }

        @Nullable
        default public List<String> getSecurityGroups() {
            return null;
        }

        @Nullable
        default public Object getSpaceStorageSettings() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DefaultSpaceSettingsProperty> {
            String executionRole;
            Object customFileSystemConfigs;
            Object customPosixUserConfig;
            Object jupyterLabAppSettings;
            Object jupyterServerAppSettings;
            Object kernelGatewayAppSettings;
            List<String> securityGroups;
            Object spaceStorageSettings;

            public Builder executionRole(String executionRole) {
                this.executionRole = executionRole;
                return this;
            }

            public Builder customFileSystemConfigs(IResolvable customFileSystemConfigs) {
                this.customFileSystemConfigs = customFileSystemConfigs;
                return this;
            }

            public Builder customFileSystemConfigs(List<? extends Object> customFileSystemConfigs) {
                this.customFileSystemConfigs = customFileSystemConfigs;
                return this;
            }

            public Builder customPosixUserConfig(IResolvable customPosixUserConfig) {
                this.customPosixUserConfig = customPosixUserConfig;
                return this;
            }

            public Builder customPosixUserConfig(CustomPosixUserConfigProperty customPosixUserConfig) {
                this.customPosixUserConfig = customPosixUserConfig;
                return this;
            }

            public Builder jupyterLabAppSettings(IResolvable jupyterLabAppSettings) {
                this.jupyterLabAppSettings = jupyterLabAppSettings;
                return this;
            }

            public Builder jupyterLabAppSettings(JupyterLabAppSettingsProperty jupyterLabAppSettings) {
                this.jupyterLabAppSettings = jupyterLabAppSettings;
                return this;
            }

            public Builder jupyterServerAppSettings(IResolvable jupyterServerAppSettings) {
                this.jupyterServerAppSettings = jupyterServerAppSettings;
                return this;
            }

            public Builder jupyterServerAppSettings(JupyterServerAppSettingsProperty jupyterServerAppSettings) {
                this.jupyterServerAppSettings = jupyterServerAppSettings;
                return this;
            }

            public Builder kernelGatewayAppSettings(IResolvable kernelGatewayAppSettings) {
                this.kernelGatewayAppSettings = kernelGatewayAppSettings;
                return this;
            }

            public Builder kernelGatewayAppSettings(KernelGatewayAppSettingsProperty kernelGatewayAppSettings) {
                this.kernelGatewayAppSettings = kernelGatewayAppSettings;
                return this;
            }

            public Builder securityGroups(List<String> securityGroups) {
                this.securityGroups = securityGroups;
                return this;
            }

            public Builder spaceStorageSettings(IResolvable spaceStorageSettings) {
                this.spaceStorageSettings = spaceStorageSettings;
                return this;
            }

            public Builder spaceStorageSettings(DefaultSpaceStorageSettingsProperty spaceStorageSettings) {
                this.spaceStorageSettings = spaceStorageSettings;
                return this;
            }

            public DefaultSpaceSettingsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnDomain.DefaultEbsStorageSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DefaultEbsStorageSettingsProperty
    extends JsiiSerializable {
        @NotNull
        public Number getDefaultEbsVolumeSizeInGb();

        @NotNull
        public Number getMaximumEbsVolumeSizeInGb();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DefaultEbsStorageSettingsProperty> {
            Number defaultEbsVolumeSizeInGb;
            Number maximumEbsVolumeSizeInGb;

            public Builder defaultEbsVolumeSizeInGb(Number defaultEbsVolumeSizeInGb) {
                this.defaultEbsVolumeSizeInGb = defaultEbsVolumeSizeInGb;
                return this;
            }

            public Builder maximumEbsVolumeSizeInGb(Number maximumEbsVolumeSizeInGb) {
                this.maximumEbsVolumeSizeInGb = maximumEbsVolumeSizeInGb;
                return this;
            }

            public DefaultEbsStorageSettingsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnDomain.CustomPosixUserConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CustomPosixUserConfigProperty
    extends JsiiSerializable {
        @NotNull
        public Number getGid();

        @NotNull
        public Number getUid();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CustomPosixUserConfigProperty> {
            Number gid;
            Number uid;

            public Builder gid(Number gid) {
                this.gid = gid;
                return this;
            }

            public Builder uid(Number uid) {
                this.uid = uid;
                return this;
            }

            public CustomPosixUserConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnDomain.CustomImageProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CustomImageProperty
    extends JsiiSerializable {
        @NotNull
        public String getAppImageConfigName();

        @NotNull
        public String getImageName();

        @Nullable
        default public Number getImageVersionNumber() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CustomImageProperty> {
            String appImageConfigName;
            String imageName;
            Number imageVersionNumber;

            public Builder appImageConfigName(String appImageConfigName) {
                this.appImageConfigName = appImageConfigName;
                return this;
            }

            public Builder imageName(String imageName) {
                this.imageName = imageName;
                return this;
            }

            public Builder imageVersionNumber(Number imageVersionNumber) {
                this.imageVersionNumber = imageVersionNumber;
                return this;
            }

            public CustomImageProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnDomain.CustomFileSystemConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CustomFileSystemConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getEfsFileSystemConfig() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CustomFileSystemConfigProperty> {
            Object efsFileSystemConfig;

            public Builder efsFileSystemConfig(IResolvable efsFileSystemConfig) {
                this.efsFileSystemConfig = efsFileSystemConfig;
                return this;
            }

            public Builder efsFileSystemConfig(EFSFileSystemConfigProperty efsFileSystemConfig) {
                this.efsFileSystemConfig = efsFileSystemConfig;
                return this;
            }

            public CustomFileSystemConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnDomain.CodeRepositoryProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CodeRepositoryProperty
    extends JsiiSerializable {
        @NotNull
        public String getRepositoryUrl();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CodeRepositoryProperty> {
            String repositoryUrl;

            public Builder repositoryUrl(String repositoryUrl) {
                this.repositoryUrl = repositoryUrl;
                return this;
            }

            public CodeRepositoryProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnDomain.CodeEditorAppSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CodeEditorAppSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCustomImages() {
            return null;
        }

        @Nullable
        default public Object getDefaultResourceSpec() {
            return null;
        }

        @Nullable
        default public List<String> getLifecycleConfigArns() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CodeEditorAppSettingsProperty> {
            Object customImages;
            Object defaultResourceSpec;
            List<String> lifecycleConfigArns;

            public Builder customImages(IResolvable customImages) {
                this.customImages = customImages;
                return this;
            }

            public Builder customImages(List<? extends Object> customImages) {
                this.customImages = customImages;
                return this;
            }

            public Builder defaultResourceSpec(IResolvable defaultResourceSpec) {
                this.defaultResourceSpec = defaultResourceSpec;
                return this;
            }

            public Builder defaultResourceSpec(ResourceSpecProperty defaultResourceSpec) {
                this.defaultResourceSpec = defaultResourceSpec;
                return this;
            }

            public Builder lifecycleConfigArns(List<String> lifecycleConfigArns) {
                this.lifecycleConfigArns = lifecycleConfigArns;
                return this;
            }

            public CodeEditorAppSettingsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

