package software.amazon.awscdk.assertions;

/**
 * Options to configure template parsing behavior, such as disregarding circular dependencies.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.assertions.*;
 * TemplateParsingOptions templateParsingOptions = TemplateParsingOptions.builder()
 *         .skipCyclicalDependenciesCheck(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-08-19T23:46:28.222Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.assertions.TemplateParsingOptions")
@software.amazon.jsii.Jsii.Proxy(TemplateParsingOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TemplateParsingOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * If set to true, will skip checking for cyclical / circular dependencies.
     * <p>
     * Should be set to false other than for
     * templates that are valid despite containing cycles, such as unprocessed transform stacks.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSkipCyclicalDependenciesCheck() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link TemplateParsingOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TemplateParsingOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<TemplateParsingOptions> {
        java.lang.Boolean skipCyclicalDependenciesCheck;

        /**
         * Sets the value of {@link TemplateParsingOptions#getSkipCyclicalDependenciesCheck}
         * @param skipCyclicalDependenciesCheck If set to true, will skip checking for cyclical / circular dependencies.
         *                                      Should be set to false other than for
         *                                      templates that are valid despite containing cycles, such as unprocessed transform stacks.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder skipCyclicalDependenciesCheck(java.lang.Boolean skipCyclicalDependenciesCheck) {
            this.skipCyclicalDependenciesCheck = skipCyclicalDependenciesCheck;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TemplateParsingOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public TemplateParsingOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link TemplateParsingOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TemplateParsingOptions {
        private final java.lang.Boolean skipCyclicalDependenciesCheck;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.skipCyclicalDependenciesCheck = software.amazon.jsii.Kernel.get(this, "skipCyclicalDependenciesCheck", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.skipCyclicalDependenciesCheck = builder.skipCyclicalDependenciesCheck;
        }

        @Override
        public final java.lang.Boolean getSkipCyclicalDependenciesCheck() {
            return this.skipCyclicalDependenciesCheck;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getSkipCyclicalDependenciesCheck() != null) {
                data.set("skipCyclicalDependenciesCheck", om.valueToTree(this.getSkipCyclicalDependenciesCheck()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.assertions.TemplateParsingOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TemplateParsingOptions.Jsii$Proxy that = (TemplateParsingOptions.Jsii$Proxy) o;

            return this.skipCyclicalDependenciesCheck != null ? this.skipCyclicalDependenciesCheck.equals(that.skipCyclicalDependenciesCheck) : that.skipCyclicalDependenciesCheck == null;
        }

        @Override
        public final int hashCode() {
            int result = this.skipCyclicalDependenciesCheck != null ? this.skipCyclicalDependenciesCheck.hashCode() : 0;
            return result;
        }
    }
}
