package software.amazon.awscdk.aws_apigatewayv2_integrations;

/**
 * Props for Lambda type integration for a WebSocket Api.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.apigatewayv2.*;
 * import software.amazon.awscdk.aws_apigatewayv2_integrations.*;
 * WebSocketLambdaIntegrationProps webSocketLambdaIntegrationProps = WebSocketLambdaIntegrationProps.builder()
 *         .contentHandling(ContentHandling.CONVERT_TO_BINARY)
 *         .timeout(Duration.minutes(30))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-08-19T23:46:28.808Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2_integrations.WebSocketLambdaIntegrationProps")
@software.amazon.jsii.Jsii.Proxy(WebSocketLambdaIntegrationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface WebSocketLambdaIntegrationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specifies how to handle response payload content type conversions.
     * <p>
     * Default: - The response payload will be passed through from the integration response to
     * the route response or method response without modification.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.ContentHandling getContentHandling() {
        return null;
    }

    /**
     * The maximum amount of time an integration will run before it returns without a response.
     * <p>
     * Must be between 50 milliseconds and 29 seconds.
     * <p>
     * Default: Duration.seconds(29)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getTimeout() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link WebSocketLambdaIntegrationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link WebSocketLambdaIntegrationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<WebSocketLambdaIntegrationProps> {
        software.amazon.awscdk.services.apigatewayv2.ContentHandling contentHandling;
        software.amazon.awscdk.Duration timeout;

        /**
         * Sets the value of {@link WebSocketLambdaIntegrationProps#getContentHandling}
         * @param contentHandling Specifies how to handle response payload content type conversions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentHandling(software.amazon.awscdk.services.apigatewayv2.ContentHandling contentHandling) {
            this.contentHandling = contentHandling;
            return this;
        }

        /**
         * Sets the value of {@link WebSocketLambdaIntegrationProps#getTimeout}
         * @param timeout The maximum amount of time an integration will run before it returns without a response.
         *                Must be between 50 milliseconds and 29 seconds.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(software.amazon.awscdk.Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link WebSocketLambdaIntegrationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public WebSocketLambdaIntegrationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link WebSocketLambdaIntegrationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WebSocketLambdaIntegrationProps {
        private final software.amazon.awscdk.services.apigatewayv2.ContentHandling contentHandling;
        private final software.amazon.awscdk.Duration timeout;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.contentHandling = software.amazon.jsii.Kernel.get(this, "contentHandling", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.ContentHandling.class));
            this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.contentHandling = builder.contentHandling;
            this.timeout = builder.timeout;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.ContentHandling getContentHandling() {
            return this.contentHandling;
        }

        @Override
        public final software.amazon.awscdk.Duration getTimeout() {
            return this.timeout;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getContentHandling() != null) {
                data.set("contentHandling", om.valueToTree(this.getContentHandling()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigatewayv2_integrations.WebSocketLambdaIntegrationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            WebSocketLambdaIntegrationProps.Jsii$Proxy that = (WebSocketLambdaIntegrationProps.Jsii$Proxy) o;

            if (this.contentHandling != null ? !this.contentHandling.equals(that.contentHandling) : that.contentHandling != null) return false;
            return this.timeout != null ? this.timeout.equals(that.timeout) : that.timeout == null;
        }

        @Override
        public final int hashCode() {
            int result = this.contentHandling != null ? this.contentHandling.hashCode() : 0;
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            return result;
        }
    }
}
