package software.amazon.awscdk.pipelines;

/**
 * A generic CDK Pipelines pipeline.
 * <p>
 * Different deployment systems will provide subclasses of <code>Pipeline</code> that generate
 * the deployment infrastructure necessary to deploy CDK apps, specific to that system.
 * <p>
 * This library comes with the <code>CodePipeline</code> class, which uses AWS CodePipeline
 * to deploy CDK apps.
 * <p>
 * The actual pipeline infrastructure is constructed (by invoking the engine)
 * when <code>buildPipeline()</code> is called, or when <code>app.synth()</code> is called (whichever
 * happens first).
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-08-19T23:46:42.360Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.pipelines.PipelineBase")
public abstract class PipelineBase extends software.constructs.Construct {

    protected PipelineBase(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected PipelineBase(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected PipelineBase(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.PipelineBaseProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Return whether the given object extends <code>PipelineBase</code>.
     * <p>
     * We do attribute detection since we can't reliably use 'instanceof'.
     * <p>
     * @param x This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isPipeline(final @org.jetbrains.annotations.NotNull java.lang.Object x) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.pipelines.PipelineBase.class, "isPipeline", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { x });
    }

    /**
     * Deploy a single Stage by itself.
     * <p>
     * Add a Stage to the pipeline, to be deployed in sequence with other
     * Stages added to the pipeline. All Stacks in the stage will be deployed
     * in an order automatically determined by their relative dependencies.
     * <p>
     * @param stage This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.StageDeployment addStage(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stage stage, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.pipelines.AddStageOpts options) {
        return software.amazon.jsii.Kernel.call(this, "addStage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.StageDeployment.class), new Object[] { java.util.Objects.requireNonNull(stage, "stage is required"), options });
    }

    /**
     * Deploy a single Stage by itself.
     * <p>
     * Add a Stage to the pipeline, to be deployed in sequence with other
     * Stages added to the pipeline. All Stacks in the stage will be deployed
     * in an order automatically determined by their relative dependencies.
     * <p>
     * @param stage This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.StageDeployment addStage(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stage stage) {
        return software.amazon.jsii.Kernel.call(this, "addStage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.StageDeployment.class), new Object[] { java.util.Objects.requireNonNull(stage, "stage is required") });
    }

    /**
     * Add a Wave to the pipeline, for deploying multiple Stages in parallel.
     * <p>
     * Use the return object of this method to deploy multiple stages in parallel.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * CodePipeline pipeline;
     * Wave wave = pipeline.addWave("MyWave");
     * wave.addStage(new MyApplicationStage(this, "Stage1"));
     * wave.addStage(new MyApplicationStage(this, "Stage2"));
     * </pre></blockquote>
     * <p>
     * @param id This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.Wave addWave(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.pipelines.WaveOptions options) {
        return software.amazon.jsii.Kernel.call(this, "addWave", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.Wave.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
    }

    /**
     * Add a Wave to the pipeline, for deploying multiple Stages in parallel.
     * <p>
     * Use the return object of this method to deploy multiple stages in parallel.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * CodePipeline pipeline;
     * Wave wave = pipeline.addWave("MyWave");
     * wave.addStage(new MyApplicationStage(this, "Stage1"));
     * wave.addStage(new MyApplicationStage(this, "Stage2"));
     * </pre></blockquote>
     * <p>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.Wave addWave(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.Kernel.call(this, "addWave", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.Wave.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Send the current pipeline definition to the engine, and construct the pipeline.
     * <p>
     * It is not possible to modify the pipeline after calling this method.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void buildPipeline() {
        software.amazon.jsii.Kernel.call(this, "buildPipeline", software.amazon.jsii.NativeType.VOID);
    }

    /**
     * Implemented by subclasses to do the actual pipeline construction.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected abstract void doBuildPipeline();

    /**
     * The FileSet tha contains the cloud assembly.
     * <p>
     * This is the primary output of the synth step.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.FileSet getCloudAssemblyFileSet() {
        return software.amazon.jsii.Kernel.get(this, "cloudAssemblyFileSet", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.FileSet.class));
    }

    /**
     * The build step that produces the CDK Cloud Assembly.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.IFileSetProducer getSynth() {
        return software.amazon.jsii.Kernel.get(this, "synth", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.IFileSetProducer.class));
    }

    /**
     * The waves in this pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.pipelines.Wave> getWaves() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "waves", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.Wave.class))));
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.pipelines.PipelineBase implements software.constructs.IConstruct.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * Implemented by subclasses to do the actual pipeline construction.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        protected final void doBuildPipeline() {
            software.amazon.jsii.Kernel.call(this, "doBuildPipeline", software.amazon.jsii.NativeType.VOID);
        }
    }
}
