package software.amazon.awscdk.pipelines;

/**
 * Instructions for additional steps that are run at stack level.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.pipelines.*;
 * Stack stack;
 * Step step;
 * StackSteps stackSteps = StackSteps.builder()
 *         .stack(stack)
 *         // the properties below are optional
 *         .changeSet(List.of(step))
 *         .post(List.of(step))
 *         .pre(List.of(step))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-08-19T23:46:42.368Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.pipelines.StackSteps")
@software.amazon.jsii.Jsii.Proxy(StackSteps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface StackSteps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The stack you want the steps to run in.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stack getStack();

    /**
     * Steps that execute after stack is prepared but before stack is deployed.
     * <p>
     * Default: - no additional steps
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.pipelines.Step> getChangeSet() {
        return null;
    }

    /**
     * Steps that execute after stack is deployed.
     * <p>
     * Default: - no additional steps
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.pipelines.Step> getPost() {
        return null;
    }

    /**
     * Steps that execute before stack is prepared.
     * <p>
     * Default: - no additional steps
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.pipelines.Step> getPre() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link StackSteps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link StackSteps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<StackSteps> {
        software.amazon.awscdk.Stack stack;
        java.util.List<software.amazon.awscdk.pipelines.Step> changeSet;
        java.util.List<software.amazon.awscdk.pipelines.Step> post;
        java.util.List<software.amazon.awscdk.pipelines.Step> pre;

        /**
         * Sets the value of {@link StackSteps#getStack}
         * @param stack The stack you want the steps to run in. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stack(software.amazon.awscdk.Stack stack) {
            this.stack = stack;
            return this;
        }

        /**
         * Sets the value of {@link StackSteps#getChangeSet}
         * @param changeSet Steps that execute after stack is prepared but before stack is deployed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder changeSet(java.util.List<? extends software.amazon.awscdk.pipelines.Step> changeSet) {
            this.changeSet = (java.util.List<software.amazon.awscdk.pipelines.Step>)changeSet;
            return this;
        }

        /**
         * Sets the value of {@link StackSteps#getPost}
         * @param post Steps that execute after stack is deployed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder post(java.util.List<? extends software.amazon.awscdk.pipelines.Step> post) {
            this.post = (java.util.List<software.amazon.awscdk.pipelines.Step>)post;
            return this;
        }

        /**
         * Sets the value of {@link StackSteps#getPre}
         * @param pre Steps that execute before stack is prepared.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder pre(java.util.List<? extends software.amazon.awscdk.pipelines.Step> pre) {
            this.pre = (java.util.List<software.amazon.awscdk.pipelines.Step>)pre;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link StackSteps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public StackSteps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link StackSteps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StackSteps {
        private final software.amazon.awscdk.Stack stack;
        private final java.util.List<software.amazon.awscdk.pipelines.Step> changeSet;
        private final java.util.List<software.amazon.awscdk.pipelines.Step> post;
        private final java.util.List<software.amazon.awscdk.pipelines.Step> pre;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.stack = software.amazon.jsii.Kernel.get(this, "stack", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Stack.class));
            this.changeSet = software.amazon.jsii.Kernel.get(this, "changeSet", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.Step.class)));
            this.post = software.amazon.jsii.Kernel.get(this, "post", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.Step.class)));
            this.pre = software.amazon.jsii.Kernel.get(this, "pre", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.Step.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.stack = java.util.Objects.requireNonNull(builder.stack, "stack is required");
            this.changeSet = (java.util.List<software.amazon.awscdk.pipelines.Step>)builder.changeSet;
            this.post = (java.util.List<software.amazon.awscdk.pipelines.Step>)builder.post;
            this.pre = (java.util.List<software.amazon.awscdk.pipelines.Step>)builder.pre;
        }

        @Override
        public final software.amazon.awscdk.Stack getStack() {
            return this.stack;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.pipelines.Step> getChangeSet() {
            return this.changeSet;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.pipelines.Step> getPost() {
            return this.post;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.pipelines.Step> getPre() {
            return this.pre;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("stack", om.valueToTree(this.getStack()));
            if (this.getChangeSet() != null) {
                data.set("changeSet", om.valueToTree(this.getChangeSet()));
            }
            if (this.getPost() != null) {
                data.set("post", om.valueToTree(this.getPost()));
            }
            if (this.getPre() != null) {
                data.set("pre", om.valueToTree(this.getPre()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.pipelines.StackSteps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            StackSteps.Jsii$Proxy that = (StackSteps.Jsii$Proxy) o;

            if (!stack.equals(that.stack)) return false;
            if (this.changeSet != null ? !this.changeSet.equals(that.changeSet) : that.changeSet != null) return false;
            if (this.post != null ? !this.post.equals(that.post) : that.post != null) return false;
            return this.pre != null ? this.pre.equals(that.pre) : that.pre == null;
        }

        @Override
        public final int hashCode() {
            int result = this.stack.hashCode();
            result = 31 * result + (this.changeSet != null ? this.changeSet.hashCode() : 0);
            result = 31 * result + (this.post != null ? this.post.hashCode() : 0);
            result = 31 * result + (this.pre != null ? this.pre.hashCode() : 0);
            return result;
        }
    }
}
