package software.amazon.awscdk.services.amplifyuibuilder;

/**
 * Properties for defining a <code>CfnComponent</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-08-19T23:46:28.345Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_amplifyuibuilder.CfnComponentProps")
@software.amazon.jsii.Jsii.Proxy(CfnComponentProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnComponentProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The unique ID of the Amplify app associated with the component.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-appid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-appid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAppId() {
        return null;
    }

    /**
     * The information to connect a component's properties to data at runtime.
     * <p>
     * You can't specify <code>tags</code> as a valid property for <code>bindingProperties</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-bindingproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-bindingproperties</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getBindingProperties() {
        return null;
    }

    /**
     * A list of the component's <code>ComponentChild</code> instances.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-children">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-children</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getChildren() {
        return null;
    }

    /**
     * The data binding configuration for the component's properties.
     * <p>
     * Use this for a collection component. You can't specify <code>tags</code> as a valid property for <code>collectionProperties</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-collectionproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-collectionproperties</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCollectionProperties() {
        return null;
    }

    /**
     * The type of the component.
     * <p>
     * This can be an Amplify custom UI component or another custom component.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-componenttype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-componenttype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getComponentType() {
        return null;
    }

    /**
     * The name of the backend environment that is a part of the Amplify app.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-environmentname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-environmentname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEnvironmentName() {
        return null;
    }

    /**
     * Describes the events that can be raised on the component.
     * <p>
     * Use for the workflow feature in Amplify Studio that allows you to bind events and actions to components.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-events">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-events</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEvents() {
        return null;
    }

    /**
     * The name of the component.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * Describes the component's properties that can be overriden in a customized instance of the component.
     * <p>
     * You can't specify <code>tags</code> as a valid property for <code>overrides</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-overrides">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-overrides</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getOverrides() {
        return null;
    }

    /**
     * Describes the component's properties.
     * <p>
     * You can't specify <code>tags</code> as a valid property for <code>properties</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-properties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-properties</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getProperties() {
        return null;
    }

    /**
     * The schema version of the component when it was imported.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-schemaversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-schemaversion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSchemaVersion() {
        return null;
    }

    /**
     * The unique ID of the component in its original source system, such as Figma.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-sourceid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-sourceid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSourceId() {
        return null;
    }

    /**
     * One or more key-value pairs to use when tagging the component.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * A list of the component's variants.
     * <p>
     * A variant is a unique style configuration of a main component.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-variants">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-variants</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getVariants() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnComponentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnComponentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnComponentProps> {
        java.lang.String appId;
        java.lang.Object bindingProperties;
        java.lang.Object children;
        java.lang.Object collectionProperties;
        java.lang.String componentType;
        java.lang.String environmentName;
        java.lang.Object events;
        java.lang.String name;
        java.lang.Object overrides;
        java.lang.Object properties;
        java.lang.String schemaVersion;
        java.lang.String sourceId;
        java.util.Map<java.lang.String, java.lang.String> tags;
        java.lang.Object variants;

        /**
         * Sets the value of {@link CfnComponentProps#getAppId}
         * @param appId The unique ID of the Amplify app associated with the component.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder appId(java.lang.String appId) {
            this.appId = appId;
            return this;
        }

        /**
         * Sets the value of {@link CfnComponentProps#getBindingProperties}
         * @param bindingProperties The information to connect a component's properties to data at runtime.
         *                          You can't specify <code>tags</code> as a valid property for <code>bindingProperties</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bindingProperties(software.amazon.awscdk.IResolvable bindingProperties) {
            this.bindingProperties = bindingProperties;
            return this;
        }

        /**
         * Sets the value of {@link CfnComponentProps#getBindingProperties}
         * @param bindingProperties The information to connect a component's properties to data at runtime.
         *                          You can't specify <code>tags</code> as a valid property for <code>bindingProperties</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bindingProperties(java.util.Map<java.lang.String, ? extends java.lang.Object> bindingProperties) {
            this.bindingProperties = bindingProperties;
            return this;
        }

        /**
         * Sets the value of {@link CfnComponentProps#getChildren}
         * @param children A list of the component's <code>ComponentChild</code> instances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder children(software.amazon.awscdk.IResolvable children) {
            this.children = children;
            return this;
        }

        /**
         * Sets the value of {@link CfnComponentProps#getChildren}
         * @param children A list of the component's <code>ComponentChild</code> instances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder children(java.util.List<? extends java.lang.Object> children) {
            this.children = children;
            return this;
        }

        /**
         * Sets the value of {@link CfnComponentProps#getCollectionProperties}
         * @param collectionProperties The data binding configuration for the component's properties.
         *                             Use this for a collection component. You can't specify <code>tags</code> as a valid property for <code>collectionProperties</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder collectionProperties(software.amazon.awscdk.IResolvable collectionProperties) {
            this.collectionProperties = collectionProperties;
            return this;
        }

        /**
         * Sets the value of {@link CfnComponentProps#getCollectionProperties}
         * @param collectionProperties The data binding configuration for the component's properties.
         *                             Use this for a collection component. You can't specify <code>tags</code> as a valid property for <code>collectionProperties</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder collectionProperties(java.util.Map<java.lang.String, ? extends java.lang.Object> collectionProperties) {
            this.collectionProperties = collectionProperties;
            return this;
        }

        /**
         * Sets the value of {@link CfnComponentProps#getComponentType}
         * @param componentType The type of the component.
         *                      This can be an Amplify custom UI component or another custom component.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder componentType(java.lang.String componentType) {
            this.componentType = componentType;
            return this;
        }

        /**
         * Sets the value of {@link CfnComponentProps#getEnvironmentName}
         * @param environmentName The name of the backend environment that is a part of the Amplify app.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentName(java.lang.String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        /**
         * Sets the value of {@link CfnComponentProps#getEvents}
         * @param events Describes the events that can be raised on the component.
         *               Use for the workflow feature in Amplify Studio that allows you to bind events and actions to components.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder events(software.amazon.awscdk.IResolvable events) {
            this.events = events;
            return this;
        }

        /**
         * Sets the value of {@link CfnComponentProps#getEvents}
         * @param events Describes the events that can be raised on the component.
         *               Use for the workflow feature in Amplify Studio that allows you to bind events and actions to components.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder events(java.util.Map<java.lang.String, ? extends java.lang.Object> events) {
            this.events = events;
            return this;
        }

        /**
         * Sets the value of {@link CfnComponentProps#getName}
         * @param name The name of the component.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnComponentProps#getOverrides}
         * @param overrides Describes the component's properties that can be overriden in a customized instance of the component.
         *                  You can't specify <code>tags</code> as a valid property for <code>overrides</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder overrides(java.lang.Object overrides) {
            this.overrides = overrides;
            return this;
        }

        /**
         * Sets the value of {@link CfnComponentProps#getProperties}
         * @param properties Describes the component's properties.
         *                   You can't specify <code>tags</code> as a valid property for <code>properties</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder properties(software.amazon.awscdk.IResolvable properties) {
            this.properties = properties;
            return this;
        }

        /**
         * Sets the value of {@link CfnComponentProps#getProperties}
         * @param properties Describes the component's properties.
         *                   You can't specify <code>tags</code> as a valid property for <code>properties</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder properties(java.util.Map<java.lang.String, ? extends java.lang.Object> properties) {
            this.properties = properties;
            return this;
        }

        /**
         * Sets the value of {@link CfnComponentProps#getSchemaVersion}
         * @param schemaVersion The schema version of the component when it was imported.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schemaVersion(java.lang.String schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnComponentProps#getSourceId}
         * @param sourceId The unique ID of the component in its original source system, such as Figma.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceId(java.lang.String sourceId) {
            this.sourceId = sourceId;
            return this;
        }

        /**
         * Sets the value of {@link CfnComponentProps#getTags}
         * @param tags One or more key-value pairs to use when tagging the component.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnComponentProps#getVariants}
         * @param variants A list of the component's variants.
         *                 A variant is a unique style configuration of a main component.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder variants(software.amazon.awscdk.IResolvable variants) {
            this.variants = variants;
            return this;
        }

        /**
         * Sets the value of {@link CfnComponentProps#getVariants}
         * @param variants A list of the component's variants.
         *                 A variant is a unique style configuration of a main component.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder variants(java.util.List<? extends java.lang.Object> variants) {
            this.variants = variants;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnComponentProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnComponentProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnComponentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnComponentProps {
        private final java.lang.String appId;
        private final java.lang.Object bindingProperties;
        private final java.lang.Object children;
        private final java.lang.Object collectionProperties;
        private final java.lang.String componentType;
        private final java.lang.String environmentName;
        private final java.lang.Object events;
        private final java.lang.String name;
        private final java.lang.Object overrides;
        private final java.lang.Object properties;
        private final java.lang.String schemaVersion;
        private final java.lang.String sourceId;
        private final java.util.Map<java.lang.String, java.lang.String> tags;
        private final java.lang.Object variants;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.appId = software.amazon.jsii.Kernel.get(this, "appId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.bindingProperties = software.amazon.jsii.Kernel.get(this, "bindingProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.children = software.amazon.jsii.Kernel.get(this, "children", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.collectionProperties = software.amazon.jsii.Kernel.get(this, "collectionProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.componentType = software.amazon.jsii.Kernel.get(this, "componentType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.environmentName = software.amazon.jsii.Kernel.get(this, "environmentName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.events = software.amazon.jsii.Kernel.get(this, "events", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.overrides = software.amazon.jsii.Kernel.get(this, "overrides", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.properties = software.amazon.jsii.Kernel.get(this, "properties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.schemaVersion = software.amazon.jsii.Kernel.get(this, "schemaVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sourceId = software.amazon.jsii.Kernel.get(this, "sourceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.variants = software.amazon.jsii.Kernel.get(this, "variants", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.appId = builder.appId;
            this.bindingProperties = builder.bindingProperties;
            this.children = builder.children;
            this.collectionProperties = builder.collectionProperties;
            this.componentType = builder.componentType;
            this.environmentName = builder.environmentName;
            this.events = builder.events;
            this.name = builder.name;
            this.overrides = builder.overrides;
            this.properties = builder.properties;
            this.schemaVersion = builder.schemaVersion;
            this.sourceId = builder.sourceId;
            this.tags = builder.tags;
            this.variants = builder.variants;
        }

        @Override
        public final java.lang.String getAppId() {
            return this.appId;
        }

        @Override
        public final java.lang.Object getBindingProperties() {
            return this.bindingProperties;
        }

        @Override
        public final java.lang.Object getChildren() {
            return this.children;
        }

        @Override
        public final java.lang.Object getCollectionProperties() {
            return this.collectionProperties;
        }

        @Override
        public final java.lang.String getComponentType() {
            return this.componentType;
        }

        @Override
        public final java.lang.String getEnvironmentName() {
            return this.environmentName;
        }

        @Override
        public final java.lang.Object getEvents() {
            return this.events;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getOverrides() {
            return this.overrides;
        }

        @Override
        public final java.lang.Object getProperties() {
            return this.properties;
        }

        @Override
        public final java.lang.String getSchemaVersion() {
            return this.schemaVersion;
        }

        @Override
        public final java.lang.String getSourceId() {
            return this.sourceId;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getVariants() {
            return this.variants;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAppId() != null) {
                data.set("appId", om.valueToTree(this.getAppId()));
            }
            if (this.getBindingProperties() != null) {
                data.set("bindingProperties", om.valueToTree(this.getBindingProperties()));
            }
            if (this.getChildren() != null) {
                data.set("children", om.valueToTree(this.getChildren()));
            }
            if (this.getCollectionProperties() != null) {
                data.set("collectionProperties", om.valueToTree(this.getCollectionProperties()));
            }
            if (this.getComponentType() != null) {
                data.set("componentType", om.valueToTree(this.getComponentType()));
            }
            if (this.getEnvironmentName() != null) {
                data.set("environmentName", om.valueToTree(this.getEnvironmentName()));
            }
            if (this.getEvents() != null) {
                data.set("events", om.valueToTree(this.getEvents()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getOverrides() != null) {
                data.set("overrides", om.valueToTree(this.getOverrides()));
            }
            if (this.getProperties() != null) {
                data.set("properties", om.valueToTree(this.getProperties()));
            }
            if (this.getSchemaVersion() != null) {
                data.set("schemaVersion", om.valueToTree(this.getSchemaVersion()));
            }
            if (this.getSourceId() != null) {
                data.set("sourceId", om.valueToTree(this.getSourceId()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getVariants() != null) {
                data.set("variants", om.valueToTree(this.getVariants()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_amplifyuibuilder.CfnComponentProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnComponentProps.Jsii$Proxy that = (CfnComponentProps.Jsii$Proxy) o;

            if (this.appId != null ? !this.appId.equals(that.appId) : that.appId != null) return false;
            if (this.bindingProperties != null ? !this.bindingProperties.equals(that.bindingProperties) : that.bindingProperties != null) return false;
            if (this.children != null ? !this.children.equals(that.children) : that.children != null) return false;
            if (this.collectionProperties != null ? !this.collectionProperties.equals(that.collectionProperties) : that.collectionProperties != null) return false;
            if (this.componentType != null ? !this.componentType.equals(that.componentType) : that.componentType != null) return false;
            if (this.environmentName != null ? !this.environmentName.equals(that.environmentName) : that.environmentName != null) return false;
            if (this.events != null ? !this.events.equals(that.events) : that.events != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.overrides != null ? !this.overrides.equals(that.overrides) : that.overrides != null) return false;
            if (this.properties != null ? !this.properties.equals(that.properties) : that.properties != null) return false;
            if (this.schemaVersion != null ? !this.schemaVersion.equals(that.schemaVersion) : that.schemaVersion != null) return false;
            if (this.sourceId != null ? !this.sourceId.equals(that.sourceId) : that.sourceId != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.variants != null ? this.variants.equals(that.variants) : that.variants == null;
        }

        @Override
        public final int hashCode() {
            int result = this.appId != null ? this.appId.hashCode() : 0;
            result = 31 * result + (this.bindingProperties != null ? this.bindingProperties.hashCode() : 0);
            result = 31 * result + (this.children != null ? this.children.hashCode() : 0);
            result = 31 * result + (this.collectionProperties != null ? this.collectionProperties.hashCode() : 0);
            result = 31 * result + (this.componentType != null ? this.componentType.hashCode() : 0);
            result = 31 * result + (this.environmentName != null ? this.environmentName.hashCode() : 0);
            result = 31 * result + (this.events != null ? this.events.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.overrides != null ? this.overrides.hashCode() : 0);
            result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
            result = 31 * result + (this.schemaVersion != null ? this.schemaVersion.hashCode() : 0);
            result = 31 * result + (this.sourceId != null ? this.sourceId.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.variants != null ? this.variants.hashCode() : 0);
            return result;
        }
    }
}
