package software.amazon.awscdk.services.apigateway;

/**
 * $context variables that can be used to customize access log pattern.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * AccessLogFormat.custom(JSON.stringify(Map.of(
 *         "requestId", AccessLogField.contextRequestId(),
 *         "sourceIp", AccessLogField.contextIdentitySourceIp(),
 *         "method", AccessLogField.contextHttpMethod(),
 *         "userContext", Map.of(
 *                 "sub", AccessLogField.contextAuthorizerClaims("sub"),
 *                 "email", AccessLogField.contextAuthorizerClaims("email")))));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-08-19T23:46:28.405Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigateway.AccessLogField")
public class AccessLogField extends software.amazon.jsii.JsiiObject {

    protected AccessLogField(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AccessLogField(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public AccessLogField() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * (deprecated) The API callers AWS account ID.
     * <p>
     * @deprecated Use <code>contextCallerAccountId</code> or <code>contextOwnerAccountId</code> instead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public static @org.jetbrains.annotations.NotNull java.lang.String contextAccountId() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextAccountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier API Gateway assigns to your API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextApiId() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextApiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The error message returned from an authentication attempt.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextAuthenticateError() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextAuthenticateError", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The authentication latency in ms.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextAuthenticateLatency() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextAuthenticateLatency", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The status code returned from an authentication attempt.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextAuthenticateStatus() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextAuthenticateStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The authorization error message.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextAuthorizeError() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextAuthorizeError", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The authorization latency in ms.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextAuthorizeLatency() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextAuthorizeLatency", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The stringified value of the specified key-value pair of the <code>context</code> map returned from an API Gateway Lambda authorizer function.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-use-lambda-authorizer.html">https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-use-lambda-authorizer.html</a>
     * @param property key of the context map. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextAuthorizer(final @org.jetbrains.annotations.NotNull java.lang.String property) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextAuthorizer", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(property, "property is required") });
    }

    /**
     * A property of the claims returned from the Amazon Cognito user pool after the method caller is successfully authenticated.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-integrate-with-cognito.html">https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-integrate-with-cognito.html</a>
     * @param property A property key of the claims. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextAuthorizerClaims(final @org.jetbrains.annotations.NotNull java.lang.String property) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextAuthorizerClaims", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(property, "property is required") });
    }

    /**
     * The error message returned from an authorizer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextAuthorizerError() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextAuthorizerError", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The authorizer latency in ms.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextAuthorizerIntegrationLatency() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextAuthorizerIntegrationLatency", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The status code returned from a Lambda authorizer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextAuthorizerIntegrationStatus() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextAuthorizerIntegrationStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The authorizer latency in ms.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextAuthorizerLatency() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextAuthorizerLatency", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The principal user identification associated with the token sent by the client and returned from an API Gateway Lambda authorizer (formerly known as a custom authorizer).
     * <p>
     * @see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-use-lambda-authorizer.html">https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-use-lambda-authorizer.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextAuthorizerPrincipalId() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextAuthorizerPrincipalId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The AWS endpoint's request ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextAuthorizerRequestId() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextAuthorizerRequestId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The status code returned from an authorizer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextAuthorizerStatus() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextAuthorizerStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The status code returned from an authorization attempt.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextAuthorizeStatus() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextAuthorizeStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The AWS endpoint's request ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextAwsEndpointRequestId() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextAwsEndpointRequestId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The API callers AWS account ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextCallerAccountId() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextCallerAccountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The path for an API mapping that an incoming request matched.
     * <p>
     * Applicable when a client uses a custom domain name to access an API. For example if a client sends a request to
     * https://api.example.com/v1/orders/1234, and the request matches the API mapping with the path v1/orders, the value is v1/orders.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/en_jp/apigateway/latest/developerguide/rest-api-mappings.html">https://docs.aws.amazon.com/en_jp/apigateway/latest/developerguide/rest-api-mappings.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextCustomDomainBasePathMatched() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextCustomDomainBasePathMatched", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The full domain name used to invoke the API.
     * <p>
     * This should be the same as the incoming <code>Host</code> header.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextDomainName() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextDomainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The first label of the <code>$context.domainName</code>. This is often used as a caller/customer identifier.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextDomainPrefix() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextDomainPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A string containing an API Gateway error message.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextErrorMessage() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextErrorMessage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The quoted value of $context.error.message, namely "$context.error.message".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextErrorMessageString() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextErrorMessageString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A type of GatewayResponse.
     * <p>
     * This variable can only be used for simple variable substitution in a GatewayResponse body-mapping template,
     * which is not processed by the Velocity Template Language engine, and in access logging.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/customize-gateway-responses.html">https://docs.aws.amazon.com/apigateway/latest/developerguide/customize-gateway-responses.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextErrorResponseType() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextErrorResponseType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A string containing a detailed validation error message.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextErrorValidationErrorString() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextErrorValidationErrorString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The extended ID that API Gateway assigns to the API request, which contains more useful information for debugging/troubleshooting.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextExtendedRequestId() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextExtendedRequestId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The HTTP method used.
     * <p>
     * Valid values include: <code>DELETE</code>, <code>GET</code>, <code>HEAD</code>, <code>OPTIONS</code>, <code>PATCH</code>, <code>POST</code>, and <code>PUT</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextHttpMethod() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextHttpMethod", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The AWS account ID associated with the request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextIdentityAccountId() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextIdentityAccountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * For API methods that require an API key, this variable is the API key associated with the method request.
     * <p>
     * For methods that don't require an API key, this variable is
     * <p>
     * @see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-api-usage-plans.html">https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-api-usage-plans.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextIdentityApiKey() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextIdentityApiKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The API key ID associated with an API request that requires an API key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextIdentityApiKeyId() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextIdentityApiKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The principal identifier of the caller making the request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextIdentityCaller() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextIdentityCaller", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The distinguished name of the issuer of the certificate that a client presents.
     * <p>
     * Present when a client accesses an API by using a custom domain name that has mutual TLS enabled.
     * Present only in access logs if mutual TLS authentication fails.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextIdentityClientCertIssunerDN() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextIdentityClientCertIssunerDN", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The PEM-encoded client certificate that the client presented during mutual TLS authentication.
     * <p>
     * Present when a client accesses an API by using a custom domain name that has mutual TLS enabled.
     * Present only in access logs if mutual TLS authentication fails.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextIdentityClientCertPem() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextIdentityClientCertPem", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The serial number of the certificate.
     * <p>
     * Present when a client accesses an API by using a custom domain name that has mutual TLS enabled.
     * Present only in access logs if mutual TLS authentication fails.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextIdentityClientCertSerialNumber() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextIdentityClientCertSerialNumber", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The distinguished name of the subject of the certificate that a client presents.
     * <p>
     * Present when a client accesses an API by using a custom domain name that has mutual TLS enabled.
     * Present only in access logs if mutual TLS authentication fails.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextIdentityClientCertSubjectDN() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextIdentityClientCertSubjectDN", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The date after which the certificate is invalid.
     * <p>
     * Present when a client accesses an API by using a custom domain name that has mutual TLS enabled.
     * Present only in access logs if mutual TLS authentication fails.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextIdentityClientCertValidityNotAfter() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextIdentityClientCertValidityNotAfter", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The date before which the certificate is invalid.
     * <p>
     * Present when a client accesses an API by using a custom domain name that has mutual TLS enabled.
     * Present only in access logs if mutual TLS authentication fails.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextIdentityClientCertValidityNotBefore() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextIdentityClientCertValidityNotBefore", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Cognito authentication provider used by the caller making the request.
     * <p>
     * Available only if the request was signed with Amazon Cognito credentials.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-identity.html">https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-identity.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextIdentityCognitoAuthenticationProvider() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextIdentityCognitoAuthenticationProvider", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Cognito authentication type of the caller making the request.
     * <p>
     * Available only if the request was signed with Amazon Cognito credentials.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextIdentityCognitoAuthenticationType() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextIdentityCognitoAuthenticationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Cognito identity ID of the caller making the request.
     * <p>
     * Available only if the request was signed with Amazon Cognito credentials.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextIdentityCognitoIdentityId() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextIdentityCognitoIdentityId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Cognito identity pool ID of the caller making the request.
     * <p>
     * Available only if the request was signed with Amazon Cognito credentials.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextIdentityCognitoIdentityPoolId() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextIdentityCognitoIdentityPoolId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The AWS organization ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextIdentityPrincipalOrgId() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextIdentityPrincipalOrgId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The source IP address of the TCP connection making the request to API Gateway.
     * <p>
     * Warning: You should not trust this value if there is any chance that the <code>X-Forwarded-For</code> header could be forged.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextIdentitySourceIp() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextIdentitySourceIp", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The principal identifier of the user making the request.
     * <p>
     * Used in Lambda authorizers.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-lambda-authorizer-output.html">https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-lambda-authorizer-output.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextIdentityUser() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextIdentityUser", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The User-Agent header of the API caller.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextIdentityUserAgent() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextIdentityUserAgent", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the effective user identified after authentication.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_users.html">https://docs.aws.amazon.com/IAM/latest/UserGuide/id_users.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextIdentityUserArn() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextIdentityUserArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A string that contains an integration error message.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextIntegrationErrorMessage() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextIntegrationErrorMessage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The integration latency in ms.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextIntegrationLatency() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextIntegrationLatency", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * For Lambda proxy integration, this parameter represents the status code returned from AWS Lambda, not from the backend Lambda function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextIntegrationStatus() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextIntegrationStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The API owner's AWS account ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextOwnerAccountId() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextOwnerAccountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The request path.
     * <p>
     * For example, for a non-proxy request URL of https://{rest-api-id.execute-api.{region}.amazonaws.com/{stage}/root/child,
     * this value is /{stage}/root/child.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextPath() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The request protocol, for example, HTTP/1.1.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextProtocol() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextProtocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID that API Gateway assigns to the API request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextRequestId() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextRequestId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The request header override.
     * <p>
     * If this parameter is defined, it contains the headers to be used instead of the HTTP Headers that are defined in the Integration Request pane.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-override-request-response-parameters.html">https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-override-request-response-parameters.html</a>
     * @param headerName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextRequestOverrideHeader(final @org.jetbrains.annotations.NotNull java.lang.String headerName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextRequestOverrideHeader", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(headerName, "headerName is required") });
    }

    /**
     * The request path override.
     * <p>
     * If this parameter is defined,
     * it contains the request path to be used instead of the URL Path Parameters that are defined in the Integration Request pane.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-override-request-response-parameters.html">https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-override-request-response-parameters.html</a>
     * @param pathName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextRequestOverridePath(final @org.jetbrains.annotations.NotNull java.lang.String pathName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextRequestOverridePath", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(pathName, "pathName is required") });
    }

    /**
     * The request query string override.
     * <p>
     * If this parameter is defined, it contains the request query strings to be used instead
     * of the URL Query String Parameters that are defined in the Integration Request pane.
     * <p>
     * @param querystringName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextRequestOverrideQuerystring(final @org.jetbrains.annotations.NotNull java.lang.String querystringName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextRequestOverrideQuerystring", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(querystringName, "querystringName is required") });
    }

    /**
     * The CLF-formatted request time (dd/MMM/yyyy:HH:mm:ss +-hhmm).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextRequestTime() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextRequestTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Epoch-formatted request time.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextRequestTimeEpoch() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextRequestTimeEpoch", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier that API Gateway assigns to your resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextResourceId() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextResourceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The path to your resource.
     * <p>
     * For example, for the non-proxy request URI of <code>https://{rest-api-id.execute-api.{region}.amazonaws.com/{stage}/root/child</code>,
     * The $context.resourcePath value is <code>/root/child</code>.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-create-api-step-by-step.html">https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-create-api-step-by-step.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextResourcePath() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextResourcePath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The response latency in ms.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextResponseLatency() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextResponseLatency", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The response payload length.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextResponseLength() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextResponseLength", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The response header override.
     * <p>
     * If this parameter is defined, it contains the header to be returned instead of the Response header
     * that is defined as the Default mapping in the Integration Response pane.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-override-request-response-parameters.html">https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-override-request-response-parameters.html</a>
     * @param headerName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextResponseOverrideHeader(final @org.jetbrains.annotations.NotNull java.lang.String headerName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextResponseOverrideHeader", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(headerName, "headerName is required") });
    }

    /**
     * The response status code override.
     * <p>
     * If this parameter is defined, it contains the status code to be returned instead of the Method response status
     * that is defined as the Default mapping in the Integration Response pane.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-override-request-response-parameters.html">https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-override-request-response-parameters.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextResponseOverrideStatus() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextResponseOverrideStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The deployment stage of the API request (for example, <code>Beta</code> or <code>Prod</code>).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextStage() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextStage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The method response status.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextStatus() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The error message returned from AWS WAF.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextWafError() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextWafError", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The AWS WAF latency in ms.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextWafLatency() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextWafLatency", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The response received from AWS WAF: <code>WAF_ALLOW</code> or <code>WAF_BLOCK</code>.
     * <p>
     * Will not be set if the stage is not associated with a web ACL.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-control-access-aws-waf.html">https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-control-access-aws-waf.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextWafResponseCode() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextWafResponseCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The status code returned from AWS WAF.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextWafStatus() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextWafStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The complete ARN of the web ACL that is used to decide whether to allow or block the request.
     * <p>
     * Will not be set if the stage is not associated with a web ACL.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-control-access-aws-waf.html">https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-control-access-aws-waf.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextWebaclArn() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextWebaclArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The trace ID for the X-Ray trace.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-enabling-xray.html">https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-enabling-xray.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String contextXrayTraceId() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogField.class, "contextXrayTraceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
