package software.amazon.awscdk.services.apigatewayv2;

/**
 * Payload format version for lambda proxy integration.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigatewayv2.*;
 * PayloadFormatVersion payloadFormatVersion = PayloadFormatVersion.custom("version");
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html">https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-08-19T23:46:28.756Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.PayloadFormatVersion")
public class PayloadFormatVersion extends software.amazon.jsii.JsiiObject {

    protected PayloadFormatVersion(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected PayloadFormatVersion(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        VERSION_1_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigatewayv2.PayloadFormatVersion.class, "VERSION_1_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.PayloadFormatVersion.class));
        VERSION_2_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigatewayv2.PayloadFormatVersion.class, "VERSION_2_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.PayloadFormatVersion.class));
    }

    /**
     * A custom payload version.
     * <p>
     * Typically used if there is a version number that the CDK doesn't support yet
     * <p>
     * @param version This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.PayloadFormatVersion custom(final @org.jetbrains.annotations.NotNull java.lang.String version) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigatewayv2.PayloadFormatVersion.class, "custom", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.PayloadFormatVersion.class), new Object[] { java.util.Objects.requireNonNull(version, "version is required") });
    }

    /**
     * Version 1.0.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.apigatewayv2.PayloadFormatVersion VERSION_1_0;

    /**
     * Version 2.0.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.apigatewayv2.PayloadFormatVersion VERSION_2_0;

    /**
     * version as a string.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getVersion() {
        return software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
