package software.amazon.awscdk.services.appmesh;

/**
 * Used to generate header matching methods.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * VirtualRouter router;
 * VirtualNode node;
 * router.addRoute("route-http2", RouteBaseProps.builder()
 *         .routeSpec(RouteSpec.http2(HttpRouteSpecOptions.builder()
 *                 .weightedTargets(List.of(WeightedTarget.builder()
 *                         .virtualNode(node)
 *                         .build()))
 *                 .match(HttpRouteMatch.builder()
 *                         .path(HttpRoutePathMatch.exactly("/exact"))
 *                         .method(HttpRouteMethod.POST)
 *                         .protocol(HttpRouteProtocol.HTTPS)
 *                         .headers(List.of(HeaderMatch.valueIs("Content-Type", "application/json"), HeaderMatch.valueIsNot("Content-Type", "application/json")))
 *                         .queryParameters(List.of(QueryParameterMatch.valueIs("query-field", "value")))
 *                         .build())
 *                 .build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-08-19T23:46:29.230Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.HeaderMatch")
public abstract class HeaderMatch extends software.amazon.jsii.JsiiObject {

    protected HeaderMatch(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected HeaderMatch(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected HeaderMatch() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * The value of the header with the given name in the request must not end with the specified characters.
     * <p>
     * @param headerName the name of the header to match against. This parameter is required.
     * @param suffix The suffix to test against. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.HeaderMatch valueDoesNotEndWith(final @org.jetbrains.annotations.NotNull java.lang.String headerName, final @org.jetbrains.annotations.NotNull java.lang.String suffix) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.HeaderMatch.class, "valueDoesNotEndWith", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.HeaderMatch.class), new Object[] { java.util.Objects.requireNonNull(headerName, "headerName is required"), java.util.Objects.requireNonNull(suffix, "suffix is required") });
    }

    /**
     * The value of the header with the given name in the request must not include the specified characters.
     * <p>
     * @param headerName the name of the header to match against. This parameter is required.
     * @param regex The regex to test against. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.HeaderMatch valueDoesNotMatchRegex(final @org.jetbrains.annotations.NotNull java.lang.String headerName, final @org.jetbrains.annotations.NotNull java.lang.String regex) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.HeaderMatch.class, "valueDoesNotMatchRegex", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.HeaderMatch.class), new Object[] { java.util.Objects.requireNonNull(headerName, "headerName is required"), java.util.Objects.requireNonNull(regex, "regex is required") });
    }

    /**
     * The value of the header with the given name in the request must not start with the specified characters.
     * <p>
     * @param headerName the name of the header to match against. This parameter is required.
     * @param prefix The prefix to test against. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.HeaderMatch valueDoesNotStartWith(final @org.jetbrains.annotations.NotNull java.lang.String headerName, final @org.jetbrains.annotations.NotNull java.lang.String prefix) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.HeaderMatch.class, "valueDoesNotStartWith", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.HeaderMatch.class), new Object[] { java.util.Objects.requireNonNull(headerName, "headerName is required"), java.util.Objects.requireNonNull(prefix, "prefix is required") });
    }

    /**
     * The value of the header with the given name in the request must end with the specified characters.
     * <p>
     * @param headerName the name of the header to match against. This parameter is required.
     * @param suffix The suffix to test against. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.HeaderMatch valueEndsWith(final @org.jetbrains.annotations.NotNull java.lang.String headerName, final @org.jetbrains.annotations.NotNull java.lang.String suffix) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.HeaderMatch.class, "valueEndsWith", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.HeaderMatch.class), new Object[] { java.util.Objects.requireNonNull(headerName, "headerName is required"), java.util.Objects.requireNonNull(suffix, "suffix is required") });
    }

    /**
     * The value of the header with the given name in the request must match the specified value exactly.
     * <p>
     * @param headerName the name of the header to match against. This parameter is required.
     * @param headerValue The exact value to test against. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.HeaderMatch valueIs(final @org.jetbrains.annotations.NotNull java.lang.String headerName, final @org.jetbrains.annotations.NotNull java.lang.String headerValue) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.HeaderMatch.class, "valueIs", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.HeaderMatch.class), new Object[] { java.util.Objects.requireNonNull(headerName, "headerName is required"), java.util.Objects.requireNonNull(headerValue, "headerValue is required") });
    }

    /**
     * The value of the header with the given name in the request must not match the specified value exactly.
     * <p>
     * @param headerName the name of the header to match against. This parameter is required.
     * @param headerValue The exact value to test against. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.HeaderMatch valueIsNot(final @org.jetbrains.annotations.NotNull java.lang.String headerName, final @org.jetbrains.annotations.NotNull java.lang.String headerValue) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.HeaderMatch.class, "valueIsNot", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.HeaderMatch.class), new Object[] { java.util.Objects.requireNonNull(headerName, "headerName is required"), java.util.Objects.requireNonNull(headerValue, "headerValue is required") });
    }

    /**
     * The value of the header with the given name in the request must include the specified characters.
     * <p>
     * @param headerName the name of the header to match against. This parameter is required.
     * @param regex The regex to test against. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.HeaderMatch valueMatchesRegex(final @org.jetbrains.annotations.NotNull java.lang.String headerName, final @org.jetbrains.annotations.NotNull java.lang.String regex) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.HeaderMatch.class, "valueMatchesRegex", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.HeaderMatch.class), new Object[] { java.util.Objects.requireNonNull(headerName, "headerName is required"), java.util.Objects.requireNonNull(regex, "regex is required") });
    }

    /**
     * The value of the header with the given name in the request must be in a range of values.
     * <p>
     * @param headerName the name of the header to match against. This parameter is required.
     * @param start Match on values starting at and including this value. This parameter is required.
     * @param end Match on values up to but not including this value. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.HeaderMatch valuesIsInRange(final @org.jetbrains.annotations.NotNull java.lang.String headerName, final @org.jetbrains.annotations.NotNull java.lang.Number start, final @org.jetbrains.annotations.NotNull java.lang.Number end) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.HeaderMatch.class, "valuesIsInRange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.HeaderMatch.class), new Object[] { java.util.Objects.requireNonNull(headerName, "headerName is required"), java.util.Objects.requireNonNull(start, "start is required"), java.util.Objects.requireNonNull(end, "end is required") });
    }

    /**
     * The value of the header with the given name in the request must not be in a range of values.
     * <p>
     * @param headerName the name of the header to match against. This parameter is required.
     * @param start Match on values starting at and including this value. This parameter is required.
     * @param end Match on values up to but not including this value. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.HeaderMatch valuesIsNotInRange(final @org.jetbrains.annotations.NotNull java.lang.String headerName, final @org.jetbrains.annotations.NotNull java.lang.Number start, final @org.jetbrains.annotations.NotNull java.lang.Number end) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.HeaderMatch.class, "valuesIsNotInRange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.HeaderMatch.class), new Object[] { java.util.Objects.requireNonNull(headerName, "headerName is required"), java.util.Objects.requireNonNull(start, "start is required"), java.util.Objects.requireNonNull(end, "end is required") });
    }

    /**
     * The value of the header with the given name in the request must start with the specified characters.
     * <p>
     * @param headerName the name of the header to match against. This parameter is required.
     * @param prefix The prefix to test against. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.HeaderMatch valueStartsWith(final @org.jetbrains.annotations.NotNull java.lang.String headerName, final @org.jetbrains.annotations.NotNull java.lang.String prefix) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.HeaderMatch.class, "valueStartsWith", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.HeaderMatch.class), new Object[] { java.util.Objects.requireNonNull(headerName, "headerName is required"), java.util.Objects.requireNonNull(prefix, "prefix is required") });
    }

    /**
     * Returns the header match configuration.
     * <p>
     * @param scope This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.HeaderMatchConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.appmesh.HeaderMatch {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * Returns the header match configuration.
         * <p>
         * @param scope This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.HeaderMatchConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope) {
            return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.HeaderMatchConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
        }
    }
}
