package software.amazon.awscdk.services.b2bi;

/**
 * Properties for defining a <code>CfnTransformer</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.b2bi.*;
 * CfnTransformerProps cfnTransformerProps = CfnTransformerProps.builder()
 *         .ediType(EdiTypeProperty.builder()
 *                 .x12Details(X12DetailsProperty.builder()
 *                         .transactionSet("transactionSet")
 *                         .version("version")
 *                         .build())
 *                 .build())
 *         .fileFormat("fileFormat")
 *         .mappingTemplate("mappingTemplate")
 *         .name("name")
 *         .status("status")
 *         // the properties below are optional
 *         .sampleDocument("sampleDocument")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-08-19T23:46:29.779Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_b2bi.CfnTransformerProps")
@software.amazon.jsii.Jsii.Proxy(CfnTransformerProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnTransformerProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Returns the details for the EDI standard that is being used for the transformer.
     * <p>
     * Currently, only X12 is supported. X12 is a set of standards and corresponding messages that define specific business documents.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-editype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-editype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getEdiType();

    /**
     * Returns that the currently supported file formats for EDI transformations are <code>JSON</code> and <code>XML</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-fileformat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-fileformat</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFileFormat();

    /**
     * Returns a sample EDI document that is used by a transformer as a guide for processing the EDI data.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-mappingtemplate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-mappingtemplate</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMappingTemplate();

    /**
     * Returns the descriptive name for the transformer.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * Returns the state of the newly created transformer.
     * <p>
     * The transformer can be either <code>active</code> or <code>inactive</code> . For the transformer to be used in a capability, its status must <code>active</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-status">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-status</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStatus();

    /**
     * Returns a sample EDI document that is used by a transformer as a guide for processing the EDI data.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-sampledocument">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-sampledocument</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSampleDocument() {
        return null;
    }

    /**
     * A key-value pair for a specific transformer.
     * <p>
     * Tags are metadata that you can use to search for and group capabilities for various purposes.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnTransformerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnTransformerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnTransformerProps> {
        java.lang.Object ediType;
        java.lang.String fileFormat;
        java.lang.String mappingTemplate;
        java.lang.String name;
        java.lang.String status;
        java.lang.String sampleDocument;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnTransformerProps#getEdiType}
         * @param ediType Returns the details for the EDI standard that is being used for the transformer. This parameter is required.
         *                Currently, only X12 is supported. X12 is a set of standards and corresponding messages that define specific business documents.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ediType(software.amazon.awscdk.IResolvable ediType) {
            this.ediType = ediType;
            return this;
        }

        /**
         * Sets the value of {@link CfnTransformerProps#getEdiType}
         * @param ediType Returns the details for the EDI standard that is being used for the transformer. This parameter is required.
         *                Currently, only X12 is supported. X12 is a set of standards and corresponding messages that define specific business documents.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ediType(software.amazon.awscdk.services.b2bi.CfnTransformer.EdiTypeProperty ediType) {
            this.ediType = ediType;
            return this;
        }

        /**
         * Sets the value of {@link CfnTransformerProps#getFileFormat}
         * @param fileFormat Returns that the currently supported file formats for EDI transformations are <code>JSON</code> and <code>XML</code> . This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileFormat(java.lang.String fileFormat) {
            this.fileFormat = fileFormat;
            return this;
        }

        /**
         * Sets the value of {@link CfnTransformerProps#getMappingTemplate}
         * @param mappingTemplate Returns a sample EDI document that is used by a transformer as a guide for processing the EDI data. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mappingTemplate(java.lang.String mappingTemplate) {
            this.mappingTemplate = mappingTemplate;
            return this;
        }

        /**
         * Sets the value of {@link CfnTransformerProps#getName}
         * @param name Returns the descriptive name for the transformer. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnTransformerProps#getStatus}
         * @param status Returns the state of the newly created transformer. This parameter is required.
         *               The transformer can be either <code>active</code> or <code>inactive</code> . For the transformer to be used in a capability, its status must <code>active</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder status(java.lang.String status) {
            this.status = status;
            return this;
        }

        /**
         * Sets the value of {@link CfnTransformerProps#getSampleDocument}
         * @param sampleDocument Returns a sample EDI document that is used by a transformer as a guide for processing the EDI data.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sampleDocument(java.lang.String sampleDocument) {
            this.sampleDocument = sampleDocument;
            return this;
        }

        /**
         * Sets the value of {@link CfnTransformerProps#getTags}
         * @param tags A key-value pair for a specific transformer.
         *             Tags are metadata that you can use to search for and group capabilities for various purposes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnTransformerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnTransformerProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnTransformerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnTransformerProps {
        private final java.lang.Object ediType;
        private final java.lang.String fileFormat;
        private final java.lang.String mappingTemplate;
        private final java.lang.String name;
        private final java.lang.String status;
        private final java.lang.String sampleDocument;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.ediType = software.amazon.jsii.Kernel.get(this, "ediType", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.fileFormat = software.amazon.jsii.Kernel.get(this, "fileFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.mappingTemplate = software.amazon.jsii.Kernel.get(this, "mappingTemplate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sampleDocument = software.amazon.jsii.Kernel.get(this, "sampleDocument", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.ediType = java.util.Objects.requireNonNull(builder.ediType, "ediType is required");
            this.fileFormat = java.util.Objects.requireNonNull(builder.fileFormat, "fileFormat is required");
            this.mappingTemplate = java.util.Objects.requireNonNull(builder.mappingTemplate, "mappingTemplate is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.status = java.util.Objects.requireNonNull(builder.status, "status is required");
            this.sampleDocument = builder.sampleDocument;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getEdiType() {
            return this.ediType;
        }

        @Override
        public final java.lang.String getFileFormat() {
            return this.fileFormat;
        }

        @Override
        public final java.lang.String getMappingTemplate() {
            return this.mappingTemplate;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getStatus() {
            return this.status;
        }

        @Override
        public final java.lang.String getSampleDocument() {
            return this.sampleDocument;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("ediType", om.valueToTree(this.getEdiType()));
            data.set("fileFormat", om.valueToTree(this.getFileFormat()));
            data.set("mappingTemplate", om.valueToTree(this.getMappingTemplate()));
            data.set("name", om.valueToTree(this.getName()));
            data.set("status", om.valueToTree(this.getStatus()));
            if (this.getSampleDocument() != null) {
                data.set("sampleDocument", om.valueToTree(this.getSampleDocument()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_b2bi.CfnTransformerProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnTransformerProps.Jsii$Proxy that = (CfnTransformerProps.Jsii$Proxy) o;

            if (!ediType.equals(that.ediType)) return false;
            if (!fileFormat.equals(that.fileFormat)) return false;
            if (!mappingTemplate.equals(that.mappingTemplate)) return false;
            if (!name.equals(that.name)) return false;
            if (!status.equals(that.status)) return false;
            if (this.sampleDocument != null ? !this.sampleDocument.equals(that.sampleDocument) : that.sampleDocument != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.ediType.hashCode();
            result = 31 * result + (this.fileFormat.hashCode());
            result = 31 * result + (this.mappingTemplate.hashCode());
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.status.hashCode());
            result = 31 * result + (this.sampleDocument != null ? this.sampleDocument.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
