package software.amazon.awscdk.services.backup;

/**
 * A backup plan rule.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * BackupPlan plan;
 * plan.addRule(BackupPlanRule.Builder.create()
 *         .enableContinuousBackup(true)
 *         .deleteAfter(Duration.days(14))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-08-19T23:46:29.785Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_backup.BackupPlanRule")
public class BackupPlanRule extends software.amazon.jsii.JsiiObject {

    protected BackupPlanRule(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected BackupPlanRule(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props Rule properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public BackupPlanRule(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.backup.BackupPlanRuleProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Daily with 35 days retention.
     * <p>
     * @param backupVault
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.backup.BackupPlanRule daily(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.backup.IBackupVault backupVault) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.backup.BackupPlanRule.class, "daily", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.backup.BackupPlanRule.class), new Object[] { backupVault });
    }

    /**
     * Daily with 35 days retention.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.backup.BackupPlanRule daily() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.backup.BackupPlanRule.class, "daily", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.backup.BackupPlanRule.class));
    }

    /**
     * Monthly 1 year retention, move to cold storage after 1 month.
     * <p>
     * @param backupVault
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.backup.BackupPlanRule monthly1Year(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.backup.IBackupVault backupVault) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.backup.BackupPlanRule.class, "monthly1Year", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.backup.BackupPlanRule.class), new Object[] { backupVault });
    }

    /**
     * Monthly 1 year retention, move to cold storage after 1 month.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.backup.BackupPlanRule monthly1Year() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.backup.BackupPlanRule.class, "monthly1Year", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.backup.BackupPlanRule.class));
    }

    /**
     * Monthly 5 year retention, move to cold storage after 3 months.
     * <p>
     * @param backupVault
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.backup.BackupPlanRule monthly5Year(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.backup.IBackupVault backupVault) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.backup.BackupPlanRule.class, "monthly5Year", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.backup.BackupPlanRule.class), new Object[] { backupVault });
    }

    /**
     * Monthly 5 year retention, move to cold storage after 3 months.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.backup.BackupPlanRule monthly5Year() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.backup.BackupPlanRule.class, "monthly5Year", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.backup.BackupPlanRule.class));
    }

    /**
     * Monthly 7 year retention, move to cold storage after 3 months.
     * <p>
     * @param backupVault
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.backup.BackupPlanRule monthly7Year(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.backup.IBackupVault backupVault) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.backup.BackupPlanRule.class, "monthly7Year", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.backup.BackupPlanRule.class), new Object[] { backupVault });
    }

    /**
     * Monthly 7 year retention, move to cold storage after 3 months.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.backup.BackupPlanRule monthly7Year() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.backup.BackupPlanRule.class, "monthly7Year", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.backup.BackupPlanRule.class));
    }

    /**
     * Weekly with 3 months retention.
     * <p>
     * @param backupVault
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.backup.BackupPlanRule weekly(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.backup.IBackupVault backupVault) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.backup.BackupPlanRule.class, "weekly", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.backup.BackupPlanRule.class), new Object[] { backupVault });
    }

    /**
     * Weekly with 3 months retention.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.backup.BackupPlanRule weekly() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.backup.BackupPlanRule.class, "weekly", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.backup.BackupPlanRule.class));
    }

    /**
     * Properties of BackupPlanRule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.backup.BackupPlanRuleProps getProps() {
        return software.amazon.jsii.Kernel.get(this, "props", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.backup.BackupPlanRuleProps.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.backup.BackupPlanRule}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.backup.BackupPlanRule> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.backup.BackupPlanRuleProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.backup.BackupPlanRuleProps.Builder();
        }

        /**
         * The backup vault where backups are.
         * <p>
         * Default: - use the vault defined at the plan level. If not defined a new
         * common vault for the plan will be created
         * <p>
         * @return {@code this}
         * @param backupVault The backup vault where backups are. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupVault(final software.amazon.awscdk.services.backup.IBackupVault backupVault) {
            this.props.backupVault(backupVault);
            return this;
        }

        /**
         * The duration after a backup job is successfully started before it must be completed or it is canceled by AWS Backup.
         * <p>
         * Default: - 7 days
         * <p>
         * @return {@code this}
         * @param completionWindow The duration after a backup job is successfully started before it must be completed or it is canceled by AWS Backup. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder completionWindow(final software.amazon.awscdk.Duration completionWindow) {
            this.props.completionWindow(completionWindow);
            return this;
        }

        /**
         * Copy operations to perform on recovery points created by this rule.
         * <p>
         * Default: - no copy actions
         * <p>
         * @return {@code this}
         * @param copyActions Copy operations to perform on recovery points created by this rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder copyActions(final java.util.List<? extends software.amazon.awscdk.services.backup.BackupPlanCopyActionProps> copyActions) {
            this.props.copyActions(copyActions);
            return this;
        }

        /**
         * Specifies the duration after creation that a recovery point is deleted.
         * <p>
         * Must be greater than <code>moveToColdStorageAfter</code>.
         * <p>
         * Default: - recovery point is never deleted
         * <p>
         * @return {@code this}
         * @param deleteAfter Specifies the duration after creation that a recovery point is deleted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deleteAfter(final software.amazon.awscdk.Duration deleteAfter) {
            this.props.deleteAfter(deleteAfter);
            return this;
        }

        /**
         * Enables continuous backup and point-in-time restores (PITR).
         * <p>
         * Property <code>deleteAfter</code> defines the retention period for the backup. It is mandatory if PITR is enabled.
         * If no value is specified, the retention period is set to 35 days which is the maximum retention period supported by PITR.
         * <p>
         * Property <code>moveToColdStorageAfter</code> must not be specified because PITR does not support this option.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param enableContinuousBackup Enables continuous backup and point-in-time restores (PITR). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableContinuousBackup(final java.lang.Boolean enableContinuousBackup) {
            this.props.enableContinuousBackup(enableContinuousBackup);
            return this;
        }

        /**
         * Specifies the duration after creation that a recovery point is moved to cold storage.
         * <p>
         * Default: - recovery point is never moved to cold storage
         * <p>
         * @return {@code this}
         * @param moveToColdStorageAfter Specifies the duration after creation that a recovery point is moved to cold storage. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder moveToColdStorageAfter(final software.amazon.awscdk.Duration moveToColdStorageAfter) {
            this.props.moveToColdStorageAfter(moveToColdStorageAfter);
            return this;
        }

        /**
         * To help organize your resources, you can assign your own metadata to the resources that you create.
         * <p>
         * Each tag is a key-value pair.
         * <p>
         * Default: - no recovery point tags.
         * <p>
         * @return {@code this}
         * @param recoveryPointTags To help organize your resources, you can assign your own metadata to the resources that you create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recoveryPointTags(final java.util.Map<java.lang.String, java.lang.String> recoveryPointTags) {
            this.props.recoveryPointTags(recoveryPointTags);
            return this;
        }

        /**
         * A display name for the backup rule.
         * <p>
         * Default: - a CDK generated name
         * <p>
         * @return {@code this}
         * @param ruleName A display name for the backup rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleName(final java.lang.String ruleName) {
            this.props.ruleName(ruleName);
            return this;
        }

        /**
         * A CRON expression specifying when AWS Backup initiates a backup job.
         * <p>
         * Default: - no schedule
         * <p>
         * @return {@code this}
         * @param scheduleExpression A CRON expression specifying when AWS Backup initiates a backup job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduleExpression(final software.amazon.awscdk.services.events.Schedule scheduleExpression) {
            this.props.scheduleExpression(scheduleExpression);
            return this;
        }

        /**
         * The duration after a backup is scheduled before a job is canceled if it doesn't start successfully.
         * <p>
         * Default: - 8 hours
         * <p>
         * @return {@code this}
         * @param startWindow The duration after a backup is scheduled before a job is canceled if it doesn't start successfully. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder startWindow(final software.amazon.awscdk.Duration startWindow) {
            this.props.startWindow(startWindow);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.backup.BackupPlanRule}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.backup.BackupPlanRule build() {
            return new software.amazon.awscdk.services.backup.BackupPlanRule(
                this.props.build()
            );
        }
    }
}
