package software.amazon.awscdk.services.batch;

/**
 * Determines when the image is pulled from the registry to launch a container.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-08-19T23:46:30.015Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.ImagePullPolicy")
public enum ImagePullPolicy {
    /**
     * Every time the kubelet launches a container, the kubelet queries the container image registry to resolve the name to an image digest.
     * <p>
     * If the kubelet has a container image with that exact digest cached locally,
     * the kubelet uses its cached image; otherwise, the kubelet pulls the image with the resolved digest,
     * and uses that image to launch the container.
     * <p>
     * @see <a href="https://docs.docker.com/engine/reference/commandline/pull/#pull-an-image-by-digest-immutable-identifier">https://docs.docker.com/engine/reference/commandline/pull/#pull-an-image-by-digest-immutable-identifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ALWAYS,
    /**
     * The image is pulled only if it is not already present locally.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    IF_NOT_PRESENT,
    /**
     * The kubelet does not try fetching the image.
     * <p>
     * If the image is somehow already present locally,
     * the kubelet attempts to start the container; otherwise, startup fails.
     * See pre-pulled images for more details.
     * <p>
     * @see <a href="https://kubernetes.io/docs/concepts/containers/images/#pre-pulled-images">https://kubernetes.io/docs/concepts/containers/images/#pre-pulled-images</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NEVER,
}
